// third_party/blink/public/mojom/widget/visual_properties.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/widget/visual_properties.mojom-params-data.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/widget/visual_properties.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
VisualProperties::VisualProperties()
    : screen_info(),
      auto_resize_enabled(false),
      min_size_for_auto_resize(),
      max_size_for_auto_resize(),
      new_size(),
      visible_viewport_size(),
      compositor_viewport_pixel_rect(),
      browser_controls_params(),
      scroll_focused_node_into_view(),
      local_surface_id(),
      is_fullscreen_granted(),
      display_mode(::blink::mojom::DisplayMode::kUndefined),
      capture_sequence_number(),
      zoom_level(),
      page_scale_factor(1),
      root_widget_window_segments(),
      is_pinch_gesture_active() {}

VisualProperties::VisualProperties(
    const ::blink::ScreenInfo& screen_info_in,
    bool auto_resize_enabled_in,
    const ::gfx::Size& min_size_for_auto_resize_in,
    const ::gfx::Size& max_size_for_auto_resize_in,
    const ::gfx::Size& new_size_in,
    const ::gfx::Size& visible_viewport_size_in,
    const ::gfx::Rect& compositor_viewport_pixel_rect_in,
    const base::Optional<::cc::BrowserControlsParams>& browser_controls_params_in,
    bool scroll_focused_node_into_view_in,
    const base::Optional<::viz::LocalSurfaceId>& local_surface_id_in,
    bool is_fullscreen_granted_in,
    ::blink::mojom::DisplayMode display_mode_in,
    uint32_t capture_sequence_number_in,
    double zoom_level_in,
    float page_scale_factor_in,
    std::vector<::gfx::Rect> root_widget_window_segments_in,
    bool is_pinch_gesture_active_in)
    : screen_info(std::move(screen_info_in)),
      auto_resize_enabled(std::move(auto_resize_enabled_in)),
      min_size_for_auto_resize(std::move(min_size_for_auto_resize_in)),
      max_size_for_auto_resize(std::move(max_size_for_auto_resize_in)),
      new_size(std::move(new_size_in)),
      visible_viewport_size(std::move(visible_viewport_size_in)),
      compositor_viewport_pixel_rect(std::move(compositor_viewport_pixel_rect_in)),
      browser_controls_params(std::move(browser_controls_params_in)),
      scroll_focused_node_into_view(std::move(scroll_focused_node_into_view_in)),
      local_surface_id(std::move(local_surface_id_in)),
      is_fullscreen_granted(std::move(is_fullscreen_granted_in)),
      display_mode(std::move(display_mode_in)),
      capture_sequence_number(std::move(capture_sequence_number_in)),
      zoom_level(std::move(zoom_level_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      root_widget_window_segments(std::move(root_widget_window_segments_in)),
      is_pinch_gesture_active(std::move(is_pinch_gesture_active_in)) {}

VisualProperties::~VisualProperties() = default;

void VisualProperties::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("screen_info", base::trace_event::ValueToString(this->screen_info, "<value of type const ::blink::ScreenInfo&>"));
  value->SetBoolean("auto_resize_enabled", this->auto_resize_enabled);
  value->SetString("min_size_for_auto_resize", base::trace_event::ValueToString(this->min_size_for_auto_resize, "<value of type const ::gfx::Size&>"));
  value->SetString("max_size_for_auto_resize", base::trace_event::ValueToString(this->max_size_for_auto_resize, "<value of type const ::gfx::Size&>"));
  value->SetString("new_size", base::trace_event::ValueToString(this->new_size, "<value of type const ::gfx::Size&>"));
  value->SetString("visible_viewport_size", base::trace_event::ValueToString(this->visible_viewport_size, "<value of type const ::gfx::Size&>"));
  value->SetString("compositor_viewport_pixel_rect", base::trace_event::ValueToString(this->compositor_viewport_pixel_rect, "<value of type const ::gfx::Rect&>"));
  value->SetString("browser_controls_params", base::trace_event::ValueToString(this->browser_controls_params, "<value of type const base::Optional<::cc::BrowserControlsParams>&>"));
  value->SetBoolean("scroll_focused_node_into_view", this->scroll_focused_node_into_view);
  value->SetString("local_surface_id", base::trace_event::ValueToString(this->local_surface_id, "<value of type const base::Optional<::viz::LocalSurfaceId>&>"));
  value->SetBoolean("is_fullscreen_granted", this->is_fullscreen_granted);
  value->SetString("display_mode", base::trace_event::ValueToString(this->display_mode));
  value->SetString("capture_sequence_number", base::NumberToString(this->capture_sequence_number));
  value->SetDouble("zoom_level", this->zoom_level);
  value->SetDouble("page_scale_factor", this->page_scale_factor);
  value->BeginArray("root_widget_window_segments");
  for (const auto& item0 : this->root_widget_window_segments) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::gfx::Rect&>"));
  }
  value->EndArray();
  value->SetBoolean("is_pinch_gesture_active", this->is_pinch_gesture_active);
}

bool VisualProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::VisualProperties::DataView, ::blink::mojom::VisualPropertiesPtr>::Read(
    ::blink::mojom::VisualProperties::DataView input,
    ::blink::mojom::VisualPropertiesPtr* output) {
  bool success = true;
  ::blink::mojom::VisualPropertiesPtr result(::blink::mojom::VisualProperties::New());
  
      if (success && !input.ReadScreenInfo(&result->screen_info))
        success = false;
      if (success)
        result->auto_resize_enabled = input.auto_resize_enabled();
      if (success && !input.ReadMinSizeForAutoResize(&result->min_size_for_auto_resize))
        success = false;
      if (success && !input.ReadMaxSizeForAutoResize(&result->max_size_for_auto_resize))
        success = false;
      if (success && !input.ReadNewSize(&result->new_size))
        success = false;
      if (success && !input.ReadVisibleViewportSize(&result->visible_viewport_size))
        success = false;
      if (success && !input.ReadCompositorViewportPixelRect(&result->compositor_viewport_pixel_rect))
        success = false;
      if (success && !input.ReadBrowserControlsParams(&result->browser_controls_params))
        success = false;
      if (success)
        result->scroll_focused_node_into_view = input.scroll_focused_node_into_view();
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
      if (success)
        result->is_fullscreen_granted = input.is_fullscreen_granted();
      if (success && !input.ReadDisplayMode(&result->display_mode))
        success = false;
      if (success)
        result->capture_sequence_number = input.capture_sequence_number();
      if (success)
        result->zoom_level = input.zoom_level();
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success && !input.ReadRootWidgetWindowSegments(&result->root_widget_window_segments))
        success = false;
      if (success)
        result->is_pinch_gesture_active = input.is_pinch_gesture_active();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif