// services/network/public/mojom/url_loader.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-blink-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/client_security_state.mojom-blink.h"
#include "services/network/public/mojom/cors.mojom-blink-forward.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-blink.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-blink.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-blink.h"
#include "services/network/public/mojom/fetch_api.mojom-blink-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom-blink.h"
#include "services/network/public/mojom/isolation_info.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink-forward.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink.h"
#include "services/network/public/mojom/trust_tokens.mojom-blink.h"
#include "services/network/public/mojom/url_response_head.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/network_ipc_param_traits.h"
#include "services/network/public/cpp/network_isolation_key_mojom_traits.h"
#include "services/network/public/cpp/url_request_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"




namespace WTF {
struct network_mojom_internal_RequestPriority_DataHashFn {
  static unsigned GetHash(const ::network::mojom::RequestPriority& value) {
    using utype = std::underlying_type<::network::mojom::RequestPriority>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::RequestPriority& left, const ::network::mojom::RequestPriority& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::RequestPriority>
    : public GenericHashTraits<::network::mojom::RequestPriority> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::RequestPriority& value) {
    return value == static_cast<::network::mojom::RequestPriority>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::RequestPriority& slot, bool) {
    slot = static_cast<::network::mojom::RequestPriority>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::RequestPriority& value) {
    return value == static_cast<::network::mojom::RequestPriority>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct network_mojom_internal_URLRequestReferrerPolicy_DataHashFn {
  static unsigned GetHash(const ::network::mojom::URLRequestReferrerPolicy& value) {
    using utype = std::underlying_type<::network::mojom::URLRequestReferrerPolicy>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::URLRequestReferrerPolicy& left, const ::network::mojom::URLRequestReferrerPolicy& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::URLRequestReferrerPolicy>
    : public GenericHashTraits<::network::mojom::URLRequestReferrerPolicy> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::URLRequestReferrerPolicy& value) {
    return value == static_cast<::network::mojom::URLRequestReferrerPolicy>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::URLRequestReferrerPolicy& slot, bool) {
    slot = static_cast<::network::mojom::URLRequestReferrerPolicy>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::URLRequestReferrerPolicy& value) {
    return value == static_cast<::network::mojom::URLRequestReferrerPolicy>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct network_mojom_internal_DataElementType_DataHashFn {
  static unsigned GetHash(const ::network::mojom::DataElementType& value) {
    using utype = std::underlying_type<::network::mojom::DataElementType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::DataElementType& left, const ::network::mojom::DataElementType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::DataElementType>
    : public GenericHashTraits<::network::mojom::DataElementType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::DataElementType& value) {
    return value == static_cast<::network::mojom::DataElementType>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::DataElementType& slot, bool) {
    slot = static_cast<::network::mojom::DataElementType>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::DataElementType& value) {
    return value == static_cast<::network::mojom::DataElementType>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {
namespace blink {

class URLLoaderProxy;

template <typename ImplRefTraits>
class URLLoaderStub;

class URLLoaderRequestValidator;


class BLINK_PLATFORM_EXPORT URLLoader
    : public URLLoaderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = URLLoaderInterfaceBase;
  using Proxy_ = URLLoaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFollowRedirectMinVersion = 0,
    kSetPriorityMinVersion = 0,
    kPauseReadingBodyFromNetMinVersion = 0,
    kResumeReadingBodyFromNetMinVersion = 0,
  };
  
  static constexpr uint32_t kClientDisconnectReason = 1U;
  virtual ~URLLoader() {}

  
  virtual void FollowRedirect(const WTF::Vector<WTF::String>& removed_headers, const ::net::HttpRequestHeaders& modified_headers, const ::net::HttpRequestHeaders& modified_cors_exempt_headers, const base::Optional<::blink::KURL>& new_url) = 0;

  
  virtual void SetPriority(::net::RequestPriority priority, int32_t intra_priority_value) = 0;

  
  virtual void PauseReadingBodyFromNet() = 0;

  
  virtual void ResumeReadingBodyFromNet() = 0;
};

class URLLoaderClientProxy;

template <typename ImplRefTraits>
class URLLoaderClientStub;

class URLLoaderClientRequestValidator;
class URLLoaderClientResponseValidator;


class BLINK_PLATFORM_EXPORT URLLoaderClient
    : public URLLoaderClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = URLLoaderClientInterfaceBase;
  using Proxy_ = URLLoaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderClientStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderClientRequestValidator;
  using ResponseValidator_ = URLLoaderClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnReceiveResponseMinVersion = 0,
    kOnReceiveRedirectMinVersion = 0,
    kOnUploadProgressMinVersion = 0,
    kOnReceiveCachedMetadataMinVersion = 0,
    kOnTransferSizeUpdatedMinVersion = 0,
    kOnStartLoadingResponseBodyMinVersion = 0,
    kOnCompleteMinVersion = 0,
  };
  virtual ~URLLoaderClient() {}

  
  virtual void OnReceiveResponse(::network::mojom::blink::URLResponseHeadPtr head) = 0;

  
  virtual void OnReceiveRedirect(URLRequestRedirectInfoPtr redirect_info, ::network::mojom::blink::URLResponseHeadPtr head) = 0;


  using OnUploadProgressCallback = base::OnceCallback<void()>;
  
  virtual void OnUploadProgress(int64_t current_position, int64_t total_size, OnUploadProgressCallback callback) = 0;

  
  virtual void OnReceiveCachedMetadata(::mojo_base::BigBuffer data) = 0;

  
  virtual void OnTransferSizeUpdated(int32_t transfer_size_diff) = 0;

  
  virtual void OnStartLoadingResponseBody(::mojo::ScopedDataPipeConsumerHandle body) = 0;

  
  virtual void OnComplete(URLLoaderCompletionStatusPtr status) = 0;
};



class BLINK_PLATFORM_EXPORT URLLoaderProxy
    : public URLLoader {
 public:
  using InterfaceType = URLLoader;

  explicit URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FollowRedirect(const WTF::Vector<WTF::String>& removed_headers, const ::net::HttpRequestHeaders& modified_headers, const ::net::HttpRequestHeaders& modified_cors_exempt_headers, const base::Optional<::blink::KURL>& new_url) final;
  
  void SetPriority(::net::RequestPriority priority, int32_t intra_priority_value) final;
  
  void PauseReadingBodyFromNet() final;
  
  void ResumeReadingBodyFromNet() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT URLLoaderClientProxy
    : public URLLoaderClient {
 public:
  using InterfaceType = URLLoaderClient;

  explicit URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReceiveResponse(::network::mojom::blink::URLResponseHeadPtr head) final;
  
  void OnReceiveRedirect(URLRequestRedirectInfoPtr redirect_info, ::network::mojom::blink::URLResponseHeadPtr head) final;
  
  void OnUploadProgress(int64_t current_position, int64_t total_size, OnUploadProgressCallback callback) final;
  
  void OnReceiveCachedMetadata(::mojo_base::BigBuffer data) final;
  
  void OnTransferSizeUpdated(int32_t transfer_size_diff) final;
  
  void OnStartLoadingResponseBody(::mojo::ScopedDataPipeConsumerHandle body) final;
  
  void OnComplete(URLLoaderCompletionStatusPtr status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT URLLoaderStubDispatch {
 public:
  static bool Accept(URLLoader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoader>>
class URLLoaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderStub() {}
  ~URLLoaderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientStubDispatch {
 public:
  static bool Accept(URLLoaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderClient>>
class URLLoaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderClientStub() {}
  ~URLLoaderClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT URLLoaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};


















class BLINK_PLATFORM_EXPORT TrustedUrlRequestParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustedUrlRequestParams, T>::value>;
  using DataView = TrustedUrlRequestParamsDataView;
  using Data_ = internal::TrustedUrlRequestParams_Data;

  template <typename... Args>
  static TrustedUrlRequestParamsPtr New(Args&&... args) {
    return TrustedUrlRequestParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustedUrlRequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<TrustedUrlRequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustedUrlRequestParams>::Convert(*this);
  }


  TrustedUrlRequestParams();

  TrustedUrlRequestParams(
      const ::net::IsolationInfo& isolation_info,
      bool disable_secure_dns,
      bool has_user_activation,
      ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer,
      ::network::mojom::blink::ClientSecurityStatePtr client_security_state);

  ~TrustedUrlRequestParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustedUrlRequestParamsPtr>
  TrustedUrlRequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustedUrlRequestParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustedUrlRequestParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustedUrlRequestParams_UnserializedMessageContext<
            UserType, TrustedUrlRequestParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TrustedUrlRequestParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TrustedUrlRequestParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustedUrlRequestParams_UnserializedMessageContext<
            UserType, TrustedUrlRequestParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustedUrlRequestParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::IsolationInfo isolation_info;
  
  bool disable_secure_dns;
  
  bool has_user_activation;
  
  ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer;
  
  ::network::mojom::blink::ClientSecurityStatePtr client_security_state;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TrustedUrlRequestParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT URLRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLRequest, T>::value>;
  using DataView = URLRequestDataView;
  using Data_ = internal::URLRequest_Data;

  template <typename... Args>
  static URLRequestPtr New(Args&&... args) {
    return URLRequestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLRequestPtr From(const U& u) {
    return mojo::TypeConverter<URLRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLRequest>::Convert(*this);
  }


  URLRequest();

  URLRequest(
      const WTF::String& method,
      const ::blink::KURL& url,
      const ::net::SiteForCookies& site_for_cookies,
      bool force_ignore_site_for_cookies,
      bool update_first_party_url_on_redirect,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& request_initiator,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& isolated_world_origin,
      const ::blink::KURL& referrer,
      ::net::ReferrerPolicy referrer_policy,
      const ::net::HttpRequestHeaders& headers,
      const ::net::HttpRequestHeaders& cors_exempt_headers,
      int32_t load_flags,
      int32_t resource_type,
      ::net::RequestPriority priority,
      bool should_reset_appcache,
      bool is_external_request,
      ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy,
      bool originated_from_service_worker,
      bool skip_service_worker,
      bool corb_detachable,
      bool corb_excluded,
      ::network::mojom::blink::RequestMode mode,
      ::network::mojom::blink::CredentialsMode credentials_mode,
      ::network::mojom::blink::RedirectMode redirect_mode,
      const WTF::String& fetch_integrity,
      ::network::mojom::blink::RequestDestination destination,
      ::scoped_refptr<::network::ResourceRequestBody> request_body,
      bool keepalive,
      bool has_user_gesture,
      bool enable_load_timing,
      bool enable_upload_progress,
      bool do_not_prompt_for_login,
      int32_t render_frame_id,
      bool is_main_frame,
      int32_t transition_type,
      bool report_raw_headers,
      int32_t previews_state,
      bool upgrade_if_insecure,
      bool is_revalidating,
      const base::Optional<::base::UnguessableToken>& throttling_profile_id,
      const base::Optional<::base::UnguessableToken>& fetch_window_id,
      const WTF::String& devtools_request_id,
      bool is_signed_exchange_prefetch_cache_enabled,
      bool obey_origin_policy,
      const base::Optional<::network::ResourceRequest::TrustedParams>& trusted_params,
      const base::Optional<::base::UnguessableToken>& recursive_prefetch_token,
      ::network::mojom::blink::TrustTokenParamsPtr trust_token_params);

  ~URLRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLRequestPtr>
  URLRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLRequest::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLRequest_UnserializedMessageContext<
            UserType, URLRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<URLRequest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return URLRequest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLRequest_UnserializedMessageContext<
            UserType, URLRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLRequest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String method;
  
  ::blink::KURL url;
  
  ::net::SiteForCookies site_for_cookies;
  
  bool force_ignore_site_for_cookies;
  
  bool update_first_party_url_on_redirect;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> request_initiator;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> isolated_world_origin;
  
  ::blink::KURL referrer;
  
  ::net::ReferrerPolicy referrer_policy;
  
  ::net::HttpRequestHeaders headers;
  
  ::net::HttpRequestHeaders cors_exempt_headers;
  
  int32_t load_flags;
  
  int32_t resource_type;
  
  ::net::RequestPriority priority;
  
  bool should_reset_appcache;
  
  bool is_external_request;
  
  ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy;
  
  bool originated_from_service_worker;
  
  bool skip_service_worker;
  
  bool corb_detachable;
  
  bool corb_excluded;
  
  ::network::mojom::blink::RequestMode mode;
  
  ::network::mojom::blink::CredentialsMode credentials_mode;
  
  ::network::mojom::blink::RedirectMode redirect_mode;
  
  WTF::String fetch_integrity;
  
  ::network::mojom::blink::RequestDestination destination;
  
  ::scoped_refptr<::network::ResourceRequestBody> request_body;
  
  bool keepalive;
  
  bool has_user_gesture;
  
  bool enable_load_timing;
  
  bool enable_upload_progress;
  
  bool do_not_prompt_for_login;
  
  int32_t render_frame_id;
  
  bool is_main_frame;
  
  int32_t transition_type;
  
  bool report_raw_headers;
  
  int32_t previews_state;
  
  bool upgrade_if_insecure;
  
  bool is_revalidating;
  
  base::Optional<::base::UnguessableToken> throttling_profile_id;
  
  base::Optional<::base::UnguessableToken> fetch_window_id;
  
  WTF::String devtools_request_id;
  
  bool is_signed_exchange_prefetch_cache_enabled;
  
  bool obey_origin_policy;
  
  base::Optional<::network::ResourceRequest::TrustedParams> trusted_params;
  
  base::Optional<::base::UnguessableToken> recursive_prefetch_token;
  
  ::network::mojom::blink::TrustTokenParamsPtr trust_token_params;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(URLRequest);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT URLRequestBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLRequestBody, T>::value>;
  using DataView = URLRequestBodyDataView;
  using Data_ = internal::URLRequestBody_Data;

  template <typename... Args>
  static URLRequestBodyPtr New(Args&&... args) {
    return URLRequestBodyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLRequestBodyPtr From(const U& u) {
    return mojo::TypeConverter<URLRequestBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLRequestBody>::Convert(*this);
  }


  URLRequestBody();

  URLRequestBody(
      WTF::Vector<::network::DataElement> elements,
      uint64_t identifier,
      bool contains_sensitive_info,
      bool allow_http1_for_streaming_upload);

  ~URLRequestBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLRequestBodyPtr>
  URLRequestBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLRequestBody::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLRequestBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLRequestBody_UnserializedMessageContext<
            UserType, URLRequestBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<URLRequestBody::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return URLRequestBody::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLRequestBody_UnserializedMessageContext<
            UserType, URLRequestBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLRequestBody::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<::network::DataElement> elements;
  
  uint64_t identifier;
  
  bool contains_sensitive_info;
  
  bool allow_http1_for_streaming_upload;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(URLRequestBody);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLRequestBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DataElement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataElement, T>::value>;
  using DataView = DataElementDataView;
  using Data_ = internal::DataElement_Data;

  template <typename... Args>
  static DataElementPtr New(Args&&... args) {
    return DataElementPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataElementPtr From(const U& u) {
    return mojo::TypeConverter<DataElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataElement>::Convert(*this);
  }


  DataElement();

  DataElement(
      DataElementType type,
      WTF::Vector<uint8_t> buf,
      const ::base::FilePath& path,
      const WTF::String& blob_uuid,
      ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter,
      ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> chunked_data_pipe_getter,
      uint64_t offset,
      uint64_t length,
      ::base::Time expected_modification_time);

  ~DataElement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataElementPtr>
  DataElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataElement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataElement::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataElement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataElement_UnserializedMessageContext<
            UserType, DataElement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DataElement::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DataElement::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataElement_UnserializedMessageContext<
            UserType, DataElement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataElement::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  DataElementType type;
  
  WTF::Vector<uint8_t> buf;
  
  ::base::FilePath path;
  
  WTF::String blob_uuid;
  
  ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter;
  
  ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> chunked_data_pipe_getter;
  
  uint64_t offset;
  
  uint64_t length;
  
  ::base::Time expected_modification_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DataElement);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataElement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataElement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataElement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataElement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT URLLoaderClientEndpoints {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderClientEndpoints, T>::value>;
  using DataView = URLLoaderClientEndpointsDataView;
  using Data_ = internal::URLLoaderClientEndpoints_Data;

  template <typename... Args>
  static URLLoaderClientEndpointsPtr New(Args&&... args) {
    return URLLoaderClientEndpointsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderClientEndpointsPtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderClientEndpointsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderClientEndpoints>::Convert(*this);
  }


  URLLoaderClientEndpoints();

  URLLoaderClientEndpoints(
      ::mojo::PendingRemote<URLLoader> url_loader,
      ::mojo::PendingReceiver<URLLoaderClient> url_loader_client);

  ~URLLoaderClientEndpoints();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderClientEndpointsPtr>
  URLLoaderClientEndpointsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLLoaderClientEndpoints::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderClientEndpoints::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderClientEndpoints_UnserializedMessageContext<
            UserType, URLLoaderClientEndpoints::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<URLLoaderClientEndpoints::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return URLLoaderClientEndpoints::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderClientEndpoints_UnserializedMessageContext<
            UserType, URLLoaderClientEndpoints::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderClientEndpoints::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<URLLoader> url_loader;
  
  ::mojo::PendingReceiver<URLLoaderClient> url_loader_client;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(URLLoaderClientEndpoints);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TrustedUrlRequestParamsPtr TrustedUrlRequestParams::Clone() const {
  return New(
      mojo::Clone(isolation_info),
      mojo::Clone(disable_secure_dns),
      mojo::Clone(has_user_activation),
      mojo::Clone(cookie_observer),
      mojo::Clone(client_security_state)
  );
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>*>
bool TrustedUrlRequestParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->isolation_info, other_struct.isolation_info))
    return false;
  if (!mojo::Equals(this->disable_secure_dns, other_struct.disable_secure_dns))
    return false;
  if (!mojo::Equals(this->has_user_activation, other_struct.has_user_activation))
    return false;
  if (!mojo::Equals(this->cookie_observer, other_struct.cookie_observer))
    return false;
  if (!mojo::Equals(this->client_security_state, other_struct.client_security_state))
    return false;
  return true;
}

template <typename T, TrustedUrlRequestParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.isolation_info, rhs.isolation_info))
    return true;
  if (std::less<>{}(rhs.isolation_info, lhs.isolation_info))
    return false;
  if (std::less<>{}(lhs.disable_secure_dns, rhs.disable_secure_dns))
    return true;
  if (std::less<>{}(rhs.disable_secure_dns, lhs.disable_secure_dns))
    return false;
  if (std::less<>{}(lhs.has_user_activation, rhs.has_user_activation))
    return true;
  if (std::less<>{}(rhs.has_user_activation, lhs.has_user_activation))
    return false;
  if (std::less<>{}(lhs.cookie_observer, rhs.cookie_observer))
    return true;
  if (std::less<>{}(rhs.cookie_observer, lhs.cookie_observer))
    return false;
  if (std::less<>{}(lhs.client_security_state, rhs.client_security_state))
    return true;
  if (std::less<>{}(rhs.client_security_state, lhs.client_security_state))
    return false;
  return false;
}
template <typename StructPtrType>
URLRequestPtr URLRequest::Clone() const {
  return New(
      mojo::Clone(method),
      mojo::Clone(url),
      mojo::Clone(site_for_cookies),
      mojo::Clone(force_ignore_site_for_cookies),
      mojo::Clone(update_first_party_url_on_redirect),
      mojo::Clone(request_initiator),
      mojo::Clone(isolated_world_origin),
      mojo::Clone(referrer),
      mojo::Clone(referrer_policy),
      mojo::Clone(headers),
      mojo::Clone(cors_exempt_headers),
      mojo::Clone(load_flags),
      mojo::Clone(resource_type),
      mojo::Clone(priority),
      mojo::Clone(should_reset_appcache),
      mojo::Clone(is_external_request),
      mojo::Clone(cors_preflight_policy),
      mojo::Clone(originated_from_service_worker),
      mojo::Clone(skip_service_worker),
      mojo::Clone(corb_detachable),
      mojo::Clone(corb_excluded),
      mojo::Clone(mode),
      mojo::Clone(credentials_mode),
      mojo::Clone(redirect_mode),
      mojo::Clone(fetch_integrity),
      mojo::Clone(destination),
      mojo::Clone(request_body),
      mojo::Clone(keepalive),
      mojo::Clone(has_user_gesture),
      mojo::Clone(enable_load_timing),
      mojo::Clone(enable_upload_progress),
      mojo::Clone(do_not_prompt_for_login),
      mojo::Clone(render_frame_id),
      mojo::Clone(is_main_frame),
      mojo::Clone(transition_type),
      mojo::Clone(report_raw_headers),
      mojo::Clone(previews_state),
      mojo::Clone(upgrade_if_insecure),
      mojo::Clone(is_revalidating),
      mojo::Clone(throttling_profile_id),
      mojo::Clone(fetch_window_id),
      mojo::Clone(devtools_request_id),
      mojo::Clone(is_signed_exchange_prefetch_cache_enabled),
      mojo::Clone(obey_origin_policy),
      mojo::Clone(trusted_params),
      mojo::Clone(recursive_prefetch_token),
      mojo::Clone(trust_token_params)
  );
}

template <typename T, URLRequest::EnableIfSame<T>*>
bool URLRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->force_ignore_site_for_cookies, other_struct.force_ignore_site_for_cookies))
    return false;
  if (!mojo::Equals(this->update_first_party_url_on_redirect, other_struct.update_first_party_url_on_redirect))
    return false;
  if (!mojo::Equals(this->request_initiator, other_struct.request_initiator))
    return false;
  if (!mojo::Equals(this->isolated_world_origin, other_struct.isolated_world_origin))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->cors_exempt_headers, other_struct.cors_exempt_headers))
    return false;
  if (!mojo::Equals(this->load_flags, other_struct.load_flags))
    return false;
  if (!mojo::Equals(this->resource_type, other_struct.resource_type))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  if (!mojo::Equals(this->should_reset_appcache, other_struct.should_reset_appcache))
    return false;
  if (!mojo::Equals(this->is_external_request, other_struct.is_external_request))
    return false;
  if (!mojo::Equals(this->cors_preflight_policy, other_struct.cors_preflight_policy))
    return false;
  if (!mojo::Equals(this->originated_from_service_worker, other_struct.originated_from_service_worker))
    return false;
  if (!mojo::Equals(this->skip_service_worker, other_struct.skip_service_worker))
    return false;
  if (!mojo::Equals(this->corb_detachable, other_struct.corb_detachable))
    return false;
  if (!mojo::Equals(this->corb_excluded, other_struct.corb_excluded))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->credentials_mode, other_struct.credentials_mode))
    return false;
  if (!mojo::Equals(this->redirect_mode, other_struct.redirect_mode))
    return false;
  if (!mojo::Equals(this->fetch_integrity, other_struct.fetch_integrity))
    return false;
  if (!mojo::Equals(this->destination, other_struct.destination))
    return false;
  if (!mojo::Equals(this->request_body, other_struct.request_body))
    return false;
  if (!mojo::Equals(this->keepalive, other_struct.keepalive))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  if (!mojo::Equals(this->enable_load_timing, other_struct.enable_load_timing))
    return false;
  if (!mojo::Equals(this->enable_upload_progress, other_struct.enable_upload_progress))
    return false;
  if (!mojo::Equals(this->do_not_prompt_for_login, other_struct.do_not_prompt_for_login))
    return false;
  if (!mojo::Equals(this->render_frame_id, other_struct.render_frame_id))
    return false;
  if (!mojo::Equals(this->is_main_frame, other_struct.is_main_frame))
    return false;
  if (!mojo::Equals(this->transition_type, other_struct.transition_type))
    return false;
  if (!mojo::Equals(this->report_raw_headers, other_struct.report_raw_headers))
    return false;
  if (!mojo::Equals(this->previews_state, other_struct.previews_state))
    return false;
  if (!mojo::Equals(this->upgrade_if_insecure, other_struct.upgrade_if_insecure))
    return false;
  if (!mojo::Equals(this->is_revalidating, other_struct.is_revalidating))
    return false;
  if (!mojo::Equals(this->throttling_profile_id, other_struct.throttling_profile_id))
    return false;
  if (!mojo::Equals(this->fetch_window_id, other_struct.fetch_window_id))
    return false;
  if (!mojo::Equals(this->devtools_request_id, other_struct.devtools_request_id))
    return false;
  if (!mojo::Equals(this->is_signed_exchange_prefetch_cache_enabled, other_struct.is_signed_exchange_prefetch_cache_enabled))
    return false;
  if (!mojo::Equals(this->obey_origin_policy, other_struct.obey_origin_policy))
    return false;
  if (!mojo::Equals(this->trusted_params, other_struct.trusted_params))
    return false;
  if (!mojo::Equals(this->recursive_prefetch_token, other_struct.recursive_prefetch_token))
    return false;
  if (!mojo::Equals(this->trust_token_params, other_struct.trust_token_params))
    return false;
  return true;
}

template <typename T, URLRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.site_for_cookies, rhs.site_for_cookies))
    return true;
  if (std::less<>{}(rhs.site_for_cookies, lhs.site_for_cookies))
    return false;
  if (std::less<>{}(lhs.force_ignore_site_for_cookies, rhs.force_ignore_site_for_cookies))
    return true;
  if (std::less<>{}(rhs.force_ignore_site_for_cookies, lhs.force_ignore_site_for_cookies))
    return false;
  if (std::less<>{}(lhs.update_first_party_url_on_redirect, rhs.update_first_party_url_on_redirect))
    return true;
  if (std::less<>{}(rhs.update_first_party_url_on_redirect, lhs.update_first_party_url_on_redirect))
    return false;
  if (std::less<>{}(lhs.request_initiator, rhs.request_initiator))
    return true;
  if (std::less<>{}(rhs.request_initiator, lhs.request_initiator))
    return false;
  if (std::less<>{}(lhs.isolated_world_origin, rhs.isolated_world_origin))
    return true;
  if (std::less<>{}(rhs.isolated_world_origin, lhs.isolated_world_origin))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.referrer_policy, rhs.referrer_policy))
    return true;
  if (std::less<>{}(rhs.referrer_policy, lhs.referrer_policy))
    return false;
  if (std::less<>{}(lhs.headers, rhs.headers))
    return true;
  if (std::less<>{}(rhs.headers, lhs.headers))
    return false;
  if (std::less<>{}(lhs.cors_exempt_headers, rhs.cors_exempt_headers))
    return true;
  if (std::less<>{}(rhs.cors_exempt_headers, lhs.cors_exempt_headers))
    return false;
  if (std::less<>{}(lhs.load_flags, rhs.load_flags))
    return true;
  if (std::less<>{}(rhs.load_flags, lhs.load_flags))
    return false;
  if (std::less<>{}(lhs.resource_type, rhs.resource_type))
    return true;
  if (std::less<>{}(rhs.resource_type, lhs.resource_type))
    return false;
  if (std::less<>{}(lhs.priority, rhs.priority))
    return true;
  if (std::less<>{}(rhs.priority, lhs.priority))
    return false;
  if (std::less<>{}(lhs.should_reset_appcache, rhs.should_reset_appcache))
    return true;
  if (std::less<>{}(rhs.should_reset_appcache, lhs.should_reset_appcache))
    return false;
  if (std::less<>{}(lhs.is_external_request, rhs.is_external_request))
    return true;
  if (std::less<>{}(rhs.is_external_request, lhs.is_external_request))
    return false;
  if (std::less<>{}(lhs.cors_preflight_policy, rhs.cors_preflight_policy))
    return true;
  if (std::less<>{}(rhs.cors_preflight_policy, lhs.cors_preflight_policy))
    return false;
  if (std::less<>{}(lhs.originated_from_service_worker, rhs.originated_from_service_worker))
    return true;
  if (std::less<>{}(rhs.originated_from_service_worker, lhs.originated_from_service_worker))
    return false;
  if (std::less<>{}(lhs.skip_service_worker, rhs.skip_service_worker))
    return true;
  if (std::less<>{}(rhs.skip_service_worker, lhs.skip_service_worker))
    return false;
  if (std::less<>{}(lhs.corb_detachable, rhs.corb_detachable))
    return true;
  if (std::less<>{}(rhs.corb_detachable, lhs.corb_detachable))
    return false;
  if (std::less<>{}(lhs.corb_excluded, rhs.corb_excluded))
    return true;
  if (std::less<>{}(rhs.corb_excluded, lhs.corb_excluded))
    return false;
  if (std::less<>{}(lhs.mode, rhs.mode))
    return true;
  if (std::less<>{}(rhs.mode, lhs.mode))
    return false;
  if (std::less<>{}(lhs.credentials_mode, rhs.credentials_mode))
    return true;
  if (std::less<>{}(rhs.credentials_mode, lhs.credentials_mode))
    return false;
  if (std::less<>{}(lhs.redirect_mode, rhs.redirect_mode))
    return true;
  if (std::less<>{}(rhs.redirect_mode, lhs.redirect_mode))
    return false;
  if (std::less<>{}(lhs.fetch_integrity, rhs.fetch_integrity))
    return true;
  if (std::less<>{}(rhs.fetch_integrity, lhs.fetch_integrity))
    return false;
  if (std::less<>{}(lhs.destination, rhs.destination))
    return true;
  if (std::less<>{}(rhs.destination, lhs.destination))
    return false;
  if (std::less<>{}(lhs.request_body, rhs.request_body))
    return true;
  if (std::less<>{}(rhs.request_body, lhs.request_body))
    return false;
  if (std::less<>{}(lhs.keepalive, rhs.keepalive))
    return true;
  if (std::less<>{}(rhs.keepalive, lhs.keepalive))
    return false;
  if (std::less<>{}(lhs.has_user_gesture, rhs.has_user_gesture))
    return true;
  if (std::less<>{}(rhs.has_user_gesture, lhs.has_user_gesture))
    return false;
  if (std::less<>{}(lhs.enable_load_timing, rhs.enable_load_timing))
    return true;
  if (std::less<>{}(rhs.enable_load_timing, lhs.enable_load_timing))
    return false;
  if (std::less<>{}(lhs.enable_upload_progress, rhs.enable_upload_progress))
    return true;
  if (std::less<>{}(rhs.enable_upload_progress, lhs.enable_upload_progress))
    return false;
  if (std::less<>{}(lhs.do_not_prompt_for_login, rhs.do_not_prompt_for_login))
    return true;
  if (std::less<>{}(rhs.do_not_prompt_for_login, lhs.do_not_prompt_for_login))
    return false;
  if (std::less<>{}(lhs.render_frame_id, rhs.render_frame_id))
    return true;
  if (std::less<>{}(rhs.render_frame_id, lhs.render_frame_id))
    return false;
  if (std::less<>{}(lhs.is_main_frame, rhs.is_main_frame))
    return true;
  if (std::less<>{}(rhs.is_main_frame, lhs.is_main_frame))
    return false;
  if (std::less<>{}(lhs.transition_type, rhs.transition_type))
    return true;
  if (std::less<>{}(rhs.transition_type, lhs.transition_type))
    return false;
  if (std::less<>{}(lhs.report_raw_headers, rhs.report_raw_headers))
    return true;
  if (std::less<>{}(rhs.report_raw_headers, lhs.report_raw_headers))
    return false;
  if (std::less<>{}(lhs.previews_state, rhs.previews_state))
    return true;
  if (std::less<>{}(rhs.previews_state, lhs.previews_state))
    return false;
  if (std::less<>{}(lhs.upgrade_if_insecure, rhs.upgrade_if_insecure))
    return true;
  if (std::less<>{}(rhs.upgrade_if_insecure, lhs.upgrade_if_insecure))
    return false;
  if (std::less<>{}(lhs.is_revalidating, rhs.is_revalidating))
    return true;
  if (std::less<>{}(rhs.is_revalidating, lhs.is_revalidating))
    return false;
  if (std::less<>{}(lhs.throttling_profile_id, rhs.throttling_profile_id))
    return true;
  if (std::less<>{}(rhs.throttling_profile_id, lhs.throttling_profile_id))
    return false;
  if (std::less<>{}(lhs.fetch_window_id, rhs.fetch_window_id))
    return true;
  if (std::less<>{}(rhs.fetch_window_id, lhs.fetch_window_id))
    return false;
  if (std::less<>{}(lhs.devtools_request_id, rhs.devtools_request_id))
    return true;
  if (std::less<>{}(rhs.devtools_request_id, lhs.devtools_request_id))
    return false;
  if (std::less<>{}(lhs.is_signed_exchange_prefetch_cache_enabled, rhs.is_signed_exchange_prefetch_cache_enabled))
    return true;
  if (std::less<>{}(rhs.is_signed_exchange_prefetch_cache_enabled, lhs.is_signed_exchange_prefetch_cache_enabled))
    return false;
  if (std::less<>{}(lhs.obey_origin_policy, rhs.obey_origin_policy))
    return true;
  if (std::less<>{}(rhs.obey_origin_policy, lhs.obey_origin_policy))
    return false;
  if (std::less<>{}(lhs.trusted_params, rhs.trusted_params))
    return true;
  if (std::less<>{}(rhs.trusted_params, lhs.trusted_params))
    return false;
  if (std::less<>{}(lhs.recursive_prefetch_token, rhs.recursive_prefetch_token))
    return true;
  if (std::less<>{}(rhs.recursive_prefetch_token, lhs.recursive_prefetch_token))
    return false;
  if (std::less<>{}(lhs.trust_token_params, rhs.trust_token_params))
    return true;
  if (std::less<>{}(rhs.trust_token_params, lhs.trust_token_params))
    return false;
  return false;
}
template <typename StructPtrType>
URLRequestBodyPtr URLRequestBody::Clone() const {
  return New(
      mojo::Clone(elements),
      mojo::Clone(identifier),
      mojo::Clone(contains_sensitive_info),
      mojo::Clone(allow_http1_for_streaming_upload)
  );
}

template <typename T, URLRequestBody::EnableIfSame<T>*>
bool URLRequestBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->elements, other_struct.elements))
    return false;
  if (!mojo::Equals(this->identifier, other_struct.identifier))
    return false;
  if (!mojo::Equals(this->contains_sensitive_info, other_struct.contains_sensitive_info))
    return false;
  if (!mojo::Equals(this->allow_http1_for_streaming_upload, other_struct.allow_http1_for_streaming_upload))
    return false;
  return true;
}

template <typename T, URLRequestBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.elements, rhs.elements))
    return true;
  if (std::less<>{}(rhs.elements, lhs.elements))
    return false;
  if (std::less<>{}(lhs.identifier, rhs.identifier))
    return true;
  if (std::less<>{}(rhs.identifier, lhs.identifier))
    return false;
  if (std::less<>{}(lhs.contains_sensitive_info, rhs.contains_sensitive_info))
    return true;
  if (std::less<>{}(rhs.contains_sensitive_info, lhs.contains_sensitive_info))
    return false;
  if (std::less<>{}(lhs.allow_http1_for_streaming_upload, rhs.allow_http1_for_streaming_upload))
    return true;
  if (std::less<>{}(rhs.allow_http1_for_streaming_upload, lhs.allow_http1_for_streaming_upload))
    return false;
  return false;
}
template <typename StructPtrType>
DataElementPtr DataElement::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(buf),
      mojo::Clone(path),
      mojo::Clone(blob_uuid),
      mojo::Clone(data_pipe_getter),
      mojo::Clone(chunked_data_pipe_getter),
      mojo::Clone(offset),
      mojo::Clone(length),
      mojo::Clone(expected_modification_time)
  );
}

template <typename T, DataElement::EnableIfSame<T>*>
bool DataElement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->buf, other_struct.buf))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->blob_uuid, other_struct.blob_uuid))
    return false;
  if (!mojo::Equals(this->data_pipe_getter, other_struct.data_pipe_getter))
    return false;
  if (!mojo::Equals(this->chunked_data_pipe_getter, other_struct.chunked_data_pipe_getter))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->length, other_struct.length))
    return false;
  if (!mojo::Equals(this->expected_modification_time, other_struct.expected_modification_time))
    return false;
  return true;
}

template <typename T, DataElement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.buf, rhs.buf))
    return true;
  if (std::less<>{}(rhs.buf, lhs.buf))
    return false;
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.blob_uuid, rhs.blob_uuid))
    return true;
  if (std::less<>{}(rhs.blob_uuid, lhs.blob_uuid))
    return false;
  if (std::less<>{}(lhs.data_pipe_getter, rhs.data_pipe_getter))
    return true;
  if (std::less<>{}(rhs.data_pipe_getter, lhs.data_pipe_getter))
    return false;
  if (std::less<>{}(lhs.chunked_data_pipe_getter, rhs.chunked_data_pipe_getter))
    return true;
  if (std::less<>{}(rhs.chunked_data_pipe_getter, lhs.chunked_data_pipe_getter))
    return false;
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.length, rhs.length))
    return true;
  if (std::less<>{}(rhs.length, lhs.length))
    return false;
  if (std::less<>{}(lhs.expected_modification_time, rhs.expected_modification_time))
    return true;
  if (std::less<>{}(rhs.expected_modification_time, lhs.expected_modification_time))
    return false;
  return false;
}
template <typename StructPtrType>
URLLoaderClientEndpointsPtr URLLoaderClientEndpoints::Clone() const {
  return New(
      mojo::Clone(url_loader),
      mojo::Clone(url_loader_client)
  );
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>*>
bool URLLoaderClientEndpoints::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url_loader, other_struct.url_loader))
    return false;
  if (!mojo::Equals(this->url_loader_client, other_struct.url_loader_client))
    return false;
  return true;
}

template <typename T, URLLoaderClientEndpoints::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url_loader, rhs.url_loader))
    return true;
  if (std::less<>{}(rhs.url_loader, lhs.url_loader))
    return false;
  if (std::less<>{}(lhs.url_loader_client, rhs.url_loader_client))
    return true;
  if (std::less<>{}(rhs.url_loader_client, lhs.url_loader_client))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::TrustedUrlRequestParams::DataView,
                                         ::network::mojom::blink::TrustedUrlRequestParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::TrustedUrlRequestParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::TrustedUrlRequestParams::isolation_info)& isolation_info(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->isolation_info;
  }

  static decltype(::network::mojom::blink::TrustedUrlRequestParams::disable_secure_dns) disable_secure_dns(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->disable_secure_dns;
  }

  static decltype(::network::mojom::blink::TrustedUrlRequestParams::has_user_activation) has_user_activation(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->has_user_activation;
  }

  static  decltype(::network::mojom::blink::TrustedUrlRequestParams::cookie_observer)& cookie_observer(
       ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->cookie_observer;
  }

  static const decltype(::network::mojom::blink::TrustedUrlRequestParams::client_security_state)& client_security_state(
      const ::network::mojom::blink::TrustedUrlRequestParamsPtr& input) {
    return input->client_security_state;
  }

  static bool Read(::network::mojom::blink::TrustedUrlRequestParams::DataView input, ::network::mojom::blink::TrustedUrlRequestParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLRequest::DataView,
                                         ::network::mojom::blink::URLRequestPtr> {
  static bool IsNull(const ::network::mojom::blink::URLRequestPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLRequestPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::URLRequest::method)& method(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->method;
  }

  static const decltype(::network::mojom::blink::URLRequest::url)& url(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::blink::URLRequest::site_for_cookies)& site_for_cookies(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->site_for_cookies;
  }

  static decltype(::network::mojom::blink::URLRequest::force_ignore_site_for_cookies) force_ignore_site_for_cookies(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->force_ignore_site_for_cookies;
  }

  static decltype(::network::mojom::blink::URLRequest::update_first_party_url_on_redirect) update_first_party_url_on_redirect(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->update_first_party_url_on_redirect;
  }

  static const decltype(::network::mojom::blink::URLRequest::request_initiator)& request_initiator(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->request_initiator;
  }

  static const decltype(::network::mojom::blink::URLRequest::isolated_world_origin)& isolated_world_origin(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->isolated_world_origin;
  }

  static const decltype(::network::mojom::blink::URLRequest::referrer)& referrer(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->referrer;
  }

  static decltype(::network::mojom::blink::URLRequest::referrer_policy) referrer_policy(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::network::mojom::blink::URLRequest::headers)& headers(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::blink::URLRequest::cors_exempt_headers)& cors_exempt_headers(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->cors_exempt_headers;
  }

  static decltype(::network::mojom::blink::URLRequest::load_flags) load_flags(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->load_flags;
  }

  static decltype(::network::mojom::blink::URLRequest::resource_type) resource_type(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->resource_type;
  }

  static decltype(::network::mojom::blink::URLRequest::priority) priority(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->priority;
  }

  static decltype(::network::mojom::blink::URLRequest::should_reset_appcache) should_reset_appcache(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->should_reset_appcache;
  }

  static decltype(::network::mojom::blink::URLRequest::is_external_request) is_external_request(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_external_request;
  }

  static decltype(::network::mojom::blink::URLRequest::cors_preflight_policy) cors_preflight_policy(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->cors_preflight_policy;
  }

  static decltype(::network::mojom::blink::URLRequest::originated_from_service_worker) originated_from_service_worker(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->originated_from_service_worker;
  }

  static decltype(::network::mojom::blink::URLRequest::skip_service_worker) skip_service_worker(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->skip_service_worker;
  }

  static decltype(::network::mojom::blink::URLRequest::corb_detachable) corb_detachable(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->corb_detachable;
  }

  static decltype(::network::mojom::blink::URLRequest::corb_excluded) corb_excluded(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->corb_excluded;
  }

  static decltype(::network::mojom::blink::URLRequest::mode) mode(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->mode;
  }

  static decltype(::network::mojom::blink::URLRequest::credentials_mode) credentials_mode(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->credentials_mode;
  }

  static decltype(::network::mojom::blink::URLRequest::redirect_mode) redirect_mode(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->redirect_mode;
  }

  static const decltype(::network::mojom::blink::URLRequest::fetch_integrity)& fetch_integrity(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->fetch_integrity;
  }

  static decltype(::network::mojom::blink::URLRequest::destination) destination(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->destination;
  }

  static  decltype(::network::mojom::blink::URLRequest::request_body)& request_body(
       ::network::mojom::blink::URLRequestPtr& input) {
    return input->request_body;
  }

  static decltype(::network::mojom::blink::URLRequest::keepalive) keepalive(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->keepalive;
  }

  static decltype(::network::mojom::blink::URLRequest::has_user_gesture) has_user_gesture(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->has_user_gesture;
  }

  static decltype(::network::mojom::blink::URLRequest::enable_load_timing) enable_load_timing(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->enable_load_timing;
  }

  static decltype(::network::mojom::blink::URLRequest::enable_upload_progress) enable_upload_progress(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->enable_upload_progress;
  }

  static decltype(::network::mojom::blink::URLRequest::do_not_prompt_for_login) do_not_prompt_for_login(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->do_not_prompt_for_login;
  }

  static decltype(::network::mojom::blink::URLRequest::render_frame_id) render_frame_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->render_frame_id;
  }

  static decltype(::network::mojom::blink::URLRequest::is_main_frame) is_main_frame(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_main_frame;
  }

  static decltype(::network::mojom::blink::URLRequest::transition_type) transition_type(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->transition_type;
  }

  static decltype(::network::mojom::blink::URLRequest::report_raw_headers) report_raw_headers(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->report_raw_headers;
  }

  static decltype(::network::mojom::blink::URLRequest::previews_state) previews_state(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->previews_state;
  }

  static decltype(::network::mojom::blink::URLRequest::upgrade_if_insecure) upgrade_if_insecure(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->upgrade_if_insecure;
  }

  static decltype(::network::mojom::blink::URLRequest::is_revalidating) is_revalidating(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_revalidating;
  }

  static const decltype(::network::mojom::blink::URLRequest::throttling_profile_id)& throttling_profile_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->throttling_profile_id;
  }

  static const decltype(::network::mojom::blink::URLRequest::fetch_window_id)& fetch_window_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->fetch_window_id;
  }

  static const decltype(::network::mojom::blink::URLRequest::devtools_request_id)& devtools_request_id(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->devtools_request_id;
  }

  static decltype(::network::mojom::blink::URLRequest::is_signed_exchange_prefetch_cache_enabled) is_signed_exchange_prefetch_cache_enabled(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->is_signed_exchange_prefetch_cache_enabled;
  }

  static decltype(::network::mojom::blink::URLRequest::obey_origin_policy) obey_origin_policy(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->obey_origin_policy;
  }

  static  decltype(::network::mojom::blink::URLRequest::trusted_params)& trusted_params(
       ::network::mojom::blink::URLRequestPtr& input) {
    return input->trusted_params;
  }

  static const decltype(::network::mojom::blink::URLRequest::recursive_prefetch_token)& recursive_prefetch_token(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->recursive_prefetch_token;
  }

  static const decltype(::network::mojom::blink::URLRequest::trust_token_params)& trust_token_params(
      const ::network::mojom::blink::URLRequestPtr& input) {
    return input->trust_token_params;
  }

  static bool Read(::network::mojom::blink::URLRequest::DataView input, ::network::mojom::blink::URLRequestPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLRequestBody::DataView,
                                         ::network::mojom::blink::URLRequestBodyPtr> {
  static bool IsNull(const ::network::mojom::blink::URLRequestBodyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLRequestBodyPtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::URLRequestBody::elements)& elements(
       ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->elements;
  }

  static decltype(::network::mojom::blink::URLRequestBody::identifier) identifier(
      const ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->identifier;
  }

  static decltype(::network::mojom::blink::URLRequestBody::contains_sensitive_info) contains_sensitive_info(
      const ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->contains_sensitive_info;
  }

  static decltype(::network::mojom::blink::URLRequestBody::allow_http1_for_streaming_upload) allow_http1_for_streaming_upload(
      const ::network::mojom::blink::URLRequestBodyPtr& input) {
    return input->allow_http1_for_streaming_upload;
  }

  static bool Read(::network::mojom::blink::URLRequestBody::DataView input, ::network::mojom::blink::URLRequestBodyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DataElement::DataView,
                                         ::network::mojom::blink::DataElementPtr> {
  static bool IsNull(const ::network::mojom::blink::DataElementPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DataElementPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::DataElement::type) type(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::blink::DataElement::buf)& buf(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->buf;
  }

  static const decltype(::network::mojom::blink::DataElement::path)& path(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->path;
  }

  static const decltype(::network::mojom::blink::DataElement::blob_uuid)& blob_uuid(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->blob_uuid;
  }

  static  decltype(::network::mojom::blink::DataElement::data_pipe_getter)& data_pipe_getter(
       ::network::mojom::blink::DataElementPtr& input) {
    return input->data_pipe_getter;
  }

  static  decltype(::network::mojom::blink::DataElement::chunked_data_pipe_getter)& chunked_data_pipe_getter(
       ::network::mojom::blink::DataElementPtr& input) {
    return input->chunked_data_pipe_getter;
  }

  static decltype(::network::mojom::blink::DataElement::offset) offset(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->offset;
  }

  static decltype(::network::mojom::blink::DataElement::length) length(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->length;
  }

  static const decltype(::network::mojom::blink::DataElement::expected_modification_time)& expected_modification_time(
      const ::network::mojom::blink::DataElementPtr& input) {
    return input->expected_modification_time;
  }

  static bool Read(::network::mojom::blink::DataElement::DataView input, ::network::mojom::blink::DataElementPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::URLLoaderClientEndpoints::DataView,
                                         ::network::mojom::blink::URLLoaderClientEndpointsPtr> {
  static bool IsNull(const ::network::mojom::blink::URLLoaderClientEndpointsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::URLLoaderClientEndpointsPtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::URLLoaderClientEndpoints::url_loader)& url_loader(
       ::network::mojom::blink::URLLoaderClientEndpointsPtr& input) {
    return input->url_loader;
  }

  static  decltype(::network::mojom::blink::URLLoaderClientEndpoints::url_loader_client)& url_loader_client(
       ::network::mojom::blink::URLLoaderClientEndpointsPtr& input) {
    return input->url_loader_client;
  }

  static bool Read(::network::mojom::blink::URLLoaderClientEndpoints::DataView input, ::network::mojom::blink::URLLoaderClientEndpointsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_H_