// gpu/ipc/common/gpu_preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/gpu_preferences.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "gpu/ipc/common/gpu_preferences.mojom-params-data.h"
namespace gpu {
namespace mojom {

std::ostream& operator<<(std::ostream& os, VulkanImplementationName value) {
  switch(value) {
    case VulkanImplementationName::kNone:
      return os << "VulkanImplementationName::kNone";
    case VulkanImplementationName::kNative:
      return os << "VulkanImplementationName::kNative";
    case VulkanImplementationName::kForcedNative:
      return os << "VulkanImplementationName::kForcedNative";
    case VulkanImplementationName::kSwiftshader:
      return os << "VulkanImplementationName::{kSwiftshader, kLast}";
    default:
      return os << "Unknown VulkanImplementationName value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, GrContextType value) {
  switch(value) {
    case GrContextType::kGL:
      return os << "GrContextType::kGL";
    case GrContextType::kVulkan:
      return os << "GrContextType::kVulkan";
    case GrContextType::kMetal:
      return os << "GrContextType::kMetal";
    case GrContextType::kDawn:
      return os << "GrContextType::{kDawn, kLast}";
    default:
      return os << "Unknown GrContextType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool GpuPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GpuPreferences_Data* object = static_cast<const GpuPreferences_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->texture_target_exception_list, 35, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams texture_target_exception_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->texture_target_exception_list, validation_context,
                                         &texture_target_exception_list_validate_params)) {
    return false;
  }


  if (!::gpu::mojom::internal::GrContextType_Data
        ::Validate(object->gr_context_type, validation_context))
    return false;


  if (!::gpu::mojom::internal::VulkanImplementationName_Data
        ::Validate(object->use_vulkan, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::MessagePumpType_Data
        ::Validate(object->message_pump_type, validation_context))
    return false;

  return true;
}

GpuPreferences_Data::GpuPreferences_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu