// content/common/frame_sink_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/frame_sink_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/frame_sink_provider.mojom-params-data.h"
#include "content/common/frame_sink_provider.mojom-shared-message-ids.h"

#include "content/common/frame_sink_provider.mojom-import-headers.h"


#ifndef CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char FrameSinkProvider::Name_[] = "content.mojom.FrameSinkProvider";

FrameSinkProviderProxy::FrameSinkProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkProviderProxy::CreateForWidget(
    int32_t in_widget_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> in_compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> in_compositor_frame_sink_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameSinkProvider::CreateForWidget", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("widget_id", in_widget_id);
      raw_value->SetBoolean("compositor_frame_sink_receiver", in_compositor_frame_sink_receiver.is_valid());
      raw_value->SetBoolean("compositor_frame_sink_client", in_compositor_frame_sink_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkProvider_CreateForWidget_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameSinkProvider_CreateForWidget_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->widget_id = in_widget_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
      in_compositor_frame_sink_receiver, &params->compositor_frame_sink_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid compositor_frame_sink_receiver in FrameSinkProvider.CreateForWidget request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
      in_compositor_frame_sink_client, &params->compositor_frame_sink_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid compositor_frame_sink_client in FrameSinkProvider.CreateForWidget request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkProvider::Name_);
  message.set_method_name("CreateForWidget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameSinkProviderProxy::RegisterRenderFrameMetadataObserver(
    int32_t in_widget_id, ::mojo::PendingReceiver<::cc::mojom::RenderFrameMetadataObserverClient> in_render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::RenderFrameMetadataObserver> in_render_frame_metadata_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::FrameSinkProvider::RegisterRenderFrameMetadataObserver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("widget_id", in_widget_id);
      raw_value->SetBoolean("render_frame_metadata_observer_client_receiver", in_render_frame_metadata_observer_client_receiver.is_valid());
      raw_value->SetBoolean("render_frame_metadata_observer", in_render_frame_metadata_observer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameSinkProvider_RegisterRenderFrameMetadataObserver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->widget_id = in_widget_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cc::mojom::RenderFrameMetadataObserverClientInterfaceBase>>(
      in_render_frame_metadata_observer_client_receiver, &params->render_frame_metadata_observer_client_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->render_frame_metadata_observer_client_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid render_frame_metadata_observer_client_receiver in FrameSinkProvider.RegisterRenderFrameMetadataObserver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cc::mojom::RenderFrameMetadataObserverInterfaceBase>>(
      in_render_frame_metadata_observer, &params->render_frame_metadata_observer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->render_frame_metadata_observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid render_frame_metadata_observer in FrameSinkProvider.RegisterRenderFrameMetadataObserver request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkProvider::Name_);
  message.set_method_name("RegisterRenderFrameMetadataObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameSinkProviderStubDispatch::Accept(
    FrameSinkProvider* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameSinkProvider_CreateForWidget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameSinkProvider::CreateForWidget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameSinkProvider::CreateForWidget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkProvider_CreateForWidget_Params_Data* params =
          reinterpret_cast<internal::FrameSinkProvider_CreateForWidget_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_widget_id{};
      ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> p_compositor_frame_sink_receiver{};
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> p_compositor_frame_sink_client{};
      FrameSinkProvider_CreateForWidget_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_widget_id = input_data_view.widget_id();
      if (success) {
        p_compositor_frame_sink_receiver =
            input_data_view.TakeCompositorFrameSinkReceiver<decltype(p_compositor_frame_sink_receiver)>();
      }
      if (success) {
        p_compositor_frame_sink_client =
            input_data_view.TakeCompositorFrameSinkClient<decltype(p_compositor_frame_sink_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateForWidget(
std::move(p_widget_id), 
std::move(p_compositor_frame_sink_receiver), 
std::move(p_compositor_frame_sink_client));
      return true;
    }
    case internal::kFrameSinkProvider_RegisterRenderFrameMetadataObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::FrameSinkProvider::RegisterRenderFrameMetadataObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::FrameSinkProvider::RegisterRenderFrameMetadataObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data* params =
          reinterpret_cast<internal::FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_widget_id{};
      ::mojo::PendingReceiver<::cc::mojom::RenderFrameMetadataObserverClient> p_render_frame_metadata_observer_client_receiver{};
      ::mojo::PendingRemote<::cc::mojom::RenderFrameMetadataObserver> p_render_frame_metadata_observer{};
      FrameSinkProvider_RegisterRenderFrameMetadataObserver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_widget_id = input_data_view.widget_id();
      if (success) {
        p_render_frame_metadata_observer_client_receiver =
            input_data_view.TakeRenderFrameMetadataObserverClientReceiver<decltype(p_render_frame_metadata_observer_client_receiver)>();
      }
      if (success) {
        p_render_frame_metadata_observer =
            input_data_view.TakeRenderFrameMetadataObserver<decltype(p_render_frame_metadata_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterRenderFrameMetadataObserver(
std::move(p_widget_id), 
std::move(p_render_frame_metadata_observer_client_receiver), 
std::move(p_render_frame_metadata_observer));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkProviderStubDispatch::AcceptWithResponder(
    FrameSinkProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameSinkProvider_CreateForWidget_Name: {
      break;
    }
    case internal::kFrameSinkProvider_RegisterRenderFrameMetadataObserver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkProviderValidationInfo[] = {
    {internal::kFrameSinkProvider_CreateForWidget_Name,
     {&internal::FrameSinkProvider_CreateForWidget_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameSinkProvider_RegisterRenderFrameMetadataObserver_Name,
     {&internal::FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::FrameSinkProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkProviderValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif