#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#include <stdarg.h>
#include <xkbcommon/xkbcommon.h>
#include <xkbcommon/xkbcommon-keysyms.h>
#include <xkbcommon/xkbcommon-compose.h>

static void _log_handler(void *user_data,
                         enum xkb_log_level level,
                         const char *message);

static void _log_handler_internal(
    struct xkb_context *context,
    enum xkb_log_level level,
    const char *format,
    va_list args)
{
  char buf[1024];
  void *user_data;

  user_data=xkb_context_get_user_data(context);
  vsnprintf(buf, 1024, format, args);
  buf[1023]=0;
  _log_handler(user_data, level, buf);
}

void _set_log_handler_internal(struct xkb_context *context)
{
  xkb_context_set_log_fn(context, _log_handler_internal);
}



/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 38), // char *()(struct xkb_keymap *, enum xkb_keymap_format)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 305), // struct xkb_keymap *
/*  2 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // enum xkb_keymap_format
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 46), // char const *()(struct xkb_context *, unsigned int)
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 304), // struct xkb_context *
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 46), // char const *()(struct xkb_keymap *, uint32_t)
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 299), // enum xkb_compose_feed_result()(struct xkb_compose_state *, uint32_t)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 302), // struct xkb_compose_state *
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 300), // enum xkb_compose_status()(struct xkb_compose_state *)
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 253), // enum xkb_log_level()(struct xkb_context *)
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 66), // enum xkb_state_component()(struct xkb_state *, uint32_t, enum xkb_key_direction)
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 307), // struct xkb_state *
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 25 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // enum xkb_key_direction
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 66), // enum xkb_state_component()(struct xkb_state *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 31 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 33 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_compose_state *, char *, size_t)
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 38 */ _CFFI_OP(_CFFI_OP_POINTER, 298), // char *
/* 39 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_context *)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_context *, char const *)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 46 */ _CFFI_OP(_CFFI_OP_POINTER, 298), // char const *
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_keymap *, uint32_t)
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 50 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_keymap *, uint32_t, uint32_t, uint32_t, uint32_t const * *)
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 55 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 56 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 57 */ _CFFI_OP(_CFFI_OP_POINTER, 308), // uint32_t const * *
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, char const *)
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, char const *, enum xkb_state_component)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 66 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // enum xkb_state_component
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, enum xkb_state_component, enum xkb_state_match, ...)
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 71 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // enum xkb_state_match
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, uint32_t)
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 75 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, uint32_t, char *, size_t)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 79 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, uint32_t, enum xkb_state_component)
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 85 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, uint32_t, uint32_t const * *)
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 90 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, uint32_t, uint32_t)
/* 94 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 95 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 96 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(struct xkb_state *, uint32_t, uint32_t, enum xkb_consumed_mode)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 100 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 101 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 102 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // enum xkb_consumed_mode
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 263), // int()(uint32_t, char *, size_t)
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 39), // size_t()(struct xkb_keymap *, uint32_t, uint32_t, uint32_t, uint32_t *, size_t)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 111 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 113 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 114 */ _CFFI_OP(_CFFI_OP_POINTER, 10), // uint32_t *
/* 115 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct xkb_compose_state *()(struct xkb_compose_state *)
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct xkb_compose_state *()(struct xkb_compose_table *, enum xkb_compose_state_flags)
/* 121 */ _CFFI_OP(_CFFI_OP_POINTER, 303), // struct xkb_compose_table *
/* 122 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum xkb_compose_state_flags
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // struct xkb_compose_table *()(struct xkb_compose_state *)
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // struct xkb_compose_table *()(struct xkb_compose_table *)
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // struct xkb_compose_table *()(struct xkb_context *, FILE *, char const *, enum xkb_compose_format, enum xkb_compose_compile_flags)
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 132 */ _CFFI_OP(_CFFI_OP_POINTER, 297), // FILE *
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 134 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum xkb_compose_format
/* 135 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum xkb_compose_compile_flags
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // struct xkb_compose_table *()(struct xkb_context *, char const *, enum xkb_compose_compile_flags)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 139 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 135),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // struct xkb_compose_table *()(struct xkb_context *, char const *, size_t, char const *, enum xkb_compose_format, enum xkb_compose_compile_flags)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 145 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 135),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // struct xkb_context *()(enum xkb_context_flags)
/* 151 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // enum xkb_context_flags
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // struct xkb_context *()(struct xkb_context *)
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct xkb_keymap *()(struct xkb_context *, FILE *, enum xkb_keymap_format, enum xkb_keymap_compile_flags)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 160 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // enum xkb_keymap_compile_flags
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct xkb_keymap *()(struct xkb_context *, char const *, enum xkb_keymap_format, enum xkb_keymap_compile_flags)
/* 163 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct xkb_keymap *()(struct xkb_context *, char const *, size_t, enum xkb_keymap_format, enum xkb_keymap_compile_flags)
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 171 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct xkb_keymap *()(struct xkb_context *, struct xkb_rule_names const *, enum xkb_keymap_compile_flags)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 177 */ _CFFI_OP(_CFFI_OP_POINTER, 306), // struct xkb_rule_names const *
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct xkb_keymap *()(struct xkb_keymap *)
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct xkb_keymap *()(struct xkb_state *)
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // struct xkb_state *()(struct xkb_keymap *)
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // struct xkb_state *()(struct xkb_state *)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(char const *, enum xkb_keysym_flags)
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 194 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // enum xkb_keysym_flags
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_compose_state *)
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_keymap *)
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_keymap *, char const *)
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_keymap *, uint32_t)
/* 207 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 208 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_keymap *, uint32_t, uint32_t)
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 213 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_state *, enum xkb_state_component)
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_state *, uint32_t)
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 221 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_state *, uint32_t, enum xkb_consumed_mode)
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 225 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 102),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 228 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(struct xkb_state *, uint32_t, uint32_t)
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // uint32_t()(uint32_t)
/* 234 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // unsigned int()(struct xkb_context *)
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void *()(struct xkb_context *)
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_compose_state *)
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_compose_table *)
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_context *)
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 250 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_context *, enum xkb_log_level)
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 253 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // enum xkb_log_level
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_context *, enum xkb_log_level, char const *, va_list)
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 257 */ _CFFI_OP(_CFFI_OP_NOOP, 253),
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 259 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // va_list
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_context *, int)
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_context *, void *)
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 267 */ _CFFI_OP(_CFFI_OP_POINTER, 310), // void *
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_context *, void(*)(struct xkb_context *, enum xkb_log_level, char const *, va_list))
/* 270 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 271 */ _CFFI_OP(_CFFI_OP_POINTER, 255), // void(*)(struct xkb_context *, enum xkb_log_level, char const *, va_list)
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_keymap *)
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 275 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_keymap *, uint32_t, void *)
/* 277 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 267),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_keymap *, void(*)(struct xkb_keymap *, uint32_t, void *), void *)
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 283 */ _CFFI_OP(_CFFI_OP_POINTER, 276), // void(*)(struct xkb_keymap *, uint32_t, void *)
/* 284 */ _CFFI_OP(_CFFI_OP_NOOP, 267),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 286 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(struct xkb_state *)
/* 287 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(void *)
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 267),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 310), // void()(void *, enum xkb_log_level, char const *)
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 267),
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 253),
/* 295 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 297 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // FILE
/* 298 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 299 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum xkb_compose_feed_result
/* 300 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum xkb_compose_status
/* 301 */ _CFFI_OP(_CFFI_OP_POINTER, 68), // int(*)(struct xkb_state *, enum xkb_state_component, enum xkb_state_match, ...)
/* 302 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct xkb_compose_state
/* 303 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct xkb_compose_table
/* 304 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct xkb_context
/* 305 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct xkb_keymap
/* 306 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct xkb_rule_names
/* 307 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct xkb_state
/* 308 */ _CFFI_OP(_CFFI_OP_POINTER, 10), // uint32_t const *
/* 309 */ _CFFI_OP(_CFFI_OP_POINTER, 292), // void(*)(void *, enum xkb_log_level, char const *)
/* 310 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPILE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_IGNORED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_IGNORED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_IGNORED) | 0);  /* check that XKB_COMPOSE_FEED_IGNORED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_ACCEPTED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_ACCEPTED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_ACCEPTED) | 0);  /* check that XKB_COMPOSE_FEED_ACCEPTED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FORMAT_TEXT_V1) | 0);  /* check that XKB_COMPOSE_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_STATE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_STATE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_STATE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_STATE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_NOTHING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_NOTHING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_NOTHING) | 0);  /* check that XKB_COMPOSE_NOTHING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSING) | 0);  /* check that XKB_COMPOSE_COMPOSING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSED) | 0);  /* check that XKB_COMPOSE_COMPOSED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_CANCELLED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_CANCELLED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_CANCELLED) | 0);  /* check that XKB_COMPOSE_CANCELLED is an integer */
  return n;
}

static int _cffi_const_XKB_CONSUMED_MODE_XKB(unsigned long long *o)
{
  int n = (XKB_CONSUMED_MODE_XKB) <= 0;
  *o = (unsigned long long)((XKB_CONSUMED_MODE_XKB) | 0);  /* check that XKB_CONSUMED_MODE_XKB is an integer */
  return n;
}

static int _cffi_const_XKB_CONSUMED_MODE_GTK(unsigned long long *o)
{
  int n = (XKB_CONSUMED_MODE_GTK) <= 0;
  *o = (unsigned long long)((XKB_CONSUMED_MODE_GTK) | 0);  /* check that XKB_CONSUMED_MODE_GTK is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_FLAGS) | 0);  /* check that XKB_CONTEXT_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_DEFAULT_INCLUDES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_DEFAULT_INCLUDES) | 0);  /* check that XKB_CONTEXT_NO_DEFAULT_INCLUDES is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_ENVIRONMENT_NAMES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_ENVIRONMENT_NAMES) | 0);  /* check that XKB_CONTEXT_NO_ENVIRONMENT_NAMES is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_SECURE_GETENV(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_SECURE_GETENV) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_SECURE_GETENV) | 0);  /* check that XKB_CONTEXT_NO_SECURE_GETENV is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_UP(unsigned long long *o)
{
  int n = (XKB_KEY_UP) <= 0;
  *o = (unsigned long long)((XKB_KEY_UP) | 0);  /* check that XKB_KEY_UP is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_DOWN(unsigned long long *o)
{
  int n = (XKB_KEY_DOWN) <= 0;
  *o = (unsigned long long)((XKB_KEY_DOWN) | 0);  /* check that XKB_KEY_DOWN is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYMAP_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_COMPILE_NO_FLAGS) | 0);  /* check that XKB_KEYMAP_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_KEYMAP_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_FORMAT_TEXT_V1) | 0);  /* check that XKB_KEYMAP_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYSYM_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_NO_FLAGS) | 0);  /* check that XKB_KEYSYM_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_CASE_INSENSITIVE(unsigned long long *o)
{
  int n = (XKB_KEYSYM_CASE_INSENSITIVE) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_CASE_INSENSITIVE) | 0);  /* check that XKB_KEYSYM_CASE_INSENSITIVE is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_CRITICAL(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_CRITICAL) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_CRITICAL) | 0);  /* check that XKB_LOG_LEVEL_CRITICAL is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_ERROR(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_ERROR) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_ERROR) | 0);  /* check that XKB_LOG_LEVEL_ERROR is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_WARNING(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_WARNING) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_WARNING) | 0);  /* check that XKB_LOG_LEVEL_WARNING is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_INFO(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_INFO) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_INFO) | 0);  /* check that XKB_LOG_LEVEL_INFO is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_DEBUG(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_DEBUG) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_DEBUG) | 0);  /* check that XKB_LOG_LEVEL_DEBUG is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_DEPRESSED) | 0);  /* check that XKB_STATE_MODS_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LATCHED) | 0);  /* check that XKB_STATE_MODS_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LOCKED) | 0);  /* check that XKB_STATE_MODS_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_EFFECTIVE) | 0);  /* check that XKB_STATE_MODS_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_DEPRESSED) | 0);  /* check that XKB_STATE_LAYOUT_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LATCHED) | 0);  /* check that XKB_STATE_LAYOUT_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LOCKED) | 0);  /* check that XKB_STATE_LAYOUT_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_EFFECTIVE) | 0);  /* check that XKB_STATE_LAYOUT_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LEDS(unsigned long long *o)
{
  int n = (XKB_STATE_LEDS) <= 0;
  *o = (unsigned long long)((XKB_STATE_LEDS) | 0);  /* check that XKB_STATE_LEDS is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ANY(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ANY) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ANY) | 0);  /* check that XKB_STATE_MATCH_ANY is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ALL(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ALL) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ALL) | 0);  /* check that XKB_STATE_MATCH_ALL is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_NON_EXCLUSIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_NON_EXCLUSIVE) | 0);  /* check that XKB_STATE_MATCH_NON_EXCLUSIVE is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___key_for_each_helper =
  { "xkbcommon._ffi._key_for_each_helper", 0, 0, 0 };

static void _key_for_each_helper(struct xkb_keymap * a0, uint32_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(struct xkb_keymap * *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___key_for_each_helper, p);
}

static struct _cffi_externpy_s _cffi_externpy___log_handler =
  { "xkbcommon._ffi._log_handler", 0, 0, 0 };

static void _log_handler(void * a0, enum xkb_log_level a1, char const * a2)
{
  char a[24];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(enum xkb_log_level *)(p + 8) = a1;
  *(char const * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___log_handler, p);
}

static void _cffi_d__set_log_handler_internal(struct xkb_context * x0)
{
  _set_log_handler_internal(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__set_log_handler_internal(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _set_log_handler_internal(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__set_log_handler_internal _cffi_d__set_log_handler_internal
#endif

static void _cffi_d_free(void * x0)
{
  free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(267), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(267), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_free _cffi_d_free
#endif

static enum xkb_compose_feed_result _cffi_d_xkb_compose_state_feed(struct xkb_compose_state * x0, uint32_t x1)
{
  return xkb_compose_state_feed(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_feed(PyObject *self, PyObject *args)
{
  struct xkb_compose_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum xkb_compose_feed_result result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_compose_state_feed", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_feed(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(299));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_feed _cffi_d_xkb_compose_state_feed
#endif

static struct xkb_compose_table * _cffi_d_xkb_compose_state_get_compose_table(struct xkb_compose_state * x0)
{
  return xkb_compose_state_get_compose_table(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_get_compose_table(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_table * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_get_compose_table(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_get_compose_table _cffi_d_xkb_compose_state_get_compose_table
#endif

static uint32_t _cffi_d_xkb_compose_state_get_one_sym(struct xkb_compose_state * x0)
{
  return xkb_compose_state_get_one_sym(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_get_one_sym(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_get_one_sym(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_get_one_sym _cffi_d_xkb_compose_state_get_one_sym
#endif

static enum xkb_compose_status _cffi_d_xkb_compose_state_get_status(struct xkb_compose_state * x0)
{
  return xkb_compose_state_get_status(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_get_status(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum xkb_compose_status result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_get_status(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(300));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_get_status _cffi_d_xkb_compose_state_get_status
#endif

static int _cffi_d_xkb_compose_state_get_utf8(struct xkb_compose_state * x0, char * x1, size_t x2)
{
  return xkb_compose_state_get_utf8(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_get_utf8(PyObject *self, PyObject *args)
{
  struct xkb_compose_state * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_compose_state_get_utf8", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_get_utf8(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_get_utf8 _cffi_d_xkb_compose_state_get_utf8
#endif

static struct xkb_compose_state * _cffi_d_xkb_compose_state_new(struct xkb_compose_table * x0, enum xkb_compose_state_flags x1)
{
  return xkb_compose_state_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_new(PyObject *self, PyObject *args)
{
  struct xkb_compose_table * x0;
  enum xkb_compose_state_flags x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_state * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_compose_state_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_table *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(122), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_new _cffi_d_xkb_compose_state_new
#endif

static struct xkb_compose_state * _cffi_d_xkb_compose_state_ref(struct xkb_compose_state * x0)
{
  return xkb_compose_state_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_ref(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_state * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_state_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_state_ref _cffi_d_xkb_compose_state_ref
#endif

static void _cffi_d_xkb_compose_state_reset(struct xkb_compose_state * x0)
{
  xkb_compose_state_reset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_reset(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_compose_state_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_compose_state_reset _cffi_d_xkb_compose_state_reset
#endif

static void _cffi_d_xkb_compose_state_unref(struct xkb_compose_state * x0)
{
  xkb_compose_state_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_state_unref(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_compose_state_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_compose_state_unref _cffi_d_xkb_compose_state_unref
#endif

static struct xkb_compose_table * _cffi_d_xkb_compose_table_new_from_buffer(struct xkb_context * x0, char const * x1, size_t x2, char const * x3, enum xkb_compose_format x4, enum xkb_compose_compile_flags x5)
{
  return xkb_compose_table_new_from_buffer(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_table_new_from_buffer(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  char const * x1;
  size_t x2;
  char const * x3;
  enum xkb_compose_format x4;
  enum xkb_compose_compile_flags x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_table * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "xkb_compose_table_new_from_buffer", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x4, _cffi_type(134), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(135), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_table_new_from_buffer(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_table_new_from_buffer _cffi_d_xkb_compose_table_new_from_buffer
#endif

static struct xkb_compose_table * _cffi_d_xkb_compose_table_new_from_file(struct xkb_context * x0, FILE * x1, char const * x2, enum xkb_compose_format x3, enum xkb_compose_compile_flags x4)
{
  return xkb_compose_table_new_from_file(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_table_new_from_file(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  FILE * x1;
  char const * x2;
  enum xkb_compose_format x3;
  enum xkb_compose_compile_flags x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_table * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "xkb_compose_table_new_from_file", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x3, _cffi_type(134), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(135), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_table_new_from_file(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_table_new_from_file _cffi_d_xkb_compose_table_new_from_file
#endif

static struct xkb_compose_table * _cffi_d_xkb_compose_table_new_from_locale(struct xkb_context * x0, char const * x1, enum xkb_compose_compile_flags x2)
{
  return xkb_compose_table_new_from_locale(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_table_new_from_locale(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  char const * x1;
  enum xkb_compose_compile_flags x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_table * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_compose_table_new_from_locale", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(135), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_table_new_from_locale(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_table_new_from_locale _cffi_d_xkb_compose_table_new_from_locale
#endif

static struct xkb_compose_table * _cffi_d_xkb_compose_table_ref(struct xkb_compose_table * x0)
{
  return xkb_compose_table_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_table_ref(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_table * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_compose_table * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_table *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_compose_table_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(121));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_compose_table_ref _cffi_d_xkb_compose_table_ref
#endif

static void _cffi_d_xkb_compose_table_unref(struct xkb_compose_table * x0)
{
  xkb_compose_table_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_compose_table_unref(PyObject *self, PyObject *arg0)
{
  struct xkb_compose_table * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_compose_table *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_compose_table_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_compose_table_unref _cffi_d_xkb_compose_table_unref
#endif

static enum xkb_log_level _cffi_d_xkb_context_get_log_level(struct xkb_context * x0)
{
  return xkb_context_get_log_level(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_get_log_level(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum xkb_log_level result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_get_log_level(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(253));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_get_log_level _cffi_d_xkb_context_get_log_level
#endif

static int _cffi_d_xkb_context_get_log_verbosity(struct xkb_context * x0)
{
  return xkb_context_get_log_verbosity(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_get_log_verbosity(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_get_log_verbosity(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_get_log_verbosity _cffi_d_xkb_context_get_log_verbosity
#endif

static void * _cffi_d_xkb_context_get_user_data(struct xkb_context * x0)
{
  return xkb_context_get_user_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_get_user_data(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_get_user_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(267));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_get_user_data _cffi_d_xkb_context_get_user_data
#endif

static int _cffi_d_xkb_context_include_path_append(struct xkb_context * x0, char const * x1)
{
  return xkb_context_include_path_append(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_include_path_append(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_context_include_path_append", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_include_path_append(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_include_path_append _cffi_d_xkb_context_include_path_append
#endif

static int _cffi_d_xkb_context_include_path_append_default(struct xkb_context * x0)
{
  return xkb_context_include_path_append_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_include_path_append_default(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_include_path_append_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_include_path_append_default _cffi_d_xkb_context_include_path_append_default
#endif

static void _cffi_d_xkb_context_include_path_clear(struct xkb_context * x0)
{
  xkb_context_include_path_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_include_path_clear(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_context_include_path_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_context_include_path_clear _cffi_d_xkb_context_include_path_clear
#endif

static char const * _cffi_d_xkb_context_include_path_get(struct xkb_context * x0, unsigned int x1)
{
  return xkb_context_include_path_get(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_include_path_get(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_context_include_path_get", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_include_path_get(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(46));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_include_path_get _cffi_d_xkb_context_include_path_get
#endif

static int _cffi_d_xkb_context_include_path_reset_defaults(struct xkb_context * x0)
{
  return xkb_context_include_path_reset_defaults(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_include_path_reset_defaults(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_include_path_reset_defaults(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_include_path_reset_defaults _cffi_d_xkb_context_include_path_reset_defaults
#endif

static struct xkb_context * _cffi_d_xkb_context_new(enum xkb_context_flags x0)
{
  return xkb_context_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_new(PyObject *self, PyObject *arg0)
{
  enum xkb_context_flags x0;
  struct xkb_context * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(151), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_new _cffi_d_xkb_context_new
#endif

static unsigned int _cffi_d_xkb_context_num_include_paths(struct xkb_context * x0)
{
  return xkb_context_num_include_paths(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_num_include_paths(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_num_include_paths(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_num_include_paths _cffi_d_xkb_context_num_include_paths
#endif

static struct xkb_context * _cffi_d_xkb_context_ref(struct xkb_context * x0)
{
  return xkb_context_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_ref(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_context * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_context_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_context_ref _cffi_d_xkb_context_ref
#endif

static void _cffi_d_xkb_context_set_log_fn(struct xkb_context * x0, void(* x1)(struct xkb_context *, enum xkb_log_level, char const *, va_list))
{
  xkb_context_set_log_fn(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_set_log_fn(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  void(* x1)(struct xkb_context *, enum xkb_log_level, char const *, va_list);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_context_set_log_fn", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct xkb_context *, enum xkb_log_level, char const *, va_list))_cffi_to_c_pointer(arg1, _cffi_type(271));
  if (x1 == (void(*)(struct xkb_context *, enum xkb_log_level, char const *, va_list))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_context_set_log_fn(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_context_set_log_fn _cffi_d_xkb_context_set_log_fn
#endif

static void _cffi_d_xkb_context_set_log_level(struct xkb_context * x0, enum xkb_log_level x1)
{
  xkb_context_set_log_level(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_set_log_level(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  enum xkb_log_level x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_context_set_log_level", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(253), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_context_set_log_level(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_context_set_log_level _cffi_d_xkb_context_set_log_level
#endif

static void _cffi_d_xkb_context_set_log_verbosity(struct xkb_context * x0, int x1)
{
  xkb_context_set_log_verbosity(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_set_log_verbosity(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_context_set_log_verbosity", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_context_set_log_verbosity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_context_set_log_verbosity _cffi_d_xkb_context_set_log_verbosity
#endif

static void _cffi_d_xkb_context_set_user_data(struct xkb_context * x0, void * x1)
{
  xkb_context_set_user_data(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_set_user_data(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_context_set_user_data", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(267), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(267), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_context_set_user_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_context_set_user_data _cffi_d_xkb_context_set_user_data
#endif

static void _cffi_d_xkb_context_unref(struct xkb_context * x0)
{
  xkb_context_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_context_unref(PyObject *self, PyObject *arg0)
{
  struct xkb_context * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_context_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_context_unref _cffi_d_xkb_context_unref
#endif

static char * _cffi_d_xkb_keymap_get_as_string(struct xkb_keymap * x0, enum xkb_keymap_format x1)
{
  return xkb_keymap_get_as_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_get_as_string(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  enum xkb_keymap_format x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_get_as_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(2), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_get_as_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(38));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_get_as_string _cffi_d_xkb_keymap_get_as_string
#endif

static uint32_t _cffi_d_xkb_keymap_key_by_name(struct xkb_keymap * x0, char const * x1)
{
  return xkb_keymap_key_by_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_key_by_name(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_key_by_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_key_by_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_key_by_name _cffi_d_xkb_keymap_key_by_name
#endif

static void _cffi_d_xkb_keymap_key_for_each(struct xkb_keymap * x0, void(* x1)(struct xkb_keymap *, uint32_t, void *), void * x2)
{
  xkb_keymap_key_for_each(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_key_for_each(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  void(* x1)(struct xkb_keymap *, uint32_t, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_key_for_each", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct xkb_keymap *, uint32_t, void *))_cffi_to_c_pointer(arg1, _cffi_type(283));
  if (x1 == (void(*)(struct xkb_keymap *, uint32_t, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(267), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(267), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_keymap_key_for_each(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_keymap_key_for_each _cffi_d_xkb_keymap_key_for_each
#endif

static size_t _cffi_d_xkb_keymap_key_get_mods_for_level(struct xkb_keymap * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t * x4, size_t x5)
{
  return xkb_keymap_key_get_mods_for_level(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_key_get_mods_for_level(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t * x4;
  size_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_key_get_mods_for_level", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_key_get_mods_for_level(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_key_get_mods_for_level _cffi_d_xkb_keymap_key_get_mods_for_level
#endif

static char const * _cffi_d_xkb_keymap_key_get_name(struct xkb_keymap * x0, uint32_t x1)
{
  return xkb_keymap_key_get_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_key_get_name(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_key_get_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_key_get_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(46));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_key_get_name _cffi_d_xkb_keymap_key_get_name
#endif

static int _cffi_d_xkb_keymap_key_get_syms_by_level(struct xkb_keymap * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t const * * x4)
{
  return xkb_keymap_key_get_syms_by_level(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_key_get_syms_by_level(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t const * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_key_get_syms_by_level", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (uint32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_key_get_syms_by_level(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_key_get_syms_by_level _cffi_d_xkb_keymap_key_get_syms_by_level
#endif

static int _cffi_d_xkb_keymap_key_repeats(struct xkb_keymap * x0, uint32_t x1)
{
  return xkb_keymap_key_repeats(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_key_repeats(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_key_repeats", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_key_repeats(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_key_repeats _cffi_d_xkb_keymap_key_repeats
#endif

static uint32_t _cffi_d_xkb_keymap_layout_get_index(struct xkb_keymap * x0, char const * x1)
{
  return xkb_keymap_layout_get_index(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_layout_get_index(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_layout_get_index", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_layout_get_index(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_layout_get_index _cffi_d_xkb_keymap_layout_get_index
#endif

static char const * _cffi_d_xkb_keymap_layout_get_name(struct xkb_keymap * x0, uint32_t x1)
{
  return xkb_keymap_layout_get_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_layout_get_name(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_layout_get_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_layout_get_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(46));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_layout_get_name _cffi_d_xkb_keymap_layout_get_name
#endif

static uint32_t _cffi_d_xkb_keymap_led_get_index(struct xkb_keymap * x0, char const * x1)
{
  return xkb_keymap_led_get_index(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_led_get_index(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_led_get_index", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_led_get_index(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_led_get_index _cffi_d_xkb_keymap_led_get_index
#endif

static char const * _cffi_d_xkb_keymap_led_get_name(struct xkb_keymap * x0, uint32_t x1)
{
  return xkb_keymap_led_get_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_led_get_name(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_led_get_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_led_get_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(46));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_led_get_name _cffi_d_xkb_keymap_led_get_name
#endif

static uint32_t _cffi_d_xkb_keymap_max_keycode(struct xkb_keymap * x0)
{
  return xkb_keymap_max_keycode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_max_keycode(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_max_keycode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_max_keycode _cffi_d_xkb_keymap_max_keycode
#endif

static uint32_t _cffi_d_xkb_keymap_min_keycode(struct xkb_keymap * x0)
{
  return xkb_keymap_min_keycode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_min_keycode(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_min_keycode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_min_keycode _cffi_d_xkb_keymap_min_keycode
#endif

static uint32_t _cffi_d_xkb_keymap_mod_get_index(struct xkb_keymap * x0, char const * x1)
{
  return xkb_keymap_mod_get_index(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_mod_get_index(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_mod_get_index", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_mod_get_index(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_mod_get_index _cffi_d_xkb_keymap_mod_get_index
#endif

static char const * _cffi_d_xkb_keymap_mod_get_name(struct xkb_keymap * x0, uint32_t x1)
{
  return xkb_keymap_mod_get_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_mod_get_name(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_mod_get_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_mod_get_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(46));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_mod_get_name _cffi_d_xkb_keymap_mod_get_name
#endif

static struct xkb_keymap * _cffi_d_xkb_keymap_new_from_buffer(struct xkb_context * x0, char const * x1, size_t x2, enum xkb_keymap_format x3, enum xkb_keymap_compile_flags x4)
{
  return xkb_keymap_new_from_buffer(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_new_from_buffer(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  char const * x1;
  size_t x2;
  enum xkb_keymap_format x3;
  enum xkb_keymap_compile_flags x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_keymap * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_new_from_buffer", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(2), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(160), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_new_from_buffer(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_new_from_buffer _cffi_d_xkb_keymap_new_from_buffer
#endif

static struct xkb_keymap * _cffi_d_xkb_keymap_new_from_file(struct xkb_context * x0, FILE * x1, enum xkb_keymap_format x2, enum xkb_keymap_compile_flags x3)
{
  return xkb_keymap_new_from_file(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_new_from_file(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  FILE * x1;
  enum xkb_keymap_format x2;
  enum xkb_keymap_compile_flags x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_keymap * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_new_from_file", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (FILE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(2), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(160), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_new_from_file(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_new_from_file _cffi_d_xkb_keymap_new_from_file
#endif

static struct xkb_keymap * _cffi_d_xkb_keymap_new_from_names(struct xkb_context * x0, struct xkb_rule_names const * x1, enum xkb_keymap_compile_flags x2)
{
  return xkb_keymap_new_from_names(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_new_from_names(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  struct xkb_rule_names const * x1;
  enum xkb_keymap_compile_flags x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_keymap * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_new_from_names", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(177), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct xkb_rule_names const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(177), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(160), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_new_from_names(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_new_from_names _cffi_d_xkb_keymap_new_from_names
#endif

static struct xkb_keymap * _cffi_d_xkb_keymap_new_from_string(struct xkb_context * x0, char const * x1, enum xkb_keymap_format x2, enum xkb_keymap_compile_flags x3)
{
  return xkb_keymap_new_from_string(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_new_from_string(PyObject *self, PyObject *args)
{
  struct xkb_context * x0;
  char const * x1;
  enum xkb_keymap_format x2;
  enum xkb_keymap_compile_flags x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_keymap * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_new_from_string", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_context *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(2), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(160), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_new_from_string(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_new_from_string _cffi_d_xkb_keymap_new_from_string
#endif

static uint32_t _cffi_d_xkb_keymap_num_layouts(struct xkb_keymap * x0)
{
  return xkb_keymap_num_layouts(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_num_layouts(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_num_layouts(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_num_layouts _cffi_d_xkb_keymap_num_layouts
#endif

static uint32_t _cffi_d_xkb_keymap_num_layouts_for_key(struct xkb_keymap * x0, uint32_t x1)
{
  return xkb_keymap_num_layouts_for_key(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_num_layouts_for_key(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_num_layouts_for_key", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_num_layouts_for_key(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_num_layouts_for_key _cffi_d_xkb_keymap_num_layouts_for_key
#endif

static uint32_t _cffi_d_xkb_keymap_num_leds(struct xkb_keymap * x0)
{
  return xkb_keymap_num_leds(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_num_leds(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_num_leds(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_num_leds _cffi_d_xkb_keymap_num_leds
#endif

static uint32_t _cffi_d_xkb_keymap_num_levels_for_key(struct xkb_keymap * x0, uint32_t x1, uint32_t x2)
{
  return xkb_keymap_num_levels_for_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_num_levels_for_key(PyObject *self, PyObject *args)
{
  struct xkb_keymap * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_keymap_num_levels_for_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_num_levels_for_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_num_levels_for_key _cffi_d_xkb_keymap_num_levels_for_key
#endif

static uint32_t _cffi_d_xkb_keymap_num_mods(struct xkb_keymap * x0)
{
  return xkb_keymap_num_mods(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_num_mods(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_num_mods(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_num_mods _cffi_d_xkb_keymap_num_mods
#endif

static struct xkb_keymap * _cffi_d_xkb_keymap_ref(struct xkb_keymap * x0)
{
  return xkb_keymap_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_ref(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_keymap * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keymap_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keymap_ref _cffi_d_xkb_keymap_ref
#endif

static void _cffi_d_xkb_keymap_unref(struct xkb_keymap * x0)
{
  xkb_keymap_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keymap_unref(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_keymap_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_keymap_unref _cffi_d_xkb_keymap_unref
#endif

static uint32_t _cffi_d_xkb_keysym_from_name(char const * x0, enum xkb_keysym_flags x1)
{
  return xkb_keysym_from_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keysym_from_name(PyObject *self, PyObject *args)
{
  char const * x0;
  enum xkb_keysym_flags x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_keysym_from_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(194), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keysym_from_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keysym_from_name _cffi_d_xkb_keysym_from_name
#endif

static int _cffi_d_xkb_keysym_get_name(uint32_t x0, char * x1, size_t x2)
{
  return xkb_keysym_get_name(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keysym_get_name(PyObject *self, PyObject *args)
{
  uint32_t x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_keysym_get_name", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keysym_get_name(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keysym_get_name _cffi_d_xkb_keysym_get_name
#endif

static uint32_t _cffi_d_xkb_keysym_to_lower(uint32_t x0)
{
  return xkb_keysym_to_lower(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keysym_to_lower(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keysym_to_lower(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keysym_to_lower _cffi_d_xkb_keysym_to_lower
#endif

static uint32_t _cffi_d_xkb_keysym_to_upper(uint32_t x0)
{
  return xkb_keysym_to_upper(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keysym_to_upper(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keysym_to_upper(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keysym_to_upper _cffi_d_xkb_keysym_to_upper
#endif

static uint32_t _cffi_d_xkb_keysym_to_utf32(uint32_t x0)
{
  return xkb_keysym_to_utf32(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keysym_to_utf32(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  uint32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keysym_to_utf32(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keysym_to_utf32 _cffi_d_xkb_keysym_to_utf32
#endif

static int _cffi_d_xkb_keysym_to_utf8(uint32_t x0, char * x1, size_t x2)
{
  return xkb_keysym_to_utf8(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_keysym_to_utf8(PyObject *self, PyObject *args)
{
  uint32_t x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_keysym_to_utf8", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_keysym_to_utf8(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_keysym_to_utf8 _cffi_d_xkb_keysym_to_utf8
#endif

static struct xkb_keymap * _cffi_d_xkb_state_get_keymap(struct xkb_state * x0)
{
  return xkb_state_get_keymap(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_get_keymap(PyObject *self, PyObject *arg0)
{
  struct xkb_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_keymap * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_get_keymap(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_get_keymap _cffi_d_xkb_state_get_keymap
#endif

static uint32_t _cffi_d_xkb_state_key_get_consumed_mods(struct xkb_state * x0, uint32_t x1)
{
  return xkb_state_key_get_consumed_mods(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_consumed_mods(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_consumed_mods", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_consumed_mods(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_consumed_mods _cffi_d_xkb_state_key_get_consumed_mods
#endif

static uint32_t _cffi_d_xkb_state_key_get_consumed_mods2(struct xkb_state * x0, uint32_t x1, enum xkb_consumed_mode x2)
{
  return xkb_state_key_get_consumed_mods2(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_consumed_mods2(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  enum xkb_consumed_mode x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_consumed_mods2", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(102), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_consumed_mods2(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_consumed_mods2 _cffi_d_xkb_state_key_get_consumed_mods2
#endif

static uint32_t _cffi_d_xkb_state_key_get_layout(struct xkb_state * x0, uint32_t x1)
{
  return xkb_state_key_get_layout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_layout(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_layout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_layout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_layout _cffi_d_xkb_state_key_get_layout
#endif

static uint32_t _cffi_d_xkb_state_key_get_level(struct xkb_state * x0, uint32_t x1, uint32_t x2)
{
  return xkb_state_key_get_level(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_level(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_level", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_level(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_level _cffi_d_xkb_state_key_get_level
#endif

static uint32_t _cffi_d_xkb_state_key_get_one_sym(struct xkb_state * x0, uint32_t x1)
{
  return xkb_state_key_get_one_sym(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_one_sym(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_one_sym", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_one_sym(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_one_sym _cffi_d_xkb_state_key_get_one_sym
#endif

static int _cffi_d_xkb_state_key_get_syms(struct xkb_state * x0, uint32_t x1, uint32_t const * * x2)
{
  return xkb_state_key_get_syms(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_syms(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  uint32_t const * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_syms", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_syms(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_syms _cffi_d_xkb_state_key_get_syms
#endif

static uint32_t _cffi_d_xkb_state_key_get_utf32(struct xkb_state * x0, uint32_t x1)
{
  return xkb_state_key_get_utf32(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_utf32(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_utf32", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_utf32(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_utf32 _cffi_d_xkb_state_key_get_utf32
#endif

static int _cffi_d_xkb_state_key_get_utf8(struct xkb_state * x0, uint32_t x1, char * x2, size_t x3)
{
  return xkb_state_key_get_utf8(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_key_get_utf8(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  char * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "xkb_state_key_get_utf8", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_key_get_utf8(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_key_get_utf8 _cffi_d_xkb_state_key_get_utf8
#endif

static int _cffi_d_xkb_state_layout_index_is_active(struct xkb_state * x0, uint32_t x1, enum xkb_state_component x2)
{
  return xkb_state_layout_index_is_active(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_layout_index_is_active(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  enum xkb_state_component x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_layout_index_is_active", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(66), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_layout_index_is_active(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_layout_index_is_active _cffi_d_xkb_state_layout_index_is_active
#endif

static int _cffi_d_xkb_state_layout_name_is_active(struct xkb_state * x0, char const * x1, enum xkb_state_component x2)
{
  return xkb_state_layout_name_is_active(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_layout_name_is_active(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  char const * x1;
  enum xkb_state_component x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_layout_name_is_active", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(66), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_layout_name_is_active(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_layout_name_is_active _cffi_d_xkb_state_layout_name_is_active
#endif

static int _cffi_d_xkb_state_led_index_is_active(struct xkb_state * x0, uint32_t x1)
{
  return xkb_state_led_index_is_active(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_led_index_is_active(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_led_index_is_active", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_led_index_is_active(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_led_index_is_active _cffi_d_xkb_state_led_index_is_active
#endif

static int _cffi_d_xkb_state_led_name_is_active(struct xkb_state * x0, char const * x1)
{
  return xkb_state_led_name_is_active(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_led_name_is_active(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_led_name_is_active", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_led_name_is_active(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_led_name_is_active _cffi_d_xkb_state_led_name_is_active
#endif

static int _cffi_d_xkb_state_mod_index_is_active(struct xkb_state * x0, uint32_t x1, enum xkb_state_component x2)
{
  return xkb_state_mod_index_is_active(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_mod_index_is_active(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  enum xkb_state_component x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_mod_index_is_active", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(66), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_mod_index_is_active(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_mod_index_is_active _cffi_d_xkb_state_mod_index_is_active
#endif

static int _cffi_d_xkb_state_mod_index_is_consumed(struct xkb_state * x0, uint32_t x1, uint32_t x2)
{
  return xkb_state_mod_index_is_consumed(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_mod_index_is_consumed(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_mod_index_is_consumed", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_mod_index_is_consumed(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_mod_index_is_consumed _cffi_d_xkb_state_mod_index_is_consumed
#endif

static int _cffi_d_xkb_state_mod_index_is_consumed2(struct xkb_state * x0, uint32_t x1, uint32_t x2, enum xkb_consumed_mode x3)
{
  return xkb_state_mod_index_is_consumed2(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_mod_index_is_consumed2(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  uint32_t x2;
  enum xkb_consumed_mode x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "xkb_state_mod_index_is_consumed2", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(102), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_mod_index_is_consumed2(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_mod_index_is_consumed2 _cffi_d_xkb_state_mod_index_is_consumed2
#endif

static void _cffi_const_xkb_state_mod_indices_are_active(char *o)
{
  *(int(* *)(struct xkb_state *, enum xkb_state_component, enum xkb_state_match, ...))o = xkb_state_mod_indices_are_active;
}

static uint32_t _cffi_d_xkb_state_mod_mask_remove_consumed(struct xkb_state * x0, uint32_t x1, uint32_t x2)
{
  return xkb_state_mod_mask_remove_consumed(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_mod_mask_remove_consumed(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_mod_mask_remove_consumed", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_mod_mask_remove_consumed(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_mod_mask_remove_consumed _cffi_d_xkb_state_mod_mask_remove_consumed
#endif

static int _cffi_d_xkb_state_mod_name_is_active(struct xkb_state * x0, char const * x1, enum xkb_state_component x2)
{
  return xkb_state_mod_name_is_active(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_mod_name_is_active(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  char const * x1;
  enum xkb_state_component x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_mod_name_is_active", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(66), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_mod_name_is_active(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_mod_name_is_active _cffi_d_xkb_state_mod_name_is_active
#endif

static void _cffi_const_xkb_state_mod_names_are_active(char *o)
{
  *(int(* *)(struct xkb_state *, enum xkb_state_component, enum xkb_state_match, ...))o = xkb_state_mod_names_are_active;
}

static struct xkb_state * _cffi_d_xkb_state_new(struct xkb_keymap * x0)
{
  return xkb_state_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_new(PyObject *self, PyObject *arg0)
{
  struct xkb_keymap * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_state * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_new _cffi_d_xkb_state_new
#endif

static struct xkb_state * _cffi_d_xkb_state_ref(struct xkb_state * x0)
{
  return xkb_state_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_ref(PyObject *self, PyObject *arg0)
{
  struct xkb_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct xkb_state * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_ref _cffi_d_xkb_state_ref
#endif

static uint32_t _cffi_d_xkb_state_serialize_layout(struct xkb_state * x0, enum xkb_state_component x1)
{
  return xkb_state_serialize_layout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_serialize_layout(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  enum xkb_state_component x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_serialize_layout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(66), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_serialize_layout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_serialize_layout _cffi_d_xkb_state_serialize_layout
#endif

static uint32_t _cffi_d_xkb_state_serialize_mods(struct xkb_state * x0, enum xkb_state_component x1)
{
  return xkb_state_serialize_mods(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_serialize_mods(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  enum xkb_state_component x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xkb_state_serialize_mods", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(66), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_serialize_mods(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_serialize_mods _cffi_d_xkb_state_serialize_mods
#endif

static void _cffi_d_xkb_state_unref(struct xkb_state * x0)
{
  xkb_state_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_unref(PyObject *self, PyObject *arg0)
{
  struct xkb_state * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xkb_state_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xkb_state_unref _cffi_d_xkb_state_unref
#endif

static enum xkb_state_component _cffi_d_xkb_state_update_key(struct xkb_state * x0, uint32_t x1, enum xkb_key_direction x2)
{
  return xkb_state_update_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_update_key(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  enum xkb_key_direction x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum xkb_state_component result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xkb_state_update_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(25), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_update_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(66));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_update_key _cffi_d_xkb_state_update_key
#endif

static enum xkb_state_component _cffi_d_xkb_state_update_mask(struct xkb_state * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6)
{
  return xkb_state_update_mask(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xkb_state_update_mask(PyObject *self, PyObject *args)
{
  struct xkb_state * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum xkb_state_component result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "xkb_state_update_mask", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct xkb_state *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xkb_state_update_mask(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(66));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xkb_state_update_mask _cffi_d_xkb_state_update_mask
#endif

static int _cffi_const_XKB_KEYCODE_INVALID(unsigned long long *o)
{
  int n = (XKB_KEYCODE_INVALID) <= 0;
  *o = (unsigned long long)((XKB_KEYCODE_INVALID) | 0);  /* check that XKB_KEYCODE_INVALID is an integer */
  return n;
}

static int _cffi_const_XKB_KEYCODE_MAX(unsigned long long *o)
{
  int n = (XKB_KEYCODE_MAX) <= 0;
  *o = (unsigned long long)((XKB_KEYCODE_MAX) | 0);  /* check that XKB_KEYCODE_MAX is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_USE_ORIGINAL_FORMAT(unsigned long long *o)
{
  int n = (XKB_KEYMAP_USE_ORIGINAL_FORMAT) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_USE_ORIGINAL_FORMAT) | 0);  /* check that XKB_KEYMAP_USE_ORIGINAL_FORMAT is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_NoSymbol(unsigned long long *o)
{
  int n = (XKB_KEY_NoSymbol) <= 0;
  *o = (unsigned long long)((XKB_KEY_NoSymbol) | 0);  /* check that XKB_KEY_NoSymbol is an integer */
  return n;
}

static int _cffi_const_XKB_LAYOUT_INVALID(unsigned long long *o)
{
  int n = (XKB_LAYOUT_INVALID) <= 0;
  *o = (unsigned long long)((XKB_LAYOUT_INVALID) | 0);  /* check that XKB_LAYOUT_INVALID is an integer */
  return n;
}

static int _cffi_const_XKB_LED_INVALID(unsigned long long *o)
{
  int n = (XKB_LED_INVALID) <= 0;
  *o = (unsigned long long)((XKB_LED_INVALID) | 0);  /* check that XKB_LED_INVALID is an integer */
  return n;
}

static int _cffi_const_XKB_LEVEL_INVALID(unsigned long long *o)
{
  int n = (XKB_LEVEL_INVALID) <= 0;
  *o = (unsigned long long)((XKB_LEVEL_INVALID) | 0);  /* check that XKB_LEVEL_INVALID is an integer */
  return n;
}

static int _cffi_const_XKB_MOD_INVALID(unsigned long long *o)
{
  int n = (XKB_MOD_INVALID) <= 0;
  *o = (unsigned long long)((XKB_MOD_INVALID) | 0);  /* check that XKB_MOD_INVALID is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_xkb_rule_names(struct xkb_rule_names *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->rules; (void)tmp; }
  { char const * *tmp = &p->model; (void)tmp; }
  { char const * *tmp = &p->layout; (void)tmp; }
  { char const * *tmp = &p->variant; (void)tmp; }
  { char const * *tmp = &p->options; (void)tmp; }
}
struct _cffi_align_struct_xkb_rule_names { char x; struct xkb_rule_names y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "XKB_COMPOSE_CANCELLED", (void *)_cffi_const_XKB_COMPOSE_CANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSED", (void *)_cffi_const_XKB_COMPOSE_COMPOSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSING", (void *)_cffi_const_XKB_COMPOSE_COMPOSING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_ACCEPTED", (void *)_cffi_const_XKB_COMPOSE_FEED_ACCEPTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_IGNORED", (void *)_cffi_const_XKB_COMPOSE_FEED_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_NOTHING", (void *)_cffi_const_XKB_COMPOSE_NOTHING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_STATE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_STATE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONSUMED_MODE_GTK", (void *)_cffi_const_XKB_CONSUMED_MODE_GTK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONSUMED_MODE_XKB", (void *)_cffi_const_XKB_CONSUMED_MODE_XKB, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_DEFAULT_INCLUDES", (void *)_cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_ENVIRONMENT_NAMES", (void *)_cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_FLAGS", (void *)_cffi_const_XKB_CONTEXT_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_SECURE_GETENV", (void *)_cffi_const_XKB_CONTEXT_NO_SECURE_GETENV, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYCODE_INVALID", (void *)_cffi_const_XKB_KEYCODE_INVALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_KEYCODE_MAX", (void *)_cffi_const_XKB_KEYCODE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_KEYMAP_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_USE_ORIGINAL_FORMAT", (void *)_cffi_const_XKB_KEYMAP_USE_ORIGINAL_FORMAT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_KEYSYM_CASE_INSENSITIVE", (void *)_cffi_const_XKB_KEYSYM_CASE_INSENSITIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_NO_FLAGS", (void *)_cffi_const_XKB_KEYSYM_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_DOWN", (void *)_cffi_const_XKB_KEY_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_NoSymbol", (void *)_cffi_const_XKB_KEY_NoSymbol, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_KEY_UP", (void *)_cffi_const_XKB_KEY_UP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LAYOUT_INVALID", (void *)_cffi_const_XKB_LAYOUT_INVALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_LED_INVALID", (void *)_cffi_const_XKB_LED_INVALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_LEVEL_INVALID", (void *)_cffi_const_XKB_LEVEL_INVALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_LOG_LEVEL_CRITICAL", (void *)_cffi_const_XKB_LOG_LEVEL_CRITICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_DEBUG", (void *)_cffi_const_XKB_LOG_LEVEL_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_ERROR", (void *)_cffi_const_XKB_LOG_LEVEL_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_INFO", (void *)_cffi_const_XKB_LOG_LEVEL_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_WARNING", (void *)_cffi_const_XKB_LOG_LEVEL_WARNING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_MOD_INVALID", (void *)_cffi_const_XKB_MOD_INVALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_DEPRESSED", (void *)_cffi_const_XKB_STATE_LAYOUT_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_EFFECTIVE", (void *)_cffi_const_XKB_STATE_LAYOUT_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LATCHED", (void *)_cffi_const_XKB_STATE_LAYOUT_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LOCKED", (void *)_cffi_const_XKB_STATE_LAYOUT_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LEDS", (void *)_cffi_const_XKB_STATE_LEDS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ALL", (void *)_cffi_const_XKB_STATE_MATCH_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ANY", (void *)_cffi_const_XKB_STATE_MATCH_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_NON_EXCLUSIVE", (void *)_cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_DEPRESSED", (void *)_cffi_const_XKB_STATE_MODS_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_EFFECTIVE", (void *)_cffi_const_XKB_STATE_MODS_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LATCHED", (void *)_cffi_const_XKB_STATE_MODS_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LOCKED", (void *)_cffi_const_XKB_STATE_MODS_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "_key_for_each_helper", (void *)&_cffi_externpy___key_for_each_helper, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 283), (void *)_key_for_each_helper },
  { "_log_handler", (void *)&_cffi_externpy___log_handler, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 309), (void *)_log_handler },
  { "_set_log_handler_internal", (void *)_cffi_f__set_log_handler_internal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 248), (void *)_cffi_d__set_log_handler_internal },
  { "free", (void *)_cffi_f_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 289), (void *)_cffi_d_free },
  { "xkb_compose_state_feed", (void *)_cffi_f_xkb_compose_state_feed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_xkb_compose_state_feed },
  { "xkb_compose_state_get_compose_table", (void *)_cffi_f_xkb_compose_state_get_compose_table, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 124), (void *)_cffi_d_xkb_compose_state_get_compose_table },
  { "xkb_compose_state_get_one_sym", (void *)_cffi_f_xkb_compose_state_get_one_sym, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 196), (void *)_cffi_d_xkb_compose_state_get_one_sym },
  { "xkb_compose_state_get_status", (void *)_cffi_f_xkb_compose_state_get_status, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 16), (void *)_cffi_d_xkb_compose_state_get_status },
  { "xkb_compose_state_get_utf8", (void *)_cffi_f_xkb_compose_state_get_utf8, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 36), (void *)_cffi_d_xkb_compose_state_get_utf8 },
  { "xkb_compose_state_new", (void *)_cffi_f_xkb_compose_state_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 120), (void *)_cffi_d_xkb_compose_state_new },
  { "xkb_compose_state_ref", (void *)_cffi_f_xkb_compose_state_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 117), (void *)_cffi_d_xkb_compose_state_ref },
  { "xkb_compose_state_reset", (void *)_cffi_f_xkb_compose_state_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 242), (void *)_cffi_d_xkb_compose_state_reset },
  { "xkb_compose_state_unref", (void *)_cffi_f_xkb_compose_state_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 242), (void *)_cffi_d_xkb_compose_state_unref },
  { "xkb_compose_table_new_from_buffer", (void *)_cffi_f_xkb_compose_table_new_from_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 142), (void *)_cffi_d_xkb_compose_table_new_from_buffer },
  { "xkb_compose_table_new_from_file", (void *)_cffi_f_xkb_compose_table_new_from_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 130), (void *)_cffi_d_xkb_compose_table_new_from_file },
  { "xkb_compose_table_new_from_locale", (void *)_cffi_f_xkb_compose_table_new_from_locale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 137), (void *)_cffi_d_xkb_compose_table_new_from_locale },
  { "xkb_compose_table_ref", (void *)_cffi_f_xkb_compose_table_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 127), (void *)_cffi_d_xkb_compose_table_ref },
  { "xkb_compose_table_unref", (void *)_cffi_f_xkb_compose_table_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 245), (void *)_cffi_d_xkb_compose_table_unref },
  { "xkb_context_get_log_level", (void *)_cffi_f_xkb_context_get_log_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 19), (void *)_cffi_d_xkb_context_get_log_level },
  { "xkb_context_get_log_verbosity", (void *)_cffi_f_xkb_context_get_log_verbosity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_xkb_context_get_log_verbosity },
  { "xkb_context_get_user_data", (void *)_cffi_f_xkb_context_get_user_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 239), (void *)_cffi_d_xkb_context_get_user_data },
  { "xkb_context_include_path_append", (void *)_cffi_f_xkb_context_include_path_append, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_xkb_context_include_path_append },
  { "xkb_context_include_path_append_default", (void *)_cffi_f_xkb_context_include_path_append_default, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_xkb_context_include_path_append_default },
  { "xkb_context_include_path_clear", (void *)_cffi_f_xkb_context_include_path_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 248), (void *)_cffi_d_xkb_context_include_path_clear },
  { "xkb_context_include_path_get", (void *)_cffi_f_xkb_context_include_path_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 4), (void *)_cffi_d_xkb_context_include_path_get },
  { "xkb_context_include_path_reset_defaults", (void *)_cffi_f_xkb_context_include_path_reset_defaults, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_xkb_context_include_path_reset_defaults },
  { "xkb_context_new", (void *)_cffi_f_xkb_context_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 150), (void *)_cffi_d_xkb_context_new },
  { "xkb_context_num_include_paths", (void *)_cffi_f_xkb_context_num_include_paths, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 236), (void *)_cffi_d_xkb_context_num_include_paths },
  { "xkb_context_ref", (void *)_cffi_f_xkb_context_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 153), (void *)_cffi_d_xkb_context_ref },
  { "xkb_context_set_log_fn", (void *)_cffi_f_xkb_context_set_log_fn, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 269), (void *)_cffi_d_xkb_context_set_log_fn },
  { "xkb_context_set_log_level", (void *)_cffi_f_xkb_context_set_log_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 251), (void *)_cffi_d_xkb_context_set_log_level },
  { "xkb_context_set_log_verbosity", (void *)_cffi_f_xkb_context_set_log_verbosity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 261), (void *)_cffi_d_xkb_context_set_log_verbosity },
  { "xkb_context_set_user_data", (void *)_cffi_f_xkb_context_set_user_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 265), (void *)_cffi_d_xkb_context_set_user_data },
  { "xkb_context_unref", (void *)_cffi_f_xkb_context_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 248), (void *)_cffi_d_xkb_context_unref },
  { "xkb_keymap_get_as_string", (void *)_cffi_f_xkb_keymap_get_as_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_xkb_keymap_get_as_string },
  { "xkb_keymap_key_by_name", (void *)_cffi_f_xkb_keymap_key_by_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 202), (void *)_cffi_d_xkb_keymap_key_by_name },
  { "xkb_keymap_key_for_each", (void *)_cffi_f_xkb_keymap_key_for_each, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 281), (void *)_cffi_d_xkb_keymap_key_for_each },
  { "xkb_keymap_key_get_mods_for_level", (void *)_cffi_f_xkb_keymap_key_get_mods_for_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_xkb_keymap_key_get_mods_for_level },
  { "xkb_keymap_key_get_name", (void *)_cffi_f_xkb_keymap_key_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_xkb_keymap_key_get_name },
  { "xkb_keymap_key_get_syms_by_level", (void *)_cffi_f_xkb_keymap_key_get_syms_by_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_xkb_keymap_key_get_syms_by_level },
  { "xkb_keymap_key_repeats", (void *)_cffi_f_xkb_keymap_key_repeats, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 48), (void *)_cffi_d_xkb_keymap_key_repeats },
  { "xkb_keymap_layout_get_index", (void *)_cffi_f_xkb_keymap_layout_get_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 202), (void *)_cffi_d_xkb_keymap_layout_get_index },
  { "xkb_keymap_layout_get_name", (void *)_cffi_f_xkb_keymap_layout_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_xkb_keymap_layout_get_name },
  { "xkb_keymap_led_get_index", (void *)_cffi_f_xkb_keymap_led_get_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 202), (void *)_cffi_d_xkb_keymap_led_get_index },
  { "xkb_keymap_led_get_name", (void *)_cffi_f_xkb_keymap_led_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_xkb_keymap_led_get_name },
  { "xkb_keymap_max_keycode", (void *)_cffi_f_xkb_keymap_max_keycode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 199), (void *)_cffi_d_xkb_keymap_max_keycode },
  { "xkb_keymap_min_keycode", (void *)_cffi_f_xkb_keymap_min_keycode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 199), (void *)_cffi_d_xkb_keymap_min_keycode },
  { "xkb_keymap_mod_get_index", (void *)_cffi_f_xkb_keymap_mod_get_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 202), (void *)_cffi_d_xkb_keymap_mod_get_index },
  { "xkb_keymap_mod_get_name", (void *)_cffi_f_xkb_keymap_mod_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_xkb_keymap_mod_get_name },
  { "xkb_keymap_new_from_buffer", (void *)_cffi_f_xkb_keymap_new_from_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 168), (void *)_cffi_d_xkb_keymap_new_from_buffer },
  { "xkb_keymap_new_from_file", (void *)_cffi_f_xkb_keymap_new_from_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_xkb_keymap_new_from_file },
  { "xkb_keymap_new_from_names", (void *)_cffi_f_xkb_keymap_new_from_names, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_xkb_keymap_new_from_names },
  { "xkb_keymap_new_from_string", (void *)_cffi_f_xkb_keymap_new_from_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 162), (void *)_cffi_d_xkb_keymap_new_from_string },
  { "xkb_keymap_num_layouts", (void *)_cffi_f_xkb_keymap_num_layouts, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 199), (void *)_cffi_d_xkb_keymap_num_layouts },
  { "xkb_keymap_num_layouts_for_key", (void *)_cffi_f_xkb_keymap_num_layouts_for_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 206), (void *)_cffi_d_xkb_keymap_num_layouts_for_key },
  { "xkb_keymap_num_leds", (void *)_cffi_f_xkb_keymap_num_leds, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 199), (void *)_cffi_d_xkb_keymap_num_leds },
  { "xkb_keymap_num_levels_for_key", (void *)_cffi_f_xkb_keymap_num_levels_for_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 210), (void *)_cffi_d_xkb_keymap_num_levels_for_key },
  { "xkb_keymap_num_mods", (void *)_cffi_f_xkb_keymap_num_mods, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 199), (void *)_cffi_d_xkb_keymap_num_mods },
  { "xkb_keymap_ref", (void *)_cffi_f_xkb_keymap_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 180), (void *)_cffi_d_xkb_keymap_ref },
  { "xkb_keymap_unref", (void *)_cffi_f_xkb_keymap_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 273), (void *)_cffi_d_xkb_keymap_unref },
  { "xkb_keysym_from_name", (void *)_cffi_f_xkb_keysym_from_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 192), (void *)_cffi_d_xkb_keysym_from_name },
  { "xkb_keysym_get_name", (void *)_cffi_f_xkb_keysym_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_xkb_keysym_get_name },
  { "xkb_keysym_to_lower", (void *)_cffi_f_xkb_keysym_to_lower, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 233), (void *)_cffi_d_xkb_keysym_to_lower },
  { "xkb_keysym_to_upper", (void *)_cffi_f_xkb_keysym_to_upper, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 233), (void *)_cffi_d_xkb_keysym_to_upper },
  { "xkb_keysym_to_utf32", (void *)_cffi_f_xkb_keysym_to_utf32, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 233), (void *)_cffi_d_xkb_keysym_to_utf32 },
  { "xkb_keysym_to_utf8", (void *)_cffi_f_xkb_keysym_to_utf8, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_xkb_keysym_to_utf8 },
  { "xkb_state_get_keymap", (void *)_cffi_f_xkb_state_get_keymap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_xkb_state_get_keymap },
  { "xkb_state_key_get_consumed_mods", (void *)_cffi_f_xkb_state_key_get_consumed_mods, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 219), (void *)_cffi_d_xkb_state_key_get_consumed_mods },
  { "xkb_state_key_get_consumed_mods2", (void *)_cffi_f_xkb_state_key_get_consumed_mods2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 223), (void *)_cffi_d_xkb_state_key_get_consumed_mods2 },
  { "xkb_state_key_get_layout", (void *)_cffi_f_xkb_state_key_get_layout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 219), (void *)_cffi_d_xkb_state_key_get_layout },
  { "xkb_state_key_get_level", (void *)_cffi_f_xkb_state_key_get_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 228), (void *)_cffi_d_xkb_state_key_get_level },
  { "xkb_state_key_get_one_sym", (void *)_cffi_f_xkb_state_key_get_one_sym, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 219), (void *)_cffi_d_xkb_state_key_get_one_sym },
  { "xkb_state_key_get_syms", (void *)_cffi_f_xkb_state_key_get_syms, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 88), (void *)_cffi_d_xkb_state_key_get_syms },
  { "xkb_state_key_get_utf32", (void *)_cffi_f_xkb_state_key_get_utf32, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 219), (void *)_cffi_d_xkb_state_key_get_utf32 },
  { "xkb_state_key_get_utf8", (void *)_cffi_f_xkb_state_key_get_utf8, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_xkb_state_key_get_utf8 },
  { "xkb_state_layout_index_is_active", (void *)_cffi_f_xkb_state_layout_index_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_xkb_state_layout_index_is_active },
  { "xkb_state_layout_name_is_active", (void *)_cffi_f_xkb_state_layout_name_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_xkb_state_layout_name_is_active },
  { "xkb_state_led_index_is_active", (void *)_cffi_f_xkb_state_led_index_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 73), (void *)_cffi_d_xkb_state_led_index_is_active },
  { "xkb_state_led_name_is_active", (void *)_cffi_f_xkb_state_led_name_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 59), (void *)_cffi_d_xkb_state_led_name_is_active },
  { "xkb_state_mod_index_is_active", (void *)_cffi_f_xkb_state_mod_index_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_xkb_state_mod_index_is_active },
  { "xkb_state_mod_index_is_consumed", (void *)_cffi_f_xkb_state_mod_index_is_consumed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 93), (void *)_cffi_d_xkb_state_mod_index_is_consumed },
  { "xkb_state_mod_index_is_consumed2", (void *)_cffi_f_xkb_state_mod_index_is_consumed2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 98), (void *)_cffi_d_xkb_state_mod_index_is_consumed2 },
  { "xkb_state_mod_indices_are_active", (void *)_cffi_const_xkb_state_mod_indices_are_active, _CFFI_OP(_CFFI_OP_CONSTANT, 301), (void *)0 },
  { "xkb_state_mod_mask_remove_consumed", (void *)_cffi_f_xkb_state_mod_mask_remove_consumed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 228), (void *)_cffi_d_xkb_state_mod_mask_remove_consumed },
  { "xkb_state_mod_name_is_active", (void *)_cffi_f_xkb_state_mod_name_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_xkb_state_mod_name_is_active },
  { "xkb_state_mod_names_are_active", (void *)_cffi_const_xkb_state_mod_names_are_active, _CFFI_OP(_CFFI_OP_CONSTANT, 301), (void *)0 },
  { "xkb_state_new", (void *)_cffi_f_xkb_state_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 186), (void *)_cffi_d_xkb_state_new },
  { "xkb_state_ref", (void *)_cffi_f_xkb_state_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 189), (void *)_cffi_d_xkb_state_ref },
  { "xkb_state_serialize_layout", (void *)_cffi_f_xkb_state_serialize_layout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 215), (void *)_cffi_d_xkb_state_serialize_layout },
  { "xkb_state_serialize_mods", (void *)_cffi_f_xkb_state_serialize_mods, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 215), (void *)_cffi_d_xkb_state_serialize_mods },
  { "xkb_state_unref", (void *)_cffi_f_xkb_state_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 286), (void *)_cffi_d_xkb_state_unref },
  { "xkb_state_update_key", (void *)_cffi_f_xkb_state_update_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 22), (void *)_cffi_d_xkb_state_update_key },
  { "xkb_state_update_mask", (void *)_cffi_f_xkb_state_update_mask, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_xkb_state_update_mask },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "rules", offsetof(struct xkb_rule_names, rules),
             sizeof(((struct xkb_rule_names *)0)->rules),
             _CFFI_OP(_CFFI_OP_NOOP, 46) },
  { "model", offsetof(struct xkb_rule_names, model),
             sizeof(((struct xkb_rule_names *)0)->model),
             _CFFI_OP(_CFFI_OP_NOOP, 46) },
  { "layout", offsetof(struct xkb_rule_names, layout),
              sizeof(((struct xkb_rule_names *)0)->layout),
              _CFFI_OP(_CFFI_OP_NOOP, 46) },
  { "variant", offsetof(struct xkb_rule_names, variant),
               sizeof(((struct xkb_rule_names *)0)->variant),
               _CFFI_OP(_CFFI_OP_NOOP, 46) },
  { "options", offsetof(struct xkb_rule_names, options),
               sizeof(((struct xkb_rule_names *)0)->options),
               _CFFI_OP(_CFFI_OP_NOOP, 46) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$FILE", 297, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$va_list", 259, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "xkb_compose_state", 302, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "xkb_compose_table", 303, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "xkb_context", 304, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "xkb_keymap", 305, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "xkb_rule_names", 306, _CFFI_F_CHECK_FIELDS,
    sizeof(struct xkb_rule_names), offsetof(struct _cffi_align_struct_xkb_rule_names, y), 0, 5 },
  { "xkb_state", 307, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "xkb_compose_compile_flags", 135, _cffi_prim_int(sizeof(enum xkb_compose_compile_flags), ((enum xkb_compose_compile_flags)-1) <= 0),
    "XKB_COMPOSE_COMPILE_NO_FLAGS" },
  { "xkb_compose_feed_result", 299, _cffi_prim_int(sizeof(enum xkb_compose_feed_result), ((enum xkb_compose_feed_result)-1) <= 0),
    "XKB_COMPOSE_FEED_IGNORED,XKB_COMPOSE_FEED_ACCEPTED" },
  { "xkb_compose_format", 134, _cffi_prim_int(sizeof(enum xkb_compose_format), ((enum xkb_compose_format)-1) <= 0),
    "XKB_COMPOSE_FORMAT_TEXT_V1" },
  { "xkb_compose_state_flags", 122, _cffi_prim_int(sizeof(enum xkb_compose_state_flags), ((enum xkb_compose_state_flags)-1) <= 0),
    "XKB_COMPOSE_STATE_NO_FLAGS" },
  { "xkb_compose_status", 300, _cffi_prim_int(sizeof(enum xkb_compose_status), ((enum xkb_compose_status)-1) <= 0),
    "XKB_COMPOSE_NOTHING,XKB_COMPOSE_COMPOSING,XKB_COMPOSE_COMPOSED,XKB_COMPOSE_CANCELLED" },
  { "xkb_consumed_mode", 102, _cffi_prim_int(sizeof(enum xkb_consumed_mode), ((enum xkb_consumed_mode)-1) <= 0),
    "XKB_CONSUMED_MODE_XKB,XKB_CONSUMED_MODE_GTK" },
  { "xkb_context_flags", 151, _cffi_prim_int(sizeof(enum xkb_context_flags), ((enum xkb_context_flags)-1) <= 0),
    "XKB_CONTEXT_NO_FLAGS,XKB_CONTEXT_NO_DEFAULT_INCLUDES,XKB_CONTEXT_NO_ENVIRONMENT_NAMES,XKB_CONTEXT_NO_SECURE_GETENV" },
  { "xkb_key_direction", 25, _cffi_prim_int(sizeof(enum xkb_key_direction), ((enum xkb_key_direction)-1) <= 0),
    "XKB_KEY_UP,XKB_KEY_DOWN" },
  { "xkb_keymap_compile_flags", 160, _cffi_prim_int(sizeof(enum xkb_keymap_compile_flags), ((enum xkb_keymap_compile_flags)-1) <= 0),
    "XKB_KEYMAP_COMPILE_NO_FLAGS" },
  { "xkb_keymap_format", 2, _cffi_prim_int(sizeof(enum xkb_keymap_format), ((enum xkb_keymap_format)-1) <= 0),
    "XKB_KEYMAP_FORMAT_TEXT_V1" },
  { "xkb_keysym_flags", 194, _cffi_prim_int(sizeof(enum xkb_keysym_flags), ((enum xkb_keysym_flags)-1) <= 0),
    "XKB_KEYSYM_NO_FLAGS,XKB_KEYSYM_CASE_INSENSITIVE" },
  { "xkb_log_level", 253, _cffi_prim_int(sizeof(enum xkb_log_level), ((enum xkb_log_level)-1) <= 0),
    "XKB_LOG_LEVEL_CRITICAL,XKB_LOG_LEVEL_ERROR,XKB_LOG_LEVEL_WARNING,XKB_LOG_LEVEL_INFO,XKB_LOG_LEVEL_DEBUG" },
  { "xkb_state_component", 66, _cffi_prim_int(sizeof(enum xkb_state_component), ((enum xkb_state_component)-1) <= 0),
    "XKB_STATE_MODS_DEPRESSED,XKB_STATE_MODS_LATCHED,XKB_STATE_MODS_LOCKED,XKB_STATE_MODS_EFFECTIVE,XKB_STATE_LAYOUT_DEPRESSED,XKB_STATE_LAYOUT_LATCHED,XKB_STATE_LAYOUT_LOCKED,XKB_STATE_LAYOUT_EFFECTIVE,XKB_STATE_LEDS" },
  { "xkb_state_match", 71, _cffi_prim_int(sizeof(enum xkb_state_match), ((enum xkb_state_match)-1) <= 0),
    "XKB_STATE_MATCH_ANY,XKB_STATE_MATCH_ALL,XKB_STATE_MATCH_NON_EXCLUSIVE" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "FILE", 297 },
  { "va_list", 259 },
  { "xkb_keycode_t", 10 },
  { "xkb_keymap_key_iter_t", 283 },
  { "xkb_keysym_t", 10 },
  { "xkb_layout_index_t", 10 },
  { "xkb_layout_mask_t", 10 },
  { "xkb_led_index_t", 10 },
  { "xkb_led_mask_t", 10 },
  { "xkb_level_index_t", 10 },
  { "xkb_mod_index_t", 10 },
  { "xkb_mod_mask_t", 10 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  139,  /* num_globals */
  8,  /* num_struct_unions */
  14,  /* num_enums */
  12,  /* num_typenames */
  NULL,  /* no includes */
  311,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__ffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__ffi(void) { return NULL; }
#  else
     init_ffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__ffi(void)
{
  return _cffi_init("xkbcommon._ffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_ffi(void)
{
  _cffi_init("xkbcommon._ffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
