#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
# include <WinSock2.h>
#else
# include <sys/types.h>
# include <sys/socket.h>
# include <netdb.h> /* struct hostent */
# include <netinet/in.h> /* struct sockaddr_in/sockaddr_in6 */
#endif
#include <ares_nameser.h>
#include <ares.h>


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 286), // ares_bool_t()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 288), // ares_status_t()(struct ares_channeldata *, int)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 306), // struct ares_channeldata *
/*  4 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // char const *()(int *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 4), // int *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // char const *()(int)
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // char const *()(int, void const *, char *, ares_socklen_t)
/* 13 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 14 */ _CFFI_OP(_CFFI_OP_POINTER, 344), // void const *
/* 15 */ _CFFI_OP(_CFFI_OP_POINTER, 289), // char *
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(ares_socklen_t), (
           ((ares_socklen_t)-1) | 0 /* check that ares_socklen_t is an integer type */
         ) <= 0)), // ares_socklen_t
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(ares_socket_t, int, void *)
/* 19 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(ares_socket_t), (
           ((ares_socket_t)-1) | 0 /* check that ares_socket_t is an integer type */
         ) <= 0)), // ares_socket_t
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 21 */ _CFFI_OP(_CFFI_OP_POINTER, 344), // void *
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *, int, int, unsigned short, int, unsigned char * *, int *)
/* 24 */ _CFFI_OP(_CFFI_OP_POINTER, 289), // char const *
/* 25 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 26 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 27 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6), // unsigned short
/* 28 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 281), // unsigned char * *
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *, int, int, unsigned short, int, unsigned char * *, int *, int)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 35 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6),
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int)
/* 43 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char const *, void *)
/* 46 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, int)
/* 51 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata * *)
/* 55 */ _CFFI_OP(_CFFI_OP_POINTER, 3), // struct ares_channeldata * *
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata * *, struct ares_channeldata *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata * *, struct ares_options *, int)
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 63 */ _CFFI_OP(_CFFI_OP_POINTER, 312), // struct ares_options *
/* 64 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata *)
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata *, ares_socket_t *, int)
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 71 */ _CFFI_OP(_CFFI_OP_POINTER, 19), // ares_socket_t *
/* 72 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata *, char const *, int, struct hostent * *)
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 78 */ _CFFI_OP(_CFFI_OP_POINTER, 247), // struct hostent * *
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata *, struct ares_addr_node * *)
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 82 */ _CFFI_OP(_CFFI_OP_POINTER, 86), // struct ares_addr_node * *
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata *, struct ares_addr_node *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 86 */ _CFFI_OP(_CFFI_OP_POINTER, 296), // struct ares_addr_node *
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct ares_channeldata *, struct ares_options *, int *)
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct ares_caa_reply * *)
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 340), // unsigned char const *
/* 95 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 96 */ _CFFI_OP(_CFFI_OP_POINTER, 304), // struct ares_caa_reply * *
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct ares_mx_reply * *)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 100 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 101 */ _CFFI_OP(_CFFI_OP_POINTER, 308), // struct ares_mx_reply * *
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct ares_naptr_reply * *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 106 */ _CFFI_OP(_CFFI_OP_POINTER, 310), // struct ares_naptr_reply * *
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct ares_soa_reply * *)
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 110 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 111 */ _CFFI_OP(_CFFI_OP_POINTER, 314), // struct ares_soa_reply * *
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct ares_srv_reply * *)
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 115 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 116 */ _CFFI_OP(_CFFI_OP_POINTER, 316), // struct ares_srv_reply * *
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct ares_txt_ext * *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 120 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 121 */ _CFFI_OP(_CFFI_OP_POINTER, 318), // struct ares_txt_ext * *
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct hostent * *)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 125 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct hostent * *, struct ares_addr6ttl *, int *)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 130 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 132 */ _CFFI_OP(_CFFI_OP_POINTER, 295), // struct ares_addr6ttl *
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, struct hostent * *, struct ares_addrttl *, int *)
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 137 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 303), // struct ares_addrttl *
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, int, void const *, int, int, struct hostent * *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 144 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 147 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, unsigned char const *, int, char * *, long *)
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 153 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 154 */ _CFFI_OP(_CFFI_OP_POINTER, 15), // char * *
/* 155 */ _CFFI_OP(_CFFI_OP_POINTER, 290), // long *
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(unsigned char const *, unsigned char const *, int, unsigned char * *, long *)
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 160 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 166), // struct timeval *()(struct ares_channeldata *, struct timeval *, struct timeval *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 166 */ _CFFI_OP(_CFFI_OP_POINTER, 330), // struct timeval *
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 166),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_addrinfo *)
/* 170 */ _CFFI_OP(_CFFI_OP_POINTER, 297), // struct ares_addrinfo *
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *)
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, ares_socket_t, ares_socket_t)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, char const *)
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, char const *, char const *, struct ares_addrinfo_hints const *, void(*)(void *, int, int, struct ares_addrinfo *), void *)
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 188 */ _CFFI_OP(_CFFI_OP_POINTER, 300), // struct ares_addrinfo_hints const *
/* 189 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // void(*)(void *, int, int, struct ares_addrinfo *)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, char const *, int, int, void(*)(void *, int, int, unsigned char *, int), void *)
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 196 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 197 */ _CFFI_OP(_CFFI_OP_POINTER, 277), // void(*)(void *, int, int, unsigned char *, int)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, char const *, int, void(*)(void *, int, int, struct hostent *), void *)
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 203 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 204 */ _CFFI_OP(_CFFI_OP_POINTER, 271), // void(*)(void *, int, int, struct hostent *)
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, int(*)(ares_socket_t, int, void *), void *)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 209 */ _CFFI_OP(_CFFI_OP_POINTER, 18), // int(*)(ares_socket_t, int, void *)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, struct sockaddr const *, ares_socklen_t, int, void(*)(void *, int, int, char *, char *), void *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 214 */ _CFFI_OP(_CFFI_OP_POINTER, 327), // struct sockaddr const *
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 216 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 217 */ _CFFI_OP(_CFFI_OP_POINTER, 258), // void(*)(void *, int, int, char *, char *)
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, unsigned char const *)
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, unsigned char const *, int, void(*)(void *, int, int, unsigned char *, int), void *)
/* 225 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 197),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, unsigned int)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 233 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_channeldata *, void const *, int, int, void(*)(void *, int, int, struct hostent *), void *)
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 239 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 204),
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct ares_options *)
/* 244 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(struct hostent *)
/* 247 */ _CFFI_OP(_CFFI_OP_POINTER, 322), // struct hostent *
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void *)
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void *, ares_socket_t, int, int)
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 256 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void *, int, int, char *, char *)
/* 259 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 261 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 263 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void *, int, int, struct ares_addrinfo *)
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 268 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 269 */ _CFFI_OP(_CFFI_OP_NOOP, 170),
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void *, int, int, struct hostent *)
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 273 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 274 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 247),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void *, int, int, unsigned char *, int)
/* 278 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 279 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 280 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 281 */ _CFFI_OP(_CFFI_OP_POINTER, 340), // unsigned char *
/* 282 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 283 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION, 344), // void()(void)
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 286 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ares_bool_t
/* 287 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // ares_evsys_t
/* 288 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // ares_status_t
/* 289 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9), // long
/* 291 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(sa_family_t), (
           ((sa_family_t)-1) | 0 /* check that sa_family_t is an integer type */
         ) <= 0)), // sa_family_t
/* 292 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 293 */ _CFFI_OP(_CFFI_OP_POINTER, 294), // struct apattern *
/* 294 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct apattern
/* 295 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct ares_addr6ttl
/* 296 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct ares_addr_node
/* 297 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct ares_addrinfo
/* 298 */ _CFFI_OP(_CFFI_OP_POINTER, 299), // struct ares_addrinfo_cname *
/* 299 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct ares_addrinfo_cname
/* 300 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct ares_addrinfo_hints
/* 301 */ _CFFI_OP(_CFFI_OP_POINTER, 302), // struct ares_addrinfo_node *
/* 302 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct ares_addrinfo_node
/* 303 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct ares_addrttl
/* 304 */ _CFFI_OP(_CFFI_OP_POINTER, 305), // struct ares_caa_reply *
/* 305 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct ares_caa_reply
/* 306 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct ares_channeldata
/* 307 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct ares_in6_addr
/* 308 */ _CFFI_OP(_CFFI_OP_POINTER, 309), // struct ares_mx_reply *
/* 309 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct ares_mx_reply
/* 310 */ _CFFI_OP(_CFFI_OP_POINTER, 311), // struct ares_naptr_reply *
/* 311 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct ares_naptr_reply
/* 312 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct ares_options
/* 313 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct ares_server_failover_options
/* 314 */ _CFFI_OP(_CFFI_OP_POINTER, 315), // struct ares_soa_reply *
/* 315 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct ares_soa_reply
/* 316 */ _CFFI_OP(_CFFI_OP_POINTER, 317), // struct ares_srv_reply *
/* 317 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct ares_srv_reply
/* 318 */ _CFFI_OP(_CFFI_OP_POINTER, 319), // struct ares_txt_ext *
/* 319 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct ares_txt_ext
/* 320 */ _CFFI_OP(_CFFI_OP_POINTER, 321), // struct ares_txt_reply *
/* 321 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // struct ares_txt_reply
/* 322 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // struct hostent
/* 323 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct in6_addr
/* 324 */ _CFFI_OP(_CFFI_OP_POINTER, 325), // struct in_addr *
/* 325 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // struct in_addr
/* 326 */ _CFFI_OP(_CFFI_OP_POINTER, 327), // struct sockaddr *
/* 327 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct sockaddr
/* 328 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct sockaddr_in6
/* 329 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // struct sockaddr_in
/* 330 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // struct timeval
/* 331 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(suseconds_t), (
           ((suseconds_t)-1) | 0 /* check that suseconds_t is an integer type */
         ) <= 0)), // suseconds_t
/* 332 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 333 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 334 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 336 */ _CFFI_OP(_CFFI_OP_ARRAY, 335), // uint8_t[16]
/* 337 */ (_cffi_opcode_t)(16),
/* 338 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union $1
/* 339 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // union $2
/* 340 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 341 */ _CFFI_OP(_CFFI_OP_ARRAY, 340), // unsigned char[16]
/* 342 */ (_cffi_opcode_t)(16),
/* 343 */ _CFFI_OP(_CFFI_OP_POINTER, 252), // void(*)(void *, ares_socket_t, int, int)
/* 344 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_ARES_FALSE(unsigned long long *o)
{
  int n = (ARES_FALSE) <= 0;
  *o = (unsigned long long)((ARES_FALSE) | 0);  /* check that ARES_FALSE is an integer */
  return n;
}

static int _cffi_const_ARES_TRUE(unsigned long long *o)
{
  int n = (ARES_TRUE) <= 0;
  *o = (unsigned long long)((ARES_TRUE) | 0);  /* check that ARES_TRUE is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_DEFAULT(unsigned long long *o)
{
  int n = (ARES_EVSYS_DEFAULT) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_DEFAULT) | 0);  /* check that ARES_EVSYS_DEFAULT is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_WIN32(unsigned long long *o)
{
  int n = (ARES_EVSYS_WIN32) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_WIN32) | 0);  /* check that ARES_EVSYS_WIN32 is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_EPOLL(unsigned long long *o)
{
  int n = (ARES_EVSYS_EPOLL) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_EPOLL) | 0);  /* check that ARES_EVSYS_EPOLL is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_KQUEUE(unsigned long long *o)
{
  int n = (ARES_EVSYS_KQUEUE) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_KQUEUE) | 0);  /* check that ARES_EVSYS_KQUEUE is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_POLL(unsigned long long *o)
{
  int n = (ARES_EVSYS_POLL) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_POLL) | 0);  /* check that ARES_EVSYS_POLL is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_SELECT(unsigned long long *o)
{
  int n = (ARES_EVSYS_SELECT) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_SELECT) | 0);  /* check that ARES_EVSYS_SELECT is an integer */
  return n;
}

static int _cffi_const_ARES_SUCCESS(unsigned long long *o)
{
  int n = (ARES_SUCCESS) <= 0;
  *o = (unsigned long long)((ARES_SUCCESS) | 0);  /* check that ARES_SUCCESS is an integer */
  return n;
}

static int _cffi_const_ARES_ENODATA(unsigned long long *o)
{
  int n = (ARES_ENODATA) <= 0;
  *o = (unsigned long long)((ARES_ENODATA) | 0);  /* check that ARES_ENODATA is an integer */
  return n;
}

static int _cffi_const_ARES_EFORMERR(unsigned long long *o)
{
  int n = (ARES_EFORMERR) <= 0;
  *o = (unsigned long long)((ARES_EFORMERR) | 0);  /* check that ARES_EFORMERR is an integer */
  return n;
}

static int _cffi_const_ARES_ESERVFAIL(unsigned long long *o)
{
  int n = (ARES_ESERVFAIL) <= 0;
  *o = (unsigned long long)((ARES_ESERVFAIL) | 0);  /* check that ARES_ESERVFAIL is an integer */
  return n;
}

static int _cffi_const_ARES_ENOTFOUND(unsigned long long *o)
{
  int n = (ARES_ENOTFOUND) <= 0;
  *o = (unsigned long long)((ARES_ENOTFOUND) | 0);  /* check that ARES_ENOTFOUND is an integer */
  return n;
}

static int _cffi_const_ARES_ENOTIMP(unsigned long long *o)
{
  int n = (ARES_ENOTIMP) <= 0;
  *o = (unsigned long long)((ARES_ENOTIMP) | 0);  /* check that ARES_ENOTIMP is an integer */
  return n;
}

static int _cffi_const_ARES_EREFUSED(unsigned long long *o)
{
  int n = (ARES_EREFUSED) <= 0;
  *o = (unsigned long long)((ARES_EREFUSED) | 0);  /* check that ARES_EREFUSED is an integer */
  return n;
}

static int _cffi_const_ARES_EBADQUERY(unsigned long long *o)
{
  int n = (ARES_EBADQUERY) <= 0;
  *o = (unsigned long long)((ARES_EBADQUERY) | 0);  /* check that ARES_EBADQUERY is an integer */
  return n;
}

static int _cffi_const_ARES_EBADNAME(unsigned long long *o)
{
  int n = (ARES_EBADNAME) <= 0;
  *o = (unsigned long long)((ARES_EBADNAME) | 0);  /* check that ARES_EBADNAME is an integer */
  return n;
}

static int _cffi_const_ARES_EBADFAMILY(unsigned long long *o)
{
  int n = (ARES_EBADFAMILY) <= 0;
  *o = (unsigned long long)((ARES_EBADFAMILY) | 0);  /* check that ARES_EBADFAMILY is an integer */
  return n;
}

static int _cffi_const_ARES_EBADRESP(unsigned long long *o)
{
  int n = (ARES_EBADRESP) <= 0;
  *o = (unsigned long long)((ARES_EBADRESP) | 0);  /* check that ARES_EBADRESP is an integer */
  return n;
}

static int _cffi_const_ARES_ECONNREFUSED(unsigned long long *o)
{
  int n = (ARES_ECONNREFUSED) <= 0;
  *o = (unsigned long long)((ARES_ECONNREFUSED) | 0);  /* check that ARES_ECONNREFUSED is an integer */
  return n;
}

static int _cffi_const_ARES_ETIMEOUT(unsigned long long *o)
{
  int n = (ARES_ETIMEOUT) <= 0;
  *o = (unsigned long long)((ARES_ETIMEOUT) | 0);  /* check that ARES_ETIMEOUT is an integer */
  return n;
}

static int _cffi_const_ARES_EOF(unsigned long long *o)
{
  int n = (ARES_EOF) <= 0;
  *o = (unsigned long long)((ARES_EOF) | 0);  /* check that ARES_EOF is an integer */
  return n;
}

static int _cffi_const_ARES_EFILE(unsigned long long *o)
{
  int n = (ARES_EFILE) <= 0;
  *o = (unsigned long long)((ARES_EFILE) | 0);  /* check that ARES_EFILE is an integer */
  return n;
}

static int _cffi_const_ARES_ENOMEM(unsigned long long *o)
{
  int n = (ARES_ENOMEM) <= 0;
  *o = (unsigned long long)((ARES_ENOMEM) | 0);  /* check that ARES_ENOMEM is an integer */
  return n;
}

static int _cffi_const_ARES_EDESTRUCTION(unsigned long long *o)
{
  int n = (ARES_EDESTRUCTION) <= 0;
  *o = (unsigned long long)((ARES_EDESTRUCTION) | 0);  /* check that ARES_EDESTRUCTION is an integer */
  return n;
}

static int _cffi_const_ARES_EBADSTR(unsigned long long *o)
{
  int n = (ARES_EBADSTR) <= 0;
  *o = (unsigned long long)((ARES_EBADSTR) | 0);  /* check that ARES_EBADSTR is an integer */
  return n;
}

static int _cffi_const_ARES_EBADFLAGS(unsigned long long *o)
{
  int n = (ARES_EBADFLAGS) <= 0;
  *o = (unsigned long long)((ARES_EBADFLAGS) | 0);  /* check that ARES_EBADFLAGS is an integer */
  return n;
}

static int _cffi_const_ARES_ENONAME(unsigned long long *o)
{
  int n = (ARES_ENONAME) <= 0;
  *o = (unsigned long long)((ARES_ENONAME) | 0);  /* check that ARES_ENONAME is an integer */
  return n;
}

static int _cffi_const_ARES_EBADHINTS(unsigned long long *o)
{
  int n = (ARES_EBADHINTS) <= 0;
  *o = (unsigned long long)((ARES_EBADHINTS) | 0);  /* check that ARES_EBADHINTS is an integer */
  return n;
}

static int _cffi_const_ARES_ENOTINITIALIZED(unsigned long long *o)
{
  int n = (ARES_ENOTINITIALIZED) <= 0;
  *o = (unsigned long long)((ARES_ENOTINITIALIZED) | 0);  /* check that ARES_ENOTINITIALIZED is an integer */
  return n;
}

static int _cffi_const_ARES_ELOADIPHLPAPI(unsigned long long *o)
{
  int n = (ARES_ELOADIPHLPAPI) <= 0;
  *o = (unsigned long long)((ARES_ELOADIPHLPAPI) | 0);  /* check that ARES_ELOADIPHLPAPI is an integer */
  return n;
}

static int _cffi_const_ARES_EADDRGETNETWORKPARAMS(unsigned long long *o)
{
  int n = (ARES_EADDRGETNETWORKPARAMS) <= 0;
  *o = (unsigned long long)((ARES_EADDRGETNETWORKPARAMS) | 0);  /* check that ARES_EADDRGETNETWORKPARAMS is an integer */
  return n;
}

static int _cffi_const_ARES_ECANCELLED(unsigned long long *o)
{
  int n = (ARES_ECANCELLED) <= 0;
  *o = (unsigned long long)((ARES_ECANCELLED) | 0);  /* check that ARES_ECANCELLED is an integer */
  return n;
}

static int _cffi_const_ARES_ESERVICE(unsigned long long *o)
{
  int n = (ARES_ESERVICE) <= 0;
  *o = (unsigned long long)((ARES_ESERVICE) | 0);  /* check that ARES_ESERVICE is an integer */
  return n;
}

static int _cffi_const_ARES_ENOSERVER(unsigned long long *o)
{
  int n = (ARES_ENOSERVER) <= 0;
  *o = (unsigned long long)((ARES_ENOSERVER) | 0);  /* check that ARES_ENOSERVER is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___addrinfo_cb =
  { "_cares._addrinfo_cb", 0, 0, 0 };

static void _addrinfo_cb(void * a0, int a1, int a2, struct ares_addrinfo * a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(struct ares_addrinfo * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___addrinfo_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___host_cb =
  { "_cares._host_cb", 0, 0, 0 };

static void _host_cb(void * a0, int a1, int a2, struct hostent * a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(struct hostent * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___host_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___nameinfo_cb =
  { "_cares._nameinfo_cb", 0, 0, 0 };

static void _nameinfo_cb(void * a0, int a1, int a2, char * a3, char * a4)
{
  char a[40];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(char * *)(p + 24) = a3;
  *(char * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___nameinfo_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___query_cb =
  { "_cares._query_cb", 0, 0, 0 };

static void _query_cb(void * a0, int a1, int a2, unsigned char * a3, int a4)
{
  char a[40];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(unsigned char * *)(p + 24) = a3;
  *(int *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___query_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___sock_state_cb =
  { "_cares._sock_state_cb", 0, 0, 0 };

static void _sock_state_cb(void * a0, ares_socket_t a1, int a2, int a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(ares_socket_t *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(int *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___sock_state_cb, p);
}

static int _cffi_d_ARES_GETSOCK_READABLE(int x0, int x1)
{
  return ARES_GETSOCK_READABLE(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ARES_GETSOCK_READABLE(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ARES_GETSOCK_READABLE", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ARES_GETSOCK_READABLE(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ARES_GETSOCK_READABLE _cffi_d_ARES_GETSOCK_READABLE
#endif

static int _cffi_d_ARES_GETSOCK_WRITABLE(int x0, int x1)
{
  return ARES_GETSOCK_WRITABLE(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ARES_GETSOCK_WRITABLE(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ARES_GETSOCK_WRITABLE", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ARES_GETSOCK_WRITABLE(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ARES_GETSOCK_WRITABLE _cffi_d_ARES_GETSOCK_WRITABLE
#endif

static void _cffi_d_ares_cancel(struct ares_channeldata * x0)
{
  ares_cancel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_cancel(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_cancel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_cancel _cffi_d_ares_cancel
#endif

static int _cffi_d_ares_create_query(char const * x0, int x1, int x2, unsigned short x3, int x4, unsigned char * * x5, int * x6, int x7)
{
  return ares_create_query(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_create_query(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  int x2;
  unsigned short x3;
  int x4;
  unsigned char * * x5;
  int * x6;
  int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ares_create_query", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned short);
  if (x3 == (unsigned short)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_create_query(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_create_query _cffi_d_ares_create_query
#endif

static void _cffi_d_ares_destroy(struct ares_channeldata * x0)
{
  ares_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_destroy(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_destroy _cffi_d_ares_destroy
#endif

static void _cffi_d_ares_destroy_options(struct ares_options * x0)
{
  ares_destroy_options(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_destroy_options(PyObject *self, PyObject *arg0)
{
  struct ares_options * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_destroy_options(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_destroy_options _cffi_d_ares_destroy_options
#endif

static int _cffi_d_ares_dup(struct ares_channeldata * * x0, struct ares_channeldata * x1)
{
  return ares_dup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dup(PyObject *self, PyObject *args)
{
  struct ares_channeldata * * x0;
  struct ares_channeldata * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dup _cffi_d_ares_dup
#endif

static int _cffi_d_ares_expand_name(unsigned char const * x0, unsigned char const * x1, int x2, char * * x3, long * x4)
{
  return ares_expand_name(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_expand_name(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  unsigned char const * x1;
  int x2;
  char * * x3;
  long * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_expand_name", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_expand_name(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_expand_name _cffi_d_ares_expand_name
#endif

static int _cffi_d_ares_expand_string(unsigned char const * x0, unsigned char const * x1, int x2, unsigned char * * x3, long * x4)
{
  return ares_expand_string(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_expand_string(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  unsigned char const * x1;
  int x2;
  unsigned char * * x3;
  long * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_expand_string", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_expand_string(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_expand_string _cffi_d_ares_expand_string
#endif

static void _cffi_d_ares_free_data(void * x0)
{
  ares_free_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_free_data(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_free_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_free_data _cffi_d_ares_free_data
#endif

static void _cffi_d_ares_free_hostent(struct hostent * x0)
{
  ares_free_hostent(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_free_hostent(PyObject *self, PyObject *arg0)
{
  struct hostent * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(247), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct hostent *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(247), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_free_hostent(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_free_hostent _cffi_d_ares_free_hostent
#endif

static void _cffi_d_ares_free_string(void * x0)
{
  ares_free_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_free_string(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_free_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_free_string _cffi_d_ares_free_string
#endif

static void _cffi_d_ares_freeaddrinfo(struct ares_addrinfo * x0)
{
  ares_freeaddrinfo(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_freeaddrinfo(PyObject *self, PyObject *arg0)
{
  struct ares_addrinfo * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(170), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_addrinfo *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(170), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_freeaddrinfo(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_freeaddrinfo _cffi_d_ares_freeaddrinfo
#endif

static int _cffi_d_ares_get_servers(struct ares_channeldata * x0, struct ares_addr_node * * x1)
{
  return ares_get_servers(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_get_servers(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct ares_addr_node * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_get_servers", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(82), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_addr_node * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(82), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_get_servers(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_get_servers _cffi_d_ares_get_servers
#endif

static void _cffi_d_ares_getaddrinfo(struct ares_channeldata * x0, char const * x1, char const * x2, struct ares_addrinfo_hints const * x3, void(* x4)(void *, int, int, struct ares_addrinfo *), void * x5)
{
  ares_getaddrinfo(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_getaddrinfo(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  char const * x2;
  struct ares_addrinfo_hints const * x3;
  void(* x4)(void *, int, int, struct ares_addrinfo *);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_getaddrinfo", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(188), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct ares_addrinfo_hints const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(188), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(void *, int, int, struct ares_addrinfo *))_cffi_to_c_pointer(arg4, _cffi_type(189));
  if (x4 == (void(*)(void *, int, int, struct ares_addrinfo *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_getaddrinfo(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_getaddrinfo _cffi_d_ares_getaddrinfo
#endif

static void _cffi_d_ares_gethostbyaddr(struct ares_channeldata * x0, void const * x1, int x2, int x3, void(* x4)(void *, int, int, struct hostent *), void * x5)
{
  ares_gethostbyaddr(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_gethostbyaddr(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  void const * x1;
  int x2;
  int x3;
  void(* x4)(void *, int, int, struct hostent *);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_gethostbyaddr", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *, int, int, struct hostent *))_cffi_to_c_pointer(arg4, _cffi_type(204));
  if (x4 == (void(*)(void *, int, int, struct hostent *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_gethostbyaddr(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_gethostbyaddr _cffi_d_ares_gethostbyaddr
#endif

static void _cffi_d_ares_gethostbyname(struct ares_channeldata * x0, char const * x1, int x2, void(* x3)(void *, int, int, struct hostent *), void * x4)
{
  ares_gethostbyname(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_gethostbyname(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  int x2;
  void(* x3)(void *, int, int, struct hostent *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_gethostbyname", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *, int, int, struct hostent *))_cffi_to_c_pointer(arg3, _cffi_type(204));
  if (x3 == (void(*)(void *, int, int, struct hostent *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_gethostbyname(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_gethostbyname _cffi_d_ares_gethostbyname
#endif

static int _cffi_d_ares_gethostbyname_file(struct ares_channeldata * x0, char const * x1, int x2, struct hostent * * x3)
{
  return ares_gethostbyname_file(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_gethostbyname_file(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  int x2;
  struct hostent * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ares_gethostbyname_file", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct hostent * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_gethostbyname_file(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_gethostbyname_file _cffi_d_ares_gethostbyname_file
#endif

static void _cffi_d_ares_getnameinfo(struct ares_channeldata * x0, struct sockaddr const * x1, ares_socklen_t x2, int x3, void(* x4)(void *, int, int, char *, char *), void * x5)
{
  ares_getnameinfo(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_getnameinfo(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct sockaddr const * x1;
  ares_socklen_t x2;
  int x3;
  void(* x4)(void *, int, int, char *, char *);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_getnameinfo", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(214), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct sockaddr const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(214), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, ares_socklen_t);
  if (x2 == (ares_socklen_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *, int, int, char *, char *))_cffi_to_c_pointer(arg4, _cffi_type(217));
  if (x4 == (void(*)(void *, int, int, char *, char *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_getnameinfo(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_getnameinfo _cffi_d_ares_getnameinfo
#endif

static int _cffi_d_ares_getsock(struct ares_channeldata * x0, ares_socket_t * x1, int x2)
{
  return ares_getsock(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_getsock(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  ares_socket_t * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_getsock", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ares_socket_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_getsock(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_getsock _cffi_d_ares_getsock
#endif

static char const * _cffi_d_ares_inet_ntop(int x0, void const * x1, char * x2, ares_socklen_t x3)
{
  return ares_inet_ntop(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_inet_ntop(PyObject *self, PyObject *args)
{
  int x0;
  void const * x1;
  char * x2;
  ares_socklen_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ares_inet_ntop", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, ares_socklen_t);
  if (x3 == (ares_socklen_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_inet_ntop(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(24));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_inet_ntop _cffi_d_ares_inet_ntop
#endif

static int _cffi_d_ares_inet_pton(int x0, char const * x1, void * x2)
{
  return ares_inet_pton(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_inet_pton(PyObject *self, PyObject *args)
{
  int x0;
  char const * x1;
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_inet_pton", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_inet_pton(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_inet_pton _cffi_d_ares_inet_pton
#endif

static int _cffi_d_ares_init(struct ares_channeldata * * x0)
{
  return ares_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_init(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_init _cffi_d_ares_init
#endif

static int _cffi_d_ares_init_options(struct ares_channeldata * * x0, struct ares_options * x1, int x2)
{
  return ares_init_options(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_init_options(PyObject *self, PyObject *args)
{
  struct ares_channeldata * * x0;
  struct ares_options * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_init_options", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_init_options(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_init_options _cffi_d_ares_init_options
#endif

static void _cffi_d_ares_library_cleanup(void)
{
  ares_library_cleanup();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_library_cleanup(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_library_cleanup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_library_cleanup _cffi_d_ares_library_cleanup
#endif

static int _cffi_d_ares_library_init(int x0)
{
  return ares_library_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_library_init(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_library_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ares_library_init _cffi_d_ares_library_init
#endif

static int _cffi_d_ares_mkquery(char const * x0, int x1, int x2, unsigned short x3, int x4, unsigned char * * x5, int * x6)
{
  return ares_mkquery(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_mkquery(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  int x2;
  unsigned short x3;
  int x4;
  unsigned char * * x5;
  int * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ares_mkquery", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned short);
  if (x3 == (unsigned short)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_mkquery(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_mkquery _cffi_d_ares_mkquery
#endif

static int _cffi_d_ares_parse_a_reply(unsigned char const * x0, int x1, struct hostent * * x2, struct ares_addrttl * x3, int * x4)
{
  return ares_parse_a_reply(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_a_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct hostent * * x2;
  struct ares_addrttl * x3;
  int * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_parse_a_reply", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct hostent * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct ares_addrttl *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_a_reply(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_a_reply _cffi_d_ares_parse_a_reply
#endif

static int _cffi_d_ares_parse_aaaa_reply(unsigned char const * x0, int x1, struct hostent * * x2, struct ares_addr6ttl * x3, int * x4)
{
  return ares_parse_aaaa_reply(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_aaaa_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct hostent * * x2;
  struct ares_addr6ttl * x3;
  int * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_parse_aaaa_reply", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct hostent * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct ares_addr6ttl *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_aaaa_reply(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_aaaa_reply _cffi_d_ares_parse_aaaa_reply
#endif

static int _cffi_d_ares_parse_caa_reply(unsigned char const * x0, int x1, struct ares_caa_reply * * x2)
{
  return ares_parse_caa_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_caa_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct ares_caa_reply * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_caa_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ares_caa_reply * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_caa_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_caa_reply _cffi_d_ares_parse_caa_reply
#endif

static int _cffi_d_ares_parse_mx_reply(unsigned char const * x0, int x1, struct ares_mx_reply * * x2)
{
  return ares_parse_mx_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_mx_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct ares_mx_reply * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_mx_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ares_mx_reply * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_mx_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_mx_reply _cffi_d_ares_parse_mx_reply
#endif

static int _cffi_d_ares_parse_naptr_reply(unsigned char const * x0, int x1, struct ares_naptr_reply * * x2)
{
  return ares_parse_naptr_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_naptr_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct ares_naptr_reply * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_naptr_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(106), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ares_naptr_reply * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(106), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_naptr_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_naptr_reply _cffi_d_ares_parse_naptr_reply
#endif

static int _cffi_d_ares_parse_ns_reply(unsigned char const * x0, int x1, struct hostent * * x2)
{
  return ares_parse_ns_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_ns_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct hostent * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_ns_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct hostent * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_ns_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_ns_reply _cffi_d_ares_parse_ns_reply
#endif

static int _cffi_d_ares_parse_ptr_reply(unsigned char const * x0, int x1, void const * x2, int x3, int x4, struct hostent * * x5)
{
  return ares_parse_ptr_reply(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_ptr_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  void const * x2;
  int x3;
  int x4;
  struct hostent * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_parse_ptr_reply", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (struct hostent * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_ptr_reply(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_ptr_reply _cffi_d_ares_parse_ptr_reply
#endif

static int _cffi_d_ares_parse_soa_reply(unsigned char const * x0, int x1, struct ares_soa_reply * * x2)
{
  return ares_parse_soa_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_soa_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct ares_soa_reply * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_soa_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(111), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ares_soa_reply * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(111), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_soa_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_soa_reply _cffi_d_ares_parse_soa_reply
#endif

static int _cffi_d_ares_parse_srv_reply(unsigned char const * x0, int x1, struct ares_srv_reply * * x2)
{
  return ares_parse_srv_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_srv_reply(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct ares_srv_reply * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_srv_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ares_srv_reply * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_srv_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_srv_reply _cffi_d_ares_parse_srv_reply
#endif

static int _cffi_d_ares_parse_txt_reply_ext(unsigned char const * x0, int x1, struct ares_txt_ext * * x2)
{
  return ares_parse_txt_reply_ext(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_parse_txt_reply_ext(PyObject *self, PyObject *args)
{
  unsigned char const * x0;
  int x1;
  struct ares_txt_ext * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_parse_txt_reply_ext", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct ares_txt_ext * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_parse_txt_reply_ext(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_parse_txt_reply_ext _cffi_d_ares_parse_txt_reply_ext
#endif

static void _cffi_d_ares_process_fd(struct ares_channeldata * x0, ares_socket_t x1, ares_socket_t x2)
{
  ares_process_fd(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_process_fd(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  ares_socket_t x1;
  ares_socket_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_process_fd", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ares_socket_t);
  if (x1 == (ares_socket_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, ares_socket_t);
  if (x2 == (ares_socket_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_process_fd(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_process_fd _cffi_d_ares_process_fd
#endif

static void _cffi_d_ares_query(struct ares_channeldata * x0, char const * x1, int x2, int x3, void(* x4)(void *, int, int, unsigned char *, int), void * x5)
{
  ares_query(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_query(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  int x2;
  int x3;
  void(* x4)(void *, int, int, unsigned char *, int);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_query", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *, int, int, unsigned char *, int))_cffi_to_c_pointer(arg4, _cffi_type(197));
  if (x4 == (void(*)(void *, int, int, unsigned char *, int))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_query(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_query _cffi_d_ares_query
#endif

static ares_status_t _cffi_d_ares_queue_wait_empty(struct ares_channeldata * x0, int x1)
{
  return ares_queue_wait_empty(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_queue_wait_empty(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_queue_wait_empty", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_queue_wait_empty(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(288));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_queue_wait_empty _cffi_d_ares_queue_wait_empty
#endif

static int _cffi_d_ares_reinit(struct ares_channeldata * x0)
{
  return ares_reinit(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_reinit(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_reinit(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_reinit _cffi_d_ares_reinit
#endif

static int _cffi_d_ares_save_options(struct ares_channeldata * x0, struct ares_options * x1, int * x2)
{
  return ares_save_options(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_save_options(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct ares_options * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_save_options", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_save_options(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_save_options _cffi_d_ares_save_options
#endif

static void _cffi_d_ares_search(struct ares_channeldata * x0, char const * x1, int x2, int x3, void(* x4)(void *, int, int, unsigned char *, int), void * x5)
{
  ares_search(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_search(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  int x2;
  int x3;
  void(* x4)(void *, int, int, unsigned char *, int);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_search", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *, int, int, unsigned char *, int))_cffi_to_c_pointer(arg4, _cffi_type(197));
  if (x4 == (void(*)(void *, int, int, unsigned char *, int))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_search(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_search _cffi_d_ares_search
#endif

static void _cffi_d_ares_send(struct ares_channeldata * x0, unsigned char const * x1, int x2, void(* x3)(void *, int, int, unsigned char *, int), void * x4)
{
  ares_send(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_send(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  unsigned char const * x1;
  int x2;
  void(* x3)(void *, int, int, unsigned char *, int);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_send", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(void *, int, int, unsigned char *, int))_cffi_to_c_pointer(arg3, _cffi_type(197));
  if (x3 == (void(*)(void *, int, int, unsigned char *, int))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_send(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_send _cffi_d_ares_send
#endif

static void _cffi_d_ares_set_local_dev(struct ares_channeldata * x0, char const * x1)
{
  ares_set_local_dev(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_local_dev(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_local_dev", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(24), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(24), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_local_dev(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_local_dev _cffi_d_ares_set_local_dev
#endif

static void _cffi_d_ares_set_local_ip4(struct ares_channeldata * x0, unsigned int x1)
{
  ares_set_local_ip4(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_local_ip4(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_local_ip4", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_local_ip4(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_local_ip4 _cffi_d_ares_set_local_ip4
#endif

static void _cffi_d_ares_set_local_ip6(struct ares_channeldata * x0, unsigned char const * x1)
{
  ares_set_local_ip6(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_local_ip6(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_local_ip6", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_local_ip6(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_local_ip6 _cffi_d_ares_set_local_ip6
#endif

static int _cffi_d_ares_set_servers(struct ares_channeldata * x0, struct ares_addr_node * x1)
{
  return ares_set_servers(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_servers(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct ares_addr_node * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_servers", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_addr_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_set_servers(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_set_servers _cffi_d_ares_set_servers
#endif

static void _cffi_d_ares_set_socket_callback(struct ares_channeldata * x0, int(* x1)(ares_socket_t, int, void *), void * x2)
{
  ares_set_socket_callback(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_socket_callback(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  int(* x1)(ares_socket_t, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_set_socket_callback", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(ares_socket_t, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(209));
  if (x1 == (int(*)(ares_socket_t, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_socket_callback(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_socket_callback _cffi_d_ares_set_socket_callback
#endif

static char const * _cffi_d_ares_strerror(int x0)
{
  return ares_strerror(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_strerror(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_strerror(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(24));
  return pyresult;
}
#else
#  define _cffi_f_ares_strerror _cffi_d_ares_strerror
#endif

static ares_bool_t _cffi_d_ares_threadsafety(void)
{
  return ares_threadsafety();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_threadsafety(PyObject *self, PyObject *noarg)
{
  ares_bool_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_threadsafety(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(286));
  return pyresult;
}
#else
#  define _cffi_f_ares_threadsafety _cffi_d_ares_threadsafety
#endif

static struct timeval * _cffi_d_ares_timeout(struct ares_channeldata * x0, struct timeval * x1, struct timeval * x2)
{
  return ares_timeout(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_timeout(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct timeval * x1;
  struct timeval * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct timeval * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_timeout", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(166), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timeval *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(166), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(166), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct timeval *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(166), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_timeout(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(166));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_timeout _cffi_d_ares_timeout
#endif

static char const * _cffi_d_ares_version(int * x0)
{
  return ares_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_version(PyObject *self, PyObject *arg0)
{
  int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(24));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_version _cffi_d_ares_version
#endif

static int _cffi_const_ARES_AI_ADDRCONFIG(unsigned long long *o)
{
  int n = (ARES_AI_ADDRCONFIG) <= 0;
  *o = (unsigned long long)((ARES_AI_ADDRCONFIG) | 0);  /* check that ARES_AI_ADDRCONFIG is an integer */
  return n;
}

static int _cffi_const_ARES_AI_ALL(unsigned long long *o)
{
  int n = (ARES_AI_ALL) <= 0;
  *o = (unsigned long long)((ARES_AI_ALL) | 0);  /* check that ARES_AI_ALL is an integer */
  return n;
}

static int _cffi_const_ARES_AI_CANONIDN(unsigned long long *o)
{
  int n = (ARES_AI_CANONIDN) <= 0;
  *o = (unsigned long long)((ARES_AI_CANONIDN) | 0);  /* check that ARES_AI_CANONIDN is an integer */
  return n;
}

static int _cffi_const_ARES_AI_CANONNAME(unsigned long long *o)
{
  int n = (ARES_AI_CANONNAME) <= 0;
  *o = (unsigned long long)((ARES_AI_CANONNAME) | 0);  /* check that ARES_AI_CANONNAME is an integer */
  return n;
}

static int _cffi_const_ARES_AI_IDN(unsigned long long *o)
{
  int n = (ARES_AI_IDN) <= 0;
  *o = (unsigned long long)((ARES_AI_IDN) | 0);  /* check that ARES_AI_IDN is an integer */
  return n;
}

static int _cffi_const_ARES_AI_IDN_ALLOW_UNASSIGNED(unsigned long long *o)
{
  int n = (ARES_AI_IDN_ALLOW_UNASSIGNED) <= 0;
  *o = (unsigned long long)((ARES_AI_IDN_ALLOW_UNASSIGNED) | 0);  /* check that ARES_AI_IDN_ALLOW_UNASSIGNED is an integer */
  return n;
}

static int _cffi_const_ARES_AI_IDN_USE_STD3_ASCII_RULES(unsigned long long *o)
{
  int n = (ARES_AI_IDN_USE_STD3_ASCII_RULES) <= 0;
  *o = (unsigned long long)((ARES_AI_IDN_USE_STD3_ASCII_RULES) | 0);  /* check that ARES_AI_IDN_USE_STD3_ASCII_RULES is an integer */
  return n;
}

static int _cffi_const_ARES_AI_MASK(unsigned long long *o)
{
  int n = (ARES_AI_MASK) <= 0;
  *o = (unsigned long long)((ARES_AI_MASK) | 0);  /* check that ARES_AI_MASK is an integer */
  return n;
}

static int _cffi_const_ARES_AI_NUMERICHOST(unsigned long long *o)
{
  int n = (ARES_AI_NUMERICHOST) <= 0;
  *o = (unsigned long long)((ARES_AI_NUMERICHOST) | 0);  /* check that ARES_AI_NUMERICHOST is an integer */
  return n;
}

static int _cffi_const_ARES_AI_NUMERICSERV(unsigned long long *o)
{
  int n = (ARES_AI_NUMERICSERV) <= 0;
  *o = (unsigned long long)((ARES_AI_NUMERICSERV) | 0);  /* check that ARES_AI_NUMERICSERV is an integer */
  return n;
}

static int _cffi_const_ARES_AI_PASSIVE(unsigned long long *o)
{
  int n = (ARES_AI_PASSIVE) <= 0;
  *o = (unsigned long long)((ARES_AI_PASSIVE) | 0);  /* check that ARES_AI_PASSIVE is an integer */
  return n;
}

static int _cffi_const_ARES_AI_V4MAPPED(unsigned long long *o)
{
  int n = (ARES_AI_V4MAPPED) <= 0;
  *o = (unsigned long long)((ARES_AI_V4MAPPED) | 0);  /* check that ARES_AI_V4MAPPED is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_EDNS(unsigned long long *o)
{
  int n = (ARES_FLAG_EDNS) <= 0;
  *o = (unsigned long long)((ARES_FLAG_EDNS) | 0);  /* check that ARES_FLAG_EDNS is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_IGNTC(unsigned long long *o)
{
  int n = (ARES_FLAG_IGNTC) <= 0;
  *o = (unsigned long long)((ARES_FLAG_IGNTC) | 0);  /* check that ARES_FLAG_IGNTC is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NOALIASES(unsigned long long *o)
{
  int n = (ARES_FLAG_NOALIASES) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NOALIASES) | 0);  /* check that ARES_FLAG_NOALIASES is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NOCHECKRESP(unsigned long long *o)
{
  int n = (ARES_FLAG_NOCHECKRESP) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NOCHECKRESP) | 0);  /* check that ARES_FLAG_NOCHECKRESP is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NORECURSE(unsigned long long *o)
{
  int n = (ARES_FLAG_NORECURSE) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NORECURSE) | 0);  /* check that ARES_FLAG_NORECURSE is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NOSEARCH(unsigned long long *o)
{
  int n = (ARES_FLAG_NOSEARCH) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NOSEARCH) | 0);  /* check that ARES_FLAG_NOSEARCH is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NO_DFLT_SVR(unsigned long long *o)
{
  int n = (ARES_FLAG_NO_DFLT_SVR) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NO_DFLT_SVR) | 0);  /* check that ARES_FLAG_NO_DFLT_SVR is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_PRIMARY(unsigned long long *o)
{
  int n = (ARES_FLAG_PRIMARY) <= 0;
  *o = (unsigned long long)((ARES_FLAG_PRIMARY) | 0);  /* check that ARES_FLAG_PRIMARY is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_STAYOPEN(unsigned long long *o)
{
  int n = (ARES_FLAG_STAYOPEN) <= 0;
  *o = (unsigned long long)((ARES_FLAG_STAYOPEN) | 0);  /* check that ARES_FLAG_STAYOPEN is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_USEVC(unsigned long long *o)
{
  int n = (ARES_FLAG_USEVC) <= 0;
  *o = (unsigned long long)((ARES_FLAG_USEVC) | 0);  /* check that ARES_FLAG_USEVC is an integer */
  return n;
}

static int _cffi_const_ARES_GETSOCK_MAXNUM(unsigned long long *o)
{
  int n = (ARES_GETSOCK_MAXNUM) <= 0;
  *o = (unsigned long long)((ARES_GETSOCK_MAXNUM) | 0);  /* check that ARES_GETSOCK_MAXNUM is an integer */
  return n;
}

static int _cffi_const_ARES_LIB_INIT_ALL(unsigned long long *o)
{
  int n = (ARES_LIB_INIT_ALL) <= 0;
  *o = (unsigned long long)((ARES_LIB_INIT_ALL) | 0);  /* check that ARES_LIB_INIT_ALL is an integer */
  return n;
}

static int _cffi_const_ARES_NI_DCCP(unsigned long long *o)
{
  int n = (ARES_NI_DCCP) <= 0;
  *o = (unsigned long long)((ARES_NI_DCCP) | 0);  /* check that ARES_NI_DCCP is an integer */
  return n;
}

static int _cffi_const_ARES_NI_DGRAM(unsigned long long *o)
{
  int n = (ARES_NI_DGRAM) <= 0;
  *o = (unsigned long long)((ARES_NI_DGRAM) | 0);  /* check that ARES_NI_DGRAM is an integer */
  return n;
}

static int _cffi_const_ARES_NI_IDN(unsigned long long *o)
{
  int n = (ARES_NI_IDN) <= 0;
  *o = (unsigned long long)((ARES_NI_IDN) | 0);  /* check that ARES_NI_IDN is an integer */
  return n;
}

static int _cffi_const_ARES_NI_IDN_ALLOW_UNASSIGNED(unsigned long long *o)
{
  int n = (ARES_NI_IDN_ALLOW_UNASSIGNED) <= 0;
  *o = (unsigned long long)((ARES_NI_IDN_ALLOW_UNASSIGNED) | 0);  /* check that ARES_NI_IDN_ALLOW_UNASSIGNED is an integer */
  return n;
}

static int _cffi_const_ARES_NI_IDN_USE_STD3_ASCII_RULES(unsigned long long *o)
{
  int n = (ARES_NI_IDN_USE_STD3_ASCII_RULES) <= 0;
  *o = (unsigned long long)((ARES_NI_IDN_USE_STD3_ASCII_RULES) | 0);  /* check that ARES_NI_IDN_USE_STD3_ASCII_RULES is an integer */
  return n;
}

static int _cffi_const_ARES_NI_LOOKUPHOST(unsigned long long *o)
{
  int n = (ARES_NI_LOOKUPHOST) <= 0;
  *o = (unsigned long long)((ARES_NI_LOOKUPHOST) | 0);  /* check that ARES_NI_LOOKUPHOST is an integer */
  return n;
}

static int _cffi_const_ARES_NI_LOOKUPSERVICE(unsigned long long *o)
{
  int n = (ARES_NI_LOOKUPSERVICE) <= 0;
  *o = (unsigned long long)((ARES_NI_LOOKUPSERVICE) | 0);  /* check that ARES_NI_LOOKUPSERVICE is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NAMEREQD(unsigned long long *o)
{
  int n = (ARES_NI_NAMEREQD) <= 0;
  *o = (unsigned long long)((ARES_NI_NAMEREQD) | 0);  /* check that ARES_NI_NAMEREQD is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NOFQDN(unsigned long long *o)
{
  int n = (ARES_NI_NOFQDN) <= 0;
  *o = (unsigned long long)((ARES_NI_NOFQDN) | 0);  /* check that ARES_NI_NOFQDN is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NUMERICHOST(unsigned long long *o)
{
  int n = (ARES_NI_NUMERICHOST) <= 0;
  *o = (unsigned long long)((ARES_NI_NUMERICHOST) | 0);  /* check that ARES_NI_NUMERICHOST is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NUMERICSCOPE(unsigned long long *o)
{
  int n = (ARES_NI_NUMERICSCOPE) <= 0;
  *o = (unsigned long long)((ARES_NI_NUMERICSCOPE) | 0);  /* check that ARES_NI_NUMERICSCOPE is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NUMERICSERV(unsigned long long *o)
{
  int n = (ARES_NI_NUMERICSERV) <= 0;
  *o = (unsigned long long)((ARES_NI_NUMERICSERV) | 0);  /* check that ARES_NI_NUMERICSERV is an integer */
  return n;
}

static int _cffi_const_ARES_NI_SCTP(unsigned long long *o)
{
  int n = (ARES_NI_SCTP) <= 0;
  *o = (unsigned long long)((ARES_NI_SCTP) | 0);  /* check that ARES_NI_SCTP is an integer */
  return n;
}

static int _cffi_const_ARES_NI_TCP(unsigned long long *o)
{
  int n = (ARES_NI_TCP) <= 0;
  *o = (unsigned long long)((ARES_NI_TCP) | 0);  /* check that ARES_NI_TCP is an integer */
  return n;
}

static int _cffi_const_ARES_NI_UDP(unsigned long long *o)
{
  int n = (ARES_NI_UDP) <= 0;
  *o = (unsigned long long)((ARES_NI_UDP) | 0);  /* check that ARES_NI_UDP is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_DOMAINS(unsigned long long *o)
{
  int n = (ARES_OPT_DOMAINS) <= 0;
  *o = (unsigned long long)((ARES_OPT_DOMAINS) | 0);  /* check that ARES_OPT_DOMAINS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_EDNSPSZ(unsigned long long *o)
{
  int n = (ARES_OPT_EDNSPSZ) <= 0;
  *o = (unsigned long long)((ARES_OPT_EDNSPSZ) | 0);  /* check that ARES_OPT_EDNSPSZ is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_EVENT_THREAD(unsigned long long *o)
{
  int n = (ARES_OPT_EVENT_THREAD) <= 0;
  *o = (unsigned long long)((ARES_OPT_EVENT_THREAD) | 0);  /* check that ARES_OPT_EVENT_THREAD is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_FLAGS(unsigned long long *o)
{
  int n = (ARES_OPT_FLAGS) <= 0;
  *o = (unsigned long long)((ARES_OPT_FLAGS) | 0);  /* check that ARES_OPT_FLAGS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_LOOKUPS(unsigned long long *o)
{
  int n = (ARES_OPT_LOOKUPS) <= 0;
  *o = (unsigned long long)((ARES_OPT_LOOKUPS) | 0);  /* check that ARES_OPT_LOOKUPS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_NDOTS(unsigned long long *o)
{
  int n = (ARES_OPT_NDOTS) <= 0;
  *o = (unsigned long long)((ARES_OPT_NDOTS) | 0);  /* check that ARES_OPT_NDOTS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_RESOLVCONF(unsigned long long *o)
{
  int n = (ARES_OPT_RESOLVCONF) <= 0;
  *o = (unsigned long long)((ARES_OPT_RESOLVCONF) | 0);  /* check that ARES_OPT_RESOLVCONF is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_ROTATE(unsigned long long *o)
{
  int n = (ARES_OPT_ROTATE) <= 0;
  *o = (unsigned long long)((ARES_OPT_ROTATE) | 0);  /* check that ARES_OPT_ROTATE is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SERVERS(unsigned long long *o)
{
  int n = (ARES_OPT_SERVERS) <= 0;
  *o = (unsigned long long)((ARES_OPT_SERVERS) | 0);  /* check that ARES_OPT_SERVERS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SOCK_RCVBUF(unsigned long long *o)
{
  int n = (ARES_OPT_SOCK_RCVBUF) <= 0;
  *o = (unsigned long long)((ARES_OPT_SOCK_RCVBUF) | 0);  /* check that ARES_OPT_SOCK_RCVBUF is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SOCK_SNDBUF(unsigned long long *o)
{
  int n = (ARES_OPT_SOCK_SNDBUF) <= 0;
  *o = (unsigned long long)((ARES_OPT_SOCK_SNDBUF) | 0);  /* check that ARES_OPT_SOCK_SNDBUF is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SOCK_STATE_CB(unsigned long long *o)
{
  int n = (ARES_OPT_SOCK_STATE_CB) <= 0;
  *o = (unsigned long long)((ARES_OPT_SOCK_STATE_CB) | 0);  /* check that ARES_OPT_SOCK_STATE_CB is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SORTLIST(unsigned long long *o)
{
  int n = (ARES_OPT_SORTLIST) <= 0;
  *o = (unsigned long long)((ARES_OPT_SORTLIST) | 0);  /* check that ARES_OPT_SORTLIST is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TCP_PORT(unsigned long long *o)
{
  int n = (ARES_OPT_TCP_PORT) <= 0;
  *o = (unsigned long long)((ARES_OPT_TCP_PORT) | 0);  /* check that ARES_OPT_TCP_PORT is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TIMEOUT(unsigned long long *o)
{
  int n = (ARES_OPT_TIMEOUT) <= 0;
  *o = (unsigned long long)((ARES_OPT_TIMEOUT) | 0);  /* check that ARES_OPT_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TIMEOUTMS(unsigned long long *o)
{
  int n = (ARES_OPT_TIMEOUTMS) <= 0;
  *o = (unsigned long long)((ARES_OPT_TIMEOUTMS) | 0);  /* check that ARES_OPT_TIMEOUTMS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TRIES(unsigned long long *o)
{
  int n = (ARES_OPT_TRIES) <= 0;
  *o = (unsigned long long)((ARES_OPT_TRIES) | 0);  /* check that ARES_OPT_TRIES is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_UDP_PORT(unsigned long long *o)
{
  int n = (ARES_OPT_UDP_PORT) <= 0;
  *o = (unsigned long long)((ARES_OPT_UDP_PORT) | 0);  /* check that ARES_OPT_UDP_PORT is an integer */
  return n;
}

static int _cffi_const_ARES_SOCKET_BAD(unsigned long long *o)
{
  int n = (ARES_SOCKET_BAD) <= 0;
  *o = (unsigned long long)((ARES_SOCKET_BAD) | 0);  /* check that ARES_SOCKET_BAD is an integer */
  return n;
}

static int _cffi_const_C_ANY(unsigned long long *o)
{
  int n = (C_ANY) <= 0;
  *o = (unsigned long long)((C_ANY) | 0);  /* check that C_ANY is an integer */
  return n;
}

static int _cffi_const_C_CHAOS(unsigned long long *o)
{
  int n = (C_CHAOS) <= 0;
  *o = (unsigned long long)((C_CHAOS) | 0);  /* check that C_CHAOS is an integer */
  return n;
}

static int _cffi_const_C_HS(unsigned long long *o)
{
  int n = (C_HS) <= 0;
  *o = (unsigned long long)((C_HS) | 0);  /* check that C_HS is an integer */
  return n;
}

static int _cffi_const_C_IN(unsigned long long *o)
{
  int n = (C_IN) <= 0;
  *o = (unsigned long long)((C_IN) | 0);  /* check that C_IN is an integer */
  return n;
}

static int _cffi_const_C_NONE(unsigned long long *o)
{
  int n = (C_NONE) <= 0;
  *o = (unsigned long long)((C_NONE) | 0);  /* check that C_NONE is an integer */
  return n;
}

static int _cffi_const_INET6_ADDRSTRLEN(unsigned long long *o)
{
  int n = (INET6_ADDRSTRLEN) <= 0;
  *o = (unsigned long long)((INET6_ADDRSTRLEN) | 0);  /* check that INET6_ADDRSTRLEN is an integer */
  return n;
}

static int _cffi_const_INET_ADDRSTRLEN(unsigned long long *o)
{
  int n = (INET_ADDRSTRLEN) <= 0;
  *o = (unsigned long long)((INET_ADDRSTRLEN) | 0);  /* check that INET_ADDRSTRLEN is an integer */
  return n;
}

static int _cffi_const_T_A(unsigned long long *o)
{
  int n = (T_A) <= 0;
  *o = (unsigned long long)((T_A) | 0);  /* check that T_A is an integer */
  return n;
}

static int _cffi_const_T_AAAA(unsigned long long *o)
{
  int n = (T_AAAA) <= 0;
  *o = (unsigned long long)((T_AAAA) | 0);  /* check that T_AAAA is an integer */
  return n;
}

static int _cffi_const_T_ANY(unsigned long long *o)
{
  int n = (T_ANY) <= 0;
  *o = (unsigned long long)((T_ANY) | 0);  /* check that T_ANY is an integer */
  return n;
}

static int _cffi_const_T_CAA(unsigned long long *o)
{
  int n = (T_CAA) <= 0;
  *o = (unsigned long long)((T_CAA) | 0);  /* check that T_CAA is an integer */
  return n;
}

static int _cffi_const_T_CNAME(unsigned long long *o)
{
  int n = (T_CNAME) <= 0;
  *o = (unsigned long long)((T_CNAME) | 0);  /* check that T_CNAME is an integer */
  return n;
}

static int _cffi_const_T_MX(unsigned long long *o)
{
  int n = (T_MX) <= 0;
  *o = (unsigned long long)((T_MX) | 0);  /* check that T_MX is an integer */
  return n;
}

static int _cffi_const_T_NAPTR(unsigned long long *o)
{
  int n = (T_NAPTR) <= 0;
  *o = (unsigned long long)((T_NAPTR) | 0);  /* check that T_NAPTR is an integer */
  return n;
}

static int _cffi_const_T_NS(unsigned long long *o)
{
  int n = (T_NS) <= 0;
  *o = (unsigned long long)((T_NS) | 0);  /* check that T_NS is an integer */
  return n;
}

static int _cffi_const_T_PTR(unsigned long long *o)
{
  int n = (T_PTR) <= 0;
  *o = (unsigned long long)((T_PTR) | 0);  /* check that T_PTR is an integer */
  return n;
}

static int _cffi_const_T_SOA(unsigned long long *o)
{
  int n = (T_SOA) <= 0;
  *o = (unsigned long long)((T_SOA) | 0);  /* check that T_SOA is an integer */
  return n;
}

static int _cffi_const_T_SRV(unsigned long long *o)
{
  int n = (T_SRV) <= 0;
  *o = (unsigned long long)((T_SRV) | 0);  /* check that T_SRV is an integer */
  return n;
}

static int _cffi_const_T_TXT(unsigned long long *o)
{
  int n = (T_TXT) <= 0;
  *o = (unsigned long long)((T_TXT) | 0);  /* check that T_TXT is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addr6ttl(struct ares_addr6ttl *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_in6_addr *tmp = &p->ip6addr; (void)tmp; }
  (void)((p->ttl) | 0);  /* check that 'struct ares_addr6ttl.ttl' is an integer */
}
struct _cffi_align_struct_ares_addr6ttl { char x; struct ares_addr6ttl y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addr_node(struct ares_addr_node *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_addr_node * *tmp = &p->next; (void)tmp; }
  (void)((p->family) | 0);  /* check that 'struct ares_addr_node.family' is an integer */
  /* cannot generate 'union $2' in field 'addr': unknown type name */
}
struct _cffi_align_struct_ares_addr_node { char x; struct ares_addr_node y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo(struct ares_addrinfo *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_addrinfo_cname * *tmp = &p->cnames; (void)tmp; }
  { struct ares_addrinfo_node * *tmp = &p->nodes; (void)tmp; }
}
struct _cffi_align_struct_ares_addrinfo { char x; struct ares_addrinfo y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo_cname(struct ares_addrinfo_cname *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ttl) | 0);  /* check that 'struct ares_addrinfo_cname.ttl' is an integer */
  { char * *tmp = &p->alias; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  { struct ares_addrinfo_cname * *tmp = &p->next; (void)tmp; }
}
struct _cffi_align_struct_ares_addrinfo_cname { char x; struct ares_addrinfo_cname y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo_hints(struct ares_addrinfo_hints *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ai_flags) | 0);  /* check that 'struct ares_addrinfo_hints.ai_flags' is an integer */
  (void)((p->ai_family) | 0);  /* check that 'struct ares_addrinfo_hints.ai_family' is an integer */
  (void)((p->ai_socktype) | 0);  /* check that 'struct ares_addrinfo_hints.ai_socktype' is an integer */
  (void)((p->ai_protocol) | 0);  /* check that 'struct ares_addrinfo_hints.ai_protocol' is an integer */
}
struct _cffi_align_struct_ares_addrinfo_hints { char x; struct ares_addrinfo_hints y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo_node(struct ares_addrinfo_node *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ai_ttl) | 0);  /* check that 'struct ares_addrinfo_node.ai_ttl' is an integer */
  (void)((p->ai_flags) | 0);  /* check that 'struct ares_addrinfo_node.ai_flags' is an integer */
  (void)((p->ai_family) | 0);  /* check that 'struct ares_addrinfo_node.ai_family' is an integer */
  (void)((p->ai_socktype) | 0);  /* check that 'struct ares_addrinfo_node.ai_socktype' is an integer */
  (void)((p->ai_protocol) | 0);  /* check that 'struct ares_addrinfo_node.ai_protocol' is an integer */
  (void)((p->ai_addrlen) | 0);  /* check that 'struct ares_addrinfo_node.ai_addrlen' is an integer */
  { struct sockaddr * *tmp = &p->ai_addr; (void)tmp; }
  { struct ares_addrinfo_node * *tmp = &p->ai_next; (void)tmp; }
}
struct _cffi_align_struct_ares_addrinfo_node { char x; struct ares_addrinfo_node y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrttl(struct ares_addrttl *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct in_addr *tmp = &p->ipaddr; (void)tmp; }
  (void)((p->ttl) | 0);  /* check that 'struct ares_addrttl.ttl' is an integer */
}
struct _cffi_align_struct_ares_addrttl { char x; struct ares_addrttl y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_caa_reply(struct ares_caa_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_caa_reply * *tmp = &p->next; (void)tmp; }
  (void)((p->critical) | 0);  /* check that 'struct ares_caa_reply.critical' is an integer */
  { unsigned char * *tmp = &p->property; (void)tmp; }
  (void)((p->plength) | 0);  /* check that 'struct ares_caa_reply.plength' is an integer */
  { unsigned char * *tmp = &p->value; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct ares_caa_reply.length' is an integer */
}
struct _cffi_align_struct_ares_caa_reply { char x; struct ares_caa_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_in6_addr(struct ares_in6_addr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  /* cannot generate 'union $1' in field '_S6_un': unknown type name */
}
struct _cffi_align_struct_ares_in6_addr { char x; struct ares_in6_addr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_mx_reply(struct ares_mx_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_mx_reply * *tmp = &p->next; (void)tmp; }
  { char * *tmp = &p->host; (void)tmp; }
  (void)((p->priority) | 0);  /* check that 'struct ares_mx_reply.priority' is an integer */
}
struct _cffi_align_struct_ares_mx_reply { char x; struct ares_mx_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_naptr_reply(struct ares_naptr_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_naptr_reply * *tmp = &p->next; (void)tmp; }
  { unsigned char * *tmp = &p->flags; (void)tmp; }
  { unsigned char * *tmp = &p->service; (void)tmp; }
  { unsigned char * *tmp = &p->regexp; (void)tmp; }
  { char * *tmp = &p->replacement; (void)tmp; }
  (void)((p->order) | 0);  /* check that 'struct ares_naptr_reply.order' is an integer */
  (void)((p->preference) | 0);  /* check that 'struct ares_naptr_reply.preference' is an integer */
}
struct _cffi_align_struct_ares_naptr_reply { char x; struct ares_naptr_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_options(struct ares_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'struct ares_options.flags' is an integer */
  (void)((p->timeout) | 0);  /* check that 'struct ares_options.timeout' is an integer */
  (void)((p->tries) | 0);  /* check that 'struct ares_options.tries' is an integer */
  (void)((p->ndots) | 0);  /* check that 'struct ares_options.ndots' is an integer */
  (void)((p->udp_port) | 0);  /* check that 'struct ares_options.udp_port' is an integer */
  (void)((p->tcp_port) | 0);  /* check that 'struct ares_options.tcp_port' is an integer */
  (void)((p->socket_send_buffer_size) | 0);  /* check that 'struct ares_options.socket_send_buffer_size' is an integer */
  (void)((p->socket_receive_buffer_size) | 0);  /* check that 'struct ares_options.socket_receive_buffer_size' is an integer */
  { struct in_addr * *tmp = &p->servers; (void)tmp; }
  (void)((p->nservers) | 0);  /* check that 'struct ares_options.nservers' is an integer */
  { char * * *tmp = &p->domains; (void)tmp; }
  (void)((p->ndomains) | 0);  /* check that 'struct ares_options.ndomains' is an integer */
  { char * *tmp = &p->lookups; (void)tmp; }
  { void(* *tmp)(void *, ares_socket_t, int, int) = &p->sock_state_cb; (void)tmp; }
  { void * *tmp = &p->sock_state_cb_data; (void)tmp; }
  { struct apattern * *tmp = &p->sortlist; (void)tmp; }
  (void)((p->nsort) | 0);  /* check that 'struct ares_options.nsort' is an integer */
  (void)((p->ednspsz) | 0);  /* check that 'struct ares_options.ednspsz' is an integer */
  { char * *tmp = &p->resolvconf_path; (void)tmp; }
  { char * *tmp = &p->hosts_path; (void)tmp; }
  (void)((p->udp_max_queries) | 0);  /* check that 'struct ares_options.udp_max_queries' is an integer */
  (void)((p->maxtimeout) | 0);  /* check that 'struct ares_options.maxtimeout' is an integer */
  (void)((p->qcache_max_ttl) | 0);  /* check that 'struct ares_options.qcache_max_ttl' is an integer */
  { ares_evsys_t *tmp = &p->evsys; (void)tmp; }
  { struct ares_server_failover_options *tmp = &p->server_failover_opts; (void)tmp; }
}
struct _cffi_align_struct_ares_options { char x; struct ares_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_server_failover_options(struct ares_server_failover_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->retry_chance) | 0);  /* check that 'struct ares_server_failover_options.retry_chance' is an integer */
  (void)((p->retry_delay) | 0);  /* check that 'struct ares_server_failover_options.retry_delay' is an integer */
}
struct _cffi_align_struct_ares_server_failover_options { char x; struct ares_server_failover_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_soa_reply(struct ares_soa_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->nsname; (void)tmp; }
  { char * *tmp = &p->hostmaster; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct ares_soa_reply.serial' is an integer */
  (void)((p->refresh) | 0);  /* check that 'struct ares_soa_reply.refresh' is an integer */
  (void)((p->retry) | 0);  /* check that 'struct ares_soa_reply.retry' is an integer */
  (void)((p->expire) | 0);  /* check that 'struct ares_soa_reply.expire' is an integer */
  (void)((p->minttl) | 0);  /* check that 'struct ares_soa_reply.minttl' is an integer */
}
struct _cffi_align_struct_ares_soa_reply { char x; struct ares_soa_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_srv_reply(struct ares_srv_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_srv_reply * *tmp = &p->next; (void)tmp; }
  { char * *tmp = &p->host; (void)tmp; }
  (void)((p->priority) | 0);  /* check that 'struct ares_srv_reply.priority' is an integer */
  (void)((p->weight) | 0);  /* check that 'struct ares_srv_reply.weight' is an integer */
  (void)((p->port) | 0);  /* check that 'struct ares_srv_reply.port' is an integer */
}
struct _cffi_align_struct_ares_srv_reply { char x; struct ares_srv_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_txt_ext(struct ares_txt_ext *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_txt_ext * *tmp = &p->next; (void)tmp; }
  { unsigned char * *tmp = &p->txt; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct ares_txt_ext.length' is an integer */
  (void)((p->record_start) | 0);  /* check that 'struct ares_txt_ext.record_start' is an integer */
}
struct _cffi_align_struct_ares_txt_ext { char x; struct ares_txt_ext y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_txt_reply(struct ares_txt_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_txt_reply * *tmp = &p->next; (void)tmp; }
  { unsigned char * *tmp = &p->txt; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct ares_txt_reply.length' is an integer */
}
struct _cffi_align_struct_ares_txt_reply { char x; struct ares_txt_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_hostent(struct hostent *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->h_name; (void)tmp; }
  { char * * *tmp = &p->h_aliases; (void)tmp; }
  (void)((p->h_addrtype) | 0);  /* check that 'struct hostent.h_addrtype' is an integer */
  (void)((p->h_length) | 0);  /* check that 'struct hostent.h_length' is an integer */
  { char * * *tmp = &p->h_addr_list; (void)tmp; }
}
struct _cffi_align_struct_hostent { char x; struct hostent y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_in6_addr(struct in6_addr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { uint8_t(*tmp)[16] = &p->s6_addr; (void)tmp; }
}
struct _cffi_align_struct_in6_addr { char x; struct in6_addr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_in_addr(struct in_addr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->s_addr) | 0);  /* check that 'struct in_addr.s_addr' is an integer */
}
struct _cffi_align_struct_in_addr { char x; struct in_addr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sockaddr(struct sockaddr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sa_family) | 0);  /* check that 'struct sockaddr.sa_family' is an integer */
}
struct _cffi_align_struct_sockaddr { char x; struct sockaddr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sockaddr_in(struct sockaddr_in *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sin_family) | 0);  /* check that 'struct sockaddr_in.sin_family' is an integer */
  (void)((p->sin_port) | 0);  /* check that 'struct sockaddr_in.sin_port' is an integer */
  { struct in_addr *tmp = &p->sin_addr; (void)tmp; }
}
struct _cffi_align_struct_sockaddr_in { char x; struct sockaddr_in y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sockaddr_in6(struct sockaddr_in6 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sin6_family) | 0);  /* check that 'struct sockaddr_in6.sin6_family' is an integer */
  (void)((p->sin6_port) | 0);  /* check that 'struct sockaddr_in6.sin6_port' is an integer */
  (void)((p->sin6_flowinfo) | 0);  /* check that 'struct sockaddr_in6.sin6_flowinfo' is an integer */
  { struct in6_addr *tmp = &p->sin6_addr; (void)tmp; }
  (void)((p->sin6_scope_id) | 0);  /* check that 'struct sockaddr_in6.sin6_scope_id' is an integer */
}
struct _cffi_align_struct_sockaddr_in6 { char x; struct sockaddr_in6 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_timeval(struct timeval *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->tv_sec) | 0);  /* check that 'struct timeval.tv_sec' is an integer */
  (void)((p->tv_usec) | 0);  /* check that 'struct timeval.tv_usec' is an integer */
}
struct _cffi_align_struct_timeval { char x; struct timeval y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "ARES_AI_ADDRCONFIG", (void *)_cffi_const_ARES_AI_ADDRCONFIG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_ALL", (void *)_cffi_const_ARES_AI_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_CANONIDN", (void *)_cffi_const_ARES_AI_CANONIDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_CANONNAME", (void *)_cffi_const_ARES_AI_CANONNAME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_IDN", (void *)_cffi_const_ARES_AI_IDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_IDN_ALLOW_UNASSIGNED", (void *)_cffi_const_ARES_AI_IDN_ALLOW_UNASSIGNED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_IDN_USE_STD3_ASCII_RULES", (void *)_cffi_const_ARES_AI_IDN_USE_STD3_ASCII_RULES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_MASK", (void *)_cffi_const_ARES_AI_MASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_NUMERICHOST", (void *)_cffi_const_ARES_AI_NUMERICHOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_NUMERICSERV", (void *)_cffi_const_ARES_AI_NUMERICSERV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_PASSIVE", (void *)_cffi_const_ARES_AI_PASSIVE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_V4MAPPED", (void *)_cffi_const_ARES_AI_V4MAPPED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_EADDRGETNETWORKPARAMS", (void *)_cffi_const_ARES_EADDRGETNETWORKPARAMS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADFAMILY", (void *)_cffi_const_ARES_EBADFAMILY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADFLAGS", (void *)_cffi_const_ARES_EBADFLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADHINTS", (void *)_cffi_const_ARES_EBADHINTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADNAME", (void *)_cffi_const_ARES_EBADNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADQUERY", (void *)_cffi_const_ARES_EBADQUERY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADRESP", (void *)_cffi_const_ARES_EBADRESP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADSTR", (void *)_cffi_const_ARES_EBADSTR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ECANCELLED", (void *)_cffi_const_ARES_ECANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ECONNREFUSED", (void *)_cffi_const_ARES_ECONNREFUSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EDESTRUCTION", (void *)_cffi_const_ARES_EDESTRUCTION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EFILE", (void *)_cffi_const_ARES_EFILE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EFORMERR", (void *)_cffi_const_ARES_EFORMERR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ELOADIPHLPAPI", (void *)_cffi_const_ARES_ELOADIPHLPAPI, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENODATA", (void *)_cffi_const_ARES_ENODATA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOMEM", (void *)_cffi_const_ARES_ENOMEM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENONAME", (void *)_cffi_const_ARES_ENONAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOSERVER", (void *)_cffi_const_ARES_ENOSERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOTFOUND", (void *)_cffi_const_ARES_ENOTFOUND, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOTIMP", (void *)_cffi_const_ARES_ENOTIMP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOTINITIALIZED", (void *)_cffi_const_ARES_ENOTINITIALIZED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EOF", (void *)_cffi_const_ARES_EOF, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EREFUSED", (void *)_cffi_const_ARES_EREFUSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ESERVFAIL", (void *)_cffi_const_ARES_ESERVFAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ESERVICE", (void *)_cffi_const_ARES_ESERVICE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ETIMEOUT", (void *)_cffi_const_ARES_ETIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_DEFAULT", (void *)_cffi_const_ARES_EVSYS_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_EPOLL", (void *)_cffi_const_ARES_EVSYS_EPOLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_KQUEUE", (void *)_cffi_const_ARES_EVSYS_KQUEUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_POLL", (void *)_cffi_const_ARES_EVSYS_POLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_SELECT", (void *)_cffi_const_ARES_EVSYS_SELECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_WIN32", (void *)_cffi_const_ARES_EVSYS_WIN32, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FALSE", (void *)_cffi_const_ARES_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_EDNS", (void *)_cffi_const_ARES_FLAG_EDNS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_IGNTC", (void *)_cffi_const_ARES_FLAG_IGNTC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NOALIASES", (void *)_cffi_const_ARES_FLAG_NOALIASES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NOCHECKRESP", (void *)_cffi_const_ARES_FLAG_NOCHECKRESP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NORECURSE", (void *)_cffi_const_ARES_FLAG_NORECURSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NOSEARCH", (void *)_cffi_const_ARES_FLAG_NOSEARCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NO_DFLT_SVR", (void *)_cffi_const_ARES_FLAG_NO_DFLT_SVR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_PRIMARY", (void *)_cffi_const_ARES_FLAG_PRIMARY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_STAYOPEN", (void *)_cffi_const_ARES_FLAG_STAYOPEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_USEVC", (void *)_cffi_const_ARES_FLAG_USEVC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_GETSOCK_MAXNUM", (void *)_cffi_const_ARES_GETSOCK_MAXNUM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_GETSOCK_READABLE", (void *)_cffi_f_ARES_GETSOCK_READABLE, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_ARES_GETSOCK_READABLE },
  { "ARES_GETSOCK_WRITABLE", (void *)_cffi_f_ARES_GETSOCK_WRITABLE, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_ARES_GETSOCK_WRITABLE },
  { "ARES_LIB_INIT_ALL", (void *)_cffi_const_ARES_LIB_INIT_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_DCCP", (void *)_cffi_const_ARES_NI_DCCP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_DGRAM", (void *)_cffi_const_ARES_NI_DGRAM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_IDN", (void *)_cffi_const_ARES_NI_IDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_IDN_ALLOW_UNASSIGNED", (void *)_cffi_const_ARES_NI_IDN_ALLOW_UNASSIGNED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_IDN_USE_STD3_ASCII_RULES", (void *)_cffi_const_ARES_NI_IDN_USE_STD3_ASCII_RULES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_LOOKUPHOST", (void *)_cffi_const_ARES_NI_LOOKUPHOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_LOOKUPSERVICE", (void *)_cffi_const_ARES_NI_LOOKUPSERVICE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NAMEREQD", (void *)_cffi_const_ARES_NI_NAMEREQD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NOFQDN", (void *)_cffi_const_ARES_NI_NOFQDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NUMERICHOST", (void *)_cffi_const_ARES_NI_NUMERICHOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NUMERICSCOPE", (void *)_cffi_const_ARES_NI_NUMERICSCOPE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NUMERICSERV", (void *)_cffi_const_ARES_NI_NUMERICSERV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_SCTP", (void *)_cffi_const_ARES_NI_SCTP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_TCP", (void *)_cffi_const_ARES_NI_TCP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_UDP", (void *)_cffi_const_ARES_NI_UDP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_DOMAINS", (void *)_cffi_const_ARES_OPT_DOMAINS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_EDNSPSZ", (void *)_cffi_const_ARES_OPT_EDNSPSZ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_EVENT_THREAD", (void *)_cffi_const_ARES_OPT_EVENT_THREAD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_FLAGS", (void *)_cffi_const_ARES_OPT_FLAGS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_LOOKUPS", (void *)_cffi_const_ARES_OPT_LOOKUPS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_NDOTS", (void *)_cffi_const_ARES_OPT_NDOTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_RESOLVCONF", (void *)_cffi_const_ARES_OPT_RESOLVCONF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_ROTATE", (void *)_cffi_const_ARES_OPT_ROTATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SERVERS", (void *)_cffi_const_ARES_OPT_SERVERS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SOCK_RCVBUF", (void *)_cffi_const_ARES_OPT_SOCK_RCVBUF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SOCK_SNDBUF", (void *)_cffi_const_ARES_OPT_SOCK_SNDBUF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SOCK_STATE_CB", (void *)_cffi_const_ARES_OPT_SOCK_STATE_CB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SORTLIST", (void *)_cffi_const_ARES_OPT_SORTLIST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TCP_PORT", (void *)_cffi_const_ARES_OPT_TCP_PORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TIMEOUT", (void *)_cffi_const_ARES_OPT_TIMEOUT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TIMEOUTMS", (void *)_cffi_const_ARES_OPT_TIMEOUTMS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TRIES", (void *)_cffi_const_ARES_OPT_TRIES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_UDP_PORT", (void *)_cffi_const_ARES_OPT_UDP_PORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_SOCKET_BAD", (void *)_cffi_const_ARES_SOCKET_BAD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_SUCCESS", (void *)_cffi_const_ARES_SUCCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_TRUE", (void *)_cffi_const_ARES_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "C_ANY", (void *)_cffi_const_C_ANY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "C_CHAOS", (void *)_cffi_const_C_CHAOS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "C_HS", (void *)_cffi_const_C_HS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "C_IN", (void *)_cffi_const_C_IN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "C_NONE", (void *)_cffi_const_C_NONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "INET6_ADDRSTRLEN", (void *)_cffi_const_INET6_ADDRSTRLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "INET_ADDRSTRLEN", (void *)_cffi_const_INET_ADDRSTRLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_A", (void *)_cffi_const_T_A, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_AAAA", (void *)_cffi_const_T_AAAA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_ANY", (void *)_cffi_const_T_ANY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_CAA", (void *)_cffi_const_T_CAA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_CNAME", (void *)_cffi_const_T_CNAME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_MX", (void *)_cffi_const_T_MX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_NAPTR", (void *)_cffi_const_T_NAPTR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_NS", (void *)_cffi_const_T_NS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_PTR", (void *)_cffi_const_T_PTR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_SOA", (void *)_cffi_const_T_SOA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_SRV", (void *)_cffi_const_T_SRV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "T_TXT", (void *)_cffi_const_T_TXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_addrinfo_cb", (void *)&_cffi_externpy___addrinfo_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 189), (void *)_addrinfo_cb },
  { "_host_cb", (void *)&_cffi_externpy___host_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 204), (void *)_host_cb },
  { "_nameinfo_cb", (void *)&_cffi_externpy___nameinfo_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 217), (void *)_nameinfo_cb },
  { "_query_cb", (void *)&_cffi_externpy___query_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 197), (void *)_query_cb },
  { "_sock_state_cb", (void *)&_cffi_externpy___sock_state_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 343), (void *)_sock_state_cb },
  { "ares_cancel", (void *)_cffi_f_ares_cancel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 172), (void *)_cffi_d_ares_cancel },
  { "ares_create_query", (void *)_cffi_f_ares_create_query, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_ares_create_query },
  { "ares_destroy", (void *)_cffi_f_ares_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 172), (void *)_cffi_d_ares_destroy },
  { "ares_destroy_options", (void *)_cffi_f_ares_destroy_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 243), (void *)_cffi_d_ares_destroy_options },
  { "ares_dup", (void *)_cffi_f_ares_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_ares_dup },
  { "ares_expand_name", (void *)_cffi_f_ares_expand_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 150), (void *)_cffi_d_ares_expand_name },
  { "ares_expand_string", (void *)_cffi_f_ares_expand_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 157), (void *)_cffi_d_ares_expand_string },
  { "ares_free_data", (void *)_cffi_f_ares_free_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 249), (void *)_cffi_d_ares_free_data },
  { "ares_free_hostent", (void *)_cffi_f_ares_free_hostent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 246), (void *)_cffi_d_ares_free_hostent },
  { "ares_free_string", (void *)_cffi_f_ares_free_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 249), (void *)_cffi_d_ares_free_string },
  { "ares_freeaddrinfo", (void *)_cffi_f_ares_freeaddrinfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 169), (void *)_cffi_d_ares_freeaddrinfo },
  { "ares_get_servers", (void *)_cffi_f_ares_get_servers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 80), (void *)_cffi_d_ares_get_servers },
  { "ares_getaddrinfo", (void *)_cffi_f_ares_getaddrinfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 184), (void *)_cffi_d_ares_getaddrinfo },
  { "ares_gethostbyaddr", (void *)_cffi_f_ares_gethostbyaddr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 235), (void *)_cffi_d_ares_gethostbyaddr },
  { "ares_gethostbyname", (void *)_cffi_f_ares_gethostbyname, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_ares_gethostbyname },
  { "ares_gethostbyname_file", (void *)_cffi_f_ares_gethostbyname_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 74), (void *)_cffi_d_ares_gethostbyname_file },
  { "ares_getnameinfo", (void *)_cffi_f_ares_getnameinfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 212), (void *)_cffi_d_ares_getnameinfo },
  { "ares_getsock", (void *)_cffi_f_ares_getsock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 69), (void *)_cffi_d_ares_getsock },
  { "ares_inet_ntop", (void *)_cffi_f_ares_inet_ntop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_ares_inet_ntop },
  { "ares_inet_pton", (void *)_cffi_f_ares_inet_pton, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 45), (void *)_cffi_d_ares_inet_pton },
  { "ares_init", (void *)_cffi_f_ares_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 54), (void *)_cffi_d_ares_init },
  { "ares_init_options", (void *)_cffi_f_ares_init_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_ares_init_options },
  { "ares_library_cleanup", (void *)_cffi_f_ares_library_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 284), (void *)_cffi_d_ares_library_cleanup },
  { "ares_library_init", (void *)_cffi_f_ares_library_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 42), (void *)_cffi_d_ares_library_init },
  { "ares_mkquery", (void *)_cffi_f_ares_mkquery, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 23), (void *)_cffi_d_ares_mkquery },
  { "ares_parse_a_reply", (void *)_cffi_f_ares_parse_a_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 135), (void *)_cffi_d_ares_parse_a_reply },
  { "ares_parse_aaaa_reply", (void *)_cffi_f_ares_parse_aaaa_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_ares_parse_aaaa_reply },
  { "ares_parse_caa_reply", (void *)_cffi_f_ares_parse_caa_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 93), (void *)_cffi_d_ares_parse_caa_reply },
  { "ares_parse_mx_reply", (void *)_cffi_f_ares_parse_mx_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 98), (void *)_cffi_d_ares_parse_mx_reply },
  { "ares_parse_naptr_reply", (void *)_cffi_f_ares_parse_naptr_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_ares_parse_naptr_reply },
  { "ares_parse_ns_reply", (void *)_cffi_f_ares_parse_ns_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_ares_parse_ns_reply },
  { "ares_parse_ptr_reply", (void *)_cffi_f_ares_parse_ptr_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 142), (void *)_cffi_d_ares_parse_ptr_reply },
  { "ares_parse_soa_reply", (void *)_cffi_f_ares_parse_soa_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 108), (void *)_cffi_d_ares_parse_soa_reply },
  { "ares_parse_srv_reply", (void *)_cffi_f_ares_parse_srv_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 113), (void *)_cffi_d_ares_parse_srv_reply },
  { "ares_parse_txt_reply_ext", (void *)_cffi_f_ares_parse_txt_reply_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ares_parse_txt_reply_ext },
  { "ares_process_fd", (void *)_cffi_f_ares_process_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_ares_process_fd },
  { "ares_query", (void *)_cffi_f_ares_query, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 192), (void *)_cffi_d_ares_query },
  { "ares_queue_wait_empty", (void *)_cffi_f_ares_queue_wait_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 2), (void *)_cffi_d_ares_queue_wait_empty },
  { "ares_reinit", (void *)_cffi_f_ares_reinit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 66), (void *)_cffi_d_ares_reinit },
  { "ares_save_options", (void *)_cffi_f_ares_save_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 88), (void *)_cffi_d_ares_save_options },
  { "ares_search", (void *)_cffi_f_ares_search, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 192), (void *)_cffi_d_ares_search },
  { "ares_send", (void *)_cffi_f_ares_send, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 224), (void *)_cffi_d_ares_send },
  { "ares_set_local_dev", (void *)_cffi_f_ares_set_local_dev, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 180), (void *)_cffi_d_ares_set_local_dev },
  { "ares_set_local_ip4", (void *)_cffi_f_ares_set_local_ip4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 231), (void *)_cffi_d_ares_set_local_ip4 },
  { "ares_set_local_ip6", (void *)_cffi_f_ares_set_local_ip6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 220), (void *)_cffi_d_ares_set_local_ip6 },
  { "ares_set_servers", (void *)_cffi_f_ares_set_servers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_ares_set_servers },
  { "ares_set_socket_callback", (void *)_cffi_f_ares_set_socket_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 207), (void *)_cffi_d_ares_set_socket_callback },
  { "ares_strerror", (void *)_cffi_f_ares_strerror, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_ares_strerror },
  { "ares_threadsafety", (void *)_cffi_f_ares_threadsafety, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_ares_threadsafety },
  { "ares_timeout", (void *)_cffi_f_ares_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_ares_timeout },
  { "ares_version", (void *)_cffi_f_ares_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_ares_version },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "ip6addr", offsetof(struct ares_addr6ttl, ip6addr),
               sizeof(((struct ares_addr6ttl *)0)->ip6addr),
               _CFFI_OP(_CFFI_OP_NOOP, 307) },
  { "ttl", offsetof(struct ares_addr6ttl, ttl),
           sizeof(((struct ares_addr6ttl *)0)->ttl),
           _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "next", offsetof(struct ares_addr_node, next),
            sizeof(((struct ares_addr_node *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 86) },
  { "family", offsetof(struct ares_addr_node, family),
              sizeof(((struct ares_addr_node *)0)->family),
              _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "addr", offsetof(struct ares_addr_node, addr),
            sizeof(((struct ares_addr_node *)0)->addr),
            _CFFI_OP(_CFFI_OP_NOOP, 339) },
  { "cnames", offsetof(struct ares_addrinfo, cnames),
              sizeof(((struct ares_addrinfo *)0)->cnames),
              _CFFI_OP(_CFFI_OP_NOOP, 298) },
  { "nodes", offsetof(struct ares_addrinfo, nodes),
             sizeof(((struct ares_addrinfo *)0)->nodes),
             _CFFI_OP(_CFFI_OP_NOOP, 301) },
  { "ttl", offsetof(struct ares_addrinfo_cname, ttl),
           sizeof(((struct ares_addrinfo_cname *)0)->ttl),
           _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "alias", offsetof(struct ares_addrinfo_cname, alias),
             sizeof(((struct ares_addrinfo_cname *)0)->alias),
             _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "name", offsetof(struct ares_addrinfo_cname, name),
            sizeof(((struct ares_addrinfo_cname *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "next", offsetof(struct ares_addrinfo_cname, next),
            sizeof(((struct ares_addrinfo_cname *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 298) },
  { "ai_flags", offsetof(struct ares_addrinfo_hints, ai_flags),
                sizeof(((struct ares_addrinfo_hints *)0)->ai_flags),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_family", offsetof(struct ares_addrinfo_hints, ai_family),
                 sizeof(((struct ares_addrinfo_hints *)0)->ai_family),
                 _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_socktype", offsetof(struct ares_addrinfo_hints, ai_socktype),
                   sizeof(((struct ares_addrinfo_hints *)0)->ai_socktype),
                   _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_protocol", offsetof(struct ares_addrinfo_hints, ai_protocol),
                   sizeof(((struct ares_addrinfo_hints *)0)->ai_protocol),
                   _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_ttl", offsetof(struct ares_addrinfo_node, ai_ttl),
              sizeof(((struct ares_addrinfo_node *)0)->ai_ttl),
              _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_flags", offsetof(struct ares_addrinfo_node, ai_flags),
                sizeof(((struct ares_addrinfo_node *)0)->ai_flags),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_family", offsetof(struct ares_addrinfo_node, ai_family),
                 sizeof(((struct ares_addrinfo_node *)0)->ai_family),
                 _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_socktype", offsetof(struct ares_addrinfo_node, ai_socktype),
                   sizeof(((struct ares_addrinfo_node *)0)->ai_socktype),
                   _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_protocol", offsetof(struct ares_addrinfo_node, ai_protocol),
                   sizeof(((struct ares_addrinfo_node *)0)->ai_protocol),
                   _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ai_addrlen", offsetof(struct ares_addrinfo_node, ai_addrlen),
                  sizeof(((struct ares_addrinfo_node *)0)->ai_addrlen),
                  _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "ai_addr", offsetof(struct ares_addrinfo_node, ai_addr),
               sizeof(((struct ares_addrinfo_node *)0)->ai_addr),
               _CFFI_OP(_CFFI_OP_NOOP, 326) },
  { "ai_next", offsetof(struct ares_addrinfo_node, ai_next),
               sizeof(((struct ares_addrinfo_node *)0)->ai_next),
               _CFFI_OP(_CFFI_OP_NOOP, 301) },
  { "ipaddr", offsetof(struct ares_addrttl, ipaddr),
              sizeof(((struct ares_addrttl *)0)->ipaddr),
              _CFFI_OP(_CFFI_OP_NOOP, 325) },
  { "ttl", offsetof(struct ares_addrttl, ttl),
           sizeof(((struct ares_addrttl *)0)->ttl),
           _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "next", offsetof(struct ares_caa_reply, next),
            sizeof(((struct ares_caa_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 304) },
  { "critical", offsetof(struct ares_caa_reply, critical),
                sizeof(((struct ares_caa_reply *)0)->critical),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "property", offsetof(struct ares_caa_reply, property),
                sizeof(((struct ares_caa_reply *)0)->property),
                _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "plength", offsetof(struct ares_caa_reply, plength),
               sizeof(((struct ares_caa_reply *)0)->plength),
               _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "value", offsetof(struct ares_caa_reply, value),
             sizeof(((struct ares_caa_reply *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "length", offsetof(struct ares_caa_reply, length),
              sizeof(((struct ares_caa_reply *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "_S6_un", offsetof(struct ares_in6_addr, _S6_un),
              sizeof(((struct ares_in6_addr *)0)->_S6_un),
              _CFFI_OP(_CFFI_OP_NOOP, 338) },
  { "next", offsetof(struct ares_mx_reply, next),
            sizeof(((struct ares_mx_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 308) },
  { "host", offsetof(struct ares_mx_reply, host),
            sizeof(((struct ares_mx_reply *)0)->host),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "priority", offsetof(struct ares_mx_reply, priority),
                sizeof(((struct ares_mx_reply *)0)->priority),
                _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "next", offsetof(struct ares_naptr_reply, next),
            sizeof(((struct ares_naptr_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 310) },
  { "flags", offsetof(struct ares_naptr_reply, flags),
             sizeof(((struct ares_naptr_reply *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "service", offsetof(struct ares_naptr_reply, service),
               sizeof(((struct ares_naptr_reply *)0)->service),
               _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "regexp", offsetof(struct ares_naptr_reply, regexp),
              sizeof(((struct ares_naptr_reply *)0)->regexp),
              _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "replacement", offsetof(struct ares_naptr_reply, replacement),
                   sizeof(((struct ares_naptr_reply *)0)->replacement),
                   _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "order", offsetof(struct ares_naptr_reply, order),
             sizeof(((struct ares_naptr_reply *)0)->order),
             _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "preference", offsetof(struct ares_naptr_reply, preference),
                  sizeof(((struct ares_naptr_reply *)0)->preference),
                  _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "flags", offsetof(struct ares_options, flags),
             sizeof(((struct ares_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "timeout", offsetof(struct ares_options, timeout),
               sizeof(((struct ares_options *)0)->timeout),
               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "tries", offsetof(struct ares_options, tries),
             sizeof(((struct ares_options *)0)->tries),
             _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ndots", offsetof(struct ares_options, ndots),
             sizeof(((struct ares_options *)0)->ndots),
             _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "udp_port", offsetof(struct ares_options, udp_port),
                sizeof(((struct ares_options *)0)->udp_port),
                _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "tcp_port", offsetof(struct ares_options, tcp_port),
                sizeof(((struct ares_options *)0)->tcp_port),
                _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "socket_send_buffer_size", offsetof(struct ares_options, socket_send_buffer_size),
                               sizeof(((struct ares_options *)0)->socket_send_buffer_size),
                               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "socket_receive_buffer_size", offsetof(struct ares_options, socket_receive_buffer_size),
                                  sizeof(((struct ares_options *)0)->socket_receive_buffer_size),
                                  _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "servers", offsetof(struct ares_options, servers),
               sizeof(((struct ares_options *)0)->servers),
               _CFFI_OP(_CFFI_OP_NOOP, 324) },
  { "nservers", offsetof(struct ares_options, nservers),
                sizeof(((struct ares_options *)0)->nservers),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "domains", offsetof(struct ares_options, domains),
               sizeof(((struct ares_options *)0)->domains),
               _CFFI_OP(_CFFI_OP_NOOP, 154) },
  { "ndomains", offsetof(struct ares_options, ndomains),
                sizeof(((struct ares_options *)0)->ndomains),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "lookups", offsetof(struct ares_options, lookups),
               sizeof(((struct ares_options *)0)->lookups),
               _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "sock_state_cb", offsetof(struct ares_options, sock_state_cb),
                     sizeof(((struct ares_options *)0)->sock_state_cb),
                     _CFFI_OP(_CFFI_OP_NOOP, 343) },
  { "sock_state_cb_data", offsetof(struct ares_options, sock_state_cb_data),
                          sizeof(((struct ares_options *)0)->sock_state_cb_data),
                          _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "sortlist", offsetof(struct ares_options, sortlist),
                sizeof(((struct ares_options *)0)->sortlist),
                _CFFI_OP(_CFFI_OP_NOOP, 293) },
  { "nsort", offsetof(struct ares_options, nsort),
             sizeof(((struct ares_options *)0)->nsort),
             _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ednspsz", offsetof(struct ares_options, ednspsz),
               sizeof(((struct ares_options *)0)->ednspsz),
               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "resolvconf_path", offsetof(struct ares_options, resolvconf_path),
                       sizeof(((struct ares_options *)0)->resolvconf_path),
                       _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "hosts_path", offsetof(struct ares_options, hosts_path),
                  sizeof(((struct ares_options *)0)->hosts_path),
                  _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "udp_max_queries", offsetof(struct ares_options, udp_max_queries),
                       sizeof(((struct ares_options *)0)->udp_max_queries),
                       _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "maxtimeout", offsetof(struct ares_options, maxtimeout),
                  sizeof(((struct ares_options *)0)->maxtimeout),
                  _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "qcache_max_ttl", offsetof(struct ares_options, qcache_max_ttl),
                      sizeof(((struct ares_options *)0)->qcache_max_ttl),
                      _CFFI_OP(_CFFI_OP_NOOP, 233) },
  { "evsys", offsetof(struct ares_options, evsys),
             sizeof(((struct ares_options *)0)->evsys),
             _CFFI_OP(_CFFI_OP_NOOP, 287) },
  { "server_failover_opts", offsetof(struct ares_options, server_failover_opts),
                            sizeof(((struct ares_options *)0)->server_failover_opts),
                            _CFFI_OP(_CFFI_OP_NOOP, 313) },
  { "retry_chance", offsetof(struct ares_server_failover_options, retry_chance),
                    sizeof(((struct ares_server_failover_options *)0)->retry_chance),
                    _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "retry_delay", offsetof(struct ares_server_failover_options, retry_delay),
                   sizeof(((struct ares_server_failover_options *)0)->retry_delay),
                   _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "nsname", offsetof(struct ares_soa_reply, nsname),
              sizeof(((struct ares_soa_reply *)0)->nsname),
              _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "hostmaster", offsetof(struct ares_soa_reply, hostmaster),
                  sizeof(((struct ares_soa_reply *)0)->hostmaster),
                  _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "serial", offsetof(struct ares_soa_reply, serial),
              sizeof(((struct ares_soa_reply *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 233) },
  { "refresh", offsetof(struct ares_soa_reply, refresh),
               sizeof(((struct ares_soa_reply *)0)->refresh),
               _CFFI_OP(_CFFI_OP_NOOP, 233) },
  { "retry", offsetof(struct ares_soa_reply, retry),
             sizeof(((struct ares_soa_reply *)0)->retry),
             _CFFI_OP(_CFFI_OP_NOOP, 233) },
  { "expire", offsetof(struct ares_soa_reply, expire),
              sizeof(((struct ares_soa_reply *)0)->expire),
              _CFFI_OP(_CFFI_OP_NOOP, 233) },
  { "minttl", offsetof(struct ares_soa_reply, minttl),
              sizeof(((struct ares_soa_reply *)0)->minttl),
              _CFFI_OP(_CFFI_OP_NOOP, 233) },
  { "next", offsetof(struct ares_srv_reply, next),
            sizeof(((struct ares_srv_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 316) },
  { "host", offsetof(struct ares_srv_reply, host),
            sizeof(((struct ares_srv_reply *)0)->host),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "priority", offsetof(struct ares_srv_reply, priority),
                sizeof(((struct ares_srv_reply *)0)->priority),
                _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "weight", offsetof(struct ares_srv_reply, weight),
              sizeof(((struct ares_srv_reply *)0)->weight),
              _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "port", offsetof(struct ares_srv_reply, port),
            sizeof(((struct ares_srv_reply *)0)->port),
            _CFFI_OP(_CFFI_OP_NOOP, 27) },
  { "next", offsetof(struct ares_txt_ext, next),
            sizeof(((struct ares_txt_ext *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 318) },
  { "txt", offsetof(struct ares_txt_ext, txt),
           sizeof(((struct ares_txt_ext *)0)->txt),
           _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "length", offsetof(struct ares_txt_ext, length),
              sizeof(((struct ares_txt_ext *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "record_start", offsetof(struct ares_txt_ext, record_start),
                    sizeof(((struct ares_txt_ext *)0)->record_start),
                    _CFFI_OP(_CFFI_OP_NOOP, 340) },
  { "next", offsetof(struct ares_txt_reply, next),
            sizeof(((struct ares_txt_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "txt", offsetof(struct ares_txt_reply, txt),
           sizeof(((struct ares_txt_reply *)0)->txt),
           _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "length", offsetof(struct ares_txt_reply, length),
              sizeof(((struct ares_txt_reply *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "h_name", offsetof(struct hostent, h_name),
              sizeof(((struct hostent *)0)->h_name),
              _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "h_aliases", offsetof(struct hostent, h_aliases),
                 sizeof(((struct hostent *)0)->h_aliases),
                 _CFFI_OP(_CFFI_OP_NOOP, 154) },
  { "h_addrtype", offsetof(struct hostent, h_addrtype),
                  sizeof(((struct hostent *)0)->h_addrtype),
                  _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "h_length", offsetof(struct hostent, h_length),
                sizeof(((struct hostent *)0)->h_length),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "h_addr_list", offsetof(struct hostent, h_addr_list),
                   sizeof(((struct hostent *)0)->h_addr_list),
                   _CFFI_OP(_CFFI_OP_NOOP, 154) },
  { "s6_addr", offsetof(struct in6_addr, s6_addr),
               sizeof(((struct in6_addr *)0)->s6_addr),
               _CFFI_OP(_CFFI_OP_NOOP, 336) },
  { "s_addr", offsetof(struct in_addr, s_addr),
              sizeof(((struct in_addr *)0)->s_addr),
              _CFFI_OP(_CFFI_OP_NOOP, 334) },
  { "sa_family", offsetof(struct sockaddr, sa_family),
                 sizeof(((struct sockaddr *)0)->sa_family),
                 _CFFI_OP(_CFFI_OP_NOOP, 291) },
  { "sin_family", offsetof(struct sockaddr_in, sin_family),
                  sizeof(((struct sockaddr_in *)0)->sin_family),
                  _CFFI_OP(_CFFI_OP_NOOP, 291) },
  { "sin_port", offsetof(struct sockaddr_in, sin_port),
                sizeof(((struct sockaddr_in *)0)->sin_port),
                _CFFI_OP(_CFFI_OP_NOOP, 333) },
  { "sin_addr", offsetof(struct sockaddr_in, sin_addr),
                sizeof(((struct sockaddr_in *)0)->sin_addr),
                _CFFI_OP(_CFFI_OP_NOOP, 325) },
  { "sin6_family", offsetof(struct sockaddr_in6, sin6_family),
                   sizeof(((struct sockaddr_in6 *)0)->sin6_family),
                   _CFFI_OP(_CFFI_OP_NOOP, 291) },
  { "sin6_port", offsetof(struct sockaddr_in6, sin6_port),
                 sizeof(((struct sockaddr_in6 *)0)->sin6_port),
                 _CFFI_OP(_CFFI_OP_NOOP, 333) },
  { "sin6_flowinfo", offsetof(struct sockaddr_in6, sin6_flowinfo),
                     sizeof(((struct sockaddr_in6 *)0)->sin6_flowinfo),
                     _CFFI_OP(_CFFI_OP_NOOP, 334) },
  { "sin6_addr", offsetof(struct sockaddr_in6, sin6_addr),
                 sizeof(((struct sockaddr_in6 *)0)->sin6_addr),
                 _CFFI_OP(_CFFI_OP_NOOP, 323) },
  { "sin6_scope_id", offsetof(struct sockaddr_in6, sin6_scope_id),
                     sizeof(((struct sockaddr_in6 *)0)->sin6_scope_id),
                     _CFFI_OP(_CFFI_OP_NOOP, 334) },
  { "tv_sec", offsetof(struct timeval, tv_sec),
              sizeof(((struct timeval *)0)->tv_sec),
              _CFFI_OP(_CFFI_OP_NOOP, 332) },
  { "tv_usec", offsetof(struct timeval, tv_usec),
               sizeof(((struct timeval *)0)->tv_usec),
               _CFFI_OP(_CFFI_OP_NOOP, 331) },
  { "_S6_u8", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 341) },
  { "addr4", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 325) },
  { "addr6", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 307) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 338, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 106, 1 /* unnamed */ },
  { "$2", 339, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 107, 2 /* unnamed */ },
  { "apattern", 294, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ares_addr6ttl", 295, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addr6ttl), offsetof(struct _cffi_align_struct_ares_addr6ttl, y), 0, 2 },
  { "ares_addr_node", 296, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addr_node), offsetof(struct _cffi_align_struct_ares_addr_node, y), 2, 3 },
  { "ares_addrinfo", 297, 0,
    sizeof(struct ares_addrinfo), offsetof(struct _cffi_align_struct_ares_addrinfo, y), 5, 2 },
  { "ares_addrinfo_cname", 299, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrinfo_cname), offsetof(struct _cffi_align_struct_ares_addrinfo_cname, y), 7, 4 },
  { "ares_addrinfo_hints", 300, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrinfo_hints), offsetof(struct _cffi_align_struct_ares_addrinfo_hints, y), 11, 4 },
  { "ares_addrinfo_node", 302, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrinfo_node), offsetof(struct _cffi_align_struct_ares_addrinfo_node, y), 15, 8 },
  { "ares_addrttl", 303, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrttl), offsetof(struct _cffi_align_struct_ares_addrttl, y), 23, 2 },
  { "ares_caa_reply", 305, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_caa_reply), offsetof(struct _cffi_align_struct_ares_caa_reply, y), 25, 6 },
  { "ares_channeldata", 306, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ares_in6_addr", 307, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_in6_addr), offsetof(struct _cffi_align_struct_ares_in6_addr, y), 31, 1 },
  { "ares_mx_reply", 309, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_mx_reply), offsetof(struct _cffi_align_struct_ares_mx_reply, y), 32, 3 },
  { "ares_naptr_reply", 311, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_naptr_reply), offsetof(struct _cffi_align_struct_ares_naptr_reply, y), 35, 7 },
  { "ares_options", 312, 0,
    sizeof(struct ares_options), offsetof(struct _cffi_align_struct_ares_options, y), 42, 25 },
  { "ares_server_failover_options", 313, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_server_failover_options), offsetof(struct _cffi_align_struct_ares_server_failover_options, y), 67, 2 },
  { "ares_soa_reply", 315, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_soa_reply), offsetof(struct _cffi_align_struct_ares_soa_reply, y), 69, 7 },
  { "ares_srv_reply", 317, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_srv_reply), offsetof(struct _cffi_align_struct_ares_srv_reply, y), 76, 5 },
  { "ares_txt_ext", 319, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_txt_ext), offsetof(struct _cffi_align_struct_ares_txt_ext, y), 81, 4 },
  { "ares_txt_reply", 321, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_txt_reply), offsetof(struct _cffi_align_struct_ares_txt_reply, y), 85, 3 },
  { "hostent", 322, _CFFI_F_CHECK_FIELDS,
    sizeof(struct hostent), offsetof(struct _cffi_align_struct_hostent, y), 88, 5 },
  { "in6_addr", 323, 0,
    sizeof(struct in6_addr), offsetof(struct _cffi_align_struct_in6_addr, y), 93, 1 },
  { "in_addr", 325, _CFFI_F_CHECK_FIELDS,
    sizeof(struct in_addr), offsetof(struct _cffi_align_struct_in_addr, y), 94, 1 },
  { "sockaddr", 327, 0,
    sizeof(struct sockaddr), offsetof(struct _cffi_align_struct_sockaddr, y), 95, 1 },
  { "sockaddr_in", 329, 0,
    sizeof(struct sockaddr_in), offsetof(struct _cffi_align_struct_sockaddr_in, y), 96, 3 },
  { "sockaddr_in6", 328, 0,
    sizeof(struct sockaddr_in6), offsetof(struct _cffi_align_struct_sockaddr_in6, y), 99, 5 },
  { "timeval", 330, _CFFI_F_CHECK_FIELDS,
    sizeof(struct timeval), offsetof(struct _cffi_align_struct_timeval, y), 104, 2 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$ares_bool_t", 286, _cffi_prim_int(sizeof(ares_bool_t), ((ares_bool_t)-1) <= 0),
    "ARES_FALSE,ARES_TRUE" },
  { "$ares_evsys_t", 287, _cffi_prim_int(sizeof(ares_evsys_t), ((ares_evsys_t)-1) <= 0),
    "ARES_EVSYS_DEFAULT,ARES_EVSYS_WIN32,ARES_EVSYS_EPOLL,ARES_EVSYS_KQUEUE,ARES_EVSYS_POLL,ARES_EVSYS_SELECT" },
  { "$ares_status_t", 288, _cffi_prim_int(sizeof(ares_status_t), ((ares_status_t)-1) <= 0),
    "ARES_SUCCESS,ARES_ENODATA,ARES_EFORMERR,ARES_ESERVFAIL,ARES_ENOTFOUND,ARES_ENOTIMP,ARES_EREFUSED,ARES_EBADQUERY,ARES_EBADNAME,ARES_EBADFAMILY,ARES_EBADRESP,ARES_ECONNREFUSED,ARES_ETIMEOUT,ARES_EOF,ARES_EFILE,ARES_ENOMEM,ARES_EDESTRUCTION,ARES_EBADSTR,ARES_EBADFLAGS,ARES_ENONAME,ARES_EBADHINTS,ARES_ENOTINITIALIZED,ARES_ELOADIPHLPAPI,ARES_EADDRGETNETWORKPARAMS,ARES_ECANCELLED,ARES_ESERVICE,ARES_ENOSERVER" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ares_addrinfo_callback", 189 },
  { "ares_bool_t", 286 },
  { "ares_callback", 197 },
  { "ares_channel", 3 },
  { "ares_evsys_t", 287 },
  { "ares_host_callback", 204 },
  { "ares_nameinfo_callback", 217 },
  { "ares_sock_create_callback", 209 },
  { "ares_sock_state_cb", 343 },
  { "ares_socket_t", 19 },
  { "ares_socklen_t", 16 },
  { "ares_status_t", 288 },
  { "h_addrtype_t", 4 },
  { "h_length_t", 4 },
  { "in_port_t", 333 },
  { "sa_family_t", 291 },
  { "suseconds_t", 331 },
  { "time_t", 332 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  170,  /* num_globals */
  28,  /* num_struct_unions */
  3,  /* num_enums */
  18,  /* num_typenames */
  NULL,  /* no includes */
  345,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__cares(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__cares(void) { return NULL; }
#  else
     init_cares(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__cares(void)
{
  return _cffi_init("_cares", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_cares(void)
{
  _cffi_init("_cares", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
