// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A9__F174

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x)xyzw" };
#else
{ R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_256_T_T_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1201)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xbb5fb783u, 0xe7cf907eu, 334, 202 }, // bb5fb783e7cf907e = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x64b030bcu, 0x1c0d47c3u, 334, 116 }, // 64b030bc1c0d47c3 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0xc35975b1u, 0x7a04a2c5u, 334, 167 }, // c35975b17a04a2c5 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0x83fa81ceu, 0x4be97932u, 334, 133 }, // 83fa81ce4be97932 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0xb9a36517u, 0x6fc428afu, 219, 202 }, // b9a365176fc428af = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x42afc9cdu, 0xa6352100u, 219, 116 }, // 42afc9cda6352100 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0xb3a78620u, 0x8ce20e98u, 219, 167 }, // b3a786208ce20e98 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0x04c68a24u, 0x8291bb08u, 219, 133 }, // 04c68a248291bb08 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0x55b6abb9u, 0x47b43bbfu, 350, 202 }, // 55b6abb947b43bbf = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x5dad4e67u, 0xfc5aa415u, 350, 116 }, // 5dad4e67fc5aa415 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0xcf15027eu, 0xfa51f26bu, 235, 202 }, // cf15027efa51f26b = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x5b828769u, 0xd3fdf838u, 235, 167 }, // 5b828769d3fdf838 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_256_T_T_3_0___gfx120x__P__2_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1201
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1201_mod0
{{ 0, 3, 3, 0, 3, 2, 1, 0, 2, 0},
 { 0, 0, 3, 2, 2, 1, 0, 3, 0, 0},
 { 2, 2, 2, 1, 3, 3, 0, 2, 2, 0},
 { 7, 2, 7, 7, 7, 7, 7, 7, 0, 0},
 { 7, 2, 7, 7, 7, 7, 7, 2, 3, 2},
 { 7, 9, 7, 6, 5, 6, 6, 6, 5, 6},
 { 7, 8, 7, 7, 5, 4, 4, 5, 5, 4},
 { 0, 9, 7, 5, 6, 6, 4, 6, 4, 4},
 { 7, 7, 7, 6, 6,10,10, 6, 5, 5},
 { 7, 7, 7, 5, 5,10,11,11, 4, 5}}
// End of GPU gfx1201_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A9__F174 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 11;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 11;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 256
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1201_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 256 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 3 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

