// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A2__F28

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_32_T_T_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1101)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x977ee758u, 0x4d1d14c4u, 456, 50 }, // 977ee7584d1d14c4 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1101
    { 0x7592ec2au, 0x9d999753u, 0, 83 }, // 7592ec2a9d999753 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1101
    { 0x48792597u, 0x8f2c0317u, 0, 16 }, // 487925978f2c0317 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1101
    { 0xc9f4a580u, 0x567face7u, 0, 33 }, // c9f4a580567face7 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1101
    { 0xe467d812u, 0x367c5fbcu, 0, 50 }, // e467d812367c5fbc = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx1101
    { 0xe20db772u, 0x05938f33u, 366, 83 }, // e20db77205938f33 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1101
    { 0xe113a7f6u, 0xdc3dabeau, 366, 33 }, // e113a7f6dc3dabea = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx1101
    { 0x9ed381b2u, 0xa6621440u, 366, 50 }, // 9ed381b2a6621440 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx1101
    { 0x9c07e819u, 0x523f45f5u, 318, 83 }, // 9c07e819523f45f5 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave1_warp2_stg1--Arch_gfx1101
    { 0x8173ea1fu, 0xc70e64c4u, 318, 202 }, // 8173ea1fc70e64c4 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1101
    { 0xa1712346u, 0xec2720b7u, 318, 16 }, // a1712346ec2720b7 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1101
    { 0x7e0b8f06u, 0x7b9d8c87u, 318, 116 }, // 7e0b8f067b9d8c87 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1101
    { 0x5c6539a2u, 0x8deea5b2u, 318, 33 }, // 5c6539a28deea5b2 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave3_warp2_stg1--Arch_gfx1101
    { 0x02001e63u, 0x53a730c3u, 318, 50 }, // 02001e6353a730c3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave4_warp2_stg1--Arch_gfx1101
    { 0xdb31ae51u, 0xf0492aeau, 318, 133 }, // db31ae51f0492aea = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1101
    { 0xdd5a7cf1u, 0x397562c0u, 381, 83 }, // dd5a7cf1397562c0 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp2_stg1--Arch_gfx1101
    { 0x0f222562u, 0x3d99980bu, 381, 202 }, // 0f2225623d99980b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1101
    { 0x8d70c6d6u, 0x659715d1u, 381, 16 }, // 8d70c6d6659715d1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp2_stg1--Arch_gfx1101
    { 0x6d489d97u, 0xbbce641bu, 381, 116 }, // 6d489d97bbce641b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1101
    { 0xc08ef075u, 0xe1ef9ba7u, 381, 33 }, // c08ef075e1ef9ba7 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave3_warp2_stg1--Arch_gfx1101
    { 0x18a9c6b2u, 0x8efc166bu, 381, 167 }, // 18a9c6b28efc166b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1101
    { 0x98fdcdc4u, 0x067bff8eu, 381, 50 }, // 98fdcdc4067bff8e = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave4_warp2_stg1--Arch_gfx1101
    { 0xa70efa17u, 0xb954b42cu, 381, 133 }, // a70efa17b954b42c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1101
    { 0x3f3f0896u, 0xf33df0ceu, 67, 83 }, // 3f3f0896f33df0ce = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_T_0_0___gfx11xx__P__0_2_64_32_False__CO__wave1_warp2_stg1--Arch_gfx1101
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1101_mod0
{{ 5,14,11,22,18,16,20,20,22,16},
 {20, 0, 9, 9,10,15,21,19,15,15},
 { 9, 7, 3, 8,13,13,21,19,15,19},
 { 1, 2, 1, 1,12,13,15,19,15,19},
 { 2, 3, 2, 1, 8,12,10,19,10,15},
 { 2, 4, 1, 1,12,12,13,19,17,17},
 { 1, 4, 4, 7,10,13,12,21,15,12},
 { 3, 4, 1, 3, 8,10,17,19, 8,15},
 { 3, 4, 2, 6, 8,19,10, 8, 8,13},
 {23, 3, 7, 3, 8,10,10, 8,13,12}}
// End of GPU gfx1101_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A2__F28 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 9;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 9;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 32 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

