/*
 * tlscerts.h
 * vim: expandtab:ts=4:sts=4:sw=4
 *
 * Copyright (C) 2012 - 2019 James Booth <boothj5@gmail.com>
 *
 * This file is part of Profanity.
 *
 * Profanity is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Profanity is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Profanity.  If not, see <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give permission to
 * link the code of portions of this program with the OpenSSL library under
 * certain conditions as described in each individual source file, and
 * distribute linked combinations including the two.
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception, you
 * may extend this exception to your version of the file(s), but you are not
 * obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version. If you delete this exception statement from all
 * source files in the program, then also delete it here.
 *
 */

#ifndef CONFIG_TLSCERTS_H
#define CONFIG_TLSCERTS_H

#include <glib.h>

typedef struct tls_cert_name_t
{
    gchar* country;
    gchar* state;
    gchar* distinguishedname;
    gchar* serialnumber;
    gchar* commonname;
    gchar* organisation;
    gchar* organisation_unit;
    gchar* email;
} tls_cert_name_t;

typedef struct tls_cert_t
{
    int version;
    const gchar* fingerprint;
    gchar* serialnumber;
    gchar* subjectname;
    tls_cert_name_t subject;
    gchar* issuername;
    tls_cert_name_t issuer;
    gchar* notbefore;
    gchar* notafter;
    gchar* fingerprint_sha1;
    gchar* fingerprint_sha256;
    gchar* key_alg;
    gchar* signature_alg;
    gchar* pem;
    gchar* pubkey_fingerprint;
} TLSCertificate;

void tlscerts_init(void);

TLSCertificate* tlscerts_new(const char* fingerprint_sha1, int version, const char* serialnumber, const char* subjectname,
                             const char* issuername, const char* notbefore, const char* notafter,
                             const char* key_alg, const char* signature_alg, const char* pem,
                             const char* fingerprint_sha256, const char* pubkey_fingerprint);

void tlscerts_set_current(const TLSCertificate* cert);

gboolean tlscerts_current_fingerprint_equals(const TLSCertificate* cert);

void tlscerts_clear_current(void);

gboolean tlscerts_exists(const TLSCertificate* cert);

void tlscerts_add(const TLSCertificate* cert);

gboolean tlscerts_revoke(const char* fingerprint);

TLSCertificate* tlscerts_get_trusted(const char* fingerprint);

void tlscerts_free(TLSCertificate* cert);

GList* tlscerts_list(void);

char* tlscerts_complete(const char* prefix, gboolean previous, void* context);

void tlscerts_reset_ac(void);

#endif
