#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkOSPRayActorNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayAMRVolumeMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayCameraNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayCompositePolyDataMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayLightNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayMaterialHelpers_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayMaterialLibrary_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayMoleculeMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayPolyDataMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayPointGaussianMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayRendererNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayUnstructuredVolumeMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayViewNodeFactory_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayVolumeMapperNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayVolumeNode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOSPRayWindowNode_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingRayTracingCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkOSPRayActorNode_Init(csi);
  vtkOSPRayAMRVolumeMapperNode_Init(csi);
  vtkOSPRayCameraNode_Init(csi);
  vtkOSPRayCompositePolyDataMapperNode_Init(csi);
  vtkOSPRayLightNode_Init(csi);
  vtkOSPRayMaterialHelpers_Init(csi);
  vtkOSPRayMaterialLibrary_Init(csi);
  vtkOSPRayMoleculeMapperNode_Init(csi);
  vtkOSPRayPass_Init(csi);
  vtkOSPRayPolyDataMapperNode_Init(csi);
  vtkOSPRayPointGaussianMapperNode_Init(csi);
  vtkOSPRayRendererNode_Init(csi);
  vtkOSPRayUnstructuredVolumeMapperNode_Init(csi);
  vtkOSPRayViewNodeFactory_Init(csi);
  vtkOSPRayVolumeMapper_Init(csi);
  vtkOSPRayVolumeMapperNode_Init(csi);
  vtkOSPRayVolumeNode_Init(csi);
  vtkOSPRayWindowNode_Init(csi);
}
