#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkDynamic2DLabelMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFreeTypeLabelRenderStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabeledDataMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabeledTreeMapDataMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelHierarchy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelHierarchyAlgorithm_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelHierarchyCompositeIterator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelHierarchyIterator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelPlacementMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelPlacer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelRenderStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLabelSizeCalculator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointSetToLabelHierarchy_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingLabelCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkDynamic2DLabelMapper_Init(csi);
  vtkFreeTypeLabelRenderStrategy_Init(csi);
  vtkLabeledDataMapper_Init(csi);
  vtkLabeledTreeMapDataMapper_Init(csi);
  vtkLabelHierarchy_Init(csi);
  vtkLabelHierarchyAlgorithm_Init(csi);
  vtkLabelHierarchyCompositeIterator_Init(csi);
  vtkLabelHierarchyIterator_Init(csi);
  vtkLabelPlacementMapper_Init(csi);
  vtkLabelPlacer_Init(csi);
  vtkLabelRenderStrategy_Init(csi);
  vtkLabelSizeCalculator_Init(csi);
  vtkPointSetToLabelHierarchy_Init(csi);
}
