// python wrapper for vtkSMParaViewPipelineControllerWithRendering
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMParaViewPipelineControllerWithRendering.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMParaViewPipelineControllerWithRendering(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMParaViewPipelineControllerWithRendering_ClassNew(); }


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMParaViewPipelineControllerWithRendering::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMParaViewPipelineControllerWithRendering::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMParaViewPipelineControllerWithRendering *tempr = vtkSMParaViewPipelineControllerWithRendering::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMParaViewPipelineControllerWithRendering *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMParaViewPipelineControllerWithRendering::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMParaViewPipelineControllerWithRendering::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMParaViewPipelineControllerWithRendering::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_Show_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Show");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  vtkSMViewProxy *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMViewProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->Show(temp0, temp1, temp2) :
      op->vtkSMParaViewPipelineControllerWithRendering::Show(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_Show_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Show");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  vtkSMViewProxy *temp2 = nullptr;
  const char *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMViewProxy") &&
      ap.GetValue(temp3))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->Show(temp0, temp1, temp2, temp3) :
      op->vtkSMParaViewPipelineControllerWithRendering::Show(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_Show(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkSMParaViewPipelineControllerWithRendering_Show_s1(self, args);
    case 4:
      return PyvtkSMParaViewPipelineControllerWithRendering_Show_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Show");
  return nullptr;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_ShowAll(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowAll");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    if (ap.IsBound())
    {
      op->ShowAll(temp0);
    }
    else
    {
      op->vtkSMParaViewPipelineControllerWithRendering::ShowAll(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_Hide_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Hide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  vtkSMViewProxy *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMViewProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->Hide(temp0, temp1, temp2) :
      op->vtkSMParaViewPipelineControllerWithRendering::Hide(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_Hide_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Hide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMViewProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMViewProxy"))
  {
    if (ap.IsBound())
    {
      op->Hide(temp0, temp1);
    }
    else
    {
      op->vtkSMParaViewPipelineControllerWithRendering::Hide(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_Hide(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkSMParaViewPipelineControllerWithRendering_Hide_s1(self, args);
    case 2:
      return PyvtkSMParaViewPipelineControllerWithRendering_Hide_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Hide");
  return nullptr;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_HideAll(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideAll");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    if (ap.IsBound())
    {
      op->HideAll(temp0);
    }
    else
    {
      op->vtkSMParaViewPipelineControllerWithRendering::HideAll(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  vtkSMViewProxy *temp2 = nullptr;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMViewProxy") &&
      ap.GetValue(temp3))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->SetVisibility(temp0, temp1, temp2, temp3) :
      op->vtkSMParaViewPipelineControllerWithRendering::SetVisibility(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_GetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  vtkSMViewProxy *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMViewProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVisibility(temp0, temp1, temp2) :
      op->vtkSMParaViewPipelineControllerWithRendering::GetVisibility(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_ShowInPreferredView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowInPreferredView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  vtkSMViewProxy *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkSMViewProxy"))
  {
    vtkSMViewProxy *tempr = (ap.IsBound() ?
      op->ShowInPreferredView(temp0, temp1, temp2) :
      op->vtkSMParaViewPipelineControllerWithRendering::ShowInPreferredView(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_GetPreferredViewType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreferredViewType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPreferredViewType(temp0, temp1) :
      op->vtkSMParaViewPipelineControllerWithRendering::GetPreferredViewType(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_GetPipelineIcon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPipelineIcon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPipelineIcon(temp0, temp1) :
      op->vtkSMParaViewPipelineControllerWithRendering::GetPipelineIcon(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_RegisterRepresentationProxy_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterRepresentationProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->RegisterRepresentationProxy(temp0) :
      op->vtkSMParaViewPipelineControllerWithRendering::RegisterRepresentationProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_RegisterRepresentationProxy_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterRepresentationProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->RegisterRepresentationProxy(temp0, temp1) :
      op->vtkSMParaViewPipelineControllerWithRendering::RegisterRepresentationProxy(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_RegisterRepresentationProxy(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMParaViewPipelineControllerWithRendering_RegisterRepresentationProxy_s1(self, args);
    case 2:
      return PyvtkSMParaViewPipelineControllerWithRendering_RegisterRepresentationProxy_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RegisterRepresentationProxy");
  return nullptr;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_SetHideScalarBarOnHide(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod SetHideScalarBarOnHide."
    " (" "Use vtkPVGeneralSettings::SetScalarBarMode(AUTOMATICALLY_HIDE_SCALAR_BARS) instead" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "SetHideScalarBarOnHide");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMParaViewPipelineControllerWithRendering::SetHideScalarBarOnHide(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_SetInheritRepresentationProperties(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod SetInheritRepresentationProperties."
    " (" "Use vtkPVGeneralSettings::SetInheritRepresentationProperties() instead" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "SetInheritRepresentationProperties");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMParaViewPipelineControllerWithRendering::SetInheritRepresentationProperties(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_GetInheritRepresentationProperties(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod GetInheritRepresentationProperties."
    " (" "Use vtkPVGeneralSettings::GetInheritRepresentationProperties() instead" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "GetInheritRepresentationProperties");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkSMParaViewPipelineControllerWithRendering::GetInheritRepresentationProperties();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_PostInitializeProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PostInitializeProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->PostInitializeProxy(temp0) :
      op->vtkSMParaViewPipelineControllerWithRendering::PostInitializeProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_RegisterLayoutProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterLayoutProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->RegisterLayoutProxy(temp0, temp1) :
      op->vtkSMParaViewPipelineControllerWithRendering::RegisterLayoutProxy(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMParaViewPipelineControllerWithRendering_AssignViewToLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AssignViewToLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMParaViewPipelineControllerWithRendering *op = static_cast<vtkSMParaViewPipelineControllerWithRendering *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  vtkSMViewLayoutProxy *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy") &&
      (ap.NoArgsLeft() || ap.GetVTKObject(temp1, "vtkSMViewLayoutProxy")) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->AssignViewToLayout(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMParaViewPipelineControllerWithRendering::AssignViewToLayout(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMParaViewPipelineControllerWithRendering_Methods[] = {
  {"IsTypeOf", PyvtkSMParaViewPipelineControllerWithRendering_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMParaViewPipelineControllerWithRendering_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMParaViewPipelineControllerWithRendering_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkSMParaViewPipelineControllerWithRendering\nC++: static vtkSMParaViewPipelineControllerWithRendering *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMParaViewPipelineControllerWithRendering_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMParaViewPipelineControllerWithRendering\nC++: vtkSMParaViewPipelineControllerWithRendering *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMParaViewPipelineControllerWithRendering_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMParaViewPipelineControllerWithRendering_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Show", PyvtkSMParaViewPipelineControllerWithRendering_Show, METH_VARARGS,
   "Show(self, producer:vtkSMSourceProxy, outputPort:int,\n    view:vtkSMViewProxy) -> vtkSMProxy\nC++: virtual vtkSMProxy *Show(vtkSMSourceProxy *producer,\n    int outputPort, vtkSMViewProxy *view)\nShow(self, producer:vtkSMSourceProxy, outputPort:int,\n    view:vtkSMViewProxy, representationType:str) -> vtkSMProxy\nC++: virtual vtkSMProxy *Show(vtkSMSourceProxy *producer,\n    int outputPort, vtkSMViewProxy *view,\n    const char *representationType)\n\nShow the output data in the view. If data cannot be shown in the\nview, returns nullptr. If view is nullptr, this simply calls\nShowInPreferredView().\n"},
  {"ShowAll", PyvtkSMParaViewPipelineControllerWithRendering_ShowAll, METH_VARARGS,
   "ShowAll(self, view:vtkSMViewProxy) -> None\nC++: void ShowAll(vtkSMViewProxy *view)\n\nShow all source output ports in provided view.\n"},
  {"Hide", PyvtkSMParaViewPipelineControllerWithRendering_Hide, METH_VARARGS,
   "Hide(self, producer:vtkSMSourceProxy, outputPort:int,\n    view:vtkSMViewProxy) -> vtkSMProxy\nC++: virtual vtkSMProxy *Hide(vtkSMSourceProxy *producer,\n    int outputPort, vtkSMViewProxy *view)\nHide(self, repr:vtkSMProxy, view:vtkSMViewProxy) -> None\nC++: virtual void Hide(vtkSMProxy *repr, vtkSMViewProxy *view)\n\nOpposite of Show(). Locates the representation for the producer\nand then hides it, if found. Returns that representation, if\nfound.\n"},
  {"HideAll", PyvtkSMParaViewPipelineControllerWithRendering_HideAll, METH_VARARGS,
   "HideAll(self, view:vtkSMViewProxy) -> None\nC++: virtual void HideAll(vtkSMViewProxy *view)\n\nHide all visible sources output ports in provided view\n"},
  {"SetVisibility", PyvtkSMParaViewPipelineControllerWithRendering_SetVisibility, METH_VARARGS,
   "SetVisibility(self, producer:vtkSMSourceProxy, outputPort:int,\n    view:vtkSMViewProxy, visible:bool) -> vtkSMProxy\nC++: vtkSMProxy *SetVisibility(vtkSMSourceProxy *producer,\n    int outputPort, vtkSMViewProxy *view, bool visible)\n\nAlternative method to call Show and Hide using a visibility flag.\n"},
  {"GetVisibility", PyvtkSMParaViewPipelineControllerWithRendering_GetVisibility, METH_VARARGS,
   "GetVisibility(self, producer:vtkSMSourceProxy, outputPort:int,\n    view:vtkSMViewProxy) -> bool\nC++: virtual bool GetVisibility(vtkSMSourceProxy *producer,\n    int outputPort, vtkSMViewProxy *view)\n\nReturns whether the producer/port are shown in the given view.\n"},
  {"ShowInPreferredView", PyvtkSMParaViewPipelineControllerWithRendering_ShowInPreferredView, METH_VARARGS,
   "ShowInPreferredView(self, producer:vtkSMSourceProxy,\n    outputPort:int, view:vtkSMViewProxy) -> vtkSMViewProxy\nC++: virtual vtkSMViewProxy *ShowInPreferredView(\n    vtkSMSourceProxy *producer, int outputPort,\n    vtkSMViewProxy *view)\n\nSame as Show() except that if the view is nullptr or not the\npreferred view for the producer's output, this method will create\na new view and show the data in that new view.\n\nThere are several different strategies employed to determine the\npreferred view for the producer's output. See\nvtkSMParaViewPipelineControllerWithRendering::GetPreferredViewType\n() for details.\n\note if the source's hint indicates so, the data may also be\n      shown in the view passed in, in addition to the preferred\nview.\n      This is done by using the `also_show_in_current_view`\nattribute to\n      the `<View />` hint.\n\n@returns the view in which the data ends up being shown, if any.\n         It may return nullptr if the view is not the preferred\ntype\n         or the preferred cannot be determined or created.\n"},
  {"GetPreferredViewType", PyvtkSMParaViewPipelineControllerWithRendering_GetPreferredViewType, METH_VARARGS,
   "GetPreferredViewType(self, producer:vtkSMSourceProxy,\n    outputPort:int) -> str\nC++: virtual const char *GetPreferredViewType(\n    vtkSMSourceProxy *producer, int outputPort)\n\nReturns the name for the preferred view type, if there is any.\nThere are several strategies employed by the default\nimplementation to determine the preferred view type.\n\n-# Using XML hints.\n\n\n   A producer proxy can provide XML hints to define the preferred\nview type\n   of each (or all) of its output ports. This is done as follows:\n\n   {xml}\n     \n       \n         <View type=\"<view name>\" port=\"<output port number\" />\n       \n        \n\n\n   Attribute `port` is optional and only needed to explicitly\nspecify\n   different view types for different output ports.\n\n-# Using data type.\n\n\n   If the data type for the generated data is `vtkTable`, then\nthe\n   preferred view (if none provided) is assumed to be\n`SpreadSheetView`.\n\n@returns XML name for the preferred view proxy. It is assumed to\n    be defined\n         in the \"views\" group.\n"},
  {"GetPipelineIcon", PyvtkSMParaViewPipelineControllerWithRendering_GetPipelineIcon, METH_VARARGS,
   "GetPipelineIcon(self, producer:vtkSMSourceProxy, outputPort:int)\n    -> str\nC++: virtual const char *GetPipelineIcon(\n    vtkSMSourceProxy *producer, int outputPort)\n\nReturn the pipeline icon to use with the provided producer. It\ncan be either a view type name, an existing icon resource or\nnullptr. Here is the strategy to determine the pipeline icon.\n\n# Using XML hints. A producer proxy can provide XML hints to\n  define the pipeline icon to use of each (or all) of its output\n  ports. This is done as follows:\n\n   {xml}\n     \n       \n         <PipelineIcon name=\"<view name or icon resource>\" port=\"<output port\nnumber>\" />\n       \n        \n\n\n   Attribute `port` is optional and only needed to explicitly\nspecify\n   different view types for different output ports.\n\n# Using GetPreferredViewType If no PipelineIcon as been provided,\nwe fall back to using GetPreferredViewType.\n"},
  {"RegisterRepresentationProxy", PyvtkSMParaViewPipelineControllerWithRendering_RegisterRepresentationProxy, METH_VARARGS,
   "RegisterRepresentationProxy(self, proxy:vtkSMProxy) -> bool\nC++: bool RegisterRepresentationProxy(vtkSMProxy *proxy) override;\nRegisterRepresentationProxy(self, proxy:vtkSMProxy, proxyname:str)\n     -> bool\nC++: virtual bool RegisterRepresentationProxy(vtkSMProxy *proxy,\n    const char *proxyname)\n\nOverridden to create color and opacity transfer functions if\napplicable. While it is tempting to add any default property\nsetup logic in such overrides, we must keep such overrides to a\nminimal and opting for domains that set appropriate defaults\nwhere as much as possible.\n"},
  {"SetHideScalarBarOnHide", PyvtkSMParaViewPipelineControllerWithRendering_SetHideScalarBarOnHide, METH_VARARGS,
   "SetHideScalarBarOnHide(__a:bool) -> None\nC++: static void SetHideScalarBarOnHide(bool)\n\nControl how scalar bar visibility is updated by the Hide call.\n"},
  {"SetInheritRepresentationProperties", PyvtkSMParaViewPipelineControllerWithRendering_SetInheritRepresentationProperties, METH_VARARGS,
   "SetInheritRepresentationProperties(__a:bool) -> None\nC++: static void SetInheritRepresentationProperties(bool)\n\nControl whether representations try to maintain properties from\nan input representation, if present. e.g. if you \"Transform\" the\nrepresentation for a source, then any filter that you connect to\nit should be transformed as well.\n"},
  {"GetInheritRepresentationProperties", PyvtkSMParaViewPipelineControllerWithRendering_GetInheritRepresentationProperties, METH_VARARGS,
   "GetInheritRepresentationProperties() -> bool\nC++: static bool GetInheritRepresentationProperties()\n\n"},
  {"PostInitializeProxy", PyvtkSMParaViewPipelineControllerWithRendering_PostInitializeProxy, METH_VARARGS,
   "PostInitializeProxy(self, proxy:vtkSMProxy) -> bool\nC++: bool PostInitializeProxy(vtkSMProxy *proxy) override;\n\nOverridden to handle default ColorArrayName for representations\ncorrectly.\n"},
  {"RegisterLayoutProxy", PyvtkSMParaViewPipelineControllerWithRendering_RegisterLayoutProxy, METH_VARARGS,
   "RegisterLayoutProxy(self, proxy:vtkSMProxy, proxyname:str=...)\n    -> bool\nC++: virtual bool RegisterLayoutProxy(vtkSMProxy *proxy,\n    const char *proxyname=nullptr)\n\nRegister layout proxy. If `proxyname` is nullptr, a new name will\nbe assigned.\n"},
  {"AssignViewToLayout", PyvtkSMParaViewPipelineControllerWithRendering_AssignViewToLayout, METH_VARARGS,
   "AssignViewToLayout(self, view:vtkSMViewProxy,\n    layout:vtkSMViewLayoutProxy=..., hint:int=0) -> None\nC++: virtual void AssignViewToLayout(vtkSMViewProxy *view,\n    vtkSMViewLayoutProxy *layout=nullptr, int hint=0)\n\nAssigns the view to any cell in the layout. If the layout is\nnullptr, then this will locate a layout on the same session and\nuse it. If no layout is present on the session, a new layout will\nbe created (and registered) before assigning the view to it.\n\nIf the view is already assigned to a layout then this method is a\nno-op.\n\n@sa vtkSMViewProxy::AssignViewToAnyCell\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMParaViewPipelineControllerWithRendering_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("hide_scalar_bar_on_hide"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMParaViewPipelineControllerWithRendering_SetHideScalarBarOnHide(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMParaViewPipelineControllerWithRendering_SetHideScalarBarOnHide(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHideScalarBarOnHide\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("inherit_representation_properties"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMParaViewPipelineControllerWithRendering_GetInheritRepresentationProperties(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMParaViewPipelineControllerWithRendering_SetInheritRepresentationProperties(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMParaViewPipelineControllerWithRendering_SetInheritRepresentationProperties(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInheritRepresentationProperties/SetInheritRepresentationProperties\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMParaViewPipelineControllerWithRendering_Doc =
  "vtkSMParaViewPipelineControllerWithRendering -\nvtkSMParaViewPipelineControllerWithRendering overrides\nvtkSMParaViewPipelineController to add support for initializing\nrendering proxies appropriately.\n\n"
  "Superclass: vtkSMParaViewPipelineController\n\n"
  "vtkSMParaViewPipelineControllerWithRendering uses vtkObjectFactory\n"
  "mechanisms to override vtkSMParaViewPipelineController's creation.\n"
  "One should not need to create or use this class directly (excepting\n"
  "when needing to subclass). Simply create\n"
  "vtkSMParaViewPipelineController. If the application is linked with\n"
  "the rendering module, then this class will be instantiated instead of\n"
  "vtkSMParaViewPipelineController automatically.\n\n"
  "vtkSMParaViewPipelineControllerWithRendering also adds new API to\n"
  "control representation visibility and manage creation of views. To\n"
  "use that API clients can instantiate\n"
  "vtkSMParaViewPipelineControllerWithRendering. Just like\n"
  "vtkSMParaViewPipelineController, this class also uses\n"
  "vtkObjectFactory mechanisms to enable overriding by clients at\n"
  "compile time.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMParaViewPipelineControllerWithRendering_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMParaViewPipelineControllerWithRendering", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMParaViewPipelineControllerWithRendering_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMParaViewPipelineControllerWithRendering_StaticNew()
{
  return vtkSMParaViewPipelineControllerWithRendering::New();
}

PyObject *PyvtkSMParaViewPipelineControllerWithRendering_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMParaViewPipelineControllerWithRendering_Type, PyvtkSMParaViewPipelineControllerWithRendering_Methods,
    "vtkSMParaViewPipelineControllerWithRendering",
 &PyvtkSMParaViewPipelineControllerWithRendering_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMParaViewPipelineController");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMParaViewPipelineControllerWithRendering_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMParaViewPipelineControllerWithRendering(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMParaViewPipelineControllerWithRendering_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMParaViewPipelineControllerWithRendering", o) != 0)
  {
    Py_DECREF(o);
  }

}

