// python wrapper for vtkPVGridAxes3DActor
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVGridAxes3DActor.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVGridAxes3DActor(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVGridAxes3DActor_ClassNew(); }


static PyObject *
PyvtkPVGridAxes3DActor_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVGridAxes3DActor::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVGridAxes3DActor::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVGridAxes3DActor *tempr = vtkPVGridAxes3DActor::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVGridAxes3DActor *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVGridAxes3DActor::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVGridAxes3DActor::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVGridAxes3DActor::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_ShallowCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShallowCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  vtkProp *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProp"))
  {
    if (ap.IsBound())
    {
      op->ShallowCopy(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::ShallowCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetDataScale_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDataScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetDataScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetDataScale_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetDataScale(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetDataScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetDataScale(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVGridAxes3DActor_SetDataScale_s1(self, args);
    case 1:
      return PyvtkPVGridAxes3DActor_SetDataScale_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetDataScale");
  return nullptr;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetDataScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetDataScale() :
      op->vtkPVGridAxes3DActor::GetDataScale());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetDataPosition_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDataPosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetDataPosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetDataPosition_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetDataPosition(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetDataPosition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetDataPosition(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVGridAxes3DActor_SetDataPosition_s1(self, args);
    case 1:
      return PyvtkPVGridAxes3DActor_SetDataPosition_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetDataPosition");
  return nullptr;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetDataPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetDataPosition() :
      op->vtkPVGridAxes3DActor::GetDataPosition());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetDataBoundsScaleFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataBoundsScaleFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataBoundsScaleFactor(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetDataBoundsScaleFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetDataBoundsScaleFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataBoundsScaleFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDataBoundsScaleFactor() :
      op->vtkPVGridAxes3DActor::GetDataBoundsScaleFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetTransformedBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetTransformedBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetTransformedBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetTransformedBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTransformedBounds(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetTransformedBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetTransformedBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkPVGridAxes3DActor_SetTransformedBounds_s1(self, args);
    case 1:
      return PyvtkPVGridAxes3DActor_SetTransformedBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTransformedBounds");
  return nullptr;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetTransformedBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTransformedBounds() :
      op->vtkPVGridAxes3DActor::GetTransformedBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetUseCustomTransformedBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCustomTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCustomTransformedBounds(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetUseCustomTransformedBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetUseCustomTransformedBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCustomTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCustomTransformedBounds() :
      op->vtkPVGridAxes3DActor::GetUseCustomTransformedBounds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetCustomTransformedBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetCustomTransformedBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetCustomTransformedBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetCustomTransformedBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCustomTransformedBounds(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetCustomTransformedBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetCustomTransformedBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkPVGridAxes3DActor_SetCustomTransformedBounds_s1(self, args);
    case 1:
      return PyvtkPVGridAxes3DActor_SetCustomTransformedBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCustomTransformedBounds");
  return nullptr;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetCustomTransformedBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomTransformedBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCustomTransformedBounds() :
      op->vtkPVGridAxes3DActor::GetCustomTransformedBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetUseModelTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseModelTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseModelTransform(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetUseModelTransform(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetUseModelTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseModelTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseModelTransform() :
      op->vtkPVGridAxes3DActor::GetUseModelTransform());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_UseModelTransformOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseModelTransformOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseModelTransformOn();
    }
    else
    {
      op->vtkPVGridAxes3DActor::UseModelTransformOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_UseModelTransformOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseModelTransformOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseModelTransformOff();
    }
    else
    {
      op->vtkPVGridAxes3DActor::UseModelTransformOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetModelBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetModelBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetModelBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetModelBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetModelBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetModelBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetModelBounds(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetModelBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVGridAxes3DActor_SetModelBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkPVGridAxes3DActor_SetModelBounds_s1(self, args);
    case 1:
      return PyvtkPVGridAxes3DActor_SetModelBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetModelBounds");
  return nullptr;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetModelBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetModelBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetModelBounds() :
      op->vtkPVGridAxes3DActor::GetModelBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_SetModelTransformMatrix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetModelTransformMatrix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetModelTransformMatrix(temp0);
    }
    else
    {
      op->vtkPVGridAxes3DActor::SetModelTransformMatrix(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGridAxes3DActor_GetBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGridAxes3DActor *op = static_cast<vtkPVGridAxes3DActor *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBounds() :
      op->vtkPVGridAxes3DActor::GetBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVGridAxes3DActor_Methods[] = {
  {"IsTypeOf", PyvtkPVGridAxes3DActor_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVGridAxes3DActor_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVGridAxes3DActor_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVGridAxes3DActor\nC++: static vtkPVGridAxes3DActor *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVGridAxes3DActor_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVGridAxes3DActor\nC++: vtkPVGridAxes3DActor *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVGridAxes3DActor_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVGridAxes3DActor_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ShallowCopy", PyvtkPVGridAxes3DActor_ShallowCopy, METH_VARARGS,
   "ShallowCopy(self, prop:vtkProp) -> None\nC++: void ShallowCopy(vtkProp *prop) override;\n\nShallow copy from another vtkPVGridAxes3DActor.\n"},
  {"SetDataScale", PyvtkPVGridAxes3DActor_SetDataScale, METH_VARARGS,
   "SetDataScale(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetDataScale(double _arg1, double _arg2,\n    double _arg3)\nSetDataScale(self, _arg:(float, float, float)) -> None\nC++: virtual void SetDataScale(const double _arg[3])\n\nSpecify transformation used by the data.\n"},
  {"GetDataScale", PyvtkPVGridAxes3DActor_GetDataScale, METH_VARARGS,
   "GetDataScale(self) -> (float, float, float)\nC++: virtual double *GetDataScale()\n\n"},
  {"SetDataPosition", PyvtkPVGridAxes3DActor_SetDataPosition, METH_VARARGS,
   "SetDataPosition(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetDataPosition(double _arg1, double _arg2,\n    double _arg3)\nSetDataPosition(self, _arg:(float, float, float)) -> None\nC++: virtual void SetDataPosition(const double _arg[3])\n\n"},
  {"GetDataPosition", PyvtkPVGridAxes3DActor_GetDataPosition, METH_VARARGS,
   "GetDataPosition(self) -> (float, float, float)\nC++: virtual double *GetDataPosition()\n\n"},
  {"SetDataBoundsScaleFactor", PyvtkPVGridAxes3DActor_SetDataBoundsScaleFactor, METH_VARARGS,
   "SetDataBoundsScaleFactor(self, _arg:float) -> None\nC++: virtual void SetDataBoundsScaleFactor(double _arg)\n\nSpecify the scale factor used to proportionally scale each axis.\n1 means no change.\n"},
  {"GetDataBoundsScaleFactor", PyvtkPVGridAxes3DActor_GetDataBoundsScaleFactor, METH_VARARGS,
   "GetDataBoundsScaleFactor(self) -> float\nC++: virtual double GetDataBoundsScaleFactor()\n\n"},
  {"SetTransformedBounds", PyvtkPVGridAxes3DActor_SetTransformedBounds, METH_VARARGS,
   "SetTransformedBounds(self, _arg1:float, _arg2:float, _arg3:float,\n    _arg4:float, _arg5:float, _arg6:float) -> None\nC++: virtual void SetTransformedBounds(double _arg1, double _arg2,\n     double _arg3, double _arg4, double _arg5, double _arg6)\nSetTransformedBounds(self, _arg:(float, float, float, float,\n    float, float)) -> None\nC++: virtual void SetTransformedBounds(const double _arg[6])\n\nAnother way for specifying grid bounds except here the bounds are\nconsidered to be pre-transformed. Using the DataPosition,\nDataScale, and DataBoundsScaleFactor, the provided bounds will\nun-transformed before calling this->SetGridBounds() and then\nposition and scale are instead passed on the vtkActor. This\nresults in display scaling rather than data scaling.\n"},
  {"GetTransformedBounds", PyvtkPVGridAxes3DActor_GetTransformedBounds, METH_VARARGS,
   "GetTransformedBounds(self) -> (float, float, float, float, float,\n    float)\nC++: virtual double *GetTransformedBounds()\n\n"},
  {"SetUseCustomTransformedBounds", PyvtkPVGridAxes3DActor_SetUseCustomTransformedBounds, METH_VARARGS,
   "SetUseCustomTransformedBounds(self, _arg:bool) -> None\nC++: virtual void SetUseCustomTransformedBounds(bool _arg)\n\nIf set to true, CustomTransformedBounds are used instead of\nTransformedBounds. Default is false.\n"},
  {"GetUseCustomTransformedBounds", PyvtkPVGridAxes3DActor_GetUseCustomTransformedBounds, METH_VARARGS,
   "GetUseCustomTransformedBounds(self) -> bool\nC++: virtual bool GetUseCustomTransformedBounds()\n\n"},
  {"SetCustomTransformedBounds", PyvtkPVGridAxes3DActor_SetCustomTransformedBounds, METH_VARARGS,
   "SetCustomTransformedBounds(self, _arg1:float, _arg2:float,\n    _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None\nC++: virtual void SetCustomTransformedBounds(double _arg1,\n    double _arg2, double _arg3, double _arg4, double _arg5,\n    double _arg6)\nSetCustomTransformedBounds(self, _arg:(float, float, float, float,\n     float, float)) -> None\nC++: virtual void SetCustomTransformedBounds(const double _arg[6])\n\nSame as TransformedBounds, except used only when\nUseCustomTransformedBounds is set.\n"},
  {"GetCustomTransformedBounds", PyvtkPVGridAxes3DActor_GetCustomTransformedBounds, METH_VARARGS,
   "GetCustomTransformedBounds(self) -> (float, float, float, float,\n    float, float)\nC++: virtual double *GetCustomTransformedBounds()\n\n"},
  {"SetUseModelTransform", PyvtkPVGridAxes3DActor_SetUseModelTransform, METH_VARARGS,
   "SetUseModelTransform(self, _arg:bool) -> None\nC++: virtual void SetUseModelTransform(bool _arg)\n\n"},
  {"GetUseModelTransform", PyvtkPVGridAxes3DActor_GetUseModelTransform, METH_VARARGS,
   "GetUseModelTransform(self) -> bool\nC++: virtual bool GetUseModelTransform()\n\n"},
  {"UseModelTransformOn", PyvtkPVGridAxes3DActor_UseModelTransformOn, METH_VARARGS,
   "UseModelTransformOn(self) -> None\nC++: virtual void UseModelTransformOn()\n\n"},
  {"UseModelTransformOff", PyvtkPVGridAxes3DActor_UseModelTransformOff, METH_VARARGS,
   "UseModelTransformOff(self) -> None\nC++: virtual void UseModelTransformOff()\n\n"},
  {"SetModelBounds", PyvtkPVGridAxes3DActor_SetModelBounds, METH_VARARGS,
   "SetModelBounds(self, _arg1:float, _arg2:float, _arg3:float,\n    _arg4:float, _arg5:float, _arg6:float) -> None\nC++: virtual void SetModelBounds(double _arg1, double _arg2,\n    double _arg3, double _arg4, double _arg5, double _arg6)\nSetModelBounds(self, _arg:(float, float, float, float, float,\n    float)) -> None\nC++: virtual void SetModelBounds(const double _arg[6])\n\n"},
  {"GetModelBounds", PyvtkPVGridAxes3DActor_GetModelBounds, METH_VARARGS,
   "GetModelBounds(self) -> (float, float, float, float, float, float)\nC++: virtual double *GetModelBounds()\n\n"},
  {"SetModelTransformMatrix", PyvtkPVGridAxes3DActor_SetModelTransformMatrix, METH_VARARGS,
   "SetModelTransformMatrix(self, matrix:[float, ...]) -> None\nC++: void SetModelTransformMatrix(double *matrix)\n\n"},
  {"GetBounds", PyvtkPVGridAxes3DActor_GetBounds, METH_VARARGS,
   "GetBounds(self) -> (float, float, float, float, float, float)\nC++: double *GetBounds() override;\n\nOverridden to ensure that the transform information is passed on\nthe superclass.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVGridAxes3DActor_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("data_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetDataScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetDataScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetDataScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataScale/SetDataScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetDataPosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetDataPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetDataPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataPosition/SetDataPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_bounds_scale_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetDataBoundsScaleFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetDataBoundsScaleFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetDataBoundsScaleFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataBoundsScaleFactor/SetDataBoundsScaleFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("transformed_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetTransformedBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetTransformedBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetTransformedBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTransformedBounds/SetTransformedBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_custom_transformed_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetUseCustomTransformedBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetUseCustomTransformedBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetUseCustomTransformedBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCustomTransformedBounds/SetUseCustomTransformedBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_transformed_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetCustomTransformedBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetCustomTransformedBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetCustomTransformedBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomTransformedBounds/SetCustomTransformedBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_model_transform"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetUseModelTransform(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetUseModelTransform(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetUseModelTransform(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseModelTransform/SetUseModelTransform\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("model_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetModelBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetModelBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetModelBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetModelBounds/SetModelBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("model_transform_matrix"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGridAxes3DActor_SetModelTransformMatrix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGridAxes3DActor_SetModelTransformMatrix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetModelTransformMatrix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGridAxes3DActor_GetBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBounds\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVGridAxes3DActor_Doc =
  "vtkPVGridAxes3DActor - ParaView extensions for vtkGridAxesActor3D.\n\n"
  "Superclass: vtkGridAxesActor3D\n\n"
  "vtkPVGridAxes3DActor adds support for ParaView-specific use-cases to\n"
  "vtkGridAxesActor3D. The special use-cases are:\n"
  "\\li Showing original data bounds when data has been transformed by\n"
  "specifying a transform on the Display properties: To support this, we\n"
  "add API to set the DataScale and DataPosition (we cannot support\n"
  "rotations, I am afraid). User is expected to set these to match the\n"
  "Scale and Position set on the Display properties of the data.\n"
  "vtkPVGridAxes3DActor converts that to scale and position on the\n"
  "vtkProperty for the superclass and sets the GridBounds on the\n"
  "superclass transformed using an inverse of the specified transform on\n"
  "the bounds reported by vtkPVRenderView. vtkPVRenderView uses\n"
  "SetTransformedBounds to set the bounds.\n\n"
  "\\li Supporting change of basis transformations: for that, one is\n"
  "    expected to\n"
  "set UseModelTransform to true, and then specify the ModelBounds and\n"
  "ModelTransformMatrix. Note: ModelTransform and DataScale/DataPosition\n"
  "are mutually exclusive.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGridAxes3DActor_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVGridAxes3DActor", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVGridAxes3DActor_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVGridAxes3DActor_StaticNew()
{
  return vtkPVGridAxes3DActor::New();
}

PyObject *PyvtkPVGridAxes3DActor_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVGridAxes3DActor_Type, PyvtkPVGridAxes3DActor_Methods,
    "vtkPVGridAxes3DActor",
 &PyvtkPVGridAxes3DActor_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkGridAxesActor3D");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVGridAxes3DActor_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVGridAxes3DActor(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVGridAxes3DActor_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVGridAxes3DActor", o) != 0)
  {
    Py_DECREF(o);
  }

}

