// python wrapper for vtkSMImporterFactory
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkSMImporterFactory.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMImporterFactory(PyObject *dict); }

static PyObject *
PyvtkSMImporterFactory_GetSupportedFileTypes(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetSupportedFileTypes");

  vtkSMSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSession"))
  {
    std::string tempr = vtkSMImporterFactory::GetSupportedFileTypes(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMImporterFactory_CreateImporter(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CreateImporter");

  const char *temp0 = nullptr;
  vtkSMSession *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSession"))
  {
    vtkSMImporterProxy *tempr = vtkSMImporterFactory::CreateImporter(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMImporterFactory_Methods[] = {
  {"GetSupportedFileTypes", PyvtkSMImporterFactory_GetSupportedFileTypes, METH_VARARGS,
   "GetSupportedFileTypes(session:vtkSMSession) -> str\nC++: static std::string GetSupportedFileTypes(\n    vtkSMSession *session)\n\nReturns a formatted string with all supported file types. An\nexample returned string would look like:\n \"GLTF Files (*.gltf);;OBJ Files (*.obj)\"\n \n"},
  {"CreateImporter", PyvtkSMImporterFactory_CreateImporter, METH_VARARGS,
   "CreateImporter(filename:str, session:vtkSMSession)\n    -> vtkSMImporterProxy\nC++: static vtkSMImporterProxy *CreateImporter(\n    const char *filename, vtkSMSession *session)\n\nImports the views from the given input file. Returns a new\nimporter instance (or nullptr). Caller must release the returned\nobject explicitly.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMImporterFactory_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkSMImporterFactory_vtkSMImporterFactory_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkSMImporterFactory");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSMImporterFactory *op = new vtkSMImporterFactory();

    result = PyVTKSpecialObject_New("vtkSMImporterFactory", op);
  }

  return result;
}

static PyObject *
PyvtkSMImporterFactory_vtkSMImporterFactory_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkSMImporterFactory");

  vtkSMImporterFactory *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkSMImporterFactory"))
  {
    vtkSMImporterFactory *op = new vtkSMImporterFactory(*temp0);

    result = PyVTKSpecialObject_New("vtkSMImporterFactory", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkSMImporterFactory_vtkSMImporterFactory_Methods[] = {
  {"vtkSMImporterFactory", PyvtkSMImporterFactory_vtkSMImporterFactory_s2, METH_VARARGS,
   "@W vtkSMImporterFactory"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMImporterFactory_vtkSMImporterFactory(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMImporterFactory_vtkSMImporterFactory_s1(self, args);
    case 1:
      return PyvtkSMImporterFactory_vtkSMImporterFactory_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkSMImporterFactory");
  return nullptr;
}


static const char *PyvtkSMImporterFactory_Doc =

  "vtkSMImporterFactory() -> vtkSMImporterFactory\nC++: vtkSMImporterFactory()\nvtkSMImporterFactory(__a:vtkSMImporterFactory) -> vtkSMImporterFactory\nC++: vtkSMImporterFactory(const &vtkSMImporterFactory)\n""\n"
  "vtkSMImporterFactory - Helper class to import meshes, textures,\nlights and camera from a file into a render view.\n\n"
  "vtkSMImporterFactory is a helper class to aid in importing files\n"
  "supported by the VTK importers.\n\n";

static PyObject *
PyvtkSMImporterFactory_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkSMImporterFactory_vtkSMImporterFactory(nullptr, args);
}

static void PyvtkSMImporterFactory_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkSMImporterFactory *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkSMImporterFactory_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMImporterFactory_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingImport.vtkSMImporterFactory", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkSMImporterFactory_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkSMImporterFactory_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkSMImporterFactory_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkSMImporterFactory_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkSMImporterFactory_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkSMImporterFactory(*static_cast<const vtkSMImporterFactory*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkSMImporterFactory_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMImporterFactory_TypeNew(); }
#define DECLARED_PyvtkSMImporterFactory_TypeNew
#endif

PyObject *PyvtkSMImporterFactory_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkSMImporterFactory_Type,
    PyvtkSMImporterFactory_Methods,
    PyvtkSMImporterFactory_GetSets,
    PyvtkSMImporterFactory_vtkSMImporterFactory_Methods,
    &PyvtkSMImporterFactory_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMImporterFactory(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMImporterFactory_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkSMImporterFactory", o) != 0)
  {
    Py_DECREF(o);
  }

}

