// python wrapper for vtkProcessModule
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkProcessModule.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkProcessModule(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkProcessModule_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkProcessModule_ProcessTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkProcessModule.ProcessTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkProcessModule_ProcessTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkProcessModule_ProcessTypes_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkProcessModule_ServerFlags_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkProcessModule.ServerFlags", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkProcessModule_ServerFlags_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkProcessModule_ServerFlags_Type, static_cast<int>(val));
}


static PyObject *
PyvtkProcessModule_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkProcessModule::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkProcessModule::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkProcessModule *tempr = vtkProcessModule::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkProcessModule *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkProcessModule::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkProcessModule::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkProcessModule::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetProcessType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetProcessType");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    typedef vtkProcessModule::ProcessTypes tempr_type;
  tempr_type tempr = vtkProcessModule::GetProcessType();

    if (!ap.ErrorOccurred())
    {
      result = PyvtkProcessModule_ProcessTypes_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetProcessTypeAsInt(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetProcessTypeAsInt");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    unsigned int tempr = vtkProcessModule::GetProcessTypeAsInt();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_UpdateProcessType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateProcessType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  typedef vtkProcessModule::ProcessTypes temp0_type;
  temp0_type temp0;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetEnumValue(temp0, "vtkProcessModule.ProcessTypes") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    if (ap.IsBound())
    {
      op->UpdateProcessType(temp0, temp1);
    }
    else
    {
      op->vtkProcessModule::UpdateProcessType(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_Finalize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Finalize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkProcessModule::Finalize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_RegisterSession(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  vtkSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSession"))
  {
    long long tempr = (ap.IsBound() ?
      op->RegisterSession(temp0) :
      op->vtkProcessModule::RegisterSession(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_UnRegisterSession_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->UnRegisterSession(temp0) :
      op->vtkProcessModule::UnRegisterSession(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkProcessModule_UnRegisterSession_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  vtkSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSession"))
  {
    bool tempr = (ap.IsBound() ?
      op->UnRegisterSession(temp0) :
      op->vtkProcessModule::UnRegisterSession(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkProcessModule_UnRegisterSession_Methods[] = {
  {"UnRegisterSession", PyvtkProcessModule_UnRegisterSession_s1, METH_VARARGS,
   "@k"},
  {"UnRegisterSession", PyvtkProcessModule_UnRegisterSession_s2, METH_VARARGS,
   "@V *vtkSession"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkProcessModule_UnRegisterSession(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkProcessModule_UnRegisterSession_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UnRegisterSession");
  return nullptr;
}


static PyObject *
PyvtkProcessModule_GetEventCallDataSessionId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEventCallDataSessionId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetEventCallDataSessionId() :
      op->vtkProcessModule::GetEventCallDataSessionId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetSession_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSession *tempr = (ap.IsBound() ?
      op->GetSession(temp0) :
      op->vtkProcessModule::GetSession(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkProcessModule_GetSession_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSession *tempr = (ap.IsBound() ?
      op->GetSession() :
      op->vtkProcessModule::GetSession());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkProcessModule_GetSession(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkProcessModule_GetSession_s1(self, args);
    case 0:
      return PyvtkProcessModule_GetSession_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetSession");
  return nullptr;
}


static PyObject *
PyvtkProcessModule_GetSessionID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSessionID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  vtkSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSession"))
  {
    long long tempr = (ap.IsBound() ?
      op->GetSessionID(temp0) :
      op->vtkProcessModule::GetSessionID(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_NewSessionIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewSessionIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSessionIterator *tempr = (ap.IsBound() ?
      op->NewSessionIterator() :
      op->vtkProcessModule::NewSessionIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetActiveSession(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSession *tempr = (ap.IsBound() ?
      op->GetActiveSession() :
      op->vtkProcessModule::GetActiveSession());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetMultipleSessionsSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMultipleSessionsSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMultipleSessionsSupport() :
      op->vtkProcessModule::GetMultipleSessionsSupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_SetMultipleSessionsSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMultipleSessionsSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMultipleSessionsSupport(temp0);
    }
    else
    {
      op->vtkProcessModule::SetMultipleSessionsSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_MultipleSessionsSupportOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MultipleSessionsSupportOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MultipleSessionsSupportOn();
    }
    else
    {
      op->vtkProcessModule::MultipleSessionsSupportOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_MultipleSessionsSupportOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MultipleSessionsSupportOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MultipleSessionsSupportOff();
    }
    else
    {
      op->vtkProcessModule::MultipleSessionsSupportOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetProcessModule(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetProcessModule");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkProcessModule *tempr = vtkProcessModule::GetProcessModule();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetNetworkAccessManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNetworkAccessManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkNetworkAccessManager *tempr = (ap.IsBound() ?
      op->GetNetworkAccessManager() :
      op->vtkProcessModule::GetNetworkAccessManager());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_SetNetworkAccessManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNetworkAccessManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  vtkNetworkAccessManager *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkNetworkAccessManager"))
  {
    if (ap.IsBound())
    {
      op->SetNetworkAccessManager(temp0);
    }
    else
    {
      op->vtkProcessModule::SetNetworkAccessManager(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetGlobalController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetGlobalController() :
      op->vtkProcessModule::GetGlobalController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetNumberOfLocalPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLocalPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfLocalPartitions() :
      op->vtkProcessModule::GetNumberOfLocalPartitions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetPartitionId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPartitionId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPartitionId() :
      op->vtkProcessModule::GetPartitionId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_IsMPIInitialized(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsMPIInitialized");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsMPIInitialized() :
      op->vtkProcessModule::IsMPIInitialized());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetReportInterpreterErrors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReportInterpreterErrors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReportInterpreterErrors() :
      op->vtkProcessModule::GetReportInterpreterErrors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_SetReportInterpreterErrors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReportInterpreterErrors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReportInterpreterErrors(temp0);
    }
    else
    {
      op->vtkProcessModule::SetReportInterpreterErrors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_ReportInterpreterErrorsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReportInterpreterErrorsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReportInterpreterErrorsOn();
    }
    else
    {
      op->vtkProcessModule::ReportInterpreterErrorsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_ReportInterpreterErrorsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReportInterpreterErrorsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReportInterpreterErrorsOff();
    }
    else
    {
      op->vtkProcessModule::ReportInterpreterErrorsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetSymmetricMPIMode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetSymmetricMPIMode");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkProcessModule::GetSymmetricMPIMode();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetProgramPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProgramPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetProgramPath() :
      &op->vtkProcessModule::GetProgramPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetSelfDir(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelfDir");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetSelfDir() :
      &op->vtkProcessModule::GetSelfDir());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkProcessModule::SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkProcessModule::GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkProcessModule::SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkProcessModule::GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetNumberOfGhostLevelsToRequest(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGhostLevelsToRequest");

  vtkInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkInformation"))
  {
    int tempr = vtkProcessModule::GetNumberOfGhostLevelsToRequest(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkProcessModule_GetCallbackQueue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCallbackQueue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkProcessModule *op = static_cast<vtkProcessModule *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkThreadedCallbackQueue *tempr = (ap.IsBound() ?
      op->GetCallbackQueue() :
      op->vtkProcessModule::GetCallbackQueue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkProcessModule_Methods[] = {
  {"IsTypeOf", PyvtkProcessModule_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkProcessModule_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkProcessModule_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkProcessModule\nC++: static vtkProcessModule *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkProcessModule_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkProcessModule\nC++: vtkProcessModule *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkProcessModule_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkProcessModule_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetProcessType", PyvtkProcessModule_GetProcessType, METH_VARARGS,
   "GetProcessType() -> ProcessTypes\nC++: static ProcessTypes GetProcessType()\n\n"},
  {"GetProcessTypeAsInt", PyvtkProcessModule_GetProcessTypeAsInt, METH_VARARGS,
   "GetProcessTypeAsInt() -> int\nC++: static unsigned int GetProcessTypeAsInt()\n\n"},
  {"UpdateProcessType", PyvtkProcessModule_UpdateProcessType, METH_VARARGS,
   "UpdateProcessType(self, newType:ProcessTypes,\n    dontKnowWhatImDoing:bool=True) -> None\nC++: void UpdateProcessType(ProcessTypes newType,\n    bool dontKnowWhatImDoing=true)\n\nThis method has been added to support migration from one type to\nanother but this method call if NOT RECOMMENDED.\n-> We use it to handle the Animation saving at disconnection time\non the server side. We create a new session and migrate the sever\nprocess to a batch process.\n"},
  {"Finalize", PyvtkProcessModule_Finalize, METH_VARARGS,
   "Finalize() -> bool\nC++: static bool Finalize()\n\nFinalizes and cleans up the process.\n"},
  {"RegisterSession", PyvtkProcessModule_RegisterSession, METH_VARARGS,
   "RegisterSession(self, __a:vtkSession) -> int\nC++: vtkIdType RegisterSession(vtkSession *)\n\nRegisters a new session. A new ID is assigned for the session and\nthat ID is returned. The ID can be used in future to access this\nsession. Fires vtkCommand::ConnectionCreatedEvent every time a\nsession is registered. The event-data for this event is a\nvtkIdType whose value is the session id.\n"},
  {"UnRegisterSession", PyvtkProcessModule_UnRegisterSession, METH_VARARGS,
   "UnRegisterSession(self, sessionID:int) -> bool\nC++: bool UnRegisterSession(vtkIdType sessionID)\nUnRegisterSession(self, session:vtkSession) -> bool\nC++: bool UnRegisterSession(vtkSession *session)\n\nUnregister a session given its ID. This is the same ID that is\nreturned when the session was registered. Returns true is the\nsession was unregistered. Unregistering a session implies that\nthe ProcessModule will no longer monitor communication on the\nsockets, if any, in the session. Fires\nvtkCommand::ConnectionClosedEvent every time a session is\nunregistered. The event-data for this event is a vtkIdType whose\nvalue is the session id.\n"},
  {"GetEventCallDataSessionId", PyvtkProcessModule_GetEventCallDataSessionId, METH_VARARGS,
   "GetEventCallDataSessionId(self) -> int\nC++: virtual vtkIdType GetEventCallDataSessionId()\n\nRegisterSession and UnRegisterSession fire events with SessionID\nin calldata. To provide access to that in Python, we have this\nmethod. The value is valid only in\nvtkCommand::ConnectionCreatedEvent and\nvtkCommand::ConnectionClosedEvent callbacks and is set to 0 at\nother times.\n"},
  {"GetSession", PyvtkProcessModule_GetSession, METH_VARARGS,
   "GetSession(self, __a:int) -> vtkSession\nC++: vtkSession *GetSession(vtkIdType)\nGetSession(self) -> vtkSession\nC++: vtkSession *GetSession()\n\nReturns the session associated with a given ID.\n"},
  {"GetSessionID", PyvtkProcessModule_GetSessionID, METH_VARARGS,
   "GetSessionID(self, __a:vtkSession) -> int\nC++: vtkIdType GetSessionID(vtkSession *)\n\nReturns the session id for the session, if any. Return 0 is the\nsession has not been registered with the process module.\n"},
  {"NewSessionIterator", PyvtkProcessModule_NewSessionIterator, METH_VARARGS,
   "NewSessionIterator(self) -> vtkSessionIterator\nC++: vtkSessionIterator *NewSessionIterator()\n\nReturns a new session iterator that can be used to iterate over\nthe registered sessions.\n"},
  {"GetActiveSession", PyvtkProcessModule_GetActiveSession, METH_VARARGS,
   "GetActiveSession(self) -> vtkSession\nC++: vtkSession *GetActiveSession()\n\nWhenever any session is processing some message, it typically\nmarks itself active with the process module. The active session\ncan be accessed using this method.\n"},
  {"GetMultipleSessionsSupport", PyvtkProcessModule_GetMultipleSessionsSupport, METH_VARARGS,
   "GetMultipleSessionsSupport(self) -> bool\nC++: virtual bool GetMultipleSessionsSupport()\n\nReturn true, if multiple sessions can be used simultanuously. We\nset the default to be FALSE.\n"},
  {"SetMultipleSessionsSupport", PyvtkProcessModule_SetMultipleSessionsSupport, METH_VARARGS,
   "SetMultipleSessionsSupport(self, _arg:bool) -> None\nC++: virtual void SetMultipleSessionsSupport(bool _arg)\n\n"},
  {"MultipleSessionsSupportOn", PyvtkProcessModule_MultipleSessionsSupportOn, METH_VARARGS,
   "MultipleSessionsSupportOn(self) -> None\nC++: virtual void MultipleSessionsSupportOn()\n\n"},
  {"MultipleSessionsSupportOff", PyvtkProcessModule_MultipleSessionsSupportOff, METH_VARARGS,
   "MultipleSessionsSupportOff(self) -> None\nC++: virtual void MultipleSessionsSupportOff()\n\n"},
  {"GetProcessModule", PyvtkProcessModule_GetProcessModule, METH_VARARGS,
   "GetProcessModule() -> vtkProcessModule\nC++: static vtkProcessModule *GetProcessModule()\n\nProvides access to the global ProcessModule. This method can only\nbe called after Initialize().\n"},
  {"GetNetworkAccessManager", PyvtkProcessModule_GetNetworkAccessManager, METH_VARARGS,
   "GetNetworkAccessManager(self) -> vtkNetworkAccessManager\nC++: virtual vtkNetworkAccessManager *GetNetworkAccessManager()\n\nGet/Set the network access manager. vtkNetworkAccessManager\nencapsulates the setup of interprocess communication channels. By\ndefault a vtkTCPNetworkAccessManager is setup. If you want to\nchange the network access manager, it should be done only when no\nsessions are present. Ideally, you want to do that during the\ninitialization of the process itself.\n"},
  {"SetNetworkAccessManager", PyvtkProcessModule_SetNetworkAccessManager, METH_VARARGS,
   "SetNetworkAccessManager(self, __a:vtkNetworkAccessManager) -> None\nC++: void SetNetworkAccessManager(vtkNetworkAccessManager *)\n\n"},
  {"GetGlobalController", PyvtkProcessModule_GetGlobalController, METH_VARARGS,
   "GetGlobalController(self) -> vtkMultiProcessController\nC++: vtkMultiProcessController *GetGlobalController()\n\nProvides access to the global MPI controller, if any. Same can be\nobtained using vtkMultiProcessController::GetGlobalController();\n"},
  {"GetNumberOfLocalPartitions", PyvtkProcessModule_GetNumberOfLocalPartitions, METH_VARARGS,
   "GetNumberOfLocalPartitions(self) -> int\nC++: int GetNumberOfLocalPartitions()\n\nReturns the number of processes in this process group.\n"},
  {"GetPartitionId", PyvtkProcessModule_GetPartitionId, METH_VARARGS,
   "GetPartitionId(self) -> int\nC++: int GetPartitionId()\n\nReturns the local process id.\n"},
  {"IsMPIInitialized", PyvtkProcessModule_IsMPIInitialized, METH_VARARGS,
   "IsMPIInitialized(self) -> bool\nC++: bool IsMPIInitialized()\n\nReturn whether MPI is initialized in this process group.\n"},
  {"GetReportInterpreterErrors", PyvtkProcessModule_GetReportInterpreterErrors, METH_VARARGS,
   "GetReportInterpreterErrors(self) -> bool\nC++: virtual bool GetReportInterpreterErrors()\n\nSet/Get whether to report errors from the Interpreter.\n"},
  {"SetReportInterpreterErrors", PyvtkProcessModule_SetReportInterpreterErrors, METH_VARARGS,
   "SetReportInterpreterErrors(self, _arg:bool) -> None\nC++: virtual void SetReportInterpreterErrors(bool _arg)\n\n"},
  {"ReportInterpreterErrorsOn", PyvtkProcessModule_ReportInterpreterErrorsOn, METH_VARARGS,
   "ReportInterpreterErrorsOn(self) -> None\nC++: virtual void ReportInterpreterErrorsOn()\n\n"},
  {"ReportInterpreterErrorsOff", PyvtkProcessModule_ReportInterpreterErrorsOff, METH_VARARGS,
   "ReportInterpreterErrorsOff(self) -> None\nC++: virtual void ReportInterpreterErrorsOff()\n\n"},
  {"GetSymmetricMPIMode", PyvtkProcessModule_GetSymmetricMPIMode, METH_VARARGS,
   "GetSymmetricMPIMode() -> bool\nC++: static bool GetSymmetricMPIMode()\n\n"},
  {"GetProgramPath", PyvtkProcessModule_GetProgramPath, METH_VARARGS,
   "GetProgramPath(self) -> str\nC++: const std::string &GetProgramPath()\n\nThe full path to the current executable that is running (or empty\nif unknown).\n"},
  {"GetSelfDir", PyvtkProcessModule_GetSelfDir, METH_VARARGS,
   "GetSelfDir(self) -> str\nC++: const std::string &GetSelfDir()\n\nThe directory containing the current executable (or empty if\nunknown).\n"},
  {"SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines", PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines, METH_VARARGS,
   "SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(\n    __a:int) -> None\nC++: static void SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(\n    int)\n\nThis is temporary approach to control the number of ghost-levels\nto request by default for data pipelines. Currently, change in\nghost level request causes the pipeline to re-execute which can\nbe expensive. In an ideal world, additional ghost levels can be\nautomatically provided by data-exchange between ranks. Until we\ndo that, this is only mechanism available to override the number\nof ghost levels requested by default.\n\nThe default is 0 for structured pipelines, and 1 for unstructured\npipelines. When not running in parallel, however, these\nghost-level requests don't make sense and hence are generally\nignored.\n\nNote, this is expected to change in the future, so use this with\ncaution.\n"},
  {"GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines", PyvtkProcessModule_GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines, METH_VARARGS,
   "GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines()\n    -> int\nC++: static int GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(\n    )\n\n"},
  {"SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines", PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines, METH_VARARGS,
   "SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(\n    __a:int) -> None\nC++: static void SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(\n    int)\n\n"},
  {"GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines", PyvtkProcessModule_GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines, METH_VARARGS,
   "GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines()\n    -> int\nC++: static int GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(\n    )\n\n"},
  {"GetNumberOfGhostLevelsToRequest", PyvtkProcessModule_GetNumberOfGhostLevelsToRequest, METH_VARARGS,
   "GetNumberOfGhostLevelsToRequest(outInfo:vtkInformation) -> int\nC++: static int GetNumberOfGhostLevelsToRequest(\n    vtkInformation *outInfo)\n\nThis returns number of ghost level to request based on\ncharacteristics of the pipelines.\n"},
  {"GetCallbackQueue", PyvtkProcessModule_GetCallbackQueue, METH_VARARGS,
   "GetCallbackQueue(self) -> vtkThreadedCallbackQueue\nC++: vtkThreadedCallbackQueue *GetCallbackQueue()\n\nReturns a callback queue in which one can defer tasks that can\nrun asynchronously.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkProcessModule_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("multiple_sessions_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetMultipleSessionsSupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkProcessModule_SetMultipleSessionsSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkProcessModule_SetMultipleSessionsSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMultipleSessionsSupport/SetMultipleSessionsSupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("network_access_manager"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetNetworkAccessManager(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkProcessModule_SetNetworkAccessManager(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkProcessModule_SetNetworkAccessManager(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNetworkAccessManager/SetNetworkAccessManager\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("report_interpreter_errors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetReportInterpreterErrors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkProcessModule_SetReportInterpreterErrors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkProcessModule_SetReportInterpreterErrors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReportInterpreterErrors/SetReportInterpreterErrors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("default_minimum_ghost_levels_to_request_for_structured_pipelines"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDefaultMinimumGhostLevelsToRequestForStructuredPipelines/SetDefaultMinimumGhostLevelsToRequestForStructuredPipelines\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("default_minimum_ghost_levels_to_request_for_unstructured_pipelines"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkProcessModule_SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines/SetDefaultMinimumGhostLevelsToRequestForUnstructuredPipelines\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("process_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetProcessType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProcessType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("process_type_as_int"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetProcessTypeAsInt(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProcessTypeAsInt\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("event_call_data_session_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetEventCallDataSessionId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEventCallDataSessionId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("session"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetSession(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSession\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_session"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetActiveSession(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveSession\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("process_module"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetProcessModule(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProcessModule\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetGlobalController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGlobalController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("partition_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetPartitionId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPartitionId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("symmetric_mpi_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetSymmetricMPIMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSymmetricMPIMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("program_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetProgramPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProgramPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("self_dir"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetSelfDir(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSelfDir\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("callback_queue"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetCallbackQueue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCallbackQueue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_local_partitions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkProcessModule_GetNumberOfLocalPartitions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLocalPartitions\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkProcessModule_Doc =
  "vtkProcessModule - process initialization and management core for\n\n"
  "Superclass: vtkObject\n\n"
  "ParaView processes. vtkProcessModule is the process initialization\n"
  "and session management core for ParaView processes.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkProcessModule_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkProcessModule", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkProcessModule_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkProcessModule_StaticNew()
{
  return vtkProcessModule::New();
}

PyObject *PyvtkProcessModule_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkProcessModule_Type, PyvtkProcessModule_Methods,
    "vtkProcessModule",
 &PyvtkProcessModule_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkProcessModule_ProcessTypes_Type);
  PyVTKEnum_Add(&PyvtkProcessModule_ProcessTypes_Type, "vtkProcessModule.ProcessTypes");

  o = (PyObject *)&PyvtkProcessModule_ProcessTypes_Type;
  if (PyDict_SetItemString(d, "ProcessTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkProcessModule_ServerFlags_Type);
  PyVTKEnum_Add(&PyvtkProcessModule_ServerFlags_Type, "vtkProcessModule.ServerFlags");

  o = (PyObject *)&PyvtkProcessModule_ServerFlags_Type;
  if (PyDict_SetItemString(d, "ServerFlags", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 6; c++)
  {
    typedef vtkProcessModule::ProcessTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[6] = {
        { "PROCESS_CLIENT", vtkProcessModule::PROCESS_CLIENT },
        { "PROCESS_SERVER", vtkProcessModule::PROCESS_SERVER },
        { "PROCESS_DATA_SERVER", vtkProcessModule::PROCESS_DATA_SERVER },
        { "PROCESS_RENDER_SERVER", vtkProcessModule::PROCESS_RENDER_SERVER },
        { "PROCESS_BATCH", vtkProcessModule::PROCESS_BATCH },
        { "PROCESS_INVALID", vtkProcessModule::PROCESS_INVALID },
      };

    o = PyvtkProcessModule_ProcessTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 7; c++)
  {
    typedef vtkProcessModule::ServerFlags cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[7] = {
        { "DATA_SERVER", vtkProcessModule::DATA_SERVER },
        { "DATA_SERVER_ROOT", vtkProcessModule::DATA_SERVER_ROOT },
        { "RENDER_SERVER", vtkProcessModule::RENDER_SERVER },
        { "RENDER_SERVER_ROOT", vtkProcessModule::RENDER_SERVER_ROOT },
        { "SERVERS", vtkProcessModule::SERVERS },
        { "CLIENT", vtkProcessModule::CLIENT },
        { "CLIENT_AND_SERVERS", vtkProcessModule::CLIENT_AND_SERVERS },
      };

    o = PyvtkProcessModule_ServerFlags_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkProcessModule_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkProcessModule(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkProcessModule_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkProcessModule", o) != 0)
  {
    Py_DECREF(o);
  }

}

