// python wrapper for vtkCPPythonScriptV2Helper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCPPythonScriptV2Helper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPPythonScriptV2Helper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPPythonScriptV2Helper_ClassNew(); }


static PyObject *
PyvtkCPPythonScriptV2Helper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPPythonScriptV2Helper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPPythonScriptV2Helper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPPythonScriptV2Helper *tempr = vtkCPPythonScriptV2Helper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPPythonScriptV2Helper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPPythonScriptV2Helper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPPythonScriptV2Helper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPPythonScriptV2Helper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_PrepareFromScript(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrepareFromScript");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->PrepareFromScript(temp0) :
      op->vtkCPPythonScriptV2Helper::PrepareFromScript(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetScriptFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScriptFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetScriptFileName() :
      &op->vtkCPPythonScriptV2Helper::GetScriptFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_IsImported(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsImported");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsImported() :
      op->vtkCPPythonScriptV2Helper::IsImported());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_Import_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Import");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetArray(temp0.data(), temp0.size())))
  {
    bool tempr = (ap.IsBound() ?
      op->Import(temp0) :
      op->vtkCPPythonScriptV2Helper::Import(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkCPPythonScriptV2Helper_Import_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Import");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    bool tempr = (ap.IsBound() ?
      op->Import(temp0) :
      op->vtkCPPythonScriptV2Helper::Import(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPPythonScriptV2Helper_Import_Methods[] = {
  {"Import", PyvtkCPPythonScriptV2Helper_Import_s1, METH_VARARGS,
   "@|T s"},
  {"Import", PyvtkCPPythonScriptV2Helper_Import_s2, METH_VARARGS,
   "@V *vtkCPDataDescription"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkCPPythonScriptV2Helper_Import(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkCPPythonScriptV2Helper_Import_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkCPPythonScriptV2Helper_Import_s1(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Import");
  return nullptr;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystInitialize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CatalystInitialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->CatalystInitialize() :
      op->vtkCPPythonScriptV2Helper::CatalystInitialize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystInitialize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CatalystInitialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    bool tempr = (ap.IsBound() ?
      op->CatalystInitialize(temp0) :
      op->vtkCPPythonScriptV2Helper::CatalystInitialize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystInitialize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkCPPythonScriptV2Helper_CatalystInitialize_s1(self, args);
    case 1:
      return PyvtkCPPythonScriptV2Helper_CatalystInitialize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CatalystInitialize");
  return nullptr;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystFinalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CatalystFinalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->CatalystFinalize() :
      op->vtkCPPythonScriptV2Helper::CatalystFinalize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystExecute_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CatalystExecute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  int temp0;
  double temp1;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetArray(temp2.data(), temp2.size())))
  {
    bool tempr = (ap.IsBound() ?
      op->CatalystExecute(temp0, temp1, temp2) :
      op->vtkCPPythonScriptV2Helper::CatalystExecute(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystExecute_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CatalystExecute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    bool tempr = (ap.IsBound() ?
      op->CatalystExecute(temp0) :
      op->vtkCPPythonScriptV2Helper::CatalystExecute(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystExecute(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
    case 3:
      return PyvtkCPPythonScriptV2Helper_CatalystExecute_s1(self, args);
    case 1:
      return PyvtkCPPythonScriptV2Helper_CatalystExecute_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CatalystExecute");
  return nullptr;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_CatalystResults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CatalystResults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->CatalystResults() :
      op->vtkCPPythonScriptV2Helper::CatalystResults());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_RequestDataDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RequestDataDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    bool tempr = (ap.IsBound() ?
      op->RequestDataDescription(temp0) :
      op->vtkCPPythonScriptV2Helper::RequestDataDescription(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetActiveInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetActiveInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkCPPythonScriptV2Helper *tempr = vtkCPPythonScriptV2Helper::GetActiveInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_RegisterExtractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterExtractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->RegisterExtractor(temp0);
    }
    else
    {
      op->vtkCPPythonScriptV2Helper::RegisterExtractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_RegisterView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->RegisterView(temp0);
    }
    else
    {
      op->vtkCPPythonScriptV2Helper::RegisterView(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_SetOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetOptions(temp0);
    }
    else
    {
      op->vtkCPPythonScriptV2Helper::SetOptions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetOptions() :
      op->vtkCPPythonScriptV2Helper::GetOptions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetDataDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPDataDescription *tempr = (ap.IsBound() ?
      op->GetDataDescription() :
      op->vtkCPPythonScriptV2Helper::GetDataDescription());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetTrivialProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrivialProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetTrivialProducer(temp0) :
      op->vtkCPPythonScriptV2Helper::GetTrivialProducer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetArgumentsAsStringList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArgumentsAsStringList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringList *tempr = (ap.IsBound() ?
      op->GetArgumentsAsStringList() :
      op->vtkCPPythonScriptV2Helper::GetArgumentsAsStringList());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Helper_GetParametersAsStringList(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParametersAsStringList");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Helper *op = static_cast<vtkCPPythonScriptV2Helper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringList *tempr = (ap.IsBound() ?
      op->GetParametersAsStringList() :
      op->vtkCPPythonScriptV2Helper::GetParametersAsStringList());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPPythonScriptV2Helper_Methods[] = {
  {"IsTypeOf", PyvtkCPPythonScriptV2Helper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPPythonScriptV2Helper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPPythonScriptV2Helper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPPythonScriptV2Helper\nC++: static vtkCPPythonScriptV2Helper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPPythonScriptV2Helper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPPythonScriptV2Helper\nC++: vtkCPPythonScriptV2Helper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPPythonScriptV2Helper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPPythonScriptV2Helper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"PrepareFromScript", PyvtkCPPythonScriptV2Helper_PrepareFromScript, METH_VARARGS,
   "PrepareFromScript(self, fname:str) -> bool\nC++: bool PrepareFromScript(const std::string &fname)\n\nPrepares the Python package/module for import. This doesn't\nactually import it yet. Returns false if the prep failed for some\nreason.\n"},
  {"GetScriptFileName", PyvtkCPPythonScriptV2Helper_GetScriptFileName, METH_VARARGS,
   "GetScriptFileName(self) -> str\nC++: const std::string &GetScriptFileName()\n\nReturns the name of the script passed in to PrepareFromScript.\n"},
  {"IsImported", PyvtkCPPythonScriptV2Helper_IsImported, METH_VARARGS,
   "IsImported(self) -> bool\nC++: bool IsImported()\n\nReturns if the package/module has been imported.\n"},
  {"Import", PyvtkCPPythonScriptV2Helper_Import, METH_VARARGS,
   "Import(self, args:(str, ...)=...) -> bool\nC++: bool Import(const std::vector<std::string> &args={ })\nImport(self, desc:vtkCPDataDescription) -> bool\nC++: bool Import(vtkCPDataDescription *desc)\n\nImports the module/package. This overload is used by\n`vtkInSituPipelinePython` which in turn is used in\nParaView-Catalyst, the ParaView-based implementation of the\nCatalyst In Situ API.\n\nReturns true on success.\n"},
  {"CatalystInitialize", PyvtkCPPythonScriptV2Helper_CatalystInitialize, METH_VARARGS,
   "CatalystInitialize(self) -> bool\nC++: bool CatalystInitialize()\nCatalystInitialize(self, desc:vtkCPDataDescription) -> bool\nC++: bool CatalystInitialize(vtkCPDataDescription *desc)\n\nCalls `catalyst_initialize`.\n"},
  {"CatalystFinalize", PyvtkCPPythonScriptV2Helper_CatalystFinalize, METH_VARARGS,
   "CatalystFinalize(self) -> bool\nC++: bool CatalystFinalize()\n\nCalls `catalyst_finalize`.\n"},
  {"CatalystExecute", PyvtkCPPythonScriptV2Helper_CatalystExecute, METH_VARARGS,
   "CatalystExecute(self, timestep:int, time:float, params:(str, ...)\n    =...) -> bool\nC++: bool CatalystExecute(int timestep, double time,\n    const std::vector<std::string> &params={ })\nCatalystExecute(self, desc:vtkCPDataDescription) -> bool\nC++: bool CatalystExecute(vtkCPDataDescription *desc)\n\nCalls `catalyst_execute`.\n"},
  {"CatalystResults", PyvtkCPPythonScriptV2Helper_CatalystResults, METH_VARARGS,
   "CatalystResults(self) -> bool\nC++: bool CatalystResults()\n\nCalls `catalyst_results`.\n"},
  {"RequestDataDescription", PyvtkCPPythonScriptV2Helper_RequestDataDescription, METH_VARARGS,
   "RequestDataDescription(self, desc:vtkCPDataDescription) -> bool\nC++: bool RequestDataDescription(vtkCPDataDescription *desc)\n\n"},
  {"GetActiveInstance", PyvtkCPPythonScriptV2Helper_GetActiveInstance, METH_VARARGS,
   "GetActiveInstance() -> vtkCPPythonScriptV2Helper\nC++: static vtkCPPythonScriptV2Helper *GetActiveInstance()\n\nInternal methods. These are called by Python modules internal to\nParaView and may change without notice. Should not be considered\nas part of ParaView API.\n"},
  {"RegisterExtractor", PyvtkCPPythonScriptV2Helper_RegisterExtractor, METH_VARARGS,
   "RegisterExtractor(self, extractor:vtkSMProxy) -> None\nC++: void RegisterExtractor(vtkSMProxy *extractor)\n\n"},
  {"RegisterView", PyvtkCPPythonScriptV2Helper_RegisterView, METH_VARARGS,
   "RegisterView(self, view:vtkSMProxy) -> None\nC++: void RegisterView(vtkSMProxy *view)\n\n"},
  {"SetOptions", PyvtkCPPythonScriptV2Helper_SetOptions, METH_VARARGS,
   "SetOptions(self, catalystOptions:vtkSMProxy) -> None\nC++: void SetOptions(vtkSMProxy *catalystOptions)\n\n"},
  {"GetOptions", PyvtkCPPythonScriptV2Helper_GetOptions, METH_VARARGS,
   "GetOptions(self) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetOptions()\n\n"},
  {"GetDataDescription", PyvtkCPPythonScriptV2Helper_GetDataDescription, METH_VARARGS,
   "GetDataDescription(self) -> vtkCPDataDescription\nC++: vtkCPDataDescription *GetDataDescription()\n\n"},
  {"GetTrivialProducer", PyvtkCPPythonScriptV2Helper_GetTrivialProducer, METH_VARARGS,
   "GetTrivialProducer(self, inputname:str) -> vtkSMProxy\nC++: vtkSMProxy *GetTrivialProducer(const char *inputname)\n\n"},
  {"GetArgumentsAsStringList", PyvtkCPPythonScriptV2Helper_GetArgumentsAsStringList, METH_VARARGS,
   "GetArgumentsAsStringList(self) -> vtkStringList\nC++: vtkStringList *GetArgumentsAsStringList()\n\n"},
  {"GetParametersAsStringList", PyvtkCPPythonScriptV2Helper_GetParametersAsStringList, METH_VARARGS,
   "GetParametersAsStringList(self) -> vtkStringList\nC++: vtkStringList *GetParametersAsStringList()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPPythonScriptV2Helper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("options"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPPythonScriptV2Helper_GetOptions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPPythonScriptV2Helper_SetOptions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPPythonScriptV2Helper_SetOptions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOptions/SetOptions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("script_file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPPythonScriptV2Helper_GetScriptFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetScriptFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPPythonScriptV2Helper_GetActiveInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPPythonScriptV2Helper_GetDataDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataDescription\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arguments_as_string_list"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPPythonScriptV2Helper_GetArgumentsAsStringList(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetArgumentsAsStringList\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parameters_as_string_list"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPPythonScriptV2Helper_GetParametersAsStringList(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetParametersAsStringList\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPPythonScriptV2Helper_Doc =
  "vtkCPPythonScriptV2Helper - an internal class encapsulating logic for\nCatalyst Python scripts.\n\n"
  "Superclass: vtkObject\n\n"
  "This class is an internal helper to share code between\n"
  "`vtkInSituPipelinePython` and `vtkCPPythonScriptV2Pipeline`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPPythonScriptV2Helper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVPythonCatalyst.vtkCPPythonScriptV2Helper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPPythonScriptV2Helper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCPPythonScriptV2Helper_StaticNew()
{
  return vtkCPPythonScriptV2Helper::New();
}

PyObject *PyvtkCPPythonScriptV2Helper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPPythonScriptV2Helper_Type, PyvtkCPPythonScriptV2Helper_Methods,
    "vtkCPPythonScriptV2Helper",
 &PyvtkCPPythonScriptV2Helper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPPythonScriptV2Helper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPPythonScriptV2Helper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPPythonScriptV2Helper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPPythonScriptV2Helper", o) != 0)
  {
    Py_DECREF(o);
  }

}

