// python wrapper for vtkInSituInitializationHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkInSituInitializationHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkInSituInitializationHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkInSituInitializationHelper_ClassNew(); }


static PyObject *
PyvtkInSituInitializationHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkInSituInitializationHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituInitializationHelper *op = static_cast<vtkInSituInitializationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkInSituInitializationHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkInSituInitializationHelper *tempr = vtkInSituInitializationHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituInitializationHelper *op = static_cast<vtkInSituInitializationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkInSituInitializationHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkInSituInitializationHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkInSituInitializationHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkInSituInitializationHelper *op = static_cast<vtkInSituInitializationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkInSituInitializationHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_Initialize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Initialize");

  unsigned long long temp0;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    vtkInSituInitializationHelper::Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_Finalize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Finalize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInSituInitializationHelper::Finalize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_AddPipeline_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddPipeline");

  std::string temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkInSituPipeline *tempr = vtkInSituInitializationHelper::AddPipeline(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkInSituInitializationHelper_AddPipeline_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddPipeline");

  vtkInSituPipeline *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkInSituPipeline"))
  {
    vtkInSituInitializationHelper::AddPipeline(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkInSituInitializationHelper_AddPipeline(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
      return PyvtkInSituInitializationHelper_AddPipeline_s1(self, args);
    case 1:
      return PyvtkInSituInitializationHelper_AddPipeline_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddPipeline");
  return nullptr;
}


static PyObject *
PyvtkInSituInitializationHelper_SetProducer(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetProducer");

  std::string temp0;
  vtkSMSourceProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy"))
  {
    vtkInSituInitializationHelper::SetProducer(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_GetProducer(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetProducer");

  std::string temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMSourceProxy *tempr = vtkInSituInitializationHelper::GetProducer(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_UpdateAllProducers(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "UpdateAllProducers");

  double temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkInSituInitializationHelper::UpdateAllProducers(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_MarkProducerModified_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MarkProducerModified");

  std::string temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkInSituInitializationHelper::MarkProducerModified(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkInSituInitializationHelper_MarkProducerModified_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "MarkProducerModified");

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    vtkInSituInitializationHelper::MarkProducerModified(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkInSituInitializationHelper_MarkProducerModified_Methods[] = {
  {"MarkProducerModified", PyvtkInSituInitializationHelper_MarkProducerModified_s1, METH_VARARGS | METH_STATIC,
   "s"},
  {"MarkProducerModified", PyvtkInSituInitializationHelper_MarkProducerModified_s2, METH_VARARGS | METH_STATIC,
   "V *vtkSMSourceProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkInSituInitializationHelper_MarkProducerModified(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkInSituInitializationHelper_MarkProducerModified_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "MarkProducerModified");
  return nullptr;
}


static PyObject *
PyvtkInSituInitializationHelper_ExecutePipelines(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ExecutePipelines");

  int temp0;
  double temp1;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  std::vector<std::string> temp3(ap.GetArgSize(3));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetArray(temp2.data(), temp2.size())) &&
      (ap.NoArgsLeft() || ap.GetArray(temp3.data(), temp3.size())))
  {
    bool tempr = vtkInSituInitializationHelper::ExecutePipelines(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_GetTimeStep(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetTimeStep");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    int tempr = vtkInSituInitializationHelper::GetTimeStep();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_GetTime(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetTime");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    double tempr = vtkInSituInitializationHelper::GetTime();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_IsInitialized(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsInitialized");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkInSituInitializationHelper::IsInitialized();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_IsPythonSupported(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsPythonSupported");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkInSituInitializationHelper::IsPythonSupported();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkInSituInitializationHelper_UpdateSteerableParameters(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "UpdateSteerableParameters");

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkInSituInitializationHelper::UpdateSteerableParameters(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkInSituInitializationHelper_Methods[] = {
  {"IsTypeOf", PyvtkInSituInitializationHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkInSituInitializationHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkInSituInitializationHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkInSituInitializationHelper\nC++: static vtkInSituInitializationHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkInSituInitializationHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkInSituInitializationHelper\nC++: vtkInSituInitializationHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkInSituInitializationHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkInSituInitializationHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkInSituInitializationHelper_Initialize, METH_VARARGS,
   "Initialize(comm:int, python_paths:(str, ...)) -> None\nC++: static void Initialize(vtkTypeUInt64 comm,\n    const std::vector<std::string> &python_paths)\n\nInitializes the engine. This can only be called once in the\nlifetime of the process. Calling this after the first call has no\neffect.\n\n'comm' is used to determine the 'MPI_Comm' handle to be used for\nParaView. In non-MPI builds of ParaView, this argument is simply\nignored. In MPI-enabled builds of ParaView, this argument must be\n'MPI_Fint' that represents the Fortran handle for MPI_Comm to\nuse. The Fortran handle is an integer and hence we use\n'vtkTypeUInt64' as a wide-enough container for the Fortran handle\nwithout having to include 'mpi.h' in this public header. The\nFortran MPI communicator handle can be obtained from a `MPI_Comm`\nusing `MPI_Comm_c2f()`. Refer to MPI specification for details.\n\n'python_paths' is used to update the PYTHONPATH visible to\ncatalyst scripts. In particular, in Python-enabled builds, the\n`python_paths` are prepended into the current path of the\nvtkPythonInterpreter that executes the catalyst script. This\nallows to add paths to python packages  that a catalyst script\ncan use. A prime example for this is path to custom scripts or\nCATALYST_PYTHONPATH which at the time of writing holds the\nnecessary package to access the conduit node used in each of the\n`catalyst_*1 calls i.e. `node = info.catalyst_params`.\n"},
  {"Finalize", PyvtkInSituInitializationHelper_Finalize, METH_VARARGS,
   "Finalize() -> None\nC++: static void Finalize()\n\nFinalizes the engine. This can be called only once in the\nlifetime of the progress, and that too only after `Initialize`\nhas been called.\n"},
  {"AddPipeline", PyvtkInSituInitializationHelper_AddPipeline, METH_VARARGS,
   "AddPipeline(pipeline_name:str, path:str) -> vtkInSituPipeline\nC++: static vtkInSituPipeline *AddPipeline(\n    const std::string &pipeline_name, const std::string &path)\nAddPipeline(pipeline:vtkInSituPipeline) -> None\nC++: static void AddPipeline(vtkInSituPipeline *pipeline)\n\nAdd Python analysis scripts or packages. This should be called\nafter `Initialize` but before `Finalize` to add analysis\npipelines. The `path` can point to a Python script, a directory\ncontaining a Python package or a zip-file which containing a\nPython package.\n"},
  {"SetProducer", PyvtkInSituInitializationHelper_SetProducer, METH_VARARGS,
   "SetProducer(channelName:str, producer:vtkSMSourceProxy) -> None\nC++: static void SetProducer(const std::string &channelName,\n    vtkSMSourceProxy *producer)\n\nSpecify the algorithm or data-producer proxy that produces the\nmesh for named catalyst channel. This cannot be changed once\nspecified.\n\nOn success, this registers the `producer` with the session proxy\nmanager using the same name as the channelName.\n"},
  {"GetProducer", PyvtkInSituInitializationHelper_GetProducer, METH_VARARGS,
   "GetProducer(channelName:str) -> vtkSMSourceProxy\nC++: static vtkSMSourceProxy *GetProducer(\n    const std::string &channelName)\n\nProvides access to the producer proxy for a given channel, if\nany.\n"},
  {"UpdateAllProducers", PyvtkInSituInitializationHelper_UpdateAllProducers, METH_VARARGS,
   "UpdateAllProducers(time:float) -> None\nC++: static void UpdateAllProducers(double time)\n\nConvenience method to call Update/UpdatePipeline on all known\nproducers.\n"},
  {"MarkProducerModified", PyvtkInSituInitializationHelper_MarkProducerModified, METH_VARARGS,
   "MarkProducerModified(channelName:str) -> None\nC++: static void MarkProducerModified(\n    const std::string &channelName)\nMarkProducerModified(producer:vtkSMSourceProxy) -> None\nC++: static void MarkProducerModified(vtkSMSourceProxy *producer)\n\nThis is provided as a convenience to indicate a particular\nproducer has been modified or has new data for current timestep.\n"},
  {"ExecutePipelines", PyvtkInSituInitializationHelper_ExecutePipelines, METH_VARARGS,
   "ExecutePipelines(timestep:int, time:float, pipelines:(str, ...)\n    =..., parameters:(str, ...)=...) -> bool\nC++: static bool ExecutePipelines(int timestep, double time,\n    const std::vector<std::string> &pipelines={ },\n    const std::vector<std::string> &parameters={ })\n\nExecutes pipelines.\n"},
  {"GetTimeStep", PyvtkInSituInitializationHelper_GetTimeStep, METH_VARARGS,
   "GetTimeStep() -> int\nC++: static int GetTimeStep()\n\nProvides access to current time and timestep during\n`ExecutePipelines` call. The value is not valid outside\n`ExecutePipelines`.\n"},
  {"GetTime", PyvtkInSituInitializationHelper_GetTime, METH_VARARGS,
   "GetTime() -> float\nC++: static double GetTime()\n\n"},
  {"IsInitialized", PyvtkInSituInitializationHelper_IsInitialized, METH_VARARGS,
   "IsInitialized() -> bool\nC++: static bool IsInitialized()\n\nReturns true if vtkInSituInitializationHelper has been\ninitialized; which means that ParaView is operating in in situ\nmode.\n"},
  {"IsPythonSupported", PyvtkInSituInitializationHelper_IsPythonSupported, METH_VARARGS,
   "IsPythonSupported() -> bool\nC++: static bool IsPythonSupported()\n\nReturns true if ParaView is built with Python support enabled.\n"},
  {"UpdateSteerableParameters", PyvtkInSituInitializationHelper_UpdateSteerableParameters, METH_VARARGS,
   "UpdateSteerableParameters(steerableProxy:vtkSMProxy,\n    steerableSourceName:str) -> None\nC++: static void UpdateSteerableParameters(\n    vtkSMProxy *steerableProxy, const char *steerableSourceName)\n\nUpdate the internal list of steerable proxies or extracts by\nadding the proxy passed in parameters.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkInSituInitializationHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInSituInitializationHelper_GetTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkInSituInitializationHelper_GetTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkInSituInitializationHelper_Doc =
  "vtkInSituInitializationHelper - no description provided.\n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkInSituInitializationHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVInSitu.vtkInSituInitializationHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkInSituInitializationHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkInSituInitializationHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkInSituInitializationHelper_Type, PyvtkInSituInitializationHelper_Methods,
    "vtkInSituInitializationHelper",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkInSituInitializationHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkInSituInitializationHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkInSituInitializationHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkInSituInitializationHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

