#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBiomTableReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkChacoGraphReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDelimitedTextReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDIMACSGraphReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDIMACSGraphWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFixedWidthTextReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkISIReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiNewickTreeReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNewickTreeReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNewickTreeWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPhyloXMLTreeReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPhyloXMLTreeWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRISReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalDelimitedTextReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTulipReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXGMLReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXMLTreeReader_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOInfovisCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBiomTableReader_Init(csi);
  vtkChacoGraphReader_Init(csi);
  vtkDelimitedTextReader_Init(csi);
  vtkDIMACSGraphReader_Init(csi);
  vtkDIMACSGraphWriter_Init(csi);
  vtkFixedWidthTextReader_Init(csi);
  vtkISIReader_Init(csi);
  vtkMultiNewickTreeReader_Init(csi);
  vtkNewickTreeReader_Init(csi);
  vtkNewickTreeWriter_Init(csi);
  vtkPhyloXMLTreeReader_Init(csi);
  vtkPhyloXMLTreeWriter_Init(csi);
  vtkRISReader_Init(csi);
  vtkTemporalDelimitedTextReader_Init(csi);
  vtkTulipReader_Init(csi);
  vtkXGMLReader_Init(csi);
  vtkXMLTreeReader_Init(csi);
}
