#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBlockSelector_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkConvertSelection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExpandMarkedElements_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractBlock_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractBlockUsingDataAssembly_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractCellsByType_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractDataArraysOverTime_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractDataOverTime_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractDataSets_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractExodusGlobalTemporalVariables_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractGeometry_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractLevel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractParticlesOverTime_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractPolyDataGeometry_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractRectilinearGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractSelectedArraysOverTime_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractSelectedRows_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractSelection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractTensorComponents_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractTimeSteps_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractUnstructuredGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractVectorComponents_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFrustumSelector_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHierarchicalDataExtractDataSets_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHierarchicalDataExtractLevel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLocationSelector_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProbeSelectedLocations_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSelector_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkValueSelector_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersExtractionCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBlockSelector_Init(csi);
  vtkConvertSelection_Init(csi);
  vtkExpandMarkedElements_Init(csi);
  vtkExtractBlock_Init(csi);
  vtkExtractBlockUsingDataAssembly_Init(csi);
  vtkExtractCellsByType_Init(csi);
  vtkExtractDataArraysOverTime_Init(csi);
  vtkExtractDataOverTime_Init(csi);
  vtkExtractDataSets_Init(csi);
  vtkExtractExodusGlobalTemporalVariables_Init(csi);
  vtkExtractGeometry_Init(csi);
  vtkExtractGrid_Init(csi);
  vtkExtractLevel_Init(csi);
  vtkExtractParticlesOverTime_Init(csi);
  vtkExtractPolyDataGeometry_Init(csi);
  vtkExtractRectilinearGrid_Init(csi);
  vtkExtractSelectedArraysOverTime_Init(csi);
  vtkExtractSelectedRows_Init(csi);
  vtkExtractSelection_Init(csi);
  vtkExtractTensorComponents_Init(csi);
  vtkExtractTimeSteps_Init(csi);
  vtkExtractUnstructuredGrid_Init(csi);
  vtkExtractVectorComponents_Init(csi);
  vtkFrustumSelector_Init(csi);
  vtkHierarchicalDataExtractDataSets_Init(csi);
  vtkHierarchicalDataExtractLevel_Init(csi);
  vtkLocationSelector_Init(csi);
  vtkProbeSelectedLocations_Init(csi);
  vtkSelector_Init(csi);
  vtkValueSelector_Init(csi);
}
