#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAbstractTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCylindricalTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGeneralTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHomogeneousTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkIdentityTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLandmarkTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMatrixToHomogeneousTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMatrixToLinearTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPerspectiveTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSphericalTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkThinPlateSplineTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransform2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransformCollection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWarpTransform_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkCommonTransformsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAbstractTransform_Init(csi);
  vtkCylindricalTransform_Init(csi);
  vtkGeneralTransform_Init(csi);
  vtkHomogeneousTransform_Init(csi);
  vtkIdentityTransform_Init(csi);
  vtkLandmarkTransform_Init(csi);
  vtkLinearTransform_Init(csi);
  vtkMatrixToHomogeneousTransform_Init(csi);
  vtkMatrixToLinearTransform_Init(csi);
  vtkPerspectiveTransform_Init(csi);
  vtkSphericalTransform_Init(csi);
  vtkThinPlateSplineTransform_Init(csi);
  vtkTransform_Init(csi);
  vtkTransform2D_Init(csi);
  vtkTransformCollection_Init(csi);
  vtkWarpTransform_Init(csi);
}
