// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: NASTRANPluginInfo.C
// ****************************************************************************

#include <NASTRANPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(NASTRAN,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(NASTRAN,General)

// ****************************************************************************
//  Method: NASTRANGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NASTRANGeneralPluginInfo::GetName() const
{
    return "NASTRAN";
}

// ****************************************************************************
//  Method: NASTRANGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NASTRANGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: NASTRANGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
NASTRANGeneralPluginInfo::GetID() const
{
    return "NASTRAN_1.0";
}
// ****************************************************************************
//  Method: NASTRANGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
NASTRANGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: NASTRANGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
NASTRANGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  NASTRANGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a NASTRAN database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
NASTRANGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.nas");
    defaultPatterns.push_back("*.f06");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  NASTRANGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a NASTRAN database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
NASTRANGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  NASTRANGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the NASTRAN plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
NASTRANGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
