// python wrapper for vtkSMProxyLink
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMProxyLink.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMProxyLink(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMProxyLink_ClassNew(); }

#ifndef DECLARED_PyvtkSMLink_ClassNew
extern "C" { PyObject *PyvtkSMLink_ClassNew(); }
#define DECLARED_PyvtkSMLink_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMProxyLink_ExceptionListBehavior_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMProxyLink.ExceptionListBehavior", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMProxyLink_ExceptionListBehavior_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMProxyLink_ExceptionListBehavior_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMProxyLink_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMProxyLink::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMProxyLink::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMProxyLink *tempr = vtkSMProxyLink::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxyLink *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMProxyLink::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMProxyLink::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMProxyLink::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_AddLinkedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddLinkedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  vtkSMProxy *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddLinkedProxy(temp0, temp1);
    }
    else
    {
      op->vtkSMProxyLink::AddLinkedProxy(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_LinkProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LinkProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->LinkProxies(temp0, temp1);
    }
    else
    {
      op->vtkSMProxyLink::LinkProxies(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_LinkProxyPropertyProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LinkProxyPropertyProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->LinkProxyPropertyProxies(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMProxyLink::LinkProxyPropertyProxies(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_RemoveLinkedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveLinkedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveLinkedProxy(temp0);
    }
    else
    {
      op->vtkSMProxyLink::RemoveLinkedProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetNumberOfLinkedObjects(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLinkedObjects");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfLinkedObjects() :
      op->vtkSMProxyLink::GetNumberOfLinkedObjects());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetNumberOfLinkedProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLinkedProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfLinkedProxies() :
      op->vtkSMProxyLink::GetNumberOfLinkedProxies());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetLinkedProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLinkedProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetLinkedProxy(temp0) :
      op->vtkSMProxyLink::GetLinkedProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetLinkedObjectDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLinkedObjectDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLinkedObjectDirection(temp0) :
      op->vtkSMProxyLink::GetLinkedObjectDirection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetLinkedProxyDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLinkedProxyDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLinkedProxyDirection(temp0) :
      op->vtkSMProxyLink::GetLinkedProxyDirection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_AddException(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddException");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddException(temp0);
    }
    else
    {
      op->vtkSMProxyLink::AddException(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_RemoveException(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveException");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveException(temp0);
    }
    else
    {
      op->vtkSMProxyLink::RemoveException(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_ClearExceptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearExceptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearExceptions();
    }
    else
    {
      op->vtkSMProxyLink::ClearExceptions();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_RemoveAllLinks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllLinks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllLinks();
    }
    else
    {
      op->vtkSMProxyLink::RemoveAllLinks();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_SetExceptionBehavior(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExceptionBehavior");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExceptionBehavior(temp0);
    }
    else
    {
      op->vtkSMProxyLink::SetExceptionBehavior(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_GetExceptionBehavior(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExceptionBehavior");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetExceptionBehavior() :
      op->vtkSMProxyLink::GetExceptionBehavior());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_SetExceptionBehaviorToBlacklist(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExceptionBehaviorToBlacklist");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetExceptionBehaviorToBlacklist();
    }
    else
    {
      op->vtkSMProxyLink::SetExceptionBehaviorToBlacklist();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyLink_SetExceptionBehaviorToWhitelist(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExceptionBehaviorToWhitelist");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyLink *op = static_cast<vtkSMProxyLink *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetExceptionBehaviorToWhitelist();
    }
    else
    {
      op->vtkSMProxyLink::SetExceptionBehaviorToWhitelist();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMProxyLink_Methods[] = {
  {"IsTypeOf", PyvtkSMProxyLink_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMProxyLink_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMProxyLink_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMProxyLink\nC++: static vtkSMProxyLink *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMProxyLink_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMProxyLink\nC++: vtkSMProxyLink *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMProxyLink_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMProxyLink_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddLinkedProxy", PyvtkSMProxyLink_AddLinkedProxy, METH_VARARGS,
   "AddLinkedProxy(self, proxy:vtkSMProxy, updateDir:int) -> None\nC++: virtual void AddLinkedProxy(vtkSMProxy *proxy, int updateDir)\n\nAdd a property to the link. updateDir determines whether a\nproperty of the proxy is read or written. When a property of an\ninput proxy changes, it's value is pushed to all other output\nproxies in the link. A proxy can be set to be both input and\noutput by adding 2 link, one to INPUT and the other to OUTPUT\n"},
  {"LinkProxies", PyvtkSMProxyLink_LinkProxies, METH_VARARGS,
   "LinkProxies(self, proxy1:vtkSMProxy, proxy2:vtkSMProxy) -> None\nC++: virtual void LinkProxies(vtkSMProxy *proxy1,\n    vtkSMProxy *proxy2)\n\nUtility method to add 2 proxies, both as INPUT and OUTPUT. This\nis equivalent to call 4 times AddLinkedProxy() with each\ncombination.\n"},
  {"LinkProxyPropertyProxies", PyvtkSMProxyLink_LinkProxyPropertyProxies, METH_VARARGS,
   "LinkProxyPropertyProxies(self, proxy1:vtkSMProxy,\n    proxy2:vtkSMProxy, pname:str) -> None\nC++: virtual void LinkProxyPropertyProxies(vtkSMProxy *proxy1,\n    vtkSMProxy *proxy2, const char *pname)\n\nUtility method to link the proxies stored as proxy property of\ninput proxies.\n"},
  {"RemoveLinkedProxy", PyvtkSMProxyLink_RemoveLinkedProxy, METH_VARARGS,
   "RemoveLinkedProxy(self, proxy:vtkSMProxy) -> None\nC++: virtual void RemoveLinkedProxy(vtkSMProxy *proxy)\n\nRemove a linked proxy.\n"},
  {"GetNumberOfLinkedObjects", PyvtkSMProxyLink_GetNumberOfLinkedObjects, METH_VARARGS,
   "GetNumberOfLinkedObjects(self) -> int\nC++: unsigned int GetNumberOfLinkedObjects() override;\n\nGet the number of proxies that are involved in this link.\n"},
  {"GetNumberOfLinkedProxies", PyvtkSMProxyLink_GetNumberOfLinkedProxies, METH_VARARGS,
   "GetNumberOfLinkedProxies(self) -> int\nC++: unsigned int GetNumberOfLinkedProxies()\n\n"},
  {"GetLinkedProxy", PyvtkSMProxyLink_GetLinkedProxy, METH_VARARGS,
   "GetLinkedProxy(self, index:int) -> vtkSMProxy\nC++: vtkSMProxy *GetLinkedProxy(int index) override;\n\nGet a proxy involved in this link.\n"},
  {"GetLinkedObjectDirection", PyvtkSMProxyLink_GetLinkedObjectDirection, METH_VARARGS,
   "GetLinkedObjectDirection(self, index:int) -> int\nC++: int GetLinkedObjectDirection(int index) override;\n\nGet the direction of a proxy involved in this link (see\nvtkSMLink::UpdateDirections)\n"},
  {"GetLinkedProxyDirection", PyvtkSMProxyLink_GetLinkedProxyDirection, METH_VARARGS,
   "GetLinkedProxyDirection(self, index:int) -> int\nC++: int GetLinkedProxyDirection(int index)\n\n"},
  {"AddException", PyvtkSMProxyLink_AddException, METH_VARARGS,
   "AddException(self, propertyname:str) -> None\nC++: void AddException(const char *propertyname)\n\nIt is possible to exclude certain properties from being\nsynchronized by this link. This method can be used to add/remove\nthe names for such exception properties. If ExceptionBehavior is\nset to BLACKLIST (default), exceptions are excluded from\nsynchronization. If ExceptionBehavior is set to WHITELIST,\nexceptions are the only one synchronized.\n"},
  {"RemoveException", PyvtkSMProxyLink_RemoveException, METH_VARARGS,
   "RemoveException(self, propertyname:str) -> None\nC++: void RemoveException(const char *propertyname)\n\n"},
  {"ClearExceptions", PyvtkSMProxyLink_ClearExceptions, METH_VARARGS,
   "ClearExceptions(self) -> None\nC++: void ClearExceptions()\n\n"},
  {"RemoveAllLinks", PyvtkSMProxyLink_RemoveAllLinks, METH_VARARGS,
   "RemoveAllLinks(self) -> None\nC++: void RemoveAllLinks() override;\n\nRemove all links.\n"},
  {"SetExceptionBehavior", PyvtkSMProxyLink_SetExceptionBehavior, METH_VARARGS,
   "SetExceptionBehavior(self, _arg:int) -> None\nC++: virtual void SetExceptionBehavior(int _arg)\n\nSet/Get exception behavior. The list can be a blacklist or a\nwhitelist of proxy properties. Properties in the list will not be\nlinked if behavior is set to BLACKLIST, or they will be the only\nones linked if behavior is set to WHITELIST. Default: BLACKLIST.\n"},
  {"GetExceptionBehavior", PyvtkSMProxyLink_GetExceptionBehavior, METH_VARARGS,
   "GetExceptionBehavior(self) -> int\nC++: virtual int GetExceptionBehavior()\n\n"},
  {"SetExceptionBehaviorToBlacklist", PyvtkSMProxyLink_SetExceptionBehaviorToBlacklist, METH_VARARGS,
   "SetExceptionBehaviorToBlacklist(self) -> None\nC++: void SetExceptionBehaviorToBlacklist()\n\n"},
  {"SetExceptionBehaviorToWhitelist", PyvtkSMProxyLink_SetExceptionBehaviorToWhitelist, METH_VARARGS,
   "SetExceptionBehaviorToWhitelist(self) -> None\nC++: void SetExceptionBehaviorToWhitelist()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMProxyLink_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("exception_behavior"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyLink_GetExceptionBehavior(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyLink_SetExceptionBehavior(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyLink_SetExceptionBehavior(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExceptionBehavior/SetExceptionBehavior\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_linked_objects"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyLink_GetNumberOfLinkedObjects(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLinkedObjects\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_linked_proxies"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyLink_GetNumberOfLinkedProxies(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLinkedProxies\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMProxyLink_Doc =
  "vtkSMProxyLink - creates a link between two proxies.\n\n"
  "Superclass: vtkSMLink\n\n"
  "When a link is created between proxy A->B, whenever any property on\n"
  "proxy A is modified, a property with the same name as the modified\n"
  "property (if any) on proxy B is also modified to be the same as the\n"
  "property on the proxy A. Similarly whenever proxy\n"
  "A->UpdateVTKObjects() is called, B->UpdateVTKObjects() is also fired.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMProxyLink_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMProxyLink", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMProxyLink_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMProxyLink_StaticNew()
{
  return vtkSMProxyLink::New();
}

PyObject *PyvtkSMProxyLink_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMProxyLink_Type, PyvtkSMProxyLink_Methods,
    "vtkSMProxyLink",
 &PyvtkSMProxyLink_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMLink_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMProxyLink_ExceptionListBehavior_Type);
  PyVTKEnum_Add(&PyvtkSMProxyLink_ExceptionListBehavior_Type, "vtkSMProxyLink.ExceptionListBehavior");

  o = (PyObject *)&PyvtkSMProxyLink_ExceptionListBehavior_Type;
  if (PyDict_SetItemString(d, "ExceptionListBehavior", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkSMProxyLink::ExceptionListBehavior cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "BLACKLIST", vtkSMProxyLink::BLACKLIST },
        { "WHITELIST", vtkSMProxyLink::WHITELIST },
      };

    o = PyvtkSMProxyLink_ExceptionListBehavior_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMProxyLink_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMProxyLink(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMProxyLink_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMProxyLink", o) != 0)
  {
    Py_DECREF(o);
  }

}

