// python wrapper for vtkPVServerManagerPluginInterface
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPVServerManagerPluginInterface.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVServerManagerPluginInterface(PyObject *dict); }

static PyObject *
PyvtkPVServerManagerPluginInterface_GetXMLs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXMLs");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVServerManagerPluginInterface *op = static_cast<vtkPVServerManagerPluginInterface *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    op->GetXMLs(temp0);

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp0.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp0.data(), temp0.size()));
      ap.SetContents(0, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVServerManagerPluginInterface_GetEnsurePluginLoaded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnsurePluginLoaded");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVServerManagerPluginInterface *op = static_cast<vtkPVServerManagerPluginInterface *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetEnsurePluginLoaded();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVServerManagerPluginInterface_Methods[] = {
  {"GetXMLs", PyvtkPVServerManagerPluginInterface_GetXMLs, METH_VARARGS,
   "GetXMLs(self, xmls:[str, ...]) -> None\nC++: virtual void GetXMLs(std::vector<std::string> &xmls)\n\nObtain the server-manager configuration xmls, if any.\n"},
  {"GetEnsurePluginLoaded", PyvtkPVServerManagerPluginInterface_GetEnsurePluginLoaded, METH_VARARGS,
   "GetEnsurePluginLoaded(self) -> bool\nC++: virtual bool GetEnsurePluginLoaded()\n\nReturn if the plugin should be ensured when using a proxy\nprovided by the XMLs Useful for delayed load plugin\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVServerManagerPluginInterface_GetSets[] = {
  {
    /*name=*/pystr("ensure_plugin_loaded"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVServerManagerPluginInterface_GetEnsurePluginLoaded(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEnsurePluginLoaded\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static const char *PyvtkPVServerManagerPluginInterface_Doc =
  "vtkPVServerManagerPluginInterface - vtkPVServerManagerPluginInterface\ndefines the interface needed to be implemented by a server-manager\nplugin i.e.\n\n"
  "a plugin that adds new filters/readers/proxies etc. to ParaView.\n\n";

static PyObject *
PyvtkPVServerManagerPluginInterface_New(PyTypeObject * /*unused*/, PyObject * /*unused*/, PyObject * /*unused*/)
{
  PyErr_SetString(PyExc_TypeError,
                  "this class cannot be instantiated");

  return nullptr;
}

static void PyvtkPVServerManagerPluginInterface_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVServerManagerPluginInterface *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVServerManagerPluginInterface_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVServerManagerPluginInterface_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVServerManagerPluginInterface", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVServerManagerPluginInterface_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVServerManagerPluginInterface_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVServerManagerPluginInterface_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVServerManagerPluginInterface_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkPVServerManagerPluginInterface_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVServerManagerPluginInterface_TypeNew(); }
#define DECLARED_PyvtkPVServerManagerPluginInterface_TypeNew
#endif

PyObject *PyvtkPVServerManagerPluginInterface_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVServerManagerPluginInterface_Type,
    PyvtkPVServerManagerPluginInterface_Methods,
    PyvtkPVServerManagerPluginInterface_GetSets,
    nullptr,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVServerManagerPluginInterface(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVServerManagerPluginInterface_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVServerManagerPluginInterface", o) != 0)
  {
    Py_DECREF(o);
  }

}

