// python wrapper for vtkPVXMLParser
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkPVXMLParser.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVXMLParser(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVXMLParser_ClassNew(); }


static PyObject *
PyvtkPVXMLParser_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVXMLParser::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVXMLParser::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVXMLParser *tempr = vtkPVXMLParser::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVXMLParser *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVXMLParser::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVXMLParser::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVXMLParser::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_GetRootElement(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRootElement");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->GetRootElement() :
      op->vtkPVXMLParser::GetRootElement());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_GetSuppressErrorMessages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSuppressErrorMessages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSuppressErrorMessages() :
      op->vtkPVXMLParser::GetSuppressErrorMessages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_SetSuppressErrorMessages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSuppressErrorMessages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSuppressErrorMessages(temp0);
    }
    else
    {
      op->vtkPVXMLParser::SetSuppressErrorMessages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_SuppressErrorMessagesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SuppressErrorMessagesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SuppressErrorMessagesOn();
    }
    else
    {
      op->vtkPVXMLParser::SuppressErrorMessagesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_SuppressErrorMessagesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SuppressErrorMessagesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXMLParser *op = static_cast<vtkPVXMLParser *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SuppressErrorMessagesOff();
    }
    else
    {
      op->vtkPVXMLParser::SuppressErrorMessagesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXMLParser_ParseXML(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ParseXML");

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkSmartPointer<vtkPVXMLElement> tempr = vtkPVXMLParser::ParseXML(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVXMLParser_Methods[] = {
  {"IsTypeOf", PyvtkPVXMLParser_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVXMLParser_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVXMLParser_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVXMLParser\nC++: static vtkPVXMLParser *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVXMLParser_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVXMLParser\nC++: vtkPVXMLParser *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVXMLParser_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVXMLParser_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetRootElement", PyvtkPVXMLParser_GetRootElement, METH_VARARGS,
   "GetRootElement(self) -> vtkPVXMLElement\nC++: vtkPVXMLElement *GetRootElement()\n\nGet the root element from the XML document.\n"},
  {"GetSuppressErrorMessages", PyvtkPVXMLParser_GetSuppressErrorMessages, METH_VARARGS,
   "GetSuppressErrorMessages(self) -> int\nC++: virtual int GetSuppressErrorMessages()\n\nIf on, then the Parse method will NOT report an error using\nvtkErrorMacro. Rather, it will just return false.  This feature\nis useful when simply checking to see if a file is a valid XML\nfile or there is otherwise a way to recover from the failed\nparse.  This flag is off by default.\n"},
  {"SetSuppressErrorMessages", PyvtkPVXMLParser_SetSuppressErrorMessages, METH_VARARGS,
   "SetSuppressErrorMessages(self, _arg:int) -> None\nC++: virtual void SetSuppressErrorMessages(int _arg)\n\n"},
  {"SuppressErrorMessagesOn", PyvtkPVXMLParser_SuppressErrorMessagesOn, METH_VARARGS,
   "SuppressErrorMessagesOn(self) -> None\nC++: virtual void SuppressErrorMessagesOn()\n\n"},
  {"SuppressErrorMessagesOff", PyvtkPVXMLParser_SuppressErrorMessagesOff, METH_VARARGS,
   "SuppressErrorMessagesOff(self) -> None\nC++: virtual void SuppressErrorMessagesOff()\n\n"},
  {"ParseXML", PyvtkPVXMLParser_ParseXML, METH_VARARGS,
   "ParseXML(xmlcontents:str, suppress_errors:bool=False)\n    -> vtkPVXMLElement\nC++: static vtkSmartPointer<vtkPVXMLElement> ParseXML(\n    const char *xmlcontents, bool suppress_errors=false)\n\nConvenience method to parse XML contents. Will return nullptr is\nthe xmlcontents cannot be parsed.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVXMLParser_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("suppress_error_messages"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXMLParser_GetSuppressErrorMessages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXMLParser_SetSuppressErrorMessages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXMLParser_SetSuppressErrorMessages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSuppressErrorMessages/SetSuppressErrorMessages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("root_element"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXMLParser_GetRootElement(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRootElement\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVXMLParser_Doc =
  "vtkPVXMLParser - This is a subclass of vtkXMLParser that constructs a\nrepresentation of parsed XML using vtkPVXMLElement.\n\n"
  "Superclass: vtkXMLParser\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVXMLParser_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsCore.vtkPVXMLParser", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVXMLParser_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVXMLParser_StaticNew()
{
  return vtkPVXMLParser::New();
}

PyObject *PyvtkPVXMLParser_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVXMLParser_Type, PyvtkPVXMLParser_Methods,
    "vtkPVXMLParser",
 &PyvtkPVXMLParser_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkXMLParser");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVXMLParser_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVXMLParser(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVXMLParser_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVXMLParser", o) != 0)
  {
    Py_DECREF(o);
  }

}

