#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkImageHSIToRGB_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageHSVToRGB_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageLuminance_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMapToRGBA_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMapToWindowLevelColors_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageQuantizeRGBToIndex_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRGBToHSI_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRGBToHSV_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRGBToXYZ_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRGBToYIQ_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageXYZToLAB_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageYIQToRGB_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkImagingColorCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkImageHSIToRGB_Init(csi);
  vtkImageHSVToRGB_Init(csi);
  vtkImageLuminance_Init(csi);
  vtkImageMapToRGBA_Init(csi);
  vtkImageMapToWindowLevelColors_Init(csi);
  vtkImageQuantizeRGBToIndex_Init(csi);
  vtkImageRGBToHSI_Init(csi);
  vtkImageRGBToHSV_Init(csi);
  vtkImageRGBToXYZ_Init(csi);
  vtkImageRGBToYIQ_Init(csi);
  vtkImageXYZToLAB_Init(csi);
  vtkImageYIQToRGB_Init(csi);
}
