// python wrapper for vtkSMPropertyGroup
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMPropertyGroup.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMPropertyGroup(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMPropertyGroup_ClassNew(); }

#ifndef DECLARED_PyvtkSMObject_ClassNew
extern "C" { PyObject *PyvtkSMObject_ClassNew(); }
#define DECLARED_PyvtkSMObject_ClassNew
#endif

static PyObject *
PyvtkSMPropertyGroup_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMPropertyGroup::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMPropertyGroup::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMPropertyGroup *tempr = vtkSMPropertyGroup::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMPropertyGroup *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMPropertyGroup::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMPropertyGroup::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMPropertyGroup::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_SetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetName(temp0);
    }
    else
    {
      op->vtkSMPropertyGroup::SetName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetName() :
      op->vtkSMPropertyGroup::GetName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_SetXMLLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXMLLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXMLLabel(temp0);
    }
    else
    {
      op->vtkSMPropertyGroup::SetXMLLabel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetXMLLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXMLLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetXMLLabel() :
      op->vtkSMPropertyGroup::GetXMLLabel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_SetPanelWidget(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPanelWidget");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPanelWidget(temp0);
    }
    else
    {
      op->vtkSMPropertyGroup::SetPanelWidget(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetPanelWidget(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPanelWidget");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPanelWidget() :
      op->vtkSMPropertyGroup::GetPanelWidget());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_SetPanelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPanelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPanelVisibility(temp0);
    }
    else
    {
      op->vtkSMPropertyGroup::SetPanelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetPanelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPanelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPanelVisibility() :
      op->vtkSMPropertyGroup::GetPanelVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_IsEmpty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsEmpty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsEmpty() :
      op->vtkSMPropertyGroup::IsEmpty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_AddProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  vtkSMProperty *temp1 = nullptr;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProperty") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->AddProperty(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMPropertyGroup::AddProperty(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetPropertyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPropertyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPropertyName(temp0) :
      op->vtkSMPropertyGroup::GetPropertyName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetProperty_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProperty *tempr = (ap.IsBound() ?
      op->GetProperty(temp0) :
      op->vtkSMPropertyGroup::GetProperty(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPropertyGroup_GetProperty_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProperty *tempr = (ap.IsBound() ?
      op->GetProperty(temp0) :
      op->vtkSMPropertyGroup::GetProperty(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPropertyGroup_GetProperty_Methods[] = {
  {"GetProperty", PyvtkSMPropertyGroup_GetProperty_s1, METH_VARARGS,
   "@I"},
  {"GetProperty", PyvtkSMPropertyGroup_GetProperty_s2, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMPropertyGroup_GetProperty(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMPropertyGroup_GetProperty_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetProperty");
  return nullptr;
}


static PyObject *
PyvtkSMPropertyGroup_GetFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFunction(temp0) :
      op->vtkSMPropertyGroup::GetFunction(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetNumberOfProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfProperties() :
      op->vtkSMPropertyGroup::GetNumberOfProperties());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetDocumentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDocumentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMDocumentation *tempr = (ap.IsBound() ?
      op->GetDocumentation() :
      op->vtkSMPropertyGroup::GetDocumentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_GetHints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->GetHints() :
      op->vtkSMPropertyGroup::GetHints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPropertyGroup_SetHints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPropertyGroup *op = static_cast<vtkSMPropertyGroup *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    if (ap.IsBound())
    {
      op->SetHints(temp0);
    }
    else
    {
      op->vtkSMPropertyGroup::SetHints(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPropertyGroup_Methods[] = {
  {"IsTypeOf", PyvtkSMPropertyGroup_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMPropertyGroup_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMPropertyGroup_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMPropertyGroup\nC++: static vtkSMPropertyGroup *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMPropertyGroup_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMPropertyGroup\nC++: vtkSMPropertyGroup *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMPropertyGroup_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMPropertyGroup_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetName", PyvtkSMPropertyGroup_SetName, METH_VARARGS,
   "SetName(self, _arg:str) -> None\nC++: virtual void SetName(const char *_arg)\n\nGet/Sets the name of the property group to name.\n"},
  {"GetName", PyvtkSMPropertyGroup_GetName, METH_VARARGS,
   "GetName(self) -> str\nC++: virtual char *GetName()\n\n"},
  {"SetXMLLabel", PyvtkSMPropertyGroup_SetXMLLabel, METH_VARARGS,
   "SetXMLLabel(self, _arg:str) -> None\nC++: virtual void SetXMLLabel(const char *_arg)\n\nGets/Sets the name of the property group to name.\n"},
  {"GetXMLLabel", PyvtkSMPropertyGroup_GetXMLLabel, METH_VARARGS,
   "GetXMLLabel(self) -> str\nC++: virtual char *GetXMLLabel()\n\n"},
  {"SetPanelWidget", PyvtkSMPropertyGroup_SetPanelWidget, METH_VARARGS,
   "SetPanelWidget(self, _arg:str) -> None\nC++: virtual void SetPanelWidget(const char *_arg)\n\nGet/Sets the name of the panel widget to use for the property\ngroup.\n"},
  {"GetPanelWidget", PyvtkSMPropertyGroup_GetPanelWidget, METH_VARARGS,
   "GetPanelWidget(self) -> str\nC++: virtual char *GetPanelWidget()\n\n"},
  {"SetPanelVisibility", PyvtkSMPropertyGroup_SetPanelVisibility, METH_VARARGS,
   "SetPanelVisibility(self, _arg:str) -> None\nC++: virtual void SetPanelVisibility(const char *_arg)\n\nGet/Sets the panel visibility for the property group.\n@sa vtkSMProperty::SetPanelVisibility()\n"},
  {"GetPanelVisibility", PyvtkSMPropertyGroup_GetPanelVisibility, METH_VARARGS,
   "GetPanelVisibility(self) -> str\nC++: virtual char *GetPanelVisibility()\n\n"},
  {"IsEmpty", PyvtkSMPropertyGroup_IsEmpty, METH_VARARGS,
   "IsEmpty(self) -> bool\nC++: bool IsEmpty()\n\nReturns true if the property group contains zero properties.\n"},
  {"AddProperty", PyvtkSMPropertyGroup_AddProperty, METH_VARARGS,
   "AddProperty(self, function:str, property:vtkSMProperty,\n    name:str=...) -> None\nC++: void AddProperty(const char *function,\n    vtkSMProperty *property, const char *name=nullptr)\n\nAdds property to the group. `name` is the name of the property.\nIf nullptr, then the property's XML name is used. `function` is\nthe role assigned to this property. If nullptr, the name (either\nspecified as argument, or the XML name for the property) will be\nused.\n"},
  {"GetPropertyName", PyvtkSMPropertyGroup_GetPropertyName, METH_VARARGS,
   "GetPropertyName(self, index:int) -> str\nC++: const char *GetPropertyName(unsigned int index)\n\nReturns the name for a property at the given index.\n"},
  {"GetProperty", PyvtkSMPropertyGroup_GetProperty, METH_VARARGS,
   "GetProperty(self, index:int) -> vtkSMProperty\nC++: vtkSMProperty *GetProperty(unsigned int index)\nGetProperty(self, function:str) -> vtkSMProperty\nC++: vtkSMProperty *GetProperty(const char *function)\n\nReturns the property at index.\n"},
  {"GetFunction", PyvtkSMPropertyGroup_GetFunction, METH_VARARGS,
   "GetFunction(self, property:vtkSMProperty) -> str\nC++: const char *GetFunction(vtkSMProperty *property)\n\nGiven property in the group, returns its function. Will return\nnullptr if the property is not present in this group.\n"},
  {"GetNumberOfProperties", PyvtkSMPropertyGroup_GetNumberOfProperties, METH_VARARGS,
   "GetNumberOfProperties(self) -> int\nC++: unsigned int GetNumberOfProperties()\n\nReturns the number of properties in the group.\n"},
  {"GetDocumentation", PyvtkSMPropertyGroup_GetDocumentation, METH_VARARGS,
   "GetDocumentation(self) -> vtkSMDocumentation\nC++: virtual vtkSMDocumentation *GetDocumentation()\n\nReturns the documentation for this proxy.\n"},
  {"GetHints", PyvtkSMPropertyGroup_GetHints, METH_VARARGS,
   "GetHints(self) -> vtkPVXMLElement\nC++: virtual vtkPVXMLElement *GetHints()\n\nThe server manager configuration XML may define `<Hints />`\nelement for a property-group. Hints are metadata associated with\nthe property-group. The Server Manager does not (and should not)\ninterpret the hints. Hints provide a mechanism to add GUI\npertinent information to the server manager XML.  Returns the XML\nelement for the hints associated with this property, if any,\notherwise returns `nullptr`;\n"},
  {"SetHints", PyvtkSMPropertyGroup_SetHints, METH_VARARGS,
   "SetHints(self, hints:vtkPVXMLElement) -> None\nC++: void SetHints(vtkPVXMLElement *hints)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMPropertyGroup_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPropertyGroup_SetName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPropertyGroup_SetName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetName/SetName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("xml_label"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetXMLLabel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPropertyGroup_SetXMLLabel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPropertyGroup_SetXMLLabel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXMLLabel/SetXMLLabel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("panel_widget"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetPanelWidget(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPropertyGroup_SetPanelWidget(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPropertyGroup_SetPanelWidget(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPanelWidget/SetPanelWidget\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("panel_visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetPanelVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPropertyGroup_SetPanelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPropertyGroup_SetPanelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPanelVisibility/SetPanelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hints"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetHints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPropertyGroup_SetHints(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPropertyGroup_SetHints(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHints/SetHints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("documentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetDocumentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDocumentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_properties"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPropertyGroup_GetNumberOfProperties(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfProperties\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMPropertyGroup_Doc =
  "vtkSMPropertyGroup - no description provided.\n\n"
  "Superclass: vtkSMObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMPropertyGroup_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMPropertyGroup", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMPropertyGroup_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMPropertyGroup_StaticNew()
{
  return vtkSMPropertyGroup::New();
}

PyObject *PyvtkSMPropertyGroup_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMPropertyGroup_Type, PyvtkSMPropertyGroup_Methods,
    "vtkSMPropertyGroup",
 &PyvtkSMPropertyGroup_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMObject_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMPropertyGroup_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMPropertyGroup(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMPropertyGroup_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMPropertyGroup", o) != 0)
  {
    Py_DECREF(o);
  }

}

