#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAutoCorrelativeStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBivariateLinearTableThreshold_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkComputeQuantiles_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkComputeQuartiles_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkContingencyStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCorrelativeStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDescriptiveStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractFunctionalBagPlot_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractHistogram_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHighestDensityRegionsStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkKMeansDistanceFunctor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkKMeansDistanceFunctorCalculator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkKMeansStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLengthDistribution_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiCorrelativeStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOrderStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPCAStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStatisticsAlgorithm_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStrahlerMetric_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStreamingStatistics_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersStatisticsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAutoCorrelativeStatistics_Init(csi);
  vtkBivariateLinearTableThreshold_Init(csi);
  vtkComputeQuantiles_Init(csi);
  vtkComputeQuartiles_Init(csi);
  vtkContingencyStatistics_Init(csi);
  vtkCorrelativeStatistics_Init(csi);
  vtkDescriptiveStatistics_Init(csi);
  vtkExtractFunctionalBagPlot_Init(csi);
  vtkExtractHistogram_Init(csi);
  vtkHighestDensityRegionsStatistics_Init(csi);
  vtkKMeansDistanceFunctor_Init(csi);
  vtkKMeansDistanceFunctorCalculator_Init(csi);
  vtkKMeansStatistics_Init(csi);
  vtkLengthDistribution_Init(csi);
  vtkMultiCorrelativeStatistics_Init(csi);
  vtkOrderStatistics_Init(csi);
  vtkPCAStatistics_Init(csi);
  vtkStatisticsAlgorithm_Init(csi);
  vtkStrahlerMetric_Init(csi);
  vtkStreamingStatistics_Init(csi);
}
