// python wrapper for vtkPVAxesWidget
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVAxesWidget.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVAxesWidget(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVAxesWidget_ClassNew(); }


static PyObject *
PyvtkPVAxesWidget_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVAxesWidget::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVAxesWidget::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVAxesWidget *tempr = vtkPVAxesWidget::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVAxesWidget *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVAxesWidget::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVAxesWidget::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVAxesWidget::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetAxesActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxesActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  vtkPVAxesActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVAxesActor"))
  {
    if (ap.IsBound())
    {
      op->SetAxesActor(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetAxesActor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetAxesActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxesActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVAxesActor *tempr = (ap.IsBound() ?
      op->GetAxesActor() :
      op->vtkPVAxesWidget::GetAxesActor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetParentRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParentRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->SetParentRenderer(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetParentRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetParentRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParentRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetParentRenderer() :
      op->vtkPVAxesWidget::GetParentRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->SetInteractor(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetInteractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer() :
      op->vtkPVAxesWidget::GetRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnabled(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVisibility() :
      op->vtkPVAxesWidget::GetVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetOutlineColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutlineColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOutlineColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesWidget::SetOutlineColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetOutlineColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutlineColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetOutlineColor() :
      op->vtkPVAxesWidget::GetOutlineColor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesWidget::SetAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetAxisLabelColor() :
      op->vtkPVAxesWidget::GetAxisLabelColor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetViewport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetViewport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetViewport(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVAxesWidget::SetViewport(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_GetViewport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetViewport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetViewport() :
      op->vtkPVAxesWidget::GetViewport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetXAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetXAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesWidget::SetXAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetYAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetYAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesWidget::SetYAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetZAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetZAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVAxesWidget::SetZAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetXAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXAxisVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetXAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetYAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYAxisVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetYAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetZAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZAxisVisibility(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetZAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetXAxisLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXAxisLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXAxisLabelText(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetXAxisLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetYAxisLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYAxisLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYAxisLabelText(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetYAxisLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVAxesWidget_SetZAxisLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZAxisLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVAxesWidget *op = static_cast<vtkPVAxesWidget *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZAxisLabelText(temp0);
    }
    else
    {
      op->vtkPVAxesWidget::SetZAxisLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVAxesWidget_Methods[] = {
  {"IsTypeOf", PyvtkPVAxesWidget_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVAxesWidget_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVAxesWidget_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVAxesWidget\nC++: static vtkPVAxesWidget *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVAxesWidget_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVAxesWidget\nC++: vtkPVAxesWidget *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVAxesWidget_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVAxesWidget_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetAxesActor", PyvtkPVAxesWidget_SetAxesActor, METH_VARARGS,
   "SetAxesActor(self, actor:vtkPVAxesActor) -> None\nC++: void SetAxesActor(vtkPVAxesActor *actor)\n\nSet/get the axes actor to be displayed in this 3D widget.\n"},
  {"GetAxesActor", PyvtkPVAxesWidget_GetAxesActor, METH_VARARGS,
   "GetAxesActor(self) -> vtkPVAxesActor\nC++: virtual vtkPVAxesActor *GetAxesActor()\n\n"},
  {"SetParentRenderer", PyvtkPVAxesWidget_SetParentRenderer, METH_VARARGS,
   "SetParentRenderer(self, ren:vtkRenderer) -> None\nC++: void SetParentRenderer(vtkRenderer *ren)\n\nSet the renderer this 3D widget will be contained in.\n"},
  {"GetParentRenderer", PyvtkPVAxesWidget_GetParentRenderer, METH_VARARGS,
   "GetParentRenderer(self) -> vtkRenderer\nC++: vtkRenderer *GetParentRenderer()\n\n"},
  {"SetInteractor", PyvtkPVAxesWidget_SetInteractor, METH_VARARGS,
   "SetInteractor(self, iren:vtkRenderWindowInteractor) -> None\nC++: void SetInteractor(vtkRenderWindowInteractor *iren) override;\n\nOverridden to add interaction observers.\n"},
  {"GetRenderer", PyvtkPVAxesWidget_GetRenderer, METH_VARARGS,
   "GetRenderer(self) -> vtkRenderer\nC++: virtual vtkRenderer *GetRenderer()\n\nGet the renderer.\n"},
  {"SetEnabled", PyvtkPVAxesWidget_SetEnabled, METH_VARARGS,
   "SetEnabled(self, __a:int) -> None\nC++: void SetEnabled(int) override;\n\nOverridden to update this->Enabled and hide outline when\ndisabled. Use this method to enable/disable interactivity.\n"},
  {"SetVisibility", PyvtkPVAxesWidget_SetVisibility, METH_VARARGS,
   "SetVisibility(self, val:bool) -> None\nC++: void SetVisibility(bool val)\n\nGet/Set the visibility. Note if visibility is off, Enabled state\nis ignored and assumed off.\n"},
  {"GetVisibility", PyvtkPVAxesWidget_GetVisibility, METH_VARARGS,
   "GetVisibility(self) -> bool\nC++: bool GetVisibility()\n\n"},
  {"SetOutlineColor", PyvtkPVAxesWidget_SetOutlineColor, METH_VARARGS,
   "SetOutlineColor(self, r:float, g:float, b:float) -> None\nC++: void SetOutlineColor(double r, double g, double b)\n\nSet/get the color of the outline of this widget.  The outline is\nvisible when (in interactive mode) the cursor is over this 3D\nwidget.\n"},
  {"GetOutlineColor", PyvtkPVAxesWidget_GetOutlineColor, METH_VARARGS,
   "GetOutlineColor(self) -> Pointer\nC++: double *GetOutlineColor()\n\n"},
  {"SetAxisLabelColor", PyvtkPVAxesWidget_SetAxisLabelColor, METH_VARARGS,
   "SetAxisLabelColor(self, r:float, g:float, b:float) -> None\nC++: void SetAxisLabelColor(double r, double g, double b)\n\nSet/get the color of the axis labels of this widget.\n"},
  {"GetAxisLabelColor", PyvtkPVAxesWidget_GetAxisLabelColor, METH_VARARGS,
   "GetAxisLabelColor(self) -> Pointer\nC++: double *GetAxisLabelColor()\n\n"},
  {"SetViewport", PyvtkPVAxesWidget_SetViewport, METH_VARARGS,
   "SetViewport(self, minX:float, minY:float, maxX:float, maxY:float)\n    -> None\nC++: void SetViewport(double minX, double minY, double maxX,\n    double maxY)\n\nSet/get the viewport to position/size this 3D widget.\n"},
  {"GetViewport", PyvtkPVAxesWidget_GetViewport, METH_VARARGS,
   "GetViewport(self) -> Pointer\nC++: double *GetViewport()\n\n"},
  {"SetXAxisColor", PyvtkPVAxesWidget_SetXAxisColor, METH_VARARGS,
   "SetXAxisColor(self, r:float, g:float, b:float) -> None\nC++: void SetXAxisColor(double r, double g, double b)\n\nSet the color and visibility of each individual axis.\n"},
  {"SetYAxisColor", PyvtkPVAxesWidget_SetYAxisColor, METH_VARARGS,
   "SetYAxisColor(self, r:float, g:float, b:float) -> None\nC++: void SetYAxisColor(double r, double g, double b)\n\n"},
  {"SetZAxisColor", PyvtkPVAxesWidget_SetZAxisColor, METH_VARARGS,
   "SetZAxisColor(self, r:float, g:float, b:float) -> None\nC++: void SetZAxisColor(double r, double g, double b)\n\n"},
  {"SetXAxisVisibility", PyvtkPVAxesWidget_SetXAxisVisibility, METH_VARARGS,
   "SetXAxisVisibility(self, vis:bool) -> None\nC++: void SetXAxisVisibility(bool vis)\n\n"},
  {"SetYAxisVisibility", PyvtkPVAxesWidget_SetYAxisVisibility, METH_VARARGS,
   "SetYAxisVisibility(self, vis:bool) -> None\nC++: void SetYAxisVisibility(bool vis)\n\n"},
  {"SetZAxisVisibility", PyvtkPVAxesWidget_SetZAxisVisibility, METH_VARARGS,
   "SetZAxisVisibility(self, vis:bool) -> None\nC++: void SetZAxisVisibility(bool vis)\n\n"},
  {"SetXAxisLabelText", PyvtkPVAxesWidget_SetXAxisLabelText, METH_VARARGS,
   "SetXAxisLabelText(self, text:str) -> None\nC++: void SetXAxisLabelText(const char *text)\n\n"},
  {"SetYAxisLabelText", PyvtkPVAxesWidget_SetYAxisLabelText, METH_VARARGS,
   "SetYAxisLabelText(self, text:str) -> None\nC++: void SetYAxisLabelText(const char *text)\n\n"},
  {"SetZAxisLabelText", PyvtkPVAxesWidget_SetZAxisLabelText, METH_VARARGS,
   "SetZAxisLabelText(self, text:str) -> None\nC++: void SetZAxisLabelText(const char *text)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVAxesWidget_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("axes_actor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetAxesActor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetAxesActor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetAxesActor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAxesActor/SetAxesActor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parent_renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetParentRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetParentRenderer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetParentRenderer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParentRenderer/SetParentRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetInteractor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetInteractor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInteractor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enabled"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVisibility/SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("outline_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetOutlineColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetOutlineColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutlineColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("viewport"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetViewport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetViewport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetViewport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetXAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetXAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetXAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetYAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetYAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetYAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetZAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetZAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetZAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetXAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetXAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetXAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetYAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetYAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetYAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetZAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetZAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetZAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_axis_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetXAxisLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetXAxisLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetXAxisLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_axis_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetYAxisLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetYAxisLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetYAxisLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_axis_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVAxesWidget_SetZAxisLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVAxesWidget_SetZAxisLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetZAxisLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("outline_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetOutlineColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOutlineColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetAxisLabelColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("viewport"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVAxesWidget_GetViewport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetViewport\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVAxesWidget_Doc =
  "vtkPVAxesWidget - A widget to manipulate vtkPVAxesWidget.\n\n"
  "Superclass: vtkInteractorObserver\n\n"
  "This widget creates and manages its own vtkPVAxesActor. To use this\n"
  "widget, make sure you call SetParentRenderer and SetInteractor (if\n"
  "interactivity is needed). Use `SetEnabled` to enable/disable\n"
  "interactivity and `SetVisibility` to show/hide the axes.\n\n"
  "ote This is an old class that uses old style for create widgets.\n"
  "Please don't use it as a reference for creating similar elements.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVAxesWidget_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVAxesWidget", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVAxesWidget_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVAxesWidget_StaticNew()
{
  return vtkPVAxesWidget::New();
}

PyObject *PyvtkPVAxesWidget_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVAxesWidget_Type, PyvtkPVAxesWidget_Methods,
    "vtkPVAxesWidget",
 &PyvtkPVAxesWidget_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkInteractorObserver");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  o = PyLong_FromLong(1);
  if (o)
  {
    PyDict_SetItemString(d, "RendererLayer", o);
    Py_DECREF(o);
  }
  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVAxesWidget_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVAxesWidget(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVAxesWidget_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVAxesWidget", o) != 0)
  {
    Py_DECREF(o);
  }

}

