// python wrapper for vtkPVSessionServer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVSessionServer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVSessionServer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVSessionServer_ClassNew(); }

#ifndef DECLARED_PyvtkPVSessionBase_ClassNew
extern "C" { PyObject *PyvtkPVSessionBase_ClassNew(); }
#define DECLARED_PyvtkPVSessionBase_ClassNew
#endif

static PyObject *
PyvtkPVSessionServer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVSessionServer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVSessionServer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVSessionServer *tempr = vtkPVSessionServer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSessionServer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVSessionServer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVSessionServer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVSessionServer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_Connect_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Connect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->Connect(temp0) :
      op->vtkPVSessionServer::Connect(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVSessionServer_Connect_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Connect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Connect() :
      op->vtkPVSessionServer::Connect());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVSessionServer_Connect(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVSessionServer_Connect_s1(self, args);
    case 0:
      return PyvtkPVSessionServer_Connect_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Connect");
  return nullptr;
}


static PyObject *
PyvtkPVSessionServer_GetIsAlive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsAlive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsAlive() :
      op->vtkPVSessionServer::GetIsAlive());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_MultipleConnectionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MultipleConnectionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MultipleConnectionOn();
    }
    else
    {
      op->vtkPVSessionServer::MultipleConnectionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_MultipleConnectionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MultipleConnectionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MultipleConnectionOff();
    }
    else
    {
      op->vtkPVSessionServer::MultipleConnectionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_SetMultipleConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMultipleConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMultipleConnection(temp0);
    }
    else
    {
      op->vtkPVSessionServer::SetMultipleConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_GetMultipleConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMultipleConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMultipleConnection() :
      op->vtkPVSessionServer::GetMultipleConnection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_DisableFurtherConnectionsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableFurtherConnectionsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableFurtherConnectionsOn();
    }
    else
    {
      op->vtkPVSessionServer::DisableFurtherConnectionsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_DisableFurtherConnectionsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableFurtherConnectionsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableFurtherConnectionsOff();
    }
    else
    {
      op->vtkPVSessionServer::DisableFurtherConnectionsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_GetDisableFurtherConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableFurtherConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableFurtherConnections() :
      op->vtkPVSessionServer::GetDisableFurtherConnections());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_SetDisableFurtherConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisableFurtherConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisableFurtherConnections(temp0);
    }
    else
    {
      op->vtkPVSessionServer::SetDisableFurtherConnections(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_SetConnectID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConnectID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConnectID(temp0);
    }
    else
    {
      op->vtkPVSessionServer::SetConnectID(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_GetConnectID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConnectID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetConnectID() :
      op->vtkPVSessionServer::GetConnectID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionServer_OnClientServerMessageRMI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnClientServerMessageRMI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetBuffer(temp0, &pbuf0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->OnClientServerMessageRMI(temp0, temp1);
    }
    else
    {
      op->vtkPVSessionServer::OnClientServerMessageRMI(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}


static PyObject *
PyvtkPVSessionServer_OnCloseSessionRMI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnCloseSessionRMI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionServer *op = static_cast<vtkPVSessionServer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OnCloseSessionRMI();
    }
    else
    {
      op->vtkPVSessionServer::OnCloseSessionRMI();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVSessionServer_Methods[] = {
  {"IsTypeOf", PyvtkPVSessionServer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVSessionServer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVSessionServer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVSessionServer\nC++: static vtkPVSessionServer *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVSessionServer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVSessionServer\nC++: vtkPVSessionServer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVSessionServer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVSessionServer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Connect", PyvtkPVSessionServer_Connect, METH_VARARGS,
   "Connect(self, url:str) -> bool\nC++: virtual bool Connect(const char *url)\nConnect(self) -> bool\nC++: bool Connect()\n\nConnects a remote server. URL can be of the following format:\ncs://<pvserver-host>:<pvserver-port>\ncdsrs://<pvdataserver-host>:<pvdataserver-port>/<pvrenderserver-ho\nst>:<pvrenderserver-port> In both cases the port is optional.\nWhen not provided default pvserver/pvdataserver port // is 11111,\nwhile default pvrenderserver port is 22221. For reverse connect\ni.e. the client waits for the server to connect back, simply add\n\"rc\" to the protocol e.g. csrc://<pvserver-host>:<pvserver-port>\ncdsrsrc://<pvdataserver-host>:<pvdataserver-port>/<pvrenderserver-\nhost>:<pvrenderserver-port> In this case, the hostname is\nirrelevant and is ignored.\n"},
  {"GetIsAlive", PyvtkPVSessionServer_GetIsAlive, METH_VARARGS,
   "GetIsAlive(self) -> bool\nC++: bool GetIsAlive() override;\n\nReturns true is this session is active/alive/valid.\n"},
  {"MultipleConnectionOn", PyvtkPVSessionServer_MultipleConnectionOn, METH_VARARGS,
   "MultipleConnectionOn(self) -> None\nC++: virtual void MultipleConnectionOn()\n\nEnable or Disable multi-connection support. The\nMultipleConnection is only used inside the DATA_SERVER to support\nseveral clients to connect to it. By default, collaboration is\nnot allowed (this->MultipleConnection = false)\n"},
  {"MultipleConnectionOff", PyvtkPVSessionServer_MultipleConnectionOff, METH_VARARGS,
   "MultipleConnectionOff(self) -> None\nC++: virtual void MultipleConnectionOff()\n\n"},
  {"SetMultipleConnection", PyvtkPVSessionServer_SetMultipleConnection, METH_VARARGS,
   "SetMultipleConnection(self, _arg:bool) -> None\nC++: virtual void SetMultipleConnection(bool _arg)\n\n"},
  {"GetMultipleConnection", PyvtkPVSessionServer_GetMultipleConnection, METH_VARARGS,
   "GetMultipleConnection(self) -> bool\nC++: virtual bool GetMultipleConnection()\n\n"},
  {"DisableFurtherConnectionsOn", PyvtkPVSessionServer_DisableFurtherConnectionsOn, METH_VARARGS,
   "DisableFurtherConnectionsOn(self) -> None\nC++: virtual void DisableFurtherConnectionsOn()\n\nEnable or Disable further connections in multiple connection\nmode. By default, further connections are enabled.\n(this->DisableFurtherConnections = false)\n"},
  {"DisableFurtherConnectionsOff", PyvtkPVSessionServer_DisableFurtherConnectionsOff, METH_VARARGS,
   "DisableFurtherConnectionsOff(self) -> None\nC++: virtual void DisableFurtherConnectionsOff()\n\n"},
  {"GetDisableFurtherConnections", PyvtkPVSessionServer_GetDisableFurtherConnections, METH_VARARGS,
   "GetDisableFurtherConnections(self) -> bool\nC++: virtual bool GetDisableFurtherConnections()\n\n"},
  {"SetDisableFurtherConnections", PyvtkPVSessionServer_SetDisableFurtherConnections, METH_VARARGS,
   "SetDisableFurtherConnections(self, disable:bool) -> None\nC++: void SetDisableFurtherConnections(bool disable)\n\n"},
  {"SetConnectID", PyvtkPVSessionServer_SetConnectID, METH_VARARGS,
   "SetConnectID(self, newConnectID:int) -> None\nC++: void SetConnectID(int newConnectID)\n\nSet/Get the server connect-id. Default is 0.\n"},
  {"GetConnectID", PyvtkPVSessionServer_GetConnectID, METH_VARARGS,
   "GetConnectID(self) -> int\nC++: int GetConnectID()\n\n"},
  {"OnClientServerMessageRMI", PyvtkPVSessionServer_OnClientServerMessageRMI, METH_VARARGS,
   "OnClientServerMessageRMI(self, message:Pointer,\n    message_length:int) -> None\nC++: void OnClientServerMessageRMI(void *message,\n    int message_length)\n\n"},
  {"OnCloseSessionRMI", PyvtkPVSessionServer_OnCloseSessionRMI, METH_VARARGS,
   "OnCloseSessionRMI(self) -> None\nC++: void OnCloseSessionRMI()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVSessionServer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("multiple_connection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionServer_GetMultipleConnection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSessionServer_SetMultipleConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSessionServer_SetMultipleConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMultipleConnection/SetMultipleConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_further_connections"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionServer_GetDisableFurtherConnections(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSessionServer_SetDisableFurtherConnections(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSessionServer_SetDisableFurtherConnections(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisableFurtherConnections/SetDisableFurtherConnections\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("connect_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionServer_GetConnectID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSessionServer_SetConnectID(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSessionServer_SetConnectID(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConnectID/SetConnectID\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_alive"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionServer_GetIsAlive(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsAlive\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVSessionServer_Doc =
  "vtkPVSessionServer - vtkSMSessionServer is a session used on data\nand/or render servers.\n\n"
  "Superclass: vtkPVSessionBase\n\n"
  "It's designed for a process that works with a separate client process\n"
  "that acts as the visualization driver.\n"
  "@sa\n"
  "vtkSMSessionClient\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSessionServer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVSessionServer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVSessionServer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVSessionServer_StaticNew()
{
  return vtkPVSessionServer::New();
}

PyObject *PyvtkPVSessionServer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVSessionServer_Type, PyvtkPVSessionServer_Methods,
    "vtkPVSessionServer",
 &PyvtkPVSessionServer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVSessionBase_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 14; c++)
  {
    static const struct { const char *name; int value; }
      constants[14] = {
        { "PUSH", vtkPVSessionServer::PUSH },
        { "PULL", vtkPVSessionServer::PULL },
        { "EXECUTE_STREAM", vtkPVSessionServer::EXECUTE_STREAM },
        { "GATHER_INFORMATION", vtkPVSessionServer::GATHER_INFORMATION },
        { "REGISTER_SI", vtkPVSessionServer::REGISTER_SI },
        { "UNREGISTER_SI", vtkPVSessionServer::UNREGISTER_SI },
        { "LAST_RESULT", vtkPVSessionServer::LAST_RESULT },
        { "SERVER_NOTIFICATION_MESSAGE_RMI", vtkPVSessionServer::SERVER_NOTIFICATION_MESSAGE_RMI },
        { "CLIENT_SERVER_MESSAGE_RMI", vtkPVSessionServer::CLIENT_SERVER_MESSAGE_RMI },
        { "CLOSE_SESSION", vtkPVSessionServer::CLOSE_SESSION },
        { "REPLY_GATHER_INFORMATION_TAG", vtkPVSessionServer::REPLY_GATHER_INFORMATION_TAG },
        { "REPLY_PULL", vtkPVSessionServer::REPLY_PULL },
        { "REPLY_LAST_RESULT", vtkPVSessionServer::REPLY_LAST_RESULT },
        { "EXECUTE_STREAM_TAG", vtkPVSessionServer::EXECUTE_STREAM_TAG },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVSessionServer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVSessionServer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVSessionServer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVSessionServer", o) != 0)
  {
    Py_DECREF(o);
  }

}

