// python wrapper for vtkCPPythonScriptV2Pipeline
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCPPythonScriptV2Pipeline.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPPythonScriptV2Pipeline(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPPythonScriptV2Pipeline_ClassNew(); }

#ifndef DECLARED_PyvtkCPPythonPipeline_ClassNew
extern "C" { PyObject *PyvtkCPPythonPipeline_ClassNew(); }
#define DECLARED_PyvtkCPPythonPipeline_ClassNew
#endif

static PyObject *
PyvtkCPPythonScriptV2Pipeline_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPPythonScriptV2Pipeline::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPPythonScriptV2Pipeline::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPPythonScriptV2Pipeline *tempr = vtkCPPythonScriptV2Pipeline::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPPythonScriptV2Pipeline *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPPythonScriptV2Pipeline::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPPythonScriptV2Pipeline::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPPythonScriptV2Pipeline::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->Initialize(temp0) :
      op->vtkCPPythonScriptV2Pipeline::Initialize(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_RequestDataDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RequestDataDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    int tempr = (ap.IsBound() ?
      op->RequestDataDescription(temp0) :
      op->vtkCPPythonScriptV2Pipeline::RequestDataDescription(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_CoProcess(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CoProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  vtkCPDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPDataDescription"))
  {
    int tempr = (ap.IsBound() ?
      op->CoProcess(temp0) :
      op->vtkCPPythonScriptV2Pipeline::CoProcess(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonScriptV2Pipeline_Finalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Finalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonScriptV2Pipeline *op = static_cast<vtkCPPythonScriptV2Pipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Finalize() :
      op->vtkCPPythonScriptV2Pipeline::Finalize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPPythonScriptV2Pipeline_Methods[] = {
  {"IsTypeOf", PyvtkCPPythonScriptV2Pipeline_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPPythonScriptV2Pipeline_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPPythonScriptV2Pipeline_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPPythonScriptV2Pipeline\nC++: static vtkCPPythonScriptV2Pipeline *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPPythonScriptV2Pipeline_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPPythonScriptV2Pipeline\nC++: vtkCPPythonScriptV2Pipeline *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPPythonScriptV2Pipeline_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPPythonScriptV2Pipeline_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkCPPythonScriptV2Pipeline_Initialize, METH_VARARGS,
   "Initialize(self, filename:str) -> bool\nC++: bool Initialize(const char *filename)\n\nInitialize from a zip archive. If the packagename is not\nspecified, then the it is assumed to be the same as the filename\nfor the zip archive without the extension.\n\nFor HPC use-cases, this is the preferred approach since we ensure\nthat only the root node makes disk access thus avoid thrashing\nthe IO subsystem and improving load times.\n"},
  {"RequestDataDescription", PyvtkCPPythonScriptV2Pipeline_RequestDataDescription, METH_VARARGS,
   "RequestDataDescription(self, dataDescription:vtkCPDataDescription)\n     -> int\nC++: int RequestDataDescription(\n    vtkCPDataDescription *dataDescription) override;\n\nImplementation for vtkCPPipeline API\n"},
  {"CoProcess", PyvtkCPPythonScriptV2Pipeline_CoProcess, METH_VARARGS,
   "CoProcess(self, dataDescription:vtkCPDataDescription) -> int\nC++: int CoProcess(vtkCPDataDescription *dataDescription)\n    override;\n\nExecute the pipeline. Returns 1 for success and 0 for failure.\n"},
  {"Finalize", PyvtkCPPythonScriptV2Pipeline_Finalize, METH_VARARGS,
   "Finalize(self) -> int\nC++: int Finalize() override;\n\nFinalize the pipeline before deleting it. A default no-op\nimplementation is given. Returns 1 for success and 0 for failure.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPPythonScriptV2Pipeline_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPPythonScriptV2Pipeline_Doc =
  "vtkCPPythonScriptV2Pipeline - vtkCPPipeline for Catalyst Python\nscript / package version 2.0\n\n"
  "Superclass: vtkCPPythonPipeline\n\n"
  "vtkCPPythonScriptV2Pipeline is intended to use with ParaView Python\n"
  "scripts introduced in ParaView version 5.9. These Python scripts\n"
  "typically use extract generators to define the extracts to be\n"
  "generated. This class is used to use such packages in Catalyst.\n\n"
  "For details on the supported Python scripts and how to use them to\n"
  "write in situ analysis, refer to ['Anatomy of Catalyst Python Module (Version\n"
  "2.0)'](@ref CatalystPythonScriptsV2).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPPythonScriptV2Pipeline_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVPythonCatalyst.vtkCPPythonScriptV2Pipeline", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPPythonScriptV2Pipeline_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCPPythonScriptV2Pipeline_StaticNew()
{
  return vtkCPPythonScriptV2Pipeline::New();
}

PyObject *PyvtkCPPythonScriptV2Pipeline_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPPythonScriptV2Pipeline_Type, PyvtkCPPythonScriptV2Pipeline_Methods,
    "vtkCPPythonScriptV2Pipeline",
 &PyvtkCPPythonScriptV2Pipeline_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkCPPythonPipeline_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPPythonScriptV2Pipeline_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPPythonScriptV2Pipeline(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPPythonScriptV2Pipeline_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPPythonScriptV2Pipeline", o) != 0)
  {
    Py_DECREF(o);
  }

}

