// python wrapper for vtkPVFileInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVFileInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVFileInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVFileInformation_ClassNew(); }

#ifndef DECLARED_PyvtkPVInformation_ClassNew
extern "C" { PyObject *PyvtkPVInformation_ClassNew(); }
#define DECLARED_PyvtkPVInformation_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVFileInformation_FileTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVFileInformation.FileTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVFileInformation_FileTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVFileInformation_FileTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVFileInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVFileInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVFileInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVFileInformation *tempr = vtkPVFileInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVFileInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVFileInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVFileInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVFileInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVFileInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_IsDirectory_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsDirectory");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkPVFileInformation::IsDirectory(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVFileInformation_IsDirectory_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsDirectory() :
      op->vtkPVFileInformation::IsDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVFileInformation_IsDirectory_Methods[] = {
  {"IsDirectory", PyvtkPVFileInformation_IsDirectory_s1, METH_VARARGS | METH_STATIC,
   "i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVFileInformation_IsDirectory(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVFileInformation_IsDirectory_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVFileInformation_IsDirectory_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsDirectory");
  return nullptr;
}


static PyObject *
PyvtkPVFileInformation_IsGroup_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsGroup");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkPVFileInformation::IsGroup(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVFileInformation_IsGroup_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsGroup() :
      op->vtkPVFileInformation::IsGroup());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVFileInformation_IsGroup_Methods[] = {
  {"IsGroup", PyvtkPVFileInformation_IsGroup_s1, METH_VARARGS | METH_STATIC,
   "i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVFileInformation_IsGroup(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVFileInformation_IsGroup_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVFileInformation_IsGroup_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsGroup");
  return nullptr;
}


static PyObject *
PyvtkPVFileInformation_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkPVFileInformation::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetName() :
      op->vtkPVFileInformation::GetName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetFullPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFullPath() :
      op->vtkPVFileInformation::GetFullPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetType() :
      op->vtkPVFileInformation::GetType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetHidden(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHidden");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHidden() :
      op->vtkPVFileInformation::GetHidden());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetGroupFileSequences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGroupFileSequences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGroupFileSequences() :
      op->vtkPVFileInformation::GetGroupFileSequences());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_SetGroupFileSequences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGroupFileSequences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGroupFileSequences(temp0);
    }
    else
    {
      op->vtkPVFileInformation::SetGroupFileSequences(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GroupFileSequencesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GroupFileSequencesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GroupFileSequencesOn();
    }
    else
    {
      op->vtkPVFileInformation::GroupFileSequencesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GroupFileSequencesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GroupFileSequencesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GroupFileSequencesOff();
    }
    else
    {
      op->vtkPVFileInformation::GroupFileSequencesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetContents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetContents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCollection *tempr = (ap.IsBound() ?
      op->GetContents() :
      op->vtkPVFileInformation::GetContents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetExtension(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtension");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetExtension() :
      op->vtkPVFileInformation::GetExtension());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetSize() :
      op->vtkPVFileInformation::GetSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_FetchDirectoryListing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FetchDirectoryListing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformation *op = static_cast<vtkPVFileInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->FetchDirectoryListing();
    }
    else
    {
      op->vtkPVFileInformation::FetchDirectoryListing();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetParaViewSharedResourcesDirectory(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetParaViewSharedResourcesDirectory");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkPVFileInformation::GetParaViewSharedResourcesDirectory();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetParaViewExampleFilesDirectory(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetParaViewExampleFilesDirectory");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkPVFileInformation::GetParaViewExampleFilesDirectory();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetParaViewDocDirectory(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetParaViewDocDirectory");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkPVFileInformation::GetParaViewDocDirectory();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformation_GetParaViewTranslationsDirectory(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetParaViewTranslationsDirectory");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkPVFileInformation::GetParaViewTranslationsDirectory();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVFileInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVFileInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVFileInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVFileInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVFileInformation\nC++: static vtkPVFileInformation *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVFileInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVFileInformation\nC++: vtkPVFileInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVFileInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVFileInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CopyFromObject", PyvtkPVFileInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, object:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *object) override;\n\nTransfer information about a single object into this object. The\nobject must be a vtkPVFileInformationHelper.\n"},
  {"IsDirectory", PyvtkPVFileInformation_IsDirectory, METH_VARARGS,
   "IsDirectory(t:int) -> bool\nC++: static bool IsDirectory(int t)\nIsDirectory(self) -> bool\nC++: bool IsDirectory()\n\nHelper that returns whether a FileType is a directory (DIRECTORY,\nDRIVE, NETWORK_ROOT, etc...) Or in other words, a type that we\ncan do a DirectoryListing on.\n"},
  {"IsGroup", PyvtkPVFileInformation_IsGroup, METH_VARARGS,
   "IsGroup(type:int) -> bool\nC++: static bool IsGroup(int type)\nIsGroup(self) -> bool\nC++: bool IsGroup()\n\nHelper that returns true if file-type is a network related file\ni.e. either a FILE_GROUP or a DIRECTORY_GROUP.\n"},
  {"Initialize", PyvtkPVFileInformation_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\nInitializes the information object.\n"},
  {"GetName", PyvtkPVFileInformation_GetName, METH_VARARGS,
   "GetName(self) -> str\nC++: virtual char *GetName()\n\nGet the name of the file/directory whose information is\nrepresented by this object.\n"},
  {"GetFullPath", PyvtkPVFileInformation_GetFullPath, METH_VARARGS,
   "GetFullPath(self) -> str\nC++: virtual char *GetFullPath()\n\nGet the full path of the file/directory whose information is\nrepresented by this object.\n"},
  {"GetType", PyvtkPVFileInformation_GetType, METH_VARARGS,
   "GetType(self) -> int\nC++: virtual int GetType()\n\nGet the type of this file object.\n"},
  {"GetHidden", PyvtkPVFileInformation_GetHidden, METH_VARARGS,
   "GetHidden(self) -> bool\nC++: virtual bool GetHidden()\n\nGet the state of the hidden flag for the file/directory.\n"},
  {"GetGroupFileSequences", PyvtkPVFileInformation_GetGroupFileSequences, METH_VARARGS,
   "GetGroupFileSequences(self) -> bool\nC++: virtual bool GetGroupFileSequences()\n\nGroups file sequences when found. A file sequence could be\n[foo1.png, foo2.png, foo6.png]. When turned on, the series of\nfiles is grouped and our sequence example is named foo..png and\noriginal files are discarded from the listing. By default, this\nflag is set to true.\n"},
  {"SetGroupFileSequences", PyvtkPVFileInformation_SetGroupFileSequences, METH_VARARGS,
   "SetGroupFileSequences(self, _arg:bool) -> None\nC++: virtual void SetGroupFileSequences(bool _arg)\n\n"},
  {"GroupFileSequencesOn", PyvtkPVFileInformation_GroupFileSequencesOn, METH_VARARGS,
   "GroupFileSequencesOn(self) -> None\nC++: virtual void GroupFileSequencesOn()\n\n"},
  {"GroupFileSequencesOff", PyvtkPVFileInformation_GroupFileSequencesOff, METH_VARARGS,
   "GroupFileSequencesOff(self) -> None\nC++: virtual void GroupFileSequencesOff()\n\n"},
  {"GetContents", PyvtkPVFileInformation_GetContents, METH_VARARGS,
   "GetContents(self) -> vtkCollection\nC++: virtual vtkCollection *GetContents()\n\nGet the Contents for this directory. Returns a collection with\nvtkPVFileInformation objects for the contents of this directory\nif Type == DIRECTORY or the contents of this file group if Type\n== FILE_GROUP or the contents of this directory group if Type ==\nDIRECTORY_GROUP.\n"},
  {"GetExtension", PyvtkPVFileInformation_GetExtension, METH_VARARGS,
   "GetExtension(self) -> str\nC++: virtual char *GetExtension()\n\n"},
  {"GetSize", PyvtkPVFileInformation_GetSize, METH_VARARGS,
   "GetSize(self) -> int\nC++: virtual long long GetSize()\n\n"},
  {"FetchDirectoryListing", PyvtkPVFileInformation_FetchDirectoryListing, METH_VARARGS,
   "FetchDirectoryListing(self) -> None\nC++: void FetchDirectoryListing()\n\nFetch the directory listing to be able to use GetSize or\nGetContents with directories\n"},
  {"GetParaViewSharedResourcesDirectory", PyvtkPVFileInformation_GetParaViewSharedResourcesDirectory, METH_VARARGS,
   "GetParaViewSharedResourcesDirectory() -> str\nC++: static std::string GetParaViewSharedResourcesDirectory()\n\nReturns the path to the base data directory path holding various\nfiles packaged with ParaView.\n"},
  {"GetParaViewExampleFilesDirectory", PyvtkPVFileInformation_GetParaViewExampleFilesDirectory, METH_VARARGS,
   "GetParaViewExampleFilesDirectory() -> str\nC++: static std::string GetParaViewExampleFilesDirectory()\n\nReturn the path of the example data packaged with ParaView.\n"},
  {"GetParaViewDocDirectory", PyvtkPVFileInformation_GetParaViewDocDirectory, METH_VARARGS,
   "GetParaViewDocDirectory() -> str\nC++: static std::string GetParaViewDocDirectory()\n\nReturn the path of the documents packaged with ParaView.\n"},
  {"GetParaViewTranslationsDirectory", PyvtkPVFileInformation_GetParaViewTranslationsDirectory, METH_VARARGS,
   "GetParaViewTranslationsDirectory() -> str\nC++: static std::string GetParaViewTranslationsDirectory()\n\nReturn the path of the translations packaged with ParaView.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVFileInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("group_file_sequences"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetGroupFileSequences(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformation_SetGroupFileSequences(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformation_SetGroupFileSequences(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGroupFileSequences/SetGroupFileSequences\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extension"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetExtension(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetExtension\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetFullPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFullPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hidden"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetHidden(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHidden\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("contents"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetContents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetContents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("para_view_shared_resources_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetParaViewSharedResourcesDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetParaViewSharedResourcesDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("para_view_example_files_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetParaViewExampleFilesDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetParaViewExampleFilesDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("para_view_doc_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetParaViewDocDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetParaViewDocDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("para_view_translations_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformation_GetParaViewTranslationsDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetParaViewTranslationsDirectory\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVFileInformation_Doc =
  "vtkPVFileInformation - Information object that can be used to obtain\ninformation about a file/directory.\n\n"
  "Superclass: vtkPVInformation\n\n"
  "vtkPVFileInformation can be used to collect information about file or\n"
  "directory. vtkPVFileInformation can collect information from a\n"
  "vtkPVFileInformationHelper object alone.\n"
  "@sa\n"
  "vtkPVFileInformationHelper\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVFileInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVFileInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVFileInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVFileInformation_StaticNew()
{
  return vtkPVFileInformation::New();
}

PyObject *PyvtkPVFileInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVFileInformation_Type, PyvtkPVFileInformation_Methods,
    "vtkPVFileInformation",
 &PyvtkPVFileInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVInformation_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVFileInformation_FileTypes_Type);
  PyVTKEnum_Add(&PyvtkPVFileInformation_FileTypes_Type, "vtkPVFileInformation.FileTypes");

  o = (PyObject *)&PyvtkPVFileInformation_FileTypes_Type;
  if (PyDict_SetItemString(d, "FileTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 12; c++)
  {
    typedef vtkPVFileInformation::FileTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[12] = {
        { "INVALID", vtkPVFileInformation::INVALID },
        { "SINGLE_FILE", vtkPVFileInformation::SINGLE_FILE },
        { "SINGLE_FILE_LINK", vtkPVFileInformation::SINGLE_FILE_LINK },
        { "DIRECTORY", vtkPVFileInformation::DIRECTORY },
        { "DIRECTORY_LINK", vtkPVFileInformation::DIRECTORY_LINK },
        { "FILE_GROUP", vtkPVFileInformation::FILE_GROUP },
        { "DRIVE", vtkPVFileInformation::DRIVE },
        { "NETWORK_ROOT", vtkPVFileInformation::NETWORK_ROOT },
        { "NETWORK_DOMAIN", vtkPVFileInformation::NETWORK_DOMAIN },
        { "NETWORK_SERVER", vtkPVFileInformation::NETWORK_SERVER },
        { "NETWORK_SHARE", vtkPVFileInformation::NETWORK_SHARE },
        { "DIRECTORY_GROUP", vtkPVFileInformation::DIRECTORY_GROUP },
      };

    o = PyvtkPVFileInformation_FileTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVFileInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVFileInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVFileInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVFileInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

