// python wrapper for vtkPVDataMover
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVDataMover.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVDataMover(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVDataMover_ClassNew(); }


static PyObject *
PyvtkPVDataMover_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVDataMover::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVDataMover::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVDataMover *tempr = vtkPVDataMover::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataMover *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVDataMover::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVDataMover::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVDataMover::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SetProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetProducer(temp0);
    }
    else
    {
      op->vtkPVDataMover::SetProducer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetProducer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProducer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetProducer() :
      op->vtkPVDataMover::GetProducer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SetPortNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPortNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPortNumber(temp0);
    }
    else
    {
      op->vtkPVDataMover::SetPortNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetPortNumberMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortNumberMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPortNumberMinValue() :
      op->vtkPVDataMover::GetPortNumberMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetPortNumberMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortNumberMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPortNumberMaxValue() :
      op->vtkPVDataMover::GetPortNumberMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetPortNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPortNumber() :
      op->vtkPVDataMover::GetPortNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SetGatherOnAllRanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGatherOnAllRanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGatherOnAllRanks(temp0);
    }
    else
    {
      op->vtkPVDataMover::SetGatherOnAllRanks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetGatherOnAllRanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGatherOnAllRanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGatherOnAllRanks() :
      op->vtkPVDataMover::GetGatherOnAllRanks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SetSkipEmptyDataSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSkipEmptyDataSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSkipEmptyDataSets(temp0);
    }
    else
    {
      op->vtkPVDataMover::SetSkipEmptyDataSets(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetSkipEmptyDataSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSkipEmptyDataSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSkipEmptyDataSets() :
      op->vtkPVDataMover::GetSkipEmptyDataSets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SkipEmptyDataSetsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SkipEmptyDataSetsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SkipEmptyDataSetsOn();
    }
    else
    {
      op->vtkPVDataMover::SkipEmptyDataSetsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SkipEmptyDataSetsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SkipEmptyDataSetsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SkipEmptyDataSetsOff();
    }
    else
    {
      op->vtkPVDataMover::SkipEmptyDataSetsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_AddSourceRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddSourceRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddSourceRank(temp0);
    }
    else
    {
      op->vtkPVDataMover::AddSourceRank(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_ClearAllSourceRanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearAllSourceRanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearAllSourceRanks();
    }
    else
    {
      op->vtkPVDataMover::ClearAllSourceRanks();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_SetSourceRanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSourceRanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  std::vector<int> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    if (ap.IsBound())
    {
      op->SetSourceRanks(temp0);
    }
    else
    {
      op->vtkPVDataMover::SetSourceRanks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetSourceRanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSourceRanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<int> *tempr = (ap.IsBound() ?
      &op->GetSourceRanks() :
      &op->vtkPVDataMover::GetSourceRanks());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_Execute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Execute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Execute() :
      op->vtkPVDataMover::Execute());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetNumberOfDataSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDataSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfDataSets() :
      op->vtkPVDataMover::GetNumberOfDataSets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetDataSetRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataSetRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataSetRank(temp0) :
      op->vtkPVDataMover::GetDataSetRank(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetDataSetAtIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataSetAtIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetDataSetAtIndex(temp0) :
      op->vtkPVDataMover::GetDataSetAtIndex(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataMover_GetDataSetFromRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataSetFromRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataMover *op = static_cast<vtkPVDataMover *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetDataSetFromRank(temp0) :
      op->vtkPVDataMover::GetDataSetFromRank(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataMover_Methods[] = {
  {"IsTypeOf", PyvtkPVDataMover_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVDataMover_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVDataMover_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVDataMover\nC++: static vtkPVDataMover *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVDataMover_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVDataMover\nC++: vtkPVDataMover *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVDataMover_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVDataMover_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetProducer", PyvtkPVDataMover_SetProducer, METH_VARARGS,
   "SetProducer(self, producer:vtkAlgorithm) -> None\nC++: void SetProducer(vtkAlgorithm *producer)\n\nGet/Set the data-producer to fetch data from.\n"},
  {"GetProducer", PyvtkPVDataMover_GetProducer, METH_VARARGS,
   "GetProducer(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetProducer()\n\n"},
  {"SetPortNumber", PyvtkPVDataMover_SetPortNumber, METH_VARARGS,
   "SetPortNumber(self, _arg:int) -> None\nC++: virtual void SetPortNumber(int _arg)\n\nGet/Set the output-port number to use to fetch data. Defaults to\n`0`.\n"},
  {"GetPortNumberMinValue", PyvtkPVDataMover_GetPortNumberMinValue, METH_VARARGS,
   "GetPortNumberMinValue(self) -> int\nC++: virtual int GetPortNumberMinValue()\n\n"},
  {"GetPortNumberMaxValue", PyvtkPVDataMover_GetPortNumberMaxValue, METH_VARARGS,
   "GetPortNumberMaxValue(self) -> int\nC++: virtual int GetPortNumberMaxValue()\n\n"},
  {"GetPortNumber", PyvtkPVDataMover_GetPortNumber, METH_VARARGS,
   "GetPortNumber(self) -> int\nC++: virtual int GetPortNumber()\n\n"},
  {"SetGatherOnAllRanks", PyvtkPVDataMover_SetGatherOnAllRanks, METH_VARARGS,
   "SetGatherOnAllRanks(self, _arg:bool) -> None\nC++: virtual void SetGatherOnAllRanks(bool _arg)\n\nIn symmetric batch mode, set this to true to indicate that the\ndata must be cloned on all ranks. Otherwise, the data is only\ngenerated on the root node. Defaults to `false`.\n\nThis has no effect in non-symmetric MPI mode and is simply\nignored.\n"},
  {"GetGatherOnAllRanks", PyvtkPVDataMover_GetGatherOnAllRanks, METH_VARARGS,
   "GetGatherOnAllRanks(self) -> bool\nC++: virtual bool GetGatherOnAllRanks()\n\n"},
  {"SetSkipEmptyDataSets", PyvtkPVDataMover_SetSkipEmptyDataSets, METH_VARARGS,
   "SetSkipEmptyDataSets(self, _arg:bool) -> None\nC++: virtual void SetSkipEmptyDataSets(bool _arg)\n\nWhen set to true (default is false), skips moving empty datasets.\nA dataset is treated as empty if it has no cells, points, etc.\ni.e. `vtkDataObject::GetNumberOfElements` for all types returns\n0.\n"},
  {"GetSkipEmptyDataSets", PyvtkPVDataMover_GetSkipEmptyDataSets, METH_VARARGS,
   "GetSkipEmptyDataSets(self) -> bool\nC++: virtual bool GetSkipEmptyDataSets()\n\n"},
  {"SkipEmptyDataSetsOn", PyvtkPVDataMover_SkipEmptyDataSetsOn, METH_VARARGS,
   "SkipEmptyDataSetsOn(self) -> None\nC++: virtual void SkipEmptyDataSetsOn()\n\n"},
  {"SkipEmptyDataSetsOff", PyvtkPVDataMover_SkipEmptyDataSetsOff, METH_VARARGS,
   "SkipEmptyDataSetsOff(self) -> None\nC++: virtual void SkipEmptyDataSetsOff()\n\n"},
  {"AddSourceRank", PyvtkPVDataMover_AddSourceRank, METH_VARARGS,
   "AddSourceRank(self, rank:int) -> None\nC++: void AddSourceRank(int rank)\n\nAPI to select source ranks. This allows users to limit fetching\ndata from only certain ranks as listed. If none are provided,\ndefault, data from all ranks is fetched. Otherwise, data only\nfrom the ranks listed is fetched.\n"},
  {"ClearAllSourceRanks", PyvtkPVDataMover_ClearAllSourceRanks, METH_VARARGS,
   "ClearAllSourceRanks(self) -> None\nC++: void ClearAllSourceRanks()\n\n"},
  {"SetSourceRanks", PyvtkPVDataMover_SetSourceRanks, METH_VARARGS,
   "SetSourceRanks(self, ranks:(int, ...)) -> None\nC++: void SetSourceRanks(const std::vector<int> &ranks)\n\n"},
  {"GetSourceRanks", PyvtkPVDataMover_GetSourceRanks, METH_VARARGS,
   "GetSourceRanks(self) -> (int, ...)\nC++: const std::vector<int> &GetSourceRanks()\n\n"},
  {"Execute", PyvtkPVDataMover_Execute, METH_VARARGS,
   "Execute(self) -> bool\nC++: bool Execute()\n\nOnce the helper has been setup, use this method to fetch the\ndata.\n"},
  {"GetNumberOfDataSets", PyvtkPVDataMover_GetNumberOfDataSets, METH_VARARGS,
   "GetNumberOfDataSets(self) -> int\nC++: unsigned int GetNumberOfDataSets()\n\n\n"},
  {"GetDataSetRank", PyvtkPVDataMover_GetDataSetRank, METH_VARARGS,
   "GetDataSetRank(self, index:int) -> int\nC++: int GetDataSetRank(unsigned int index)\n\n"},
  {"GetDataSetAtIndex", PyvtkPVDataMover_GetDataSetAtIndex, METH_VARARGS,
   "GetDataSetAtIndex(self, index:int) -> vtkDataObject\nC++: vtkDataObject *GetDataSetAtIndex(unsigned int index)\n\n"},
  {"GetDataSetFromRank", PyvtkPVDataMover_GetDataSetFromRank, METH_VARARGS,
   "GetDataSetFromRank(self, rank:int) -> vtkDataObject\nC++: vtkDataObject *GetDataSetFromRank(int rank)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVDataMover_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("producer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataMover_GetProducer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataMover_SetProducer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataMover_SetProducer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProducer/SetProducer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("port_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataMover_GetPortNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataMover_SetPortNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataMover_SetPortNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPortNumber/SetPortNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gather_on_all_ranks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataMover_GetGatherOnAllRanks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataMover_SetGatherOnAllRanks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataMover_SetGatherOnAllRanks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGatherOnAllRanks/SetGatherOnAllRanks\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("skip_empty_data_sets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataMover_GetSkipEmptyDataSets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataMover_SetSkipEmptyDataSets(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataMover_SetSkipEmptyDataSets(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSkipEmptyDataSets/SetSkipEmptyDataSets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_ranks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataMover_GetSourceRanks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataMover_SetSourceRanks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataMover_SetSourceRanks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSourceRanks/SetSourceRanks\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_data_sets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataMover_GetNumberOfDataSets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfDataSets\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVDataMover_Doc =
  "vtkPVDataMover - helper to move data between ParaView processes.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVDataMover is used to transfer data between ParView processes\n"
  "without any transformations. This is primarily used by\n"
  "`simple.FetchData` to transfer data to the client.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVDataMover_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVDataMover", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVDataMover_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVDataMover_StaticNew()
{
  return vtkPVDataMover::New();
}

PyObject *PyvtkPVDataMover_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVDataMover_Type, PyvtkPVDataMover_Methods,
    "vtkPVDataMover",
 &PyvtkPVDataMover_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVDataMover_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVDataMover(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVDataMover_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVDataMover", o) != 0)
  {
    Py_DECREF(o);
  }

}

