#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBoundedPointSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkConnectedPointsFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkConvertToPointCloud_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDensifyPointCloudFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEllipsoidalGaussianKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEuclideanClusterExtraction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractEnclosedPoints_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractHierarchicalBins_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractPointCloudPiece_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractPoints_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractSurface_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFitImplicitFunction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGaussianKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGeneralizedKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHierarchicalBinningFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkInterpolationKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMaskPointsFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPCACurvatureEstimation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPCANormalEstimation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointCloudFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointDensityFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointInterpolator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointInterpolator2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointOccupancyFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointSmoothingFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPoissonDiskSampler_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProbabilisticVoronoiKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProjectPointsToPlane_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRadiusOutlierRemoval_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSPHCubicKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSPHInterpolator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSPHKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSPHQuarticKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSPHQuinticKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkShepardKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSignedDistance_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStatisticalOutlierRemoval_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnsignedDistance_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVoronoiKernel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVoxelGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWendlandQuinticKernel_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersPointsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBoundedPointSource_Init(csi);
  vtkConnectedPointsFilter_Init(csi);
  vtkConvertToPointCloud_Init(csi);
  vtkDensifyPointCloudFilter_Init(csi);
  vtkEllipsoidalGaussianKernel_Init(csi);
  vtkEuclideanClusterExtraction_Init(csi);
  vtkExtractEnclosedPoints_Init(csi);
  vtkExtractHierarchicalBins_Init(csi);
  vtkExtractPointCloudPiece_Init(csi);
  vtkExtractPoints_Init(csi);
  vtkExtractSurface_Init(csi);
  vtkFitImplicitFunction_Init(csi);
  vtkGaussianKernel_Init(csi);
  vtkGeneralizedKernel_Init(csi);
  vtkHierarchicalBinningFilter_Init(csi);
  vtkInterpolationKernel_Init(csi);
  vtkLinearKernel_Init(csi);
  vtkMaskPointsFilter_Init(csi);
  vtkPCACurvatureEstimation_Init(csi);
  vtkPCANormalEstimation_Init(csi);
  vtkPointCloudFilter_Init(csi);
  vtkPointDensityFilter_Init(csi);
  vtkPointInterpolator_Init(csi);
  vtkPointInterpolator2D_Init(csi);
  vtkPointOccupancyFilter_Init(csi);
  vtkPointSmoothingFilter_Init(csi);
  vtkPoissonDiskSampler_Init(csi);
  vtkProbabilisticVoronoiKernel_Init(csi);
  vtkProjectPointsToPlane_Init(csi);
  vtkRadiusOutlierRemoval_Init(csi);
  vtkSPHCubicKernel_Init(csi);
  vtkSPHInterpolator_Init(csi);
  vtkSPHKernel_Init(csi);
  vtkSPHQuarticKernel_Init(csi);
  vtkSPHQuinticKernel_Init(csi);
  vtkShepardKernel_Init(csi);
  vtkSignedDistance_Init(csi);
  vtkStatisticalOutlierRemoval_Init(csi);
  vtkUnsignedDistance_Init(csi);
  vtkVoronoiKernel_Init(csi);
  vtkVoxelGrid_Init(csi);
  vtkWendlandQuinticKernel_Init(csi);
}
