/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2011-2025 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <vte/vte.h>
#include <handy.h>
#include <gdk/gdk.h>
#include <locale.h>

#define TERMINAL_APPLICATION_MINIMUM_WIDTH 600
#define TERMINAL_APPLICATION_MINIMUM_HEIGHT 400
#define CONFIG_PROJECT_NAME "io.elementary.terminal"
#define CONFIG_VERSION "7.2.0"
#define TERMINAL_TERMINAL_WIDGET_ACTION_COPY "term.copy"
#define TERMINAL_TERMINAL_WIDGET_ACTION_COPY_OUTPUT "term.copy-output"
#define TERMINAL_TERMINAL_WIDGET_ACTION_PASTE "term.paste"
#define TERMINAL_TERMINAL_WIDGET_ACTION_RELOAD "term.reload"
#define TERMINAL_TERMINAL_WIDGET_ACTION_SCROLL_TO_COMMAND "term.scroll-to-command"
#define TERMINAL_TERMINAL_WIDGET_ACTION_SELECT_ALL "term.select-all"
#define TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_DEFAULT "term.zoom::default"
#define TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_IN "term.zoom::in"
#define TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_OUT "term.zoom::out"
#define CONFIG_GETTEXT_PACKAGE "io.elementary.terminal"
#define CONFIG_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TERMINAL_TYPE_APPLICATION (terminal_application_get_type ())
#define TERMINAL_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_APPLICATION, TerminalApplication))
#define TERMINAL_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_APPLICATION, TerminalApplicationClass))
#define TERMINAL_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_APPLICATION))
#define TERMINAL_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_APPLICATION))
#define TERMINAL_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_APPLICATION, TerminalApplicationClass))

typedef struct _TerminalApplication TerminalApplication;
typedef struct _TerminalApplicationClass TerminalApplicationClass;
typedef struct _TerminalApplicationPrivate TerminalApplicationPrivate;
enum  {
	TERMINAL_APPLICATION_0_PROPERTY,
	TERMINAL_APPLICATION_IS_TESTING_PROPERTY,
	TERMINAL_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* terminal_application_properties[TERMINAL_APPLICATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TERMINAL_TYPE_THEMES (terminal_themes_get_type ())
#define TERMINAL_THEMES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_THEMES, TerminalThemes))
#define TERMINAL_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_THEMES, TerminalThemesClass))
#define TERMINAL_IS_THEMES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_THEMES))
#define TERMINAL_IS_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_THEMES))
#define TERMINAL_THEMES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_THEMES, TerminalThemesClass))

typedef struct _TerminalThemes TerminalThemes;
typedef struct _TerminalThemesClass TerminalThemesClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TERMINAL_TYPE_DBUS (terminal_dbus_get_type ())
#define TERMINAL_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_DBUS, TerminalDBus))
#define TERMINAL_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_DBUS, TerminalDBusClass))
#define TERMINAL_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_DBUS))
#define TERMINAL_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_DBUS))
#define TERMINAL_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_DBUS, TerminalDBusClass))

typedef struct _TerminalDBus TerminalDBus;
typedef struct _TerminalDBusClass TerminalDBusClass;
#define _terminal_dbus_unref0(var) ((var == NULL) ? NULL : (var = (terminal_dbus_unref (var), NULL)))

#define TERMINAL_TYPE_TERMINAL_WIDGET (terminal_terminal_widget_get_type ())
#define TERMINAL_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget))
#define TERMINAL_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))
#define TERMINAL_IS_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_IS_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_TERMINAL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))

typedef struct _TerminalTerminalWidget TerminalTerminalWidget;
typedef struct _TerminalTerminalWidgetClass TerminalTerminalWidgetClass;
typedef struct _Block6Data Block6Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TERMINAL_TYPE_MAIN_WINDOW (terminal_main_window_get_type ())
#define TERMINAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow))
#define TERMINAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindowClass))
#define TERMINAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_MAIN_WINDOW))
#define TERMINAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_MAIN_WINDOW))
#define TERMINAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindowClass))

typedef struct _TerminalMainWindow TerminalMainWindow;
typedef struct _TerminalMainWindowClass TerminalMainWindowClass;
typedef struct _TerminalTerminalWidgetPrivate TerminalTerminalWidgetPrivate;
typedef struct _Block7Data Block7Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _terminal_themes_unref0(var) ((var == NULL) ? NULL : (var = (terminal_themes_unref (var), NULL)))

#define TERMINAL_TYPE_TERMINAL_VIEW (terminal_terminal_view_get_type ())
#define TERMINAL_TERMINAL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalView))
#define TERMINAL_TERMINAL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalViewClass))
#define TERMINAL_IS_TERMINAL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_TERMINAL_VIEW))
#define TERMINAL_IS_TERMINAL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_TERMINAL_VIEW))
#define TERMINAL_TERMINAL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_TERMINAL_VIEW, TerminalTerminalViewClass))

typedef struct _TerminalTerminalView TerminalTerminalView;
typedef struct _TerminalTerminalViewClass TerminalTerminalViewClass;

struct _TerminalApplication {
	GtkApplication parent_instance;
	TerminalApplicationPrivate * priv;
};

struct _TerminalApplicationClass {
	GtkApplicationClass parent_class;
};

struct _TerminalApplicationPrivate {
	gchar* commandline;
	guint dbus_id;
	gboolean _is_testing;
};

struct _Block6Data {
	int _ref_count_;
	TerminalApplication* self;
	TerminalTerminalWidget* terminal;
	gchar* id;
};

struct _TerminalTerminalWidget {
	VteTerminal parent_instance;
	TerminalTerminalWidgetPrivate * priv;
	gchar* terminal_id;
	HdyTabPage* tab;
	gchar* link_uri;
	gint default_size;
	gboolean last_key_was_return;
};

struct _TerminalTerminalWidgetClass {
	VteTerminalClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gulong tab_change_handler;
	gulong focus_in_handler;
};

static gint TerminalApplication_private_offset;
static gpointer terminal_application_parent_class = NULL;
VALA_EXTERN GSettings* terminal_application_saved_state;
GSettings* terminal_application_saved_state = NULL;
VALA_EXTERN GSettings* terminal_application_settings;
GSettings* terminal_application_settings = NULL;
VALA_EXTERN GSettings* terminal_application_settings_sys;
GSettings* terminal_application_settings_sys = NULL;
static TerminalThemes* terminal_application_themes;
static TerminalThemes* terminal_application_themes = NULL;

VALA_EXTERN GType terminal_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalApplication, g_object_unref)
VALA_EXTERN gpointer terminal_themes_ref (gpointer instance);
VALA_EXTERN void terminal_themes_unref (gpointer instance);
VALA_EXTERN GParamSpec* terminal_param_spec_themes (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void terminal_value_set_themes (GValue* value,
                                gpointer v_object);
VALA_EXTERN void terminal_value_take_themes (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer terminal_value_get_themes (const GValue* value);
VALA_EXTERN GType terminal_themes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalThemes, terminal_themes_unref)
VALA_EXTERN TerminalApplication* terminal_application_new (void);
VALA_EXTERN TerminalApplication* terminal_application_construct (GType object_type);
static gboolean terminal_application_real_local_command_line (GApplication* base,
                                                       gchar*** args,
                                                       gint* exit_status);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gint terminal_application_real_handle_local_options (GApplication* base,
                                                     GVariantDict* options);
VALA_EXTERN gchar* terminal_utils_sanitize_path (const gchar* _path,
                                     const gchar* shell_location,
                                     gboolean add_file_scheme);
static gboolean terminal_application_real_dbus_register (GApplication* base,
                                                  GDBusConnection* connection,
                                                  const gchar* object_path,
                                                  GError** error);
VALA_EXTERN gpointer terminal_dbus_ref (gpointer instance);
VALA_EXTERN void terminal_dbus_unref (gpointer instance);
VALA_EXTERN GParamSpec* terminal_param_spec_dbus (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void terminal_value_set_dbus (GValue* value,
                              gpointer v_object);
VALA_EXTERN void terminal_value_take_dbus (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer terminal_value_get_dbus (const GValue* value);
VALA_EXTERN GType terminal_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalDBus, terminal_dbus_unref)
VALA_EXTERN guint terminal_dbus_register_object (void* object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error);
VALA_EXTERN TerminalDBus* terminal_dbus_new (void);
VALA_EXTERN TerminalDBus* terminal_dbus_construct (GType object_type);
static void __lambda5_ (TerminalApplication* self,
                 const gchar* id,
                 const gchar* process,
                 gint exit_status);
VALA_EXTERN GType terminal_terminal_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalTerminalWidget, g_object_unref)
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN GType terminal_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalMainWindow, g_object_unref)
VALA_EXTERN TerminalTerminalWidget* terminal_main_window_get_terminal (TerminalMainWindow* self,
                                                           const gchar* id);
VALA_EXTERN gboolean terminal_terminal_widget_is_init_complete (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_set_init_complete (TerminalTerminalWidget* self);
VALA_EXTERN TerminalMainWindow* terminal_terminal_widget_get_main_window (TerminalTerminalWidget* self);
VALA_EXTERN TerminalTerminalWidget* terminal_main_window_get_current_terminal (TerminalMainWindow* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda46_ (Block7Data* _data7_);
static void terminal_application_withdraw_notification_for_terminal (TerminalApplication* self,
                                                              TerminalTerminalWidget* terminal,
                                                              const gchar* id,
                                                              gulong tab_change_handler,
                                                              gulong focus_in_handler);
static void ____lambda46__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda47_ (Block7Data* _data7_);
static void ____lambda47__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda5__terminal_dbus_finished_process (TerminalDBus* _sender,
                                                 const gchar* terminal_id,
                                                 const gchar* process,
                                                 gint exit_status,
                                                 gpointer self);
static void terminal_application_real_startup (GApplication* base);
VALA_EXTERN TerminalThemes* terminal_themes_new (void);
VALA_EXTERN TerminalThemes* terminal_themes_construct (GType object_type);
static void __lambda48_ (TerminalApplication* self);
VALA_EXTERN const gchar* terminal_terminal_widget_get_current_working_directory (TerminalTerminalWidget* self);
VALA_EXTERN TerminalMainWindow* terminal_main_window_new (TerminalApplication* app,
                                              gboolean recreate_tabs);
VALA_EXTERN TerminalMainWindow* terminal_main_window_construct (GType object_type,
                                                    TerminalApplication* app,
                                                    gboolean recreate_tabs);
VALA_EXTERN void terminal_main_window_add_tab_with_working_directory (TerminalMainWindow* self,
                                                          const gchar* directory,
                                                          const gchar* command,
                                                          gboolean create_new_tab);
static void ___lambda48__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
VALA_EXTERN void terminal_application_close (TerminalApplication* self);
static void _terminal_application_close_g_simple_action_activate (GSimpleAction* _sender,
                                                           GVariant* parameter,
                                                           gpointer self);
static gint terminal_application_real_command_line (GApplication* base,
                                             GApplicationCommandLine* command_line);
VALA_EXTERN GType terminal_terminal_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalTerminalView, g_object_unref)
VALA_EXTERN TerminalTerminalView* terminal_main_window_get_notebook (TerminalMainWindow* self);
VALA_EXTERN gint terminal_terminal_view_get_n_pages (TerminalTerminalView* self);
static void terminal_application_real_dbus_unregister (GApplication* base,
                                                GDBusConnection* connection,
                                                const gchar* path);
VALA_EXTERN gboolean terminal_application_get_is_testing (TerminalApplication* self);
VALA_EXTERN void terminal_application_set_is_testing (TerminalApplication* self,
                                          gboolean value);
static GObject * terminal_application_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _terminal_application___lambda49_ (TerminalApplication* self,
                                        GVariant* v);
VALA_EXTERN void terminal_main_window_set_active_terminal_tab (TerminalMainWindow* self,
                                                   HdyTabPage* tab);
static void __terminal_application___lambda49__g_simple_action_activate (GSimpleAction* _sender,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void terminal_application_finalize (GObject * obj);
static GType terminal_application_get_type_once (void);
static void _vala_terminal_application_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_terminal_application_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_COPY[2];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_COPY_OUTPUT[2];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_PASTE[2];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_RELOAD[3];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_SCROLL_TO_COMMAND[2];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_SELECT_ALL[2];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_DEFAULT[3];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_IN[4];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_OUT[3];

static inline gpointer
terminal_application_get_instance_private (TerminalApplication* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalApplication_private_offset);
}

TerminalApplication*
terminal_application_construct (GType object_type)
{
	TerminalApplication * self = NULL;
	self = (TerminalApplication*) g_object_new (object_type, "application-id", "io.elementary.terminal", "flags", G_APPLICATION_HANDLES_COMMAND_LINE | G_APPLICATION_CAN_OVERRIDE_APP_ID, NULL);
	return self;
}

TerminalApplication*
terminal_application_new (void)
{
	return terminal_application_construct (TERMINAL_TYPE_APPLICATION);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
terminal_application_real_local_command_line (GApplication* base,
                                              gchar*** args,
                                              gint* exit_status)
{
	TerminalApplication * self;
	gint _vala_exit_status = 0;
	gboolean show_help = FALSE;
	gboolean _tmp49_ = FALSE;
	gint _tmp50_ = 0;
	gboolean _tmp51_;
	gboolean result;
	self = (TerminalApplication*) base;
	show_help = FALSE;
	{
		guint i = 0U;
		i = (guint) 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_;
				const gchar* _tmp14_;
				const gchar* _tmp48_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = (*args)[i];
				if (!(_tmp2_ != NULL)) {
					break;
				}
				_tmp3_ = (*args)[i];
				if (string_get (_tmp3_, (glong) 0) != '-') {
					continue;
				}
				_tmp5_ = (*args)[i];
				if (g_strcmp0 (_tmp5_, "--version") == 0) {
					_tmp4_ = TRUE;
				} else {
					gboolean _tmp6_ = FALSE;
					const gchar* _tmp7_;
					_tmp7_ = (*args)[i];
					if (string_get (_tmp7_, (glong) 1) != '-') {
						const gchar* _tmp8_;
						_tmp8_ = (*args)[i];
						_tmp6_ = string_contains (_tmp8_, "v");
					} else {
						_tmp6_ = FALSE;
					}
					_tmp4_ = _tmp6_;
				}
				if (_tmp4_) {
					g_print ("%s %s\n", CONFIG_PROJECT_NAME, CONFIG_VERSION);
					_vala_exit_status = 0;
					result = TRUE;
					if (exit_status) {
						*exit_status = _vala_exit_status;
					}
					return result;
				} else {
					gboolean _tmp9_ = FALSE;
					const gchar* _tmp10_;
					_tmp10_ = (*args)[i];
					if (g_strcmp0 (_tmp10_, "--help") == 0) {
						_tmp9_ = TRUE;
					} else {
						gboolean _tmp11_ = FALSE;
						const gchar* _tmp12_;
						_tmp12_ = (*args)[i];
						if (string_get (_tmp12_, (glong) 1) != '-') {
							const gchar* _tmp13_;
							_tmp13_ = (*args)[i];
							_tmp11_ = string_contains (_tmp13_, "h");
						} else {
							_tmp11_ = FALSE;
						}
						_tmp9_ = _tmp11_;
					}
					if (_tmp9_) {
						show_help = TRUE;
						break;
					}
				}
				_tmp14_ = (*args)[i];
				if (string_get (_tmp14_, (glong) 1) == '-') {
					gboolean _tmp15_ = FALSE;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gboolean _tmp22_;
					_tmp16_ = (*args)[i];
					_tmp17_ = (*args)[i];
					_tmp18_ = strlen (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = string_slice (_tmp17_, (glong) 2, (glong) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strcmp0 (_tmp21_, "commandline") == 0;
					_g_free0 (_tmp21_);
					if (_tmp22_) {
						_tmp15_ = TRUE;
					} else {
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp23_ = (*args)[i];
						_tmp24_ = (*args)[i];
						_tmp25_ = strlen (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = string_slice (_tmp24_, (glong) 2, (glong) _tmp26_);
						_tmp28_ = _tmp27_;
						_tmp15_ = g_str_has_prefix (_tmp28_, "commandline");
						_g_free0 (_tmp28_);
					}
					if (_tmp15_) {
						const gchar* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						gchar* _tmp34_;
						_tmp29_ = (*args)[i];
						_tmp30_ = strlen (_tmp29_);
						_tmp31_ = _tmp30_;
						if (_tmp31_ > 14) {
							const gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp32_ = (*args)[i];
							_tmp33_ = string_substring (_tmp32_, (glong) 14, (glong) -1);
							_g_free0 (self->priv->commandline);
							self->priv->commandline = _tmp33_;
						}
						_tmp34_ = g_strdup ("--");
						_g_free0 ((*args)[i]);
						(*args)[i] = _tmp34_;
					}
				} else {
					const gchar* _tmp35_;
					_tmp35_ = (*args)[i];
					if (string_contains (_tmp35_, "x")) {
						gboolean _tmp36_ = FALSE;
						const gchar* _tmp37_;
						const gchar* _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						gchar* _tmp47_;
						_tmp37_ = (*args)[i];
						if (string_contains (_tmp37_, "w")) {
							_tmp36_ = TRUE;
						} else {
							const gchar* _tmp38_;
							_tmp38_ = (*args)[i];
							_tmp36_ = string_contains (_tmp38_, "e");
						}
						if (_tmp36_) {
							continue;
						}
						_tmp39_ = (*args)[i];
						_tmp40_ = strlen (_tmp39_);
						_tmp41_ = _tmp40_;
						if (_tmp41_ != 2) {
							const gchar* _tmp42_;
							gchar* _tmp43_;
							guint _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							_tmp42_ = (*args)[i];
							_tmp43_ = string_replace (_tmp42_, "x", "");
							_g_free0 ((*args)[i]);
							(*args)[i] = _tmp43_;
							i = i + 1;
							_tmp44_ = i;
							_tmp45_ = (*args)[_tmp44_];
							_tmp46_ = g_strdup (_tmp45_);
							_g_free0 (self->priv->commandline);
							self->priv->commandline = _tmp46_;
						}
						_tmp47_ = g_strdup ("--");
						_g_free0 ((*args)[i]);
						(*args)[i] = _tmp47_;
					}
				}
				_tmp48_ = (*args)[i];
				if (g_strcmp0 (_tmp48_, "--") == 0) {
					break;
				}
			}
		}
	}
	if (_vala_string_array_contains (*args, _vala_array_length (*args), "--")) {
		_tmp49_ = TRUE;
	} else {
		_tmp49_ = show_help;
	}
	if (_tmp49_) {
		g_application_add_main_option ((GApplication*) self, G_OPTION_REMAINING, '\0', 0, G_OPTION_ARG_FILENAME_ARRAY, "", _ ("[-- COMMAND…]"));
	}
	_tmp51_ = G_APPLICATION_CLASS (terminal_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), args, &_tmp50_);
	_vala_exit_status = _tmp50_;
	result = _tmp51_;
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gint
terminal_application_real_handle_local_options (GApplication* base,
                                                GVariantDict* options)
{
	TerminalApplication * self;
	const gchar* working_directory = NULL;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar** _tmp8_ = NULL;
	gboolean _tmp9_;
	const gchar* _tmp20_;
	gint result;
	self = (TerminalApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp1_ = g_variant_dict_lookup (options, "working-directory", "^&ay", &_tmp0_, NULL);
	working_directory = _tmp0_;
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = working_directory;
		if (g_strcmp0 (_tmp2_, "\0") != 0) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = working_directory;
			_tmp4_ = g_get_current_dir ();
			_tmp5_ = _tmp4_;
			_tmp6_ = terminal_utils_sanitize_path (_tmp3_, _tmp5_, FALSE);
			_tmp7_ = _tmp6_;
			g_chdir (_tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			g_variant_dict_insert (options, "new-tab", "b", TRUE, NULL);
		}
		g_variant_dict_remove (options, "working-directory");
	}
	_tmp9_ = g_variant_dict_lookup (options, G_OPTION_REMAINING, "^a&ay", &_tmp8_, NULL);
	args = _tmp8_;
	args_length1 = -1;
	_args_size_ = args_length1;
	if (_tmp9_) {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->commandline;
		if (g_strcmp0 (_tmp10_, "\0") != 0) {
			const gchar* _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = self->priv->commandline;
			_tmp12_ = args;
			_tmp12__length1 = args_length1;
			_tmp13_ = _vala_g_strjoinv (" ", _tmp12_, (gint) _tmp12__length1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf (" %s", _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp11_, _tmp16_, NULL);
			_g_free0 (self->priv->commandline);
			self->priv->commandline = _tmp17_;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
		} else {
			gchar** _tmp18_;
			gint _tmp18__length1;
			gchar* _tmp19_;
			_tmp18_ = args;
			_tmp18__length1 = args_length1;
			_tmp19_ = _vala_g_strjoinv (" ", _tmp18_, (gint) _tmp18__length1);
			_g_free0 (self->priv->commandline);
			self->priv->commandline = _tmp19_;
		}
	}
	_tmp20_ = self->priv->commandline;
	if (g_strcmp0 (_tmp20_, "\0") != 0) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = self->priv->commandline;
		_tmp22_ = g_strescape (_tmp21_, NULL);
		_tmp23_ = _tmp22_;
		g_variant_dict_insert (options, "commandline", "^&ay", _tmp23_, NULL);
		_g_free0 (_tmp23_);
	}
	result = -1;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		TerminalApplication* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->terminal);
		_g_free0 (_data6_->id);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		TerminalApplication* self;
		self = _data7_->_data6_->self;
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda46_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	TerminalApplication* self;
	TerminalTerminalWidget* _tmp0_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = _data6_->terminal;
	terminal_application_withdraw_notification_for_terminal (self, _tmp0_, _data6_->id, _data7_->tab_change_handler, _data7_->focus_in_handler);
}

static void
____lambda46__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda46_ (self);
}

static void
___lambda47_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	TerminalApplication* self;
	TerminalTerminalWidget* _tmp0_;
	TerminalMainWindow* _tmp1_;
	TerminalMainWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = _data6_->terminal;
	_tmp1_ = terminal_terminal_widget_get_main_window (_tmp0_);
	_tmp2_ = _tmp1_;
	g_object_get ((GtkWindow*) _tmp2_, "is-active", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		TerminalTerminalWidget* _tmp5_;
		_tmp5_ = _data6_->terminal;
		terminal_application_withdraw_notification_for_terminal (self, _tmp5_, _data6_->id, _data7_->tab_change_handler, _data7_->focus_in_handler);
	}
}

static void
____lambda47__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda47_ (self);
}

static void
__lambda5_ (TerminalApplication* self,
            const gchar* id,
            const gchar* process,
            gint exit_status)
{
	Block6Data* _data6_;
	gchar* _tmp0_;
	GList* _tmp1_;
	TerminalTerminalWidget* _tmp7_;
	gchar* process_string = NULL;
	gchar* _tmp10_;
	GThemedIcon* process_icon = NULL;
	GThemedIcon* _tmp11_;
	TerminalTerminalWidget* _tmp14_;
	TerminalTerminalWidget* _tmp15_;
	TerminalMainWindow* _tmp16_;
	TerminalMainWindow* _tmp17_;
	TerminalTerminalWidget* _tmp18_;
	TerminalTerminalWidget* _tmp19_;
	GtkWindow* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	g_return_if_fail (id != NULL);
	g_return_if_fail (process != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data6_->id);
	_data6_->id = _tmp0_;
	_data6_->terminal = NULL;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = (GList*) _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			TerminalMainWindow* _tmp2_;
			TerminalMainWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((TerminalMainWindow*) window_it->data);
			window = _tmp2_;
			{
				TerminalTerminalWidget* _tmp3_;
				TerminalMainWindow* _tmp4_;
				TerminalTerminalWidget* _tmp5_;
				TerminalTerminalWidget* _tmp6_;
				_tmp3_ = _data6_->terminal;
				if (_tmp3_ != NULL) {
					_g_object_unref0 (window);
					break;
				}
				_tmp4_ = window;
				_tmp5_ = terminal_main_window_get_terminal (_tmp4_, _data6_->id);
				_tmp6_ = _g_object_ref0 (_tmp5_);
				_g_object_unref0 (_data6_->terminal);
				_data6_->terminal = _tmp6_;
				_g_object_unref0 (window);
			}
		}
	}
	_tmp7_ = _data6_->terminal;
	if (_tmp7_ == NULL) {
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	} else {
		TerminalTerminalWidget* _tmp8_;
		_tmp8_ = _data6_->terminal;
		if (!terminal_terminal_widget_is_init_complete (_tmp8_)) {
			TerminalTerminalWidget* _tmp9_;
			_tmp9_ = _data6_->terminal;
			terminal_terminal_widget_set_init_complete (_tmp9_);
			block6_data_unref (_data6_);
			_data6_ = NULL;
			return;
		}
	}
	_tmp10_ = g_strdup (_ ("Process completed"));
	process_string = _tmp10_;
	_tmp11_ = (GThemedIcon*) g_themed_icon_new ("process-completed-symbolic");
	process_icon = _tmp11_;
	if (exit_status != 0) {
		gchar* _tmp12_;
		GThemedIcon* _tmp13_;
		_tmp12_ = g_strdup (_ ("Process exited with errors"));
		_g_free0 (process_string);
		process_string = _tmp12_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("process-error-symbolic");
		_g_object_unref0 (process_icon);
		process_icon = _tmp13_;
	}
	_tmp14_ = _data6_->terminal;
	_tmp15_ = _data6_->terminal;
	_tmp16_ = terminal_terminal_widget_get_main_window (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = terminal_main_window_get_current_terminal (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp14_ != _tmp19_) {
		TerminalTerminalWidget* _tmp20_;
		HdyTabPage* _tmp21_;
		GThemedIcon* _tmp22_;
		_tmp20_ = _data6_->terminal;
		_tmp21_ = _tmp20_->tab;
		_tmp22_ = process_icon;
		hdy_tab_page_set_icon (_tmp21_, (GIcon*) _tmp22_);
	}
	_tmp23_ = gtk_application_get_active_window ((GtkApplication*) self);
	g_object_get (_tmp23_, "is-active", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	if (!_tmp25_) {
		Block7Data* _data7_;
		GNotification* notification = NULL;
		const gchar* _tmp26_;
		GNotification* _tmp27_;
		GNotification* _tmp28_;
		GNotification* _tmp29_;
		GThemedIcon* _tmp30_;
		GNotification* _tmp31_;
		GVariant* _tmp32_;
		GVariant* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		GNotification* _tmp36_;
		TerminalTerminalWidget* _tmp37_;
		TerminalMainWindow* _tmp38_;
		TerminalMainWindow* _tmp39_;
		gulong _tmp40_;
		TerminalTerminalWidget* _tmp41_;
		TerminalMainWindow* _tmp42_;
		TerminalMainWindow* _tmp43_;
		gulong _tmp44_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data6_ = block6_data_ref (_data6_);
		_tmp26_ = process_string;
		_tmp27_ = g_notification_new (_tmp26_);
		notification = _tmp27_;
		_tmp28_ = notification;
		g_notification_set_body (_tmp28_, process);
		_tmp29_ = notification;
		_tmp30_ = process_icon;
		g_notification_set_icon (_tmp29_, (GIcon*) _tmp30_);
		_tmp31_ = notification;
		_tmp32_ = g_variant_new_string (_data6_->id);
		g_variant_ref_sink (_tmp32_);
		_tmp33_ = _tmp32_;
		g_notification_set_default_action_and_target_value (_tmp31_, "app.process-finished", _tmp33_);
		_g_variant_unref0 (_tmp33_);
		_tmp34_ = g_strdup_printf ("process-finished-%s", _data6_->id);
		_tmp35_ = _tmp34_;
		_tmp36_ = notification;
		g_application_send_notification ((GApplication*) self, _tmp35_, _tmp36_);
		_g_free0 (_tmp35_);
		_data7_->tab_change_handler = (gulong) 0;
		_data7_->focus_in_handler = (gulong) 0;
		_tmp37_ = _data6_->terminal;
		_tmp38_ = terminal_terminal_widget_get_main_window (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_signal_connect_data ((GObject*) _tmp39_, "notify::current-terminal", (GCallback) ____lambda46__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_data7_->tab_change_handler = _tmp40_;
		_tmp41_ = _data6_->terminal;
		_tmp42_ = terminal_terminal_widget_get_main_window (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_signal_connect_data ((GObject*) _tmp43_, "notify::is-active", (GCallback) ____lambda47__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_data7_->focus_in_handler = _tmp44_;
		_g_object_unref0 (notification);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_g_object_unref0 (process_icon);
	_g_free0 (process_string);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
___lambda5__terminal_dbus_finished_process (TerminalDBus* _sender,
                                            const gchar* terminal_id,
                                            const gchar* process,
                                            gint exit_status,
                                            gpointer self)
{
	__lambda5_ ((TerminalApplication*) self, terminal_id, process, exit_status);
}

static gboolean
terminal_application_real_dbus_register (GApplication* base,
                                         GDBusConnection* connection,
                                         const gchar* object_path,
                                         GError** error)
{
	TerminalApplication * self;
	TerminalDBus* dbus = NULL;
	TerminalDBus* _tmp1_;
	guint _tmp2_ = 0U;
	TerminalDBus* _tmp3_;
	guint _tmp4_;
	TerminalDBus* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (TerminalApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	G_APPLICATION_CLASS (terminal_application_parent_class)->dbus_register ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp0_;
	}
	_tmp1_ = terminal_dbus_new ();
	dbus = _tmp1_;
	_tmp3_ = dbus;
	_tmp4_ = terminal_dbus_register_object (_tmp3_, connection, object_path, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_terminal_dbus_unref0 (dbus);
		return _tmp5_;
	}
	self->priv->dbus_id = _tmp2_;
	_tmp6_ = dbus;
	g_signal_connect_object (_tmp6_, "finished-process", (GCallback) ___lambda5__terminal_dbus_finished_process, self, 0);
	result = TRUE;
	_terminal_dbus_unref0 (dbus);
	return result;
}

static void
terminal_application_withdraw_notification_for_terminal (TerminalApplication* self,
                                                         TerminalTerminalWidget* terminal,
                                                         const gchar* id,
                                                         gulong tab_change_handler,
                                                         gulong focus_in_handler)
{
	TerminalMainWindow* _tmp0_;
	TerminalMainWindow* _tmp1_;
	TerminalTerminalWidget* _tmp2_;
	TerminalTerminalWidget* _tmp3_;
	HdyTabPage* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	TerminalMainWindow* _tmp7_;
	TerminalMainWindow* _tmp8_;
	TerminalMainWindow* _tmp9_;
	TerminalMainWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = terminal_terminal_widget_get_main_window (terminal);
	_tmp1_ = _tmp0_;
	_tmp2_ = terminal_main_window_get_current_terminal (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != terminal) {
		return;
	}
	_tmp4_ = terminal->tab;
	hdy_tab_page_set_icon (_tmp4_, NULL);
	_tmp5_ = g_strdup_printf ("process-finished-%s", id);
	_tmp6_ = _tmp5_;
	g_application_withdraw_notification ((GApplication*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = terminal_terminal_widget_get_main_window (terminal);
	_tmp8_ = _tmp7_;
	g_signal_handler_disconnect ((GObject*) _tmp8_, tab_change_handler);
	_tmp9_ = terminal_terminal_widget_get_main_window (terminal);
	_tmp10_ = _tmp9_;
	g_signal_handler_disconnect ((GObject*) _tmp10_, focus_in_handler);
}

static void
__lambda48_ (TerminalApplication* self)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	TerminalMainWindow* new_window = NULL;
	GtkWindow* _tmp11_;
	GtkWindow* _tmp12_;
	TerminalMainWindow* _tmp13_;
	GtkWindow* _tmp14_;
	GtkWindow* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GtkWindow* _tmp18_;
	GtkWindow* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	const gchar* _tmp22_;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	dir = _tmp1_;
	_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkWindow* _tmp4_;
		GtkWindow* _tmp5_;
		TerminalTerminalWidget* _tmp6_;
		TerminalTerminalWidget* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = terminal_main_window_get_current_terminal (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow));
		_tmp7_ = _tmp6_;
		_tmp8_ = terminal_terminal_widget_get_current_working_directory (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (dir);
		dir = _tmp10_;
	}
	_tmp11_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = terminal_main_window_new (self, _tmp12_ == NULL);
	g_object_ref_sink (_tmp13_);
	new_window = _tmp13_;
	gtk_window_present ((GtkWindow*) new_window);
	_tmp14_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp15_ = _tmp14_;
	g_object_get ((GtkWidget*) _tmp15_, "width-request", &_tmp16_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp19_ = _tmp18_;
	g_object_get ((GtkWidget*) _tmp19_, "height-request", &_tmp20_, NULL);
	_tmp21_ = _tmp20_;
	gtk_widget_set_size_request ((GtkWidget*) new_window, _tmp17_, _tmp21_);
	_tmp22_ = dir;
	terminal_main_window_add_tab_with_working_directory (new_window, _tmp22_, "", FALSE);
	_g_object_unref0 (new_window);
	_g_free0 (dir);
}

static void
___lambda48__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda48_ ((TerminalApplication*) self);
}

static void
_terminal_application_close_g_simple_action_activate (GSimpleAction* _sender,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	terminal_application_close ((TerminalApplication*) self);
}

static void
terminal_application_real_startup (GApplication* base)
{
	TerminalApplication * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	TerminalThemes* _tmp3_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp4_;
	GdkScreen* _tmp5_;
	GSimpleAction* new_window_action = NULL;
	GSimpleAction* _tmp6_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	self = (TerminalApplication*) base;
	G_APPLICATION_CLASS (terminal_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = g_settings_new ("io.elementary.terminal.saved-state");
	_g_object_unref0 (terminal_application_saved_state);
	terminal_application_saved_state = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.terminal.settings");
	_g_object_unref0 (terminal_application_settings);
	terminal_application_settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (terminal_application_settings_sys);
	terminal_application_settings_sys = _tmp2_;
	_tmp3_ = terminal_themes_new ();
	_terminal_themes_unref0 (terminal_application_themes);
	terminal_application_themes = _tmp3_;
	_tmp4_ = gtk_css_provider_new ();
	provider = _tmp4_;
	gtk_css_provider_load_from_resource (provider, "/io/elementary/terminal/Application.css");
	_tmp5_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp5_, (GtkStyleProvider*) provider, (guint) (GTK_STYLE_PROVIDER_PRIORITY_APPLICATION + 1));
	_tmp6_ = g_simple_action_new ("new-window", NULL);
	new_window_action = _tmp6_;
	g_signal_connect_object (new_window_action, "activate", (GCallback) ___lambda48__g_simple_action_activate, self, 0);
	_tmp7_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp7_;
	g_signal_connect_object (quit_action, "activate", (GCallback) _terminal_application_close_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) new_window_action);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_tmp8_ = g_strdup ("<Control><Shift>N");
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-window", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = g_strdup ("<Control><Shift>Q");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_COPY, TERMINAL_TERMINAL_WIDGET_ACCELS_COPY);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_COPY_OUTPUT, TERMINAL_TERMINAL_WIDGET_ACCELS_COPY_OUTPUT);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_PASTE, TERMINAL_TERMINAL_WIDGET_ACCELS_PASTE);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_RELOAD, TERMINAL_TERMINAL_WIDGET_ACCELS_RELOAD);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_SCROLL_TO_COMMAND, TERMINAL_TERMINAL_WIDGET_ACCELS_SCROLL_TO_COMMAND);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_SELECT_ALL, TERMINAL_TERMINAL_WIDGET_ACCELS_SELECT_ALL);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_DEFAULT, TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_DEFAULT);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_IN, TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_IN);
	gtk_application_set_accels_for_action ((GtkApplication*) self, TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_OUT, TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_OUT);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (new_window_action);
	_g_object_unref0 (provider);
}

static gint
terminal_application_real_command_line (GApplication* base,
                                        GApplicationCommandLine* command_line)
{
	TerminalApplication * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	TerminalMainWindow* window = NULL;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	TerminalMainWindow* _tmp3_;
	gboolean is_first_window = FALSE;
	TerminalMainWindow* _tmp4_;
	gboolean new_window = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* working_directory = NULL;
	const gchar* _tmp11_;
	gchar** commands = NULL;
	gint commands_length1 = 0;
	gint _commands_size_ = 0;
	const gchar* command = NULL;
	gboolean new_tab = FALSE;
	gboolean minimized = FALSE;
	GVariantDict* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GVariantDict* _tmp14_;
	gchar** _tmp15_ = NULL;
	gboolean _tmp16_;
	gboolean _tmp43_ = FALSE;
	GVariantDict* _tmp44_;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_;
	gint result;
	self = (TerminalApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	options = _tmp0_;
	_tmp1_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow));
	window = _tmp3_;
	_tmp4_ = window;
	is_first_window = _tmp4_ == NULL;
	if (is_first_window) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		GVariantDict* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		_tmp7_ = options;
		_tmp9_ = g_variant_dict_lookup (_tmp7_, "new-window", "b", &_tmp8_, NULL);
		new_window = _tmp8_;
		if (_tmp9_) {
			_tmp6_ = new_window;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp5_ = _tmp6_;
	}
	if (_tmp5_) {
		TerminalMainWindow* _tmp10_;
		_tmp10_ = terminal_main_window_new (self, is_first_window);
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (window);
		window = _tmp10_;
	}
	_tmp11_ = g_application_command_line_get_cwd (command_line);
	working_directory = _tmp11_;
	_tmp12_ = options;
	g_variant_dict_lookup (_tmp12_, "new-tab", "b", &_tmp13_, NULL);
	new_tab = _tmp13_;
	_tmp14_ = options;
	_tmp16_ = g_variant_dict_lookup (_tmp14_, "execute", "^a&ay", &_tmp15_, NULL);
	commands = _tmp15_;
	commands_length1 = -1;
	_commands_size_ = commands_length1;
	if (_tmp16_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = i;
						i = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp19_ = commands;
					_tmp19__length1 = commands_length1;
					_tmp20_ = _tmp19_[i];
					if (!(_tmp20_ != NULL)) {
						break;
					}
					_tmp21_ = commands;
					_tmp21__length1 = commands_length1;
					_tmp22_ = _tmp21_[i];
					if (g_strcmp0 (_tmp22_, "\0") != 0) {
						TerminalMainWindow* _tmp23_;
						const gchar* _tmp24_;
						gchar** _tmp25_;
						gint _tmp25__length1;
						const gchar* _tmp26_;
						_tmp23_ = window;
						_tmp24_ = working_directory;
						_tmp25_ = commands;
						_tmp25__length1 = commands_length1;
						_tmp26_ = _tmp25_[i];
						terminal_main_window_add_tab_with_working_directory (_tmp23_, _tmp24_, _tmp26_, new_tab);
					}
				}
			}
		}
	} else {
		gboolean _tmp27_ = FALSE;
		GVariantDict* _tmp28_;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_;
		_tmp28_ = options;
		_tmp30_ = g_variant_dict_lookup (_tmp28_, "commandline", "^&ay", &_tmp29_, NULL);
		command = _tmp29_;
		if (_tmp30_) {
			const gchar* _tmp31_;
			_tmp31_ = command;
			_tmp27_ = g_strcmp0 (_tmp31_, "\0") != 0;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			TerminalMainWindow* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			_tmp32_ = window;
			_tmp33_ = working_directory;
			_tmp34_ = command;
			terminal_main_window_add_tab_with_working_directory (_tmp32_, _tmp33_, _tmp34_, new_tab);
		} else {
			gboolean _tmp35_ = FALSE;
			if (new_tab) {
				_tmp35_ = TRUE;
			} else {
				TerminalMainWindow* _tmp36_;
				TerminalTerminalView* _tmp37_;
				TerminalTerminalView* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				_tmp36_ = window;
				_tmp37_ = terminal_main_window_get_notebook (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = terminal_terminal_view_get_n_pages (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp35_ = _tmp40_ == 0;
			}
			if (_tmp35_) {
				TerminalMainWindow* _tmp41_;
				const gchar* _tmp42_;
				_tmp41_ = window;
				_tmp42_ = working_directory;
				terminal_main_window_add_tab_with_working_directory (_tmp41_, _tmp42_, "", new_tab);
			}
		}
	}
	_tmp44_ = options;
	_tmp46_ = g_variant_dict_lookup (_tmp44_, "minimized", "b", &_tmp45_, NULL);
	minimized = _tmp45_;
	if (_tmp46_) {
		_tmp43_ = minimized;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		TerminalMainWindow* _tmp47_;
		_tmp47_ = window;
		gtk_window_iconify ((GtkWindow*) _tmp47_);
	} else {
		TerminalMainWindow* _tmp48_;
		_tmp48_ = window;
		gtk_window_present ((GtkWindow*) _tmp48_);
	}
	result = 0;
	_g_object_unref0 (window);
	return result;
}

static void
terminal_application_real_dbus_unregister (GApplication* base,
                                           GDBusConnection* connection,
                                           const gchar* path)
{
	TerminalApplication * self;
	self = (TerminalApplication*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (path != NULL);
	if (self->priv->dbus_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (connection, self->priv->dbus_id);
	}
	G_APPLICATION_CLASS (terminal_application_parent_class)->dbus_unregister ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, path);
}

void
terminal_application_close (TerminalApplication* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp1_;
			GtkWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp1_;
			{
				GtkWindow* _tmp2_;
				_tmp2_ = window;
				gtk_window_close (_tmp2_);
				_g_object_unref0 (window);
			}
		}
	}
}

gboolean
terminal_application_get_is_testing (TerminalApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_testing;
	return result;
}

void
terminal_application_set_is_testing (TerminalApplication* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_application_get_is_testing (self);
	if (old_value != value) {
		self->priv->_is_testing = value;
		g_object_notify_by_pspec ((GObject *) self, terminal_application_properties[TERMINAL_APPLICATION_IS_TESTING_PROPERTY]);
	}
}

static void
_terminal_application___lambda49_ (TerminalApplication* self,
                                   GVariant* v)
{
	TerminalMainWindow* window_to_present = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	TerminalMainWindow* _tmp2_;
	gsize len = 0UL;
	gchar* tid = NULL;
	gsize _tmp3_ = 0UL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GList* _tmp6_;
	TerminalMainWindow* _tmp18_;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow));
	window_to_present = _tmp2_;
	_tmp4_ = g_variant_get_string (v, &_tmp3_);
	len = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	tid = _tmp5_;
	_tmp6_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = (GList*) _tmp6_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			TerminalMainWindow* _tmp7_;
			TerminalMainWindow* window = NULL;
			_tmp7_ = _g_object_ref0 ((TerminalMainWindow*) window_it->data);
			window = _tmp7_;
			{
				TerminalTerminalWidget* terminal = NULL;
				TerminalMainWindow* _tmp8_;
				const gchar* _tmp9_;
				TerminalTerminalWidget* _tmp10_;
				TerminalTerminalWidget* _tmp11_;
				TerminalTerminalWidget* _tmp12_;
				_tmp8_ = window;
				_tmp9_ = tid;
				_tmp10_ = terminal_main_window_get_terminal (_tmp8_, _tmp9_);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				terminal = _tmp11_;
				_tmp12_ = terminal;
				if (_tmp12_ != NULL) {
					TerminalMainWindow* _tmp13_;
					TerminalTerminalWidget* _tmp14_;
					HdyTabPage* _tmp15_;
					TerminalMainWindow* _tmp16_;
					TerminalMainWindow* _tmp17_;
					_tmp13_ = window;
					_tmp14_ = terminal;
					_tmp15_ = _tmp14_->tab;
					terminal_main_window_set_active_terminal_tab (_tmp13_, _tmp15_);
					_tmp16_ = window;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (window_to_present);
					window_to_present = _tmp17_;
					_g_object_unref0 (terminal);
					_g_object_unref0 (window);
					break;
				}
				_g_object_unref0 (terminal);
				_g_object_unref0 (window);
			}
		}
	}
	_tmp18_ = window_to_present;
	gtk_window_present ((GtkWindow*) _tmp18_);
	_g_free0 (tid);
	_g_object_unref0 (window_to_present);
}

static void
__terminal_application___lambda49__g_simple_action_activate (GSimpleAction* _sender,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	_terminal_application___lambda49_ ((TerminalApplication*) self, parameter);
}

static GObject *
terminal_application_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TerminalApplication * self;
	GSimpleAction* act = NULL;
	const GVariantType* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	parent_class = G_OBJECT_CLASS (terminal_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_APPLICATION, TerminalApplication);
	setlocale (LC_ALL, "");
	bindtextdomain (CONFIG_GETTEXT_PACKAGE, CONFIG_LOCALEDIR);
	bind_textdomain_codeset (CONFIG_GETTEXT_PACKAGE, "UTF-8");
	textdomain (CONFIG_GETTEXT_PACKAGE);
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_tmp1_ = g_simple_action_new ("process-finished", _tmp0_);
	act = _tmp1_;
	_tmp2_ = act;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = act;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) __terminal_application___lambda49__g_simple_action_activate, self, 0);
	g_application_add_main_option ((GApplication*) self, "version", 'v', 0, G_OPTION_ARG_NONE, _ ("Show version"), NULL);
	g_application_add_main_option ((GApplication*) self, "new-window", 'n', 0, G_OPTION_ARG_NONE, _ ("Open a new terminal window"), NULL);
	g_application_add_main_option ((GApplication*) self, "new-tab", 't', 0, G_OPTION_ARG_NONE, _ ("Open a new terminal tab at current working directory"), NULL);
	g_application_add_main_option ((GApplication*) self, "working-directory", 'w', 0, G_OPTION_ARG_FILENAME, _ ("Set shell working directory"), "DIR");
	g_application_add_main_option ((GApplication*) self, "execute", 'e', 0, G_OPTION_ARG_FILENAME_ARRAY, _ ("Run a program in terminal"), "PROGRAM");
	g_application_add_main_option ((GApplication*) self, "minimized", 'm', 0, G_OPTION_ARG_NONE, _ ("Open terminal in a minimized state"), NULL);
	g_application_add_main_option ((GApplication*) self, "commandline", 'x', 0, G_OPTION_ARG_FILENAME, _ ("Run remainder of line as a command in terminal"), "COMMAND");
	_g_object_unref0 (act);
	return obj;
}

static void
terminal_application_class_init (TerminalApplicationClass * klass,
                                 gpointer klass_data)
{
	terminal_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalApplication_private_offset);
	((GApplicationClass *) klass)->local_command_line = (gboolean (*) (GApplication*, gchar***, gint*)) terminal_application_real_local_command_line;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) terminal_application_real_handle_local_options;
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) terminal_application_real_dbus_register;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) terminal_application_real_startup;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) terminal_application_real_command_line;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) terminal_application_real_dbus_unregister;
	G_OBJECT_CLASS (klass)->get_property = _vala_terminal_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_terminal_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = terminal_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = terminal_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_APPLICATION_IS_TESTING_PROPERTY, terminal_application_properties[TERMINAL_APPLICATION_IS_TESTING_PROPERTY] = g_param_spec_boolean ("is-testing", "is-testing", "is-testing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
terminal_application_instance_init (TerminalApplication * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = terminal_application_get_instance_private (self);
	_tmp0_ = g_strdup ("\0");
	self->priv->commandline = _tmp0_;
	self->priv->dbus_id = (guint) 0;
}

static void
terminal_application_finalize (GObject * obj)
{
	TerminalApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_APPLICATION, TerminalApplication);
	_g_free0 (self->priv->commandline);
	G_OBJECT_CLASS (terminal_application_parent_class)->finalize (obj);
}

static GType
terminal_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalApplication), 0, (GInstanceInitFunc) terminal_application_instance_init, NULL };
	GType terminal_application_type_id;
	terminal_application_type_id = g_type_register_static (gtk_application_get_type (), "TerminalApplication", &g_define_type_info, 0);
	TerminalApplication_private_offset = g_type_add_instance_private (terminal_application_type_id, sizeof (TerminalApplicationPrivate));
	return terminal_application_type_id;
}

GType
terminal_application_get_type (void)
{
	static volatile gsize terminal_application_type_id__once = 0;
	if (g_once_init_enter (&terminal_application_type_id__once)) {
		GType terminal_application_type_id;
		terminal_application_type_id = terminal_application_get_type_once ();
		g_once_init_leave (&terminal_application_type_id__once, terminal_application_type_id);
	}
	return terminal_application_type_id__once;
}

static void
_vala_terminal_application_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	TerminalApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_APPLICATION, TerminalApplication);
	switch (property_id) {
		case TERMINAL_APPLICATION_IS_TESTING_PROPERTY:
		g_value_set_boolean (value, terminal_application_get_is_testing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_terminal_application_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	TerminalApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_APPLICATION, TerminalApplication);
	switch (property_id) {
		case TERMINAL_APPLICATION_IS_TESTING_PROPERTY:
		terminal_application_set_is_testing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	TerminalApplication* _tmp0_;
	TerminalApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = terminal_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

