#include <components/version/version.hpp>

#include <filesystem>
#include <fstream>

namespace Version
{
    std::string_view getVersion()
    {
        return "0.49.0";
    }

    std::string_view getCommitHash()
    {
        return "";
    }

    std::string_view getTagHash()
    {
        return "";
    }

    int getLuaApiRevision()
    {
        return 76;
    }

    int getPostprocessingApiRevision()
    {
        return 2;
    }

    std::string getOpenmwVersionDescription()
    {
        std::string str = "OpenMW version ";
        str += getVersion();
        if (!getCommitHash().empty())
        {
            str += "\nRevision: ";
            str += getCommitHash().substr(0, 10);
        }
        return str;
    }

    bool checkResourcesVersion(const std::filesystem::path& resourcePath)
    {
        std::ifstream stream(resourcePath / "version");
        std::string version, commitHash, tagHash;
        std::getline(stream, version);
        std::getline(stream, commitHash);
        std::getline(stream, tagHash);
        return getVersion() == version && getCommitHash() == commitHash && getTagHash() == tagHash;
    }

    std::string_view getDocumentationUrl()
    {
        if constexpr (std::string_view("") == "")
            return OPENMW_DOC_BASEURL "openmw-0.49.0/";
        else
            return OPENMW_DOC_BASEURL "latest/";
    }
}
