// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#include "core/providers/rocm/tensor/slice.h"
#include "core/providers/rocm/tensor/slice_impl.h"

namespace onnxruntime {
namespace contrib {
namespace rocm {

using namespace onnxruntime::rocm;

#define REGISTER_TYPED_DYNAMICSLICE(TIND)                               \
  ONNX_OPERATOR_TYPED_KERNEL_EX(                                        \
      DynamicSlice,                                                     \
      kOnnxDomain,                                                      \
      1,                                                                \
      TIND,                                                             \
      kRocmExecutionProvider,                                           \
      (*KernelDefBuilder::Create())                                     \
          .InputMemoryType(OrtMemTypeCPUInput, 1)                       \
          .InputMemoryType(OrtMemTypeCPUInput, 2)                       \
          .InputMemoryType(OrtMemTypeCPUInput, 3)                       \
          .TypeConstraint("T", DataTypeImpl::AllFixedSizeTensorTypes()) \
          .TypeConstraint("Tind", DataTypeImpl::GetTensorType<TIND>()), \
      rocm::Slice<true>);

REGISTER_TYPED_DYNAMICSLICE(int32_t)
REGISTER_TYPED_DYNAMICSLICE(int64_t)

}  // namespace rocm
}  // namespace contrib
}  // namespace onnxruntime
