// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolKeyValueAndUnit = sync.Pool{
		New: func() any {
			return &otlpprofiles.KeyValueAndUnit{}
		},
	}
)

func NewOrigKeyValueAndUnit() *otlpprofiles.KeyValueAndUnit {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.KeyValueAndUnit{}
	}
	return protoPoolKeyValueAndUnit.Get().(*otlpprofiles.KeyValueAndUnit)
}

func DeleteOrigKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigAnyValue(&orig.Value, false)

	orig.Reset()
	if nullable {
		protoPoolKeyValueAndUnit.Put(orig)
	}
}

func CopyOrigKeyValueAndUnit(dest, src *otlpprofiles.KeyValueAndUnit) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.KeyStrindex = src.KeyStrindex
	CopyOrigAnyValue(&dest.Value, &src.Value)
	dest.UnitStrindex = src.UnitStrindex
}

func GenTestOrigKeyValueAndUnit() *otlpprofiles.KeyValueAndUnit {
	orig := NewOrigKeyValueAndUnit()
	orig.KeyStrindex = int32(13)
	orig.Value = *GenTestOrigAnyValue()
	orig.UnitStrindex = int32(13)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.KeyStrindex != int32(0) {
		dest.WriteObjectField("keyStrindex")
		dest.WriteInt32(orig.KeyStrindex)
	}
	dest.WriteObjectField("value")
	MarshalJSONOrigAnyValue(&orig.Value, dest)
	if orig.UnitStrindex != int32(0) {
		dest.WriteObjectField("unitStrindex")
		dest.WriteInt32(orig.UnitStrindex)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigKeyValueAndUnit unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "keyStrindex", "key_strindex":
			orig.KeyStrindex = iter.ReadInt32()
		case "value":
			UnmarshalJSONOrigAnyValue(&orig.Value, iter)
		case "unitStrindex", "unit_strindex":
			orig.UnitStrindex = iter.ReadInt32()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit) int {
	var n int
	var l int
	_ = l
	if orig.KeyStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.KeyStrindex))
	}
	l = SizeProtoOrigAnyValue(&orig.Value)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.UnitStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.UnitStrindex))
	}
	return n
}

func MarshalProtoOrigKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.KeyStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.KeyStrindex))
		pos--
		buf[pos] = 0x8
	}

	l = MarshalProtoOrigAnyValue(&orig.Value, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	if orig.UnitStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.UnitStrindex))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.KeyStrindex = int32(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigAnyValue(&orig.Value, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field UnitStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.UnitStrindex = int32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
