/*
 * Copyright The Asahi Linux Contributors
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include <stdint.h>

#pragma once
#include "util/macros.h"

struct libagx_decompress_args {
   uint64_t images;
   uint64_t metadata;
   uint64_t tile_uncompressed;
   uint32_t metadata_layer_stride_tl;
   uint16_t metadata_width_tl;
   uint16_t metadata_height_tl;
} PACKED;

static_assert(offsetof(struct libagx_decompress_args, images) == 0, "");
static_assert(offsetof(struct libagx_decompress_args, metadata) == 8, "");
static_assert(offsetof(struct libagx_decompress_args, tile_uncompressed) == 16, "");
static_assert(offsetof(struct libagx_decompress_args, metadata_layer_stride_tl) == 24, "");
static_assert(offsetof(struct libagx_decompress_args, metadata_width_tl) == 28, "");
static_assert(offsetof(struct libagx_decompress_args, metadata_height_tl) == 30, "");
static_assert(sizeof(struct libagx_decompress_args) == 32, "");

struct libagx_fast_clear_args {
   uint64_t meta;
   uint64_t body;
   uint32_t width_tl;
   uint32_t height_tl;
   uint32_t tile_w_el;
   uint32_t tile_h_el;
   uint32_t meta_layer_stride_tl;
   uint32_t body_layer_stride_uint4;
   uint32_t a;
   uint32_t b;
   uint32_t c;
   uint32_t d;
   uint32_t solid_mode;
} PACKED;

static_assert(offsetof(struct libagx_fast_clear_args, meta) == 0, "");
static_assert(offsetof(struct libagx_fast_clear_args, body) == 8, "");
static_assert(offsetof(struct libagx_fast_clear_args, width_tl) == 16, "");
static_assert(offsetof(struct libagx_fast_clear_args, height_tl) == 20, "");
static_assert(offsetof(struct libagx_fast_clear_args, tile_w_el) == 24, "");
static_assert(offsetof(struct libagx_fast_clear_args, tile_h_el) == 28, "");
static_assert(offsetof(struct libagx_fast_clear_args, meta_layer_stride_tl) == 32, "");
static_assert(offsetof(struct libagx_fast_clear_args, body_layer_stride_uint4) == 36, "");
static_assert(offsetof(struct libagx_fast_clear_args, a) == 40, "");
static_assert(offsetof(struct libagx_fast_clear_args, b) == 44, "");
static_assert(offsetof(struct libagx_fast_clear_args, c) == 48, "");
static_assert(offsetof(struct libagx_fast_clear_args, d) == 52, "");
static_assert(offsetof(struct libagx_fast_clear_args, solid_mode) == 56, "");
static_assert(sizeof(struct libagx_fast_clear_args) == 60, "");

struct libagx_fill_args {
   uint64_t address;
   uint32_t value;
} PACKED;

static_assert(offsetof(struct libagx_fill_args, address) == 0, "");
static_assert(offsetof(struct libagx_fill_args, value) == 8, "");
static_assert(sizeof(struct libagx_fill_args) == 12, "");

struct libagx_copy_uint4_args {
   uint64_t dest;
   uint64_t src;
} PACKED;

static_assert(offsetof(struct libagx_copy_uint4_args, dest) == 0, "");
static_assert(offsetof(struct libagx_copy_uint4_args, src) == 8, "");
static_assert(sizeof(struct libagx_copy_uint4_args) == 16, "");

struct libagx_copy_uchar_args {
   uint64_t dest;
   uint64_t src;
} PACKED;

static_assert(offsetof(struct libagx_copy_uchar_args, dest) == 0, "");
static_assert(offsetof(struct libagx_copy_uchar_args, src) == 8, "");
static_assert(sizeof(struct libagx_copy_uchar_args) == 16, "");

struct libagx_fill_uint4_args {
   uint64_t address;
   uint32_t layer_stride_uint4;
   uint32_t a;
   uint32_t b;
   uint32_t c;
   uint32_t d;
} PACKED;

static_assert(offsetof(struct libagx_fill_uint4_args, address) == 0, "");
static_assert(offsetof(struct libagx_fill_uint4_args, layer_stride_uint4) == 8, "");
static_assert(offsetof(struct libagx_fill_uint4_args, a) == 12, "");
static_assert(offsetof(struct libagx_fill_uint4_args, b) == 16, "");
static_assert(offsetof(struct libagx_fill_uint4_args, c) == 20, "");
static_assert(offsetof(struct libagx_fill_uint4_args, d) == 24, "");
static_assert(sizeof(struct libagx_fill_uint4_args) == 28, "");

struct libagx_predicate_indirect_args {
   uint64_t out;
   uint64_t in;
   uint64_t draw_count;
   uint32_t stride_el;
} PACKED;

static_assert(offsetof(struct libagx_predicate_indirect_args, out) == 0, "");
static_assert(offsetof(struct libagx_predicate_indirect_args, in) == 8, "");
static_assert(offsetof(struct libagx_predicate_indirect_args, draw_count) == 16, "");
static_assert(offsetof(struct libagx_predicate_indirect_args, stride_el) == 24, "");
static_assert(sizeof(struct libagx_predicate_indirect_args) == 28, "");

struct libagx_draw_without_adj_args {
   uint64_t out;
   uint64_t in;
   uint64_t vp;
   uint64_t index_buffer;
   uint64_t index_buffer_range_el;
   uint32_t index_size_B;
   uint32_t prim;
} PACKED;

static_assert(offsetof(struct libagx_draw_without_adj_args, out) == 0, "");
static_assert(offsetof(struct libagx_draw_without_adj_args, in) == 8, "");
static_assert(offsetof(struct libagx_draw_without_adj_args, vp) == 16, "");
static_assert(offsetof(struct libagx_draw_without_adj_args, index_buffer) == 24, "");
static_assert(offsetof(struct libagx_draw_without_adj_args, index_buffer_range_el) == 32, "");
static_assert(offsetof(struct libagx_draw_without_adj_args, index_size_B) == 40, "");
static_assert(offsetof(struct libagx_draw_without_adj_args, prim) == 44, "");
static_assert(sizeof(struct libagx_draw_without_adj_args) == 48, "");

struct libagx_draw_robust_index_args {
   uint64_t vdm;
   uint64_t heap;
   uint64_t cmd;
   uint64_t in_buf_ptr;
   uint32_t in_buf_range_B;
   uint16_t restart;
   uint8_t _pad6[2];
   uint32_t topology;
} PACKED;

static_assert(offsetof(struct libagx_draw_robust_index_args, vdm) == 0, "");
static_assert(offsetof(struct libagx_draw_robust_index_args, heap) == 8, "");
static_assert(offsetof(struct libagx_draw_robust_index_args, cmd) == 16, "");
static_assert(offsetof(struct libagx_draw_robust_index_args, in_buf_ptr) == 24, "");
static_assert(offsetof(struct libagx_draw_robust_index_args, in_buf_range_B) == 32, "");
static_assert(offsetof(struct libagx_draw_robust_index_args, restart) == 36, "");
static_assert(offsetof(struct libagx_draw_robust_index_args, topology) == 40, "");
static_assert(sizeof(struct libagx_draw_robust_index_args) == 44, "");

struct libagx_increment_ia_args {
   uint64_t ia_vertices;
   uint64_t ia_primitives;
   uint64_t vs_invocations;
   uint64_t c_prims;
   uint64_t c_invs;
   uint64_t draw;
   uint32_t prim;
   uint32_t verts_per_patch;
} PACKED;

static_assert(offsetof(struct libagx_increment_ia_args, ia_vertices) == 0, "");
static_assert(offsetof(struct libagx_increment_ia_args, ia_primitives) == 8, "");
static_assert(offsetof(struct libagx_increment_ia_args, vs_invocations) == 16, "");
static_assert(offsetof(struct libagx_increment_ia_args, c_prims) == 24, "");
static_assert(offsetof(struct libagx_increment_ia_args, c_invs) == 32, "");
static_assert(offsetof(struct libagx_increment_ia_args, draw) == 40, "");
static_assert(offsetof(struct libagx_increment_ia_args, prim) == 48, "");
static_assert(offsetof(struct libagx_increment_ia_args, verts_per_patch) == 52, "");
static_assert(sizeof(struct libagx_increment_ia_args) == 56, "");

struct libagx_increment_ia_restart_args {
   uint64_t ia_vertices;
   uint64_t ia_primitives;
   uint64_t vs_invocations;
   uint64_t c_prims;
   uint64_t c_invs;
   uint64_t draw;
   uint64_t index_buffer;
   uint32_t index_buffer_range_el;
   uint32_t restart_index;
   uint32_t index_size_B;
   uint32_t prim;
   uint32_t verts_per_patch;
} PACKED;

static_assert(offsetof(struct libagx_increment_ia_restart_args, ia_vertices) == 0, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, ia_primitives) == 8, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, vs_invocations) == 16, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, c_prims) == 24, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, c_invs) == 32, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, draw) == 40, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, index_buffer) == 48, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, index_buffer_range_el) == 56, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, restart_index) == 60, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, index_size_B) == 64, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, prim) == 68, "");
static_assert(offsetof(struct libagx_increment_ia_restart_args, verts_per_patch) == 72, "");
static_assert(sizeof(struct libagx_increment_ia_restart_args) == 76, "");

struct libagx_unroll_restart_args {
   uint64_t heap;
   uint64_t index_buffer;
   uint64_t in_draw;
   uint64_t out_draw;
   uint32_t max_draws;
   uint32_t restart_index;
   uint32_t index_buffer_size_el;
   uint32_t index_size_log2;
   uint32_t flatshade_first;
} PACKED;

static_assert(offsetof(struct libagx_unroll_restart_args, heap) == 0, "");
static_assert(offsetof(struct libagx_unroll_restart_args, index_buffer) == 8, "");
static_assert(offsetof(struct libagx_unroll_restart_args, in_draw) == 16, "");
static_assert(offsetof(struct libagx_unroll_restart_args, out_draw) == 24, "");
static_assert(offsetof(struct libagx_unroll_restart_args, max_draws) == 32, "");
static_assert(offsetof(struct libagx_unroll_restart_args, restart_index) == 36, "");
static_assert(offsetof(struct libagx_unroll_restart_args, index_buffer_size_el) == 40, "");
static_assert(offsetof(struct libagx_unroll_restart_args, index_size_log2) == 44, "");
static_assert(offsetof(struct libagx_unroll_restart_args, flatshade_first) == 48, "");
static_assert(sizeof(struct libagx_unroll_restart_args) == 52, "");

struct libagx_gs_setup_indirect_args {
   uint64_t index_buffer;
   uint64_t draw;
   uint64_t vp;
   uint64_t p;
   uint64_t heap;
   uint64_t vs_outputs;
   uint32_t index_size_B;
   uint32_t index_buffer_range_el;
   uint32_t prim;
   uint32_t is_prefix_summing;
   uint32_t max_indices;
   uint32_t shape;
} PACKED;

static_assert(offsetof(struct libagx_gs_setup_indirect_args, index_buffer) == 0, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, draw) == 8, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, vp) == 16, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, p) == 24, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, heap) == 32, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, vs_outputs) == 40, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, index_size_B) == 48, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, index_buffer_range_el) == 52, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, prim) == 56, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, is_prefix_summing) == 60, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, max_indices) == 64, "");
static_assert(offsetof(struct libagx_gs_setup_indirect_args, shape) == 68, "");
static_assert(sizeof(struct libagx_gs_setup_indirect_args) == 72, "");

struct libagx_prefix_sum_geom_args {
   uint64_t p;
} PACKED;

static_assert(offsetof(struct libagx_prefix_sum_geom_args, p) == 0, "");
static_assert(sizeof(struct libagx_prefix_sum_geom_args) == 8, "");

struct libagx_prefix_sum_tess_args {
   uint64_t p;
   uint64_t c_prims;
   uint64_t c_invs;
} PACKED;

static_assert(offsetof(struct libagx_prefix_sum_tess_args, p) == 0, "");
static_assert(offsetof(struct libagx_prefix_sum_tess_args, c_prims) == 8, "");
static_assert(offsetof(struct libagx_prefix_sum_tess_args, c_invs) == 16, "");
static_assert(sizeof(struct libagx_prefix_sum_tess_args) == 24, "");

struct libagx_copy_query_args {
   uint64_t availability;
   uint64_t results;
   uint64_t oq_index;
   uint64_t dst_addr;
   uint64_t dst_stride;
   uint32_t first_query;
   uint32_t flags;
   uint16_t reports_per_query;
} PACKED;

static_assert(offsetof(struct libagx_copy_query_args, availability) == 0, "");
static_assert(offsetof(struct libagx_copy_query_args, results) == 8, "");
static_assert(offsetof(struct libagx_copy_query_args, oq_index) == 16, "");
static_assert(offsetof(struct libagx_copy_query_args, dst_addr) == 24, "");
static_assert(offsetof(struct libagx_copy_query_args, dst_stride) == 32, "");
static_assert(offsetof(struct libagx_copy_query_args, first_query) == 40, "");
static_assert(offsetof(struct libagx_copy_query_args, flags) == 44, "");
static_assert(offsetof(struct libagx_copy_query_args, reports_per_query) == 48, "");
static_assert(sizeof(struct libagx_copy_query_args) == 50, "");

struct libagx_reset_query_args {
   uint64_t availability;
   uint64_t results;
   uint64_t oq_index;
   uint32_t first_query;
   uint16_t reports_per_query;
   uint8_t _pad5[2];
   uint32_t set_available;
} PACKED;

static_assert(offsetof(struct libagx_reset_query_args, availability) == 0, "");
static_assert(offsetof(struct libagx_reset_query_args, results) == 8, "");
static_assert(offsetof(struct libagx_reset_query_args, oq_index) == 16, "");
static_assert(offsetof(struct libagx_reset_query_args, first_query) == 24, "");
static_assert(offsetof(struct libagx_reset_query_args, reports_per_query) == 28, "");
static_assert(offsetof(struct libagx_reset_query_args, set_available) == 32, "");
static_assert(sizeof(struct libagx_reset_query_args) == 36, "");

struct libagx_copy_query_gl_args {
   uint64_t query;
   uint64_t dest;
   uint16_t value_type;
   uint16_t bool_size;
} PACKED;

static_assert(offsetof(struct libagx_copy_query_gl_args, query) == 0, "");
static_assert(offsetof(struct libagx_copy_query_gl_args, dest) == 8, "");
static_assert(offsetof(struct libagx_copy_query_gl_args, value_type) == 16, "");
static_assert(offsetof(struct libagx_copy_query_gl_args, bool_size) == 18, "");
static_assert(sizeof(struct libagx_copy_query_gl_args) == 20, "");

struct libagx_copy_xfb_counters_args {
   uint64_t push;
} PACKED;

static_assert(offsetof(struct libagx_copy_xfb_counters_args, push) == 0, "");
static_assert(sizeof(struct libagx_copy_xfb_counters_args) == 8, "");

struct libagx_increment_statistic_args {
   uint64_t statistic;
   uint32_t delta;
} PACKED;

static_assert(offsetof(struct libagx_increment_statistic_args, statistic) == 0, "");
static_assert(offsetof(struct libagx_increment_statistic_args, delta) == 8, "");
static_assert(sizeof(struct libagx_increment_statistic_args) == 12, "");

struct libagx_increment_cs_invocations_args {
   uint64_t grid;
   uint64_t statistic;
   uint32_t local_size_threads;
} PACKED;

static_assert(offsetof(struct libagx_increment_cs_invocations_args, grid) == 0, "");
static_assert(offsetof(struct libagx_increment_cs_invocations_args, statistic) == 8, "");
static_assert(offsetof(struct libagx_increment_cs_invocations_args, local_size_threads) == 16, "");
static_assert(sizeof(struct libagx_increment_cs_invocations_args) == 20, "");

struct libagx_write_u32s_args {
   uint64_t p;
} PACKED;

static_assert(offsetof(struct libagx_write_u32s_args, p) == 0, "");
static_assert(sizeof(struct libagx_write_u32s_args) == 8, "");

struct libagx_copy_timestamp_args {
   uint64_t dest;
   uint64_t src;
} PACKED;

static_assert(offsetof(struct libagx_copy_timestamp_args, dest) == 0, "");
static_assert(offsetof(struct libagx_copy_timestamp_args, src) == 8, "");
static_assert(sizeof(struct libagx_copy_timestamp_args) == 16, "");

struct libagx_write_u32_args {
   uint64_t address;
   uint32_t value;
} PACKED;

static_assert(offsetof(struct libagx_write_u32_args, address) == 0, "");
static_assert(offsetof(struct libagx_write_u32_args, value) == 8, "");
static_assert(sizeof(struct libagx_write_u32_args) == 12, "");

struct libagx_tess_setup_indirect_args {
   uint64_t p;
   uint64_t grids;
   uint64_t vp;
   uint64_t indirect;
   uint64_t in_index_buffer;
   uint32_t in_index_buffer_range_el;
   uint32_t in_index_size_B;
   uint64_t vertex_outputs;
   uint64_t tcs_statistic;
} PACKED;

static_assert(offsetof(struct libagx_tess_setup_indirect_args, p) == 0, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, grids) == 8, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, vp) == 16, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, indirect) == 24, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, in_index_buffer) == 32, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, in_index_buffer_range_el) == 40, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, in_index_size_B) == 44, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, vertex_outputs) == 48, "");
static_assert(offsetof(struct libagx_tess_setup_indirect_args, tcs_statistic) == 56, "");
static_assert(sizeof(struct libagx_tess_setup_indirect_args) == 64, "");

struct libagx_tess_isoline_args {
   uint64_t p;
} PACKED;

static_assert(offsetof(struct libagx_tess_isoline_args, p) == 0, "");
static_assert(sizeof(struct libagx_tess_isoline_args) == 8, "");

struct libagx_tess_tri_args {
   uint64_t p;
} PACKED;

static_assert(offsetof(struct libagx_tess_tri_args, p) == 0, "");
static_assert(sizeof(struct libagx_tess_tri_args) == 8, "");

struct libagx_tess_quad_args {
   uint64_t p;
} PACKED;

static_assert(offsetof(struct libagx_tess_quad_args, p) == 0, "");
static_assert(sizeof(struct libagx_tess_quad_args) == 8, "");

struct libagx_helper_args {
} PACKED;

static_assert(sizeof(struct libagx_helper_args) == 0, "");

enum libagx_program {
    LIBAGX_DECOMPRESS_0 = 0,
    LIBAGX_DECOMPRESS_1 = 1,
    LIBAGX_DECOMPRESS_2 = 2,
    LIBAGX_FAST_CLEAR_0 = 3,
    LIBAGX_FAST_CLEAR_1 = 4,
    LIBAGX_FAST_CLEAR_2 = 5,
    LIBAGX_FAST_CLEAR_3 = 6,
    LIBAGX_FAST_CLEAR_4 = 7,
    LIBAGX_FAST_CLEAR_5 = 8,
    LIBAGX_FAST_CLEAR_6 = 9,
    LIBAGX_FAST_CLEAR_7 = 10,
    LIBAGX_FAST_CLEAR_8 = 11,
    LIBAGX_FAST_CLEAR_9 = 12,
    LIBAGX_FAST_CLEAR_10 = 13,
    LIBAGX_FAST_CLEAR_11 = 14,
    LIBAGX_FAST_CLEAR_12 = 15,
    LIBAGX_FAST_CLEAR_13 = 16,
    LIBAGX_FAST_CLEAR_14 = 17,
    LIBAGX_FILL = 18,
    LIBAGX_COPY_UINT4 = 19,
    LIBAGX_COPY_UCHAR = 20,
    LIBAGX_FILL_UINT4 = 21,
    LIBAGX_PREDICATE_INDIRECT_0 = 22,
    LIBAGX_PREDICATE_INDIRECT_1 = 23,
    LIBAGX_DRAW_WITHOUT_ADJ = 24,
    LIBAGX_DRAW_ROBUST_INDEX_0 = 25,
    LIBAGX_DRAW_ROBUST_INDEX_1 = 26,
    LIBAGX_DRAW_ROBUST_INDEX_2 = 27,
    LIBAGX_INCREMENT_IA = 28,
    LIBAGX_INCREMENT_IA_RESTART = 29,
    LIBAGX_UNROLL_RESTART_0 = 30,
    LIBAGX_UNROLL_RESTART_1 = 31,
    LIBAGX_UNROLL_RESTART_2 = 32,
    LIBAGX_UNROLL_RESTART_3 = 33,
    LIBAGX_UNROLL_RESTART_4 = 34,
    LIBAGX_UNROLL_RESTART_5 = 35,
    LIBAGX_UNROLL_RESTART_6 = 36,
    LIBAGX_UNROLL_RESTART_7 = 37,
    LIBAGX_UNROLL_RESTART_8 = 38,
    LIBAGX_UNROLL_RESTART_9 = 39,
    LIBAGX_UNROLL_RESTART_10 = 40,
    LIBAGX_GS_SETUP_INDIRECT = 41,
    LIBAGX_PREFIX_SUM_GEOM = 42,
    LIBAGX_PREFIX_SUM_TESS_0 = 43,
    LIBAGX_PREFIX_SUM_TESS_1 = 44,
    LIBAGX_COPY_QUERY = 45,
    LIBAGX_RESET_QUERY = 46,
    LIBAGX_COPY_QUERY_GL = 47,
    LIBAGX_COPY_XFB_COUNTERS = 48,
    LIBAGX_INCREMENT_STATISTIC = 49,
    LIBAGX_INCREMENT_CS_INVOCATIONS = 50,
    LIBAGX_WRITE_U32S = 51,
    LIBAGX_COPY_TIMESTAMP = 52,
    LIBAGX_WRITE_U32 = 53,
    LIBAGX_TESS_SETUP_INDIRECT = 54,
    LIBAGX_TESS_ISOLINE_0 = 55,
    LIBAGX_TESS_ISOLINE_1 = 56,
    LIBAGX_TESS_TRI_0 = 57,
    LIBAGX_TESS_TRI_1 = 58,
    LIBAGX_TESS_QUAD_0 = 59,
    LIBAGX_TESS_QUAD_1 = 60,
    LIBAGX_HELPER = 61,
    LIBAGX_NUM_PROGRAMS,
};

static inline unsigned
LIBAGX_DECOMPRESS(unsigned log2_samples__3)
{
   assert(log2_samples__3 < 3);

   unsigned idx = log2_samples__3;

   assert(idx < 3);
   return LIBAGX_DECOMPRESS_0 + idx;
}

static inline unsigned
LIBAGX_FAST_CLEAR(unsigned blocksize_B_log2__5, unsigned samples_log2__3)
{
   assert(blocksize_B_log2__5 < 5);
   assert(samples_log2__3 < 3);

   unsigned idx = samples_log2__3;
   idx = (idx * 5) + blocksize_B_log2__5;

   assert(idx < 15);
   return LIBAGX_FAST_CLEAR_0 + idx;
}

static inline unsigned
LIBAGX_PREDICATE_INDIRECT(unsigned indexed__2)
{
   assert(indexed__2 < 2);

   unsigned idx = indexed__2;

   assert(idx < 2);
   return LIBAGX_PREDICATE_INDIRECT_0 + idx;
}

static inline unsigned
LIBAGX_DRAW_ROBUST_INDEX(unsigned index_size__3)
{
   assert(index_size__3 < 3);

   unsigned idx = index_size__3;

   assert(idx < 3);
   return LIBAGX_DRAW_ROBUST_INDEX_0 + idx;
}

static inline unsigned
LIBAGX_UNROLL_RESTART(unsigned mode__11)
{
   assert(mode__11 < 11);

   unsigned idx = mode__11;

   assert(idx < 11);
   return LIBAGX_UNROLL_RESTART_0 + idx;
}

static inline unsigned
LIBAGX_PREFIX_SUM_TESS(unsigned increment_stats__2)
{
   assert(increment_stats__2 < 2);

   unsigned idx = increment_stats__2;

   assert(idx < 2);
   return LIBAGX_PREFIX_SUM_TESS_0 + idx;
}

static inline unsigned
LIBAGX_TESS_ISOLINE(unsigned mode__2)
{
   assert(mode__2 < 2);

   unsigned idx = mode__2;

   assert(idx < 2);
   return LIBAGX_TESS_ISOLINE_0 + idx;
}

static inline unsigned
LIBAGX_TESS_TRI(unsigned mode__2)
{
   assert(mode__2 < 2);

   unsigned idx = mode__2;

   assert(idx < 2);
   return LIBAGX_TESS_TRI_0 + idx;
}

static inline unsigned
LIBAGX_TESS_QUAD(unsigned mode__2)
{
   assert(mode__2 < 2);

   unsigned idx = mode__2;

   assert(idx < 2);
   return LIBAGX_TESS_QUAD_0 + idx;
}


#define libagx_decompress_struct(_context, _grid, _barrier, _data, log2_samples__3) do { \
   struct libagx_decompress_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_DECOMPRESS(log2_samples__3), &_args, sizeof(_args)); \
} while(0);

#define libagx_decompress(_context, _grid, _barrier, images, metadata, tile_uncompressed, metadata_layer_stride_tl, metadata_width_tl, metadata_height_tl, log2_samples__3) do { \
   struct libagx_decompress_args _args = {images, metadata, tile_uncompressed, metadata_layer_stride_tl, metadata_width_tl, metadata_height_tl};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_DECOMPRESS(log2_samples__3), &_args, sizeof(_args)); \
} while(0);

#define libagx_fast_clear_struct(_context, _grid, _barrier, _data, blocksize_B_log2__5, samples_log2__3) do { \
   struct libagx_fast_clear_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_FAST_CLEAR(blocksize_B_log2__5, samples_log2__3), &_args, sizeof(_args)); \
} while(0);

#define libagx_fast_clear(_context, _grid, _barrier, meta, body, width_tl, height_tl, tile_w_el, tile_h_el, meta_layer_stride_tl, body_layer_stride_uint4, blocksize_B_log2__5, samples_log2__3, a, b, c, d, solid_mode) do { \
   struct libagx_fast_clear_args _args = {meta, body, width_tl, height_tl, tile_w_el, tile_h_el, meta_layer_stride_tl, body_layer_stride_uint4, a, b, c, d, solid_mode};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_FAST_CLEAR(blocksize_B_log2__5, samples_log2__3), &_args, sizeof(_args)); \
} while(0);

#define libagx_fill_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_fill_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_FILL, &_args, sizeof(_args)); \
} while(0);

#define libagx_fill(_context, _grid, _barrier, address, value) do { \
   struct libagx_fill_args _args = {address, value};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_FILL, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_uint4_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_copy_uint4_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_UINT4, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_uint4(_context, _grid, _barrier, dest, src) do { \
   struct libagx_copy_uint4_args _args = {dest, src};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_UINT4, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_uchar_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_copy_uchar_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_UCHAR, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_uchar(_context, _grid, _barrier, dest, src) do { \
   struct libagx_copy_uchar_args _args = {dest, src};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_UCHAR, &_args, sizeof(_args)); \
} while(0);

#define libagx_fill_uint4_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_fill_uint4_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_FILL_UINT4, &_args, sizeof(_args)); \
} while(0);

#define libagx_fill_uint4(_context, _grid, _barrier, address, layer_stride_uint4, a, b, c, d) do { \
   struct libagx_fill_uint4_args _args = {address, layer_stride_uint4, a, b, c, d};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_FILL_UINT4, &_args, sizeof(_args)); \
} while(0);

#define libagx_predicate_indirect_struct(_context, _grid, _barrier, _data, indexed__2) do { \
   struct libagx_predicate_indirect_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_PREDICATE_INDIRECT(indexed__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_predicate_indirect(_context, _grid, _barrier, out, in, draw_count, stride_el, indexed__2) do { \
   struct libagx_predicate_indirect_args _args = {out, in, draw_count, stride_el};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_PREDICATE_INDIRECT(indexed__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_draw_without_adj_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_draw_without_adj_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_DRAW_WITHOUT_ADJ, &_args, sizeof(_args)); \
} while(0);

#define libagx_draw_without_adj(_context, _grid, _barrier, out, in, vp, index_buffer, index_buffer_range_el, index_size_B, prim) do { \
   struct libagx_draw_without_adj_args _args = {out, in, vp, index_buffer, index_buffer_range_el, index_size_B, prim};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_DRAW_WITHOUT_ADJ, &_args, sizeof(_args)); \
} while(0);

#define libagx_draw_robust_index_struct(_context, _grid, _barrier, _data, index_size__3) do { \
   struct libagx_draw_robust_index_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_DRAW_ROBUST_INDEX(index_size__3), &_args, sizeof(_args)); \
} while(0);

#define libagx_draw_robust_index(_context, _grid, _barrier, vdm, heap, cmd, in_buf_ptr, in_buf_range_B, restart, topology, index_size__3) do { \
   struct libagx_draw_robust_index_args _args = {vdm, heap, cmd, in_buf_ptr, in_buf_range_B, restart, {0}, topology};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_DRAW_ROBUST_INDEX(index_size__3), &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_ia_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_increment_ia_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_IA, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_ia(_context, _grid, _barrier, ia_vertices, ia_primitives, vs_invocations, c_prims, c_invs, draw, prim, verts_per_patch) do { \
   struct libagx_increment_ia_args _args = {ia_vertices, ia_primitives, vs_invocations, c_prims, c_invs, draw, prim, verts_per_patch};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_IA, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_ia_restart_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_increment_ia_restart_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_IA_RESTART, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_ia_restart(_context, _grid, _barrier, ia_vertices, ia_primitives, vs_invocations, c_prims, c_invs, draw, index_buffer, index_buffer_range_el, restart_index, index_size_B, prim, verts_per_patch) do { \
   struct libagx_increment_ia_restart_args _args = {ia_vertices, ia_primitives, vs_invocations, c_prims, c_invs, draw, index_buffer, index_buffer_range_el, restart_index, index_size_B, prim, verts_per_patch};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_IA_RESTART, &_args, sizeof(_args)); \
} while(0);

#define libagx_unroll_restart_struct(_context, _grid, _barrier, _data, mode__11) do { \
   struct libagx_unroll_restart_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_UNROLL_RESTART(mode__11), &_args, sizeof(_args)); \
} while(0);

#define libagx_unroll_restart(_context, _grid, _barrier, heap, index_buffer, in_draw, out_draw, max_draws, restart_index, index_buffer_size_el, index_size_log2, flatshade_first, mode__11) do { \
   struct libagx_unroll_restart_args _args = {heap, index_buffer, in_draw, out_draw, max_draws, restart_index, index_buffer_size_el, index_size_log2, flatshade_first};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_UNROLL_RESTART(mode__11), &_args, sizeof(_args)); \
} while(0);

#define libagx_gs_setup_indirect_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_gs_setup_indirect_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_GS_SETUP_INDIRECT, &_args, sizeof(_args)); \
} while(0);

#define libagx_gs_setup_indirect(_context, _grid, _barrier, index_buffer, draw, vp, p, heap, vs_outputs, index_size_B, index_buffer_range_el, prim, is_prefix_summing, max_indices, shape) do { \
   struct libagx_gs_setup_indirect_args _args = {index_buffer, draw, vp, p, heap, vs_outputs, index_size_B, index_buffer_range_el, prim, is_prefix_summing, max_indices, shape};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_GS_SETUP_INDIRECT, &_args, sizeof(_args)); \
} while(0);

#define libagx_prefix_sum_geom_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_prefix_sum_geom_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_PREFIX_SUM_GEOM, &_args, sizeof(_args)); \
} while(0);

#define libagx_prefix_sum_geom(_context, _grid, _barrier, p) do { \
   struct libagx_prefix_sum_geom_args _args = {p};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_PREFIX_SUM_GEOM, &_args, sizeof(_args)); \
} while(0);

#define libagx_prefix_sum_tess_struct(_context, _grid, _barrier, _data, increment_stats__2) do { \
   struct libagx_prefix_sum_tess_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_PREFIX_SUM_TESS(increment_stats__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_prefix_sum_tess(_context, _grid, _barrier, p, c_prims, c_invs, increment_stats__2) do { \
   struct libagx_prefix_sum_tess_args _args = {p, c_prims, c_invs};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_PREFIX_SUM_TESS(increment_stats__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_query_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_copy_query_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_QUERY, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_query(_context, _grid, _barrier, availability, results, oq_index, dst_addr, dst_stride, first_query, flags, reports_per_query) do { \
   struct libagx_copy_query_args _args = {availability, results, oq_index, dst_addr, dst_stride, first_query, flags, reports_per_query};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_QUERY, &_args, sizeof(_args)); \
} while(0);

#define libagx_reset_query_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_reset_query_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_RESET_QUERY, &_args, sizeof(_args)); \
} while(0);

#define libagx_reset_query(_context, _grid, _barrier, availability, results, oq_index, first_query, reports_per_query, set_available) do { \
   struct libagx_reset_query_args _args = {availability, results, oq_index, first_query, reports_per_query, {0}, set_available};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_RESET_QUERY, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_query_gl_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_copy_query_gl_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_QUERY_GL, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_query_gl(_context, _grid, _barrier, query, dest, value_type, bool_size) do { \
   struct libagx_copy_query_gl_args _args = {query, dest, value_type, bool_size};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_QUERY_GL, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_xfb_counters_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_copy_xfb_counters_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_XFB_COUNTERS, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_xfb_counters(_context, _grid, _barrier, push) do { \
   struct libagx_copy_xfb_counters_args _args = {push};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_XFB_COUNTERS, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_statistic_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_increment_statistic_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_STATISTIC, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_statistic(_context, _grid, _barrier, statistic, delta) do { \
   struct libagx_increment_statistic_args _args = {statistic, delta};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_STATISTIC, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_cs_invocations_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_increment_cs_invocations_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_CS_INVOCATIONS, &_args, sizeof(_args)); \
} while(0);

#define libagx_increment_cs_invocations(_context, _grid, _barrier, grid, statistic, local_size_threads) do { \
   struct libagx_increment_cs_invocations_args _args = {grid, statistic, local_size_threads};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_INCREMENT_CS_INVOCATIONS, &_args, sizeof(_args)); \
} while(0);

#define libagx_write_u32s_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_write_u32s_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_WRITE_U32S, &_args, sizeof(_args)); \
} while(0);

#define libagx_write_u32s(_context, _grid, _barrier, p) do { \
   struct libagx_write_u32s_args _args = {p};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_WRITE_U32S, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_timestamp_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_copy_timestamp_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_TIMESTAMP, &_args, sizeof(_args)); \
} while(0);

#define libagx_copy_timestamp(_context, _grid, _barrier, dest, src) do { \
   struct libagx_copy_timestamp_args _args = {dest, src};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_COPY_TIMESTAMP, &_args, sizeof(_args)); \
} while(0);

#define libagx_write_u32_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_write_u32_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_WRITE_U32, &_args, sizeof(_args)); \
} while(0);

#define libagx_write_u32(_context, _grid, _barrier, address, value) do { \
   struct libagx_write_u32_args _args = {address, value};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_WRITE_U32, &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_setup_indirect_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_tess_setup_indirect_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_SETUP_INDIRECT, &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_setup_indirect(_context, _grid, _barrier, p, grids, vp, indirect, in_index_buffer, in_index_buffer_range_el, in_index_size_B, vertex_outputs, tcs_statistic) do { \
   struct libagx_tess_setup_indirect_args _args = {p, grids, vp, indirect, in_index_buffer, in_index_buffer_range_el, in_index_size_B, vertex_outputs, tcs_statistic};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_SETUP_INDIRECT, &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_isoline_struct(_context, _grid, _barrier, _data, mode__2) do { \
   struct libagx_tess_isoline_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_ISOLINE(mode__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_isoline(_context, _grid, _barrier, p, mode__2) do { \
   struct libagx_tess_isoline_args _args = {p};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_ISOLINE(mode__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_tri_struct(_context, _grid, _barrier, _data, mode__2) do { \
   struct libagx_tess_tri_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_TRI(mode__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_tri(_context, _grid, _barrier, p, mode__2) do { \
   struct libagx_tess_tri_args _args = {p};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_TRI(mode__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_quad_struct(_context, _grid, _barrier, _data, mode__2) do { \
   struct libagx_tess_quad_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_QUAD(mode__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_tess_quad(_context, _grid, _barrier, p, mode__2) do { \
   struct libagx_tess_quad_args _args = {p};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_TESS_QUAD(mode__2), &_args, sizeof(_args)); \
} while(0);

#define libagx_helper_struct(_context, _grid, _barrier, _data) do { \
   struct libagx_helper_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_HELPER, &_args, sizeof(_args)); \
} while(0);

#define libagx_helper(_context, _grid, _barrier) do { \
   struct libagx_helper_args _args = {};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, LIBAGX_HELPER, &_args, sizeof(_args)); \
} while(0);


extern const uint32_t *libagx_g13g[LIBAGX_NUM_PROGRAMS];
extern const uint32_t *libagx_g13x[LIBAGX_NUM_PROGRAMS];
