/* parsed class NVC06F */

#include "nvtypes.h"
#include "clc06f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc06f_SET_OBJECT {
    uint32_t nvclass;
    uint32_t engine;
};

static inline void
__NVC06F_SET_OBJECT(uint32_t *val_out, struct nv_nvc06f_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.nvclass < (1ULL << 16));
    val |= st.nvclass << 0;
    
    assert(st.engine < (1ULL << 5));
    val |= st.engine << 16;
    *val_out = val;
}

#define V_NVC06F_SET_OBJECT(val, args...) { \
    UNUSED uint32_t ENGINE_SW = NVC06F_SET_OBJECT_ENGINE_SW; \
    struct nv_nvc06f_SET_OBJECT __data = args; \
    __NVC06F_SET_OBJECT(&val, __data); \
}

#define VA_NVC06F_SET_OBJECT V_NVC06F_SET_OBJECT

#define P_NVC06F_SET_OBJECT(push, args...) do { \
    UNUSED uint32_t ENGINE_SW = NVC06F_SET_OBJECT_ENGINE_SW; \
    uint32_t nvk_p_ret; \
    V_NVC06F_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nvc06f_ILLEGAL {
    uint32_t handle;
};

static inline void
__NVC06F_ILLEGAL(uint32_t *val_out, struct nv_nvc06f_ILLEGAL st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC06F_ILLEGAL(val, args...) { \
    struct nv_nvc06f_ILLEGAL __data = { .handle = (args) }; \
    __NVC06F_ILLEGAL(&val, __data); \
}

#define VA_NVC06F_ILLEGAL V_NVC06F_ILLEGAL

#define P_NVC06F_ILLEGAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_ILLEGAL(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_ILLEGAL, nvk_p_ret); \
} while(0)

struct nv_nvc06f_NOP {
    uint32_t handle;
};

static inline void
__NVC06F_NOP(uint32_t *val_out, struct nv_nvc06f_NOP st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC06F_NOP(val, args...) { \
    struct nv_nvc06f_NOP __data = { .handle = (args) }; \
    __NVC06F_NOP(&val, __data); \
}

#define VA_NVC06F_NOP V_NVC06F_NOP

#define P_NVC06F_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_NOP, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SEMAPHOREA {
    uint32_t offset_upper;
};

static inline void
__NVC06F_SEMAPHOREA(uint32_t *val_out, struct nv_nvc06f_SEMAPHOREA st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC06F_SEMAPHOREA(val, args...) { \
    struct nv_nvc06f_SEMAPHOREA __data = { .offset_upper = (args) }; \
    __NVC06F_SEMAPHOREA(&val, __data); \
}

#define VA_NVC06F_SEMAPHOREA V_NVC06F_SEMAPHOREA

#define P_NVC06F_SEMAPHOREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_SEMAPHOREA(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SEMAPHOREA, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SEMAPHOREB {
    uint32_t offset_lower;
};

static inline void
__NVC06F_SEMAPHOREB(uint32_t *val_out, struct nv_nvc06f_SEMAPHOREB st)
{
    uint32_t val = 0;
    
    assert(st.offset_lower < (1ULL << 30));
    val |= st.offset_lower << 2;
    *val_out = val;
}

#define V_NVC06F_SEMAPHOREB(val, args...) { \
    struct nv_nvc06f_SEMAPHOREB __data = { .offset_lower = (args) }; \
    __NVC06F_SEMAPHOREB(&val, __data); \
}

#define VA_NVC06F_SEMAPHOREB V_NVC06F_SEMAPHOREB

#define P_NVC06F_SEMAPHOREB(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_SEMAPHOREB(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SEMAPHOREB, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SEMAPHOREC {
    uint32_t payload;
};

static inline void
__NVC06F_SEMAPHOREC(uint32_t *val_out, struct nv_nvc06f_SEMAPHOREC st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC06F_SEMAPHOREC(val, args...) { \
    struct nv_nvc06f_SEMAPHOREC __data = { .payload = (args) }; \
    __NVC06F_SEMAPHOREC(&val, __data); \
}

#define VA_NVC06F_SEMAPHOREC V_NVC06F_SEMAPHOREC

#define P_NVC06F_SEMAPHOREC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_SEMAPHOREC(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SEMAPHOREC, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SEMAPHORED {
    uint32_t operation;
    uint32_t acquire_switch;
    uint32_t release_wfi;
    uint32_t release_size;
    uint32_t reduction;
    uint32_t format;
};

static inline void
__NVC06F_SEMAPHORED(uint32_t *val_out, struct nv_nvc06f_SEMAPHORED st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 0;
    
    assert(st.acquire_switch < (1ULL << 1));
    val |= st.acquire_switch << 12;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.release_size < (1ULL << 1));
    val |= st.release_size << 24;
    
    assert(st.reduction < (1ULL << 4));
    val |= st.reduction << 27;
    
    assert(st.format < (1ULL << 1));
    val |= st.format << 31;
    *val_out = val;
}

#define V_NVC06F_SEMAPHORED(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC06F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC06F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVC06F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVC06F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVC06F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVC06F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVC06F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVC06F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC06F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVC06F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVC06F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVC06F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVC06F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVC06F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVC06F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVC06F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVC06F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVC06F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVC06F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVC06F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVC06F_SEMAPHORED_FORMAT_UNSIGNED; \
    struct nv_nvc06f_SEMAPHORED __data = args; \
    __NVC06F_SEMAPHORED(&val, __data); \
}

#define VA_NVC06F_SEMAPHORED V_NVC06F_SEMAPHORED

#define P_NVC06F_SEMAPHORED(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC06F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC06F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVC06F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVC06F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVC06F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVC06F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVC06F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVC06F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC06F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVC06F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVC06F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVC06F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVC06F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVC06F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVC06F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVC06F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVC06F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVC06F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVC06F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVC06F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVC06F_SEMAPHORED_FORMAT_UNSIGNED; \
    uint32_t nvk_p_ret; \
    V_NVC06F_SEMAPHORED(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SEMAPHORED, nvk_p_ret); \
} while(0)

struct nv_nvc06f_NON_STALL_INTERRUPT {
    uint32_t handle;
};

static inline void
__NVC06F_NON_STALL_INTERRUPT(uint32_t *val_out, struct nv_nvc06f_NON_STALL_INTERRUPT st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC06F_NON_STALL_INTERRUPT(val, args...) { \
    struct nv_nvc06f_NON_STALL_INTERRUPT __data = { .handle = (args) }; \
    __NVC06F_NON_STALL_INTERRUPT(&val, __data); \
}

#define VA_NVC06F_NON_STALL_INTERRUPT V_NVC06F_NON_STALL_INTERRUPT

#define P_NVC06F_NON_STALL_INTERRUPT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_NON_STALL_INTERRUPT(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_NON_STALL_INTERRUPT, nvk_p_ret); \
} while(0)

struct nv_nvc06f_FB_FLUSH {
    uint32_t handle;
};

static inline void
__NVC06F_FB_FLUSH(uint32_t *val_out, struct nv_nvc06f_FB_FLUSH st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC06F_FB_FLUSH(val, args...) { \
    struct nv_nvc06f_FB_FLUSH __data = { .handle = (args) }; \
    __NVC06F_FB_FLUSH(&val, __data); \
}

#define VA_NVC06F_FB_FLUSH V_NVC06F_FB_FLUSH

#define P_NVC06F_FB_FLUSH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_FB_FLUSH(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_FB_FLUSH, nvk_p_ret); \
} while(0)

struct nv_nvc06f_MEM_OP_A {
    uint32_t tlb_invalidate_cancel_target_client_unit_id;
    uint32_t tlb_invalidate_cancel_target_gpc_id;
    uint32_t tlb_invalidate_sysmembar;
    uint32_t tlb_invalidate_target_addr_lo;
};

static inline void
__NVC06F_MEM_OP_A(uint32_t *val_out, struct nv_nvc06f_MEM_OP_A st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_cancel_target_client_unit_id < (1ULL << 6));
    val |= st.tlb_invalidate_cancel_target_client_unit_id << 0;
    
    assert(st.tlb_invalidate_cancel_target_gpc_id < (1ULL << 5));
    val |= st.tlb_invalidate_cancel_target_gpc_id << 6;
    
    assert(st.tlb_invalidate_sysmembar < (1ULL << 1));
    val |= st.tlb_invalidate_sysmembar << 11;
    
    assert(st.tlb_invalidate_target_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_target_addr_lo << 12;
    *val_out = val;
}

#define V_NVC06F_MEM_OP_A(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_EN = NVC06F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_DIS = NVC06F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS; \
    struct nv_nvc06f_MEM_OP_A __data = args; \
    __NVC06F_MEM_OP_A(&val, __data); \
}

#define VA_NVC06F_MEM_OP_A V_NVC06F_MEM_OP_A

#define P_NVC06F_MEM_OP_A(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_EN = NVC06F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_DIS = NVC06F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS; \
    uint32_t nvk_p_ret; \
    V_NVC06F_MEM_OP_A(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_MEM_OP_A, nvk_p_ret); \
} while(0)

struct nv_nvc06f_MEM_OP_B {
    uint32_t tlb_invalidate_target_addr_hi;
};

static inline void
__NVC06F_MEM_OP_B(uint32_t *val_out, struct nv_nvc06f_MEM_OP_B st)
{
    uint32_t val = 0;
    
    val |= st.tlb_invalidate_target_addr_hi;
    *val_out = val;
}

#define V_NVC06F_MEM_OP_B(val, args...) { \
    struct nv_nvc06f_MEM_OP_B __data = { .tlb_invalidate_target_addr_hi = (args) }; \
    __NVC06F_MEM_OP_B(&val, __data); \
}

#define VA_NVC06F_MEM_OP_B V_NVC06F_MEM_OP_B

#define P_NVC06F_MEM_OP_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_MEM_OP_B(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_MEM_OP_B, nvk_p_ret); \
} while(0)

struct nv_nvc06f_MEM_OP_C {
    uint32_t membar_type;
    uint32_t tlb_invalidate_pdb;
    uint32_t tlb_invalidate_gpc;
    uint32_t tlb_invalidate_replay;
    uint32_t tlb_invalidate_ack_type;
    uint32_t tlb_invalidate_page_table_level;
    uint32_t tlb_invalidate_pdb_aperture;
    uint32_t tlb_invalidate_pdb_addr_lo;
};

static inline void
__NVC06F_MEM_OP_C(uint32_t *val_out, struct nv_nvc06f_MEM_OP_C st)
{
    uint32_t val = 0;
    
    assert(st.membar_type < (1ULL << 3));
    val |= st.membar_type << 0;
    
    assert(st.tlb_invalidate_pdb < (1ULL << 1));
    val |= st.tlb_invalidate_pdb << 0;
    
    assert(st.tlb_invalidate_gpc < (1ULL << 1));
    val |= st.tlb_invalidate_gpc << 1;
    
    assert(st.tlb_invalidate_replay < (1ULL << 3));
    val |= st.tlb_invalidate_replay << 2;
    
    assert(st.tlb_invalidate_ack_type < (1ULL << 2));
    val |= st.tlb_invalidate_ack_type << 5;
    
    assert(st.tlb_invalidate_page_table_level < (1ULL << 3));
    val |= st.tlb_invalidate_page_table_level << 7;
    
    assert(st.tlb_invalidate_pdb_aperture < (1ULL << 2));
    val |= st.tlb_invalidate_pdb_aperture << 10;
    
    assert(st.tlb_invalidate_pdb_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_pdb_addr_lo << 12;
    *val_out = val;
}

#define V_NVC06F_MEM_OP_C(val, args...) { \
    UNUSED uint32_t MEMBAR_TYPE_SYS_MEMBAR = NVC06F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR; \
    UNUSED uint32_t MEMBAR_TYPE_MEMBAR = NVC06F_MEM_OP_C_MEMBAR_TYPE_MEMBAR; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVC06F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVC06F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_NONE = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START_ACK_ALL = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_TARGETED = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_NONE = NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_GLOBALLY = NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_INTRANODE = NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_VID_MEM = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT; \
    struct nv_nvc06f_MEM_OP_C __data = args; \
    __NVC06F_MEM_OP_C(&val, __data); \
}

#define VA_NVC06F_MEM_OP_C V_NVC06F_MEM_OP_C

#define P_NVC06F_MEM_OP_C(push, args...) do { \
    UNUSED uint32_t MEMBAR_TYPE_SYS_MEMBAR = NVC06F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR; \
    UNUSED uint32_t MEMBAR_TYPE_MEMBAR = NVC06F_MEM_OP_C_MEMBAR_TYPE_MEMBAR; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVC06F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVC06F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_NONE = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START_ACK_ALL = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_TARGETED = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL = NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_NONE = NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_GLOBALLY = NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_INTRANODE = NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5 = NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_VID_MEM = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT = NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT; \
    uint32_t nvk_p_ret; \
    V_NVC06F_MEM_OP_C(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_MEM_OP_C, nvk_p_ret); \
} while(0)

struct nv_nvc06f_MEM_OP_D {
    uint32_t tlb_invalidate_pdb_addr_hi;
    uint32_t operation;
};

static inline void
__NVC06F_MEM_OP_D(uint32_t *val_out, struct nv_nvc06f_MEM_OP_D st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_pdb_addr_hi < (1ULL << 27));
    val |= st.tlb_invalidate_pdb_addr_hi << 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 27;
    *val_out = val;
}

#define V_NVC06F_MEM_OP_D(val, args...) { \
    UNUSED uint32_t OPERATION_MEMBAR = NVC06F_MEM_OP_D_OPERATION_MEMBAR; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVC06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE_TARGETED = NVC06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVC06F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVC06F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_INVALIDATE_CLEAN_LINES = NVC06F_MEM_OP_D_OPERATION_L2_INVALIDATE_CLEAN_LINES; \
    struct nv_nvc06f_MEM_OP_D __data = args; \
    __NVC06F_MEM_OP_D(&val, __data); \
}

#define VA_NVC06F_MEM_OP_D V_NVC06F_MEM_OP_D

#define P_NVC06F_MEM_OP_D(push, args...) do { \
    UNUSED uint32_t OPERATION_MEMBAR = NVC06F_MEM_OP_D_OPERATION_MEMBAR; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVC06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE_TARGETED = NVC06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVC06F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVC06F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_INVALIDATE_CLEAN_LINES = NVC06F_MEM_OP_D_OPERATION_L2_INVALIDATE_CLEAN_LINES; \
    uint32_t nvk_p_ret; \
    V_NVC06F_MEM_OP_D(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_MEM_OP_D, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SET_REFERENCE {
    uint32_t count;
};

static inline void
__NVC06F_SET_REFERENCE(uint32_t *val_out, struct nv_nvc06f_SET_REFERENCE st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVC06F_SET_REFERENCE(val, args...) { \
    struct nv_nvc06f_SET_REFERENCE __data = { .count = (args) }; \
    __NVC06F_SET_REFERENCE(&val, __data); \
}

#define VA_NVC06F_SET_REFERENCE V_NVC06F_SET_REFERENCE

#define P_NVC06F_SET_REFERENCE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_SET_REFERENCE(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SET_REFERENCE, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SYNCPOINTA {
    uint32_t payload;
};

static inline void
__NVC06F_SYNCPOINTA(uint32_t *val_out, struct nv_nvc06f_SYNCPOINTA st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC06F_SYNCPOINTA(val, args...) { \
    struct nv_nvc06f_SYNCPOINTA __data = { .payload = (args) }; \
    __NVC06F_SYNCPOINTA(&val, __data); \
}

#define VA_NVC06F_SYNCPOINTA V_NVC06F_SYNCPOINTA

#define P_NVC06F_SYNCPOINTA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_SYNCPOINTA(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SYNCPOINTA, nvk_p_ret); \
} while(0)

struct nv_nvc06f_SYNCPOINTB {
    uint32_t operation;
    uint32_t wait_switch;
    uint32_t syncpt_index;
};

static inline void
__NVC06F_SYNCPOINTB(uint32_t *val_out, struct nv_nvc06f_SYNCPOINTB st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 1));
    val |= st.operation << 0;
    
    assert(st.wait_switch < (1ULL << 1));
    val |= st.wait_switch << 4;
    
    assert(st.syncpt_index < (1ULL << 12));
    val |= st.syncpt_index << 8;
    *val_out = val;
}

#define V_NVC06F_SYNCPOINTB(val, args...) { \
    UNUSED uint32_t OPERATION_WAIT = NVC06F_SYNCPOINTB_OPERATION_WAIT; \
    UNUSED uint32_t OPERATION_INCR = NVC06F_SYNCPOINTB_OPERATION_INCR; \
    UNUSED uint32_t WAIT_SWITCH_DIS = NVC06F_SYNCPOINTB_WAIT_SWITCH_DIS; \
    UNUSED uint32_t WAIT_SWITCH_EN = NVC06F_SYNCPOINTB_WAIT_SWITCH_EN; \
    struct nv_nvc06f_SYNCPOINTB __data = args; \
    __NVC06F_SYNCPOINTB(&val, __data); \
}

#define VA_NVC06F_SYNCPOINTB V_NVC06F_SYNCPOINTB

#define P_NVC06F_SYNCPOINTB(push, args...) do { \
    UNUSED uint32_t OPERATION_WAIT = NVC06F_SYNCPOINTB_OPERATION_WAIT; \
    UNUSED uint32_t OPERATION_INCR = NVC06F_SYNCPOINTB_OPERATION_INCR; \
    UNUSED uint32_t WAIT_SWITCH_DIS = NVC06F_SYNCPOINTB_WAIT_SWITCH_DIS; \
    UNUSED uint32_t WAIT_SWITCH_EN = NVC06F_SYNCPOINTB_WAIT_SWITCH_EN; \
    uint32_t nvk_p_ret; \
    V_NVC06F_SYNCPOINTB(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_SYNCPOINTB, nvk_p_ret); \
} while(0)

struct nv_nvc06f_WFI {
    uint32_t scope;
};

static inline void
__NVC06F_WFI(uint32_t *val_out, struct nv_nvc06f_WFI st)
{
    uint32_t val = 0;
    
    assert(st.scope < (1ULL << 1));
    val |= st.scope << 0;
    *val_out = val;
}

#define V_NVC06F_WFI(val, args...) { \
    UNUSED uint32_t SCOPE_ALL = NVC06F_WFI_SCOPE_ALL; \
    struct nv_nvc06f_WFI __data = { .scope = (args) }; \
    __NVC06F_WFI(&val, __data); \
}

#define VA_NVC06F_WFI V_NVC06F_WFI

#define P_NVC06F_WFI(push, args...) do { \
    UNUSED uint32_t SCOPE_ALL = NVC06F_WFI_SCOPE_ALL; \
    uint32_t nvk_p_ret; \
    V_NVC06F_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc06f_CRC_CHECK {
    uint32_t value;
};

static inline void
__NVC06F_CRC_CHECK(uint32_t *val_out, struct nv_nvc06f_CRC_CHECK st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC06F_CRC_CHECK(val, args...) { \
    struct nv_nvc06f_CRC_CHECK __data = { .value = (args) }; \
    __NVC06F_CRC_CHECK(&val, __data); \
}

#define VA_NVC06F_CRC_CHECK V_NVC06F_CRC_CHECK

#define P_NVC06F_CRC_CHECK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC06F_CRC_CHECK(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_CRC_CHECK, nvk_p_ret); \
} while(0)

struct nv_nvc06f_YIELD {
    uint32_t op;
};

static inline void
__NVC06F_YIELD(uint32_t *val_out, struct nv_nvc06f_YIELD st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    *val_out = val;
}

#define V_NVC06F_YIELD(val, args...) { \
    UNUSED uint32_t OP_NOP = NVC06F_YIELD_OP_NOP; \
    UNUSED uint32_t OP_PBDMA_TIMESLICE = NVC06F_YIELD_OP_PBDMA_TIMESLICE; \
    UNUSED uint32_t OP_RUNLIST_TIMESLICE = NVC06F_YIELD_OP_RUNLIST_TIMESLICE; \
    UNUSED uint32_t OP_TSG = NVC06F_YIELD_OP_TSG; \
    struct nv_nvc06f_YIELD __data = { .op = (args) }; \
    __NVC06F_YIELD(&val, __data); \
}

#define VA_NVC06F_YIELD V_NVC06F_YIELD

#define P_NVC06F_YIELD(push, args...) do { \
    UNUSED uint32_t OP_NOP = NVC06F_YIELD_OP_NOP; \
    UNUSED uint32_t OP_PBDMA_TIMESLICE = NVC06F_YIELD_OP_PBDMA_TIMESLICE; \
    UNUSED uint32_t OP_RUNLIST_TIMESLICE = NVC06F_YIELD_OP_RUNLIST_TIMESLICE; \
    UNUSED uint32_t OP_TSG = NVC06F_YIELD_OP_TSG; \
    uint32_t nvk_p_ret; \
    V_NVC06F_YIELD(nvk_p_ret, args); \
    nv_push_val(push, NVC06F_YIELD, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC06F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
