/* parsed class NVA040 */

#include "nvtypes.h"
#include "cla040.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nva040_SET_OBJECT {
    uint32_t class_id;
    uint32_t engine_id;
};

static inline void
__NVA040_SET_OBJECT(uint32_t *val_out, struct nv_nva040_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.class_id < (1ULL << 16));
    val |= st.class_id << 0;
    
    assert(st.engine_id < (1ULL << 5));
    val |= st.engine_id << 16;
    *val_out = val;
}

#define V_NVA040_SET_OBJECT(val, args...) { \
    struct nv_nva040_SET_OBJECT __data = args; \
    __NVA040_SET_OBJECT(&val, __data); \
}

#define VA_NVA040_SET_OBJECT V_NVA040_SET_OBJECT

#define P_NVA040_SET_OBJECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nva040_NO_OPERATION {
    uint32_t v;
};

static inline void
__NVA040_NO_OPERATION(uint32_t *val_out, struct nv_nva040_NO_OPERATION st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_NO_OPERATION(val, args...) { \
    struct nv_nva040_NO_OPERATION __data = { .v = (args) }; \
    __NVA040_NO_OPERATION(&val, __data); \
}

#define VA_NVA040_NO_OPERATION V_NVA040_NO_OPERATION

#define P_NVA040_NO_OPERATION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_NO_OPERATION(nvk_p_ret, args); \
    nv_push_val(push, NVA040_NO_OPERATION, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_NOTIFY_A {
    uint32_t address_upper;
};

static inline void
__NVA040_SET_NOTIFY_A(uint32_t *val_out, struct nv_nva040_SET_NOTIFY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA040_SET_NOTIFY_A(val, args...) { \
    struct nv_nva040_SET_NOTIFY_A __data = { .address_upper = (args) }; \
    __NVA040_SET_NOTIFY_A(&val, __data); \
}

#define VA_NVA040_SET_NOTIFY_A V_NVA040_SET_NOTIFY_A

#define P_NVA040_SET_NOTIFY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_NOTIFY_A(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_NOTIFY_A, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_NOTIFY_B {
    uint32_t address_lower;
};

static inline void
__NVA040_SET_NOTIFY_B(uint32_t *val_out, struct nv_nva040_SET_NOTIFY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA040_SET_NOTIFY_B(val, args...) { \
    struct nv_nva040_SET_NOTIFY_B __data = { .address_lower = (args) }; \
    __NVA040_SET_NOTIFY_B(&val, __data); \
}

#define VA_NVA040_SET_NOTIFY_B V_NVA040_SET_NOTIFY_B

#define P_NVA040_SET_NOTIFY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_NOTIFY_B(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_NOTIFY_B, nvk_p_ret); \
} while(0)

struct nv_nva040_NOTIFY {
    uint32_t type;
};

static inline void
__NVA040_NOTIFY(uint32_t *val_out, struct nv_nva040_NOTIFY st)
{
    uint32_t val = 0;
    
    val |= st.type;
    *val_out = val;
}

#define V_NVA040_NOTIFY(val, args...) { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NVA040_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NVA040_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    struct nv_nva040_NOTIFY __data = { .type = (args) }; \
    __NVA040_NOTIFY(&val, __data); \
}

#define VA_NVA040_NOTIFY V_NVA040_NOTIFY

#define P_NVA040_NOTIFY(push, args...) do { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NVA040_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NVA040_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    uint32_t nvk_p_ret; \
    V_NVA040_NOTIFY(nvk_p_ret, args); \
    nv_push_val(push, NVA040_NOTIFY, nvk_p_ret); \
} while(0)

struct nv_nva040_WAIT_FOR_IDLE {
    uint32_t v;
};

static inline void
__NVA040_WAIT_FOR_IDLE(uint32_t *val_out, struct nv_nva040_WAIT_FOR_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_WAIT_FOR_IDLE(val, args...) { \
    struct nv_nva040_WAIT_FOR_IDLE __data = { .v = (args) }; \
    __NVA040_WAIT_FOR_IDLE(&val, __data); \
}

#define VA_NVA040_WAIT_FOR_IDLE V_NVA040_WAIT_FOR_IDLE

#define P_NVA040_WAIT_FOR_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_WAIT_FOR_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NVA040_WAIT_FOR_IDLE, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NVA040_SET_GLOBAL_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA040_SET_GLOBAL_RENDER_ENABLE_A(val, args...) { \
    struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NVA040_SET_GLOBAL_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVA040_SET_GLOBAL_RENDER_ENABLE_A V_NVA040_SET_GLOBAL_RENDER_ENABLE_A

#define P_NVA040_SET_GLOBAL_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_GLOBAL_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_GLOBAL_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NVA040_SET_GLOBAL_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA040_SET_GLOBAL_RENDER_ENABLE_B(val, args...) { \
    struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NVA040_SET_GLOBAL_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVA040_SET_GLOBAL_RENDER_ENABLE_B V_NVA040_SET_GLOBAL_RENDER_ENABLE_B

#define P_NVA040_SET_GLOBAL_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_GLOBAL_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_GLOBAL_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVA040_SET_GLOBAL_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA040_SET_GLOBAL_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nva040_SET_GLOBAL_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVA040_SET_GLOBAL_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVA040_SET_GLOBAL_RENDER_ENABLE_C V_NVA040_SET_GLOBAL_RENDER_ENABLE_C

#define P_NVA040_SET_GLOBAL_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA040_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_GLOBAL_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_GLOBAL_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nva040_SEND_GO_IDLE {
    uint32_t v;
};

static inline void
__NVA040_SEND_GO_IDLE(uint32_t *val_out, struct nv_nva040_SEND_GO_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SEND_GO_IDLE(val, args...) { \
    struct nv_nva040_SEND_GO_IDLE __data = { .v = (args) }; \
    __NVA040_SEND_GO_IDLE(&val, __data); \
}

#define VA_NVA040_SEND_GO_IDLE V_NVA040_SEND_GO_IDLE

#define P_NVA040_SEND_GO_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SEND_GO_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SEND_GO_IDLE, nvk_p_ret); \
} while(0)

struct nv_nva040_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NVA040_PM_TRIGGER(uint32_t *val_out, struct nv_nva040_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_PM_TRIGGER(val, args...) { \
    struct nv_nva040_PM_TRIGGER __data = { .v = (args) }; \
    __NVA040_PM_TRIGGER(&val, __data); \
}

#define VA_NVA040_PM_TRIGGER V_NVA040_PM_TRIGGER

#define P_NVA040_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NVA040_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nva040_PM_TRIGGER_WFI {
    uint32_t v;
};

static inline void
__NVA040_PM_TRIGGER_WFI(uint32_t *val_out, struct nv_nva040_PM_TRIGGER_WFI st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_PM_TRIGGER_WFI(val, args...) { \
    struct nv_nva040_PM_TRIGGER_WFI __data = { .v = (args) }; \
    __NVA040_PM_TRIGGER_WFI(&val, __data); \
}

#define VA_NVA040_PM_TRIGGER_WFI V_NVA040_PM_TRIGGER_WFI

#define P_NVA040_PM_TRIGGER_WFI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_PM_TRIGGER_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA040_PM_TRIGGER_WFI, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_INSTRUMENTATION_METHOD_HEADER {
    uint32_t v;
};

static inline void
__NVA040_SET_INSTRUMENTATION_METHOD_HEADER(uint32_t *val_out, struct nv_nva040_SET_INSTRUMENTATION_METHOD_HEADER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_INSTRUMENTATION_METHOD_HEADER(val, args...) { \
    struct nv_nva040_SET_INSTRUMENTATION_METHOD_HEADER __data = { .v = (args) }; \
    __NVA040_SET_INSTRUMENTATION_METHOD_HEADER(&val, __data); \
}

#define VA_NVA040_SET_INSTRUMENTATION_METHOD_HEADER V_NVA040_SET_INSTRUMENTATION_METHOD_HEADER

#define P_NVA040_SET_INSTRUMENTATION_METHOD_HEADER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_INSTRUMENTATION_METHOD_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_INSTRUMENTATION_METHOD_HEADER, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_INSTRUMENTATION_METHOD_DATA {
    uint32_t v;
};

static inline void
__NVA040_SET_INSTRUMENTATION_METHOD_DATA(uint32_t *val_out, struct nv_nva040_SET_INSTRUMENTATION_METHOD_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_INSTRUMENTATION_METHOD_DATA(val, args...) { \
    struct nv_nva040_SET_INSTRUMENTATION_METHOD_DATA __data = { .v = (args) }; \
    __NVA040_SET_INSTRUMENTATION_METHOD_DATA(&val, __data); \
}

#define VA_NVA040_SET_INSTRUMENTATION_METHOD_DATA V_NVA040_SET_INSTRUMENTATION_METHOD_DATA

#define P_NVA040_SET_INSTRUMENTATION_METHOD_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_INSTRUMENTATION_METHOD_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_INSTRUMENTATION_METHOD_DATA, nvk_p_ret); \
} while(0)

struct nv_nva040_LINE_LENGTH_IN {
    uint32_t value;
};

static inline void
__NVA040_LINE_LENGTH_IN(uint32_t *val_out, struct nv_nva040_LINE_LENGTH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA040_LINE_LENGTH_IN(val, args...) { \
    struct nv_nva040_LINE_LENGTH_IN __data = { .value = (args) }; \
    __NVA040_LINE_LENGTH_IN(&val, __data); \
}

#define VA_NVA040_LINE_LENGTH_IN V_NVA040_LINE_LENGTH_IN

#define P_NVA040_LINE_LENGTH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_LINE_LENGTH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVA040_LINE_LENGTH_IN, nvk_p_ret); \
} while(0)

struct nv_nva040_LINE_COUNT {
    uint32_t value;
};

static inline void
__NVA040_LINE_COUNT(uint32_t *val_out, struct nv_nva040_LINE_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA040_LINE_COUNT(val, args...) { \
    struct nv_nva040_LINE_COUNT __data = { .value = (args) }; \
    __NVA040_LINE_COUNT(&val, __data); \
}

#define VA_NVA040_LINE_COUNT V_NVA040_LINE_COUNT

#define P_NVA040_LINE_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_LINE_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVA040_LINE_COUNT, nvk_p_ret); \
} while(0)

struct nv_nva040_OFFSET_OUT_UPPER {
    uint32_t value;
};

static inline void
__NVA040_OFFSET_OUT_UPPER(uint32_t *val_out, struct nv_nva040_OFFSET_OUT_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.value < (1ULL << 8));
    val |= st.value << 0;
    *val_out = val;
}

#define V_NVA040_OFFSET_OUT_UPPER(val, args...) { \
    struct nv_nva040_OFFSET_OUT_UPPER __data = { .value = (args) }; \
    __NVA040_OFFSET_OUT_UPPER(&val, __data); \
}

#define VA_NVA040_OFFSET_OUT_UPPER V_NVA040_OFFSET_OUT_UPPER

#define P_NVA040_OFFSET_OUT_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_OFFSET_OUT_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVA040_OFFSET_OUT_UPPER, nvk_p_ret); \
} while(0)

struct nv_nva040_OFFSET_OUT {
    uint32_t value;
};

static inline void
__NVA040_OFFSET_OUT(uint32_t *val_out, struct nv_nva040_OFFSET_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA040_OFFSET_OUT(val, args...) { \
    struct nv_nva040_OFFSET_OUT __data = { .value = (args) }; \
    __NVA040_OFFSET_OUT(&val, __data); \
}

#define VA_NVA040_OFFSET_OUT V_NVA040_OFFSET_OUT

#define P_NVA040_OFFSET_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_OFFSET_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVA040_OFFSET_OUT, nvk_p_ret); \
} while(0)

struct nv_nva040_PITCH_OUT {
    uint32_t value;
};

static inline void
__NVA040_PITCH_OUT(uint32_t *val_out, struct nv_nva040_PITCH_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA040_PITCH_OUT(val, args...) { \
    struct nv_nva040_PITCH_OUT __data = { .value = (args) }; \
    __NVA040_PITCH_OUT(&val, __data); \
}

#define VA_NVA040_PITCH_OUT V_NVA040_PITCH_OUT

#define P_NVA040_PITCH_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_PITCH_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVA040_PITCH_OUT, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
};

static inline void
__NVA040_SET_DST_BLOCK_SIZE(uint32_t *val_out, struct nv_nva040_SET_DST_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NVA040_SET_DST_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA040_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA040_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    struct nv_nva040_SET_DST_BLOCK_SIZE __data = args; \
    __NVA040_SET_DST_BLOCK_SIZE(&val, __data); \
}

#define VA_NVA040_SET_DST_BLOCK_SIZE V_NVA040_SET_DST_BLOCK_SIZE

#define P_NVA040_SET_DST_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA040_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA040_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA040_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_WIDTH {
    uint32_t v;
};

static inline void
__NVA040_SET_DST_WIDTH(uint32_t *val_out, struct nv_nva040_SET_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_DST_WIDTH(val, args...) { \
    struct nv_nva040_SET_DST_WIDTH __data = { .v = (args) }; \
    __NVA040_SET_DST_WIDTH(&val, __data); \
}

#define VA_NVA040_SET_DST_WIDTH V_NVA040_SET_DST_WIDTH

#define P_NVA040_SET_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NVA040_SET_DST_HEIGHT(uint32_t *val_out, struct nv_nva040_SET_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_DST_HEIGHT(val, args...) { \
    struct nv_nva040_SET_DST_HEIGHT __data = { .v = (args) }; \
    __NVA040_SET_DST_HEIGHT(&val, __data); \
}

#define VA_NVA040_SET_DST_HEIGHT V_NVA040_SET_DST_HEIGHT

#define P_NVA040_SET_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_DEPTH {
    uint32_t v;
};

static inline void
__NVA040_SET_DST_DEPTH(uint32_t *val_out, struct nv_nva040_SET_DST_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_DST_DEPTH(val, args...) { \
    struct nv_nva040_SET_DST_DEPTH __data = { .v = (args) }; \
    __NVA040_SET_DST_DEPTH(&val, __data); \
}

#define VA_NVA040_SET_DST_DEPTH V_NVA040_SET_DST_DEPTH

#define P_NVA040_SET_DST_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_LAYER {
    uint32_t v;
};

static inline void
__NVA040_SET_DST_LAYER(uint32_t *val_out, struct nv_nva040_SET_DST_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_DST_LAYER(val, args...) { \
    struct nv_nva040_SET_DST_LAYER __data = { .v = (args) }; \
    __NVA040_SET_DST_LAYER(&val, __data); \
}

#define VA_NVA040_SET_DST_LAYER V_NVA040_SET_DST_LAYER

#define P_NVA040_SET_DST_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_LAYER, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_ORIGIN_BYTES_X {
    uint32_t v;
};

static inline void
__NVA040_SET_DST_ORIGIN_BYTES_X(uint32_t *val_out, struct nv_nva040_SET_DST_ORIGIN_BYTES_X st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 20));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA040_SET_DST_ORIGIN_BYTES_X(val, args...) { \
    struct nv_nva040_SET_DST_ORIGIN_BYTES_X __data = { .v = (args) }; \
    __NVA040_SET_DST_ORIGIN_BYTES_X(&val, __data); \
}

#define VA_NVA040_SET_DST_ORIGIN_BYTES_X V_NVA040_SET_DST_ORIGIN_BYTES_X

#define P_NVA040_SET_DST_ORIGIN_BYTES_X(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_ORIGIN_BYTES_X(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_ORIGIN_BYTES_X, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_DST_ORIGIN_SAMPLES_Y {
    uint32_t v;
};

static inline void
__NVA040_SET_DST_ORIGIN_SAMPLES_Y(uint32_t *val_out, struct nv_nva040_SET_DST_ORIGIN_SAMPLES_Y st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA040_SET_DST_ORIGIN_SAMPLES_Y(val, args...) { \
    struct nv_nva040_SET_DST_ORIGIN_SAMPLES_Y __data = { .v = (args) }; \
    __NVA040_SET_DST_ORIGIN_SAMPLES_Y(&val, __data); \
}

#define VA_NVA040_SET_DST_ORIGIN_SAMPLES_Y V_NVA040_SET_DST_ORIGIN_SAMPLES_Y

#define P_NVA040_SET_DST_ORIGIN_SAMPLES_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_DST_ORIGIN_SAMPLES_Y(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_DST_ORIGIN_SAMPLES_Y, nvk_p_ret); \
} while(0)

struct nv_nva040_LAUNCH_DMA {
    uint32_t dst_memory_layout;
    uint32_t completion_type;
    uint32_t interrupt_type;
    uint32_t semaphore_struct_size;
    uint32_t reduction_enable;
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t sysmembar_disable;
};

static inline void
__NVA040_LAUNCH_DMA(uint32_t *val_out, struct nv_nva040_LAUNCH_DMA st)
{
    uint32_t val = 0;
    
    assert(st.dst_memory_layout < (1ULL << 1));
    val |= st.dst_memory_layout << 0;
    
    assert(st.completion_type < (1ULL << 2));
    val |= st.completion_type << 4;
    
    assert(st.interrupt_type < (1ULL << 2));
    val |= st.interrupt_type << 8;
    
    assert(st.semaphore_struct_size < (1ULL << 1));
    val |= st.semaphore_struct_size << 12;
    
    assert(st.reduction_enable < (1ULL << 1));
    val |= st.reduction_enable << 1;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 13;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 2;
    
    assert(st.sysmembar_disable < (1ULL << 1));
    val |= st.sysmembar_disable << 6;
    *val_out = val;
}

#define V_NVA040_LAUNCH_DMA(val, args...) { \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVA040_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVA040_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_DISABLE = NVA040_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_ONLY = NVA040_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY; \
    UNUSED uint32_t COMPLETION_TYPE_RELEASE_SEMAPHORE = NVA040_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVA040_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_INTERRUPT = NVA040_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = NVA040_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_ONE_WORD = NVA040_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVA040_LAUNCH_DMA_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVA040_LAUNCH_DMA_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVA040_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVA040_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_FALSE = NVA040_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_TRUE = NVA040_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE; \
    struct nv_nva040_LAUNCH_DMA __data = args; \
    __NVA040_LAUNCH_DMA(&val, __data); \
}

#define VA_NVA040_LAUNCH_DMA V_NVA040_LAUNCH_DMA

#define P_NVA040_LAUNCH_DMA(push, args...) do { \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVA040_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVA040_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_DISABLE = NVA040_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_ONLY = NVA040_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY; \
    UNUSED uint32_t COMPLETION_TYPE_RELEASE_SEMAPHORE = NVA040_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVA040_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_INTERRUPT = NVA040_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = NVA040_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_ONE_WORD = NVA040_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVA040_LAUNCH_DMA_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVA040_LAUNCH_DMA_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVA040_LAUNCH_DMA_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVA040_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVA040_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_FALSE = NVA040_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_TRUE = NVA040_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA040_LAUNCH_DMA(nvk_p_ret, args); \
    nv_push_val(push, NVA040_LAUNCH_DMA, nvk_p_ret); \
} while(0)

struct nv_nva040_LOAD_INLINE_DATA {
    uint32_t v;
};

static inline void
__NVA040_LOAD_INLINE_DATA(uint32_t *val_out, struct nv_nva040_LOAD_INLINE_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_LOAD_INLINE_DATA(val, args...) { \
    struct nv_nva040_LOAD_INLINE_DATA __data = { .v = (args) }; \
    __NVA040_LOAD_INLINE_DATA(&val, __data); \
}

#define VA_NVA040_LOAD_INLINE_DATA V_NVA040_LOAD_INLINE_DATA

#define P_NVA040_LOAD_INLINE_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_LOAD_INLINE_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVA040_LOAD_INLINE_DATA, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SEMAPHORE_A {
    uint32_t offset_upper;
};

static inline void
__NVA040_SET_I2M_SEMAPHORE_A(uint32_t *val_out, struct nv_nva040_SET_I2M_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SEMAPHORE_A(val, args...) { \
    struct nv_nva040_SET_I2M_SEMAPHORE_A __data = { .offset_upper = (args) }; \
    __NVA040_SET_I2M_SEMAPHORE_A(&val, __data); \
}

#define VA_NVA040_SET_I2M_SEMAPHORE_A V_NVA040_SET_I2M_SEMAPHORE_A

#define P_NVA040_SET_I2M_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SEMAPHORE_B {
    uint32_t offset_lower;
};

static inline void
__NVA040_SET_I2M_SEMAPHORE_B(uint32_t *val_out, struct nv_nva040_SET_I2M_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SEMAPHORE_B(val, args...) { \
    struct nv_nva040_SET_I2M_SEMAPHORE_B __data = { .offset_lower = (args) }; \
    __NVA040_SET_I2M_SEMAPHORE_B(&val, __data); \
}

#define VA_NVA040_SET_I2M_SEMAPHORE_B V_NVA040_SET_I2M_SEMAPHORE_B

#define P_NVA040_SET_I2M_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVA040_SET_I2M_SEMAPHORE_C(uint32_t *val_out, struct nv_nva040_SET_I2M_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SEMAPHORE_C(val, args...) { \
    struct nv_nva040_SET_I2M_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVA040_SET_I2M_SEMAPHORE_C(&val, __data); \
}

#define VA_NVA040_SET_I2M_SEMAPHORE_C V_NVA040_SET_I2M_SEMAPHORE_C

#define P_NVA040_SET_I2M_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SPARE_NOOP00 {
    uint32_t v;
};

static inline void
__NVA040_SET_I2M_SPARE_NOOP00(uint32_t *val_out, struct nv_nva040_SET_I2M_SPARE_NOOP00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SPARE_NOOP00(val, args...) { \
    struct nv_nva040_SET_I2M_SPARE_NOOP00 __data = { .v = (args) }; \
    __NVA040_SET_I2M_SPARE_NOOP00(&val, __data); \
}

#define VA_NVA040_SET_I2M_SPARE_NOOP00 V_NVA040_SET_I2M_SPARE_NOOP00

#define P_NVA040_SET_I2M_SPARE_NOOP00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SPARE_NOOP00(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SPARE_NOOP00, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SPARE_NOOP01 {
    uint32_t v;
};

static inline void
__NVA040_SET_I2M_SPARE_NOOP01(uint32_t *val_out, struct nv_nva040_SET_I2M_SPARE_NOOP01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SPARE_NOOP01(val, args...) { \
    struct nv_nva040_SET_I2M_SPARE_NOOP01 __data = { .v = (args) }; \
    __NVA040_SET_I2M_SPARE_NOOP01(&val, __data); \
}

#define VA_NVA040_SET_I2M_SPARE_NOOP01 V_NVA040_SET_I2M_SPARE_NOOP01

#define P_NVA040_SET_I2M_SPARE_NOOP01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SPARE_NOOP01(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SPARE_NOOP01, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SPARE_NOOP02 {
    uint32_t v;
};

static inline void
__NVA040_SET_I2M_SPARE_NOOP02(uint32_t *val_out, struct nv_nva040_SET_I2M_SPARE_NOOP02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SPARE_NOOP02(val, args...) { \
    struct nv_nva040_SET_I2M_SPARE_NOOP02 __data = { .v = (args) }; \
    __NVA040_SET_I2M_SPARE_NOOP02(&val, __data); \
}

#define VA_NVA040_SET_I2M_SPARE_NOOP02 V_NVA040_SET_I2M_SPARE_NOOP02

#define P_NVA040_SET_I2M_SPARE_NOOP02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SPARE_NOOP02(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SPARE_NOOP02, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_I2M_SPARE_NOOP03 {
    uint32_t v;
};

static inline void
__NVA040_SET_I2M_SPARE_NOOP03(uint32_t *val_out, struct nv_nva040_SET_I2M_SPARE_NOOP03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_I2M_SPARE_NOOP03(val, args...) { \
    struct nv_nva040_SET_I2M_SPARE_NOOP03 __data = { .v = (args) }; \
    __NVA040_SET_I2M_SPARE_NOOP03(&val, __data); \
}

#define VA_NVA040_SET_I2M_SPARE_NOOP03 V_NVA040_SET_I2M_SPARE_NOOP03

#define P_NVA040_SET_I2M_SPARE_NOOP03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_I2M_SPARE_NOOP03(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_I2M_SPARE_NOOP03, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON00 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON00(uint32_t *val_out, struct nv_nva040_SET_FALCON00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON00(val, args...) { \
    struct nv_nva040_SET_FALCON00 __data = { .v = (args) }; \
    __NVA040_SET_FALCON00(&val, __data); \
}

#define VA_NVA040_SET_FALCON00 V_NVA040_SET_FALCON00

#define P_NVA040_SET_FALCON00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON00(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON00, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON01 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON01(uint32_t *val_out, struct nv_nva040_SET_FALCON01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON01(val, args...) { \
    struct nv_nva040_SET_FALCON01 __data = { .v = (args) }; \
    __NVA040_SET_FALCON01(&val, __data); \
}

#define VA_NVA040_SET_FALCON01 V_NVA040_SET_FALCON01

#define P_NVA040_SET_FALCON01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON01(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON01, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON02 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON02(uint32_t *val_out, struct nv_nva040_SET_FALCON02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON02(val, args...) { \
    struct nv_nva040_SET_FALCON02 __data = { .v = (args) }; \
    __NVA040_SET_FALCON02(&val, __data); \
}

#define VA_NVA040_SET_FALCON02 V_NVA040_SET_FALCON02

#define P_NVA040_SET_FALCON02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON02(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON02, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON03 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON03(uint32_t *val_out, struct nv_nva040_SET_FALCON03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON03(val, args...) { \
    struct nv_nva040_SET_FALCON03 __data = { .v = (args) }; \
    __NVA040_SET_FALCON03(&val, __data); \
}

#define VA_NVA040_SET_FALCON03 V_NVA040_SET_FALCON03

#define P_NVA040_SET_FALCON03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON03(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON03, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON04 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON04(uint32_t *val_out, struct nv_nva040_SET_FALCON04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON04(val, args...) { \
    struct nv_nva040_SET_FALCON04 __data = { .v = (args) }; \
    __NVA040_SET_FALCON04(&val, __data); \
}

#define VA_NVA040_SET_FALCON04 V_NVA040_SET_FALCON04

#define P_NVA040_SET_FALCON04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON04(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON04, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON05 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON05(uint32_t *val_out, struct nv_nva040_SET_FALCON05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON05(val, args...) { \
    struct nv_nva040_SET_FALCON05 __data = { .v = (args) }; \
    __NVA040_SET_FALCON05(&val, __data); \
}

#define VA_NVA040_SET_FALCON05 V_NVA040_SET_FALCON05

#define P_NVA040_SET_FALCON05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON05(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON05, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON06 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON06(uint32_t *val_out, struct nv_nva040_SET_FALCON06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON06(val, args...) { \
    struct nv_nva040_SET_FALCON06 __data = { .v = (args) }; \
    __NVA040_SET_FALCON06(&val, __data); \
}

#define VA_NVA040_SET_FALCON06 V_NVA040_SET_FALCON06

#define P_NVA040_SET_FALCON06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON06(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON06, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON07 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON07(uint32_t *val_out, struct nv_nva040_SET_FALCON07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON07(val, args...) { \
    struct nv_nva040_SET_FALCON07 __data = { .v = (args) }; \
    __NVA040_SET_FALCON07(&val, __data); \
}

#define VA_NVA040_SET_FALCON07 V_NVA040_SET_FALCON07

#define P_NVA040_SET_FALCON07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON07(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON07, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON08 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON08(uint32_t *val_out, struct nv_nva040_SET_FALCON08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON08(val, args...) { \
    struct nv_nva040_SET_FALCON08 __data = { .v = (args) }; \
    __NVA040_SET_FALCON08(&val, __data); \
}

#define VA_NVA040_SET_FALCON08 V_NVA040_SET_FALCON08

#define P_NVA040_SET_FALCON08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON08(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON08, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON09 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON09(uint32_t *val_out, struct nv_nva040_SET_FALCON09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON09(val, args...) { \
    struct nv_nva040_SET_FALCON09 __data = { .v = (args) }; \
    __NVA040_SET_FALCON09(&val, __data); \
}

#define VA_NVA040_SET_FALCON09 V_NVA040_SET_FALCON09

#define P_NVA040_SET_FALCON09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON09(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON09, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON10 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON10(uint32_t *val_out, struct nv_nva040_SET_FALCON10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON10(val, args...) { \
    struct nv_nva040_SET_FALCON10 __data = { .v = (args) }; \
    __NVA040_SET_FALCON10(&val, __data); \
}

#define VA_NVA040_SET_FALCON10 V_NVA040_SET_FALCON10

#define P_NVA040_SET_FALCON10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON10(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON10, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON11 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON11(uint32_t *val_out, struct nv_nva040_SET_FALCON11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON11(val, args...) { \
    struct nv_nva040_SET_FALCON11 __data = { .v = (args) }; \
    __NVA040_SET_FALCON11(&val, __data); \
}

#define VA_NVA040_SET_FALCON11 V_NVA040_SET_FALCON11

#define P_NVA040_SET_FALCON11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON11(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON11, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON12 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON12(uint32_t *val_out, struct nv_nva040_SET_FALCON12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON12(val, args...) { \
    struct nv_nva040_SET_FALCON12 __data = { .v = (args) }; \
    __NVA040_SET_FALCON12(&val, __data); \
}

#define VA_NVA040_SET_FALCON12 V_NVA040_SET_FALCON12

#define P_NVA040_SET_FALCON12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON12(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON12, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON13 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON13(uint32_t *val_out, struct nv_nva040_SET_FALCON13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON13(val, args...) { \
    struct nv_nva040_SET_FALCON13 __data = { .v = (args) }; \
    __NVA040_SET_FALCON13(&val, __data); \
}

#define VA_NVA040_SET_FALCON13 V_NVA040_SET_FALCON13

#define P_NVA040_SET_FALCON13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON13(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON13, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON14 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON14(uint32_t *val_out, struct nv_nva040_SET_FALCON14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON14(val, args...) { \
    struct nv_nva040_SET_FALCON14 __data = { .v = (args) }; \
    __NVA040_SET_FALCON14(&val, __data); \
}

#define VA_NVA040_SET_FALCON14 V_NVA040_SET_FALCON14

#define P_NVA040_SET_FALCON14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON14(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON14, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON15 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON15(uint32_t *val_out, struct nv_nva040_SET_FALCON15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON15(val, args...) { \
    struct nv_nva040_SET_FALCON15 __data = { .v = (args) }; \
    __NVA040_SET_FALCON15(&val, __data); \
}

#define VA_NVA040_SET_FALCON15 V_NVA040_SET_FALCON15

#define P_NVA040_SET_FALCON15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON15(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON15, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON16 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON16(uint32_t *val_out, struct nv_nva040_SET_FALCON16 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON16(val, args...) { \
    struct nv_nva040_SET_FALCON16 __data = { .v = (args) }; \
    __NVA040_SET_FALCON16(&val, __data); \
}

#define VA_NVA040_SET_FALCON16 V_NVA040_SET_FALCON16

#define P_NVA040_SET_FALCON16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON16(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON16, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON17 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON17(uint32_t *val_out, struct nv_nva040_SET_FALCON17 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON17(val, args...) { \
    struct nv_nva040_SET_FALCON17 __data = { .v = (args) }; \
    __NVA040_SET_FALCON17(&val, __data); \
}

#define VA_NVA040_SET_FALCON17 V_NVA040_SET_FALCON17

#define P_NVA040_SET_FALCON17(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON17(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON17, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON18 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON18(uint32_t *val_out, struct nv_nva040_SET_FALCON18 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON18(val, args...) { \
    struct nv_nva040_SET_FALCON18 __data = { .v = (args) }; \
    __NVA040_SET_FALCON18(&val, __data); \
}

#define VA_NVA040_SET_FALCON18 V_NVA040_SET_FALCON18

#define P_NVA040_SET_FALCON18(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON18(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON18, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON19 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON19(uint32_t *val_out, struct nv_nva040_SET_FALCON19 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON19(val, args...) { \
    struct nv_nva040_SET_FALCON19 __data = { .v = (args) }; \
    __NVA040_SET_FALCON19(&val, __data); \
}

#define VA_NVA040_SET_FALCON19 V_NVA040_SET_FALCON19

#define P_NVA040_SET_FALCON19(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON19(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON19, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON20 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON20(uint32_t *val_out, struct nv_nva040_SET_FALCON20 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON20(val, args...) { \
    struct nv_nva040_SET_FALCON20 __data = { .v = (args) }; \
    __NVA040_SET_FALCON20(&val, __data); \
}

#define VA_NVA040_SET_FALCON20 V_NVA040_SET_FALCON20

#define P_NVA040_SET_FALCON20(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON20(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON20, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON21 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON21(uint32_t *val_out, struct nv_nva040_SET_FALCON21 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON21(val, args...) { \
    struct nv_nva040_SET_FALCON21 __data = { .v = (args) }; \
    __NVA040_SET_FALCON21(&val, __data); \
}

#define VA_NVA040_SET_FALCON21 V_NVA040_SET_FALCON21

#define P_NVA040_SET_FALCON21(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON21(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON21, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON22 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON22(uint32_t *val_out, struct nv_nva040_SET_FALCON22 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON22(val, args...) { \
    struct nv_nva040_SET_FALCON22 __data = { .v = (args) }; \
    __NVA040_SET_FALCON22(&val, __data); \
}

#define VA_NVA040_SET_FALCON22 V_NVA040_SET_FALCON22

#define P_NVA040_SET_FALCON22(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON22(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON22, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON23 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON23(uint32_t *val_out, struct nv_nva040_SET_FALCON23 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON23(val, args...) { \
    struct nv_nva040_SET_FALCON23 __data = { .v = (args) }; \
    __NVA040_SET_FALCON23(&val, __data); \
}

#define VA_NVA040_SET_FALCON23 V_NVA040_SET_FALCON23

#define P_NVA040_SET_FALCON23(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON23(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON23, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON24 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON24(uint32_t *val_out, struct nv_nva040_SET_FALCON24 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON24(val, args...) { \
    struct nv_nva040_SET_FALCON24 __data = { .v = (args) }; \
    __NVA040_SET_FALCON24(&val, __data); \
}

#define VA_NVA040_SET_FALCON24 V_NVA040_SET_FALCON24

#define P_NVA040_SET_FALCON24(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON24(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON24, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON25 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON25(uint32_t *val_out, struct nv_nva040_SET_FALCON25 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON25(val, args...) { \
    struct nv_nva040_SET_FALCON25 __data = { .v = (args) }; \
    __NVA040_SET_FALCON25(&val, __data); \
}

#define VA_NVA040_SET_FALCON25 V_NVA040_SET_FALCON25

#define P_NVA040_SET_FALCON25(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON25(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON25, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON26 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON26(uint32_t *val_out, struct nv_nva040_SET_FALCON26 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON26(val, args...) { \
    struct nv_nva040_SET_FALCON26 __data = { .v = (args) }; \
    __NVA040_SET_FALCON26(&val, __data); \
}

#define VA_NVA040_SET_FALCON26 V_NVA040_SET_FALCON26

#define P_NVA040_SET_FALCON26(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON26(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON26, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON27 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON27(uint32_t *val_out, struct nv_nva040_SET_FALCON27 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON27(val, args...) { \
    struct nv_nva040_SET_FALCON27 __data = { .v = (args) }; \
    __NVA040_SET_FALCON27(&val, __data); \
}

#define VA_NVA040_SET_FALCON27 V_NVA040_SET_FALCON27

#define P_NVA040_SET_FALCON27(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON27(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON27, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON28 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON28(uint32_t *val_out, struct nv_nva040_SET_FALCON28 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON28(val, args...) { \
    struct nv_nva040_SET_FALCON28 __data = { .v = (args) }; \
    __NVA040_SET_FALCON28(&val, __data); \
}

#define VA_NVA040_SET_FALCON28 V_NVA040_SET_FALCON28

#define P_NVA040_SET_FALCON28(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON28(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON28, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON29 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON29(uint32_t *val_out, struct nv_nva040_SET_FALCON29 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON29(val, args...) { \
    struct nv_nva040_SET_FALCON29 __data = { .v = (args) }; \
    __NVA040_SET_FALCON29(&val, __data); \
}

#define VA_NVA040_SET_FALCON29 V_NVA040_SET_FALCON29

#define P_NVA040_SET_FALCON29(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON29(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON29, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON30 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON30(uint32_t *val_out, struct nv_nva040_SET_FALCON30 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON30(val, args...) { \
    struct nv_nva040_SET_FALCON30 __data = { .v = (args) }; \
    __NVA040_SET_FALCON30(&val, __data); \
}

#define VA_NVA040_SET_FALCON30 V_NVA040_SET_FALCON30

#define P_NVA040_SET_FALCON30(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON30(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON30, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_FALCON31 {
    uint32_t v;
};

static inline void
__NVA040_SET_FALCON31(uint32_t *val_out, struct nv_nva040_SET_FALCON31 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_FALCON31(val, args...) { \
    struct nv_nva040_SET_FALCON31 __data = { .v = (args) }; \
    __NVA040_SET_FALCON31(&val, __data); \
}

#define VA_NVA040_SET_FALCON31 V_NVA040_SET_FALCON31

#define P_NVA040_SET_FALCON31(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_FALCON31(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_FALCON31, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NVA040_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nva040_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA040_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nva040_SET_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NVA040_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVA040_SET_RENDER_ENABLE_A V_NVA040_SET_RENDER_ENABLE_A

#define P_NVA040_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NVA040_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nva040_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA040_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nva040_SET_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NVA040_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVA040_SET_RENDER_ENABLE_B V_NVA040_SET_RENDER_ENABLE_B

#define P_NVA040_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVA040_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nva040_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA040_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVA040_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA040_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA040_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA040_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA040_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nva040_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVA040_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVA040_SET_RENDER_ENABLE_C V_NVA040_SET_RENDER_ENABLE_C

#define P_NVA040_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVA040_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA040_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA040_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA040_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA040_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_RENDER_ENABLE_OVERRIDE {
    uint32_t mode;
};

static inline void
__NVA040_SET_RENDER_ENABLE_OVERRIDE(uint32_t *val_out, struct nv_nva040_SET_RENDER_ENABLE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA040_SET_RENDER_ENABLE_OVERRIDE(val, args...) { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NVA040_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NVA040_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NVA040_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    struct nv_nva040_SET_RENDER_ENABLE_OVERRIDE __data = { .mode = (args) }; \
    __NVA040_SET_RENDER_ENABLE_OVERRIDE(&val, __data); \
}

#define VA_NVA040_SET_RENDER_ENABLE_OVERRIDE V_NVA040_SET_RENDER_ENABLE_OVERRIDE

#define P_NVA040_SET_RENDER_ENABLE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NVA040_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NVA040_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NVA040_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_RENDER_ENABLE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_RENDER_ENABLE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nva040_SET_MME_SHADOW_SCRATCH {
    uint32_t v;
};

static inline void
__NVA040_SET_MME_SHADOW_SCRATCH(uint32_t *val_out, struct nv_nva040_SET_MME_SHADOW_SCRATCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA040_SET_MME_SHADOW_SCRATCH(val, args...) { \
    struct nv_nva040_SET_MME_SHADOW_SCRATCH __data = { .v = (args) }; \
    __NVA040_SET_MME_SHADOW_SCRATCH(&val, __data); \
}

#define VA_NVA040_SET_MME_SHADOW_SCRATCH(i) V_NVA040_SET_MME_SHADOW_SCRATCH

#define P_NVA040_SET_MME_SHADOW_SCRATCH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA040_SET_MME_SHADOW_SCRATCH(nvk_p_ret, args); \
    nv_push_val(push, NVA040_SET_MME_SHADOW_SCRATCH(idx), nvk_p_ret); \
} while(0)


const char *P_PARSE_NVA040_MTHD(uint16_t idx);
void P_DUMP_NVA040_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix);
