// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{NavigationDirection, Swipeable, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwSwipeTracker")]
    pub struct SwipeTracker(Object<ffi::AdwSwipeTracker, ffi::AdwSwipeTrackerClass>) @implements gtk::Orientable;

    match fn {
        type_ => || ffi::adw_swipe_tracker_get_type(),
    }
}

impl SwipeTracker {
    #[doc(alias = "adw_swipe_tracker_new")]
    pub fn new(swipeable: &impl IsA<Swipeable>) -> SwipeTracker {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::adw_swipe_tracker_new(
                swipeable.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SwipeTracker`] objects.
    ///
    /// This method returns an instance of [`SwipeTrackerBuilder`](crate::builders::SwipeTrackerBuilder) which can be used to create [`SwipeTracker`] objects.
    pub fn builder() -> SwipeTrackerBuilder {
        SwipeTrackerBuilder::new()
    }

    #[doc(alias = "adw_swipe_tracker_get_allow_long_swipes")]
    #[doc(alias = "get_allow_long_swipes")]
    #[doc(alias = "allow-long-swipes")]
    pub fn allows_long_swipes(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_swipe_tracker_get_allow_long_swipes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_swipe_tracker_get_allow_mouse_drag")]
    #[doc(alias = "get_allow_mouse_drag")]
    #[doc(alias = "allow-mouse-drag")]
    pub fn allows_mouse_drag(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_swipe_tracker_get_allow_mouse_drag(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "adw_swipe_tracker_get_allow_window_handle")]
    #[doc(alias = "get_allow_window_handle")]
    #[doc(alias = "allow-window-handle")]
    pub fn allows_window_handle(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_swipe_tracker_get_allow_window_handle(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_swipe_tracker_get_enabled")]
    #[doc(alias = "get_enabled")]
    #[doc(alias = "enabled")]
    pub fn is_enabled(&self) -> bool {
        unsafe { from_glib(ffi::adw_swipe_tracker_get_enabled(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_swipe_tracker_get_lower_overshoot")]
    #[doc(alias = "get_lower_overshoot")]
    #[doc(alias = "lower-overshoot")]
    pub fn is_lower_overshoot(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_swipe_tracker_get_lower_overshoot(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_swipe_tracker_get_reversed")]
    #[doc(alias = "get_reversed")]
    #[doc(alias = "reversed")]
    pub fn is_reversed(&self) -> bool {
        unsafe { from_glib(ffi::adw_swipe_tracker_get_reversed(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_swipe_tracker_get_swipeable")]
    #[doc(alias = "get_swipeable")]
    pub fn swipeable(&self) -> Swipeable {
        unsafe { from_glib_none(ffi::adw_swipe_tracker_get_swipeable(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_swipe_tracker_get_upper_overshoot")]
    #[doc(alias = "get_upper_overshoot")]
    #[doc(alias = "upper-overshoot")]
    pub fn is_upper_overshoot(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_swipe_tracker_get_upper_overshoot(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_swipe_tracker_set_allow_long_swipes")]
    #[doc(alias = "allow-long-swipes")]
    pub fn set_allow_long_swipes(&self, allow_long_swipes: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_allow_long_swipes(
                self.to_glib_none().0,
                allow_long_swipes.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_swipe_tracker_set_allow_mouse_drag")]
    #[doc(alias = "allow-mouse-drag")]
    pub fn set_allow_mouse_drag(&self, allow_mouse_drag: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_allow_mouse_drag(
                self.to_glib_none().0,
                allow_mouse_drag.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "adw_swipe_tracker_set_allow_window_handle")]
    #[doc(alias = "allow-window-handle")]
    pub fn set_allow_window_handle(&self, allow_window_handle: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_allow_window_handle(
                self.to_glib_none().0,
                allow_window_handle.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_swipe_tracker_set_enabled")]
    #[doc(alias = "enabled")]
    pub fn set_enabled(&self, enabled: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_swipe_tracker_set_lower_overshoot")]
    #[doc(alias = "lower-overshoot")]
    pub fn set_lower_overshoot(&self, overshoot: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_lower_overshoot(
                self.to_glib_none().0,
                overshoot.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_swipe_tracker_set_reversed")]
    #[doc(alias = "reversed")]
    pub fn set_reversed(&self, reversed: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_reversed(self.to_glib_none().0, reversed.into_glib());
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_swipe_tracker_set_upper_overshoot")]
    #[doc(alias = "upper-overshoot")]
    pub fn set_upper_overshoot(&self, overshoot: bool) {
        unsafe {
            ffi::adw_swipe_tracker_set_upper_overshoot(
                self.to_glib_none().0,
                overshoot.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_swipe_tracker_shift_position")]
    pub fn shift_position(&self, delta: f64) {
        unsafe {
            ffi::adw_swipe_tracker_shift_position(self.to_glib_none().0, delta);
        }
    }

    #[doc(alias = "begin-swipe")]
    pub fn connect_begin_swipe<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn begin_swipe_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"begin-swipe".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    begin_swipe_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "end-swipe")]
    pub fn connect_end_swipe<F: Fn(&Self, f64, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn end_swipe_trampoline<F: Fn(&SwipeTracker, f64, f64) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            velocity: std::ffi::c_double,
            to: std::ffi::c_double,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), velocity, to)
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"end-swipe".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    end_swipe_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "prepare")]
    pub fn connect_prepare<F: Fn(&Self, NavigationDirection) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn prepare_trampoline<
            F: Fn(&SwipeTracker, NavigationDirection) + 'static,
        >(
            this: *mut ffi::AdwSwipeTracker,
            direction: ffi::AdwNavigationDirection,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), from_glib(direction))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"prepare".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    prepare_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "update-swipe")]
    pub fn connect_update_swipe<F: Fn(&Self, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn update_swipe_trampoline<F: Fn(&SwipeTracker, f64) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            progress: std::ffi::c_double,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), progress)
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"update-swipe".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    update_swipe_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-long-swipes")]
    pub fn connect_allow_long_swipes_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_long_swipes_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::allow-long-swipes".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_long_swipes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-mouse-drag")]
    pub fn connect_allow_mouse_drag_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_mouse_drag_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::allow-mouse-drag".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_mouse_drag_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "allow-window-handle")]
    pub fn connect_allow_window_handle_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_window_handle_trampoline<
            F: Fn(&SwipeTracker) + 'static,
        >(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::allow-window-handle".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_allow_window_handle_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enabled")]
    pub fn connect_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enabled_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::enabled".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_enabled_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "lower-overshoot")]
    pub fn connect_lower_overshoot_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_lower_overshoot_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::lower-overshoot".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_lower_overshoot_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reversed")]
    pub fn connect_reversed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reversed_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::reversed".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_reversed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "upper-overshoot")]
    pub fn connect_upper_overshoot_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_upper_overshoot_trampoline<F: Fn(&SwipeTracker) + 'static>(
            this: *mut ffi::AdwSwipeTracker,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::upper-overshoot".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_upper_overshoot_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for SwipeTracker {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SwipeTracker`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SwipeTrackerBuilder {
    builder: glib::object::ObjectBuilder<'static, SwipeTracker>,
}

impl SwipeTrackerBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn allow_long_swipes(self, allow_long_swipes: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("allow-long-swipes", allow_long_swipes),
        }
    }

    pub fn allow_mouse_drag(self, allow_mouse_drag: bool) -> Self {
        Self {
            builder: self.builder.property("allow-mouse-drag", allow_mouse_drag),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn allow_window_handle(self, allow_window_handle: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("allow-window-handle", allow_window_handle),
        }
    }

    pub fn enabled(self, enabled: bool) -> Self {
        Self {
            builder: self.builder.property("enabled", enabled),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn lower_overshoot(self, lower_overshoot: bool) -> Self {
        Self {
            builder: self.builder.property("lower-overshoot", lower_overshoot),
        }
    }

    pub fn reversed(self, reversed: bool) -> Self {
        Self {
            builder: self.builder.property("reversed", reversed),
        }
    }

    pub fn swipeable(self, swipeable: &impl IsA<Swipeable>) -> Self {
        Self {
            builder: self
                .builder
                .property("swipeable", swipeable.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn upper_overshoot(self, upper_overshoot: bool) -> Self {
        Self {
            builder: self.builder.property("upper-overshoot", upper_overshoot),
        }
    }

    pub fn orientation(self, orientation: gtk::Orientation) -> Self {
        Self {
            builder: self.builder.property("orientation", orientation),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SwipeTracker`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SwipeTracker {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
