// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::ffi;
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkAdjustment")]
    pub struct Adjustment(Object<ffi::GtkAdjustment, ffi::GtkAdjustmentClass>);

    match fn {
        type_ => || ffi::gtk_adjustment_get_type(),
    }
}

impl Adjustment {
    pub const NONE: Option<&'static Adjustment> = None;

    #[doc(alias = "gtk_adjustment_new")]
    pub fn new(
        value: f64,
        lower: f64,
        upper: f64,
        step_increment: f64,
        page_increment: f64,
        page_size: f64,
    ) -> Adjustment {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gtk_adjustment_new(
                value,
                lower,
                upper,
                step_increment,
                page_increment,
                page_size,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Adjustment`] objects.
    ///
    /// This method returns an instance of [`AdjustmentBuilder`](crate::builders::AdjustmentBuilder) which can be used to create [`Adjustment`] objects.
    pub fn builder() -> AdjustmentBuilder {
        AdjustmentBuilder::new()
    }
}

impl Default for Adjustment {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Adjustment`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AdjustmentBuilder {
    builder: glib::object::ObjectBuilder<'static, Adjustment>,
}

impl AdjustmentBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn lower(self, lower: f64) -> Self {
        Self {
            builder: self.builder.property("lower", lower),
        }
    }

    pub fn page_increment(self, page_increment: f64) -> Self {
        Self {
            builder: self.builder.property("page-increment", page_increment),
        }
    }

    pub fn page_size(self, page_size: f64) -> Self {
        Self {
            builder: self.builder.property("page-size", page_size),
        }
    }

    pub fn step_increment(self, step_increment: f64) -> Self {
        Self {
            builder: self.builder.property("step-increment", step_increment),
        }
    }

    pub fn upper(self, upper: f64) -> Self {
        Self {
            builder: self.builder.property("upper", upper),
        }
    }

    pub fn value(self, value: f64) -> Self {
        Self {
            builder: self.builder.property("value", value),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Adjustment`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Adjustment {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait AdjustmentExt: IsA<Adjustment> + 'static {
    #[doc(alias = "gtk_adjustment_clamp_page")]
    fn clamp_page(&self, lower: f64, upper: f64) {
        unsafe {
            ffi::gtk_adjustment_clamp_page(self.as_ref().to_glib_none().0, lower, upper);
        }
    }

    #[doc(alias = "gtk_adjustment_configure")]
    fn configure(
        &self,
        value: f64,
        lower: f64,
        upper: f64,
        step_increment: f64,
        page_increment: f64,
        page_size: f64,
    ) {
        unsafe {
            ffi::gtk_adjustment_configure(
                self.as_ref().to_glib_none().0,
                value,
                lower,
                upper,
                step_increment,
                page_increment,
                page_size,
            );
        }
    }

    #[doc(alias = "gtk_adjustment_get_lower")]
    #[doc(alias = "get_lower")]
    fn lower(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_lower(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_get_minimum_increment")]
    #[doc(alias = "get_minimum_increment")]
    fn minimum_increment(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_minimum_increment(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_get_page_increment")]
    #[doc(alias = "get_page_increment")]
    #[doc(alias = "page-increment")]
    fn page_increment(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_page_increment(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_get_page_size")]
    #[doc(alias = "get_page_size")]
    #[doc(alias = "page-size")]
    fn page_size(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_page_size(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_get_step_increment")]
    #[doc(alias = "get_step_increment")]
    #[doc(alias = "step-increment")]
    fn step_increment(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_step_increment(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_get_upper")]
    #[doc(alias = "get_upper")]
    fn upper(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_upper(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_get_value")]
    #[doc(alias = "get_value")]
    fn value(&self) -> f64 {
        unsafe { ffi::gtk_adjustment_get_value(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_adjustment_set_lower")]
    #[doc(alias = "lower")]
    fn set_lower(&self, lower: f64) {
        unsafe {
            ffi::gtk_adjustment_set_lower(self.as_ref().to_glib_none().0, lower);
        }
    }

    #[doc(alias = "gtk_adjustment_set_page_increment")]
    #[doc(alias = "page-increment")]
    fn set_page_increment(&self, page_increment: f64) {
        unsafe {
            ffi::gtk_adjustment_set_page_increment(self.as_ref().to_glib_none().0, page_increment);
        }
    }

    #[doc(alias = "gtk_adjustment_set_page_size")]
    #[doc(alias = "page-size")]
    fn set_page_size(&self, page_size: f64) {
        unsafe {
            ffi::gtk_adjustment_set_page_size(self.as_ref().to_glib_none().0, page_size);
        }
    }

    #[doc(alias = "gtk_adjustment_set_step_increment")]
    #[doc(alias = "step-increment")]
    fn set_step_increment(&self, step_increment: f64) {
        unsafe {
            ffi::gtk_adjustment_set_step_increment(self.as_ref().to_glib_none().0, step_increment);
        }
    }

    #[doc(alias = "gtk_adjustment_set_upper")]
    #[doc(alias = "upper")]
    fn set_upper(&self, upper: f64) {
        unsafe {
            ffi::gtk_adjustment_set_upper(self.as_ref().to_glib_none().0, upper);
        }
    }

    #[doc(alias = "gtk_adjustment_set_value")]
    #[doc(alias = "value")]
    fn set_value(&self, value: f64) {
        unsafe {
            ffi::gtk_adjustment_set_value(self.as_ref().to_glib_none().0, value);
        }
    }

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<Adjustment>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAdjustment,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-changed")]
    fn connect_value_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn value_changed_trampoline<P: IsA<Adjustment>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAdjustment,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"value-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    value_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "lower")]
    fn connect_lower_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_lower_trampoline<P: IsA<Adjustment>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAdjustment,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::lower".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_lower_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-increment")]
    fn connect_page_increment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_increment_trampoline<
            P: IsA<Adjustment>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAdjustment,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::page-increment".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_page_increment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-size")]
    fn connect_page_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_size_trampoline<
            P: IsA<Adjustment>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAdjustment,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::page-size".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_page_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "step-increment")]
    fn connect_step_increment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_step_increment_trampoline<
            P: IsA<Adjustment>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAdjustment,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::step-increment".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_step_increment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "upper")]
    fn connect_upper_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_upper_trampoline<P: IsA<Adjustment>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAdjustment,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::upper".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_upper_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value")]
    fn connect_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_trampoline<P: IsA<Adjustment>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAdjustment,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Adjustment::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::value".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_value_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Adjustment>> AdjustmentExt for O {}
