/* dash-entry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dash-entry.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 */
/* Vala's vapi for gtk3 is broken for lookup_color (it forgets the out keyword) */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <atk/atk.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_DASH_ENTRY (dash_entry_get_type ())
#define DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_ENTRY, DashEntry))
#define DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_ENTRY, DashEntryClass))
#define IS_DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_ENTRY))
#define IS_DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_ENTRY))
#define DASH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_ENTRY, DashEntryClass))

typedef struct _DashEntry DashEntry;
typedef struct _DashEntryClass DashEntryClass;
typedef struct _DashEntryPrivate DashEntryPrivate;
enum  {
	DASH_ENTRY_0_PROPERTY,
	DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT_PROPERTY,
	DASH_ENTRY_CAN_RESPOND_PROPERTY,
	DASH_ENTRY_DID_RESPOND_PROPERTY,
	DASH_ENTRY_FADE_TRACKER_PROPERTY,
	DASH_ENTRY_NUM_PROPERTIES
};
static GParamSpec* dash_entry_properties[DASH_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_SLICK_GREETER (slick_greeter_get_type ())
#define SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLICK_GREETER, SlickGreeter))
#define SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLICK_GREETER, SlickGreeterClass))
#define IS_SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLICK_GREETER))
#define IS_SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLICK_GREETER))
#define SLICK_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLICK_GREETER, SlickGreeterClass))

typedef struct _SlickGreeter SlickGreeter;
typedef struct _SlickGreeterClass SlickGreeterClass;
typedef struct _SlickGreeterPrivate SlickGreeterPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DASH_ENTRY_RESPOND_SIGNAL,
	DASH_ENTRY_NUM_SIGNALS
};
static guint dash_entry_signals[DASH_ENTRY_NUM_SIGNALS] = {0};

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _DashEntry {
	GtkEntry parent_instance;
	DashEntryPrivate * priv;
};

struct _DashEntryClass {
	GtkEntryClass parent_class;
};

struct _DashEntryPrivate {
	gchar* _constant_placeholder_text;
	gboolean _can_respond;
	gboolean _did_respond;
	FadeTracker* _fade_tracker;
	GdkWindow* arrow_win;
};

struct _SlickGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlickGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _SlickGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (SlickGreeter *self);
};

static gint DashEntry_private_offset;
static gpointer dash_entry_parent_class = NULL;
VALA_EXTERN gchar* dash_entry_font;
gchar* dash_entry_font = NULL;
static GdkPixbuf* dash_entry_arrow_pixbuf;
static GdkPixbuf* dash_entry_arrow_pixbuf = NULL;
VALA_EXTERN SlickGreeter* slick_greeter_singleton;
static FadableIface * dash_entry_fadable_parent_iface = NULL;

VALA_EXTERN GType fade_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadeTracker, g_object_unref)
VALA_EXTERN GType fadable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Fadable, g_object_unref)
VALA_EXTERN GType dash_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashEntry, g_object_unref)
static gboolean dash_entry_real_draw (GtkWidget* base,
                               cairo_t* c);
VALA_EXTERN FadeTracker* fadable_get_fade_tracker (Fadable* self);
VALA_EXTERN gdouble fade_tracker_get_alpha (FadeTracker* self);
VALA_EXTERN const gchar* dash_entry_get_constant_placeholder_text (DashEntry* self);
static void dash_entry_draw_prompt_text (DashEntry* self,
                                  cairo_t* c);
VALA_EXTERN gboolean dash_entry_get_did_respond (DashEntry* self);
static void dash_entry_draw_spinner (DashEntry* self,
                              cairo_t* c);
VALA_EXTERN gboolean dash_entry_get_can_respond (DashEntry* self);
static void dash_entry_draw_arrow (DashEntry* self,
                            cairo_t* c);
static gint dash_entry_get_arrow_size (DashEntry* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void dash_entry_real_activate (GtkEntry* base);
VALA_EXTERN void dash_entry_set_did_respond (DashEntry* self,
                                 gboolean value);
VALA_EXTERN gboolean dash_entry_button_press_event_cb (DashEntry* self,
                                           GdkEventButton* event);
static void dash_entry_get_arrow_location (DashEntry* self,
                                    gint* x,
                                    gint* y);
static void dash_entry_real_size_allocate (GtkWidget* base,
                                    GtkAllocation* allocation);
static void dash_entry_real_realize (GtkWidget* base);
static void dash_entry_real_unrealize (GtkWidget* base);
static void dash_entry_real_map (GtkWidget* base);
static void dash_entry_real_unmap (GtkWidget* base);
static gboolean dash_entry_real_key_press_event (GtkWidget* base,
                                          GdkEventKey* event);
VALA_EXTERN gpointer slick_greeter_ref (gpointer instance);
VALA_EXTERN void slick_greeter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slick_greeter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_slick_greeter (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_slick_greeter (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_slick_greeter (const GValue* value);
VALA_EXTERN GType slick_greeter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlickGreeter, slick_greeter_unref)
VALA_EXTERN DashEntry* dash_entry_new (void);
VALA_EXTERN DashEntry* dash_entry_construct (GType object_type);
VALA_EXTERN void dash_entry_set_constant_placeholder_text (DashEntry* self,
                                               const gchar* value);
VALA_EXTERN void dash_entry_set_can_respond (DashEntry* self,
                                 gboolean value);
static GObject * dash_entry_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
VALA_EXTERN FadeTracker* fade_tracker_new (GtkWidget* widget);
VALA_EXTERN FadeTracker* fade_tracker_construct (GType object_type,
                                     GtkWidget* widget);
VALA_EXTERN void fadable_set_fade_tracker (Fadable* self,
                               FadeTracker* value);
static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self);
static gboolean _dash_entry_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self);
static void dash_entry_finalize (GObject * obj);
static GType dash_entry_get_type_once (void);
static void _vala_dash_entry_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_dash_entry_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dash_entry_get_instance_private (DashEntry* self)
{
	return G_STRUCT_MEMBER_P (self, DashEntry_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 94 "../src/dash-entry.vala"
	return self ? g_object_ref (self) : NULL;
#line 256 "dash-entry.c"
}

static gboolean
dash_entry_real_draw (GtkWidget* base,
                      cairo_t* c)
{
	DashEntry * self;
	GtkStyleContext* style_ctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	FadeTracker* _tmp3_;
	FadeTracker* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GtkStyleContext* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean result;
#line 92 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 92 "../src/dash-entry.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 94 "../src/dash-entry.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 94 "../src/dash-entry.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 94 "../src/dash-entry.vala"
	style_ctx = _tmp1_;
#line 97 "../src/dash-entry.vala"
	_tmp2_ = style_ctx;
#line 97 "../src/dash-entry.vala"
	gtk_style_context_save (_tmp2_);
#line 98 "../src/dash-entry.vala"
	cairo_save (c);
#line 99 "../src/dash-entry.vala"
	cairo_push_group (c);
#line 100 "../src/dash-entry.vala"
	GTK_WIDGET_CLASS (dash_entry_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry), c);
#line 101 "../src/dash-entry.vala"
	cairo_pop_group_to_source (c);
#line 102 "../src/dash-entry.vala"
	_tmp3_ = fadable_get_fade_tracker ((Fadable*) self);
#line 102 "../src/dash-entry.vala"
	_tmp4_ = _tmp3_;
#line 102 "../src/dash-entry.vala"
	_tmp5_ = fade_tracker_get_alpha (_tmp4_);
#line 102 "../src/dash-entry.vala"
	_tmp6_ = _tmp5_;
#line 102 "../src/dash-entry.vala"
	cairo_paint_with_alpha (c, _tmp6_);
#line 103 "../src/dash-entry.vala"
	cairo_restore (c);
#line 104 "../src/dash-entry.vala"
	_tmp7_ = style_ctx;
#line 104 "../src/dash-entry.vala"
	gtk_style_context_restore (_tmp7_);
#line 107 "../src/dash-entry.vala"
	if (((gint) gtk_entry_get_text_length ((GtkEntry*) self)) == 0) {
#line 317 "dash-entry.c"
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 107 "../src/dash-entry.vala"
		_tmp9_ = self->priv->_constant_placeholder_text;
#line 107 "../src/dash-entry.vala"
		_tmp10_ = strlen (_tmp9_);
#line 107 "../src/dash-entry.vala"
		_tmp11_ = _tmp10_;
#line 107 "../src/dash-entry.vala"
		_tmp8_ = _tmp11_ > 0;
#line 329 "dash-entry.c"
	} else {
#line 107 "../src/dash-entry.vala"
		_tmp8_ = FALSE;
#line 333 "dash-entry.c"
	}
#line 107 "../src/dash-entry.vala"
	if (_tmp8_) {
#line 108 "../src/dash-entry.vala"
		dash_entry_draw_prompt_text (self, c);
#line 339 "dash-entry.c"
	}
#line 111 "../src/dash-entry.vala"
	_tmp12_ = dash_entry_get_did_respond (self);
#line 111 "../src/dash-entry.vala"
	_tmp13_ = _tmp12_;
#line 111 "../src/dash-entry.vala"
	if (_tmp13_) {
#line 112 "../src/dash-entry.vala"
		dash_entry_draw_spinner (self, c);
#line 349 "dash-entry.c"
	} else {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
#line 113 "../src/dash-entry.vala"
		_tmp15_ = self->priv->_can_respond;
#line 113 "../src/dash-entry.vala"
		if (_tmp15_) {
#line 113 "../src/dash-entry.vala"
			_tmp14_ = ((gint) gtk_entry_get_text_length ((GtkEntry*) self)) > 0;
#line 359 "dash-entry.c"
		} else {
#line 113 "../src/dash-entry.vala"
			_tmp14_ = FALSE;
#line 363 "dash-entry.c"
		}
#line 113 "../src/dash-entry.vala"
		if (_tmp14_) {
#line 114 "../src/dash-entry.vala"
			dash_entry_draw_arrow (self, c);
#line 369 "dash-entry.c"
		}
	}
#line 116 "../src/dash-entry.vala"
	result = FALSE;
#line 116 "../src/dash-entry.vala"
	_g_object_unref0 (style_ctx);
#line 116 "../src/dash-entry.vala"
	return result;
#line 378 "dash-entry.c"
}

static void
dash_entry_draw_spinner (DashEntry* self,
                         cairo_t* c)
{
	GtkStyleContext* style_ctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gint arrow_size = 0;
	GdkWindow* _tmp2_;
#line 119 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 119 "../src/dash-entry.vala"
	g_return_if_fail (c != NULL);
#line 121 "../src/dash-entry.vala"
	cairo_save (c);
#line 123 "../src/dash-entry.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 123 "../src/dash-entry.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 123 "../src/dash-entry.vala"
	style_ctx = _tmp1_;
#line 124 "../src/dash-entry.vala"
	arrow_size = dash_entry_get_arrow_size (self);
#line 125 "../src/dash-entry.vala"
	_tmp2_ = self->priv->arrow_win;
#line 125 "../src/dash-entry.vala"
	gtk_cairo_transform_to_window (c, (GtkWidget*) self, _tmp2_);
#line 126 "../src/dash-entry.vala"
	gtk_render_activity (style_ctx, c, (gdouble) 0, (gdouble) 0, (gdouble) arrow_size, (gdouble) arrow_size);
#line 128 "../src/dash-entry.vala"
	cairo_restore (c);
#line 119 "../src/dash-entry.vala"
	_g_object_unref0 (style_ctx);
#line 414 "dash-entry.c"
}

static void
dash_entry_draw_arrow (DashEntry* self,
                       cairo_t* c)
{
	GdkPixbuf* _tmp0_;
	gint arrow_size = 0;
	GdkWindow* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
#line 131 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 131 "../src/dash-entry.vala"
	g_return_if_fail (c != NULL);
#line 133 "../src/dash-entry.vala"
	_tmp0_ = dash_entry_arrow_pixbuf;
#line 133 "../src/dash-entry.vala"
	if (_tmp0_ == NULL) {
#line 134 "../src/dash-entry.vala"
		return;
#line 436 "dash-entry.c"
	}
#line 136 "../src/dash-entry.vala"
	cairo_save (c);
#line 138 "../src/dash-entry.vala"
	arrow_size = dash_entry_get_arrow_size (self);
#line 139 "../src/dash-entry.vala"
	_tmp1_ = self->priv->arrow_win;
#line 139 "../src/dash-entry.vala"
	gtk_cairo_transform_to_window (c, (GtkWidget*) self, _tmp1_);
#line 140 "../src/dash-entry.vala"
	_tmp2_ = dash_entry_arrow_pixbuf;
#line 140 "../src/dash-entry.vala"
	cairo_translate (c, (gdouble) ((arrow_size - gdk_pixbuf_get_width (_tmp2_)) - 1), (gdouble) 0);
#line 141 "../src/dash-entry.vala"
	_tmp3_ = dash_entry_arrow_pixbuf;
#line 141 "../src/dash-entry.vala"
	gdk_cairo_set_source_pixbuf (c, _tmp3_, (gdouble) 0, (gdouble) 0);
#line 143 "../src/dash-entry.vala"
	cairo_paint (c);
#line 144 "../src/dash-entry.vala"
	cairo_restore (c);
#line 458 "dash-entry.c"
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 156 "../src/dash-entry.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 466 "dash-entry.c"
}

static void
dash_entry_draw_prompt_text (DashEntry* self,
                             cairo_t* c)
{
	gint layout_width = 0;
	gint layout_height = 0;
	GdkRectangle rect = {0};
	PangoLayout* layout = NULL;
	const gchar* _tmp0_;
	PangoLayout* _tmp1_;
	PangoLayout* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoLayout* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_;
	GdkRGBA fg = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GdkRGBA _tmp15_ = {0};
	gboolean _tmp16_;
	GdkRGBA _tmp17_;
	GdkRGBA _tmp18_;
	GdkRGBA _tmp19_;
	GdkRGBA _tmp20_;
	PangoLayout* _tmp21_;
#line 147 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 147 "../src/dash-entry.vala"
	g_return_if_fail (c != NULL);
#line 149 "../src/dash-entry.vala"
	cairo_save (c);
#line 155 "../src/dash-entry.vala"
	_tmp0_ = self->priv->_constant_placeholder_text;
#line 155 "../src/dash-entry.vala"
	_tmp1_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp0_);
#line 155 "../src/dash-entry.vala"
	layout = _tmp1_;
#line 156 "../src/dash-entry.vala"
	_tmp2_ = layout;
#line 156 "../src/dash-entry.vala"
	_tmp3_ = pango_font_description_from_string ("Ubuntu 13");
#line 156 "../src/dash-entry.vala"
	_tmp4_ = _tmp3_;
#line 156 "../src/dash-entry.vala"
	pango_layout_set_font_description (_tmp2_, _tmp4_);
#line 156 "../src/dash-entry.vala"
	__vala_PangoFontDescription_free0 (_tmp4_);
#line 157 "../src/dash-entry.vala"
	_tmp5_ = layout;
#line 157 "../src/dash-entry.vala"
	pango_layout_get_pixel_size (_tmp5_, &_tmp6_, &_tmp7_);
#line 157 "../src/dash-entry.vala"
	layout_width = _tmp6_;
#line 157 "../src/dash-entry.vala"
	layout_height = _tmp7_;
#line 159 "../src/dash-entry.vala"
	gtk_entry_get_text_area ((GtkEntry*) self, &_tmp8_);
#line 159 "../src/dash-entry.vala"
	rect = _tmp8_;
#line 161 "../src/dash-entry.vala"
	_tmp9_ = rect;
#line 161 "../src/dash-entry.vala"
	_tmp10_ = rect;
#line 161 "../src/dash-entry.vala"
	_tmp11_ = rect;
#line 161 "../src/dash-entry.vala"
	cairo_move_to (c, (gdouble) _tmp9_.x, (gdouble) ((_tmp10_.y + (_tmp11_.height / 2)) - (layout_height / 2)));
#line 164 "../src/dash-entry.vala"
	memset (&fg, 0, sizeof (GdkRGBA));
#line 165 "../src/dash-entry.vala"
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 165 "../src/dash-entry.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 165 "../src/dash-entry.vala"
	context = _tmp13_;
#line 166 "../src/dash-entry.vala"
	_tmp14_ = context;
#line 166 "../src/dash-entry.vala"
	_tmp16_ = gtk_style_context_lookup_color (_tmp14_, "placeholder_text_color", &_tmp15_);
#line 166 "../src/dash-entry.vala"
	fg = _tmp15_;
#line 166 "../src/dash-entry.vala"
	if (!_tmp16_) {
#line 167 "../src/dash-entry.vala"
		gdk_rgba_parse (&fg, "#888");
#line 561 "dash-entry.c"
	}
#line 168 "../src/dash-entry.vala"
	_tmp17_ = fg;
#line 168 "../src/dash-entry.vala"
	_tmp18_ = fg;
#line 168 "../src/dash-entry.vala"
	_tmp19_ = fg;
#line 168 "../src/dash-entry.vala"
	_tmp20_ = fg;
#line 168 "../src/dash-entry.vala"
	cairo_set_source_rgba (c, _tmp17_.red, _tmp18_.green, _tmp19_.blue, _tmp20_.alpha);
#line 171 "../src/dash-entry.vala"
	_tmp21_ = layout;
#line 171 "../src/dash-entry.vala"
	pango_cairo_show_layout (c, _tmp21_);
#line 173 "../src/dash-entry.vala"
	cairo_restore (c);
#line 147 "../src/dash-entry.vala"
	_g_object_unref0 (context);
#line 147 "../src/dash-entry.vala"
	_g_object_unref0 (layout);
#line 583 "dash-entry.c"
}

static void
dash_entry_real_activate (GtkEntry* base)
{
	DashEntry * self;
	gboolean _tmp0_;
#line 176 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 178 "../src/dash-entry.vala"
	GTK_ENTRY_CLASS (dash_entry_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
#line 179 "../src/dash-entry.vala"
	_tmp0_ = self->priv->_can_respond;
#line 179 "../src/dash-entry.vala"
	if (_tmp0_) {
#line 181 "../src/dash-entry.vala"
		dash_entry_set_did_respond (self, TRUE);
#line 182 "../src/dash-entry.vala"
		g_signal_emit (self, dash_entry_signals[DASH_ENTRY_RESPOND_SIGNAL], 0);
#line 603 "dash-entry.c"
	} else {
		GtkWidget* _tmp1_;
#line 186 "../src/dash-entry.vala"
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 186 "../src/dash-entry.vala"
		gtk_widget_child_focus (_tmp1_, GTK_DIR_TAB_FORWARD);
#line 610 "dash-entry.c"
	}
}

gboolean
dash_entry_button_press_event_cb (DashEntry* self,
                                  GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	gboolean result;
#line 190 "../src/dash-entry.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 190 "../src/dash-entry.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 192 "../src/dash-entry.vala"
	_tmp1_ = event->window;
#line 192 "../src/dash-entry.vala"
	_tmp2_ = self->priv->arrow_win;
#line 192 "../src/dash-entry.vala"
	if (_tmp1_ == _tmp2_) {
#line 192 "../src/dash-entry.vala"
		_tmp0_ = ((gint) gtk_entry_get_text_length ((GtkEntry*) self)) > 0;
#line 634 "dash-entry.c"
	} else {
#line 192 "../src/dash-entry.vala"
		_tmp0_ = FALSE;
#line 638 "dash-entry.c"
	}
#line 192 "../src/dash-entry.vala"
	if (_tmp0_) {
#line 194 "../src/dash-entry.vala"
		g_signal_emit_by_name ((GtkEntry*) self, "activate");
#line 195 "../src/dash-entry.vala"
		result = TRUE;
#line 195 "../src/dash-entry.vala"
		return result;
#line 648 "dash-entry.c"
	} else {
#line 198 "../src/dash-entry.vala"
		result = FALSE;
#line 198 "../src/dash-entry.vala"
		return result;
#line 654 "dash-entry.c"
	}
}

static gint
dash_entry_get_arrow_size (DashEntry* self)
{
	GdkPixbuf* _tmp0_;
	gint result;
#line 201 "../src/dash-entry.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 204 "../src/dash-entry.vala"
	_tmp0_ = dash_entry_arrow_pixbuf;
#line 204 "../src/dash-entry.vala"
	if (_tmp0_ != NULL) {
#line 669 "dash-entry.c"
		GdkPixbuf* _tmp1_;
#line 205 "../src/dash-entry.vala"
		_tmp1_ = dash_entry_arrow_pixbuf;
#line 205 "../src/dash-entry.vala"
		result = gdk_pixbuf_get_height (_tmp1_);
#line 205 "../src/dash-entry.vala"
		return result;
#line 677 "dash-entry.c"
	} else {
#line 207 "../src/dash-entry.vala"
		result = 20;
#line 207 "../src/dash-entry.vala"
		return result;
#line 683 "dash-entry.c"
	}
}

static void
dash_entry_get_arrow_location (DashEntry* self,
                               gint* x,
                               gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint arrow_size = 0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint margin = 0;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
#line 210 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 212 "../src/dash-entry.vala"
	arrow_size = dash_entry_get_arrow_size (self);
#line 215 "../src/dash-entry.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
#line 215 "../src/dash-entry.vala"
	allocation = _tmp0_;
#line 218 "../src/dash-entry.vala"
	_tmp1_ = allocation;
#line 218 "../src/dash-entry.vala"
	margin = (_tmp1_.height - arrow_size) / 2;
#line 220 "../src/dash-entry.vala"
	_tmp2_ = allocation;
#line 220 "../src/dash-entry.vala"
	_tmp3_ = allocation;
#line 220 "../src/dash-entry.vala"
	_vala_x = ((_tmp2_.x + _tmp3_.width) - margin) - arrow_size;
#line 221 "../src/dash-entry.vala"
	_tmp4_ = allocation;
#line 221 "../src/dash-entry.vala"
	_vala_y = _tmp4_.y + margin;
#line 210 "../src/dash-entry.vala"
	if (x) {
#line 210 "../src/dash-entry.vala"
		*x = _vala_x;
#line 728 "dash-entry.c"
	}
#line 210 "../src/dash-entry.vala"
	if (y) {
#line 210 "../src/dash-entry.vala"
		*y = _vala_y;
#line 734 "dash-entry.c"
	}
}

static void
dash_entry_real_size_allocate (GtkWidget* base,
                               GtkAllocation* allocation)
{
	DashEntry * self;
	GtkAllocation _tmp0_;
	GdkWindow* _tmp1_;
	gint arrow_x = 0;
	gint arrow_y = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint arrow_size = 0;
	GdkWindow* _tmp4_;
#line 224 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 224 "../src/dash-entry.vala"
	g_return_if_fail (allocation != NULL);
#line 226 "../src/dash-entry.vala"
	_tmp0_ = *allocation;
#line 226 "../src/dash-entry.vala"
	GTK_WIDGET_CLASS (dash_entry_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry), &_tmp0_);
#line 228 "../src/dash-entry.vala"
	_tmp1_ = self->priv->arrow_win;
#line 228 "../src/dash-entry.vala"
	if (_tmp1_ == NULL) {
#line 229 "../src/dash-entry.vala"
		return;
#line 765 "dash-entry.c"
	}
#line 232 "../src/dash-entry.vala"
	dash_entry_get_arrow_location (self, &_tmp2_, &_tmp3_);
#line 232 "../src/dash-entry.vala"
	arrow_x = _tmp2_;
#line 232 "../src/dash-entry.vala"
	arrow_y = _tmp3_;
#line 233 "../src/dash-entry.vala"
	arrow_size = dash_entry_get_arrow_size (self);
#line 235 "../src/dash-entry.vala"
	_tmp4_ = self->priv->arrow_win;
#line 235 "../src/dash-entry.vala"
	gdk_window_move_resize (_tmp4_, arrow_x, arrow_y, arrow_size, arrow_size);
#line 779 "dash-entry.c"
}

static void
dash_entry_real_realize (GtkWidget* base)
{
	DashEntry * self;
	GdkCursor* cursor = NULL;
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GdkWindowAttr attrs = {0};
	GdkWindow* _tmp2_;
	GdkWindowAttr _tmp3_;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
	GdkWindow* _tmp6_;
#line 238 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 240 "../src/dash-entry.vala"
	GTK_WIDGET_CLASS (dash_entry_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
#line 242 "../src/dash-entry.vala"
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
#line 242 "../src/dash-entry.vala"
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, GDK_LEFT_PTR);
#line 242 "../src/dash-entry.vala"
	cursor = _tmp1_;
#line 243 "../src/dash-entry.vala"
	memset (&attrs, 0, sizeof (GdkWindowAttr));
#line 244 "../src/dash-entry.vala"
	attrs.x = 0;
#line 245 "../src/dash-entry.vala"
	attrs.y = 0;
#line 246 "../src/dash-entry.vala"
	attrs.width = 1;
#line 247 "../src/dash-entry.vala"
	attrs.height = 1;
#line 248 "../src/dash-entry.vala"
	attrs.cursor = cursor;
#line 249 "../src/dash-entry.vala"
	attrs.wclass = GDK_INPUT_ONLY;
#line 250 "../src/dash-entry.vala"
	attrs.window_type = GDK_WINDOW_CHILD;
#line 251 "../src/dash-entry.vala"
	attrs.event_mask = gtk_widget_get_events ((GtkWidget*) self) | GDK_BUTTON_PRESS_MASK;
#line 254 "../src/dash-entry.vala"
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
#line 254 "../src/dash-entry.vala"
	_tmp3_ = attrs;
#line 254 "../src/dash-entry.vala"
	_tmp4_ = gdk_window_new (_tmp2_, &_tmp3_, (GDK_WA_X | GDK_WA_Y) | GDK_WA_CURSOR);
#line 254 "../src/dash-entry.vala"
	_g_object_unref0 (self->priv->arrow_win);
#line 254 "../src/dash-entry.vala"
	self->priv->arrow_win = _tmp4_;
#line 258 "../src/dash-entry.vala"
	_tmp5_ = self->priv->arrow_win;
#line 258 "../src/dash-entry.vala"
	g_object_ref ((GObject*) _tmp5_);
#line 259 "../src/dash-entry.vala"
	_tmp6_ = self->priv->arrow_win;
#line 259 "../src/dash-entry.vala"
	gdk_window_set_user_data (_tmp6_, (GObject*) self);
#line 238 "../src/dash-entry.vala"
	_g_object_unref0 (cursor);
#line 843 "dash-entry.c"
}

static void
dash_entry_real_unrealize (GtkWidget* base)
{
	DashEntry * self;
	GdkWindow* _tmp0_;
#line 262 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 264 "../src/dash-entry.vala"
	_tmp0_ = self->priv->arrow_win;
#line 264 "../src/dash-entry.vala"
	if (_tmp0_ != NULL) {
#line 857 "dash-entry.c"
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
#line 266 "../src/dash-entry.vala"
		_tmp1_ = self->priv->arrow_win;
#line 266 "../src/dash-entry.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 266 "../src/dash-entry.vala"
		gdk_window_destroy (_tmp2_);
#line 267 "../src/dash-entry.vala"
		_g_object_unref0 (self->priv->arrow_win);
#line 267 "../src/dash-entry.vala"
		self->priv->arrow_win = NULL;
#line 870 "dash-entry.c"
	}
#line 269 "../src/dash-entry.vala"
	GTK_WIDGET_CLASS (dash_entry_parent_class)->unrealize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
#line 874 "dash-entry.c"
}

static void
dash_entry_real_map (GtkWidget* base)
{
	DashEntry * self;
	GdkWindow* _tmp0_;
#line 272 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 274 "../src/dash-entry.vala"
	GTK_WIDGET_CLASS (dash_entry_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
#line 275 "../src/dash-entry.vala"
	_tmp0_ = self->priv->arrow_win;
#line 275 "../src/dash-entry.vala"
	if (_tmp0_ != NULL) {
#line 890 "dash-entry.c"
		GdkWindow* _tmp1_;
#line 276 "../src/dash-entry.vala"
		_tmp1_ = self->priv->arrow_win;
#line 276 "../src/dash-entry.vala"
		gdk_window_show (_tmp1_);
#line 896 "dash-entry.c"
	}
}

static void
dash_entry_real_unmap (GtkWidget* base)
{
	DashEntry * self;
	GdkWindow* _tmp0_;
#line 279 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 281 "../src/dash-entry.vala"
	_tmp0_ = self->priv->arrow_win;
#line 281 "../src/dash-entry.vala"
	if (_tmp0_ != NULL) {
#line 911 "dash-entry.c"
		GdkWindow* _tmp1_;
#line 282 "../src/dash-entry.vala"
		_tmp1_ = self->priv->arrow_win;
#line 282 "../src/dash-entry.vala"
		gdk_window_hide (_tmp1_);
#line 917 "dash-entry.c"
	}
#line 283 "../src/dash-entry.vala"
	GTK_WIDGET_CLASS (dash_entry_parent_class)->unmap ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
#line 921 "dash-entry.c"
}

static gboolean
dash_entry_real_key_press_event (GtkWidget* base,
                                 GdkEventKey* event)
{
	DashEntry * self;
	SlickGreeter* _tmp0_;
	gboolean result;
#line 286 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 286 "../src/dash-entry.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 291 "../src/dash-entry.vala"
	_tmp0_ = slick_greeter_singleton;
#line 291 "../src/dash-entry.vala"
	if (_tmp0_->orca_needs_kick) {
#line 939 "dash-entry.c"
		AtkObject* _tmp1_;
		SlickGreeter* _tmp2_;
#line 293 "../src/dash-entry.vala"
		_tmp1_ = gtk_widget_get_accessible ((GtkWidget*) self);
#line 293 "../src/dash-entry.vala"
		g_signal_emit_by_name (_tmp1_, "focus-event", TRUE, NULL);
#line 294 "../src/dash-entry.vala"
		_tmp2_ = slick_greeter_singleton;
#line 294 "../src/dash-entry.vala"
		_tmp2_->orca_needs_kick = FALSE;
#line 950 "dash-entry.c"
	}
#line 297 "../src/dash-entry.vala"
	result = GTK_WIDGET_CLASS (dash_entry_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry), event);
#line 297 "../src/dash-entry.vala"
	return result;
#line 956 "dash-entry.c"
}

DashEntry*
dash_entry_construct (GType object_type)
{
	DashEntry * self = NULL;
#line 24 "../src/dash-entry.vala"
	self = (DashEntry*) g_object_new (object_type, NULL);
#line 24 "../src/dash-entry.vala"
	return self;
#line 967 "dash-entry.c"
}

DashEntry*
dash_entry_new (void)
{
#line 24 "../src/dash-entry.vala"
	return dash_entry_construct (TYPE_DASH_ENTRY);
#line 975 "dash-entry.c"
}

const gchar*
dash_entry_get_constant_placeholder_text (DashEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "../src/dash-entry.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "../src/dash-entry.vala"
	_tmp0_ = self->priv->_constant_placeholder_text;
#line 29 "../src/dash-entry.vala"
	result = _tmp0_;
#line 29 "../src/dash-entry.vala"
	return result;
#line 991 "dash-entry.c"
}

void
dash_entry_set_constant_placeholder_text (DashEntry* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 29 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 29 "../src/dash-entry.vala"
	old_value = dash_entry_get_constant_placeholder_text (self);
#line 29 "../src/dash-entry.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1005 "dash-entry.c"
		gchar* _tmp0_;
#line 29 "../src/dash-entry.vala"
		_tmp0_ = g_strdup (value);
#line 29 "../src/dash-entry.vala"
		_g_free0 (self->priv->_constant_placeholder_text);
#line 29 "../src/dash-entry.vala"
		self->priv->_constant_placeholder_text = _tmp0_;
#line 29 "../src/dash-entry.vala"
		g_object_notify_by_pspec ((GObject *) self, dash_entry_properties[DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT_PROPERTY]);
#line 1015 "dash-entry.c"
	}
}

gboolean
dash_entry_get_can_respond (DashEntry* self)
{
	gboolean result;
#line 30 "../src/dash-entry.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 30 "../src/dash-entry.vala"
	result = self->priv->_can_respond;
#line 30 "../src/dash-entry.vala"
	return result;
#line 1029 "dash-entry.c"
}

void
dash_entry_set_can_respond (DashEntry* self,
                            gboolean value)
{
	gboolean old_value;
#line 30 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 30 "../src/dash-entry.vala"
	old_value = dash_entry_get_can_respond (self);
#line 30 "../src/dash-entry.vala"
	if (old_value != value) {
#line 30 "../src/dash-entry.vala"
		self->priv->_can_respond = value;
#line 30 "../src/dash-entry.vala"
		g_object_notify_by_pspec ((GObject *) self, dash_entry_properties[DASH_ENTRY_CAN_RESPOND_PROPERTY]);
#line 1047 "dash-entry.c"
	}
}

gboolean
dash_entry_get_did_respond (DashEntry* self)
{
	gboolean result;
#line 35 "../src/dash-entry.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 37 "../src/dash-entry.vala"
	result = self->priv->_did_respond;
#line 37 "../src/dash-entry.vala"
	return result;
#line 1061 "dash-entry.c"
}

void
dash_entry_set_did_respond (DashEntry* self,
                            gboolean value)
{
#line 39 "../src/dash-entry.vala"
	g_return_if_fail (self != NULL);
#line 41 "../src/dash-entry.vala"
	self->priv->_did_respond = value;
#line 42 "../src/dash-entry.vala"
	if (value) {
#line 43 "../src/dash-entry.vala"
		gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_ACTIVE, FALSE);
#line 1076 "dash-entry.c"
	} else {
#line 45 "../src/dash-entry.vala"
		gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_ACTIVE);
#line 1080 "dash-entry.c"
	}
#line 46 "../src/dash-entry.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 39 "../src/dash-entry.vala"
	g_object_notify_by_pspec ((GObject *) self, dash_entry_properties[DASH_ENTRY_DID_RESPOND_PROPERTY]);
#line 1086 "dash-entry.c"
}

static FadeTracker*
dash_entry_real_get_fade_tracker (Fadable* base)
{
	FadeTracker* result;
	DashEntry* self;
	FadeTracker* _tmp0_;
#line 50 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 50 "../src/dash-entry.vala"
	_tmp0_ = self->priv->_fade_tracker;
#line 50 "../src/dash-entry.vala"
	result = _tmp0_;
#line 50 "../src/dash-entry.vala"
	return result;
#line 1103 "dash-entry.c"
}

static void
dash_entry_real_set_fade_tracker (Fadable* base,
                                  FadeTracker* value)
{
	DashEntry* self;
	FadeTracker* old_value;
#line 50 "../src/dash-entry.vala"
	self = (DashEntry*) base;
#line 50 "../src/dash-entry.vala"
	old_value = dash_entry_real_get_fade_tracker (base);
#line 50 "../src/dash-entry.vala"
	if (old_value != value) {
#line 1118 "dash-entry.c"
		FadeTracker* _tmp0_;
#line 50 "../src/dash-entry.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 50 "../src/dash-entry.vala"
		_g_object_unref0 (self->priv->_fade_tracker);
#line 50 "../src/dash-entry.vala"
		self->priv->_fade_tracker = _tmp0_;
#line 50 "../src/dash-entry.vala"
		g_object_notify_by_pspec ((GObject *) self, dash_entry_properties[DASH_ENTRY_FADE_TRACKER_PROPERTY]);
#line 1128 "dash-entry.c"
	}
}

static void
_gtk_widget_queue_draw_g_object_notify (GObject* _sender,
                                        GParamSpec* pspec,
                                        gpointer self)
{
#line 58 "../src/dash-entry.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1139 "dash-entry.c"
}

static gboolean
_dash_entry_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                 GdkEventButton* event,
                                                                 gpointer self)
{
	gboolean result;
	result = dash_entry_button_press_event_cb ((DashEntry*) self, event);
#line 59 "../src/dash-entry.vala"
	return result;
#line 1151 "dash-entry.c"
}

static GObject *
dash_entry_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DashEntry * self;
	FadeTracker* _tmp0_;
	FadeTracker* _tmp1_;
	GdkPixbuf* _tmp2_;
	const gchar* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoFontDescription* _tmp12_;
	GtkStyleContext* style_ctx = NULL;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GError* _inner_error0_ = NULL;
#line 54 "../src/dash-entry.vala"
	parent_class = G_OBJECT_CLASS (dash_entry_parent_class);
#line 54 "../src/dash-entry.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 54 "../src/dash-entry.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DASH_ENTRY, DashEntry);
#line 56 "../src/dash-entry.vala"
	_tmp0_ = fade_tracker_new ((GtkWidget*) self);
#line 56 "../src/dash-entry.vala"
	_tmp1_ = _tmp0_;
#line 56 "../src/dash-entry.vala"
	fadable_set_fade_tracker ((Fadable*) self, _tmp1_);
#line 56 "../src/dash-entry.vala"
	_g_object_unref0 (_tmp1_);
#line 58 "../src/dash-entry.vala"
	g_signal_connect_object ((GObject*) self, "notify::can-respond", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
#line 59 "../src/dash-entry.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _dash_entry_button_press_event_cb_gtk_widget_button_press_event, self, 0);
#line 61 "../src/dash-entry.vala"
	_tmp2_ = dash_entry_arrow_pixbuf;
#line 61 "../src/dash-entry.vala"
	if (_tmp2_ == NULL) {
#line 1194 "dash-entry.c"
		gchar* filename = NULL;
		gchar* _tmp3_;
#line 63 "../src/dash-entry.vala"
		_tmp3_ = g_build_filename (PKGDATADIR, "arrow_right.svg", NULL);
#line 63 "../src/dash-entry.vala"
		filename = _tmp3_;
#line 1201 "dash-entry.c"
		{
			GdkPixbuf* _tmp4_ = NULL;
			const gchar* _tmp5_;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
#line 66 "../src/dash-entry.vala"
			_tmp5_ = filename;
#line 66 "../src/dash-entry.vala"
			_tmp6_ = gdk_pixbuf_new_from_file (_tmp5_, &_inner_error0_);
#line 66 "../src/dash-entry.vala"
			_tmp4_ = _tmp6_;
#line 66 "../src/dash-entry.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1215 "dash-entry.c"
				goto __catch0_g_error;
			}
#line 66 "../src/dash-entry.vala"
			_tmp7_ = _tmp4_;
#line 66 "../src/dash-entry.vala"
			_tmp4_ = NULL;
#line 66 "../src/dash-entry.vala"
			_g_object_unref0 (dash_entry_arrow_pixbuf);
#line 66 "../src/dash-entry.vala"
			dash_entry_arrow_pixbuf = _tmp7_;
#line 64 "../src/dash-entry.vala"
			_g_object_unref0 (_tmp4_);
#line 1228 "dash-entry.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
#line 64 "../src/dash-entry.vala"
			e = _inner_error0_;
#line 64 "../src/dash-entry.vala"
			_inner_error0_ = NULL;
#line 70 "../src/dash-entry.vala"
			_tmp8_ = e;
#line 70 "../src/dash-entry.vala"
			_tmp9_ = _tmp8_->message;
#line 70 "../src/dash-entry.vala"
			g_debug ("dash-entry.vala:70: Internal error loading arrow icon: %s", _tmp9_);
#line 64 "../src/dash-entry.vala"
			_g_error_free0 (e);
#line 1248 "dash-entry.c"
		}
		__finally0:
#line 64 "../src/dash-entry.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 64 "../src/dash-entry.vala"
			_g_free0 (filename);
#line 64 "../src/dash-entry.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 64 "../src/dash-entry.vala"
			g_clear_error (&_inner_error0_);
#line 1259 "dash-entry.c"
		}
#line 61 "../src/dash-entry.vala"
		_g_free0 (filename);
#line 1263 "dash-entry.c"
	}
#line 74 "../src/dash-entry.vala"
	_tmp10_ = dash_entry_font;
#line 74 "../src/dash-entry.vala"
	_tmp11_ = pango_font_description_from_string (_tmp10_);
#line 74 "../src/dash-entry.vala"
	_tmp12_ = _tmp11_;
#line 74 "../src/dash-entry.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp12_);
#line 74 "../src/dash-entry.vala"
	__vala_PangoFontDescription_free0 (_tmp12_);
#line 76 "../src/dash-entry.vala"
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 76 "../src/dash-entry.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 76 "../src/dash-entry.vala"
	style_ctx = _tmp14_;
#line 1281 "dash-entry.c"
	{
		GtkCssProvider* padding_provider = NULL;
		GtkCssProvider* _tmp15_;
		gchar* css = NULL;
		gchar* _tmp16_;
		GtkCssProvider* _tmp17_;
		const gchar* _tmp18_;
		GtkStyleContext* _tmp19_;
		GtkCssProvider* _tmp20_;
#line 80 "../src/dash-entry.vala"
		_tmp15_ = gtk_css_provider_new ();
#line 80 "../src/dash-entry.vala"
		padding_provider = _tmp15_;
#line 81 "../src/dash-entry.vala"
		_tmp16_ = g_strdup_printf ("* {padding-right: %dpx;}", dash_entry_get_arrow_size (self));
#line 81 "../src/dash-entry.vala"
		css = _tmp16_;
#line 82 "../src/dash-entry.vala"
		_tmp17_ = padding_provider;
#line 82 "../src/dash-entry.vala"
		_tmp18_ = css;
#line 82 "../src/dash-entry.vala"
		gtk_css_provider_load_from_data (_tmp17_, _tmp18_, (gssize) -1, &_inner_error0_);
#line 82 "../src/dash-entry.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 82 "../src/dash-entry.vala"
			_g_free0 (css);
#line 82 "../src/dash-entry.vala"
			_g_object_unref0 (padding_provider);
#line 1311 "dash-entry.c"
			goto __catch1_g_error;
		}
#line 83 "../src/dash-entry.vala"
		_tmp19_ = style_ctx;
#line 83 "../src/dash-entry.vala"
		_tmp20_ = padding_provider;
#line 83 "../src/dash-entry.vala"
		gtk_style_context_add_provider (_tmp19_, (GtkStyleProvider*) _tmp20_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 78 "../src/dash-entry.vala"
		_g_free0 (css);
#line 78 "../src/dash-entry.vala"
		_g_object_unref0 (padding_provider);
#line 1324 "dash-entry.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
#line 78 "../src/dash-entry.vala"
		e = _inner_error0_;
#line 78 "../src/dash-entry.vala"
		_inner_error0_ = NULL;
#line 88 "../src/dash-entry.vala"
		_tmp21_ = e;
#line 88 "../src/dash-entry.vala"
		_tmp22_ = _tmp21_->message;
#line 88 "../src/dash-entry.vala"
		g_debug ("dash-entry.vala:88: Internal error loading padding style: %s", _tmp22_);
#line 78 "../src/dash-entry.vala"
		_g_error_free0 (e);
#line 1344 "dash-entry.c"
	}
	__finally1:
#line 78 "../src/dash-entry.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 78 "../src/dash-entry.vala"
		_g_object_unref0 (style_ctx);
#line 78 "../src/dash-entry.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 78 "../src/dash-entry.vala"
		g_clear_error (&_inner_error0_);
#line 1355 "dash-entry.c"
	}
#line 54 "../src/dash-entry.vala"
	_g_object_unref0 (style_ctx);
#line 54 "../src/dash-entry.vala"
	return obj;
#line 1361 "dash-entry.c"
}

static void
dash_entry_class_init (DashEntryClass * klass,
                       gpointer klass_data)
{
	gchar* _tmp0_;
#line 24 "../src/dash-entry.vala"
	dash_entry_parent_class = g_type_class_peek_parent (klass);
#line 24 "../src/dash-entry.vala"
	g_type_class_adjust_private_offset (klass, &DashEntry_private_offset);
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) dash_entry_real_draw;
#line 24 "../src/dash-entry.vala"
	((GtkEntryClass *) klass)->activate = (void (*) (GtkEntry*)) dash_entry_real_activate;
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) dash_entry_real_size_allocate;
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) dash_entry_real_realize;
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->unrealize = (void (*) (GtkWidget*)) dash_entry_real_unrealize;
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) dash_entry_real_map;
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->unmap = (void (*) (GtkWidget*)) dash_entry_real_unmap;
#line 24 "../src/dash-entry.vala"
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) dash_entry_real_key_press_event;
#line 24 "../src/dash-entry.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_dash_entry_get_property;
#line 24 "../src/dash-entry.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_dash_entry_set_property;
#line 24 "../src/dash-entry.vala"
	G_OBJECT_CLASS (klass)->constructor = dash_entry_constructor;
#line 24 "../src/dash-entry.vala"
	G_OBJECT_CLASS (klass)->finalize = dash_entry_finalize;
#line 24 "../src/dash-entry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT_PROPERTY, dash_entry_properties[DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT_PROPERTY] = g_param_spec_string ("constant-placeholder-text", "constant-placeholder-text", "constant-placeholder-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../src/dash-entry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_CAN_RESPOND_PROPERTY, dash_entry_properties[DASH_ENTRY_CAN_RESPOND_PROPERTY] = g_param_spec_boolean ("can-respond", "can-respond", "can-respond", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../src/dash-entry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_DID_RESPOND_PROPERTY, dash_entry_properties[DASH_ENTRY_DID_RESPOND_PROPERTY] = g_param_spec_boolean ("did-respond", "did-respond", "did-respond", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../src/dash-entry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_FADE_TRACKER_PROPERTY, dash_entry_properties[DASH_ENTRY_FADE_TRACKER_PROPERTY] = g_param_spec_object ("fade-tracker", "fade-tracker", "fade-tracker", TYPE_FADE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../src/dash-entry.vala"
	dash_entry_signals[DASH_ENTRY_RESPOND_SIGNAL] = g_signal_new ("respond", TYPE_DASH_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "../src/dash-entry.vala"
	_tmp0_ = g_strdup ("Ubuntu 14");
#line 26 "../src/dash-entry.vala"
	dash_entry_font = _tmp0_;
#line 1411 "dash-entry.c"
}

static void
dash_entry_fadable_interface_init (FadableIface * iface,
                                   gpointer iface_data)
{
#line 24 "../src/dash-entry.vala"
	dash_entry_fadable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../src/dash-entry.vala"
	iface->get_fade_tracker = dash_entry_real_get_fade_tracker;
#line 24 "../src/dash-entry.vala"
	iface->set_fade_tracker = dash_entry_real_set_fade_tracker;
#line 1424 "dash-entry.c"
}

static void
dash_entry_instance_init (DashEntry * self,
                          gpointer klass)
{
#line 24 "../src/dash-entry.vala"
	self->priv = dash_entry_get_instance_private (self);
#line 30 "../src/dash-entry.vala"
	self->priv->_can_respond = TRUE;
#line 1435 "dash-entry.c"
}

static void
dash_entry_finalize (GObject * obj)
{
	DashEntry * self;
#line 24 "../src/dash-entry.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DASH_ENTRY, DashEntry);
#line 29 "../src/dash-entry.vala"
	_g_free0 (self->priv->_constant_placeholder_text);
#line 50 "../src/dash-entry.vala"
	_g_object_unref0 (self->priv->_fade_tracker);
#line 51 "../src/dash-entry.vala"
	_g_object_unref0 (self->priv->arrow_win);
#line 24 "../src/dash-entry.vala"
	G_OBJECT_CLASS (dash_entry_parent_class)->finalize (obj);
#line 1452 "dash-entry.c"
}

static GType
dash_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DashEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dash_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DashEntry), 0, (GInstanceInitFunc) dash_entry_instance_init, NULL };
	static const GInterfaceInfo fadable_info = { (GInterfaceInitFunc) dash_entry_fadable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dash_entry_type_id;
	dash_entry_type_id = g_type_register_static (gtk_entry_get_type (), "DashEntry", &g_define_type_info, 0);
	g_type_add_interface_static (dash_entry_type_id, TYPE_FADABLE, &fadable_info);
	DashEntry_private_offset = g_type_add_instance_private (dash_entry_type_id, sizeof (DashEntryPrivate));
	return dash_entry_type_id;
}

GType
dash_entry_get_type (void)
{
	static volatile gsize dash_entry_type_id__once = 0;
	if (g_once_init_enter (&dash_entry_type_id__once)) {
		GType dash_entry_type_id;
		dash_entry_type_id = dash_entry_get_type_once ();
		g_once_init_leave (&dash_entry_type_id__once, dash_entry_type_id);
	}
	return dash_entry_type_id__once;
}

static void
_vala_dash_entry_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	DashEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DASH_ENTRY, DashEntry);
#line 24 "../src/dash-entry.vala"
	switch (property_id) {
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT_PROPERTY:
#line 24 "../src/dash-entry.vala"
		g_value_set_string (value, dash_entry_get_constant_placeholder_text (self));
#line 24 "../src/dash-entry.vala"
		break;
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_CAN_RESPOND_PROPERTY:
#line 24 "../src/dash-entry.vala"
		g_value_set_boolean (value, dash_entry_get_can_respond (self));
#line 24 "../src/dash-entry.vala"
		break;
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_DID_RESPOND_PROPERTY:
#line 24 "../src/dash-entry.vala"
		g_value_set_boolean (value, dash_entry_get_did_respond (self));
#line 24 "../src/dash-entry.vala"
		break;
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_FADE_TRACKER_PROPERTY:
#line 24 "../src/dash-entry.vala"
		g_value_set_object (value, fadable_get_fade_tracker ((Fadable*) self));
#line 24 "../src/dash-entry.vala"
		break;
#line 1513 "dash-entry.c"
		default:
#line 24 "../src/dash-entry.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../src/dash-entry.vala"
		break;
#line 1519 "dash-entry.c"
	}
}

static void
_vala_dash_entry_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	DashEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DASH_ENTRY, DashEntry);
#line 24 "../src/dash-entry.vala"
	switch (property_id) {
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT_PROPERTY:
#line 24 "../src/dash-entry.vala"
		dash_entry_set_constant_placeholder_text (self, g_value_get_string (value));
#line 24 "../src/dash-entry.vala"
		break;
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_CAN_RESPOND_PROPERTY:
#line 24 "../src/dash-entry.vala"
		dash_entry_set_can_respond (self, g_value_get_boolean (value));
#line 24 "../src/dash-entry.vala"
		break;
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_DID_RESPOND_PROPERTY:
#line 24 "../src/dash-entry.vala"
		dash_entry_set_did_respond (self, g_value_get_boolean (value));
#line 24 "../src/dash-entry.vala"
		break;
#line 24 "../src/dash-entry.vala"
		case DASH_ENTRY_FADE_TRACKER_PROPERTY:
#line 24 "../src/dash-entry.vala"
		fadable_set_fade_tracker ((Fadable*) self, g_value_get_object (value));
#line 24 "../src/dash-entry.vala"
		break;
#line 1557 "dash-entry.c"
		default:
#line 24 "../src/dash-entry.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../src/dash-entry.vala"
		break;
#line 1563 "dash-entry.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

