/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_ad9777_regs.py on Sat Dec 13 19:39:22 2025
 **********************************************************************/

#ifndef INCLUDED_AD9777_REGS_HPP
#define INCLUDED_AD9777_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class ad9777_regs_t{
public:
    enum sdio_bidirectional_t{
        SDIO_BIDIRECTIONAL_INPUT = 0,
        SDIO_BIDIRECTIONAL_IO = 1
    };
    sdio_bidirectional_t sdio_bidirectional;
    enum lsb_msb_first_t{
        LSB_MSB_FIRST_MSB = 0,
        LSB_MSB_FIRST_LSB = 1
    };
    lsb_msb_first_t lsb_msb_first;
    uint8_t soft_reset;
    uint8_t sleep_mode;
    uint8_t power_down_mode;
    enum x_1r_2r_mode_t{
        X_1R_2R_MODE_2R = 0,
        X_1R_2R_MODE_1R = 1
    };
    x_1r_2r_mode_t x_1r_2r_mode;
    uint8_t pll_lock_indicator;
    enum filter_interp_rate_t{
        FILTER_INTERP_RATE_1X = 0,
        FILTER_INTERP_RATE_2X = 1,
        FILTER_INTERP_RATE_4X = 2,
        FILTER_INTERP_RATE_8X = 3
    };
    filter_interp_rate_t filter_interp_rate;
    enum modulation_mode_t{
        MODULATION_MODE_NONE = 0,
        MODULATION_MODE_FS_2 = 1,
        MODULATION_MODE_FS_4 = 2,
        MODULATION_MODE_FS_8 = 3
    };
    modulation_mode_t modulation_mode;
    uint8_t zero_stuff_mode;
    enum mix_mode_t{
        MIX_MODE_COMPLEX = 0,
        MIX_MODE_REAL = 1
    };
    mix_mode_t mix_mode;
    enum modulation_form_t{
        MODULATION_FORM_E_MINUS_JWT = 0,
        MODULATION_FORM_E_PLUS_JWT = 1
    };
    modulation_form_t modulation_form;
    enum data_clk_pll_lock_sel_t{
        DATA_CLK_PLL_LOCK_SEL_PLL_LOCK = 0,
        DATA_CLK_PLL_LOCK_SEL_DATA_CLK = 1
    };
    data_clk_pll_lock_sel_t data_clk_pll_lock_sel;
    enum signed_input_data_t{
        SIGNED_INPUT_DATA_SIGNED = 0,
        SIGNED_INPUT_DATA_UNSIGNED = 1
    };
    signed_input_data_t signed_input_data;
    enum two_port_mode_t{
        TWO_PORT_MODE_TWO_PORT = 0,
        TWO_PORT_MODE_ONE_PORT = 1
    };
    two_port_mode_t two_port_mode;
    enum dataclk_driver_strength_t{
        DATACLK_DRIVER_STRENGTH_WEAK = 0,
        DATACLK_DRIVER_STRENGTH_STRONG = 1
    };
    dataclk_driver_strength_t dataclk_driver_strength;
    uint8_t dataclk_invert;
    uint8_t oneportclk_invert;
    uint8_t iqsel_invert;
    enum iq_first_t{
        IQ_FIRST_I_FIRST = 0,
        IQ_FIRST_Q_FIRST = 1
    };
    iq_first_t iq_first;
    enum data_rate_clock_output_t{
        DATA_RATE_CLOCK_OUTPUT_PLL_LOCK = 0,
        DATA_RATE_CLOCK_OUTPUT_SPI_SDO = 1
    };
    data_rate_clock_output_t data_rate_clock_output;
    enum pll_divide_ratio_t{
        PLL_DIVIDE_RATIO_DIV1 = 0,
        PLL_DIVIDE_RATIO_DIV2 = 1,
        PLL_DIVIDE_RATIO_DIV4 = 2,
        PLL_DIVIDE_RATIO_DIV8 = 3
    };
    pll_divide_ratio_t pll_divide_ratio;
    enum pll_state_t{
        PLL_STATE_OFF = 0,
        PLL_STATE_ON = 1
    };
    pll_state_t pll_state;
    enum auto_cp_control_t{
        AUTO_CP_CONTROL_AUTO = 0,
        AUTO_CP_CONTROL_MANUAL = 1
    };
    auto_cp_control_t auto_cp_control;
    enum pll_cp_control_t{
        PLL_CP_CONTROL_50UA = 0,
        PLL_CP_CONTROL_100UA = 1,
        PLL_CP_CONTROL_200UA = 2,
        PLL_CP_CONTROL_400UA = 3,
        PLL_CP_CONTROL_800UA = 7
    };
    pll_cp_control_t pll_cp_control;
    uint8_t idac_fine_gain_adjust;
    uint8_t qdac_fine_gain_adjust;
    uint8_t idac_coarse_gain_adjust;
    uint8_t qdac_coarse_gain_adjust;
    uint8_t idac_offset_adjust_msb;
    uint8_t idac_offset_adjust_lsb;
    enum idac_ioffset_direction_t{
        IDAC_IOFFSET_DIRECTION_OUT_A = 0,
        IDAC_IOFFSET_DIRECTION_OUT_B = 1
    };
    idac_ioffset_direction_t idac_ioffset_direction;
    uint8_t qdac_offset_adjust_msb;
    uint8_t qdac_offset_adjust_lsb;
    enum qdac_ioffset_direction_t{
        QDAC_IOFFSET_DIRECTION_OUT_A = 0,
        QDAC_IOFFSET_DIRECTION_OUT_B = 1
    };
    qdac_ioffset_direction_t qdac_ioffset_direction;

    ad9777_regs_t(void){
        _state = NULL;
        sdio_bidirectional = SDIO_BIDIRECTIONAL_INPUT;
        lsb_msb_first = LSB_MSB_FIRST_MSB;
        soft_reset = 0;
        sleep_mode = 0;
        power_down_mode = 0;
        x_1r_2r_mode = X_1R_2R_MODE_2R;
        pll_lock_indicator = 0;
        filter_interp_rate = FILTER_INTERP_RATE_1X;
        modulation_mode = MODULATION_MODE_NONE;
        zero_stuff_mode = 0;
        mix_mode = MIX_MODE_REAL;
        modulation_form = MODULATION_FORM_E_MINUS_JWT;
        data_clk_pll_lock_sel = DATA_CLK_PLL_LOCK_SEL_PLL_LOCK;
        signed_input_data = SIGNED_INPUT_DATA_SIGNED;
        two_port_mode = TWO_PORT_MODE_TWO_PORT;
        dataclk_driver_strength = DATACLK_DRIVER_STRENGTH_WEAK;
        dataclk_invert = 0;
        oneportclk_invert = 0;
        iqsel_invert = 0;
        iq_first = IQ_FIRST_I_FIRST;
        data_rate_clock_output = DATA_RATE_CLOCK_OUTPUT_PLL_LOCK;
        pll_divide_ratio = PLL_DIVIDE_RATIO_DIV1;
        pll_state = PLL_STATE_OFF;
        auto_cp_control = AUTO_CP_CONTROL_AUTO;
        pll_cp_control = PLL_CP_CONTROL_50UA;
        idac_fine_gain_adjust = 0;
        qdac_fine_gain_adjust = 0;
        idac_coarse_gain_adjust = 0;
        qdac_coarse_gain_adjust = 0;
        idac_offset_adjust_msb = 0;
        idac_offset_adjust_lsb = 0;
        idac_ioffset_direction = IDAC_IOFFSET_DIRECTION_OUT_A;
        qdac_offset_adjust_msb = 0;
        qdac_offset_adjust_lsb = 0;
        qdac_ioffset_direction = QDAC_IOFFSET_DIRECTION_OUT_A;
    }

    ~ad9777_regs_t(void){
        delete _state;
    }

    uint8_t get_reg(uint8_t addr){
        uint8_t reg = 0;
        switch(addr){
        case 0:
            reg |= (uint8_t(sdio_bidirectional) & 0x1) << 7;
            reg |= (uint8_t(lsb_msb_first) & 0x1) << 6;
            reg |= (uint8_t(soft_reset) & 0x1) << 5;
            reg |= (uint8_t(sleep_mode) & 0x1) << 4;
            reg |= (uint8_t(power_down_mode) & 0x1) << 3;
            reg |= (uint8_t(x_1r_2r_mode) & 0x1) << 2;
            reg |= (uint8_t(pll_lock_indicator) & 0x1) << 1;
            break;
        case 1:
            reg |= (uint8_t(filter_interp_rate) & 0x3) << 6;
            reg |= (uint8_t(modulation_mode) & 0x3) << 4;
            reg |= (uint8_t(zero_stuff_mode) & 0x1) << 3;
            reg |= (uint8_t(mix_mode) & 0x1) << 2;
            reg |= (uint8_t(modulation_form) & 0x1) << 1;
            reg |= (uint8_t(data_clk_pll_lock_sel) & 0x1) << 0;
            break;
        case 2:
            reg |= (uint8_t(signed_input_data) & 0x1) << 7;
            reg |= (uint8_t(two_port_mode) & 0x1) << 6;
            reg |= (uint8_t(dataclk_driver_strength) & 0x1) << 5;
            reg |= (uint8_t(dataclk_invert) & 0x1) << 4;
            reg |= (uint8_t(oneportclk_invert) & 0x1) << 2;
            reg |= (uint8_t(iqsel_invert) & 0x1) << 1;
            reg |= (uint8_t(iq_first) & 0x1) << 0;
            break;
        case 3:
            reg |= (uint8_t(data_rate_clock_output) & 0x1) << 7;
            reg |= (uint8_t(pll_divide_ratio) & 0x3) << 0;
            break;
        case 4:
            reg |= (uint8_t(pll_state) & 0x1) << 7;
            reg |= (uint8_t(auto_cp_control) & 0x1) << 6;
            reg |= (uint8_t(pll_cp_control) & 0x7) << 0;
            break;
        case 5:
            reg |= (uint8_t(idac_fine_gain_adjust) & 0xff) << 0;
            break;
        case 6:
            reg |= (uint8_t(idac_coarse_gain_adjust) & 0xf) << 0;
            break;
        case 7:
            reg |= (uint8_t(idac_offset_adjust_msb) & 0xff) << 0;
            break;
        case 8:
            reg |= (uint8_t(idac_offset_adjust_lsb) & 0x3) << 0;
            reg |= (uint8_t(idac_ioffset_direction) & 0x1) << 7;
            break;
        case 9:
            reg |= (uint8_t(qdac_fine_gain_adjust) & 0xff) << 0;
            break;
        case 10:
            reg |= (uint8_t(qdac_coarse_gain_adjust) & 0xf) << 0;
            break;
        case 11:
            reg |= (uint8_t(qdac_offset_adjust_msb) & 0xff) << 0;
            break;
        case 12:
            reg |= (uint8_t(qdac_offset_adjust_lsb) & 0x3) << 0;
            reg |= (uint8_t(qdac_ioffset_direction) & 0x1) << 7;
            break;
        }
        return reg;
    }
    
    uint16_t get_write_reg(uint8_t addr){
        return (uint16_t(addr) << 8) | get_reg(addr);
    }
    
    uint16_t get_read_reg(uint8_t addr){
        return (uint16_t(addr) << 8) | (1 << 7);
    }

    void save_state(void){
        if (_state == NULL) _state = new ad9777_regs_t();
        _state->sdio_bidirectional = this->sdio_bidirectional;
        _state->lsb_msb_first = this->lsb_msb_first;
        _state->soft_reset = this->soft_reset;
        _state->sleep_mode = this->sleep_mode;
        _state->power_down_mode = this->power_down_mode;
        _state->x_1r_2r_mode = this->x_1r_2r_mode;
        _state->pll_lock_indicator = this->pll_lock_indicator;
        _state->filter_interp_rate = this->filter_interp_rate;
        _state->modulation_mode = this->modulation_mode;
        _state->zero_stuff_mode = this->zero_stuff_mode;
        _state->mix_mode = this->mix_mode;
        _state->modulation_form = this->modulation_form;
        _state->data_clk_pll_lock_sel = this->data_clk_pll_lock_sel;
        _state->signed_input_data = this->signed_input_data;
        _state->two_port_mode = this->two_port_mode;
        _state->dataclk_driver_strength = this->dataclk_driver_strength;
        _state->dataclk_invert = this->dataclk_invert;
        _state->oneportclk_invert = this->oneportclk_invert;
        _state->iqsel_invert = this->iqsel_invert;
        _state->iq_first = this->iq_first;
        _state->data_rate_clock_output = this->data_rate_clock_output;
        _state->pll_divide_ratio = this->pll_divide_ratio;
        _state->pll_state = this->pll_state;
        _state->auto_cp_control = this->auto_cp_control;
        _state->pll_cp_control = this->pll_cp_control;
        _state->idac_fine_gain_adjust = this->idac_fine_gain_adjust;
        _state->qdac_fine_gain_adjust = this->qdac_fine_gain_adjust;
        _state->idac_coarse_gain_adjust = this->idac_coarse_gain_adjust;
        _state->qdac_coarse_gain_adjust = this->qdac_coarse_gain_adjust;
        _state->idac_offset_adjust_msb = this->idac_offset_adjust_msb;
        _state->idac_offset_adjust_lsb = this->idac_offset_adjust_lsb;
        _state->idac_ioffset_direction = this->idac_ioffset_direction;
        _state->qdac_offset_adjust_msb = this->qdac_offset_adjust_msb;
        _state->qdac_offset_adjust_lsb = this->qdac_offset_adjust_lsb;
        _state->qdac_ioffset_direction = this->qdac_ioffset_direction;
    }

    sdio_bidirectional_t get_state_sdio_bidirectional(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sdio_bidirectional;
    }

    lsb_msb_first_t get_state_lsb_msb_first(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lsb_msb_first;
    }

    uint8_t get_state_soft_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->soft_reset;
    }

    uint8_t get_state_sleep_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sleep_mode;
    }

    uint8_t get_state_power_down_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_mode;
    }

    x_1r_2r_mode_t get_state_x_1r_2r_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->x_1r_2r_mode;
    }

    uint8_t get_state_pll_lock_indicator(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_lock_indicator;
    }

    filter_interp_rate_t get_state_filter_interp_rate(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->filter_interp_rate;
    }

    modulation_mode_t get_state_modulation_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->modulation_mode;
    }

    uint8_t get_state_zero_stuff_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->zero_stuff_mode;
    }

    mix_mode_t get_state_mix_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mix_mode;
    }

    modulation_form_t get_state_modulation_form(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->modulation_form;
    }

    data_clk_pll_lock_sel_t get_state_data_clk_pll_lock_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->data_clk_pll_lock_sel;
    }

    signed_input_data_t get_state_signed_input_data(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->signed_input_data;
    }

    two_port_mode_t get_state_two_port_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->two_port_mode;
    }

    dataclk_driver_strength_t get_state_dataclk_driver_strength(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dataclk_driver_strength;
    }

    uint8_t get_state_dataclk_invert(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dataclk_invert;
    }

    uint8_t get_state_oneportclk_invert(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->oneportclk_invert;
    }

    uint8_t get_state_iqsel_invert(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->iqsel_invert;
    }

    iq_first_t get_state_iq_first(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->iq_first;
    }

    data_rate_clock_output_t get_state_data_rate_clock_output(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->data_rate_clock_output;
    }

    pll_divide_ratio_t get_state_pll_divide_ratio(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_divide_ratio;
    }

    pll_state_t get_state_pll_state(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_state;
    }

    auto_cp_control_t get_state_auto_cp_control(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->auto_cp_control;
    }

    pll_cp_control_t get_state_pll_cp_control(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_cp_control;
    }

    uint8_t get_state_idac_fine_gain_adjust(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->idac_fine_gain_adjust;
    }

    uint8_t get_state_qdac_fine_gain_adjust(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->qdac_fine_gain_adjust;
    }

    uint8_t get_state_idac_coarse_gain_adjust(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->idac_coarse_gain_adjust;
    }

    uint8_t get_state_qdac_coarse_gain_adjust(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->qdac_coarse_gain_adjust;
    }

    uint8_t get_state_idac_offset_adjust_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->idac_offset_adjust_msb;
    }

    uint8_t get_state_idac_offset_adjust_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->idac_offset_adjust_lsb;
    }

    idac_ioffset_direction_t get_state_idac_ioffset_direction(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->idac_ioffset_direction;
    }

    uint8_t get_state_qdac_offset_adjust_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->qdac_offset_adjust_msb;
    }

    uint8_t get_state_qdac_offset_adjust_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->qdac_offset_adjust_lsb;
    }

    qdac_ioffset_direction_t get_state_qdac_ioffset_direction(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->qdac_ioffset_direction;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->sdio_bidirectional != this->sdio_bidirectional) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->lsb_msb_first != this->lsb_msb_first) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->soft_reset != this->soft_reset) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->sleep_mode != this->sleep_mode) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_mode != this->power_down_mode) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->x_1r_2r_mode != this->x_1r_2r_mode) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_lock_indicator != this->pll_lock_indicator) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->filter_interp_rate != this->filter_interp_rate) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->modulation_mode != this->modulation_mode) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->zero_stuff_mode != this->zero_stuff_mode) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->mix_mode != this->mix_mode) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->modulation_form != this->modulation_form) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->data_clk_pll_lock_sel != this->data_clk_pll_lock_sel) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->signed_input_data != this->signed_input_data) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->two_port_mode != this->two_port_mode) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->dataclk_driver_strength != this->dataclk_driver_strength) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->dataclk_invert != this->dataclk_invert) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->oneportclk_invert != this->oneportclk_invert) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->iqsel_invert != this->iqsel_invert) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->iq_first != this->iq_first) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->data_rate_clock_output != this->data_rate_clock_output) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_divide_ratio != this->pll_divide_ratio) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_state != this->pll_state) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->auto_cp_control != this->auto_cp_control) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_cp_control != this->pll_cp_control) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->idac_fine_gain_adjust != this->idac_fine_gain_adjust) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->qdac_fine_gain_adjust != this->qdac_fine_gain_adjust) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->idac_coarse_gain_adjust != this->idac_coarse_gain_adjust) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->qdac_coarse_gain_adjust != this->qdac_coarse_gain_adjust) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->idac_offset_adjust_msb != this->idac_offset_adjust_msb) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->idac_offset_adjust_lsb != this->idac_offset_adjust_lsb) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->idac_ioffset_direction != this->idac_ioffset_direction) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->qdac_offset_adjust_msb != this->qdac_offset_adjust_msb) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->qdac_offset_adjust_lsb != this->qdac_offset_adjust_lsb) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->qdac_ioffset_direction != this->qdac_ioffset_direction) {
                addrs.insert(12);
            }
        }
        return addrs;
    }

    uint16_t get_idac_offset_adjust(void){
        return 
        (uint16_t(idac_offset_adjust_lsb & 0x3) << 0) |
        (uint16_t(idac_offset_adjust_msb & 0xff) << 2) |
        0;
    }

    void set_idac_offset_adjust(uint16_t reg){
        idac_offset_adjust_lsb = (reg >> 0) & 0x3;
        idac_offset_adjust_msb = (reg >> 2) & 0xff;
    }

    uint16_t get_qdac_offset_adjust(void){
        return 
        (uint16_t(qdac_offset_adjust_lsb & 0x3) << 0) |
        (uint16_t(qdac_offset_adjust_msb & 0xff) << 2) |
        0;
    }

    void set_qdac_offset_adjust(uint16_t reg){
        qdac_offset_adjust_lsb = (reg >> 0) & 0x3;
        qdac_offset_adjust_msb = (reg >> 2) & 0xff;
    }

private:
    ad9777_regs_t *_state;
};

#endif /* INCLUDED_AD9777_REGS_HPP */
