/* state.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from state.vala, do not modify */

/* -*- coding: utf-8 -*-*/
/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "libskk/libskk.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_STATE (skk_state_get_type ())
#define SKK_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_STATE, SkkState))
#define SKK_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_STATE, SkkStateClass))
#define SKK_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_STATE))
#define SKK_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_STATE))
#define SKK_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_STATE, SkkStateClass))

typedef struct _SkkState SkkState;
typedef struct _SkkStateClass SkkStateClass;
typedef struct _SkkStatePrivate SkkStatePrivate;

#define SKK_TYPE_UNICODE_STRING (skk_unicode_string_get_type ())
#define SKK_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeString))
#define SKK_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))
#define SKK_IS_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_UNICODE_STRING))
#define SKK_IS_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_UNICODE_STRING))
#define SKK_UNICODE_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))

typedef struct _SkkUnicodeString SkkUnicodeString;
typedef struct _SkkUnicodeStringClass SkkUnicodeStringClass;
enum  {
	SKK_STATE_0_PROPERTY,
	SKK_STATE_INPUT_MODE_PROPERTY,
	SKK_STATE_PERIOD_STYLE_PROPERTY,
	SKK_STATE_TYPING_RULE_PROPERTY,
	SKK_STATE_NUM_PROPERTIES
};
static GParamSpec* skk_state_properties[SKK_STATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _skk_completion_service_unref0(var) ((var == NULL) ? NULL : (var = (skk_completion_service_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SKK_TYPE_KEYMAP (skk_keymap_get_type ())
#define SKK_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEYMAP, SkkKeymap))
#define SKK_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEYMAP, SkkKeymapClass))
#define SKK_IS_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEYMAP))
#define SKK_IS_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEYMAP))
#define SKK_KEYMAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEYMAP, SkkKeymapClass))

typedef struct _SkkKeymap SkkKeymap;
typedef struct _SkkKeymapClass SkkKeymapClass;

#define SKK_TYPE_MAP_FILE (skk_map_file_get_type ())
#define SKK_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MAP_FILE, SkkMapFile))
#define SKK_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MAP_FILE, SkkMapFileClass))
#define SKK_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MAP_FILE))
#define SKK_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MAP_FILE))
#define SKK_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MAP_FILE, SkkMapFileClass))

typedef struct _SkkMapFile SkkMapFile;
typedef struct _SkkMapFileClass SkkMapFileClass;

#define SKK_TYPE_KEYMAP_MAP_FILE (skk_keymap_map_file_get_type ())
#define SKK_KEYMAP_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEYMAP_MAP_FILE, SkkKeymapMapFile))
#define SKK_KEYMAP_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEYMAP_MAP_FILE, SkkKeymapMapFileClass))
#define SKK_IS_KEYMAP_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEYMAP_MAP_FILE))
#define SKK_IS_KEYMAP_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEYMAP_MAP_FILE))
#define SKK_KEYMAP_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEYMAP_MAP_FILE, SkkKeymapMapFileClass))

typedef struct _SkkKeymapMapFile SkkKeymapMapFile;
typedef struct _SkkKeymapMapFileClass SkkKeymapMapFileClass;
typedef struct _SkkMapFilePrivate SkkMapFilePrivate;
typedef struct _SkkKeymapMapFilePrivate SkkKeymapMapFilePrivate;

#define SKK_TYPE_SIMPLE_CANDIDATE_LIST (skk_simple_candidate_list_get_type ())
#define SKK_SIMPLE_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateList))
#define SKK_SIMPLE_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateListClass))
#define SKK_IS_SIMPLE_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST))
#define SKK_IS_SIMPLE_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_SIMPLE_CANDIDATE_LIST))
#define SKK_SIMPLE_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateListClass))

typedef struct _SkkSimpleCandidateList SkkSimpleCandidateList;
typedef struct _SkkSimpleCandidateListClass SkkSimpleCandidateListClass;

#define SKK_TYPE_STATE_HANDLER (skk_state_handler_get_type ())
#define SKK_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_STATE_HANDLER, SkkStateHandler))
#define SKK_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_STATE_HANDLER, SkkStateHandlerClass))
#define SKK_IS_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_STATE_HANDLER))
#define SKK_IS_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_STATE_HANDLER))
#define SKK_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_STATE_HANDLER, SkkStateHandlerClass))

typedef struct _SkkStateHandler SkkStateHandler;
typedef struct _SkkStateHandlerClass SkkStateHandlerClass;

#define SKK_TYPE_NONE_STATE_HANDLER (skk_none_state_handler_get_type ())
#define SKK_NONE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_NONE_STATE_HANDLER, SkkNoneStateHandler))
#define SKK_NONE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_NONE_STATE_HANDLER, SkkNoneStateHandlerClass))
#define SKK_IS_NONE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_NONE_STATE_HANDLER))
#define SKK_IS_NONE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_NONE_STATE_HANDLER))
#define SKK_NONE_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_NONE_STATE_HANDLER, SkkNoneStateHandlerClass))

typedef struct _SkkNoneStateHandler SkkNoneStateHandler;
typedef struct _SkkNoneStateHandlerClass SkkNoneStateHandlerClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

#define SKK_TYPE_EXPR_READER (skk_expr_reader_get_type ())
#define SKK_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_READER, SkkExprReader))
#define SKK_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_READER, SkkExprReaderClass))
#define SKK_IS_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_READER))
#define SKK_IS_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_READER))
#define SKK_EXPR_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_READER, SkkExprReaderClass))

typedef struct _SkkExprReader SkkExprReader;
typedef struct _SkkExprReaderClass SkkExprReaderClass;

#define SKK_TYPE_EXPR_NODE (skk_expr_node_get_type ())
typedef struct _SkkExprNode SkkExprNode;
typedef enum  {
	SKK_EXPR_NODE_TYPE_ARRAY,
	SKK_EXPR_NODE_TYPE_SYMBOL,
	SKK_EXPR_NODE_TYPE_STRING
} SkkExprNodeType;

#define SKK_TYPE_EXPR_NODE_TYPE (skk_expr_node_type_get_type ())

#define SKK_TYPE_EXPR_EVALUATOR (skk_expr_evaluator_get_type ())
#define SKK_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluator))
#define SKK_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))
#define SKK_IS_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_IS_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_EXPR_EVALUATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))

typedef struct _SkkExprEvaluator SkkExprEvaluator;
typedef struct _SkkExprEvaluatorClass SkkExprEvaluatorClass;
#define _skk_expr_node_free0(var) ((var == NULL) ? NULL : (var = (skk_expr_node_free (var), NULL)))
typedef enum  {
	SKK_NUMERIC_CONVERSION_TYPE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI,
	SKK_NUMERIC_CONVERSION_TYPE_RECONVERT,
	SKK_NUMERIC_CONVERSION_TYPE_DAIJI,
	SKK_NUMERIC_CONVERSION_TYPE_SHOGI
} SkkNumericConversionType;

#define SKK_TYPE_NUMERIC_CONVERSION_TYPE (skk_numeric_conversion_type_get_type ())

#define SKK_TYPE_ABBREV_STATE_HANDLER (skk_abbrev_state_handler_get_type ())
#define SKK_ABBREV_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ABBREV_STATE_HANDLER, SkkAbbrevStateHandler))
#define SKK_ABBREV_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ABBREV_STATE_HANDLER, SkkAbbrevStateHandlerClass))
#define SKK_IS_ABBREV_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ABBREV_STATE_HANDLER))
#define SKK_IS_ABBREV_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ABBREV_STATE_HANDLER))
#define SKK_ABBREV_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ABBREV_STATE_HANDLER, SkkAbbrevStateHandlerClass))

typedef struct _SkkAbbrevStateHandler SkkAbbrevStateHandler;
typedef struct _SkkAbbrevStateHandlerClass SkkAbbrevStateHandlerClass;

#define SKK_TYPE_ROM_KANA_MAP_FILE (skk_rom_kana_map_file_get_type ())
#define SKK_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ROM_KANA_MAP_FILE, SkkRomKanaMapFile))
#define SKK_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ROM_KANA_MAP_FILE, SkkRomKanaMapFileClass))
#define SKK_IS_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ROM_KANA_MAP_FILE))
#define SKK_IS_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ROM_KANA_MAP_FILE))
#define SKK_ROM_KANA_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ROM_KANA_MAP_FILE, SkkRomKanaMapFileClass))

typedef struct _SkkRomKanaMapFile SkkRomKanaMapFile;
typedef struct _SkkRomKanaMapFileClass SkkRomKanaMapFileClass;
enum  {
	SKK_STATE_RECURSIVE_EDIT_ABORT_SIGNAL,
	SKK_STATE_RECURSIVE_EDIT_END_SIGNAL,
	SKK_STATE_RECURSIVE_EDIT_START_SIGNAL,
	SKK_STATE_RETRIEVE_SURROUNDING_TEXT_SIGNAL,
	SKK_STATE_DELETE_SURROUNDING_TEXT_SIGNAL,
	SKK_STATE_REQUEST_SELECTION_TEXT_SIGNAL,
	SKK_STATE_NUM_SIGNALS
};
static guint skk_state_signals[SKK_STATE_NUM_SIGNALS] = {0};
typedef gboolean (*SkkCommandHandler) (SkkState* state, gpointer user_data);
typedef struct _SkkStateHandlerPrivate SkkStateHandlerPrivate;
enum  {
	SKK_STATE_HANDLER_0_PROPERTY,
	SKK_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* skk_state_handler_properties[SKK_STATE_HANDLER_NUM_PROPERTIES];

#define SKK_TYPE_INPUT_MODE_COMMAND_ENTRY (skk_input_mode_command_entry_get_type ())
typedef struct _SkkInputModeCommandEntry SkkInputModeCommandEntry;
typedef struct _SkkNoneStateHandlerPrivate SkkNoneStateHandlerPrivate;
enum  {
	SKK_NONE_STATE_HANDLER_0_PROPERTY,
	SKK_NONE_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* skk_none_state_handler_properties[SKK_NONE_STATE_HANDLER_NUM_PROPERTIES];
typedef struct _SkkUnicodeStringPrivate SkkUnicodeStringPrivate;

#define SKK_TYPE_START_STATE_HANDLER (skk_start_state_handler_get_type ())
#define SKK_START_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_START_STATE_HANDLER, SkkStartStateHandler))
#define SKK_START_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_START_STATE_HANDLER, SkkStartStateHandlerClass))
#define SKK_IS_START_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_START_STATE_HANDLER))
#define SKK_IS_START_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_START_STATE_HANDLER))
#define SKK_START_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_START_STATE_HANDLER, SkkStartStateHandlerClass))

typedef struct _SkkStartStateHandler SkkStartStateHandler;
typedef struct _SkkStartStateHandlerClass SkkStartStateHandlerClass;

#define SKK_TYPE_KUTEN_STATE_HANDLER (skk_kuten_state_handler_get_type ())
#define SKK_KUTEN_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandler))
#define SKK_KUTEN_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandlerClass))
#define SKK_IS_KUTEN_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KUTEN_STATE_HANDLER))
#define SKK_IS_KUTEN_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KUTEN_STATE_HANDLER))
#define SKK_KUTEN_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandlerClass))

typedef struct _SkkKutenStateHandler SkkKutenStateHandler;
typedef struct _SkkKutenStateHandlerClass SkkKutenStateHandlerClass;
typedef struct _SkkKutenStateHandlerPrivate SkkKutenStateHandlerPrivate;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_KUTEN_STATE_HANDLER_0_PROPERTY,
	SKK_KUTEN_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* skk_kuten_state_handler_properties[SKK_KUTEN_STATE_HANDLER_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SkkAbbrevStateHandlerPrivate SkkAbbrevStateHandlerPrivate;
enum  {
	SKK_ABBREV_STATE_HANDLER_0_PROPERTY,
	SKK_ABBREV_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* skk_abbrev_state_handler_properties[SKK_ABBREV_STATE_HANDLER_NUM_PROPERTIES];

#define SKK_TYPE_SELECT_STATE_HANDLER (skk_select_state_handler_get_type ())
#define SKK_SELECT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_SELECT_STATE_HANDLER, SkkSelectStateHandler))
#define SKK_SELECT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_SELECT_STATE_HANDLER, SkkSelectStateHandlerClass))
#define SKK_IS_SELECT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_SELECT_STATE_HANDLER))
#define SKK_IS_SELECT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_SELECT_STATE_HANDLER))
#define SKK_SELECT_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_SELECT_STATE_HANDLER, SkkSelectStateHandlerClass))

typedef struct _SkkSelectStateHandler SkkSelectStateHandler;
typedef struct _SkkSelectStateHandlerClass SkkSelectStateHandlerClass;
typedef struct _SkkStartStateHandlerPrivate SkkStartStateHandlerPrivate;
enum  {
	SKK_START_STATE_HANDLER_0_PROPERTY,
	SKK_START_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* skk_start_state_handler_properties[SKK_START_STATE_HANDLER_NUM_PROPERTIES];
typedef struct _SkkSelectStateHandlerPrivate SkkSelectStateHandlerPrivate;
enum  {
	SKK_SELECT_STATE_HANDLER_0_PROPERTY,
	SKK_SELECT_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* skk_select_state_handler_properties[SKK_SELECT_STATE_HANDLER_NUM_PROPERTIES];

struct _SkkState {
	GObject parent_instance;
	SkkStatePrivate * priv;
	GType handler_type;
	GeeList* dictionaries;
	SkkCandidateList* candidates;
	SkkRomKanaConverter* rom_kana_converter;
	SkkRomKanaConverter* okuri_rom_kana_converter;
	gboolean okuri;
	gchar* yomi;
	GString* selection;
	GString* output;
	GString* abbrev;
	GString* kuten;
	GeeBidirListIterator* completion_iterator;
	GeeSet* completion_set;
	SkkCompletionService* normal_completion_service;
	SkkCompletionService* abbrev_completion_service;
	gchar** auto_start_henkan_keywords;
	gint auto_start_henkan_keywords_length1;
	gint _auto_start_henkan_keywords_size_;
	gchar* auto_start_henkan_keyword;
	gboolean egg_like_newline;
	SkkUnicodeString* surrounding_text;
	guint surrounding_end;
};

struct _SkkStateClass {
	GObjectClass parent_class;
};

struct _SkkStatePrivate {
	SkkInputMode _input_mode;
	GeeArrayList* completion;
	SkkRule* _typing_rule;
	GRegex* numeric_regex;
	GRegex* numeric_ref_regex;
};

struct _SkkMapFile {
	GObject parent_instance;
	SkkMapFilePrivate * priv;
};

struct _SkkMapFileClass {
	GObjectClass parent_class;
};

struct _SkkKeymapMapFile {
	SkkMapFile parent_instance;
	SkkKeymapMapFilePrivate * priv;
	SkkKeymap* keymap;
};

struct _SkkKeymapMapFileClass {
	SkkMapFileClass parent_class;
};

struct _SkkExprNode {
	SkkExprNodeType type;
	GeeLinkedList* nodes;
	gchar* data;
};

struct _SkkStateHandler {
	GObject parent_instance;
	SkkStateHandlerPrivate * priv;
};

struct _SkkStateHandlerClass {
	GObjectClass parent_class;
	gboolean (*process_key_event) (SkkStateHandler* self, SkkState* state, SkkKeyEvent** key);
	gchar* (*get_preedit) (SkkStateHandler* self, SkkState* state, guint* underline_offset, guint* underline_nchars);
	gchar* (*get_output) (SkkStateHandler* self, SkkState* state);
};

struct _SkkInputModeCommandEntry {
	gchar* key;
	SkkInputMode value;
};

struct _SkkNoneStateHandler {
	SkkStateHandler parent_instance;
	SkkNoneStateHandlerPrivate * priv;
};

struct _SkkNoneStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkUnicodeString {
	GObject parent_instance;
	SkkUnicodeStringPrivate * priv;
	gint length;
};

struct _SkkUnicodeStringClass {
	GObjectClass parent_class;
};

struct _SkkKutenStateHandler {
	SkkStateHandler parent_instance;
	SkkKutenStateHandlerPrivate * priv;
};

struct _SkkKutenStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkKutenStateHandlerPrivate {
	SkkEncodingConverter* converter;
};

struct _SkkAbbrevStateHandler {
	SkkStateHandler parent_instance;
	SkkAbbrevStateHandlerPrivate * priv;
};

struct _SkkAbbrevStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkStartStateHandler {
	SkkStateHandler parent_instance;
	SkkStartStateHandlerPrivate * priv;
};

struct _SkkStartStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkSelectStateHandler {
	SkkStateHandler parent_instance;
	SkkSelectStateHandlerPrivate * priv;
};

struct _SkkSelectStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

static gint SkkState_private_offset;
static gpointer skk_state_parent_class = NULL;
static gpointer skk_state_handler_parent_class = NULL;
static gpointer skk_none_state_handler_parent_class = NULL;
static gint SkkKutenStateHandler_private_offset;
static gpointer skk_kuten_state_handler_parent_class = NULL;
static gpointer skk_abbrev_state_handler_parent_class = NULL;
static gpointer skk_start_state_handler_parent_class = NULL;
static gpointer skk_select_state_handler_parent_class = NULL;

VALA_EXTERN GType skk_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_unicode_string_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void skk_state_reset (SkkState* self);
VALA_EXTERN gchar* skk_state_lookup_key (SkkState* self,
                             SkkKeyEvent* key);
VALA_EXTERN GType skk_keymap_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_map_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_keymap_map_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkInputMode skk_state_get_input_mode (SkkState* self);
VALA_EXTERN gchar* skk_keymap_lookup_key (SkkKeymap* self,
                              SkkKeyEvent* key);
VALA_EXTERN SkkKeyEvent* skk_state_where_is (SkkState* self,
                                 const gchar* command);
VALA_EXTERN SkkKeyEvent* skk_keymap_where_is (SkkKeymap* self,
                                  const gchar* command);
VALA_EXTERN gboolean skk_state_isupper (SkkState* self,
                            SkkKeyEvent* key,
                            gunichar* lower_code);
VALA_EXTERN SkkState* skk_state_new (GeeList* dictionaries);
VALA_EXTERN SkkState* skk_state_construct (GType object_type,
                               GeeList* dictionaries);
VALA_EXTERN SkkSimpleCandidateList* skk_simple_candidate_list_new (guint page_start,
                                                       guint page_size);
VALA_EXTERN SkkSimpleCandidateList* skk_simple_candidate_list_construct (GType object_type,
                                                             guint page_start,
                                                             guint page_size);
VALA_EXTERN GType skk_simple_candidate_list_get_type (void) G_GNUC_CONST ;
static void skk_state_candidate_selected (SkkState* self,
                                   SkkCandidate* c);
static void _skk_state_candidate_selected_skk_candidate_list_selected (SkkCandidateList* _sender,
                                                                SkkCandidate* candidate,
                                                                gpointer self);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
VALA_EXTERN void skk_state_output_surrounding_text (SkkState* self);
VALA_EXTERN gchar* skk_unicode_string_substring (SkkUnicodeString* self,
                                     glong offset,
                                     glong len);
VALA_EXTERN GType skk_state_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_none_state_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkKeyEventFilter* skk_rule_get_filter (SkkRule* self);
VALA_EXTERN void skk_candidate_list_clear (SkkCandidateList* self);
VALA_EXTERN void skk_state_cancel_okuri (SkkState* self);
VALA_EXTERN void skk_rom_kana_converter_set_output (SkkRomKanaConverter* self,
                                        const gchar* value);
static gchar* skk_state_extract_numerics (SkkState* self,
                                   const gchar* midasi,
                                   gint** numerics,
                                   gint* numerics_length1);
static void _vala_array_add2 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
static gint* _vala_array_dup4 (gint* self,
                        gssize length);
static gchar* skk_state_expand_expr (SkkState* self,
                              const gchar* text);
VALA_EXTERN GType skk_expr_reader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkExprReader* skk_expr_reader_new (void);
VALA_EXTERN SkkExprReader* skk_expr_reader_construct (GType object_type);
VALA_EXTERN GType skk_expr_node_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_expr_node_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkExprNode* skk_expr_node_dup (const SkkExprNode* self);
VALA_EXTERN void skk_expr_node_free (SkkExprNode* self);
VALA_EXTERN void skk_expr_node_copy (const SkkExprNode* self,
                         SkkExprNode* dest);
VALA_EXTERN void skk_expr_node_destroy (SkkExprNode* self);
VALA_EXTERN SkkExprNode* skk_expr_reader_read_expr (SkkExprReader* self,
                                        const gchar* expr,
                                        gint* index);
VALA_EXTERN GType skk_expr_evaluator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkExprEvaluator* skk_expr_evaluator_new (void);
VALA_EXTERN SkkExprEvaluator* skk_expr_evaluator_construct (GType object_type);
VALA_EXTERN gchar* skk_expr_evaluator_eval (SkkExprEvaluator* self,
                                SkkExprNode* node);
static gchar* skk_state_expand_numeric_references (SkkState* self,
                                            const gchar* text,
                                            gint* numerics,
                                            gint numerics_length1);
VALA_EXTERN GType skk_numeric_conversion_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* skk_util_get_numeric (gint numeric,
                             SkkNumericConversionType type);
VALA_EXTERN void skk_state_lookup (SkkState* self,
                       const gchar* midasi,
                       gboolean okuri);
static void skk_state_lookup_internal (SkkState* self,
                                const gchar* midasi,
                                gint* numerics,
                                gint numerics_length1,
                                gboolean okuri);
VALA_EXTERN void skk_candidate_list_add_candidates_end (SkkCandidateList* self);
VALA_EXTERN void skk_candidate_list_add_candidates (SkkCandidateList* self,
                                        SkkCandidate** array,
                                        gint array_length1);
VALA_EXTERN void skk_state_purge_candidate (SkkState* self,
                                SkkCandidate* candidate);
VALA_EXTERN void skk_state_update_completion_sources (SkkState* self,
                                          const gchar* mode,
                                          SkkCompletionSource** sources,
                                          gint sources_length1);
VALA_EXTERN void skk_state_completion_start (SkkState* self,
                                 const gchar* midasi);
VALA_EXTERN GType skk_abbrev_state_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* skk_state_get_yomi (SkkState* self);
VALA_EXTERN gchar* skk_state_get_midasi (SkkState* self);
VALA_EXTERN gchar* skk_util_get_okurigana_prefix (const gchar* okurigana);
VALA_EXTERN gchar* skk_util_get_hiragana (const gchar* kana);
VALA_EXTERN void skk_state_set_input_mode (SkkState* self,
                               SkkInputMode value);
VALA_EXTERN SkkPeriodStyle skk_state_get_period_style (SkkState* self);
VALA_EXTERN void skk_state_set_period_style (SkkState* self,
                                 SkkPeriodStyle value);
VALA_EXTERN SkkRule* skk_state_get_typing_rule (SkkState* self);
VALA_EXTERN void skk_state_set_typing_rule (SkkState* self,
                                SkkRule* value);
VALA_EXTERN GType skk_rom_kana_map_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void skk_rom_kana_converter_set_rule (SkkRomKanaConverter* self,
                                      SkkRomKanaMapFile* value);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void skk_state_finalize (GObject * obj);
static GType skk_state_get_type_once (void);
static void _vala_skk_state_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_skk_state_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
VALA_EXTERN gboolean skk_state_handler_process_key_event (SkkStateHandler* self,
                                              SkkState* state,
                                              SkkKeyEvent** key);
VALA_EXTERN gchar* skk_state_handler_get_preedit (SkkStateHandler* self,
                                      SkkState* state,
                                      guint* underline_offset,
                                      guint* underline_nchars);
VALA_EXTERN gchar* skk_state_handler_get_output (SkkStateHandler* self,
                                     SkkState* state);
static gboolean skk_state_handler_real_process_key_event (SkkStateHandler* self,
                                                   SkkState* state,
                                                   SkkKeyEvent** key);
static gchar* skk_state_handler_real_get_preedit (SkkStateHandler* self,
                                           SkkState* state,
                                           guint* underline_offset,
                                           guint* underline_nchars);
static gchar* skk_state_handler_real_get_output (SkkStateHandler* self,
                                          SkkState* state);
VALA_EXTERN SkkStateHandler* skk_state_handler_construct (GType object_type);
static GType skk_state_handler_get_type_once (void);
VALA_EXTERN GType skk_input_mode_command_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkInputModeCommandEntry* skk_input_mode_command_entry_dup (const SkkInputModeCommandEntry* self);
VALA_EXTERN void skk_input_mode_command_entry_free (SkkInputModeCommandEntry* self);
VALA_EXTERN void skk_input_mode_command_entry_copy (const SkkInputModeCommandEntry* self,
                                        SkkInputModeCommandEntry* dest);
VALA_EXTERN void skk_input_mode_command_entry_destroy (SkkInputModeCommandEntry* self);
static gboolean skk_none_state_handler_real_process_key_event (SkkStateHandler* base,
                                                        SkkState* state,
                                                        SkkKeyEvent** key);
VALA_EXTERN SkkUnicodeString* skk_unicode_string_new (const gchar* str);
VALA_EXTERN SkkUnicodeString* skk_unicode_string_construct (GType object_type,
                                                const gchar* str);
VALA_EXTERN GType skk_start_state_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_kuten_state_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* skk_util_convert_by_input_mode (const gchar* str,
                                       SkkInputMode input_mode);
VALA_EXTERN gunichar skk_util_get_wide_latin_char (gchar c);
static gchar* skk_none_state_handler_real_get_preedit (SkkStateHandler* base,
                                                SkkState* state,
                                                guint* underline_offset,
                                                guint* underline_nchars);
VALA_EXTERN SkkNoneStateHandler* skk_none_state_handler_new (void);
VALA_EXTERN SkkNoneStateHandler* skk_none_state_handler_construct (GType object_type);
static GType skk_none_state_handler_get_type_once (void);
VALA_EXTERN GType skk_encoding_converter_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkKutenStateHandler* skk_kuten_state_handler_new (void);
VALA_EXTERN SkkKutenStateHandler* skk_kuten_state_handler_construct (GType object_type);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
static gint skk_kuten_state_handler_hex_char_to_int (SkkKutenStateHandler* self,
                                              gchar hex);
static gchar* skk_kuten_state_handler_parse_hex (SkkKutenStateHandler* self,
                                          const gchar* hex);
static gboolean skk_kuten_state_handler_real_process_key_event (SkkStateHandler* base,
                                                         SkkState* state,
                                                         SkkKeyEvent** key);
VALA_EXTERN gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
static gchar* skk_kuten_state_handler_real_get_preedit (SkkStateHandler* base,
                                                 SkkState* state,
                                                 guint* underline_offset,
                                                 guint* underline_nchars);
static void skk_kuten_state_handler_finalize (GObject * obj);
static GType skk_kuten_state_handler_get_type_once (void);
static gboolean skk_abbrev_state_handler_real_process_key_event (SkkStateHandler* base,
                                                          SkkState* state,
                                                          SkkKeyEvent** key);
VALA_EXTERN GType skk_select_state_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* skk_util_get_wide_latin (const gchar* latin);
static gchar* skk_abbrev_state_handler_real_get_preedit (SkkStateHandler* base,
                                                  SkkState* state,
                                                  guint* underline_offset,
                                                  guint* underline_nchars);
VALA_EXTERN SkkAbbrevStateHandler* skk_abbrev_state_handler_new (void);
VALA_EXTERN SkkAbbrevStateHandler* skk_abbrev_state_handler_construct (GType object_type);
static GType skk_abbrev_state_handler_get_type_once (void);
static gboolean skk_start_state_handler_real_process_key_event (SkkStateHandler* base,
                                                         SkkState* state,
                                                         SkkKeyEvent** key);
static gboolean skk_start_state_handler_check_auto_conversion (SkkStartStateHandler* self,
                                                        SkkState* state,
                                                        SkkKeyEvent* key);
static gchar* skk_start_state_handler_real_get_preedit (SkkStateHandler* base,
                                                 SkkState* state,
                                                 guint* underline_offset,
                                                 guint* underline_nchars);
VALA_EXTERN SkkStartStateHandler* skk_start_state_handler_new (void);
VALA_EXTERN SkkStartStateHandler* skk_start_state_handler_construct (GType object_type);
static GType skk_start_state_handler_get_type_once (void);
static gboolean skk_select_state_handler_real_process_key_event (SkkStateHandler* base,
                                                          SkkState* state,
                                                          SkkKeyEvent** key);
static gchar* skk_select_state_handler_real_get_preedit (SkkStateHandler* base,
                                                  SkkState* state,
                                                  guint* underline_offset,
                                                  guint* underline_nchars);
VALA_EXTERN SkkSelectStateHandler* skk_select_state_handler_new (void);
VALA_EXTERN SkkSelectStateHandler* skk_select_state_handler_construct (GType object_type);
static GType skk_select_state_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* SKK_AUTO_START_HENKAN_KEYWORDS[33] = {"を", "ヲ", "、", "。", "．", "，", "？", "」", "ｦ", "､", "｡", "｣", "！", "；", "：", ")", ";", ":", "）", "”", "】", "』", "》", "〉", "｝", "］", "〕", "}", "]", "?", ".", ",", "!"};
static const SkkInputModeCommandEntry SKK_NONE_STATE_HANDLER_input_mode_commands[5] = {{"set-input-mode-hiragana", SKK_INPUT_MODE_HIRAGANA}, {"set-input-mode-katakana", SKK_INPUT_MODE_KATAKANA}, {"set-input-mode-hankaku-katakana", SKK_INPUT_MODE_HANKAKU_KATAKANA}, {"set-input-mode-latin", SKK_INPUT_MODE_LATIN}, {"set-input-mode-wide-latin", SKK_INPUT_MODE_WIDE_LATIN}};
static const SkkInputModeCommandEntry SKK_START_STATE_HANDLER_end_preedit_commands[3] = {{"set-input-mode-hiragana", SKK_INPUT_MODE_HIRAGANA}, {"set-input-mode-katakana", SKK_INPUT_MODE_KATAKANA}, {"set-input-mode-hankaku-katakana", SKK_INPUT_MODE_HANKAKU_KATAKANA}};

static inline gpointer
skk_state_get_instance_private (SkkState* self)
{
	return G_STRUCT_MEMBER_P (self, SkkState_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
skk_state_lookup_key (SkkState* self,
                      SkkKeyEvent* key)
{
	SkkKeymap* keymap = NULL;
	SkkRule* _tmp0_;
	SkkKeymapMapFile** _tmp1_;
	gint _tmp1__length1;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	SkkKeymapMapFile* _tmp4_;
	SkkKeymap* _tmp5_;
	SkkKeymap* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	_tmp1_ = _tmp0_->keymaps;
	_tmp1__length1 = _tmp0_->keymaps_length1;
	_tmp2_ = skk_state_get_input_mode (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_[_tmp3_];
	_tmp5_ = _tmp4_->keymap;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	keymap = _tmp6_;
	g_return_val_if_fail (keymap != NULL, NULL);
	_tmp7_ = skk_keymap_lookup_key (keymap, key);
	result = _tmp7_;
	_g_object_unref0 (keymap);
	return result;
}

SkkKeyEvent*
skk_state_where_is (SkkState* self,
                    const gchar* command)
{
	SkkKeymap* keymap = NULL;
	SkkRule* _tmp0_;
	SkkKeymapMapFile** _tmp1_;
	gint _tmp1__length1;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	SkkKeymapMapFile* _tmp4_;
	SkkKeymap* _tmp5_;
	SkkKeymap* _tmp6_;
	SkkKeyEvent* _tmp7_;
	SkkKeyEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	_tmp1_ = _tmp0_->keymaps;
	_tmp1__length1 = _tmp0_->keymaps_length1;
	_tmp2_ = skk_state_get_input_mode (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_[_tmp3_];
	_tmp5_ = _tmp4_->keymap;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	keymap = _tmp6_;
	g_return_val_if_fail (keymap != NULL, NULL);
	_tmp7_ = skk_keymap_where_is (keymap, command);
	result = _tmp7_;
	_g_object_unref0 (keymap);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
skk_state_isupper (SkkState* self,
                   SkkKeyEvent* key,
                   gunichar* lower_code)
{
	gunichar _vala_lower_code = 0U;
	gchar* command = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gunichar _tmp9_;
	gunichar _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = skk_state_lookup_key (self, key);
	command = _tmp0_;
	_tmp2_ = command;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = command;
		_tmp1_ = g_str_has_prefix (_tmp3_, "upper-");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		_tmp4_ = command;
		_vala_lower_code = (gunichar) string_get (_tmp4_, (glong) 6);
		result = TRUE;
		_g_free0 (command);
		if (lower_code) {
			*lower_code = _vala_lower_code;
		}
		return result;
	} else {
		gunichar _tmp5_;
		gunichar _tmp6_;
		_tmp5_ = skk_key_event_get_code (key);
		_tmp6_ = _tmp5_;
		if (g_unichar_isupper (_tmp6_)) {
			gunichar _tmp7_;
			gunichar _tmp8_;
			_tmp7_ = skk_key_event_get_code (key);
			_tmp8_ = _tmp7_;
			_vala_lower_code = g_unichar_tolower (_tmp8_);
			result = TRUE;
			_g_free0 (command);
			if (lower_code) {
				*lower_code = _vala_lower_code;
			}
			return result;
		}
	}
	_tmp9_ = skk_key_event_get_code (key);
	_tmp10_ = _tmp9_;
	_vala_lower_code = _tmp10_;
	result = FALSE;
	_g_free0 (command);
	if (lower_code) {
		*lower_code = _vala_lower_code;
	}
	return result;
}

static void
_skk_state_candidate_selected_skk_candidate_list_selected (SkkCandidateList* _sender,
                                                           SkkCandidate* candidate,
                                                           gpointer self)
{
	skk_state_candidate_selected ((SkkState*) self, candidate);
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

SkkState*
skk_state_construct (GType object_type,
                     GeeList* dictionaries)
{
	SkkState * self = NULL;
	GeeList* _tmp0_;
	SkkSimpleCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	SkkRomKanaConverter* _tmp3_;
	SkkRomKanaConverter* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dictionaries != NULL, NULL);
	self = (SkkState*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (dictionaries);
	_g_object_unref0 (self->dictionaries);
	self->dictionaries = _tmp0_;
	_tmp1_ = skk_simple_candidate_list_new ((guint) 4, (guint) 7);
	_g_object_unref0 (self->candidates);
	self->candidates = (SkkCandidateList*) _tmp1_;
	_tmp2_ = self->candidates;
	g_signal_connect_object (_tmp2_, "selected", (GCallback) _skk_state_candidate_selected_skk_candidate_list_selected, self, 0);
	_tmp3_ = skk_rom_kana_converter_new ();
	_g_object_unref0 (self->rom_kana_converter);
	self->rom_kana_converter = _tmp3_;
	_tmp4_ = skk_rom_kana_converter_new ();
	_g_object_unref0 (self->okuri_rom_kana_converter);
	self->okuri_rom_kana_converter = _tmp4_;
	_tmp5_ = _vala_array_dup3 (SKK_AUTO_START_HENKAN_KEYWORDS, G_N_ELEMENTS (SKK_AUTO_START_HENKAN_KEYWORDS));
	_tmp5__length1 = G_N_ELEMENTS (SKK_AUTO_START_HENKAN_KEYWORDS);
	self->auto_start_henkan_keywords = (_vala_array_free (self->auto_start_henkan_keywords, self->auto_start_henkan_keywords_length1, (GDestroyNotify) g_free), NULL);
	self->auto_start_henkan_keywords = _tmp5_;
	self->auto_start_henkan_keywords_length1 = _tmp5__length1;
	self->_auto_start_henkan_keywords_size_ = self->auto_start_henkan_keywords_length1;
	{
		SkkRule* _tmp6_ = NULL;
		SkkRule* _tmp7_;
		SkkRule* _tmp8_;
		_tmp7_ = skk_rule_new ("default", &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
				goto __catch0_skk_rule_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (self->priv->_typing_rule);
		self->priv->_typing_rule = _tmp8_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_skk_rule_parse_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
		_tmp10_ = g_regex_new ("[0-9]+", 0, 0, &_inner_error0_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_g_regex_unref0 (self->priv->numeric_regex);
		self->priv->numeric_regex = _tmp11_;
		_g_regex_unref0 (_tmp9_);
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GRegex* _tmp12_ = NULL;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		_tmp13_ = g_regex_new ("#([0-9])", 0, 0, &_inner_error0_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_regex_unref0 (self->priv->numeric_ref_regex);
		self->priv->numeric_ref_regex = _tmp14_;
		_g_regex_unref0 (_tmp12_);
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	skk_state_reset (self);
	return self;
}

SkkState*
skk_state_new (GeeList* dictionaries)
{
	return skk_state_construct (SKK_TYPE_STATE, dictionaries);
}

static void
skk_state_candidate_selected (SkkState* self,
                              SkkCandidate* c)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SkkInputMode _mode = 0;
	SkkInputMode _tmp10_;
	SkkInputMode _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->output;
	_tmp1_ = skk_candidate_get_output (c);
	_tmp2_ = _tmp1_;
	g_string_append (_tmp0_, _tmp2_);
	_tmp3_ = self->auto_start_henkan_keyword;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->output;
		_tmp5_ = self->auto_start_henkan_keyword;
		g_string_append (_tmp4_, _tmp5_);
	} else {
		if (self->okuri) {
			GString* _tmp6_;
			SkkRomKanaConverter* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp6_ = self->output;
			_tmp7_ = self->okuri_rom_kana_converter;
			_tmp8_ = skk_rom_kana_converter_get_output (_tmp7_);
			_tmp9_ = _tmp8_;
			g_string_append (_tmp6_, _tmp9_);
		}
	}
	_tmp10_ = skk_state_get_input_mode (self);
	_tmp11_ = _tmp10_;
	_mode = _tmp11_;
	skk_state_reset (self);
	self->priv->_input_mode = _mode;
}

void
skk_state_output_surrounding_text (SkkState* self)
{
	SkkUnicodeString* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->surrounding_text;
	if (_tmp0_ != NULL) {
		GString* _tmp1_;
		SkkUnicodeString* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->output;
		_tmp2_ = self->surrounding_text;
		_tmp3_ = skk_unicode_string_substring (_tmp2_, (glong) 0, (glong) -1);
		_tmp4_ = _tmp3_;
		g_string_append (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
	}
}

void
skk_state_reset (SkkState* self)
{
	SkkRomKanaConverter* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	SkkRule* _tmp2_;
	SkkKeyEventFilter* _tmp3_;
	SkkKeyEventFilter* _tmp4_;
	GeeSet* _tmp5_;
	GeeArrayList* _tmp6_;
	SkkCandidateList* _tmp7_;
	GString* _tmp8_;
	GString* _tmp9_;
	GString* _tmp10_;
	g_return_if_fail (self != NULL);
	self->handler_type = SKK_TYPE_NONE_STATE_HANDLER;
	_tmp0_ = self->rom_kana_converter;
	skk_rom_kana_converter_reset (_tmp0_);
	_tmp1_ = self->okuri_rom_kana_converter;
	skk_rom_kana_converter_reset (_tmp1_);
	self->okuri = FALSE;
	_tmp2_ = self->priv->_typing_rule;
	_tmp3_ = skk_rule_get_filter (_tmp2_);
	_tmp4_ = _tmp3_;
	skk_key_event_filter_reset (_tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (self->completion_iterator);
	self->completion_iterator = NULL;
	_tmp5_ = self->completion_set;
	gee_collection_clear ((GeeCollection*) _tmp5_);
	_tmp6_ = self->priv->completion;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
	_tmp7_ = self->candidates;
	skk_candidate_list_clear (_tmp7_);
	_tmp8_ = self->abbrev;
	g_string_erase (_tmp8_, (gssize) 0, (gssize) -1);
	_tmp9_ = self->kuten;
	g_string_erase (_tmp9_, (gssize) 0, (gssize) -1);
	_tmp10_ = self->selection;
	g_string_erase (_tmp10_, (gssize) 0, (gssize) -1);
	_g_free0 (self->auto_start_henkan_keyword);
	self->auto_start_henkan_keyword = NULL;
	_g_object_unref0 (self->surrounding_text);
	self->surrounding_text = NULL;
	self->surrounding_end = (guint) 0;
}

void
skk_state_cancel_okuri (SkkState* self)
{
	SkkRomKanaConverter* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SkkRomKanaConverter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	SkkRomKanaConverter* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = self->rom_kana_converter;
	_tmp2_ = skk_rom_kana_converter_get_output (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->okuri_rom_kana_converter;
	_tmp5_ = skk_rom_kana_converter_get_output (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	skk_rom_kana_converter_set_output (_tmp1_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->okuri_rom_kana_converter;
	skk_rom_kana_converter_reset (_tmp9_);
	self->okuri = FALSE;
}

static void
_vala_array_add2 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint*
_vala_array_dup4 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gchar*
skk_state_extract_numerics (SkkState* self,
                            const gchar* midasi,
                            gint** numerics,
                            gint* numerics_length1)
{
	gint* _vala_numerics = NULL;
	gint _vala_numerics_length1 = 0;
	GMatchInfo* info = NULL;
	gint start_pos = 0;
	gint* _numerics = NULL;
	gint* _tmp0_;
	gint _numerics_length1;
	gint __numerics_size_;
	GString* builder = NULL;
	GString* _tmp1_;
	gint* _tmp16_;
	gint _tmp16__length1;
	gint* _tmp17_;
	gint _tmp17__length1;
	GString* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (midasi != NULL, NULL);
	info = NULL;
	start_pos = 0;
	_tmp0_ = g_new0 (gint, 0);
	_numerics = _tmp0_;
	_numerics_length1 = 0;
	__numerics_size_ = _numerics_length1;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	while (TRUE) {
		gchar* numeric = NULL;
		GMatchInfo* _tmp6_;
		gchar* _tmp7_;
		gint match_start_pos = 0;
		gint match_end_pos = 0;
		GMatchInfo* _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp11_;
		GString* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GString* _tmp15_;
		{
			gboolean _tmp2_ = FALSE;
			GRegex* _tmp3_;
			GMatchInfo* _tmp4_ = NULL;
			gboolean _tmp5_;
			_tmp3_ = self->priv->numeric_regex;
			_tmp5_ = g_regex_match_full (_tmp3_, midasi, (gssize) -1, start_pos, 0, &_tmp4_, &_inner_error0_);
			_g_match_info_unref0 (info);
			info = _tmp4_;
			_tmp2_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_string_free0 (builder);
				_numerics = (g_free (_numerics), NULL);
				_g_match_info_unref0 (info);
				_vala_numerics = (g_free (_vala_numerics), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			if (!_tmp2_) {
				break;
			}
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
			g_return_val_if_reached (midasi);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (builder);
			_numerics = (g_free (_numerics), NULL);
			_g_match_info_unref0 (info);
			_vala_numerics = (g_free (_vala_numerics), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = info;
		_tmp7_ = g_match_info_fetch (_tmp6_, 0);
		numeric = _tmp7_;
		_tmp8_ = info;
		g_match_info_fetch_pos (_tmp8_, 0, &_tmp9_, &_tmp10_);
		match_start_pos = _tmp9_;
		match_end_pos = _tmp10_;
		_tmp11_ = numeric;
		_vala_array_add2 (&_numerics, &_numerics_length1, &__numerics_size_, atoi (_tmp11_));
		_tmp12_ = builder;
		_tmp13_ = string_slice (midasi, (glong) start_pos, (glong) match_start_pos);
		_tmp14_ = _tmp13_;
		g_string_append (_tmp12_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = builder;
		g_string_append (_tmp15_, "#");
		start_pos = match_end_pos;
		_g_free0 (numeric);
	}
	_tmp16_ = _numerics;
	_tmp16__length1 = _numerics_length1;
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup4 (_tmp16_, _tmp16__length1) : _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	_vala_numerics = (g_free (_vala_numerics), NULL);
	_vala_numerics = _tmp17_;
	_vala_numerics_length1 = _tmp17__length1;
	_tmp18_ = builder;
	_tmp19_ = strlen (midasi);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_slice (midasi, (glong) start_pos, (glong) _tmp20_);
	_tmp22_ = _tmp21_;
	g_string_append (_tmp18_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = builder;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (builder);
	_numerics = (g_free (_numerics), NULL);
	_g_match_info_unref0 (info);
	if (numerics) {
		*numerics = _vala_numerics;
	} else {
		_vala_numerics = (g_free (_vala_numerics), NULL);
	}
	if (numerics_length1) {
		*numerics_length1 = _vala_numerics_length1;
	}
	return result;
}

static gchar*
skk_state_expand_expr (SkkState* self,
                       const gchar* text)
{
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	if (g_str_has_prefix (text, "(")) {
		SkkExprReader* reader = NULL;
		SkkExprReader* _tmp0_;
		gint index = 0;
		SkkExprNode* node = NULL;
		SkkExprReader* _tmp1_;
		SkkExprNode* _tmp2_;
		SkkExprEvaluator* evaluator = NULL;
		SkkExprEvaluator* _tmp3_;
		gchar* _text = NULL;
		SkkExprEvaluator* _tmp4_;
		SkkExprNode* _tmp5_;
		SkkExprNode _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp0_ = skk_expr_reader_new ();
		reader = _tmp0_;
		index = 0;
		_tmp1_ = reader;
		_tmp2_ = skk_expr_reader_read_expr (_tmp1_, text, &index);
		node = _tmp2_;
		_tmp3_ = skk_expr_evaluator_new ();
		evaluator = _tmp3_;
		_tmp4_ = evaluator;
		_tmp5_ = node;
		_tmp6_ = *_tmp5_;
		_tmp7_ = skk_expr_evaluator_eval (_tmp4_, &_tmp6_);
		_text = _tmp7_;
		_tmp8_ = _text;
		if (_tmp8_ != NULL) {
			result = _text;
			_g_object_unref0 (evaluator);
			_skk_expr_node_free0 (node);
			_g_object_unref0 (reader);
			return result;
		}
		_g_free0 (_text);
		_g_object_unref0 (evaluator);
		_skk_expr_node_free0 (node);
		_g_object_unref0 (reader);
	}
	_tmp9_ = g_strdup (text);
	result = _tmp9_;
	return result;
}

static gchar*
skk_state_expand_numeric_references (SkkState* self,
                                     const gchar* text,
                                     gint* numerics,
                                     gint numerics_length1)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GMatchInfo* info = NULL;
	gint start_pos = 0;
	GString* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	info = NULL;
	start_pos = 0;
	{
		gint numeric_index = 0;
		numeric_index = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint match_start_pos = 0;
				gint match_end_pos = 0;
				GMatchInfo* _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				GString* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* type = NULL;
				GMatchInfo* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = numeric_index;
					numeric_index = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(numeric_index < numerics_length1)) {
					break;
				}
				{
					gboolean _tmp3_ = FALSE;
					GRegex* _tmp4_;
					GMatchInfo* _tmp5_ = NULL;
					gboolean _tmp6_;
					_tmp4_ = self->priv->numeric_ref_regex;
					_tmp6_ = g_regex_match_full (_tmp4_, text, (gssize) -1, start_pos, 0, &_tmp5_, &_inner_error0_);
					_g_match_info_unref0 (info);
					info = _tmp5_;
					_tmp3_ = _tmp6_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch0_g_regex_error;
						}
						_g_match_info_unref0 (info);
						_g_string_free0 (builder);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					if (!_tmp3_) {
						break;
					}
				}
				goto __finally0;
				__catch0_g_regex_error:
				{
					g_clear_error (&_inner_error0_);
					g_return_val_if_reached (text);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_match_info_unref0 (info);
					_g_string_free0 (builder);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp7_ = info;
				g_match_info_fetch_pos (_tmp7_, 0, &_tmp8_, &_tmp9_);
				match_start_pos = _tmp8_;
				match_end_pos = _tmp9_;
				_tmp10_ = builder;
				_tmp11_ = string_slice (text, (glong) start_pos, (glong) match_start_pos);
				_tmp12_ = _tmp11_;
				g_string_append (_tmp10_, _tmp12_);
				_g_free0 (_tmp12_);
				_tmp13_ = info;
				_tmp14_ = g_match_info_fetch (_tmp13_, 1);
				type = _tmp14_;
				_tmp15_ = type;
				switch (string_get (_tmp15_, (glong) 0)) {
					case '0':
					case '1':
					case '2':
					case '3':
					case '5':
					{
						GString* _tmp16_;
						gint _tmp17_;
						const gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						_tmp16_ = builder;
						_tmp17_ = numerics[numeric_index];
						_tmp18_ = type;
						_tmp19_ = skk_util_get_numeric (_tmp17_, (SkkNumericConversionType) (string_get (_tmp18_, (glong) 0) - '0'));
						_tmp20_ = _tmp19_;
						g_string_append (_tmp16_, _tmp20_);
						_g_free0 (_tmp20_);
						break;
					}
					case '4':
					case '9':
					{
						break;
					}
					default:
					{
						const gchar* _tmp21_;
						_tmp21_ = type;
						g_warning ("state.vala:306: unknown numeric conversion type: %s", _tmp21_);
						break;
					}
				}
				start_pos = match_end_pos;
				_g_free0 (type);
			}
		}
	}
	_tmp22_ = builder;
	_tmp23_ = strlen (text);
	_tmp24_ = _tmp23_;
	_tmp25_ = string_slice (text, (glong) start_pos, (glong) _tmp24_);
	_tmp26_ = _tmp25_;
	g_string_append (_tmp22_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = builder;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = g_strdup (_tmp28_);
	result = _tmp29_;
	_g_match_info_unref0 (info);
	_g_string_free0 (builder);
	return result;
}

void
skk_state_lookup (SkkState* self,
                  const gchar* midasi,
                  gboolean okuri)
{
	SkkCandidateList* _tmp0_;
	gint* numerics = NULL;
	gint* _tmp1_;
	gint numerics_length1;
	gint _numerics_size_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gchar* numeric_midasi = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	SkkCandidateList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (midasi != NULL);
	_tmp0_ = self->candidates;
	skk_candidate_list_clear (_tmp0_);
	_tmp1_ = g_new0 (gint, 0);
	numerics = _tmp1_;
	numerics_length1 = 0;
	_numerics_size_ = numerics_length1;
	_tmp2_ = numerics;
	_tmp2__length1 = numerics_length1;
	skk_state_lookup_internal (self, midasi, _tmp2_, (gint) _tmp2__length1, okuri);
	_tmp5_ = skk_state_extract_numerics (self, midasi, &_tmp3_, &_tmp4_);
	numerics = (g_free (numerics), NULL);
	numerics = _tmp3_;
	numerics_length1 = _tmp4_;
	_numerics_size_ = numerics_length1;
	numeric_midasi = _tmp5_;
	_tmp6_ = numeric_midasi;
	if (g_strcmp0 (_tmp6_, midasi) != 0) {
		const gchar* _tmp7_;
		gint* _tmp8_;
		gint _tmp8__length1;
		_tmp7_ = numeric_midasi;
		_tmp8_ = numerics;
		_tmp8__length1 = numerics_length1;
		skk_state_lookup_internal (self, _tmp7_, _tmp8_, (gint) _tmp8__length1, okuri);
	}
	_tmp9_ = self->candidates;
	skk_candidate_list_add_candidates_end (_tmp9_);
	_g_free0 (numeric_midasi);
	numerics = (g_free (numerics), NULL);
}

static void
skk_state_lookup_internal (SkkState* self,
                           const gchar* midasi,
                           gint* numerics,
                           gint numerics_length1,
                           gboolean okuri)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (midasi != NULL);
	{
		GeeList* _dict_list = NULL;
		GeeList* _tmp0_;
		gint _dict_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _dict_index = 0;
		_tmp0_ = self->dictionaries;
		_dict_list = _tmp0_;
		_tmp1_ = _dict_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_dict_size = _tmp3_;
		_dict_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			SkkDict* dict = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			SkkCandidate** _candidates = NULL;
			SkkDict* _tmp8_;
			gint _tmp9_ = 0;
			SkkCandidate** _tmp10_;
			gint _candidates_length1;
			gint __candidates_size_;
			SkkCandidate** _tmp11_;
			gint _tmp11__length1;
			SkkCandidateList* _tmp32_;
			SkkCandidate** _tmp33_;
			gint _tmp33__length1;
			_dict_index = _dict_index + 1;
			_tmp4_ = _dict_index;
			_tmp5_ = _dict_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _dict_list;
			_tmp7_ = gee_list_get (_tmp6_, _dict_index);
			dict = (SkkDict*) _tmp7_;
			_tmp8_ = dict;
			_tmp10_ = skk_dict_lookup (_tmp8_, midasi, okuri, &_tmp9_);
			_candidates = _tmp10_;
			_candidates_length1 = _tmp9_;
			__candidates_size_ = _candidates_length1;
			_tmp11_ = _candidates;
			_tmp11__length1 = _candidates_length1;
			{
				SkkCandidate** candidate_collection = NULL;
				gint candidate_collection_length1 = 0;
				gint _candidate_collection_size_ = 0;
				gint candidate_it = 0;
				candidate_collection = _tmp11_;
				candidate_collection_length1 = _tmp11__length1;
				for (candidate_it = 0; candidate_it < candidate_collection_length1; candidate_it = candidate_it + 1) {
					SkkCandidate* _tmp12_;
					SkkCandidate* candidate = NULL;
					_tmp12_ = _g_object_ref0 (candidate_collection[candidate_it]);
					candidate = _tmp12_;
					{
						gchar* text = NULL;
						SkkCandidate* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						SkkCandidate* _tmp21_;
						const gchar* _tmp22_;
						SkkCandidate* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp13_ = candidate;
						_tmp14_ = skk_candidate_get_text (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = g_strdup (_tmp15_);
						text = _tmp16_;
						_tmp17_ = text;
						_tmp18_ = skk_state_expand_expr (self, _tmp17_);
						_g_free0 (text);
						text = _tmp18_;
						_tmp19_ = text;
						_tmp20_ = skk_state_expand_numeric_references (self, _tmp19_, numerics, (gint) numerics_length1);
						_g_free0 (text);
						text = _tmp20_;
						_tmp21_ = candidate;
						_tmp22_ = text;
						skk_candidate_set_output (_tmp21_, _tmp22_);
						_tmp23_ = candidate;
						_tmp24_ = skk_candidate_get_annotation (_tmp23_);
						_tmp25_ = _tmp24_;
						if (_tmp25_ != NULL) {
							SkkCandidate* _tmp26_;
							SkkCandidate* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							_tmp26_ = candidate;
							_tmp27_ = candidate;
							_tmp28_ = skk_candidate_get_annotation (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = skk_state_expand_expr (self, _tmp29_);
							_tmp31_ = _tmp30_;
							skk_candidate_set_annotation (_tmp26_, _tmp31_);
							_g_free0 (_tmp31_);
						}
						_g_free0 (text);
						_g_object_unref0 (candidate);
					}
				}
			}
			_tmp32_ = self->candidates;
			_tmp33_ = _candidates;
			_tmp33__length1 = _candidates_length1;
			skk_candidate_list_add_candidates (_tmp32_, _tmp33_, (gint) _tmp33__length1);
			_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (dict);
		}
	}
}

void
skk_state_purge_candidate (SkkState* self,
                           SkkCandidate* candidate)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidate != NULL);
	{
		GeeList* _dict_list = NULL;
		GeeList* _tmp0_;
		gint _dict_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _dict_index = 0;
		_tmp0_ = self->dictionaries;
		_dict_list = _tmp0_;
		_tmp1_ = _dict_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_dict_size = _tmp3_;
		_dict_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			SkkDict* dict = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			SkkDict* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_dict_index = _dict_index + 1;
			_tmp4_ = _dict_index;
			_tmp5_ = _dict_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _dict_list;
			_tmp7_ = gee_list_get (_tmp6_, _dict_index);
			dict = (SkkDict*) _tmp7_;
			_tmp8_ = dict;
			_tmp9_ = skk_dict_get_read_only (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				SkkDict* _tmp11_;
				_tmp11_ = dict;
				skk_dict_purge_candidate (_tmp11_, candidate);
			}
			_g_object_unref0 (dict);
		}
	}
}

static gpointer
_skk_completion_service_ref0 (gpointer self)
{
	return self ? skk_completion_service_ref (self) : NULL;
}

void
skk_state_update_completion_sources (SkkState* self,
                                     const gchar* mode,
                                     SkkCompletionSource** sources,
                                     gint sources_length1)
{
	SkkCompletionService* service = NULL;
	SkkCompletionService* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mode != NULL);
	_tmp0_ = skk_completion_service_new ();
	service = _tmp0_;
	{
		SkkCompletionSource** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = sources;
		source_collection_length1 = sources_length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			SkkCompletionSource* _tmp1_;
			SkkCompletionSource* source = NULL;
			_tmp1_ = _g_object_ref0 (source_collection[source_it]);
			source = _tmp1_;
			{
				SkkCompletionService* _tmp2_;
				SkkCompletionSource* _tmp3_;
				SkkCompletionSource* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp2_ = service;
				_tmp3_ = source;
				_tmp4_ = source;
				_tmp5_ = skk_completion_source_get_priority (_tmp4_);
				_tmp6_ = _tmp5_;
				skk_completion_service_add_source (_tmp2_, (GObject*) _tmp3_, _tmp6_);
				_g_object_unref0 (source);
			}
		}
	}
	if (g_strcmp0 (mode, "normal") == 0) {
		SkkCompletionService* _tmp7_;
		SkkCompletionService* _tmp8_;
		_tmp7_ = service;
		_tmp8_ = _skk_completion_service_ref0 (_tmp7_);
		_skk_completion_service_unref0 (self->normal_completion_service);
		self->normal_completion_service = _tmp8_;
	} else {
		if (g_strcmp0 (mode, "abbrev") == 0) {
			SkkCompletionService* _tmp9_;
			SkkCompletionService* _tmp10_;
			_tmp9_ = service;
			_tmp10_ = _skk_completion_service_ref0 (_tmp9_);
			_skk_completion_service_unref0 (self->abbrev_completion_service);
			self->abbrev_completion_service = _tmp10_;
		} else {
			g_warning ("state.vala:367: Invalid mode specified: %s", mode);
		}
	}
	_skk_completion_service_unref0 (service);
}

void
skk_state_completion_start (SkkState* self,
                            const gchar* midasi)
{
	SkkCompletionService* _tmp0_;
	SkkCompletionService* _tmp16_;
	GeeArrayList* _tmp32_;
	GeeSet* _tmp33_;
	SkkCompletionService* _tmp34_ = NULL;
	SkkCompletionService* service = NULL;
	SkkCompletionService* _tmp37_;
	GeeArrayList* completions = NULL;
	SkkCompletionService* _tmp38_;
	GeeArrayList* _tmp39_;
	GeeArrayList* _tmp52_;
	GeeBidirListIterator* _tmp53_;
	GeeBidirListIterator* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (midasi != NULL);
	_tmp0_ = self->normal_completion_service;
	if (_tmp0_ == NULL) {
		SkkCompletionService* _tmp1_;
		_tmp1_ = skk_completion_service_new ();
		_skk_completion_service_unref0 (self->normal_completion_service);
		self->normal_completion_service = _tmp1_;
		{
			GeeList* _dict_list = NULL;
			GeeList* _tmp2_;
			gint _dict_size = 0;
			GeeList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _dict_index = 0;
			_tmp2_ = self->dictionaries;
			_dict_list = _tmp2_;
			_tmp3_ = _dict_list;
			_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_dict_size = _tmp5_;
			_dict_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				SkkDict* dict = NULL;
				GeeList* _tmp8_;
				gpointer _tmp9_;
				gint _tmp10_ = 0;
				SkkDict* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				SkkCompletionService* _tmp14_;
				SkkDict* _tmp15_;
				_dict_index = _dict_index + 1;
				_tmp6_ = _dict_index;
				_tmp7_ = _dict_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _dict_list;
				_tmp9_ = gee_list_get (_tmp8_, _dict_index);
				dict = (SkkDict*) _tmp9_;
				_tmp11_ = dict;
				_tmp12_ = skk_dict_get_read_only (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_) {
					_tmp10_ = 10;
				} else {
					_tmp10_ = 20;
				}
				_tmp14_ = self->normal_completion_service;
				_tmp15_ = dict;
				skk_completion_service_add_source (_tmp14_, (GObject*) _tmp15_, _tmp10_);
				_g_object_unref0 (dict);
			}
		}
	}
	_tmp16_ = self->abbrev_completion_service;
	if (_tmp16_ == NULL) {
		SkkCompletionService* _tmp17_;
		_tmp17_ = skk_completion_service_new ();
		_skk_completion_service_unref0 (self->abbrev_completion_service);
		self->abbrev_completion_service = _tmp17_;
		{
			GeeList* _dict_list = NULL;
			GeeList* _tmp18_;
			gint _dict_size = 0;
			GeeList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _dict_index = 0;
			_tmp18_ = self->dictionaries;
			_dict_list = _tmp18_;
			_tmp19_ = _dict_list;
			_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			_dict_size = _tmp21_;
			_dict_index = -1;
			while (TRUE) {
				gint _tmp22_;
				gint _tmp23_;
				SkkDict* dict = NULL;
				GeeList* _tmp24_;
				gpointer _tmp25_;
				gint _tmp26_ = 0;
				SkkDict* _tmp27_;
				gboolean _tmp28_;
				gboolean _tmp29_;
				SkkCompletionService* _tmp30_;
				SkkDict* _tmp31_;
				_dict_index = _dict_index + 1;
				_tmp22_ = _dict_index;
				_tmp23_ = _dict_size;
				if (!(_tmp22_ < _tmp23_)) {
					break;
				}
				_tmp24_ = _dict_list;
				_tmp25_ = gee_list_get (_tmp24_, _dict_index);
				dict = (SkkDict*) _tmp25_;
				_tmp27_ = dict;
				_tmp28_ = skk_dict_get_read_only (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_) {
					_tmp26_ = 10;
				} else {
					_tmp26_ = 20;
				}
				_tmp30_ = self->abbrev_completion_service;
				_tmp31_ = dict;
				skk_completion_service_add_source (_tmp30_, (GObject*) _tmp31_, _tmp26_);
				_g_object_unref0 (dict);
			}
		}
	}
	_tmp32_ = self->priv->completion;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp32_);
	_tmp33_ = self->completion_set;
	gee_collection_clear ((GeeCollection*) _tmp33_);
	if (self->handler_type == SKK_TYPE_ABBREV_STATE_HANDLER) {
		SkkCompletionService* _tmp35_;
		_tmp35_ = self->abbrev_completion_service;
		_tmp34_ = _tmp35_;
	} else {
		SkkCompletionService* _tmp36_;
		_tmp36_ = self->normal_completion_service;
		_tmp34_ = _tmp36_;
	}
	_tmp37_ = _skk_completion_service_ref0 (_tmp34_);
	service = _tmp37_;
	_tmp38_ = service;
	_tmp39_ = skk_completion_service_get_completions (_tmp38_, midasi);
	completions = _tmp39_;
	{
		GeeArrayList* _word_list = NULL;
		GeeArrayList* _tmp40_;
		gint _word_size = 0;
		GeeArrayList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _word_index = 0;
		_tmp40_ = completions;
		_word_list = _tmp40_;
		_tmp41_ = _word_list;
		_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_word_size = _tmp43_;
		_word_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gchar* word = NULL;
			GeeArrayList* _tmp46_;
			gpointer _tmp47_;
			GeeSet* _tmp48_;
			const gchar* _tmp49_;
			_word_index = _word_index + 1;
			_tmp44_ = _word_index;
			_tmp45_ = _word_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _word_list;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _word_index);
			word = (gchar*) _tmp47_;
			_tmp48_ = self->completion_set;
			_tmp49_ = word;
			if (gee_collection_add ((GeeCollection*) _tmp48_, _tmp49_)) {
				GeeArrayList* _tmp50_;
				const gchar* _tmp51_;
				_tmp50_ = self->priv->completion;
				_tmp51_ = word;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
			}
			_g_free0 (word);
		}
	}
	_tmp52_ = self->priv->completion;
	_tmp53_ = gee_abstract_bidir_list_bidir_list_iterator ((GeeAbstractBidirList*) _tmp52_);
	_g_object_unref0 (self->completion_iterator);
	self->completion_iterator = _tmp53_;
	_tmp54_ = self->completion_iterator;
	if (!gee_bidir_iterator_first ((GeeBidirIterator*) _tmp54_)) {
		_g_object_unref0 (self->completion_iterator);
		self->completion_iterator = NULL;
	}
	_g_object_unref0 (completions);
	_skk_completion_service_unref0 (service);
}

gchar*
skk_state_get_yomi (SkkState* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->abbrev;
	if (_tmp1_->len > ((gssize) 0)) {
		GString* _tmp2_;
		GString* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = builder;
		_tmp3_ = self->abbrev;
		_tmp4_ = _tmp3_->str;
		g_string_append (_tmp2_, _tmp4_);
	} else {
		if (self->okuri) {
			GString* _tmp5_;
			SkkRomKanaConverter* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			GString* _tmp9_;
			GString* _tmp10_;
			SkkRomKanaConverter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			GString* _tmp14_;
			SkkRomKanaConverter* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp5_ = builder;
			_tmp6_ = self->rom_kana_converter;
			_tmp7_ = skk_rom_kana_converter_get_output (_tmp6_);
			_tmp8_ = _tmp7_;
			g_string_append (_tmp5_, _tmp8_);
			_tmp9_ = builder;
			g_string_append (_tmp9_, "*");
			_tmp10_ = builder;
			_tmp11_ = self->okuri_rom_kana_converter;
			_tmp12_ = skk_rom_kana_converter_get_output (_tmp11_);
			_tmp13_ = _tmp12_;
			g_string_append (_tmp10_, _tmp13_);
			_tmp14_ = builder;
			_tmp15_ = self->okuri_rom_kana_converter;
			_tmp16_ = skk_rom_kana_converter_get_preedit (_tmp15_);
			_tmp17_ = _tmp16_;
			g_string_append (_tmp14_, _tmp17_);
		} else {
			GString* _tmp18_;
			SkkRomKanaConverter* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			GString* _tmp22_;
			SkkRomKanaConverter* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp18_ = builder;
			_tmp19_ = self->rom_kana_converter;
			_tmp20_ = skk_rom_kana_converter_get_output (_tmp19_);
			_tmp21_ = _tmp20_;
			g_string_append (_tmp18_, _tmp21_);
			_tmp22_ = builder;
			_tmp23_ = self->rom_kana_converter;
			_tmp24_ = skk_rom_kana_converter_get_preedit (_tmp23_);
			_tmp25_ = _tmp24_;
			g_string_append (_tmp22_, _tmp25_);
		}
	}
	_tmp26_ = builder;
	_tmp27_ = _tmp26_->str;
	_tmp28_ = g_strdup (_tmp27_);
	result = _tmp28_;
	_g_string_free0 (builder);
	return result;
}

gchar*
skk_state_get_midasi (SkkState* self)
{
	gchar* midasi = NULL;
	GString* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->abbrev;
	if (_tmp0_->len > ((gssize) 0)) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->abbrev;
		_tmp2_ = _tmp1_->str;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (midasi);
		midasi = _tmp3_;
	} else {
		GString* builder = NULL;
		GString* _tmp4_;
		SkkRomKanaConverter* _tmp5_;
		GString* _tmp6_;
		SkkRomKanaConverter* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GString* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp4_ = g_string_new ("");
		builder = _tmp4_;
		_tmp5_ = self->rom_kana_converter;
		skk_rom_kana_converter_output_nn_if_any (_tmp5_);
		_tmp6_ = builder;
		_tmp7_ = self->rom_kana_converter;
		_tmp8_ = skk_rom_kana_converter_get_output (_tmp7_);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp6_, _tmp9_);
		if (self->okuri) {
			gchar* prefix = NULL;
			SkkRomKanaConverter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp10_ = self->okuri_rom_kana_converter;
			_tmp11_ = skk_rom_kana_converter_get_output (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = skk_util_get_hiragana (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = skk_util_get_okurigana_prefix (_tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			prefix = _tmp16_;
			_tmp17_ = prefix;
			if (_tmp17_ != NULL) {
				GString* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = builder;
				_tmp19_ = prefix;
				g_string_append (_tmp18_, _tmp19_);
			}
			_g_free0 (prefix);
		}
		_tmp20_ = builder;
		_tmp21_ = _tmp20_->str;
		_tmp22_ = skk_util_get_hiragana (_tmp21_);
		_g_free0 (midasi);
		midasi = _tmp22_;
		_g_string_free0 (builder);
	}
	result = midasi;
	return result;
}

SkkInputMode
skk_state_get_input_mode (SkkState* self)
{
	SkkInputMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_input_mode;
	return result;
}

void
skk_state_set_input_mode (SkkState* self,
                          SkkInputMode value)
{
	GString* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SkkInputMode last_input_mode = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->output;
	_tmp1_ = self->rom_kana_converter;
	_tmp2_ = skk_rom_kana_converter_get_output (_tmp1_);
	_tmp3_ = _tmp2_;
	g_string_append (_tmp0_, _tmp3_);
	last_input_mode = self->priv->_input_mode;
	skk_state_reset (self);
	self->priv->_input_mode = value;
	switch (self->priv->_input_mode) {
		case SKK_INPUT_MODE_HIRAGANA:
		case SKK_INPUT_MODE_KATAKANA:
		case SKK_INPUT_MODE_HANKAKU_KATAKANA:
		{
			SkkRomKanaConverter* _tmp4_;
			SkkRomKanaConverter* _tmp5_;
			_tmp4_ = self->rom_kana_converter;
			skk_rom_kana_converter_set_kana_mode (_tmp4_, (SkkKanaMode) value);
			_tmp5_ = self->okuri_rom_kana_converter;
			skk_rom_kana_converter_set_kana_mode (_tmp5_, (SkkKanaMode) value);
			break;
		}
		default:
		{
			break;
		}
	}
	if (self->priv->_input_mode != last_input_mode) {
		g_object_notify ((GObject*) self, "input-mode");
	}
}

SkkPeriodStyle
skk_state_get_period_style (SkkState* self)
{
	SkkPeriodStyle result;
	SkkRomKanaConverter* _tmp0_;
	SkkPeriodStyle _tmp1_;
	SkkPeriodStyle _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = skk_rom_kana_converter_get_period_style (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
skk_state_set_period_style (SkkState* self,
                            SkkPeriodStyle value)
{
	SkkRomKanaConverter* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	skk_rom_kana_converter_set_period_style (_tmp0_, value);
	_tmp1_ = self->okuri_rom_kana_converter;
	skk_rom_kana_converter_set_period_style (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, skk_state_properties[SKK_STATE_PERIOD_STYLE_PROPERTY]);
}

SkkRule*
skk_state_get_typing_rule (SkkState* self)
{
	SkkRule* result;
	SkkRule* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	result = _tmp0_;
	return result;
}

void
skk_state_set_typing_rule (SkkState* self,
                           SkkRule* value)
{
	SkkRule* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	SkkRule* _tmp2_;
	SkkRomKanaMapFile* _tmp3_;
	SkkRomKanaConverter* _tmp4_;
	SkkRule* _tmp5_;
	SkkRomKanaMapFile* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_typing_rule);
	self->priv->_typing_rule = _tmp0_;
	_tmp1_ = self->rom_kana_converter;
	_tmp2_ = self->priv->_typing_rule;
	_tmp3_ = _tmp2_->rom_kana;
	skk_rom_kana_converter_set_rule (_tmp1_, _tmp3_);
	_tmp4_ = self->okuri_rom_kana_converter;
	_tmp5_ = self->priv->_typing_rule;
	_tmp6_ = _tmp5_->rom_kana;
	skk_rom_kana_converter_set_rule (_tmp4_, _tmp6_);
	g_object_notify_by_pspec ((GObject *) self, skk_state_properties[SKK_STATE_TYPING_RULE_PROPERTY]);
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__INT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_UINT) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_UINT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_uint (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
skk_state_class_init (SkkStateClass * klass,
                      gpointer klass_data)
{
	skk_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkState_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_state_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_state_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_state_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_STATE_INPUT_MODE_PROPERTY, skk_state_properties[SKK_STATE_INPUT_MODE_PROPERTY] = g_param_spec_enum ("input-mode", "input-mode", "input-mode", SKK_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_STATE_PERIOD_STYLE_PROPERTY, skk_state_properties[SKK_STATE_PERIOD_STYLE_PROPERTY] = g_param_spec_enum ("period-style", "period-style", "period-style", SKK_TYPE_PERIOD_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_STATE_TYPING_RULE_PROPERTY, skk_state_properties[SKK_STATE_TYPING_RULE_PROPERTY] = g_param_spec_object ("typing-rule", "typing-rule", "typing-rule", SKK_TYPE_RULE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	skk_state_signals[SKK_STATE_RECURSIVE_EDIT_ABORT_SIGNAL] = g_signal_new ("recursive-edit-abort", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	skk_state_signals[SKK_STATE_RECURSIVE_EDIT_END_SIGNAL] = g_signal_new ("recursive-edit-end", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
	skk_state_signals[SKK_STATE_RECURSIVE_EDIT_START_SIGNAL] = g_signal_new ("recursive-edit-start", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	skk_state_signals[SKK_STATE_RETRIEVE_SURROUNDING_TEXT_SIGNAL] = g_signal_new ("retrieve-surrounding-text", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, G_TYPE_BOOLEAN, 2, G_TYPE_POINTER, G_TYPE_POINTER);
	skk_state_signals[SKK_STATE_DELETE_SURROUNDING_TEXT_SIGNAL] = g_signal_new ("delete-surrounding-text", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_UINT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_UINT);
	skk_state_signals[SKK_STATE_REQUEST_SELECTION_TEXT_SIGNAL] = g_signal_new ("request-selection-text", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
skk_state_instance_init (SkkState * self,
                         gpointer klass)
{
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeHashSet* _tmp5_;
	self->priv = skk_state_get_instance_private (self);
	_tmp0_ = g_string_new ("");
	self->selection = _tmp0_;
	_tmp1_ = g_string_new ("");
	self->output = _tmp1_;
	_tmp2_ = g_string_new ("");
	self->abbrev = _tmp2_;
	_tmp3_ = g_string_new ("");
	self->kuten = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->completion = _tmp4_;
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->completion_set = (GeeSet*) _tmp5_;
	self->normal_completion_service = NULL;
	self->abbrev_completion_service = NULL;
	self->auto_start_henkan_keyword = NULL;
	self->egg_like_newline = FALSE;
}

static void
skk_state_finalize (GObject * obj)
{
	SkkState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_STATE, SkkState);
	skk_state_reset (self);
	_g_object_unref0 (self->dictionaries);
	_g_object_unref0 (self->candidates);
	_g_object_unref0 (self->rom_kana_converter);
	_g_object_unref0 (self->okuri_rom_kana_converter);
	_g_free0 (self->yomi);
	_g_string_free0 (self->selection);
	_g_string_free0 (self->output);
	_g_string_free0 (self->abbrev);
	_g_string_free0 (self->kuten);
	_g_object_unref0 (self->priv->completion);
	_g_object_unref0 (self->completion_iterator);
	_g_object_unref0 (self->completion_set);
	_skk_completion_service_unref0 (self->normal_completion_service);
	_skk_completion_service_unref0 (self->abbrev_completion_service);
	self->auto_start_henkan_keywords = (_vala_array_free (self->auto_start_henkan_keywords, self->auto_start_henkan_keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->auto_start_henkan_keyword);
	_g_object_unref0 (self->priv->_typing_rule);
	_g_regex_unref0 (self->priv->numeric_regex);
	_g_regex_unref0 (self->priv->numeric_ref_regex);
	_g_object_unref0 (self->surrounding_text);
	G_OBJECT_CLASS (skk_state_parent_class)->finalize (obj);
}

static GType
skk_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkState), 0, (GInstanceInitFunc) skk_state_instance_init, NULL };
	GType skk_state_type_id;
	skk_state_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkState", &g_define_type_info, 0);
	SkkState_private_offset = g_type_add_instance_private (skk_state_type_id, sizeof (SkkStatePrivate));
	return skk_state_type_id;
}

GType
skk_state_get_type (void)
{
	static volatile gsize skk_state_type_id__once = 0;
	if (g_once_init_enter (&skk_state_type_id__once)) {
		GType skk_state_type_id;
		skk_state_type_id = skk_state_get_type_once ();
		g_once_init_leave (&skk_state_type_id__once, skk_state_type_id);
	}
	return skk_state_type_id__once;
}

static void
_vala_skk_state_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	SkkState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_STATE, SkkState);
	switch (property_id) {
		case SKK_STATE_INPUT_MODE_PROPERTY:
		g_value_set_enum (value, skk_state_get_input_mode (self));
		break;
		case SKK_STATE_PERIOD_STYLE_PROPERTY:
		g_value_set_enum (value, skk_state_get_period_style (self));
		break;
		case SKK_STATE_TYPING_RULE_PROPERTY:
		g_value_set_object (value, skk_state_get_typing_rule (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_skk_state_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	SkkState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_STATE, SkkState);
	switch (property_id) {
		case SKK_STATE_INPUT_MODE_PROPERTY:
		skk_state_set_input_mode (self, g_value_get_enum (value));
		break;
		case SKK_STATE_PERIOD_STYLE_PROPERTY:
		skk_state_set_period_style (self, g_value_get_enum (value));
		break;
		case SKK_STATE_TYPING_RULE_PROPERTY:
		skk_state_set_typing_rule (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gboolean
skk_state_handler_real_process_key_event (SkkStateHandler* self,
                                          SkkState* state,
                                          SkkKeyEvent** key)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `skk_state_handler_process_key_event'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
skk_state_handler_process_key_event (SkkStateHandler* self,
                                     SkkState* state,
                                     SkkKeyEvent** key)
{
	SkkStateHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SKK_STATE_HANDLER_GET_CLASS (self);
	if (_klass_->process_key_event) {
		return _klass_->process_key_event (self, state, key);
	}
	return FALSE;
}

static gchar*
skk_state_handler_real_get_preedit (SkkStateHandler* self,
                                    SkkState* state,
                                    guint* underline_offset,
                                    guint* underline_nchars)
{
	g_critical ("Type `%s' does not implement abstract method `skk_state_handler_get_preedit'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
skk_state_handler_get_preedit (SkkStateHandler* self,
                               SkkState* state,
                               guint* underline_offset,
                               guint* underline_nchars)
{
	SkkStateHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SKK_STATE_HANDLER_GET_CLASS (self);
	if (_klass_->get_preedit) {
		return _klass_->get_preedit (self, state, underline_offset, underline_nchars);
	}
	return NULL;
}

static gchar*
skk_state_handler_real_get_output (SkkStateHandler* self,
                                   SkkState* state)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = state->output;
	_tmp1_ = _tmp0_->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
skk_state_handler_get_output (SkkStateHandler* self,
                              SkkState* state)
{
	SkkStateHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SKK_STATE_HANDLER_GET_CLASS (self);
	if (_klass_->get_output) {
		return _klass_->get_output (self, state);
	}
	return NULL;
}

SkkStateHandler*
skk_state_handler_construct (GType object_type)
{
	SkkStateHandler * self = NULL;
	self = (SkkStateHandler*) g_object_new (object_type, NULL);
	return self;
}

static void
skk_state_handler_class_init (SkkStateHandlerClass * klass,
                              gpointer klass_data)
{
	skk_state_handler_parent_class = g_type_class_peek_parent (klass);
	((SkkStateHandlerClass *) klass)->process_key_event = (gboolean (*) (SkkStateHandler*, SkkState*, SkkKeyEvent**)) skk_state_handler_real_process_key_event;
	((SkkStateHandlerClass *) klass)->get_preedit = (gchar* (*) (SkkStateHandler*, SkkState*, guint*, guint*)) skk_state_handler_real_get_preedit;
	((SkkStateHandlerClass *) klass)->get_output = (gchar* (*) (SkkStateHandler*, SkkState*)) skk_state_handler_real_get_output;
}

static void
skk_state_handler_instance_init (SkkStateHandler * self,
                                 gpointer klass)
{
}

static GType
skk_state_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkStateHandler), 0, (GInstanceInitFunc) skk_state_handler_instance_init, NULL };
	GType skk_state_handler_type_id;
	skk_state_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkStateHandler", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return skk_state_handler_type_id;
}

GType
skk_state_handler_get_type (void)
{
	static volatile gsize skk_state_handler_type_id__once = 0;
	if (g_once_init_enter (&skk_state_handler_type_id__once)) {
		GType skk_state_handler_type_id;
		skk_state_handler_type_id = skk_state_handler_get_type_once ();
		g_once_init_leave (&skk_state_handler_type_id__once, skk_state_handler_type_id);
	}
	return skk_state_handler_type_id__once;
}

void
skk_input_mode_command_entry_copy (const SkkInputModeCommandEntry* self,
                                   SkkInputModeCommandEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).key;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp1_;
	(*dest).value = (*self).value;
}

void
skk_input_mode_command_entry_destroy (SkkInputModeCommandEntry* self)
{
	_g_free0 ((*self).key);
}

SkkInputModeCommandEntry*
skk_input_mode_command_entry_dup (const SkkInputModeCommandEntry* self)
{
	SkkInputModeCommandEntry* dup;
	dup = g_new0 (SkkInputModeCommandEntry, 1);
	skk_input_mode_command_entry_copy (self, dup);
	return dup;
}

void
skk_input_mode_command_entry_free (SkkInputModeCommandEntry* self)
{
	skk_input_mode_command_entry_destroy (self);
	g_free (self);
}

static GType
skk_input_mode_command_entry_get_type_once (void)
{
	GType skk_input_mode_command_entry_type_id;
	skk_input_mode_command_entry_type_id = g_boxed_type_register_static ("SkkInputModeCommandEntry", (GBoxedCopyFunc) skk_input_mode_command_entry_dup, (GBoxedFreeFunc) skk_input_mode_command_entry_free);
	return skk_input_mode_command_entry_type_id;
}

GType
skk_input_mode_command_entry_get_type (void)
{
	static volatile gsize skk_input_mode_command_entry_type_id__once = 0;
	if (g_once_init_enter (&skk_input_mode_command_entry_type_id__once)) {
		GType skk_input_mode_command_entry_type_id;
		skk_input_mode_command_entry_type_id = skk_input_mode_command_entry_get_type_once ();
		g_once_init_leave (&skk_input_mode_command_entry_type_id__once, skk_input_mode_command_entry_type_id);
	}
	return skk_input_mode_command_entry_type_id__once;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gboolean
skk_none_state_handler_real_process_key_event (SkkStateHandler* base,
                                               SkkState* state,
                                               SkkKeyEvent** key)
{
	SkkNoneStateHandler * self;
	gchar* command = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	const gchar* _tmp53_;
	const gchar* _tmp75_;
	const gchar* _tmp83_;
	SkkInputMode _tmp88_;
	SkkInputMode _tmp89_;
	gboolean result;
	self = (SkkNoneStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (*key != NULL, FALSE);
	_tmp0_ = skk_state_lookup_key (state, *key);
	command = _tmp0_;
	_tmp2_ = command;
	if (_tmp2_ == NULL) {
		gunichar _tmp3_;
		gunichar _tmp4_;
		_tmp3_ = skk_key_event_get_code (*key);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == ((gunichar) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_free0 (command);
		return result;
	}
	_tmp7_ = command;
	if (g_strcmp0 (_tmp7_, "abort") == 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = command;
		_tmp6_ = g_strcmp0 (_tmp8_, "abort-to-latin") == 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = command;
		_tmp5_ = g_strcmp0 (_tmp9_, "abort-to-latin-unhandled") == 0;
	}
	if (_tmp5_) {
		gboolean something_changed = FALSE;
		SkkRomKanaConverter* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gboolean _tmp16_ = FALSE;
		SkkInputMode _tmp18_;
		SkkInputMode _tmp19_;
		const gchar* _tmp20_;
		_tmp10_ = state->rom_kana_converter;
		_tmp11_ = skk_rom_kana_converter_get_preedit (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ > 0) {
			something_changed = TRUE;
		} else {
			gboolean _tmp15_ = FALSE;
			g_signal_emit (state, skk_state_signals[SKK_STATE_RECURSIVE_EDIT_ABORT_SIGNAL], 0, &_tmp15_);
			something_changed = _tmp15_;
		}
		skk_state_reset (state);
		if (something_changed) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = command;
			_tmp16_ = g_strcmp0 (_tmp17_, "abort") == 0;
		}
		if (_tmp16_) {
			result = something_changed;
			_g_free0 (command);
			return result;
		}
		_tmp18_ = skk_state_get_input_mode (state);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != SKK_INPUT_MODE_LATIN) {
			skk_state_set_input_mode (state, SKK_INPUT_MODE_LATIN);
			something_changed = TRUE;
		}
		_tmp20_ = command;
		result = g_strcmp0 (_tmp20_, "abort-to-latin") == 0;
		_g_free0 (command);
		return result;
	} else {
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		_tmp22_ = command;
		if (g_strcmp0 (_tmp22_, "commit") == 0) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp23_;
			_tmp23_ = command;
			_tmp21_ = g_strcmp0 (_tmp23_, "commit-unhandled") == 0;
		}
		if (_tmp21_) {
			gboolean handled = FALSE;
			GString* _tmp24_;
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gboolean _tmp32_ = FALSE;
			const gchar* _tmp33_;
			_tmp24_ = state->output;
			_tmp25_ = _tmp24_->str;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			if (_tmp27_ == 0) {
				gboolean _tmp28_ = FALSE;
				g_signal_emit (state, skk_state_signals[SKK_STATE_RECURSIVE_EDIT_ABORT_SIGNAL], 0, &_tmp28_);
				handled = _tmp28_;
			} else {
				GString* _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp31_ = FALSE;
				_tmp29_ = state->output;
				_tmp30_ = _tmp29_->str;
				g_signal_emit (state, skk_state_signals[SKK_STATE_RECURSIVE_EDIT_END_SIGNAL], 0, _tmp30_, &_tmp31_);
				handled = _tmp31_;
			}
			skk_state_reset (state);
			_tmp33_ = command;
			if (g_strcmp0 (_tmp33_, "commit") == 0) {
				_tmp32_ = TRUE;
			} else {
				_tmp32_ = handled;
			}
			result = _tmp32_;
			_g_free0 (command);
			return result;
		} else {
			gboolean _tmp34_ = FALSE;
			const gchar* _tmp35_;
			_tmp35_ = command;
			if (g_strcmp0 (_tmp35_, "start-preedit") == 0) {
				_tmp34_ = TRUE;
			} else {
				const gchar* _tmp36_;
				_tmp36_ = command;
				_tmp34_ = g_strcmp0 (_tmp36_, "start-preedit-kana") == 0;
			}
			if (_tmp34_) {
				gchar* text = NULL;
				guint cursor_pos = 0U;
				gchar* _tmp37_ = NULL;
				guint _tmp38_ = 0U;
				gboolean _tmp39_ = FALSE;
				g_signal_emit (state, skk_state_signals[SKK_STATE_RETRIEVE_SURROUNDING_TEXT_SIGNAL], 0, &_tmp37_, &_tmp38_, &_tmp39_);
				_g_free0 (text);
				text = _tmp37_;
				cursor_pos = _tmp38_;
				if (_tmp39_) {
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					SkkUnicodeString* _tmp47_;
					SkkUnicodeString* _tmp48_;
					gboolean _tmp49_ = FALSE;
					_tmp40_ = text;
					_tmp41_ = text;
					_tmp42_ = text;
					_tmp43_ = strlen (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = string_slice (_tmp40_, (glong) string_index_of_nth_char (_tmp41_, (glong) cursor_pos), (glong) _tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = skk_unicode_string_new (_tmp46_);
					_g_object_unref0 (state->surrounding_text);
					state->surrounding_text = _tmp47_;
					_g_free0 (_tmp46_);
					state->surrounding_end = (guint) 0;
					_tmp48_ = state->surrounding_text;
					g_signal_emit (state, skk_state_signals[SKK_STATE_DELETE_SURROUNDING_TEXT_SIGNAL], 0, 0, (guint) _tmp48_->length, &_tmp49_);
				}
				state->handler_type = SKK_TYPE_START_STATE_HANDLER;
				result = TRUE;
				_g_free0 (text);
				_g_free0 (command);
				return result;
			} else {
				const gchar* _tmp50_;
				_tmp50_ = command;
				if (g_strcmp0 (_tmp50_, "start-preedit-no-delete") == 0) {
					state->handler_type = SKK_TYPE_START_STATE_HANDLER;
					result = TRUE;
					_g_free0 (command);
					return result;
				}
			}
		}
	}
	_tmp53_ = command;
	if (_tmp53_ != NULL) {
		const gchar* _tmp54_;
		_tmp54_ = command;
		_tmp52_ = g_str_has_prefix (_tmp54_, "set-input-mode-");
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		gboolean _tmp55_ = FALSE;
		gboolean _tmp56_ = FALSE;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
		SkkInputMode _tmp59_;
		SkkInputMode _tmp60_;
		_tmp59_ = skk_state_get_input_mode (state);
		_tmp60_ = _tmp59_;
		if (_tmp60_ == SKK_INPUT_MODE_HIRAGANA) {
			_tmp58_ = TRUE;
		} else {
			SkkInputMode _tmp61_;
			SkkInputMode _tmp62_;
			_tmp61_ = skk_state_get_input_mode (state);
			_tmp62_ = _tmp61_;
			_tmp58_ = _tmp62_ == SKK_INPUT_MODE_KATAKANA;
		}
		if (_tmp58_) {
			_tmp57_ = TRUE;
		} else {
			SkkInputMode _tmp63_;
			SkkInputMode _tmp64_;
			_tmp63_ = skk_state_get_input_mode (state);
			_tmp64_ = _tmp63_;
			_tmp57_ = _tmp64_ == SKK_INPUT_MODE_HANKAKU_KATAKANA;
		}
		if (_tmp57_) {
			SkkModifierType _tmp65_;
			SkkModifierType _tmp66_;
			_tmp65_ = skk_key_event_get_modifiers (*key);
			_tmp66_ = _tmp65_;
			_tmp56_ = _tmp66_ == 0;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			SkkRomKanaConverter* _tmp67_;
			gunichar _tmp68_;
			gunichar _tmp69_;
			_tmp67_ = state->rom_kana_converter;
			_tmp68_ = skk_key_event_get_code (*key);
			_tmp69_ = _tmp68_;
			_tmp55_ = skk_rom_kana_converter_can_consume (_tmp67_, _tmp69_, FALSE, TRUE);
		} else {
			_tmp55_ = FALSE;
		}
		_tmp51_ = !_tmp55_;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		{
			SkkInputModeCommandEntry* entry_collection = NULL;
			gint entry_collection_length1 = 0;
			gint _entry_collection_size_ = 0;
			gint entry_it = 0;
			entry_collection = SKK_NONE_STATE_HANDLER_input_mode_commands;
			entry_collection_length1 = G_N_ELEMENTS (SKK_NONE_STATE_HANDLER_input_mode_commands);
			for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
				SkkInputModeCommandEntry entry = {0};
				entry = entry_collection[entry_it];
				{
					SkkInputModeCommandEntry _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = entry;
					_tmp71_ = _tmp70_.key;
					_tmp72_ = command;
					if (g_strcmp0 (_tmp71_, _tmp72_) == 0) {
						SkkRomKanaConverter* _tmp73_;
						SkkInputModeCommandEntry _tmp74_;
						_tmp73_ = state->rom_kana_converter;
						skk_rom_kana_converter_output_nn_if_any (_tmp73_);
						_tmp74_ = entry;
						skk_state_set_input_mode (state, _tmp74_.value);
						result = TRUE;
						_g_free0 (command);
						return result;
					}
				}
			}
		}
	}
	_tmp75_ = command;
	if (g_strcmp0 (_tmp75_, "delete") == 0) {
		SkkRomKanaConverter* _tmp76_;
		GString* _tmp77_;
		_tmp76_ = state->rom_kana_converter;
		if (skk_rom_kana_converter_delete (_tmp76_)) {
			result = TRUE;
			_g_free0 (command);
			return result;
		}
		_tmp77_ = state->output;
		if (_tmp77_->len > ((gssize) 0)) {
			GString* _tmp78_;
			GString* _tmp79_;
			const gchar* _tmp80_;
			GString* _tmp81_;
			const gchar* _tmp82_;
			_tmp78_ = state->output;
			_tmp79_ = state->output;
			_tmp80_ = _tmp79_->str;
			_tmp81_ = state->output;
			_tmp82_ = _tmp81_->str;
			g_string_truncate (_tmp78_, (gsize) string_index_of_nth_char (_tmp80_, (glong) (g_utf8_strlen (_tmp82_, (gssize) -1) - 1)));
			result = TRUE;
			_g_free0 (command);
			return result;
		}
		result = FALSE;
		_g_free0 (command);
		return result;
	}
	_tmp83_ = command;
	if (g_strcmp0 (_tmp83_, "register") == 0) {
		GString* _tmp84_;
		GString* _tmp85_;
		const gchar* _tmp86_;
		GString* _tmp87_;
		g_signal_emit (state, skk_state_signals[SKK_STATE_REQUEST_SELECTION_TEXT_SIGNAL], 0);
		_tmp84_ = state->output;
		_tmp85_ = state->selection;
		_tmp86_ = _tmp85_->str;
		g_string_append (_tmp84_, _tmp86_);
		_tmp87_ = state->selection;
		g_string_erase (_tmp87_, (gssize) 0, (gssize) -1);
		result = TRUE;
		_g_free0 (command);
		return result;
	}
	_tmp88_ = skk_state_get_input_mode (state);
	_tmp89_ = _tmp88_;
	switch (_tmp89_) {
		case SKK_INPUT_MODE_HIRAGANA:
		case SKK_INPUT_MODE_KATAKANA:
		case SKK_INPUT_MODE_HANKAKU_KATAKANA:
		{
			gunichar lower_code = 0U;
			gboolean _tmp90_ = FALSE;
			gboolean _tmp91_ = FALSE;
			gboolean _tmp92_ = FALSE;
			const gchar* _tmp93_;
			gboolean _tmp113_ = FALSE;
			const gchar* _tmp114_;
			SkkModifierType _tmp130_;
			SkkModifierType _tmp131_;
			lower_code = (gunichar) 0;
			_tmp93_ = command;
			if (_tmp93_ != NULL) {
				_tmp92_ = TRUE;
			} else {
				SkkModifierType _tmp94_;
				SkkModifierType _tmp95_;
				_tmp94_ = skk_key_event_get_modifiers (*key);
				_tmp95_ = _tmp94_;
				_tmp92_ = _tmp95_ == 0;
			}
			if (_tmp92_) {
				gunichar _tmp96_ = 0U;
				gboolean _tmp97_;
				_tmp97_ = skk_state_isupper (state, *key, &_tmp96_);
				lower_code = _tmp96_;
				_tmp91_ = _tmp97_;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				SkkRomKanaConverter* _tmp98_;
				_tmp98_ = state->rom_kana_converter;
				_tmp90_ = skk_rom_kana_converter_is_valid (_tmp98_, lower_code);
			} else {
				_tmp90_ = FALSE;
			}
			if (_tmp90_) {
				SkkRomKanaConverter* _tmp99_;
				GString* _tmp100_;
				SkkRomKanaConverter* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				SkkRomKanaConverter* _tmp104_;
				_tmp99_ = state->rom_kana_converter;
				skk_rom_kana_converter_output_nn_if_any (_tmp99_);
				_tmp100_ = state->output;
				_tmp101_ = state->rom_kana_converter;
				_tmp102_ = skk_rom_kana_converter_get_output (_tmp101_);
				_tmp103_ = _tmp102_;
				g_string_append (_tmp100_, _tmp103_);
				_tmp104_ = state->rom_kana_converter;
				skk_rom_kana_converter_set_output (_tmp104_, "");
				state->handler_type = SKK_TYPE_START_STATE_HANDLER;
				result = FALSE;
				_g_free0 (command);
				return result;
			} else {
				gboolean _tmp105_ = FALSE;
				SkkModifierType _tmp106_;
				SkkModifierType _tmp107_;
				_tmp106_ = skk_key_event_get_modifiers (*key);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == 0) {
					SkkRomKanaConverter* _tmp108_;
					gunichar _tmp109_;
					gunichar _tmp110_;
					_tmp108_ = state->rom_kana_converter;
					_tmp109_ = skk_key_event_get_code (*key);
					_tmp110_ = _tmp109_;
					_tmp105_ = !skk_rom_kana_converter_can_consume (_tmp108_, _tmp110_, TRUE, TRUE);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					const gchar* _tmp111_;
					_tmp111_ = command;
					if (g_strcmp0 (_tmp111_, "abbrev") == 0) {
						state->handler_type = SKK_TYPE_ABBREV_STATE_HANDLER;
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						const gchar* _tmp112_;
						_tmp112_ = command;
						if (g_strcmp0 (_tmp112_, "kuten") == 0) {
							state->handler_type = SKK_TYPE_KUTEN_STATE_HANDLER;
							result = TRUE;
							_g_free0 (command);
							return result;
						}
					}
				}
			}
			_tmp114_ = command;
			if (_tmp114_ != NULL) {
				const gchar* _tmp115_;
				_tmp115_ = command;
				_tmp113_ = g_str_has_prefix (_tmp115_, "insert-kana-");
			} else {
				_tmp113_ = FALSE;
			}
			if (_tmp113_) {
				gchar* kana = NULL;
				const gchar* _tmp116_;
				gint _tmp117_;
				gint _tmp118_;
				const gchar* _tmp119_;
				gint _tmp120_;
				gint _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				SkkInputMode _tmp124_;
				SkkInputMode _tmp125_;
				gchar* _tmp126_;
				gchar* _tmp127_;
				GString* _tmp128_;
				const gchar* _tmp129_;
				_tmp116_ = command;
				_tmp117_ = strlen ("insert-kana-");
				_tmp118_ = _tmp117_;
				_tmp119_ = command;
				_tmp120_ = strlen (_tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = string_slice (_tmp116_, (glong) _tmp118_, (glong) _tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = skk_state_get_input_mode (state);
				_tmp125_ = _tmp124_;
				_tmp126_ = skk_util_convert_by_input_mode (_tmp123_, _tmp125_);
				_tmp127_ = _tmp126_;
				_g_free0 (_tmp123_);
				kana = _tmp127_;
				_tmp128_ = state->output;
				_tmp129_ = kana;
				g_string_append (_tmp128_, _tmp129_);
				result = TRUE;
				_g_free0 (kana);
				_g_free0 (command);
				return result;
			}
			_tmp130_ = skk_key_event_get_modifiers (*key);
			_tmp131_ = _tmp130_;
			if (_tmp131_ == 0) {
				SkkRomKanaConverter* _tmp132_;
				gunichar _tmp133_;
				gunichar _tmp134_;
				_tmp132_ = state->rom_kana_converter;
				_tmp133_ = skk_key_event_get_code (*key);
				_tmp134_ = _tmp133_;
				if (skk_rom_kana_converter_append (_tmp132_, _tmp134_)) {
					GString* _tmp135_;
					SkkRomKanaConverter* _tmp136_;
					const gchar* _tmp137_;
					const gchar* _tmp138_;
					SkkRomKanaConverter* _tmp139_;
					_tmp135_ = state->output;
					_tmp136_ = state->rom_kana_converter;
					_tmp137_ = skk_rom_kana_converter_get_output (_tmp136_);
					_tmp138_ = _tmp137_;
					g_string_append (_tmp135_, _tmp138_);
					_tmp139_ = state->rom_kana_converter;
					skk_rom_kana_converter_set_output (_tmp139_, "");
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					gboolean _tmp140_ = FALSE;
					gunichar _tmp141_;
					gunichar _tmp142_;
					_tmp141_ = skk_key_event_get_code (*key);
					_tmp142_ = _tmp141_;
					if (((gunichar) 0x20) <= _tmp142_) {
						gunichar _tmp143_;
						gunichar _tmp144_;
						_tmp143_ = skk_key_event_get_code (*key);
						_tmp144_ = _tmp143_;
						_tmp140_ = _tmp144_ < ((gunichar) 0x7F);
					} else {
						_tmp140_ = FALSE;
					}
					if (_tmp140_) {
						GString* _tmp145_;
						gunichar _tmp146_;
						gunichar _tmp147_;
						SkkRomKanaConverter* _tmp148_;
						_tmp145_ = state->output;
						_tmp146_ = skk_key_event_get_code (*key);
						_tmp147_ = _tmp146_;
						g_string_append_c (_tmp145_, (gchar) _tmp147_);
						_tmp148_ = state->rom_kana_converter;
						skk_rom_kana_converter_set_output (_tmp148_, "");
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						SkkRomKanaConverter* _tmp149_;
						_tmp149_ = state->rom_kana_converter;
						skk_rom_kana_converter_set_output (_tmp149_, "");
						result = FALSE;
						_g_free0 (command);
						return result;
					}
				}
			}
			break;
		}
		case SKK_INPUT_MODE_LATIN:
		{
			gboolean _tmp150_ = FALSE;
			gboolean _tmp151_ = FALSE;
			SkkModifierType _tmp152_;
			SkkModifierType _tmp153_;
			_tmp152_ = skk_key_event_get_modifiers (*key);
			_tmp153_ = _tmp152_;
			if (_tmp153_ == 0) {
				gunichar _tmp154_;
				gunichar _tmp155_;
				_tmp154_ = skk_key_event_get_code (*key);
				_tmp155_ = _tmp154_;
				_tmp151_ = ((gunichar) 0x20) <= _tmp155_;
			} else {
				_tmp151_ = FALSE;
			}
			if (_tmp151_) {
				gunichar _tmp156_;
				gunichar _tmp157_;
				_tmp156_ = skk_key_event_get_code (*key);
				_tmp157_ = _tmp156_;
				_tmp150_ = _tmp157_ < ((gunichar) 0x7F);
			} else {
				_tmp150_ = FALSE;
			}
			if (_tmp150_) {
				GString* _tmp158_;
				gunichar _tmp159_;
				gunichar _tmp160_;
				_tmp158_ = state->output;
				_tmp159_ = skk_key_event_get_code (*key);
				_tmp160_ = _tmp159_;
				g_string_append_c (_tmp158_, (gchar) _tmp160_);
				result = TRUE;
				_g_free0 (command);
				return result;
			}
			break;
		}
		case SKK_INPUT_MODE_WIDE_LATIN:
		{
			gboolean _tmp161_ = FALSE;
			gboolean _tmp162_ = FALSE;
			SkkModifierType _tmp163_;
			SkkModifierType _tmp164_;
			_tmp163_ = skk_key_event_get_modifiers (*key);
			_tmp164_ = _tmp163_;
			if (_tmp164_ == 0) {
				gunichar _tmp165_;
				gunichar _tmp166_;
				_tmp165_ = skk_key_event_get_code (*key);
				_tmp166_ = _tmp165_;
				_tmp162_ = ((gunichar) 0x20) <= _tmp166_;
			} else {
				_tmp162_ = FALSE;
			}
			if (_tmp162_) {
				gunichar _tmp167_;
				gunichar _tmp168_;
				_tmp167_ = skk_key_event_get_code (*key);
				_tmp168_ = _tmp167_;
				_tmp161_ = _tmp168_ < ((gunichar) 0x7F);
			} else {
				_tmp161_ = FALSE;
			}
			if (_tmp161_) {
				GString* _tmp169_;
				gunichar _tmp170_;
				gunichar _tmp171_;
				_tmp169_ = state->output;
				_tmp170_ = skk_key_event_get_code (*key);
				_tmp171_ = _tmp170_;
				g_string_append_unichar (_tmp169_, skk_util_get_wide_latin_char ((gchar) _tmp171_));
				result = TRUE;
				_g_free0 (command);
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	_g_free0 (command);
	return result;
}

static gchar*
skk_none_state_handler_real_get_preedit (SkkStateHandler* base,
                                         SkkState* state,
                                         guint* underline_offset,
                                         guint* underline_nchars)
{
	SkkNoneStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	GString* builder = NULL;
	GString* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	self = (SkkNoneStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = state->rom_kana_converter;
	_tmp2_ = skk_rom_kana_converter_get_preedit (_tmp1_);
	_tmp3_ = _tmp2_;
	g_string_append (builder, _tmp3_);
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp4_ = builder->str;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_g_string_free0 (builder);
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}

SkkNoneStateHandler*
skk_none_state_handler_construct (GType object_type)
{
	SkkNoneStateHandler * self = NULL;
	self = (SkkNoneStateHandler*) skk_state_handler_construct (object_type);
	return self;
}

SkkNoneStateHandler*
skk_none_state_handler_new (void)
{
	return skk_none_state_handler_construct (SKK_TYPE_NONE_STATE_HANDLER);
}

static void
skk_none_state_handler_class_init (SkkNoneStateHandlerClass * klass,
                                   gpointer klass_data)
{
	skk_none_state_handler_parent_class = g_type_class_peek_parent (klass);
	((SkkStateHandlerClass *) klass)->process_key_event = (gboolean (*) (SkkStateHandler*, SkkState*, SkkKeyEvent**)) skk_none_state_handler_real_process_key_event;
	((SkkStateHandlerClass *) klass)->get_preedit = (gchar* (*) (SkkStateHandler*, SkkState*, guint*, guint*)) skk_none_state_handler_real_get_preedit;
}

static void
skk_none_state_handler_instance_init (SkkNoneStateHandler * self,
                                      gpointer klass)
{
}

static GType
skk_none_state_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkNoneStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_none_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkNoneStateHandler), 0, (GInstanceInitFunc) skk_none_state_handler_instance_init, NULL };
	GType skk_none_state_handler_type_id;
	skk_none_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkNoneStateHandler", &g_define_type_info, 0);
	return skk_none_state_handler_type_id;
}

GType
skk_none_state_handler_get_type (void)
{
	static volatile gsize skk_none_state_handler_type_id__once = 0;
	if (g_once_init_enter (&skk_none_state_handler_type_id__once)) {
		GType skk_none_state_handler_type_id;
		skk_none_state_handler_type_id = skk_none_state_handler_get_type_once ();
		g_once_init_leave (&skk_none_state_handler_type_id__once, skk_none_state_handler_type_id);
	}
	return skk_none_state_handler_type_id__once;
}

static inline gpointer
skk_kuten_state_handler_get_instance_private (SkkKutenStateHandler* self)
{
	return G_STRUCT_MEMBER_P (self, SkkKutenStateHandler_private_offset);
}

SkkKutenStateHandler*
skk_kuten_state_handler_construct (GType object_type)
{
	SkkKutenStateHandler * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (SkkKutenStateHandler*) skk_state_handler_construct (object_type);
	{
		SkkEncodingConverter* _tmp0_ = NULL;
		SkkEncodingConverter* _tmp1_;
		SkkEncodingConverter* _tmp2_;
		_tmp1_ = skk_encoding_converter_new ("EUC-JP", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = NULL;
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

SkkKutenStateHandler*
skk_kuten_state_handler_new (void)
{
	return skk_kuten_state_handler_construct (SKK_TYPE_KUTEN_STATE_HANDLER);
}

static gint
skk_kuten_state_handler_hex_char_to_int (SkkKutenStateHandler* self,
                                         gchar hex)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if ('0' <= hex) {
		_tmp0_ = hex <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gint) (hex - '0');
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if ('a' <= g_ascii_tolower (hex)) {
			_tmp1_ = g_ascii_tolower (hex) <= 'f';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = (hex - 'a') + 10;
			return result;
		}
	}
	result = -1;
	return result;
}

static gchar*
skk_kuten_state_handler_parse_hex (SkkKutenStateHandler* self,
                                   const gchar* hex)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hex != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint c = 0;
				GString* _tmp4_;
				if (!_tmp1_) {
					i += 2;
				}
				_tmp1_ = FALSE;
				_tmp2_ = strlen (hex);
				_tmp3_ = _tmp2_;
				if (!(i < (_tmp3_ - 1))) {
					break;
				}
				c = (skk_kuten_state_handler_hex_char_to_int (self, string_get (hex, (glong) i)) << 4) | skk_kuten_state_handler_hex_char_to_int (self, string_get (hex, (glong) (i + 1)));
				_tmp4_ = builder;
				g_string_append_c (_tmp4_, (gchar) c);
			}
		}
	}
	_tmp5_ = builder;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (builder);
	return result;
}

static gboolean
skk_kuten_state_handler_real_process_key_event (SkkStateHandler* base,
                                                SkkState* state,
                                                SkkKeyEvent** key)
{
	SkkKutenStateHandler * self;
	gchar* command = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (SkkKutenStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (*key != NULL, FALSE);
	_tmp0_ = skk_state_lookup_key (state, *key);
	command = _tmp0_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "abort") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = command;
		_tmp2_ = g_strcmp0 (_tmp4_, "abort-to-latin") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = command;
		_tmp1_ = g_strcmp0 (_tmp5_, "abort-to-latin-unhandled") == 0;
	}
	if (_tmp1_) {
		skk_state_reset (state);
		result = TRUE;
		_g_free0 (command);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = command;
		if (g_strcmp0 (_tmp7_, "commit-unhandled") == 0) {
			gboolean _tmp8_ = FALSE;
			GString* _tmp9_;
			_tmp9_ = state->kuten;
			if (_tmp9_->len == ((gssize) 4)) {
				_tmp8_ = TRUE;
			} else {
				GString* _tmp10_;
				_tmp10_ = state->kuten;
				_tmp8_ = _tmp10_->len == ((gssize) 6);
			}
			_tmp6_ = _tmp8_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			SkkEncodingConverter* _tmp11_;
			_tmp11_ = self->priv->converter;
			if (_tmp11_ != NULL) {
				gchar* euc = NULL;
				GString* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = state->kuten;
				_tmp13_ = _tmp12_->str;
				_tmp14_ = skk_kuten_state_handler_parse_hex (self, _tmp13_);
				euc = _tmp14_;
				{
					gchar* _tmp15_ = NULL;
					SkkEncodingConverter* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					GString* _tmp19_;
					_tmp16_ = self->priv->converter;
					_tmp17_ = euc;
					_tmp18_ = skk_encoding_converter_decode (_tmp16_, _tmp17_, &_inner_error0_);
					_tmp15_ = _tmp18_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp19_ = state->output;
					g_string_append (_tmp19_, _tmp15_);
					_g_free0 (_tmp15_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp20_;
					GError* _tmp21_;
					const gchar* _tmp22_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp20_ = euc;
					_tmp21_ = e;
					_tmp22_ = _tmp21_->message;
					g_warning ("state.vala:719: can't decode %s in EUC-JP: %s", _tmp20_, _tmp22_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp23_ = FALSE;
					_g_free0 (euc);
					_g_free0 (command);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp23_;
				}
				_g_free0 (euc);
			}
			skk_state_reset (state);
			result = TRUE;
			_g_free0 (command);
			return result;
		} else {
			gboolean _tmp24_ = FALSE;
			const gchar* _tmp25_;
			_tmp25_ = command;
			if (g_strcmp0 (_tmp25_, "delete") == 0) {
				GString* _tmp26_;
				_tmp26_ = state->kuten;
				_tmp24_ = _tmp26_->len > ((gssize) 0);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GString* _tmp27_;
				GString* _tmp28_;
				_tmp27_ = state->kuten;
				_tmp28_ = state->kuten;
				g_string_truncate (_tmp27_, (gsize) (_tmp28_->len - 1));
				result = TRUE;
				_g_free0 (command);
				return result;
			} else {
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				SkkModifierType _tmp31_;
				SkkModifierType _tmp32_;
				_tmp31_ = skk_key_event_get_modifiers (*key);
				_tmp32_ = _tmp31_;
				if (_tmp32_ == 0) {
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					gunichar _tmp36_;
					gunichar _tmp37_;
					_tmp36_ = skk_key_event_get_code (*key);
					_tmp37_ = _tmp36_;
					if (((gunichar) 'a') <= _tmp37_) {
						gunichar _tmp38_;
						gunichar _tmp39_;
						_tmp38_ = skk_key_event_get_code (*key);
						_tmp39_ = _tmp38_;
						_tmp35_ = _tmp39_ <= ((gunichar) 'f');
					} else {
						_tmp35_ = FALSE;
					}
					if (_tmp35_) {
						_tmp34_ = TRUE;
					} else {
						gboolean _tmp40_ = FALSE;
						gunichar _tmp41_;
						gunichar _tmp42_;
						_tmp41_ = skk_key_event_get_code (*key);
						_tmp42_ = _tmp41_;
						if (((gunichar) 'A') <= _tmp42_) {
							gunichar _tmp43_;
							gunichar _tmp44_;
							_tmp43_ = skk_key_event_get_code (*key);
							_tmp44_ = _tmp43_;
							_tmp40_ = _tmp44_ <= ((gunichar) 'F');
						} else {
							_tmp40_ = FALSE;
						}
						_tmp34_ = _tmp40_;
					}
					if (_tmp34_) {
						_tmp33_ = TRUE;
					} else {
						gboolean _tmp45_ = FALSE;
						gunichar _tmp46_;
						gunichar _tmp47_;
						_tmp46_ = skk_key_event_get_code (*key);
						_tmp47_ = _tmp46_;
						if (((gunichar) '0') <= _tmp47_) {
							gunichar _tmp48_;
							gunichar _tmp49_;
							_tmp48_ = skk_key_event_get_code (*key);
							_tmp49_ = _tmp48_;
							_tmp45_ = _tmp49_ <= ((gunichar) '9');
						} else {
							_tmp45_ = FALSE;
						}
						_tmp33_ = _tmp45_;
					}
					_tmp30_ = _tmp33_;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					GString* _tmp50_;
					_tmp50_ = state->kuten;
					_tmp29_ = _tmp50_->len < ((gssize) 6);
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					GString* _tmp51_;
					gunichar _tmp52_;
					gunichar _tmp53_;
					_tmp51_ = state->kuten;
					_tmp52_ = skk_key_event_get_code (*key);
					_tmp53_ = _tmp52_;
					g_string_append_unichar (_tmp51_, _tmp53_);
					result = TRUE;
					_g_free0 (command);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (command);
	return result;
}

static gchar*
skk_kuten_state_handler_real_get_preedit (SkkStateHandler* base,
                                          SkkState* state,
                                          guint* underline_offset,
                                          guint* underline_nchars)
{
	SkkKutenStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (SkkKutenStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp0_ = state->kuten;
	_tmp1_ = _tmp0_->str;
	_tmp2_ = g_strconcat (_ ("Kuten([MM]KKTT) "), _tmp1_, NULL);
	result = _tmp2_;
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}

static void
skk_kuten_state_handler_class_init (SkkKutenStateHandlerClass * klass,
                                    gpointer klass_data)
{
	skk_kuten_state_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkKutenStateHandler_private_offset);
	((SkkStateHandlerClass *) klass)->process_key_event = (gboolean (*) (SkkStateHandler*, SkkState*, SkkKeyEvent**)) skk_kuten_state_handler_real_process_key_event;
	((SkkStateHandlerClass *) klass)->get_preedit = (gchar* (*) (SkkStateHandler*, SkkState*, guint*, guint*)) skk_kuten_state_handler_real_get_preedit;
	G_OBJECT_CLASS (klass)->finalize = skk_kuten_state_handler_finalize;
}

static void
skk_kuten_state_handler_instance_init (SkkKutenStateHandler * self,
                                       gpointer klass)
{
	self->priv = skk_kuten_state_handler_get_instance_private (self);
}

static void
skk_kuten_state_handler_finalize (GObject * obj)
{
	SkkKutenStateHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandler);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_kuten_state_handler_parent_class)->finalize (obj);
}

static GType
skk_kuten_state_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkKutenStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_kuten_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKutenStateHandler), 0, (GInstanceInitFunc) skk_kuten_state_handler_instance_init, NULL };
	GType skk_kuten_state_handler_type_id;
	skk_kuten_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkKutenStateHandler", &g_define_type_info, 0);
	SkkKutenStateHandler_private_offset = g_type_add_instance_private (skk_kuten_state_handler_type_id, sizeof (SkkKutenStateHandlerPrivate));
	return skk_kuten_state_handler_type_id;
}

GType
skk_kuten_state_handler_get_type (void)
{
	static volatile gsize skk_kuten_state_handler_type_id__once = 0;
	if (g_once_init_enter (&skk_kuten_state_handler_type_id__once)) {
		GType skk_kuten_state_handler_type_id;
		skk_kuten_state_handler_type_id = skk_kuten_state_handler_get_type_once ();
		g_once_init_leave (&skk_kuten_state_handler_type_id__once, skk_kuten_state_handler_type_id);
	}
	return skk_kuten_state_handler_type_id__once;
}

static gboolean
skk_abbrev_state_handler_real_process_key_event (SkkStateHandler* base,
                                                 SkkState* state,
                                                 SkkKeyEvent** key)
{
	SkkAbbrevStateHandler * self;
	gchar* command = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	self = (SkkAbbrevStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (*key != NULL, FALSE);
	_tmp0_ = skk_state_lookup_key (state, *key);
	command = _tmp0_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "abort") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = command;
		_tmp2_ = g_strcmp0 (_tmp4_, "abort-to-latin") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = command;
		_tmp1_ = g_strcmp0 (_tmp5_, "abort-to-latin-unhandled") == 0;
	}
	if (_tmp1_) {
		skk_state_reset (state);
		result = TRUE;
		_g_free0 (command);
		return result;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = command;
		if (g_strcmp0 (_tmp6_, "next-candidate") == 0) {
			state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
			result = FALSE;
			_g_free0 (command);
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			SkkModifierType _tmp8_;
			SkkModifierType _tmp9_;
			_tmp8_ = skk_key_event_get_modifiers (*key);
			_tmp9_ = _tmp8_;
			if ((_tmp9_ & SKK_MODIFIER_TYPE_CONTROL_MASK) != 0) {
				gunichar _tmp10_;
				gunichar _tmp11_;
				_tmp10_ = skk_key_event_get_code (*key);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ == ((gunichar) 'q');
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				GString* _tmp12_;
				GString* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp12_ = state->output;
				_tmp13_ = state->abbrev;
				_tmp14_ = _tmp13_->str;
				_tmp15_ = skk_util_get_wide_latin (_tmp14_);
				_tmp16_ = _tmp15_;
				g_string_assign (_tmp12_, _tmp16_);
				_g_free0 (_tmp16_);
				skk_state_reset (state);
				result = TRUE;
				_g_free0 (command);
				return result;
			} else {
				const gchar* _tmp17_;
				_tmp17_ = command;
				if (g_strcmp0 (_tmp17_, "delete") == 0) {
					GString* _tmp18_;
					_tmp18_ = state->abbrev;
					if (_tmp18_->len > ((gssize) 0)) {
						GString* _tmp19_;
						GString* _tmp20_;
						_tmp19_ = state->abbrev;
						_tmp20_ = state->abbrev;
						g_string_truncate (_tmp19_, (gsize) (_tmp20_->len - 1));
					} else {
						skk_state_reset (state);
					}
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					const gchar* _tmp21_;
					_tmp21_ = command;
					if (g_strcmp0 (_tmp21_, "commit") == 0) {
						GString* _tmp22_;
						GString* _tmp23_;
						const gchar* _tmp24_;
						_tmp22_ = state->output;
						_tmp23_ = state->abbrev;
						_tmp24_ = _tmp23_->str;
						g_string_assign (_tmp22_, _tmp24_);
						skk_state_reset (state);
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						const gchar* _tmp25_;
						_tmp25_ = command;
						if (g_strcmp0 (_tmp25_, "commit-unhandled") == 0) {
							GString* _tmp26_;
							GString* _tmp27_;
							const gchar* _tmp28_;
							_tmp26_ = state->output;
							_tmp27_ = state->abbrev;
							_tmp28_ = _tmp27_->str;
							g_string_assign (_tmp26_, _tmp28_);
							skk_state_reset (state);
							result = state->egg_like_newline;
							_g_free0 (command);
							return result;
						} else {
							const gchar* _tmp29_;
							_tmp29_ = command;
							if (g_strcmp0 (_tmp29_, "register") == 0) {
								GString* _tmp30_;
								GString* _tmp31_;
								const gchar* _tmp32_;
								GString* _tmp33_;
								g_signal_emit (state, skk_state_signals[SKK_STATE_REQUEST_SELECTION_TEXT_SIGNAL], 0);
								_tmp30_ = state->abbrev;
								_tmp31_ = state->selection;
								_tmp32_ = _tmp31_->str;
								g_string_append (_tmp30_, _tmp32_);
								_tmp33_ = state->selection;
								g_string_erase (_tmp33_, (gssize) 0, (gssize) -1);
								result = TRUE;
								_g_free0 (command);
								return result;
							} else {
								const gchar* _tmp34_;
								_tmp34_ = command;
								if (g_strcmp0 (_tmp34_, "complete") == 0) {
									GeeBidirListIterator* _tmp35_;
									GeeBidirListIterator* _tmp38_;
									_tmp35_ = state->completion_iterator;
									if (_tmp35_ == NULL) {
										GString* _tmp36_;
										const gchar* _tmp37_;
										_tmp36_ = state->abbrev;
										_tmp37_ = _tmp36_->str;
										skk_state_completion_start (state, _tmp37_);
									}
									_tmp38_ = state->completion_iterator;
									if (_tmp38_ != NULL) {
										gchar* midasi = NULL;
										GeeBidirListIterator* _tmp39_;
										gpointer _tmp40_;
										GString* _tmp41_;
										const gchar* _tmp42_;
										GeeBidirListIterator* _tmp43_;
										_tmp39_ = state->completion_iterator;
										_tmp40_ = gee_iterator_get ((GeeIterator*) _tmp39_);
										midasi = (gchar*) _tmp40_;
										_tmp41_ = state->abbrev;
										_tmp42_ = midasi;
										g_string_assign (_tmp41_, _tmp42_);
										_tmp43_ = state->completion_iterator;
										if (gee_iterator_has_next ((GeeIterator*) _tmp43_)) {
											GeeBidirListIterator* _tmp44_;
											_tmp44_ = state->completion_iterator;
											gee_iterator_next ((GeeIterator*) _tmp44_);
										}
										_g_free0 (midasi);
									}
								} else {
									gboolean _tmp45_ = FALSE;
									gboolean _tmp46_ = FALSE;
									SkkModifierType _tmp47_;
									SkkModifierType _tmp48_;
									_tmp47_ = skk_key_event_get_modifiers (*key);
									_tmp48_ = _tmp47_;
									if (_tmp48_ == 0) {
										gunichar _tmp49_;
										gunichar _tmp50_;
										_tmp49_ = skk_key_event_get_code (*key);
										_tmp50_ = _tmp49_;
										_tmp46_ = ((gunichar) 0x20) <= _tmp50_;
									} else {
										_tmp46_ = FALSE;
									}
									if (_tmp46_) {
										gunichar _tmp51_;
										gunichar _tmp52_;
										_tmp51_ = skk_key_event_get_code (*key);
										_tmp52_ = _tmp51_;
										_tmp45_ = _tmp52_ <= ((gunichar) 0x7E);
									} else {
										_tmp45_ = FALSE;
									}
									if (_tmp45_) {
										GString* _tmp53_;
										gunichar _tmp54_;
										gunichar _tmp55_;
										_tmp53_ = state->abbrev;
										_tmp54_ = skk_key_event_get_code (*key);
										_tmp55_ = _tmp54_;
										g_string_append_unichar (_tmp53_, _tmp55_);
										result = TRUE;
										_g_free0 (command);
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (command);
	return result;
}

static gchar*
skk_abbrev_state_handler_real_get_preedit (SkkStateHandler* base,
                                           SkkState* state,
                                           guint* underline_offset,
                                           guint* underline_nchars)
{
	SkkAbbrevStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (SkkAbbrevStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp0_ = state->abbrev;
	_tmp1_ = _tmp0_->str;
	_tmp2_ = g_strconcat ("▽", _tmp1_, NULL);
	result = _tmp2_;
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}

SkkAbbrevStateHandler*
skk_abbrev_state_handler_construct (GType object_type)
{
	SkkAbbrevStateHandler * self = NULL;
	self = (SkkAbbrevStateHandler*) skk_state_handler_construct (object_type);
	return self;
}

SkkAbbrevStateHandler*
skk_abbrev_state_handler_new (void)
{
	return skk_abbrev_state_handler_construct (SKK_TYPE_ABBREV_STATE_HANDLER);
}

static void
skk_abbrev_state_handler_class_init (SkkAbbrevStateHandlerClass * klass,
                                     gpointer klass_data)
{
	skk_abbrev_state_handler_parent_class = g_type_class_peek_parent (klass);
	((SkkStateHandlerClass *) klass)->process_key_event = (gboolean (*) (SkkStateHandler*, SkkState*, SkkKeyEvent**)) skk_abbrev_state_handler_real_process_key_event;
	((SkkStateHandlerClass *) klass)->get_preedit = (gchar* (*) (SkkStateHandler*, SkkState*, guint*, guint*)) skk_abbrev_state_handler_real_get_preedit;
}

static void
skk_abbrev_state_handler_instance_init (SkkAbbrevStateHandler * self,
                                        gpointer klass)
{
}

static GType
skk_abbrev_state_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkAbbrevStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_abbrev_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkAbbrevStateHandler), 0, (GInstanceInitFunc) skk_abbrev_state_handler_instance_init, NULL };
	GType skk_abbrev_state_handler_type_id;
	skk_abbrev_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkAbbrevStateHandler", &g_define_type_info, 0);
	return skk_abbrev_state_handler_type_id;
}

GType
skk_abbrev_state_handler_get_type (void)
{
	static volatile gsize skk_abbrev_state_handler_type_id__once = 0;
	if (g_once_init_enter (&skk_abbrev_state_handler_type_id__once)) {
		GType skk_abbrev_state_handler_type_id;
		skk_abbrev_state_handler_type_id = skk_abbrev_state_handler_get_type_once ();
		g_once_init_leave (&skk_abbrev_state_handler_type_id__once, skk_abbrev_state_handler_type_id);
	}
	return skk_abbrev_state_handler_type_id__once;
}

static gboolean
skk_start_state_handler_real_process_key_event (SkkStateHandler* base,
                                                SkkState* state,
                                                SkkKeyEvent** key)
{
	SkkStartStateHandler * self;
	gchar* command = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp27_;
	gunichar lower_code = 0U;
	gboolean is_upper = FALSE;
	gunichar _tmp159_ = 0U;
	gboolean _tmp160_;
	gboolean _tmp161_ = FALSE;
	gboolean _tmp162_ = FALSE;
	const gchar* _tmp163_;
	gboolean result;
	self = (SkkStartStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (*key != NULL, FALSE);
	_tmp0_ = skk_state_lookup_key (state, *key);
	command = _tmp0_;
	_tmp2_ = command;
	if (_tmp2_ == NULL) {
		gunichar _tmp3_;
		gunichar _tmp4_;
		_tmp3_ = skk_key_event_get_code (*key);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == ((gunichar) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (command);
		return result;
	}
	_tmp7_ = command;
	if (g_strcmp0 (_tmp7_, "abort") == 0) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = command;
		_tmp6_ = g_strcmp0 (_tmp8_, "abort-to-latin") == 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = command;
		_tmp5_ = g_strcmp0 (_tmp9_, "abort-to-latin-unhandled") == 0;
	}
	if (_tmp5_) {
		skk_state_reset (state);
		result = TRUE;
		_g_free0 (command);
		return result;
	}
	{
		SkkInputModeCommandEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_START_STATE_HANDLER_end_preedit_commands;
		entry_collection_length1 = G_N_ELEMENTS (SKK_START_STATE_HANDLER_end_preedit_commands);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			SkkInputModeCommandEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkInputModeCommandEntry _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp10_ = entry;
				_tmp11_ = _tmp10_.key;
				_tmp12_ = command;
				if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
					SkkRomKanaConverter* _tmp13_;
					GString* _tmp14_;
					SkkRomKanaConverter* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					SkkInputModeCommandEntry _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					SkkUnicodeString* _tmp21_;
					SkkRomKanaConverter* _tmp26_;
					_tmp13_ = state->rom_kana_converter;
					skk_rom_kana_converter_output_nn_if_any (_tmp13_);
					_tmp14_ = state->output;
					_tmp15_ = state->rom_kana_converter;
					_tmp16_ = skk_rom_kana_converter_get_output (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = entry;
					_tmp19_ = skk_util_convert_by_input_mode (_tmp17_, _tmp18_.value);
					_tmp20_ = _tmp19_;
					g_string_append (_tmp14_, _tmp20_);
					_g_free0 (_tmp20_);
					_tmp21_ = state->surrounding_text;
					if (_tmp21_ != NULL) {
						GString* _tmp22_;
						SkkUnicodeString* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp22_ = state->output;
						_tmp23_ = state->surrounding_text;
						_tmp24_ = skk_unicode_string_substring (_tmp23_, (glong) state->surrounding_end, (glong) -1);
						_tmp25_ = _tmp24_;
						g_string_append (_tmp22_, _tmp25_);
						_g_free0 (_tmp25_);
					}
					_tmp26_ = state->rom_kana_converter;
					skk_rom_kana_converter_reset (_tmp26_);
					state->handler_type = SKK_TYPE_NONE_STATE_HANDLER;
					result = TRUE;
					_g_free0 (command);
					return result;
				}
			}
		}
	}
	_tmp27_ = command;
	if (g_strcmp0 (_tmp27_, "next-candidate") == 0) {
		SkkRomKanaConverter* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp28_ = state->rom_kana_converter;
		_tmp29_ = skk_rom_kana_converter_get_output (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = strlen (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == 0) {
			SkkUnicodeString* _tmp33_;
			_tmp33_ = state->surrounding_text;
			if (_tmp33_ != NULL) {
				GString* _tmp34_;
				SkkUnicodeString* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp34_ = state->output;
				_tmp35_ = state->surrounding_text;
				_tmp36_ = skk_unicode_string_substring (_tmp35_, (glong) state->surrounding_end, (glong) -1);
				_tmp37_ = _tmp36_;
				g_string_append (_tmp34_, _tmp37_);
				_g_free0 (_tmp37_);
			}
			skk_state_reset (state);
			result = TRUE;
			_g_free0 (command);
			return result;
		}
		state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
		result = FALSE;
		_g_free0 (command);
		return result;
	} else {
		const gchar* _tmp38_;
		_tmp38_ = command;
		if (g_strcmp0 (_tmp38_, "commit") == 0) {
			GString* _tmp39_;
			SkkRomKanaConverter* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			SkkUnicodeString* _tmp43_;
			_tmp39_ = state->output;
			_tmp40_ = state->rom_kana_converter;
			_tmp41_ = skk_rom_kana_converter_get_output (_tmp40_);
			_tmp42_ = _tmp41_;
			g_string_append (_tmp39_, _tmp42_);
			_tmp43_ = state->surrounding_text;
			if (_tmp43_ != NULL) {
				GString* _tmp44_;
				SkkUnicodeString* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				_tmp44_ = state->output;
				_tmp45_ = state->surrounding_text;
				_tmp46_ = skk_unicode_string_substring (_tmp45_, (glong) state->surrounding_end, (glong) -1);
				_tmp47_ = _tmp46_;
				g_string_append (_tmp44_, _tmp47_);
				_g_free0 (_tmp47_);
			}
			skk_state_reset (state);
			result = TRUE;
			_g_free0 (command);
			return result;
		} else {
			const gchar* _tmp48_;
			_tmp48_ = command;
			if (g_strcmp0 (_tmp48_, "commit-unhandled") == 0) {
				GString* _tmp49_;
				SkkRomKanaConverter* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				SkkUnicodeString* _tmp53_;
				_tmp49_ = state->output;
				_tmp50_ = state->rom_kana_converter;
				_tmp51_ = skk_rom_kana_converter_get_output (_tmp50_);
				_tmp52_ = _tmp51_;
				g_string_append (_tmp49_, _tmp52_);
				_tmp53_ = state->surrounding_text;
				if (_tmp53_ != NULL) {
					GString* _tmp54_;
					SkkUnicodeString* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp54_ = state->output;
					_tmp55_ = state->surrounding_text;
					_tmp56_ = skk_unicode_string_substring (_tmp55_, (glong) state->surrounding_end, (glong) -1);
					_tmp57_ = _tmp56_;
					g_string_append (_tmp54_, _tmp57_);
					_g_free0 (_tmp57_);
				}
				skk_state_reset (state);
				result = state->egg_like_newline;
				_g_free0 (command);
				return result;
			} else {
				const gchar* _tmp58_;
				_tmp58_ = command;
				if (g_strcmp0 (_tmp58_, "delete") == 0) {
					SkkRomKanaConverter* _tmp59_;
					_tmp59_ = state->okuri_rom_kana_converter;
					if (skk_rom_kana_converter_delete (_tmp59_)) {
						SkkRomKanaConverter* _tmp60_;
						const gchar* _tmp61_;
						const gchar* _tmp62_;
						gint _tmp63_;
						gint _tmp64_;
						_tmp60_ = state->okuri_rom_kana_converter;
						_tmp61_ = skk_rom_kana_converter_get_preedit (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = strlen (_tmp62_);
						_tmp64_ = _tmp63_;
						if (_tmp64_ == 0) {
							state->okuri = FALSE;
						}
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						SkkRomKanaConverter* _tmp65_;
						_tmp65_ = state->rom_kana_converter;
						if (skk_rom_kana_converter_delete (_tmp65_)) {
							result = TRUE;
							_g_free0 (command);
							return result;
						} else {
							GString* _tmp66_;
							_tmp66_ = state->output;
							if (_tmp66_->len > ((gssize) 0)) {
								GString* _tmp67_;
								GString* _tmp68_;
								const gchar* _tmp69_;
								GString* _tmp70_;
								const gchar* _tmp71_;
								_tmp67_ = state->output;
								_tmp68_ = state->output;
								_tmp69_ = _tmp68_->str;
								_tmp70_ = state->output;
								_tmp71_ = _tmp70_->str;
								g_string_truncate (_tmp67_, (gsize) string_index_of_nth_char (_tmp69_, (glong) (g_utf8_strlen (_tmp71_, (gssize) -1) - 1)));
								result = TRUE;
								_g_free0 (command);
								return result;
							}
						}
					}
					state->handler_type = SKK_TYPE_NONE_STATE_HANDLER;
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					const gchar* _tmp72_;
					_tmp72_ = command;
					if (g_strcmp0 (_tmp72_, "complete") == 0) {
						GeeBidirListIterator* _tmp73_;
						GeeBidirListIterator* _tmp77_;
						_tmp73_ = state->completion_iterator;
						if (_tmp73_ == NULL) {
							SkkRomKanaConverter* _tmp74_;
							const gchar* _tmp75_;
							const gchar* _tmp76_;
							_tmp74_ = state->rom_kana_converter;
							_tmp75_ = skk_rom_kana_converter_get_output (_tmp74_);
							_tmp76_ = _tmp75_;
							skk_state_completion_start (state, _tmp76_);
						}
						_tmp77_ = state->completion_iterator;
						if (_tmp77_ != NULL) {
							gchar* midasi = NULL;
							GeeBidirListIterator* _tmp78_;
							gpointer _tmp79_;
							SkkRomKanaConverter* _tmp80_;
							SkkRomKanaConverter* _tmp81_;
							const gchar* _tmp82_;
							GeeBidirListIterator* _tmp83_;
							_tmp78_ = state->completion_iterator;
							_tmp79_ = gee_iterator_get ((GeeIterator*) _tmp78_);
							midasi = (gchar*) _tmp79_;
							_tmp80_ = state->rom_kana_converter;
							skk_rom_kana_converter_reset (_tmp80_);
							_tmp81_ = state->rom_kana_converter;
							_tmp82_ = midasi;
							skk_rom_kana_converter_set_output (_tmp81_, _tmp82_);
							_tmp83_ = state->completion_iterator;
							if (gee_iterator_has_next ((GeeIterator*) _tmp83_)) {
								GeeBidirListIterator* _tmp84_;
								_tmp84_ = state->completion_iterator;
								gee_iterator_next ((GeeIterator*) _tmp84_);
							}
							_g_free0 (midasi);
						}
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						const gchar* _tmp85_;
						_tmp85_ = command;
						if (g_strcmp0 (_tmp85_, "special-midasi") == 0) {
							SkkRomKanaConverter* _tmp86_;
							const gchar* _tmp87_;
							const gchar* _tmp88_;
							gint _tmp89_;
							gint _tmp90_;
							_tmp86_ = state->rom_kana_converter;
							_tmp87_ = skk_rom_kana_converter_get_output (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = strlen (_tmp88_);
							_tmp90_ = _tmp89_;
							if (_tmp90_ > 0) {
								SkkRomKanaConverter* _tmp91_;
								gunichar _tmp92_;
								gunichar _tmp93_;
								SkkKeyEvent* _tmp94_;
								_tmp91_ = state->rom_kana_converter;
								_tmp92_ = skk_key_event_get_code (*key);
								_tmp93_ = _tmp92_;
								skk_rom_kana_converter_append (_tmp91_, g_unichar_tolower (_tmp93_));
								state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
								_tmp94_ = skk_state_where_is (state, "next-candidate");
								_g_object_unref0 (*key);
								*key = _tmp94_;
								result = FALSE;
								_g_free0 (command);
								return result;
							} else {
								SkkRomKanaConverter* _tmp95_;
								gunichar _tmp96_;
								gunichar _tmp97_;
								_tmp95_ = state->rom_kana_converter;
								_tmp96_ = skk_key_event_get_code (*key);
								_tmp97_ = _tmp96_;
								skk_rom_kana_converter_append (_tmp95_, _tmp97_);
								result = TRUE;
								_g_free0 (command);
								return result;
							}
						} else {
							gboolean _tmp98_ = FALSE;
							const gchar* _tmp99_;
							_tmp99_ = command;
							if (_tmp99_ != NULL) {
								const gchar* _tmp100_;
								_tmp100_ = command;
								_tmp98_ = g_str_has_prefix (_tmp100_, "insert-kana-");
							} else {
								_tmp98_ = FALSE;
							}
							if (_tmp98_) {
								gchar* kana = NULL;
								const gchar* _tmp101_;
								gint _tmp102_;
								gint _tmp103_;
								const gchar* _tmp104_;
								gint _tmp105_;
								gint _tmp106_;
								gchar* _tmp107_;
								gchar* _tmp108_;
								SkkInputMode _tmp109_;
								SkkInputMode _tmp110_;
								gchar* _tmp111_;
								gchar* _tmp112_;
								_tmp101_ = command;
								_tmp102_ = strlen ("insert-kana-");
								_tmp103_ = _tmp102_;
								_tmp104_ = command;
								_tmp105_ = strlen (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp107_ = string_slice (_tmp101_, (glong) _tmp103_, (glong) _tmp106_);
								_tmp108_ = _tmp107_;
								_tmp109_ = skk_state_get_input_mode (state);
								_tmp110_ = _tmp109_;
								_tmp111_ = skk_util_convert_by_input_mode (_tmp108_, _tmp110_);
								_tmp112_ = _tmp111_;
								_g_free0 (_tmp108_);
								kana = _tmp112_;
								if (state->okuri) {
									SkkRomKanaConverter* _tmp113_;
									const gchar* _tmp114_;
									SkkKeyEvent* _tmp115_;
									_tmp113_ = state->okuri_rom_kana_converter;
									_tmp114_ = kana;
									skk_rom_kana_converter_set_output (_tmp113_, _tmp114_);
									state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
									_tmp115_ = skk_state_where_is (state, "next-candidate");
									_g_object_unref0 (*key);
									*key = _tmp115_;
									result = FALSE;
									_g_free0 (kana);
									_g_free0 (command);
									return result;
								} else {
									SkkRomKanaConverter* _tmp116_;
									SkkRomKanaConverter* _tmp117_;
									const gchar* _tmp118_;
									const gchar* _tmp119_;
									const gchar* _tmp120_;
									gchar* _tmp121_;
									gchar* _tmp122_;
									_tmp116_ = state->rom_kana_converter;
									_tmp117_ = state->rom_kana_converter;
									_tmp118_ = skk_rom_kana_converter_get_output (_tmp117_);
									_tmp119_ = _tmp118_;
									_tmp120_ = kana;
									_tmp121_ = g_strconcat (_tmp119_, _tmp120_, NULL);
									_tmp122_ = _tmp121_;
									skk_rom_kana_converter_set_output (_tmp117_, _tmp122_);
									_g_free0 (_tmp122_);
									result = TRUE;
									_g_free0 (kana);
									_g_free0 (command);
									return result;
								}
								_g_free0 (kana);
							} else {
								const gchar* _tmp123_;
								_tmp123_ = command;
								if (g_strcmp0 (_tmp123_, "start-preedit") == 0) {
									result = TRUE;
									_g_free0 (command);
									return result;
								} else {
									gboolean _tmp124_ = FALSE;
									const gchar* _tmp125_;
									_tmp125_ = command;
									if (g_strcmp0 (_tmp125_, "start-preedit-kana") == 0) {
										_tmp124_ = TRUE;
									} else {
										const gchar* _tmp126_;
										_tmp126_ = command;
										_tmp124_ = g_strcmp0 (_tmp126_, "start-preedit-no-delete") == 0;
									}
									if (_tmp124_) {
										SkkRomKanaConverter* _tmp127_;
										const gchar* _tmp128_;
										const gchar* _tmp129_;
										gint _tmp130_;
										gint _tmp131_;
										_tmp127_ = state->rom_kana_converter;
										_tmp128_ = skk_rom_kana_converter_get_output (_tmp127_);
										_tmp129_ = _tmp128_;
										_tmp130_ = strlen (_tmp129_);
										_tmp131_ = _tmp130_;
										if (_tmp131_ > 0) {
											state->okuri = TRUE;
										}
										result = TRUE;
										_g_free0 (command);
										return result;
									} else {
										const gchar* _tmp132_;
										_tmp132_ = command;
										if (g_strcmp0 (_tmp132_, "expand-preedit") == 0) {
											gboolean _tmp133_ = FALSE;
											SkkUnicodeString* _tmp134_;
											_tmp134_ = state->surrounding_text;
											if (_tmp134_ != NULL) {
												SkkUnicodeString* _tmp135_;
												_tmp135_ = state->surrounding_text;
												_tmp133_ = state->surrounding_end < ((guint) _tmp135_->length);
											} else {
												_tmp133_ = FALSE;
											}
											if (_tmp133_) {
												guint _tmp136_;
												SkkRomKanaConverter* _tmp137_;
												SkkUnicodeString* _tmp138_;
												gchar* _tmp139_;
												gchar* _tmp140_;
												_tmp136_ = state->surrounding_end;
												state->surrounding_end = _tmp136_ + 1;
												_tmp137_ = state->rom_kana_converter;
												_tmp138_ = state->surrounding_text;
												_tmp139_ = skk_unicode_string_substring (_tmp138_, (glong) 0, (glong) state->surrounding_end);
												_tmp140_ = _tmp139_;
												skk_rom_kana_converter_set_output (_tmp137_, _tmp140_);
												_g_free0 (_tmp140_);
												result = TRUE;
												_g_free0 (command);
												return result;
											}
										} else {
											const gchar* _tmp141_;
											_tmp141_ = command;
											if (g_strcmp0 (_tmp141_, "shrink-preedit") == 0) {
												gboolean _tmp142_ = FALSE;
												SkkUnicodeString* _tmp143_;
												_tmp143_ = state->surrounding_text;
												if (_tmp143_ != NULL) {
													_tmp142_ = state->surrounding_end > ((guint) 0);
												} else {
													_tmp142_ = FALSE;
												}
												if (_tmp142_) {
													guint _tmp144_;
													SkkRomKanaConverter* _tmp145_;
													SkkUnicodeString* _tmp146_;
													gchar* _tmp147_;
													gchar* _tmp148_;
													_tmp144_ = state->surrounding_end;
													state->surrounding_end = _tmp144_ - 1;
													_tmp145_ = state->rom_kana_converter;
													_tmp146_ = state->surrounding_text;
													_tmp147_ = skk_unicode_string_substring (_tmp146_, (glong) 0, (glong) state->surrounding_end);
													_tmp148_ = _tmp147_;
													skk_rom_kana_converter_set_output (_tmp145_, _tmp148_);
													_g_free0 (_tmp148_);
													result = TRUE;
													_g_free0 (command);
													return result;
												}
											} else {
												const gchar* _tmp149_;
												_tmp149_ = command;
												if (g_strcmp0 (_tmp149_, "register") == 0) {
													SkkRomKanaConverter* _tmp150_;
													SkkRomKanaConverter* _tmp151_;
													const gchar* _tmp152_;
													const gchar* _tmp153_;
													GString* _tmp154_;
													const gchar* _tmp155_;
													gchar* _tmp156_;
													gchar* _tmp157_;
													GString* _tmp158_;
													g_signal_emit (state, skk_state_signals[SKK_STATE_REQUEST_SELECTION_TEXT_SIGNAL], 0);
													_tmp150_ = state->rom_kana_converter;
													_tmp151_ = state->rom_kana_converter;
													_tmp152_ = skk_rom_kana_converter_get_output (_tmp151_);
													_tmp153_ = _tmp152_;
													_tmp154_ = state->selection;
													_tmp155_ = _tmp154_->str;
													_tmp156_ = g_strconcat (_tmp153_, _tmp155_, NULL);
													_tmp157_ = _tmp156_;
													skk_rom_kana_converter_set_output (_tmp151_, _tmp157_);
													_g_free0 (_tmp157_);
													_tmp158_ = state->selection;
													g_string_erase (_tmp158_, (gssize) 0, (gssize) -1);
													result = TRUE;
													_g_free0 (command);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp160_ = skk_state_isupper (state, *key, &_tmp159_);
	lower_code = _tmp159_;
	is_upper = _tmp160_;
	_tmp163_ = command;
	if (_tmp163_ != NULL) {
		_tmp162_ = TRUE;
	} else {
		SkkModifierType _tmp164_;
		SkkModifierType _tmp165_;
		_tmp164_ = skk_key_event_get_modifiers (*key);
		_tmp165_ = _tmp164_;
		_tmp162_ = _tmp165_ == 0;
	}
	if (_tmp162_) {
		SkkRomKanaConverter* _tmp166_;
		_tmp166_ = state->rom_kana_converter;
		_tmp161_ = skk_rom_kana_converter_is_valid (_tmp166_, lower_code);
	} else {
		_tmp161_ = FALSE;
	}
	if (_tmp161_) {
		gboolean _tmp167_ = FALSE;
		if (state->okuri) {
			_tmp167_ = TRUE;
		} else {
			gboolean _tmp168_ = FALSE;
			gboolean _tmp169_ = FALSE;
			if (is_upper) {
				SkkRomKanaConverter* _tmp170_;
				const gchar* _tmp171_;
				const gchar* _tmp172_;
				gint _tmp173_;
				gint _tmp174_;
				_tmp170_ = state->rom_kana_converter;
				_tmp171_ = skk_rom_kana_converter_get_output (_tmp170_);
				_tmp172_ = _tmp171_;
				_tmp173_ = strlen (_tmp172_);
				_tmp174_ = _tmp173_;
				_tmp169_ = _tmp174_ > 0;
			} else {
				_tmp169_ = FALSE;
			}
			if (_tmp169_) {
				SkkRomKanaConverter* _tmp175_;
				_tmp175_ = state->rom_kana_converter;
				_tmp168_ = !skk_rom_kana_converter_can_consume (_tmp175_, lower_code, TRUE, TRUE);
			} else {
				_tmp168_ = FALSE;
			}
			_tmp167_ = _tmp168_;
		}
		if (_tmp167_) {
			gboolean _tmp176_ = FALSE;
			SkkRomKanaConverter* _tmp179_;
			SkkRomKanaConverter* _tmp181_;
			SkkRomKanaConverter* _tmp182_;
			const gchar* _tmp183_;
			const gchar* _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			if (!state->okuri) {
				SkkRomKanaConverter* _tmp177_;
				_tmp177_ = state->rom_kana_converter;
				_tmp176_ = skk_rom_kana_converter_can_consume (_tmp177_, lower_code, TRUE, FALSE);
			} else {
				_tmp176_ = FALSE;
			}
			if (_tmp176_) {
				SkkRomKanaConverter* _tmp178_;
				_tmp178_ = state->rom_kana_converter;
				skk_rom_kana_converter_append (_tmp178_, lower_code);
			}
			_tmp179_ = state->rom_kana_converter;
			skk_rom_kana_converter_output_nn_if_any (_tmp179_);
			state->okuri = TRUE;
			if (is_upper) {
				SkkRomKanaConverter* _tmp180_;
				_tmp180_ = state->okuri_rom_kana_converter;
				skk_rom_kana_converter_output_nn_if_any (_tmp180_);
			}
			_tmp181_ = state->okuri_rom_kana_converter;
			skk_rom_kana_converter_append (_tmp181_, lower_code);
			_tmp182_ = state->okuri_rom_kana_converter;
			_tmp183_ = skk_rom_kana_converter_get_preedit (_tmp182_);
			_tmp184_ = _tmp183_;
			_tmp185_ = strlen (_tmp184_);
			_tmp186_ = _tmp185_;
			if (_tmp186_ == 0) {
				SkkKeyEvent* _tmp187_;
				state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
				_tmp187_ = skk_state_where_is (state, "next-candidate");
				_g_object_unref0 (*key);
				*key = _tmp187_;
				result = FALSE;
				_g_free0 (command);
				return result;
			}
			result = TRUE;
			_g_free0 (command);
			return result;
		} else {
			SkkRomKanaConverter* _tmp188_;
			_tmp188_ = state->rom_kana_converter;
			skk_rom_kana_converter_append (_tmp188_, lower_code);
			if (skk_start_state_handler_check_auto_conversion (self, state, *key)) {
				SkkKeyEvent* _tmp189_;
				state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
				_tmp189_ = skk_state_where_is (state, "next-candidate");
				_g_object_unref0 (*key);
				*key = _tmp189_;
				result = FALSE;
				_g_free0 (command);
				return result;
			}
			result = TRUE;
			_g_free0 (command);
			return result;
		}
	} else {
		SkkModifierType _tmp190_;
		SkkModifierType _tmp191_;
		_tmp190_ = skk_key_event_get_modifiers (*key);
		_tmp191_ = _tmp190_;
		if (_tmp191_ == 0) {
			SkkRomKanaConverter* _tmp192_;
			_tmp192_ = state->rom_kana_converter;
			skk_rom_kana_converter_append (_tmp192_, lower_code);
			if (skk_start_state_handler_check_auto_conversion (self, state, *key)) {
				SkkKeyEvent* _tmp193_;
				state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
				_tmp193_ = skk_state_where_is (state, "next-candidate");
				_g_object_unref0 (*key);
				*key = _tmp193_;
				result = FALSE;
				_g_free0 (command);
				return result;
			}
			result = TRUE;
			_g_free0 (command);
			return result;
		}
	}
	result = TRUE;
	_g_free0 (command);
	return result;
}

static gchar*
skk_start_state_handler_real_get_preedit (SkkStateHandler* base,
                                          SkkState* state,
                                          guint* underline_offset,
                                          guint* underline_nchars)
{
	SkkStartStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SkkUnicodeString* _tmp4_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	self = (SkkStartStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_string_new ("▽");
	builder = _tmp0_;
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp1_ = builder;
	_tmp2_ = skk_state_get_yomi (state);
	_tmp3_ = _tmp2_;
	g_string_append (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = state->surrounding_text;
	if (_tmp4_ != NULL) {
		GString* _tmp5_;
		const gchar* _tmp6_;
		GString* _tmp7_;
		SkkUnicodeString* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_vala_underline_offset = (guint) 1;
		_tmp5_ = builder;
		_tmp6_ = _tmp5_->str;
		_vala_underline_nchars = (guint) (g_utf8_strlen (_tmp6_, (gssize) -1) - 1);
		_tmp7_ = builder;
		_tmp8_ = state->surrounding_text;
		_tmp9_ = skk_unicode_string_substring (_tmp8_, (glong) state->surrounding_end, (glong) -1);
		_tmp10_ = _tmp9_;
		g_string_append (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = builder;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_string_free0 (builder);
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}

static gboolean
skk_start_state_handler_check_auto_conversion (SkkStartStateHandler* self,
                                               SkkState* state,
                                               SkkKeyEvent* key)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state->auto_start_henkan_keywords;
	_tmp0__length1 = state->auto_start_henkan_keywords_length1;
	{
		gchar** keyword_collection = NULL;
		gint keyword_collection_length1 = 0;
		gint _keyword_collection_size_ = 0;
		gint keyword_it = 0;
		keyword_collection = _tmp0_;
		keyword_collection_length1 = _tmp0__length1;
		for (keyword_it = 0; keyword_it < keyword_collection_length1; keyword_it = keyword_it + 1) {
			gchar* _tmp1_;
			gchar* keyword = NULL;
			_tmp1_ = g_strdup (keyword_collection[keyword_it]);
			keyword = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				SkkRomKanaConverter* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				_tmp3_ = state->rom_kana_converter;
				_tmp4_ = skk_rom_kana_converter_get_output (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = keyword;
				_tmp9_ = strlen (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp7_ > _tmp10_) {
					SkkRomKanaConverter* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp11_ = state->rom_kana_converter;
					_tmp12_ = skk_rom_kana_converter_get_output (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = keyword;
					_tmp2_ = g_str_has_suffix (_tmp13_, _tmp14_);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					const gchar* _tmp15_;
					gchar* _tmp16_;
					SkkRomKanaConverter* _tmp17_;
					SkkRomKanaConverter* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp15_ = keyword;
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (state->auto_start_henkan_keyword);
					state->auto_start_henkan_keyword = _tmp16_;
					_tmp17_ = state->rom_kana_converter;
					_tmp18_ = state->rom_kana_converter;
					_tmp19_ = skk_rom_kana_converter_get_output (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = keyword;
					_tmp22_ = strlen (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = string_slice (_tmp20_, (glong) 0, (glong) (-_tmp23_));
					_tmp25_ = _tmp24_;
					skk_rom_kana_converter_set_output (_tmp17_, _tmp25_);
					_g_free0 (_tmp25_);
					state->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
					result = TRUE;
					_g_free0 (keyword);
					return result;
				}
				_g_free0 (keyword);
			}
		}
	}
	result = FALSE;
	return result;
}

SkkStartStateHandler*
skk_start_state_handler_construct (GType object_type)
{
	SkkStartStateHandler * self = NULL;
	self = (SkkStartStateHandler*) skk_state_handler_construct (object_type);
	return self;
}

SkkStartStateHandler*
skk_start_state_handler_new (void)
{
	return skk_start_state_handler_construct (SKK_TYPE_START_STATE_HANDLER);
}

static void
skk_start_state_handler_class_init (SkkStartStateHandlerClass * klass,
                                    gpointer klass_data)
{
	skk_start_state_handler_parent_class = g_type_class_peek_parent (klass);
	((SkkStateHandlerClass *) klass)->process_key_event = (gboolean (*) (SkkStateHandler*, SkkState*, SkkKeyEvent**)) skk_start_state_handler_real_process_key_event;
	((SkkStateHandlerClass *) klass)->get_preedit = (gchar* (*) (SkkStateHandler*, SkkState*, guint*, guint*)) skk_start_state_handler_real_get_preedit;
}

static void
skk_start_state_handler_instance_init (SkkStartStateHandler * self,
                                       gpointer klass)
{
}

static GType
skk_start_state_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkStartStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_start_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkStartStateHandler), 0, (GInstanceInitFunc) skk_start_state_handler_instance_init, NULL };
	GType skk_start_state_handler_type_id;
	skk_start_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkStartStateHandler", &g_define_type_info, 0);
	return skk_start_state_handler_type_id;
}

GType
skk_start_state_handler_get_type (void)
{
	static volatile gsize skk_start_state_handler_type_id__once = 0;
	if (g_once_init_enter (&skk_start_state_handler_type_id__once)) {
		GType skk_start_state_handler_type_id;
		skk_start_state_handler_type_id = skk_start_state_handler_get_type_once ();
		g_once_init_leave (&skk_start_state_handler_type_id__once, skk_start_state_handler_type_id);
	}
	return skk_start_state_handler_type_id__once;
}

static gboolean
skk_select_state_handler_real_process_key_event (SkkStateHandler* base,
                                                 SkkState* state,
                                                 SkkKeyEvent** key)
{
	SkkSelectStateHandler * self;
	gchar* command = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gboolean result;
	self = (SkkSelectStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (*key != NULL, FALSE);
	_tmp0_ = skk_state_lookup_key (state, *key);
	command = _tmp0_;
	_tmp2_ = command;
	if (_tmp2_ == NULL) {
		gunichar _tmp3_;
		gunichar _tmp4_;
		_tmp3_ = skk_key_event_get_code (*key);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == ((gunichar) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (command);
		return result;
	}
	_tmp5_ = command;
	if (g_strcmp0 (_tmp5_, "previous-candidate") == 0) {
		SkkCandidateList* _tmp6_;
		_tmp6_ = state->candidates;
		if (!skk_candidate_list_previous (_tmp6_)) {
			SkkCandidateList* _tmp7_;
			_tmp7_ = state->candidates;
			skk_candidate_list_clear (_tmp7_);
			state->handler_type = SKK_TYPE_START_STATE_HANDLER;
		}
		result = TRUE;
		_g_free0 (command);
		return result;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = command;
		if (g_strcmp0 (_tmp8_, "purge-candidate") == 0) {
			SkkCandidate* candidate = NULL;
			SkkCandidateList* _tmp9_;
			SkkCandidate* _tmp10_;
			SkkCandidate* _tmp11_;
			_tmp9_ = state->candidates;
			_tmp10_ = skk_candidate_list_get (_tmp9_, -1);
			candidate = _tmp10_;
			_tmp11_ = candidate;
			skk_state_purge_candidate (state, _tmp11_);
			skk_state_reset (state);
			result = TRUE;
			_g_object_unref0 (candidate);
			_g_free0 (command);
			return result;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = command;
			if (g_strcmp0 (_tmp12_, "next-candidate") == 0) {
				SkkCandidateList* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				SkkCandidateList* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				_tmp13_ = state->candidates;
				_tmp14_ = skk_candidate_list_get_cursor_pos (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ < 0) {
					gchar* _tmp16_;
					gchar* _tmp17_;
					SkkCandidateList* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp16_ = skk_state_get_midasi (state);
					_tmp17_ = _tmp16_;
					skk_state_lookup (state, _tmp17_, state->okuri);
					_g_free0 (_tmp17_);
					_tmp18_ = state->candidates;
					_tmp19_ = skk_candidate_list_get_size (_tmp18_);
					_tmp20_ = _tmp19_;
					if (_tmp20_ > 0) {
						result = TRUE;
						_g_free0 (command);
						return result;
					}
				} else {
					SkkCandidateList* _tmp21_;
					_tmp21_ = state->candidates;
					if (skk_candidate_list_next (_tmp21_)) {
						result = TRUE;
						_g_free0 (command);
						return result;
					}
				}
				_tmp22_ = skk_state_get_yomi (state);
				_tmp23_ = _tmp22_;
				g_signal_emit (state, skk_state_signals[SKK_STATE_RECURSIVE_EDIT_START_SIGNAL], 0, _tmp23_);
				_g_free0 (_tmp23_);
				_tmp24_ = state->candidates;
				_tmp25_ = skk_candidate_list_get_size (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_ == 0) {
					SkkCandidateList* _tmp27_;
					_tmp27_ = state->candidates;
					skk_candidate_list_clear (_tmp27_);
					state->handler_type = SKK_TYPE_START_STATE_HANDLER;
				}
				result = TRUE;
				_g_free0 (command);
				return result;
			} else {
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				const gchar* _tmp30_;
				_tmp30_ = command;
				if (g_strcmp0 (_tmp30_, "abort") == 0) {
					_tmp29_ = TRUE;
				} else {
					const gchar* _tmp31_;
					_tmp31_ = command;
					_tmp29_ = g_strcmp0 (_tmp31_, "abort-to-latin") == 0;
				}
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					const gchar* _tmp32_;
					_tmp32_ = command;
					_tmp28_ = g_strcmp0 (_tmp32_, "abort-to-latin-unhandled") == 0;
				}
				if (_tmp28_) {
					SkkCandidateList* _tmp33_;
					GString* _tmp34_;
					_tmp33_ = state->candidates;
					skk_candidate_list_clear (_tmp33_);
					skk_state_cancel_okuri (state);
					_tmp34_ = state->abbrev;
					if (_tmp34_->len > ((gssize) 0)) {
						state->handler_type = SKK_TYPE_ABBREV_STATE_HANDLER;
					} else {
						state->handler_type = SKK_TYPE_START_STATE_HANDLER;
					}
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					gchar* surrounding_after = NULL;
					gchar* _tmp35_;
					SkkUnicodeString* _tmp36_;
					SkkCandidateList* _tmp39_;
					GString* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp35_ = g_strdup ("");
					surrounding_after = _tmp35_;
					_tmp36_ = state->surrounding_text;
					if (_tmp36_ != NULL) {
						SkkUnicodeString* _tmp37_;
						gchar* _tmp38_;
						_tmp37_ = state->surrounding_text;
						_tmp38_ = skk_unicode_string_substring (_tmp37_, (glong) state->surrounding_end, (glong) -1);
						_g_free0 (surrounding_after);
						surrounding_after = _tmp38_;
					}
					_tmp39_ = state->candidates;
					skk_candidate_list_select (_tmp39_);
					_tmp40_ = state->output;
					_tmp41_ = surrounding_after;
					g_string_append (_tmp40_, _tmp41_);
					_tmp42_ = command;
					if (g_strcmp0 (_tmp42_, "special-midasi") == 0) {
						SkkCandidateList* _tmp43_;
						_tmp43_ = state->candidates;
						skk_candidate_list_clear (_tmp43_);
						state->handler_type = SKK_TYPE_START_STATE_HANDLER;
						result = FALSE;
						_g_free0 (surrounding_after);
						_g_free0 (command);
						return result;
					} else {
						gboolean _tmp44_ = FALSE;
						gboolean _tmp45_ = FALSE;
						gboolean _tmp46_ = FALSE;
						gboolean _tmp47_ = FALSE;
						SkkModifierType _tmp48_;
						SkkModifierType _tmp49_;
						skk_state_reset (state);
						_tmp48_ = skk_key_event_get_modifiers (*key);
						_tmp49_ = _tmp48_;
						if (_tmp49_ == 0) {
							gunichar _tmp50_;
							gunichar _tmp51_;
							_tmp50_ = skk_key_event_get_code (*key);
							_tmp51_ = _tmp50_;
							_tmp47_ = ((gunichar) 0x20) <= _tmp51_;
						} else {
							_tmp47_ = FALSE;
						}
						if (_tmp47_) {
							gunichar _tmp52_;
							gunichar _tmp53_;
							_tmp52_ = skk_key_event_get_code (*key);
							_tmp53_ = _tmp52_;
							_tmp46_ = _tmp53_ <= ((gunichar) 0x7E);
						} else {
							_tmp46_ = FALSE;
						}
						if (_tmp46_) {
							_tmp45_ = TRUE;
						} else {
							const gchar* _tmp54_;
							_tmp54_ = command;
							_tmp45_ = g_strcmp0 (_tmp54_, "delete") == 0;
						}
						if (_tmp45_) {
							_tmp44_ = TRUE;
						} else {
							gboolean _tmp55_ = FALSE;
							if (!state->egg_like_newline) {
								const gchar* _tmp56_;
								_tmp56_ = command;
								_tmp55_ = g_strcmp0 (_tmp56_, "commit-unhandled") == 0;
							} else {
								_tmp55_ = FALSE;
							}
							_tmp44_ = _tmp55_;
						}
						if (_tmp44_) {
							result = FALSE;
							_g_free0 (surrounding_after);
							_g_free0 (command);
							return result;
						} else {
							result = TRUE;
							_g_free0 (surrounding_after);
							_g_free0 (command);
							return result;
						}
					}
					_g_free0 (surrounding_after);
				}
			}
		}
	}
}

static gchar*
skk_select_state_handler_real_get_preedit (SkkStateHandler* base,
                                           SkkState* state,
                                           guint* underline_offset,
                                           guint* underline_nchars)
{
	SkkSelectStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	GString* builder = NULL;
	GString* _tmp0_;
	SkkCandidateList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp14_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	self = (SkkSelectStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_string_new ("▼");
	builder = _tmp0_;
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp1_ = state->candidates;
	_tmp2_ = skk_candidate_list_get_cursor_pos (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= 0) {
		SkkCandidate* c = NULL;
		SkkCandidateList* _tmp4_;
		SkkCandidate* _tmp5_;
		GString* _tmp6_;
		SkkCandidate* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = state->candidates;
		_tmp5_ = skk_candidate_list_get (_tmp4_, -1);
		c = _tmp5_;
		_tmp6_ = builder;
		_tmp7_ = c;
		_tmp8_ = skk_candidate_get_output (_tmp7_);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp6_, _tmp9_);
		_g_object_unref0 (c);
	} else {
		GString* _tmp10_;
		SkkRomKanaConverter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = builder;
		_tmp11_ = state->rom_kana_converter;
		_tmp12_ = skk_rom_kana_converter_get_output (_tmp11_);
		_tmp13_ = _tmp12_;
		g_string_append (_tmp10_, _tmp13_);
	}
	_tmp14_ = state->auto_start_henkan_keyword;
	if (_tmp14_ != NULL) {
		GString* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = builder;
		_tmp16_ = state->auto_start_henkan_keyword;
		g_string_append (_tmp15_, _tmp16_);
	} else {
		if (state->okuri) {
			GString* _tmp17_;
			SkkRomKanaConverter* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = builder;
			_tmp18_ = state->okuri_rom_kana_converter;
			_tmp19_ = skk_rom_kana_converter_get_output (_tmp18_);
			_tmp20_ = _tmp19_;
			g_string_append (_tmp17_, _tmp20_);
		} else {
			SkkUnicodeString* _tmp21_;
			_tmp21_ = state->surrounding_text;
			if (_tmp21_ != NULL) {
				GString* _tmp22_;
				const gchar* _tmp23_;
				GString* _tmp24_;
				SkkUnicodeString* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_vala_underline_offset = (guint) 1;
				_tmp22_ = builder;
				_tmp23_ = _tmp22_->str;
				_vala_underline_nchars = (guint) (g_utf8_strlen (_tmp23_, (gssize) -1) - 1);
				_tmp24_ = builder;
				_tmp25_ = state->surrounding_text;
				_tmp26_ = skk_unicode_string_substring (_tmp25_, (glong) state->surrounding_end, (glong) -1);
				_tmp27_ = _tmp26_;
				g_string_append (_tmp24_, _tmp27_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp28_ = builder;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (builder);
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}

SkkSelectStateHandler*
skk_select_state_handler_construct (GType object_type)
{
	SkkSelectStateHandler * self = NULL;
	self = (SkkSelectStateHandler*) skk_state_handler_construct (object_type);
	return self;
}

SkkSelectStateHandler*
skk_select_state_handler_new (void)
{
	return skk_select_state_handler_construct (SKK_TYPE_SELECT_STATE_HANDLER);
}

static void
skk_select_state_handler_class_init (SkkSelectStateHandlerClass * klass,
                                     gpointer klass_data)
{
	skk_select_state_handler_parent_class = g_type_class_peek_parent (klass);
	((SkkStateHandlerClass *) klass)->process_key_event = (gboolean (*) (SkkStateHandler*, SkkState*, SkkKeyEvent**)) skk_select_state_handler_real_process_key_event;
	((SkkStateHandlerClass *) klass)->get_preedit = (gchar* (*) (SkkStateHandler*, SkkState*, guint*, guint*)) skk_select_state_handler_real_get_preedit;
}

static void
skk_select_state_handler_instance_init (SkkSelectStateHandler * self,
                                        gpointer klass)
{
}

static GType
skk_select_state_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkSelectStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_select_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkSelectStateHandler), 0, (GInstanceInitFunc) skk_select_state_handler_instance_init, NULL };
	GType skk_select_state_handler_type_id;
	skk_select_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkSelectStateHandler", &g_define_type_info, 0);
	return skk_select_state_handler_type_id;
}

GType
skk_select_state_handler_get_type (void)
{
	static volatile gsize skk_select_state_handler_type_id__once = 0;
	if (g_once_init_enter (&skk_select_state_handler_type_id__once)) {
		GType skk_select_state_handler_type_id;
		skk_select_state_handler_type_id = skk_select_state_handler_get_type_once ();
		g_once_init_leave (&skk_select_state_handler_type_id__once, skk_select_state_handler_type_id);
	}
	return skk_select_state_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

