/* key-event-filter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from key-event-filter.vala, do not modify */

/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <glib.h>
#include <glib-object.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SKK_KEY_EVENT_FILTER_0_PROPERTY,
	SKK_KEY_EVENT_FILTER_NUM_PROPERTIES
};
static GParamSpec* skk_key_event_filter_properties[SKK_KEY_EVENT_FILTER_NUM_PROPERTIES];
enum  {
	SKK_KEY_EVENT_FILTER_FORWARDED_SIGNAL,
	SKK_KEY_EVENT_FILTER_NUM_SIGNALS
};
static guint skk_key_event_filter_signals[SKK_KEY_EVENT_FILTER_NUM_SIGNALS] = {0};

#define SKK_TYPE_SIMPLE_KEY_EVENT_FILTER (skk_simple_key_event_filter_get_type ())
#define SKK_SIMPLE_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_SIMPLE_KEY_EVENT_FILTER, SkkSimpleKeyEventFilter))
#define SKK_SIMPLE_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_SIMPLE_KEY_EVENT_FILTER, SkkSimpleKeyEventFilterClass))
#define SKK_IS_SIMPLE_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_SIMPLE_KEY_EVENT_FILTER))
#define SKK_IS_SIMPLE_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_SIMPLE_KEY_EVENT_FILTER))
#define SKK_SIMPLE_KEY_EVENT_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_SIMPLE_KEY_EVENT_FILTER, SkkSimpleKeyEventFilterClass))

typedef struct _SkkSimpleKeyEventFilter SkkSimpleKeyEventFilter;
typedef struct _SkkSimpleKeyEventFilterClass SkkSimpleKeyEventFilterClass;
typedef struct _SkkSimpleKeyEventFilterPrivate SkkSimpleKeyEventFilterPrivate;
enum  {
	SKK_SIMPLE_KEY_EVENT_FILTER_0_PROPERTY,
	SKK_SIMPLE_KEY_EVENT_FILTER_NUM_PROPERTIES
};
static GParamSpec* skk_simple_key_event_filter_properties[SKK_SIMPLE_KEY_EVENT_FILTER_NUM_PROPERTIES];

struct _SkkSimpleKeyEventFilter {
	SkkKeyEventFilter parent_instance;
	SkkSimpleKeyEventFilterPrivate * priv;
};

struct _SkkSimpleKeyEventFilterClass {
	SkkKeyEventFilterClass parent_class;
};

static gpointer skk_key_event_filter_parent_class = NULL;
static gpointer skk_simple_key_event_filter_parent_class = NULL;

static SkkKeyEvent* skk_key_event_filter_real_filter_key_event (SkkKeyEventFilter* self,
                                                         SkkKeyEvent* key);
static void skk_key_event_filter_real_reset (SkkKeyEventFilter* self);
static GType skk_key_event_filter_get_type_once (void);
VALA_EXTERN GType skk_simple_key_event_filter_get_type (void) G_GNUC_CONST ;
static SkkKeyEvent* skk_simple_key_event_filter_real_filter_key_event (SkkKeyEventFilter* base,
                                                                SkkKeyEvent* key);
VALA_EXTERN SkkSimpleKeyEventFilter* skk_simple_key_event_filter_new (void);
VALA_EXTERN SkkSimpleKeyEventFilter* skk_simple_key_event_filter_construct (GType object_type);
static GType skk_simple_key_event_filter_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
         * Convert a key event to another.
         *
         * @param key a key event
         *
         * @return a KeyEvent or `null` if the result cannot be
         * fetched immediately
         */
static SkkKeyEvent*
skk_key_event_filter_real_filter_key_event (SkkKeyEventFilter* self,
                                            SkkKeyEvent* key)
{
	g_critical ("Type `%s' does not implement abstract method `skk_key_event_filter_filter_key_event'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

SkkKeyEvent*
skk_key_event_filter_filter_key_event (SkkKeyEventFilter* self,
                                       SkkKeyEvent* key)
{
	SkkKeyEventFilterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = SKK_KEY_EVENT_FILTER_GET_CLASS (self);
	if (_klass_->filter_key_event) {
		return _klass_->filter_key_event (self, key);
	}
	return NULL;
}

/**
         * Reset the filter.
         */
static void
skk_key_event_filter_real_reset (SkkKeyEventFilter* self)
{
}

void
skk_key_event_filter_reset (SkkKeyEventFilter* self)
{
	SkkKeyEventFilterClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SKK_KEY_EVENT_FILTER_GET_CLASS (self);
	if (_klass_->reset) {
		_klass_->reset (self);
	}
}

SkkKeyEventFilter*
skk_key_event_filter_construct (GType object_type)
{
	SkkKeyEventFilter * self = NULL;
	self = (SkkKeyEventFilter*) g_object_new (object_type, NULL);
	return self;
}

static void
skk_key_event_filter_class_init (SkkKeyEventFilterClass * klass,
                                 gpointer klass_data)
{
	skk_key_event_filter_parent_class = g_type_class_peek_parent (klass);
	((SkkKeyEventFilterClass *) klass)->filter_key_event = (SkkKeyEvent* (*) (SkkKeyEventFilter*, SkkKeyEvent*)) skk_key_event_filter_real_filter_key_event;
	((SkkKeyEventFilterClass *) klass)->reset = (void (*) (SkkKeyEventFilter*)) skk_key_event_filter_real_reset;
	/**
	         * Signal emitted when a new key event is generated in the filter.
	         *
	         * @param key a key event
	         */
	skk_key_event_filter_signals[SKK_KEY_EVENT_FILTER_FORWARDED_SIGNAL] = g_signal_new ("forwarded", SKK_TYPE_KEY_EVENT_FILTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SKK_TYPE_KEY_EVENT);
}

static void
skk_key_event_filter_instance_init (SkkKeyEventFilter * self,
                                    gpointer klass)
{
}

/**
     * Base class of a key event filter.
     */
static GType
skk_key_event_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkKeyEventFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_key_event_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeyEventFilter), 0, (GInstanceInitFunc) skk_key_event_filter_instance_init, NULL };
	GType skk_key_event_filter_type_id;
	skk_key_event_filter_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeyEventFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return skk_key_event_filter_type_id;
}

GType
skk_key_event_filter_get_type (void)
{
	static volatile gsize skk_key_event_filter_type_id__once = 0;
	if (g_once_init_enter (&skk_key_event_filter_type_id__once)) {
		GType skk_key_event_filter_type_id;
		skk_key_event_filter_type_id = skk_key_event_filter_get_type_once ();
		g_once_init_leave (&skk_key_event_filter_type_id__once, skk_key_event_filter_type_id);
	}
	return skk_key_event_filter_type_id__once;
}

/**
         * {@inheritDoc}
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static SkkKeyEvent*
skk_simple_key_event_filter_real_filter_key_event (SkkKeyEventFilter* base,
                                                   SkkKeyEvent* key)
{
	SkkSimpleKeyEventFilter * self;
	SkkModifierType _tmp0_;
	SkkModifierType _tmp1_;
	SkkModifierType _tmp2_;
	SkkModifierType _tmp3_;
	SkkKeyEvent* _tmp4_;
	SkkKeyEvent* result;
	self = (SkkSimpleKeyEventFilter*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = skk_key_event_get_modifiers (key);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ & SKK_MODIFIER_TYPE_RELEASE_MASK) != 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = skk_key_event_get_modifiers (key);
	_tmp3_ = _tmp2_;
	skk_key_event_set_modifiers (key, _tmp3_ & (~SKK_MODIFIER_TYPE_SHIFT_MASK));
	_tmp4_ = _g_object_ref0 (key);
	result = _tmp4_;
	return result;
}

SkkSimpleKeyEventFilter*
skk_simple_key_event_filter_construct (GType object_type)
{
	SkkSimpleKeyEventFilter * self = NULL;
	self = (SkkSimpleKeyEventFilter*) skk_key_event_filter_construct (object_type);
	return self;
}

SkkSimpleKeyEventFilter*
skk_simple_key_event_filter_new (void)
{
	return skk_simple_key_event_filter_construct (SKK_TYPE_SIMPLE_KEY_EVENT_FILTER);
}

static void
skk_simple_key_event_filter_class_init (SkkSimpleKeyEventFilterClass * klass,
                                        gpointer klass_data)
{
	skk_simple_key_event_filter_parent_class = g_type_class_peek_parent (klass);
	((SkkKeyEventFilterClass *) klass)->filter_key_event = (SkkKeyEvent* (*) (SkkKeyEventFilter*, SkkKeyEvent*)) skk_simple_key_event_filter_real_filter_key_event;
}

static void
skk_simple_key_event_filter_instance_init (SkkSimpleKeyEventFilter * self,
                                           gpointer klass)
{
}

/**
     * Simple implementation of a key event filter.
     *
     * This class is rarely used in programs but specified as "filter"
     * property in rule metadata.
     *
     * @see Rule
     */
static GType
skk_simple_key_event_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkSimpleKeyEventFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_simple_key_event_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkSimpleKeyEventFilter), 0, (GInstanceInitFunc) skk_simple_key_event_filter_instance_init, NULL };
	GType skk_simple_key_event_filter_type_id;
	skk_simple_key_event_filter_type_id = g_type_register_static (SKK_TYPE_KEY_EVENT_FILTER, "SkkSimpleKeyEventFilter", &g_define_type_info, 0);
	return skk_simple_key_event_filter_type_id;
}

GType
skk_simple_key_event_filter_get_type (void)
{
	static volatile gsize skk_simple_key_event_filter_type_id__once = 0;
	if (g_once_init_enter (&skk_simple_key_event_filter_type_id__once)) {
		GType skk_simple_key_event_filter_type_id;
		skk_simple_key_event_filter_type_id = skk_simple_key_event_filter_get_type_once ();
		g_once_init_leave (&skk_simple_key_event_filter_type_id__once, skk_simple_key_event_filter_type_id);
	}
	return skk_simple_key_event_filter_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

