/* file-dict.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from file-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_FILE_DICT_0_PROPERTY,
	SKK_FILE_DICT_READ_ONLY_PROPERTY,
	SKK_FILE_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_file_dict_properties[SKK_FILE_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define SKK_TYPE_SKK_DICT_ERROR (skk_skk_dict_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SkkFileDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
	glong okuri_ari_offset;
	glong okuri_nasi_offset;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gint SkkFileDict_private_offset;
static gpointer skk_file_dict_parent_class = NULL;

VALA_EXTERN GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_encoding_converter_get_type (void) G_GNUC_CONST ;
static gchar* skk_file_dict_read_line (SkkFileDict* self,
                                glong* offset);
VALA_EXTERN gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self);
VALA_EXTERN void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
static gchar* skk_file_dict_read_previous_line (SkkFileDict* self,
                                         glong* pos,
                                         const gchar* line);
static gchar* skk_file_dict_read_next_line (SkkFileDict* self,
                                     glong* pos,
                                     const gchar* line);
static gboolean skk_file_dict_read_until (SkkFileDict* self,
                                   glong* offset,
                                   const gchar* line);
VALA_EXTERN GQuark skk_skk_dict_error_quark (void);
VALA_EXTERN GType skk_skk_dict_error_get_type (void) G_GNUC_CONST ;
static void skk_file_dict_load (SkkFileDict* self,
                         GError** error);
VALA_EXTERN void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self,
                                   GError** error);
VALA_EXTERN gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding,
                                                                     GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type,
                                                                           const gchar* coding,
                                                                           GError** error);
static void skk_file_dict_real_reload (SkkDict* base,
                                GError** error);
static gboolean skk_file_dict_search_pos (SkkFileDict* self,
                                   const gchar* midasi,
                                   glong start_offset,
                                   glong end_offset,
                                   GCompareFunc cmp,
                                   glong* pos,
                                   gchar** line,
                                   gint direction);
static SkkCandidate** skk_file_dict_real_lookup (SkkDict* base,
                                          const gchar* midasi,
                                          gboolean okuri,
                                          gint* result_length1);
VALA_EXTERN gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
VALA_EXTERN gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
static gint skk_file_dict_strcmp_prefix (const gchar* a,
                                  const gchar* b);
static gchar** skk_file_dict_real_complete (SkkDict* base,
                                     const gchar* midasi,
                                     gint* result_length1);
static gint _skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a,
                                                 gconstpointer b);
VALA_EXTERN SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
VALA_EXTERN SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type,
                                                       GFile* file);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
static void skk_file_dict_finalize (GObject * obj);
static GType skk_file_dict_get_type_once (void);
static void _vala_skk_file_dict_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
skk_file_dict_get_instance_private (SkkFileDict* self)
{
	return G_STRUCT_MEMBER_P (self, SkkFileDict_private_offset);
}

static gchar*
skk_file_dict_read_line (SkkFileDict* self,
                         glong* offset)
{
	SkkMemoryMappedFile* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gchar* p = NULL;
	SkkMemoryMappedFile* _tmp3_;
	void* _tmp4_;
	void* _tmp5_;
	GString* builder = NULL;
	GString* _tmp12_;
	glong _offset = 0L;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (((gsize) (*offset)) < _tmp2_, NULL);
	_tmp3_ = self->priv->mmap;
	_tmp4_ = skk_memory_mapped_file_get_memory (_tmp3_);
	_tmp5_ = _tmp4_;
	p = ((gchar*) _tmp5_) + (*offset);
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gchar* _tmp9_;
			if (!_tmp6_) {
				glong _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = *offset;
				*offset = _tmp7_ - 1;
				_tmp8_ = p;
				p = _tmp8_ - 1;
			}
			_tmp6_ = FALSE;
			if (!((*offset) > ((glong) 0))) {
				break;
			}
			_tmp9_ = p;
			if ((*_tmp9_) == '\n') {
				break;
			}
		}
	}
	if ((*offset) > ((glong) 0)) {
		glong _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = *offset;
		*offset = _tmp10_ + 1;
		_tmp11_ = p;
		p = _tmp11_ + 1;
	}
	_tmp12_ = g_string_new ("");
	builder = _tmp12_;
	_offset = *offset;
	{
		gboolean _tmp13_ = FALSE;
		_tmp13_ = TRUE;
		while (TRUE) {
			SkkMemoryMappedFile* _tmp16_;
			gsize _tmp17_;
			gsize _tmp18_;
			gchar* _tmp19_;
			GString* _tmp20_;
			gchar* _tmp21_;
			if (!_tmp13_) {
				glong _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = _offset;
				_offset = _tmp14_ + 1;
				_tmp15_ = p;
				p = _tmp15_ + 1;
			}
			_tmp13_ = FALSE;
			_tmp16_ = self->priv->mmap;
			_tmp17_ = skk_memory_mapped_file_get_length (_tmp16_);
			_tmp18_ = _tmp17_;
			if (!(((gsize) _offset) < _tmp18_)) {
				break;
			}
			_tmp19_ = p;
			if ((*_tmp19_) == '\n') {
				break;
			}
			_tmp20_ = builder;
			_tmp21_ = p;
			g_string_append_c (_tmp20_, *_tmp21_);
		}
	}
	_tmp22_ = builder;
	_tmp23_ = _tmp22_->str;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	_g_string_free0 (builder);
	return result;
}

static gchar*
skk_file_dict_read_previous_line (SkkFileDict* self,
                                  glong* pos,
                                  const gchar* line)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	if ((*pos) < ((glong) 2)) {
		result = NULL;
		return result;
	}
	*pos = (*pos) - 2;
	_tmp0_ = skk_file_dict_read_line (self, pos);
	result = _tmp0_;
	return result;
}

static gchar*
skk_file_dict_read_next_line (SkkFileDict* self,
                              glong* pos,
                              const gchar* line)
{
	gint _tmp0_;
	gint _tmp1_;
	SkkMemoryMappedFile* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = strlen (line);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->mmap;
	_tmp3_ = skk_memory_mapped_file_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	if (((gsize) (((*pos) + _tmp1_) + 1)) >= _tmp4_) {
		result = NULL;
		return result;
	}
	_tmp5_ = strlen (line);
	_tmp6_ = _tmp5_;
	*pos = (*pos) + (_tmp6_ + 1);
	_tmp7_ = skk_file_dict_read_line (self, pos);
	result = _tmp7_;
	return result;
}

static gboolean
skk_file_dict_read_until (SkkFileDict* self,
                          glong* offset,
                          const gchar* line)
{
	SkkMemoryMappedFile* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (((gsize) (*offset)) < _tmp2_, FALSE);
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_;
		SkkMemoryMappedFile* _tmp5_;
		gsize _tmp6_;
		gsize _tmp7_;
		gchar* p = NULL;
		SkkMemoryMappedFile* _tmp8_;
		void* _tmp9_;
		void* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gchar* _tmp12_;
		glong _tmp18_;
		_tmp3_ = strlen (line);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->mmap;
		_tmp6_ = skk_memory_mapped_file_get_length (_tmp5_);
		_tmp7_ = _tmp6_;
		if (!(((gsize) ((*offset) + _tmp4_)) < _tmp7_)) {
			break;
		}
		_tmp8_ = self->priv->mmap;
		_tmp9_ = skk_memory_mapped_file_get_memory (_tmp8_);
		_tmp10_ = _tmp9_;
		p = ((gchar*) _tmp10_) + (*offset);
		_tmp12_ = p;
		if ((*_tmp12_) == '\n') {
			gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = p;
			_tmp14_ = strlen (line);
			_tmp15_ = _tmp14_;
			_tmp11_ = memcmp (_tmp13_ + 1, (void*) line, (gsize) _tmp15_) == 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gint _tmp16_;
			gint _tmp17_;
			_tmp16_ = strlen (line);
			_tmp17_ = _tmp16_;
			*offset = (*offset) + _tmp17_;
			result = TRUE;
			return result;
		}
		_tmp18_ = *offset;
		*offset = _tmp18_ + 1;
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
skk_file_dict_load (SkkFileDict* self,
                    GError** error)
{
	SkkMemoryMappedFile* _tmp0_;
	glong offset = 0L;
	gchar* line = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* coding = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp15_;
	gboolean _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mmap;
	skk_memory_mapped_file_remap (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	offset = (glong) 0;
	_tmp1_ = skk_file_dict_read_line (self, &offset);
	line = _tmp1_;
	_tmp2_ = line;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't read the first line");
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = line;
	_tmp5_ = skk_encoding_converter_extract_coding_system (_tmp4_);
	coding = _tmp5_;
	_tmp6_ = coding;
	if (_tmp6_ != NULL) {
		{
			SkkEncodingConverter* _converter = NULL;
			const gchar* _tmp7_;
			SkkEncodingConverter* _tmp8_;
			SkkEncodingConverter* _tmp9_;
			_tmp7_ = coding;
			_tmp8_ = skk_encoding_converter_new_from_coding_system (_tmp7_, &_inner_error0_);
			_converter = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp9_ = _converter;
			if (_tmp9_ != NULL) {
				SkkEncodingConverter* _tmp10_;
				SkkEncodingConverter* _tmp11_;
				_tmp10_ = _converter;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp11_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = coding;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("file-dict.vala:105: can't create converter from coding system %s: %s", _tmp12_, _tmp14_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (coding);
				_g_free0 (line);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	offset = (glong) 0;
	_tmp15_ = skk_file_dict_read_until (self, &offset, ";; okuri-ari entries.\n");
	if (!_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->okuri_ari_offset = offset;
	_tmp17_ = skk_file_dict_read_until (self, &offset, ";; okuri-nasi entries.\n");
	if (!_tmp17_) {
		GError* _tmp18_;
		_tmp18_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-nasi boundary");
		_inner_error0_ = _tmp18_;
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->okuri_nasi_offset = offset;
	_g_free0 (coding);
	_g_free0 (line);
}

/**
         * {@inheritDoc}
         */
static void
skk_file_dict_real_reload (SkkDict* base,
                           GError** error)
{
	SkkFileDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (SkkFileDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			skk_file_dict_load (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch0_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp5_ = g_file_info_get_etag (info);
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp6_;
		}
		goto __finally0;
		__catch0_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("file-dict.vala:140: error loading file dictionary %s %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
skk_file_dict_search_pos (SkkFileDict* self,
                          const gchar* midasi,
                          glong start_offset,
                          glong end_offset,
                          GCompareFunc cmp,
                          glong* pos,
                          gchar** line,
                          gint direction)
{
	glong _vala_pos = 0L;
	gchar* _vala_line = NULL;
	glong offset = 0L;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (midasi != NULL, FALSE);
	offset = start_offset + ((end_offset - start_offset) / 2);
	while (TRUE) {
		SkkMemoryMappedFile* _tmp0_;
		gsize _tmp1_;
		gsize _tmp2_;
		gchar* _line = NULL;
		gchar* _tmp3_;
		gint index = 0;
		const gchar* _tmp4_;
		gint r = 0;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gint _tmp9_;
		if (!(start_offset <= end_offset)) {
			break;
		}
		_tmp0_ = self->priv->mmap;
		_tmp1_ = skk_memory_mapped_file_get_length (_tmp0_);
		_tmp2_ = _tmp1_;
		_vala_assert (((gsize) offset) < _tmp2_, "offset < mmap.length");
		_tmp3_ = skk_file_dict_read_line (self, &offset);
		_line = _tmp3_;
		_tmp4_ = _line;
		index = string_index_of (_tmp4_, " ", 0);
		if (index < 1) {
			const gchar* _tmp5_;
			_tmp5_ = _line;
			g_warning ("file-dict.vala:160: corrupted dictionary entry: %s", _tmp5_);
			_g_free0 (_line);
			break;
		}
		_tmp6_ = _line;
		_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) index);
		_tmp8_ = _tmp7_;
		_tmp9_ = cmp (_tmp8_, midasi);
		_g_free0 (_tmp8_);
		r = _tmp9_;
		if (r == 0) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_vala_pos = offset;
			_tmp10_ = _line;
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (_vala_line);
			_vala_line = _tmp11_;
			result = TRUE;
			_g_free0 (_line);
			if (pos) {
				*pos = _vala_pos;
			}
			if (line) {
				*line = _vala_line;
			} else {
				_g_free0 (_vala_line);
			}
			return result;
		}
		if ((r * direction) > 0) {
			end_offset = offset - 2;
		} else {
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp12_ = _line;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			start_offset = (offset + _tmp14_) + 1;
		}
		offset = start_offset + ((end_offset - start_offset) / 2);
		_g_free0 (_line);
	}
	_vala_pos = (glong) -1;
	_g_free0 (_vala_line);
	_vala_line = NULL;
	result = FALSE;
	if (pos) {
		*pos = _vala_pos;
	}
	if (line) {
		*line = _vala_line;
	} else {
		_g_free0 (_vala_line);
	}
	return result;
}

/**
         * {@inheritDoc}
         */
static SkkCandidate**
skk_file_dict_real_lookup (SkkDict* base,
                           const gchar* midasi,
                           gboolean okuri,
                           gint* result_length1)
{
	SkkFileDict * self;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	gint _tmp16_ = 0;
	const gchar* _tmp17_;
	GCompareFunc _tmp18_;
	glong _tmp19_ = 0L;
	gchar* _tmp20_ = NULL;
	gboolean _tmp21_;
	SkkCandidate** _tmp43_;
	SkkCandidate** _tmp44_;
	gint _tmp44__length1;
	GError* _inner_error0_ = NULL;
	SkkCandidate** result;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	if (okuri) {
		start_offset = self->priv->okuri_ari_offset;
		end_offset = self->priv->okuri_nasi_offset;
	} else {
		SkkMemoryMappedFile* _tmp5_;
		gsize _tmp6_;
		gsize _tmp7_;
		start_offset = self->priv->okuri_nasi_offset;
		_tmp5_ = self->priv->mmap;
		_tmp6_ = skk_memory_mapped_file_get_length (_tmp5_);
		_tmp7_ = _tmp6_;
		end_offset = ((glong) _tmp7_) - 1;
	}
	{
		gchar* _tmp8_ = NULL;
		SkkEncodingConverter* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->priv->converter;
		_tmp10_ = skk_encoding_converter_encode (_tmp9_, midasi, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp11_;
		_g_free0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		SkkCandidate** _tmp14_;
		SkkCandidate** _tmp15_;
		gint _tmp15__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("file-dict.vala:202: can't encode %s: %s", midasi, _tmp13_);
		_tmp14_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp15__length1;
		}
		result = _tmp15_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (okuri) {
		_tmp16_ = -1;
	} else {
		_tmp16_ = 1;
	}
	_tmp17_ = _midasi;
	_tmp18_ = ((GCompareFunc) g_strcmp0);
	_tmp21_ = skk_file_dict_search_pos (self, _tmp17_, start_offset, end_offset, _tmp18_, &_tmp19_, &_tmp20_, _tmp16_);
	pos = _tmp19_;
	_g_free0 (line);
	line = _tmp20_;
	if (_tmp21_) {
		gint index = 0;
		const gchar* _tmp22_;
		gchar* _line = NULL;
		_tmp22_ = line;
		index = string_index_of (_tmp22_, " ", 0);
		if (index > 0) {
			const gchar* _tmp39_;
			gint _tmp40_ = 0;
			SkkCandidate** _tmp41_;
			SkkCandidate** _tmp42_;
			gint _tmp42__length1;
			{
				gchar* _tmp23_ = NULL;
				SkkEncodingConverter* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp24_ = self->priv->converter;
				_tmp25_ = line;
				_tmp26_ = line;
				_tmp27_ = strlen (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = string_slice (_tmp25_, (glong) index, (glong) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = skk_encoding_converter_decode (_tmp24_, _tmp30_, &_inner_error0_);
				_tmp32_ = _tmp31_;
				_g_free0 (_tmp30_);
				_tmp23_ = _tmp32_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp33_ = _tmp23_;
				_tmp23_ = NULL;
				_g_free0 (_line);
				_line = _tmp33_;
				_g_free0 (_tmp23_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp34_;
				GError* _tmp35_;
				const gchar* _tmp36_;
				SkkCandidate** _tmp37_;
				SkkCandidate** _tmp38_;
				gint _tmp38__length1;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp34_ = line;
				_tmp35_ = e;
				_tmp36_ = _tmp35_->message;
				g_warning ("file-dict.vala:221: can't decode line %s: %s", _tmp34_, _tmp36_);
				_tmp37_ = g_new0 (SkkCandidate*, 0 + 1);
				_tmp38_ = _tmp37_;
				_tmp38__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp38__length1;
				}
				result = _tmp38_;
				_g_error_free0 (e);
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp39_ = _line;
			_tmp41_ = skk_dict_split_candidates ((SkkDict*) self, midasi, okuri, _tmp39_, &_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp42__length1 = _tmp40_;
			if (result_length1) {
				*result_length1 = _tmp42__length1;
			}
			result = _tmp42_;
			_g_free0 (_line);
			_g_free0 (line);
			_g_free0 (_midasi);
			return result;
		}
		_g_free0 (_line);
	}
	_tmp43_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp44__length1;
	}
	result = _tmp44_;
	_g_free0 (line);
	_g_free0 (_midasi);
	return result;
}

static gint
skk_file_dict_strcmp_prefix (const gchar* a,
                             const gchar* b)
{
	GCompareFunc _tmp0_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (g_str_has_prefix (a, b)) {
		result = 0;
		return result;
	}
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

/**
         * {@inheritDoc}
         */
static gint
_skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a,
                                            gconstpointer b)
{
	gint result;
	result = skk_file_dict_strcmp_prefix ((const gchar*) a, (const gchar*) b);
	return result;
}

static gchar**
skk_file_dict_real_complete (SkkDict* base,
                             const gchar* midasi,
                             gint* result_length1)
{
	SkkFileDict * self;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	GeeArrayList* completion = NULL;
	GeeArrayList* _tmp5_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	SkkMemoryMappedFile* _tmp6_;
	gsize _tmp7_;
	gsize _tmp8_;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	const gchar* _tmp19_;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_;
	GeeArrayList* _tmp68_;
	gint _tmp69_ = 0;
	gpointer* _tmp70_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	completion = _tmp5_;
	start_offset = self->priv->okuri_nasi_offset;
	_tmp6_ = self->priv->mmap;
	_tmp7_ = skk_memory_mapped_file_get_length (_tmp6_);
	_tmp8_ = _tmp7_;
	end_offset = ((glong) _tmp8_) - 1;
	{
		gchar* _tmp9_ = NULL;
		SkkEncodingConverter* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->converter;
		_tmp11_ = skk_encoding_converter_encode (_tmp10_, midasi, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp12_;
		_g_free0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _tmp16_ = 0;
		gpointer* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("file-dict.vala:254: can't decode %s: %s", midasi, _tmp14_);
		_tmp15_ = completion;
		_tmp17_ = gee_collection_to_array ((GeeCollection*) _tmp15_, &_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _tmp16_;
		if (result_length1) {
			*result_length1 = _tmp18__length1;
		}
		result = _tmp18_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp19_ = _midasi;
	_tmp22_ = skk_file_dict_search_pos (self, _tmp19_, start_offset, end_offset, _skk_file_dict_strcmp_prefix_gcompare_func, &_tmp20_, &_tmp21_, 1);
	pos = _tmp20_;
	_g_free0 (line);
	line = _tmp21_;
	if (_tmp22_) {
		glong _pos = 0L;
		gchar* _line = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		_pos = pos;
		_tmp23_ = line;
		_tmp24_ = g_strdup (_tmp23_);
		_line = _tmp24_;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gint index = 0;
				const gchar* _tmp32_;
				if (!_tmp25_) {
					gboolean _tmp26_ = FALSE;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp27_ = line;
					_tmp28_ = skk_file_dict_read_previous_line (self, &pos, _tmp27_);
					_g_free0 (line);
					line = _tmp28_;
					_tmp29_ = line;
					if (_tmp29_ != NULL) {
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = line;
						_tmp31_ = _midasi;
						_tmp26_ = g_str_has_prefix (_tmp30_, _tmp31_);
					} else {
						_tmp26_ = FALSE;
					}
					if (!_tmp26_) {
						break;
					}
				}
				_tmp25_ = FALSE;
				_tmp32_ = line;
				index = string_index_of (_tmp32_, " ", 0);
				if (index < 0) {
					const gchar* _tmp33_;
					_tmp33_ = line;
					g_warning ("file-dict.vala:274: corrupted dictionary entry: %s", _tmp33_);
				} else {
					gchar* completed = NULL;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					_tmp34_ = line;
					_tmp35_ = string_slice (_tmp34_, (glong) 0, (glong) index);
					completed = _tmp35_;
					_tmp36_ = completed;
					_tmp37_ = _midasi;
					if (g_strcmp0 (_tmp36_, _tmp37_) != 0) {
						{
							gchar* decoded = NULL;
							SkkEncodingConverter* _tmp38_;
							const gchar* _tmp39_;
							gchar* _tmp40_;
							GeeArrayList* _tmp41_;
							const gchar* _tmp42_;
							_tmp38_ = self->priv->converter;
							_tmp39_ = completed;
							_tmp40_ = skk_encoding_converter_decode (_tmp38_, _tmp39_, &_inner_error0_);
							decoded = _tmp40_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
							_tmp41_ = completion;
							_tmp42_ = decoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp41_, 0, _tmp42_);
							_g_free0 (decoded);
						}
						goto __finally1;
						__catch1_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp43_;
							GError* _tmp44_;
							const gchar* _tmp45_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp43_ = line;
							_tmp44_ = e;
							_tmp45_ = _tmp44_->message;
							g_warning ("file-dict.vala:284: can't decode line %s: %s", _tmp43_, _tmp45_);
							_g_error_free0 (e);
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (completed);
							_g_free0 (_line);
							_g_free0 (line);
							_g_free0 (_midasi);
							_g_object_unref0 (completion);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_g_free0 (completed);
				}
			}
		}
		pos = _pos;
		_tmp46_ = _line;
		_tmp47_ = g_strdup (_tmp46_);
		_g_free0 (line);
		line = _tmp47_;
		while (TRUE) {
			gboolean _tmp48_ = FALSE;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			const gchar* _tmp51_;
			gint index = 0;
			const gchar* _tmp54_;
			_tmp49_ = line;
			_tmp50_ = skk_file_dict_read_next_line (self, &pos, _tmp49_);
			_g_free0 (line);
			line = _tmp50_;
			_tmp51_ = line;
			if (_tmp51_ != NULL) {
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				_tmp52_ = line;
				_tmp53_ = _midasi;
				_tmp48_ = g_str_has_prefix (_tmp52_, _tmp53_);
			} else {
				_tmp48_ = FALSE;
			}
			if (!_tmp48_) {
				break;
			}
			_tmp54_ = line;
			index = string_index_of (_tmp54_, " ", 0);
			if (index < 0) {
				const gchar* _tmp55_;
				_tmp55_ = line;
				g_warning ("file-dict.vala:299: corrupted dictionary entry: %s", _tmp55_);
			} else {
				gchar* completed = NULL;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				_tmp56_ = line;
				_tmp57_ = string_slice (_tmp56_, (glong) 0, (glong) index);
				completed = _tmp57_;
				_tmp58_ = completed;
				_tmp59_ = _midasi;
				if (g_strcmp0 (_tmp58_, _tmp59_) != 0) {
					{
						gchar* decoded = NULL;
						SkkEncodingConverter* _tmp60_;
						const gchar* _tmp61_;
						gchar* _tmp62_;
						GeeArrayList* _tmp63_;
						const gchar* _tmp64_;
						_tmp60_ = self->priv->converter;
						_tmp61_ = completed;
						_tmp62_ = skk_encoding_converter_decode (_tmp60_, _tmp61_, &_inner_error0_);
						decoded = _tmp62_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
						_tmp63_ = completion;
						_tmp64_ = decoded;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp63_, _tmp64_);
						_g_free0 (decoded);
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp65_;
						GError* _tmp66_;
						const gchar* _tmp67_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp65_ = line;
						_tmp66_ = e;
						_tmp67_ = _tmp66_->message;
						g_warning ("file-dict.vala:309: can't decode line %s: %s", _tmp65_, _tmp67_);
						_g_error_free0 (e);
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (completed);
						_g_free0 (_line);
						_g_free0 (line);
						_g_free0 (_midasi);
						_g_object_unref0 (completion);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_g_free0 (completed);
			}
		}
		_g_free0 (_line);
	}
	_tmp68_ = completion;
	_tmp70_ = gee_collection_to_array ((GeeCollection*) _tmp68_, &_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp71__length1 = _tmp69_;
	if (result_length1) {
		*result_length1 = _tmp71__length1;
	}
	result = _tmp71_;
	_g_free0 (line);
	_g_free0 (_midasi);
	_g_object_unref0 (completion);
	return result;
}

/**
         * Create a new FileDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkFileDict*
skk_file_dict_construct (GType object_type,
                         const gchar* path,
                         const gchar* encoding,
                         GError** error)
{
	SkkFileDict * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	SkkMemoryMappedFile* _tmp2_;
	gchar* _tmp3_;
	SkkEncodingConverter* _tmp4_ = NULL;
	SkkEncodingConverter* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkFileDict*) skk_dict_construct (object_type);
	_tmp0_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = skk_memory_mapped_file_new (_tmp1_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	_tmp5_ = skk_encoding_converter_new (encoding, &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp6_;
	skk_dict_reload ((SkkDict*) self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp4_);
	return self;
}

SkkFileDict*
skk_file_dict_new (const gchar* path,
                   const gchar* encoding,
                   GError** error)
{
	return skk_file_dict_construct (SKK_TYPE_FILE_DICT, path, encoding, error);
}

static gboolean
skk_file_dict_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkFileDict* self;
	self = (SkkFileDict*) base;
	result = TRUE;
	return result;
}

static void
skk_file_dict_class_init (SkkFileDictClass * klass,
                          gpointer klass_data)
{
	skk_file_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkFileDict_private_offset);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict*, GError**)) skk_file_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict*, const gchar*, gboolean, gint*)) skk_file_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict*, const gchar*, gint*)) skk_file_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = (gboolean (*) (SkkDict*)) skk_file_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_file_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_file_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_FILE_DICT_READ_ONLY_PROPERTY, skk_file_dict_properties[SKK_FILE_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_file_dict_instance_init (SkkFileDict * self,
                             gpointer klass)
{
	self->priv = skk_file_dict_get_instance_private (self);
}

static void
skk_file_dict_finalize (GObject * obj)
{
	SkkFileDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_FILE_DICT, SkkFileDict);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_file_dict_parent_class)->finalize (obj);
}

/**
     * Read-only file based implementation of Dict.
     */
static GType
skk_file_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkFileDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_file_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkFileDict), 0, (GInstanceInitFunc) skk_file_dict_instance_init, NULL };
	GType skk_file_dict_type_id;
	skk_file_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkFileDict", &g_define_type_info, 0);
	SkkFileDict_private_offset = g_type_add_instance_private (skk_file_dict_type_id, sizeof (SkkFileDictPrivate));
	return skk_file_dict_type_id;
}

GType
skk_file_dict_get_type (void)
{
	static volatile gsize skk_file_dict_type_id__once = 0;
	if (g_once_init_enter (&skk_file_dict_type_id__once)) {
		GType skk_file_dict_type_id;
		skk_file_dict_type_id = skk_file_dict_get_type_once ();
		g_once_init_leave (&skk_file_dict_type_id__once, skk_file_dict_type_id);
	}
	return skk_file_dict_type_id__once;
}

static void
_vala_skk_file_dict_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SkkFileDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_FILE_DICT, SkkFileDict);
	switch (property_id) {
		case SKK_FILE_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

