/* cdb-dict.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from cdb-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libskk/libskk.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_CDB_DICT_0_PROPERTY,
	SKK_CDB_DICT_READ_ONLY_PROPERTY,
	SKK_CDB_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_cdb_dict_properties[SKK_CDB_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SKK_TYPE_SKK_DICT_ERROR (skk_skk_dict_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SkkCdbDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gint SkkCdbDict_private_offset;
static gpointer skk_cdb_dict_parent_class = NULL;

VALA_EXTERN GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_encoding_converter_get_type (void) G_GNUC_CONST ;
static guint32 skk_cdb_dict_hash (gchar* chars,
                           gint chars_length1);
static void skk_cdb_dict_real_reload (SkkDict* base,
                               GError** error);
VALA_EXTERN GQuark skk_skk_dict_error_quark (void);
VALA_EXTERN GType skk_skk_dict_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self,
                                   GError** error);
static guint32 skk_cdb_dict_read_uint32 (guint8* p);
static SkkCandidate** skk_cdb_dict_real_lookup (SkkDict* base,
                                         const gchar* midasi,
                                         gboolean okuri,
                                         gint* result_length1);
VALA_EXTERN void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
VALA_EXTERN gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
VALA_EXTERN gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
static gchar** skk_cdb_dict_real_complete (SkkDict* base,
                                    const gchar* midasi,
                                    gint* result_length1);
VALA_EXTERN SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
VALA_EXTERN SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type,
                                                       GFile* file);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
VALA_EXTERN SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
static void skk_cdb_dict_finalize (GObject * obj);
static GType skk_cdb_dict_get_type_once (void);
static void _vala_skk_cdb_dict_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
skk_cdb_dict_get_instance_private (SkkCdbDict* self)
{
	return G_STRUCT_MEMBER_P (self, SkkCdbDict_private_offset);
}

static guint32
skk_cdb_dict_hash (gchar* chars,
                   gint chars_length1)
{
	guint32 h = 0U;
	guint32 result;
	h = (guint32) 5381;
	{
		gchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = chars;
		c_collection_length1 = chars_length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			gchar c = '\0';
			c = c_collection[c_it];
			{
				h = ((h << 5) + h) ^ ((guint8) c);
			}
		}
	}
	result = h;
	return result;
}

/**
         * {@inheritDoc}
         */
static void
skk_cdb_dict_real_reload (SkkDict* base,
                          GError** error)
{
	SkkCdbDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (SkkCdbDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			SkkMemoryMappedFile* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->mmap;
			skk_memory_mapped_file_remap (_tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch0_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp6_ = g_file_info_get_etag (info);
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp7_;
		}
		goto __finally0;
		__catch0_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = self->priv->file;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("cdb-dict.vala:47: error loading file dictionary %s %s", _tmp10_, _tmp12_);
			_g_free0 (_tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}

static guint32
skk_cdb_dict_read_uint32 (guint8* p)
{
	guint8 q[4] = {0};
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	guint32 result;
	memcpy (q, (guint8*) p, 4 * sizeof (guint8));
	_tmp0_ = q[3];
	_tmp1_ = q[2];
	_tmp2_ = q[1];
	_tmp3_ = q[0];
	result = (guint32) ((((_tmp0_ << 24) | (_tmp1_ << 16)) | (_tmp2_ << 8)) | _tmp3_);
	return result;
}

/**
         * {@inheritDoc}
         */
static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static SkkCandidate**
skk_cdb_dict_real_lookup (SkkDict* base,
                          const gchar* midasi,
                          gboolean okuri,
                          gint* result_length1)
{
	SkkCdbDict * self;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	gchar* _midasi = NULL;
	guint32 h = 0U;
	const gchar* _tmp13_;
	gint _tmp14_ = 0;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp16__length1;
	guint32 _tmp17_;
	guint8* p = NULL;
	SkkMemoryMappedFile* _tmp18_;
	void* _tmp19_;
	void* _tmp20_;
	guint32 hash_offset = 0U;
	guint8* _tmp21_;
	guint32 hash_length = 0U;
	guint8* _tmp22_;
	guint32 start = 0U;
	SkkMemoryMappedFile* _tmp23_;
	void* _tmp24_;
	void* _tmp25_;
	SkkCandidate** _tmp54_;
	SkkCandidate** _tmp55_;
	gint _tmp55__length1;
	GError* _inner_error0_ = NULL;
	SkkCandidate** result;
	self = (SkkCdbDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	{
		gchar* _tmp5_ = NULL;
		SkkEncodingConverter* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->converter;
		_tmp7_ = skk_encoding_converter_encode (_tmp6_, midasi, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp8_;
		_g_free0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		SkkCandidate** _tmp11_;
		SkkCandidate** _tmp12_;
		gint _tmp12__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("cdb-dict.vala:71: can't encode %s: %s", midasi, _tmp10_);
		_tmp11_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp13_ = _midasi;
	_tmp15_ = string_to_utf8 (_tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	_tmp17_ = skk_cdb_dict_hash (_tmp16_, (gint) _tmp14_);
	_tmp16_ = (g_free (_tmp16_), NULL);
	h = _tmp17_;
	_tmp18_ = self->priv->mmap;
	_tmp19_ = skk_memory_mapped_file_get_memory (_tmp18_);
	_tmp20_ = _tmp19_;
	p = ((guint8*) _tmp20_) + ((h % 256) * 8);
	_tmp21_ = p;
	hash_offset = skk_cdb_dict_read_uint32 (_tmp21_);
	_tmp22_ = p;
	hash_length = skk_cdb_dict_read_uint32 (_tmp22_ + 4);
	start = (h >> 8) % hash_length;
	_tmp23_ = self->priv->mmap;
	_tmp24_ = skk_memory_mapped_file_get_memory (_tmp23_);
	_tmp25_ = _tmp24_;
	p = ((guint8*) _tmp25_) + hash_offset;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				guint8* q = NULL;
				guint8* _tmp28_;
				guint32 _h = 0U;
				guint8* _tmp29_;
				guint32 record_offset = 0U;
				guint8* _tmp30_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				if (!(((guint32) i) < hash_length)) {
					break;
				}
				_tmp28_ = p;
				q = _tmp28_ + (8 * ((i + start) % hash_length));
				_tmp29_ = q;
				_h = skk_cdb_dict_read_uint32 (_tmp29_);
				_tmp30_ = q;
				record_offset = skk_cdb_dict_read_uint32 (_tmp30_ + 4);
				if (record_offset == ((guint32) 0)) {
					break;
				}
				if (_h == h) {
					guint8* r = NULL;
					SkkMemoryMappedFile* _tmp31_;
					void* _tmp32_;
					void* _tmp33_;
					guint32 key_length = 0U;
					guint8* _tmp34_;
					guint32 data_length = 0U;
					guint8* _tmp35_;
					guint8* _tmp36_;
					const gchar* _tmp37_;
					_tmp31_ = self->priv->mmap;
					_tmp32_ = skk_memory_mapped_file_get_memory (_tmp31_);
					_tmp33_ = _tmp32_;
					r = ((guint8*) _tmp33_) + record_offset;
					_tmp34_ = r;
					key_length = skk_cdb_dict_read_uint32 (_tmp34_);
					_tmp35_ = r;
					data_length = skk_cdb_dict_read_uint32 (_tmp35_ + 4);
					_tmp36_ = r;
					_tmp37_ = _midasi;
					if (memcmp (_tmp36_ + 8, _tmp37_, (gsize) key_length) == 0) {
						gchar* data = NULL;
						gchar* _tmp38_;
						gint data_length1;
						gint _data_size_;
						gchar* _tmp39_;
						gint _tmp39__length1;
						guint8* _tmp40_;
						gint _tmp41_;
						gchar* _data = NULL;
						const gchar* _tmp50_;
						gint _tmp51_ = 0;
						SkkCandidate** _tmp52_;
						SkkCandidate** _tmp53_;
						gint _tmp53__length1;
						_tmp38_ = g_new0 (gchar, data_length + 1);
						data = _tmp38_;
						data_length1 = data_length + 1;
						_data_size_ = data_length1;
						_tmp39_ = data;
						_tmp39__length1 = data_length1;
						_tmp40_ = r;
						memcpy (_tmp39_, (_tmp40_ + 8) + key_length, (gsize) data_length);
						_tmp41_ = data_length1;
						data_length1 = _tmp41_ - 1;
						{
							gchar* _tmp42_ = NULL;
							SkkEncodingConverter* _tmp43_;
							gchar* _tmp44_;
							gint _tmp44__length1;
							gchar* _tmp45_;
							gchar* _tmp46_;
							_tmp43_ = self->priv->converter;
							_tmp44_ = data;
							_tmp44__length1 = data_length1;
							_tmp45_ = skk_encoding_converter_decode (_tmp43_, (const gchar*) _tmp44_, &_inner_error0_);
							_tmp42_ = _tmp45_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
							_tmp46_ = _tmp42_;
							_tmp42_ = NULL;
							_g_free0 (_data);
							_data = _tmp46_;
							_g_free0 (_tmp42_);
						}
						goto __finally1;
						__catch1_g_error:
						{
							GError* e = NULL;
							gchar* _tmp47_;
							gint _tmp47__length1;
							GError* _tmp48_;
							const gchar* _tmp49_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp47_ = data;
							_tmp47__length1 = data_length1;
							_tmp48_ = e;
							_tmp49_ = _tmp48_->message;
							g_warning ("cdb-dict.vala:100: can't decode data %s: %s", (const gchar*) _tmp47_, _tmp49_);
							_g_error_free0 (e);
							_g_free0 (_data);
							data = (g_free (data), NULL);
							break;
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (_data);
							data = (g_free (data), NULL);
							_g_free0 (_midasi);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp50_ = _data;
						_tmp52_ = skk_dict_split_candidates ((SkkDict*) self, midasi, okuri, _tmp50_, &_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp53__length1 = _tmp51_;
						if (result_length1) {
							*result_length1 = _tmp53__length1;
						}
						result = _tmp53_;
						_g_free0 (_data);
						data = (g_free (data), NULL);
						_g_free0 (_midasi);
						return result;
					}
				}
			}
		}
	}
	_tmp54_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp55__length1;
	}
	result = _tmp55_;
	_g_free0 (_midasi);
	return result;
}

/**
         * {@inheritDoc}
         *
         * This always returns an empty array since CDB format does
         * not provide key enumeration.
         */
static gchar**
skk_cdb_dict_real_complete (SkkDict* base,
                            const gchar* midasi,
                            gint* result_length1)
{
	SkkCdbDict * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** result;
	self = (SkkCdbDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

/**
         * Create a new CdbDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkCdbDict*
skk_cdb_dict_construct (GType object_type,
                        const gchar* path,
                        const gchar* encoding,
                        GError** error)
{
	SkkCdbDict * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	SkkMemoryMappedFile* _tmp2_;
	gchar* _tmp3_;
	SkkEncodingConverter* _tmp4_ = NULL;
	SkkEncodingConverter* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkCdbDict*) skk_dict_construct (object_type);
	_tmp0_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = skk_memory_mapped_file_new (_tmp1_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	_tmp5_ = skk_encoding_converter_new (encoding, &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp6_;
	skk_dict_reload ((SkkDict*) self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp4_);
	return self;
}

SkkCdbDict*
skk_cdb_dict_new (const gchar* path,
                  const gchar* encoding,
                  GError** error)
{
	return skk_cdb_dict_construct (SKK_TYPE_CDB_DICT, path, encoding, error);
}

static gboolean
skk_cdb_dict_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkCdbDict* self;
	self = (SkkCdbDict*) base;
	result = TRUE;
	return result;
}

static void
skk_cdb_dict_class_init (SkkCdbDictClass * klass,
                         gpointer klass_data)
{
	skk_cdb_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkCdbDict_private_offset);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict*, GError**)) skk_cdb_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict*, const gchar*, gboolean, gint*)) skk_cdb_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict*, const gchar*, gint*)) skk_cdb_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = (gboolean (*) (SkkDict*)) skk_cdb_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_cdb_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_cdb_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CDB_DICT_READ_ONLY_PROPERTY, skk_cdb_dict_properties[SKK_CDB_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_cdb_dict_instance_init (SkkCdbDict * self,
                            gpointer klass)
{
	self->priv = skk_cdb_dict_get_instance_private (self);
}

static void
skk_cdb_dict_finalize (GObject * obj)
{
	SkkCdbDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_CDB_DICT, SkkCdbDict);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_cdb_dict_parent_class)->finalize (obj);
}

/**
     * CDB based implementation of Dict.
     */
static GType
skk_cdb_dict_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkCdbDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_cdb_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkCdbDict), 0, (GInstanceInitFunc) skk_cdb_dict_instance_init, NULL };
	GType skk_cdb_dict_type_id;
	skk_cdb_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkCdbDict", &g_define_type_info, 0);
	SkkCdbDict_private_offset = g_type_add_instance_private (skk_cdb_dict_type_id, sizeof (SkkCdbDictPrivate));
	return skk_cdb_dict_type_id;
}

GType
skk_cdb_dict_get_type (void)
{
	static volatile gsize skk_cdb_dict_type_id__once = 0;
	if (g_once_init_enter (&skk_cdb_dict_type_id__once)) {
		GType skk_cdb_dict_type_id;
		skk_cdb_dict_type_id = skk_cdb_dict_get_type_once ();
		g_once_init_leave (&skk_cdb_dict_type_id__once, skk_cdb_dict_type_id);
	}
	return skk_cdb_dict_type_id__once;
}

static void
_vala_skk_cdb_dict_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SkkCdbDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_CDB_DICT, SkkCdbDict);
	switch (property_id) {
		case SKK_CDB_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

