/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef OOX_TOKEN_TOKENS_HXX
#define OOX_TOKEN_TOKENS_HXX

#include <com/sun/star/xml/sax/FastToken.hpp>

namespace oox {
const sal_Int32 XML_1D = 0;
const sal_Int32 XML_1pic = 1;
const sal_Int32 XML_1picTitle = 2;
const sal_Int32 XML_2D = 3;
const sal_Int32 XML_2pic = 4;
const sal_Int32 XML_2picTitle = 5;
const sal_Int32 XML_35mm = 6;
const sal_Int32 XML_3Arrows = 7;
const sal_Int32 XML_3ArrowsGray = 8;
const sal_Int32 XML_3Flags = 9;
const sal_Int32 XML_3Signs = 10;
const sal_Int32 XML_3Symbols = 11;
const sal_Int32 XML_3Symbols2 = 12;
const sal_Int32 XML_3TrafficLights1 = 13;
const sal_Int32 XML_3TrafficLights2 = 14;
const sal_Int32 XML_3cd4 = 15;
const sal_Int32 XML_3cd8 = 16;
const sal_Int32 XML_3dDkShadow = 17;
const sal_Int32 XML_3dLight = 18;
const sal_Int32 XML_4Arrows = 19;
const sal_Int32 XML_4ArrowsGray = 20;
const sal_Int32 XML_4Rating = 21;
const sal_Int32 XML_4RedToBlack = 22;
const sal_Int32 XML_4TrafficLights = 23;
const sal_Int32 XML_4pic = 24;
const sal_Int32 XML_4picTitle = 25;
const sal_Int32 XML_5Arrows = 26;
const sal_Int32 XML_5ArrowsGray = 27;
const sal_Int32 XML_5Quarters = 28;
const sal_Int32 XML_5Rating = 29;
const sal_Int32 XML_5cd8 = 30;
const sal_Int32 XML_7cd8 = 31;
const sal_Int32 XML_A1 = 32;
const sal_Int32 XML_A3 = 33;
const sal_Int32 XML_A4 = 34;
const sal_Int32 XML_AbbreviatedCaseNumber = 35;
const sal_Int32 XML_Accel = 36;
const sal_Int32 XML_Accel2 = 37;
const sal_Int32 XML_AlbumTitle = 38;
const sal_Int32 XML_AlternateContent = 39;
const sal_Int32 XML_Always = 40;
const sal_Int32 XML_Anchor = 41;
const sal_Int32 XML_AppVersion = 42;
const sal_Int32 XML_Append = 43;
const sal_Int32 XML_Application = 44;
const sal_Int32 XML_Art = 45;
const sal_Int32 XML_ArticleInAPeriodical = 46;
const sal_Int32 XML_Artist = 47;
const sal_Int32 XML_Author = 48;
const sal_Int32 XML_AutoFill = 49;
const sal_Int32 XML_AutoFit = 50;
const sal_Int32 XML_AutoLine = 51;
const sal_Int32 XML_AutoPict = 52;
const sal_Int32 XML_AutoScale = 53;
const sal_Int32 XML_B4ISO = 54;
const sal_Int32 XML_B4JIS = 55;
const sal_Int32 XML_B5ISO = 56;
const sal_Int32 XML_B5JIS = 57;
const sal_Int32 XML_BackColor = 58;
const sal_Int32 XML_Bitmap = 59;
const sal_Int32 XML_Book = 60;
const sal_Int32 XML_BookAuthor = 61;
const sal_Int32 XML_BookSection = 62;
const sal_Int32 XML_BookTitle = 63;
const sal_Int32 XML_BorderColor = 64;
const sal_Int32 XML_BorderStyle = 65;
const sal_Int32 XML_Bottom = 66;
const sal_Int32 XML_BroadcastTitle = 67;
const sal_Int32 XML_Broadcaster = 68;
const sal_Int32 XML_Button = 69;
const sal_Int32 XML_CF = 70;
const sal_Int32 XML_CalcA1 = 71;
const sal_Int32 XML_CalcA1ExcelA1 = 72;
const sal_Int32 XML_Camera = 73;
const sal_Int32 XML_Cancel = 74;
const sal_Int32 XML_Caption = 75;
const sal_Int32 XML_Case = 76;
const sal_Int32 XML_CaseNumber = 77;
const sal_Int32 XML_Center = 78;
const sal_Int32 XML_ChapterNumber = 79;
const sal_Int32 XML_Characters = 80;
const sal_Int32 XML_CharactersWithSpaces = 81;
const sal_Int32 XML_Checkbox = 82;
const sal_Int32 XML_Checked = 83;
const sal_Int32 XML_Choice = 84;
const sal_Int32 XML_City = 85;
const sal_Int32 XML_ClientData = 86;
const sal_Int32 XML_ColHidden = 87;
const sal_Int32 XML_Colored = 88;
const sal_Int32 XML_Column = 89;
const sal_Int32 XML_Combo = 90;
const sal_Int32 XML_ComboEdit = 91;
const sal_Int32 XML_Comments = 92;
const sal_Int32 XML_Company = 93;
const sal_Int32 XML_Compiler = 94;
const sal_Int32 XML_Composer = 95;
const sal_Int32 XML_Conductor = 96;
const sal_Int32 XML_ConferenceName = 97;
const sal_Int32 XML_ConferenceProceedings = 98;
const sal_Int32 XML_ConnectionID = 99;
const sal_Int32 XML_Content = 100;
const sal_Int32 XML_ContentType = 101;
const sal_Int32 XML_Corporate = 102;
const sal_Int32 XML_Counsel = 103;
const sal_Int32 XML_CountryRegion = 104;
const sal_Int32 XML_Court = 105;
const sal_Int32 XML_DDE = 106;
const sal_Int32 XML_DMY = 107;
const sal_Int32 XML_DVASPECT_CONTENT = 108;
const sal_Int32 XML_DVASPECT_ICON = 109;
const sal_Int32 XML_DYM = 110;
const sal_Int32 XML_DataBinding = 111;
const sal_Int32 XML_DataBindingLoadMode = 112;
const sal_Int32 XML_DataBindingName = 113;
const sal_Int32 XML_Day = 114;
const sal_Int32 XML_DayAccessed = 115;
const sal_Int32 XML_Default = 116;
const sal_Int32 XML_DefaultSize = 117;
const sal_Int32 XML_Delay = 118;
const sal_Int32 XML_Department = 119;
const sal_Int32 XML_Dialog = 120;
const sal_Int32 XML_DigSig = 121;
const sal_Int32 XML_Director = 122;
const sal_Int32 XML_Disabled = 123;
const sal_Int32 XML_Dismiss = 124;
const sal_Int32 XML_DisplayStyle = 125;
const sal_Int32 XML_Distributed = 126;
const sal_Int32 XML_Distributor = 127;
const sal_Int32 XML_DocSecurity = 128;
const sal_Int32 XML_DocumentFromInternetSite = 129;
const sal_Int32 XML_DrawAspect = 130;
const sal_Int32 XML_Drop = 131;
const sal_Int32 XML_DropButtonStyle = 132;
const sal_Int32 XML_DropLines = 133;
const sal_Int32 XML_DropStyle = 134;
const sal_Int32 XML_Dx = 135;
const sal_Int32 XML_EMD = 136;
const sal_Int32 XML_ENTITIES = 137;
const sal_Int32 XML_ENTITY = 138;
const sal_Int32 XML_Edit = 139;
const sal_Int32 XML_Edition = 140;
const sal_Int32 XML_Editor = 141;
const sal_Int32 XML_ElectronicSource = 142;
const sal_Int32 XML_Embed = 143;
const sal_Int32 XML_EnhancedMetaFile = 144;
const sal_Int32 XML_ExcelA1 = 145;
const sal_Int32 XML_ExcelR1C1 = 146;
const sal_Int32 XML_Extend = 147;
const sal_Int32 XML_Extension = 148;
const sal_Int32 XML_External = 149;
const sal_Int32 XML_Fallback = 150;
const sal_Int32 XML_False = 151;
const sal_Int32 XML_FieldCodes = 152;
const sal_Int32 XML_FileBinding = 153;
const sal_Int32 XML_FileBindingName = 154;
const sal_Int32 XML_Film = 155;
const sal_Int32 XML_First = 156;
const sal_Int32 XML_FirstButton = 157;
const sal_Int32 XML_FmlaGroup = 158;
const sal_Int32 XML_FmlaLink = 159;
const sal_Int32 XML_FmlaMacro = 160;
const sal_Int32 XML_FmlaPict = 161;
const sal_Int32 XML_FmlaRange = 162;
const sal_Int32 XML_FmlaTxbx = 163;
const sal_Int32 XML_FontCharSet = 164;
const sal_Int32 XML_FontEffects = 165;
const sal_Int32 XML_FontHeight = 166;
const sal_Int32 XML_FontName = 167;
const sal_Int32 XML_FontPitchAndFamily = 168;
const sal_Int32 XML_FontWeight = 169;
const sal_Int32 XML_ForeColor = 170;
const sal_Int32 XML_Format = 171;
const sal_Int32 XML_Formula = 172;
const sal_Int32 XML_GBox = 173;
const sal_Int32 XML_Group = 174;
const sal_Int32 XML_GroupName = 175;
const sal_Int32 XML_Guid = 176;
const sal_Int32 XML_HLinks = 177;
const sal_Int32 XML_HTMLInset = 178;
const sal_Int32 XML_HTMLOutset = 179;
const sal_Int32 XML_HeadingPairs = 180;
const sal_Int32 XML_Help = 181;
const sal_Int32 XML_HiddenSlides = 182;
const sal_Int32 XML_Hiragana = 183;
const sal_Int32 XML_Horiz = 184;
const sal_Int32 XML_HyperlinkBase = 185;
const sal_Int32 XML_HyperlinksChanged = 186;
const sal_Int32 XML_ID = 187;
const sal_Int32 XML_IDREF = 188;
const sal_Int32 XML_IDREFS = 189;
const sal_Int32 XML_Icon = 190;
const sal_Int32 XML_Id = 191;
const sal_Int32 XML_Ignorable = 192;
const sal_Int32 XML_Inc = 193;
const sal_Int32 XML_Institution = 194;
const sal_Int32 XML_Internal = 195;
const sal_Int32 XML_InternetSite = 196;
const sal_Int32 XML_InternetSiteTitle = 197;
const sal_Int32 XML_Interview = 198;
const sal_Int32 XML_Interviewee = 199;
const sal_Int32 XML_Interviewer = 200;
const sal_Int32 XML_Inventor = 201;
const sal_Int32 XML_Issue = 202;
const sal_Int32 XML_JournalArticle = 203;
const sal_Int32 XML_JournalName = 204;
const sal_Int32 XML_JustLastX = 205;
const sal_Int32 XML_Justify = 206;
const sal_Int32 XML_LCID = 207;
const sal_Int32 XML_LCT = 208;
const sal_Int32 XML_Label = 209;
const sal_Int32 XML_LargeChange = 210;
const sal_Int32 XML_Last = 211;
const sal_Int32 XML_Left = 212;
const sal_Int32 XML_LineA = 213;
const sal_Int32 XML_Lines = 214;
const sal_Int32 XML_Link = 215;
const sal_Int32 XML_LinkType = 216;
const sal_Int32 XML_LinksUpToDate = 217;
const sal_Int32 XML_List = 218;
const sal_Int32 XML_ListItem = 219;
const sal_Int32 XML_ListRows = 220;
const sal_Int32 XML_ListStyle = 221;
const sal_Int32 XML_LockText = 222;
const sal_Int32 XML_Locked = 223;
const sal_Int32 XML_LockedField = 224;
const sal_Int32 XML_M1 = 225;
const sal_Int32 XML_M10 = 226;
const sal_Int32 XML_M11 = 227;
const sal_Int32 XML_M12 = 228;
const sal_Int32 XML_M2 = 229;
const sal_Int32 XML_M3 = 230;
const sal_Int32 XML_M4 = 231;
const sal_Int32 XML_M5 = 232;
const sal_Int32 XML_M6 = 233;
const sal_Int32 XML_M7 = 234;
const sal_Int32 XML_M8 = 235;
const sal_Int32 XML_M9 = 236;
const sal_Int32 XML_MDY = 237;
const sal_Int32 XML_MMClips = 238;
const sal_Int32 XML_MYD = 239;
const sal_Int32 XML_Manager = 240;
const sal_Int32 XML_Map = 241;
const sal_Int32 XML_MapInfo = 242;
const sal_Int32 XML_MapOCX = 243;
const sal_Int32 XML_MatchEntry = 244;
const sal_Int32 XML_Max = 245;
const sal_Int32 XML_MaxLength = 246;
const sal_Int32 XML_Medium = 247;
const sal_Int32 XML_Middle = 248;
const sal_Int32 XML_Min = 249;
const sal_Int32 XML_Misc = 250;
const sal_Int32 XML_Month = 251;
const sal_Int32 XML_MonthAccessed = 252;
const sal_Int32 XML_MouseIcon = 253;
const sal_Int32 XML_MousePointer = 254;
const sal_Int32 XML_MoveWithCells = 255;
const sal_Int32 XML_Movie = 256;
const sal_Int32 XML_Multi = 257;
const sal_Int32 XML_MultiLine = 258;
const sal_Int32 XML_MultiSel = 259;
const sal_Int32 XML_MultiSelect = 260;
const sal_Int32 XML_NA = 261;
const sal_Int32 XML_NCName = 262;
const sal_Int32 XML_NMTOKEN = 263;
const sal_Int32 XML_NMTOKENS = 264;
const sal_Int32 XML_NOTATION = 265;
const sal_Int32 XML_Name = 266;
const sal_Int32 XML_NameList = 267;
const sal_Int32 XML_Namespace = 268;
const sal_Int32 XML_NextEnabled = 269;
const sal_Int32 XML_NoThreeD = 270;
const sal_Int32 XML_NoThreeD2 = 271;
const sal_Int32 XML_Note = 272;
const sal_Int32 XML_Notes = 273;
const sal_Int32 XML_NumberVolumes = 274;
const sal_Int32 XML_OLEObject = 275;
const sal_Int32 XML_OLEUPDATE_ALWAYS = 276;
const sal_Int32 XML_OLEUPDATE_ONCALL = 277;
const sal_Int32 XML_ObjectID = 278;
const sal_Int32 XML_ObjectType = 279;
const sal_Int32 XML_OnCall = 280;
const sal_Int32 XML_Orientation = 281;
const sal_Int32 XML_Override = 282;
const sal_Int32 XML_Page = 283;
const sal_Int32 XML_Pages = 284;
const sal_Int32 XML_ParagraphAlign = 285;
const sal_Int32 XML_ParagraphFormat = 286;
const sal_Int32 XML_Paragraphs = 287;
const sal_Int32 XML_PartName = 288;
const sal_Int32 XML_PasswordChar = 289;
const sal_Int32 XML_Patent = 290;
const sal_Int32 XML_PatentNumber = 291;
const sal_Int32 XML_Performance = 292;
const sal_Int32 XML_Performer = 293;
const sal_Int32 XML_PeriodicalTitle = 294;
const sal_Int32 XML_Person = 295;
const sal_Int32 XML_Pict = 296;
const sal_Int32 XML_PictOld = 297;
const sal_Int32 XML_PictPrint = 298;
const sal_Int32 XML_PictScreen = 299;
const sal_Int32 XML_Picture = 300;
const sal_Int32 XML_PictureAlignment = 301;
const sal_Int32 XML_PicturePosition = 302;
const sal_Int32 XML_PictureTiling = 303;
const sal_Int32 XML_Position = 304;
const sal_Int32 XML_PresentationFormat = 305;
const sal_Int32 XML_PreserveFormat = 306;
const sal_Int32 XML_PreserveSortAFLayout = 307;
const sal_Int32 XML_PrevEnabled = 308;
const sal_Int32 XML_PrintObject = 309;
const sal_Int32 XML_ProducerName = 310;
const sal_Int32 XML_ProductionCompany = 311;
const sal_Int32 XML_ProgID = 312;
const sal_Int32 XML_Properties = 313;
const sal_Int32 XML_ProportionalThumb = 314;
const sal_Int32 XML_PublicationTitle = 315;
const sal_Int32 XML_Publisher = 316;
const sal_Int32 XML_Q1 = 317;
const sal_Int32 XML_Q2 = 318;
const sal_Int32 XML_Q3 = 319;
const sal_Int32 XML_Q4 = 320;
const sal_Int32 XML_QName = 321;
const sal_Int32 XML_R1C1 = 322;
const sal_Int32 XML_Radio = 323;
const sal_Int32 XML_RecalcAlways = 324;
const sal_Int32 XML_RecordingNumber = 325;
const sal_Int32 XML_Rect = 326;
const sal_Int32 XML_RectA = 327;
const sal_Int32 XML_RefOrder = 328;
const sal_Int32 XML_Relationship = 329;
const sal_Int32 XML_RelationshipReference = 330;
const sal_Int32 XML_Relationships = 331;
const sal_Int32 XML_RelationshipsGroupReference = 332;
const sal_Int32 XML_Report = 333;
const sal_Int32 XML_Reporter = 334;
const sal_Int32 XML_Requires = 335;
const sal_Int32 XML_Right = 336;
const sal_Int32 XML_RootElement = 337;
const sal_Int32 XML_Row = 338;
const sal_Int32 XML_RowHidden = 339;
const sal_Int32 XML_ScaleCrop = 340;
const sal_Int32 XML_Schema = 341;
const sal_Int32 XML_SchemaID = 342;
const sal_Int32 XML_SchemaRef = 343;
const sal_Int32 XML_ScriptExtended = 344;
const sal_Int32 XML_ScriptLanguage = 345;
const sal_Int32 XML_ScriptLocation = 346;
const sal_Int32 XML_ScriptText = 347;
const sal_Int32 XML_Scroll = 348;
const sal_Int32 XML_ScrollBars = 349;
const sal_Int32 XML_SecretEdit = 350;
const sal_Int32 XML_Sel = 351;
const sal_Int32 XML_SelType = 352;
const sal_Int32 XML_SelectedStyle = 353;
const sal_Int32 XML_SelectionNamespaces = 354;
const sal_Int32 XML_Shape = 355;
const sal_Int32 XML_ShapeID = 356;
const sal_Int32 XML_SharedDoc = 357;
const sal_Int32 XML_ShortTitle = 358;
const sal_Int32 XML_ShowDropButtonWhen = 359;
const sal_Int32 XML_ShowImportExportValidationErrors = 360;
const sal_Int32 XML_SignatureTime = 361;
const sal_Int32 XML_Simple = 362;
const sal_Int32 XML_Single = 363;
const sal_Int32 XML_Size = 364;
const sal_Int32 XML_SizeMode = 365;
const sal_Int32 XML_SizeWithCells = 366;
const sal_Int32 XML_Slides = 367;
const sal_Int32 XML_SmallChange = 368;
const sal_Int32 XML_SoundRecording = 369;
const sal_Int32 XML_Source = 370;
const sal_Int32 XML_SourceId = 371;
const sal_Int32 XML_SourceType = 372;
const sal_Int32 XML_Sources = 373;
const sal_Int32 XML_SpecialEffect = 374;
const sal_Int32 XML_Spin = 375;
const sal_Int32 XML_StandardNumber = 376;
const sal_Int32 XML_StateProvince = 377;
const sal_Int32 XML_Station = 378;
const sal_Int32 XML_StyleName = 379;
const sal_Int32 XML_Tag = 380;
const sal_Int32 XML_TakeFocusOnClick = 381;
const sal_Int32 XML_Target = 382;
const sal_Int32 XML_TargetMode = 383;
const sal_Int32 XML_Template = 384;
const sal_Int32 XML_TextHAlign = 385;
const sal_Int32 XML_TextVAlign = 386;
const sal_Int32 XML_Theater = 387;
const sal_Int32 XML_ThesisType = 388;
const sal_Int32 XML_Title = 389;
const sal_Int32 XML_TitlesOfParts = 390;
const sal_Int32 XML_Top = 391;
const sal_Int32 XML_TotalTime = 392;
const sal_Int32 XML_Translator = 393;
const sal_Int32 XML_True = 394;
const sal_Int32 XML_Type = 395;
const sal_Int32 XML_Types = 396;
const sal_Int32 XML_UIObj = 397;
const sal_Int32 XML_Unspecified = 398;
const sal_Int32 XML_URI = 399;
const sal_Int32 XML_URL = 400;
const sal_Int32 XML_UpdateMode = 401;
const sal_Int32 XML_VScroll = 402;
const sal_Int32 XML_VTEdit = 403;
const sal_Int32 XML_Val = 404;
const sal_Int32 XML_ValidIds = 405;
const sal_Int32 XML_Value = 406;
const sal_Int32 XML_VariousPropertyBits = 407;
const sal_Int32 XML_Version = 408;
const sal_Int32 XML_Visible = 409;
const sal_Int32 XML_Volume = 410;
const sal_Int32 XML_WidthMin = 411;
const sal_Int32 XML_Words = 412;
const sal_Int32 XML_Writer = 413;
const sal_Int32 XML_XY = 414;
const sal_Int32 XML_YDM = 415;
const sal_Int32 XML_YMD = 416;
const sal_Int32 XML_YZ = 417;
const sal_Int32 XML_Year = 418;
const sal_Int32 XML_YearAccessed = 419;
const sal_Int32 XML_ZX = 420;
const sal_Int32 XML_a = 421;
const sal_Int32 XML_a14 = 422;
const sal_Int32 XML_a16 = 423;
const sal_Int32 XML_aa = 424;
const sal_Int32 XML_above = 425;
const sal_Int32 XML_aboveAverage = 426;
const sal_Int32 XML_absSizeAnchor = 427;
const sal_Int32 XML_absolute = 428;
const sal_Int32 XML_absoluteAnchor = 429;
const sal_Int32 XML_abstractNum = 430;
const sal_Int32 XML_abstractNumId = 431;
const sal_Int32 XML_aca = 432;
const sal_Int32 XML_acc = 433;
const sal_Int32 XML_accPr = 434;
const sal_Int32 XML_accel = 435;
const sal_Int32 XML_accent1 = 436;
const sal_Int32 XML_accent2 = 437;
const sal_Int32 XML_accent3 = 438;
const sal_Int32 XML_accent4 = 439;
const sal_Int32 XML_accent5 = 440;
const sal_Int32 XML_accent6 = 441;
const sal_Int32 XML_accentBorderCallout1 = 442;
const sal_Int32 XML_accentBorderCallout2 = 443;
const sal_Int32 XML_accentBorderCallout3 = 444;
const sal_Int32 XML_accentCallout1 = 445;
const sal_Int32 XML_accentCallout2 = 446;
const sal_Int32 XML_accentCallout3 = 447;
const sal_Int32 XML_accentbar = 448;
const sal_Int32 XML_accumulate = 449;
const sal_Int32 XML_action = 450;
const sal_Int32 XML_actionButtonBackPrevious = 451;
const sal_Int32 XML_actionButtonBeginning = 452;
const sal_Int32 XML_actionButtonBlank = 453;
const sal_Int32 XML_actionButtonDocument = 454;
const sal_Int32 XML_actionButtonEnd = 455;
const sal_Int32 XML_actionButtonForwardNext = 456;
const sal_Int32 XML_actionButtonHelp = 457;
const sal_Int32 XML_actionButtonHome = 458;
const sal_Int32 XML_actionButtonInformation = 459;
const sal_Int32 XML_actionButtonMovie = 460;
const sal_Int32 XML_actionButtonReturn = 461;
const sal_Int32 XML_actionButtonSound = 462;
const sal_Int32 XML_active = 463;
const sal_Int32 XML_activeBorder = 464;
const sal_Int32 XML_activeCaption = 465;
const sal_Int32 XML_activeCell = 466;
const sal_Int32 XML_activeCellId = 467;
const sal_Int32 XML_activeCol = 468;
const sal_Int32 XML_activePane = 469;
const sal_Int32 XML_activeRecord = 470;
const sal_Int32 XML_activeRow = 471;
const sal_Int32 XML_activeSheetId = 472;
const sal_Int32 XML_activeTab = 473;
const sal_Int32 XML_activeWritingStyle = 474;
const sal_Int32 XML_actualPg = 475;
const sal_Int32 XML_ad = 476;
const sal_Int32 XML_add = 477;
const sal_Int32 XML_additionalCharacteristics = 478;
const sal_Int32 XML_additive = 479;
const sal_Int32 XML_addlxml = 480;
const sal_Int32 XML_addressBook = 481;
const sal_Int32 XML_addressFieldName = 482;
const sal_Int32 XML_adec = 483;
const sal_Int32 XML_adj = 484;
const sal_Int32 XML_adjLst = 485;
const sal_Int32 XML_adjust = 486;
const sal_Int32 XML_adjustColumnWidth = 487;
const sal_Int32 XML_adjustLineHeightInTable = 488;
const sal_Int32 XML_adjustRightInd = 489;
const sal_Int32 XML_adjusthandles = 490;
const sal_Int32 XML_administrators = 491;
const sal_Int32 XML_advAuto = 492;
const sal_Int32 XML_advClick = 493;
const sal_Int32 XML_advTm = 494;
const sal_Int32 XML_advise = 495;
const sal_Int32 XML_aft = 496;
const sal_Int32 XML_after = 497;
const sal_Int32 XML_afterAutospacing = 498;
const sal_Int32 XML_afterEffect = 499;
const sal_Int32 XML_afterGroup = 500;
const sal_Int32 XML_afterLines = 501;
const sal_Int32 XML_ahLst = 502;
const sal_Int32 XML_ahPolar = 503;
const sal_Int32 XML_ahXY = 504;
const sal_Int32 XML_aiueo = 505;
const sal_Int32 XML_aiueoFullWidth = 506;
const sal_Int32 XML_alg = 507;
const sal_Int32 XML_algIdExt = 508;
const sal_Int32 XML_algIdExtSource = 509;
const sal_Int32 XML_algn = 510;
const sal_Int32 XML_algorithmName = 511;
const sal_Int32 XML_alias = 512;
const sal_Int32 XML_aliases = 513;
const sal_Int32 XML_aliceBlue = 514;
const sal_Int32 XML_align = 515;
const sal_Int32 XML_alignBordersAndEdges = 516;
const sal_Int32 XML_alignOff = 517;
const sal_Int32 XML_alignTablesRowByRow = 518;
const sal_Int32 XML_alignTx = 519;
const sal_Int32 XML_alignWithMargins = 520;
const sal_Int32 XML_alignment = 521;
const sal_Int32 XML_alignshape = 522;
const sal_Int32 XML_all = 523;
const sal_Int32 XML_allAtOnce = 524;
const sal_Int32 XML_allCaption = 525;
const sal_Int32 XML_allDrilled = 526;
const sal_Int32 XML_allLines = 527;
const sal_Int32 XML_allPages = 528;
const sal_Int32 XML_allPts = 529;
const sal_Int32 XML_allUniqueName = 530;
const sal_Int32 XML_allowBlank = 531;
const sal_Int32 XML_allowOverlap = 532;
const sal_Int32 XML_allowPNG = 533;
const sal_Int32 XML_allowPng = 534;
const sal_Int32 XML_allowRefreshQuery = 535;
const sal_Int32 XML_allowSpaceOfSameStyleInTable = 536;
const sal_Int32 XML_allowcomments = 537;
const sal_Int32 XML_allowincell = 538;
const sal_Int32 XML_allowoverlap = 539;
const sal_Int32 XML_aln = 540;
const sal_Int32 XML_alnAt = 541;
const sal_Int32 XML_alnScr = 542;
const sal_Int32 XML_alongPath = 543;
const sal_Int32 XML_alpha = 544;
const sal_Int32 XML_alphaBiLevel = 545;
const sal_Int32 XML_alphaCeiling = 546;
const sal_Int32 XML_alphaFloor = 547;
const sal_Int32 XML_alphaInv = 548;
const sal_Int32 XML_alphaLcParenBoth = 549;
const sal_Int32 XML_alphaLcParenR = 550;
const sal_Int32 XML_alphaLcPeriod = 551;
const sal_Int32 XML_alphaMod = 552;
const sal_Int32 XML_alphaModFix = 553;
const sal_Int32 XML_alphaOff = 554;
const sal_Int32 XML_alphaOutset = 555;
const sal_Int32 XML_alphaRepl = 556;
const sal_Int32 XML_alphaUcParenBoth = 557;
const sal_Int32 XML_alphaUcParenR = 558;
const sal_Int32 XML_alphaUcPeriod = 559;
const sal_Int32 XML_alt = 560;
const sal_Int32 XML_altChunk = 561;
const sal_Int32 XML_altChunkPr = 562;
const sal_Int32 XML_altLang = 563;
const sal_Int32 XML_altName = 564;
const sal_Int32 XML_althref = 565;
const sal_Int32 XML_always = 566;
const sal_Int32 XML_alwaysMergeEmptyNamespace = 567;
const sal_Int32 XML_alwaysShow = 568;
const sal_Int32 XML_alwaysShowPlaceholderText = 569;
const sal_Int32 XML_amount = 570;
const sal_Int32 XML_amt = 571;
const sal_Int32 XML_anchor = 572;
const sal_Int32 XML_anchorCtr = 573;
const sal_Int32 XML_anchorId = 574;
const sal_Int32 XML_anchorLock = 575;
const sal_Int32 XML_anchorlock = 576;
const sal_Int32 XML_anchorx = 577;
const sal_Int32 XML_anchory = 578;
const sal_Int32 XML_ancst = 579;
const sal_Int32 XML_ancstOrSelf = 580;
const sal_Int32 XML_and = 581;
const sal_Int32 XML_ang = 582;
const sal_Int32 XML_angle = 583;
const sal_Int32 XML_anim = 584;
const sal_Int32 XML_animBg = 585;
const sal_Int32 XML_animClr = 586;
const sal_Int32 XML_animEffect = 587;
const sal_Int32 XML_animLvl = 588;
const sal_Int32 XML_animMotion = 589;
const sal_Int32 XML_animOne = 590;
const sal_Int32 XML_animRot = 591;
const sal_Int32 XML_animScale = 592;
const sal_Int32 XML_annotation = 593;
const sal_Int32 XML_annotationRef = 594;
const sal_Int32 XML_antiqueWhite = 595;
const sal_Int32 XML_antsBlack = 596;
const sal_Int32 XML_antsRed = 597;
const sal_Int32 XML_any = 598;
const sal_Int32 XML_anyType = 599;
const sal_Int32 XML_anyURI = 600;
const sal_Int32 XML_appName = 601;
const sal_Int32 XML_appWorkspace = 602;
const sal_Int32 XML_appearance = 603;
const sal_Int32 XML_apples = 604;
const sal_Int32 XML_applyAlignment = 605;
const sal_Int32 XML_applyAlignmentFormats = 606;
const sal_Int32 XML_applyBorder = 607;
const sal_Int32 XML_applyBorderFormats = 608;
const sal_Int32 XML_applyBreakingRules = 609;
const sal_Int32 XML_applyFill = 610;
const sal_Int32 XML_applyFont = 611;
const sal_Int32 XML_applyFontFormats = 612;
const sal_Int32 XML_applyNumberFormat = 613;
const sal_Int32 XML_applyNumberFormats = 614;
const sal_Int32 XML_applyPatternFormats = 615;
const sal_Int32 XML_applyProtection = 616;
const sal_Int32 XML_applyStyles = 617;
const sal_Int32 XML_applyToEnd = 618;
const sal_Int32 XML_applyToFront = 619;
const sal_Int32 XML_applyToSides = 620;
const sal_Int32 XML_applyWidthHeightFormats = 621;
const sal_Int32 XML_aqua = 622;
const sal_Int32 XML_aquamarine = 623;
const sal_Int32 XML_ar = 624;
const sal_Int32 XML_arabic1Minus = 625;
const sal_Int32 XML_arabic2Minus = 626;
const sal_Int32 XML_arabicAbjad = 627;
const sal_Int32 XML_arabicAlpha = 628;
const sal_Int32 XML_arabicDbPeriod = 629;
const sal_Int32 XML_arabicDbPlain = 630;
const sal_Int32 XML_arabicParenBoth = 631;
const sal_Int32 XML_arabicParenR = 632;
const sal_Int32 XML_arabicPeriod = 633;
const sal_Int32 XML_arabicPlain = 634;
const sal_Int32 XML_arc = 635;
const sal_Int32 XML_arcTo = 636;
const sal_Int32 XML_archedScallops = 637;
const sal_Int32 XML_arcsize = 638;
const sal_Int32 XML_area = 639;
const sal_Int32 XML_area3DChart = 640;
const sal_Int32 XML_areaChart = 641;
const sal_Int32 XML_areaError = 642;
const sal_Int32 XML_arg = 643;
const sal_Int32 XML_argPr = 644;
const sal_Int32 XML_argSz = 645;
const sal_Int32 XML_around = 646;
const sal_Int32 XML_arr = 647;
const sal_Int32 XML_array = 648;
const sal_Int32 XML_arrow = 649;
const sal_Int32 XML_arrowok = 650;
const sal_Int32 XML_artDeco = 651;
const sal_Int32 XML_artisticBlur = 652;
const sal_Int32 XML_artisticCement = 653;
const sal_Int32 XML_artisticChalkSketch = 654;
const sal_Int32 XML_artisticCrisscrossEtching = 655;
const sal_Int32 XML_artisticCutout = 656;
const sal_Int32 XML_artisticFilmGrain = 657;
const sal_Int32 XML_artisticGlass = 658;
const sal_Int32 XML_artisticGlowDiffused = 659;
const sal_Int32 XML_artisticGlowEdges = 660;
const sal_Int32 XML_artisticLightScreen = 661;
const sal_Int32 XML_artisticLineDrawing = 662;
const sal_Int32 XML_artisticMarker = 663;
const sal_Int32 XML_artisticMosiaicBubbles = 664;
const sal_Int32 XML_artisticPaintBrush = 665;
const sal_Int32 XML_artisticPaintStrokes = 666;
const sal_Int32 XML_artisticPastelsSmooth = 667;
const sal_Int32 XML_artisticPencilGrayscale = 668;
const sal_Int32 XML_artisticPencilSketch = 669;
const sal_Int32 XML_artisticPhotocopy = 670;
const sal_Int32 XML_artisticPlasticWrap = 671;
const sal_Int32 XML_artisticTexturizer = 672;
const sal_Int32 XML_artisticWatercolorSponge = 673;
const sal_Int32 XML_asDisplayed = 674;
const sal_Int32 XML_ascending = 675;
const sal_Int32 XML_ascendingAlpha = 676;
const sal_Int32 XML_ascendingNatural = 677;
const sal_Int32 XML_ascii = 678;
const sal_Int32 XML_asciiTheme = 679;
const sal_Int32 XML_aspect = 680;
const sal_Int32 XML_aspectratio = 681;
const sal_Int32 XML_assign = 682;
const sal_Int32 XML_asst = 683;
const sal_Int32 XML_asteriskTotals = 684;
const sal_Int32 XML_asvg = 685;
const sal_Int32 XML_atEnd = 686;
const sal_Int32 XML_atLeast = 687;
const sal_Int32 XML_atMost = 688;
const sal_Int32 XML_attachedSchema = 689;
const sal_Int32 XML_attachedTemplate = 690;
const sal_Int32 XML_attr = 691;
const sal_Int32 XML_attrName = 692;
const sal_Int32 XML_attrNameLst = 693;
const sal_Int32 XML_attribute = 694;
const sal_Int32 XML_audio = 695;
const sal_Int32 XML_audioCd = 696;
const sal_Int32 XML_audioFile = 697;
const sal_Int32 XML_author = 698;
const sal_Int32 XML_authorId = 699;
const sal_Int32 XML_authors = 700;
const sal_Int32 XML_auto = 701;
const sal_Int32 XML_autoAdjust = 702;
const sal_Int32 XML_autoCaption = 703;
const sal_Int32 XML_autoCaptions = 704;
const sal_Int32 XML_autoCompressPictures = 705;
const sal_Int32 XML_autoEnd = 706;
const sal_Int32 XML_autoExp = 707;
const sal_Int32 XML_autoFill = 708;
const sal_Int32 XML_autoFilter = 709;
const sal_Int32 XML_autoFilterDateGrouping = 710;
const sal_Int32 XML_autoFormatId = 711;
const sal_Int32 XML_autoFormatOverride = 712;
const sal_Int32 XML_autoHyphenation = 713;
const sal_Int32 XML_autoLine = 714;
const sal_Int32 XML_autoLoad = 715;
const sal_Int32 XML_autoNoTable = 716;
const sal_Int32 XML_autoPage = 717;
const sal_Int32 XML_autoPageBreaks = 718;
const sal_Int32 XML_autoPict = 719;
const sal_Int32 XML_autoRecover = 720;
const sal_Int32 XML_autoRedefine = 721;
const sal_Int32 XML_autoRepublish = 722;
const sal_Int32 XML_autoRev = 723;
const sal_Int32 XML_autoScale = 724;
const sal_Int32 XML_autoShow = 725;
const sal_Int32 XML_autoSortScope = 726;
const sal_Int32 XML_autoSpaceDE = 727;
const sal_Int32 XML_autoSpaceDN = 728;
const sal_Int32 XML_autoSpaceLikeWord95 = 729;
const sal_Int32 XML_autoStart = 730;
const sal_Int32 XML_autoText = 731;
const sal_Int32 XML_autoTitleDeleted = 732;
const sal_Int32 XML_autoTxRot = 733;
const sal_Int32 XML_autoTxt = 734;
const sal_Int32 XML_autoUpdate = 735;
const sal_Int32 XML_autoUpdateAnimBg = 736;
const sal_Int32 XML_autoZero = 737;
const sal_Int32 XML_autofit = 738;
const sal_Int32 XML_autofitToFirstFixedWidthCell = 739;
const sal_Int32 XML_autoformat = 740;
const sal_Int32 XML_autolayout = 741;
const sal_Int32 XML_autorotationcenter = 742;
const sal_Int32 XML_avLst = 743;
const sal_Int32 XML_average = 744;
const sal_Int32 XML_avg = 745;
const sal_Int32 XML_avgSubtotal = 746;
const sal_Int32 XML_ax = 747;
const sal_Int32 XML_axId = 748;
const sal_Int32 XML_axPos = 749;
const sal_Int32 XML_axis = 750;
const sal_Int32 XML_axisCol = 751;
const sal_Int32 XML_axisColor = 752;
const sal_Int32 XML_axisId = 753;
const sal_Int32 XML_axisPage = 754;
const sal_Int32 XML_axisPosition = 755;
const sal_Int32 XML_axisRow = 756;
const sal_Int32 XML_axisTitle = 757;
const sal_Int32 XML_axisValues = 758;
const sal_Int32 XML_azure = 759;
const sal_Int32 XML_b = 760;
const sal_Int32 XML_bCs = 761;
const sal_Int32 XML_bCtr = 762;
const sal_Int32 XML_bCtrCh = 763;
const sal_Int32 XML_bCtrDes = 764;
const sal_Int32 XML_bIns = 765;
const sal_Int32 XML_bL = 766;
const sal_Int32 XML_bMarg = 767;
const sal_Int32 XML_bOff = 768;
const sal_Int32 XML_bR = 769;
const sal_Int32 XML_babyPacifier = 770;
const sal_Int32 XML_babyRattle = 771;
const sal_Int32 XML_back = 772;
const sal_Int32 XML_backWall = 773;
const sal_Int32 XML_backdepth = 774;
const sal_Int32 XML_backdrop = 775;
const sal_Int32 XML_background = 776;
const sal_Int32 XML_background1 = 777;
const sal_Int32 XML_background2 = 778;
const sal_Int32 XML_backgroundQuery = 779;
const sal_Int32 XML_backgroundRefresh = 780;
const sal_Int32 XML_backgroundRemoval = 781;
const sal_Int32 XML_backupFile = 782;
const sal_Int32 XML_backward = 783;
const sal_Int32 XML_backwardCompatible = 784;
const sal_Int32 XML_backwards = 785;
const sal_Int32 XML_bal = 786;
const sal_Int32 XML_balanceSingleByteDoubleByteWidth = 787;
const sal_Int32 XML_balanced = 788;
const sal_Int32 XML_balloons3Colors = 789;
const sal_Int32 XML_balloonsHotAir = 790;
const sal_Int32 XML_band1H = 791;
const sal_Int32 XML_band1Horz = 792;
const sal_Int32 XML_band1V = 793;
const sal_Int32 XML_band1Vert = 794;
const sal_Int32 XML_band2H = 795;
const sal_Int32 XML_band2Horz = 796;
const sal_Int32 XML_band2V = 797;
const sal_Int32 XML_band2Vert = 798;
const sal_Int32 XML_bandCol = 799;
const sal_Int32 XML_bandFmt = 800;
const sal_Int32 XML_bandFmts = 801;
const sal_Int32 XML_bandRow = 802;
const sal_Int32 XML_banner = 803;
const sal_Int32 XML_bar = 804;
const sal_Int32 XML_bar3DChart = 805;
const sal_Int32 XML_barChart = 806;
const sal_Int32 XML_barDir = 807;
const sal_Int32 XML_barPr = 808;
const sal_Int32 XML_base = 809;
const sal_Int32 XML_base64Binary = 810;
const sal_Int32 XML_baseColWidth = 811;
const sal_Int32 XML_baseField = 812;
const sal_Int32 XML_baseItem = 813;
const sal_Int32 XML_baseJc = 814;
const sal_Int32 XML_baseTimeUnit = 815;
const sal_Int32 XML_baseType = 816;
const sal_Int32 XML_basedOn = 817;
const sal_Int32 XML_baseline = 818;
const sal_Int32 XML_basicBlackDashes = 819;
const sal_Int32 XML_basicBlackDots = 820;
const sal_Int32 XML_basicBlackSquares = 821;
const sal_Int32 XML_basicThinLines = 822;
const sal_Int32 XML_basicWhiteDashes = 823;
const sal_Int32 XML_basicWhiteDots = 824;
const sal_Int32 XML_basicWhiteSquares = 825;
const sal_Int32 XML_basicWideInline = 826;
const sal_Int32 XML_basicWideMidline = 827;
const sal_Int32 XML_basicWideOutline = 828;
const sal_Int32 XML_bats = 829;
const sal_Int32 XML_bbPlcHdr = 830;
const sal_Int32 XML_bc = 831;
const sal_Int32 XML_bdr = 832;
const sal_Int32 XML_bef = 833;
const sal_Int32 XML_before = 834;
const sal_Int32 XML_beforeAutospacing = 835;
const sal_Int32 XML_beforeLines = 836;
const sal_Int32 XML_beg = 837;
const sal_Int32 XML_begChr = 838;
const sal_Int32 XML_begMarg = 839;
const sal_Int32 XML_begPad = 840;
const sal_Int32 XML_begPts = 841;
const sal_Int32 XML_begSty = 842;
const sal_Int32 XML_begin = 843;
const sal_Int32 XML_beginsWith = 844;
const sal_Int32 XML_behavior = 845;
const sal_Int32 XML_behaviors = 846;
const sal_Int32 XML_behindDoc = 847;
const sal_Int32 XML_beige = 848;
const sal_Int32 XML_below = 849;
const sal_Int32 XML_belowAverage = 850;
const sal_Int32 XML_bend = 851;
const sal_Int32 XML_bendDist = 852;
const sal_Int32 XML_bendPt = 853;
const sal_Int32 XML_beneathText = 854;
const sal_Int32 XML_bentArrow = 855;
const sal_Int32 XML_bentConnector2 = 856;
const sal_Int32 XML_bentConnector3 = 857;
const sal_Int32 XML_bentConnector4 = 858;
const sal_Int32 XML_bentConnector5 = 859;
const sal_Int32 XML_bentUpArrow = 860;
const sal_Int32 XML_bestFit = 861;
const sal_Int32 XML_between = 862;
const sal_Int32 XML_bevel = 863;
const sal_Int32 XML_bevelB = 864;
const sal_Int32 XML_bevelT = 865;
const sal_Int32 XML_bg = 866;
const sal_Int32 XML_bg1 = 867;
const sal_Int32 XML_bg2 = 868;
const sal_Int32 XML_bgClr = 869;
const sal_Int32 XML_bgColor = 870;
const sal_Int32 XML_bgFillStyleLst = 871;
const sal_Int32 XML_bgPr = 872;
const sal_Int32 XML_bgRef = 873;
const sal_Int32 XML_bi = 874;
const sal_Int32 XML_biLevel = 875;
const sal_Int32 XML_bib = 876;
const sal_Int32 XML_bibliography = 877;
const sal_Int32 XML_bidi = 878;
const sal_Int32 XML_bidiVisual = 879;
const sal_Int32 XML_bilevel = 880;
const sal_Int32 XML_billions = 881;
const sal_Int32 XML_birds = 882;
const sal_Int32 XML_birdsFlight = 883;
const sal_Int32 XML_bisque = 884;
const sal_Int32 XML_bk = 885;
const sal_Int32 XML_bkPtFixedVal = 886;
const sal_Int32 XML_bkpt = 887;
const sal_Int32 XML_bl = 888;
const sal_Int32 XML_black = 889;
const sal_Int32 XML_blackAndWhite = 890;
const sal_Int32 XML_blackGray = 891;
const sal_Int32 XML_blackTextAndLines = 892;
const sal_Int32 XML_blackTextOnWhite = 893;
const sal_Int32 XML_blackWhite = 894;
const sal_Int32 XML_blacklevel = 895;
const sal_Int32 XML_blanchedAlmond = 896;
const sal_Int32 XML_blank = 897;
const sal_Int32 XML_blankRow = 898;
const sal_Int32 XML_bld = 899;
const sal_Int32 XML_bldAsOne = 900;
const sal_Int32 XML_bldChart = 901;
const sal_Int32 XML_bldDgm = 902;
const sal_Int32 XML_bldGraphic = 903;
const sal_Int32 XML_bldLst = 904;
const sal_Int32 XML_bldLvl = 905;
const sal_Int32 XML_bldOleChart = 906;
const sal_Int32 XML_bldP = 907;
const sal_Int32 XML_bldStep = 908;
const sal_Int32 XML_bldSub = 909;
const sal_Int32 XML_blend = 910;
const sal_Int32 XML_blinds = 911;
const sal_Int32 XML_blinkBackground = 912;
const sal_Int32 XML_blip = 913;
const sal_Int32 XML_blipFill = 914;
const sal_Int32 XML_blipPhldr = 915;
const sal_Int32 XML_blob = 916;
const sal_Int32 XML_block = 917;
const sal_Int32 XML_blockArc = 918;
const sal_Int32 XML_blockQuote = 919;
const sal_Int32 XML_blue = 920;
const sal_Int32 XML_blueMod = 921;
const sal_Int32 XML_blueOff = 922;
const sal_Int32 XML_blueViolet = 923;
const sal_Int32 XML_blur = 924;
const sal_Int32 XML_blurRad = 925;
const sal_Int32 XML_bmk = 926;
const sal_Int32 XML_body = 927;
const sal_Int32 XML_bodyDiv = 928;
const sal_Int32 XML_bodyPr = 929;
const sal_Int32 XML_bodyStyle = 930;
const sal_Int32 XML_bold = 931;
const sal_Int32 XML_boldItalic = 932;
const sal_Int32 XML_bookFoldPrinting = 933;
const sal_Int32 XML_bookFoldPrintingSheets = 934;
const sal_Int32 XML_bookFoldRevPrinting = 935;
const sal_Int32 XML_bookViews = 936;
const sal_Int32 XML_bookmarkEnd = 937;
const sal_Int32 XML_bookmarkIdSeed = 938;
const sal_Int32 XML_bookmarkStart = 939;
const sal_Int32 XML_bool = 940;
const sal_Int32 XML_boolVal = 941;
const sal_Int32 XML_boolean = 942;
const sal_Int32 XML_border = 943;
const sal_Int32 XML_borderBox = 944;
const sal_Int32 XML_borderBoxPr = 945;
const sal_Int32 XML_borderCallout1 = 946;
const sal_Int32 XML_borderCallout2 = 947;
const sal_Int32 XML_borderCallout3 = 948;
const sal_Int32 XML_borderId = 949;
const sal_Int32 XML_borderbottom = 950;
const sal_Int32 XML_borderbottomcolor = 951;
const sal_Int32 XML_borderleft = 952;
const sal_Int32 XML_borderleftcolor = 953;
const sal_Int32 XML_borderright = 954;
const sal_Int32 XML_borderrightcolor = 955;
const sal_Int32 XML_borders = 956;
const sal_Int32 XML_bordersDoNotSurroundFooter = 957;
const sal_Int32 XML_bordersDoNotSurroundHeader = 958;
const sal_Int32 XML_bordertop = 959;
const sal_Int32 XML_bordertopcolor = 960;
const sal_Int32 XML_bot = 961;
const sal_Int32 XML_both = 962;
const sal_Int32 XML_bothSides = 963;
const sal_Int32 XML_bottom = 964;
const sal_Int32 XML_bottomFromText = 965;
const sal_Int32 XML_bottomLeft = 966;
const sal_Int32 XML_bottomMargin = 967;
const sal_Int32 XML_bottomRight = 968;
const sal_Int32 XML_boundingCube = 969;
const sal_Int32 XML_box = 970;
const sal_Int32 XML_boxPr = 971;
const sal_Int32 XML_boxWhisker = 972;
const sal_Int32 XML_br = 973;
const sal_Int32 XML_bracePair = 974;
const sal_Int32 XML_bracketPair = 975;
const sal_Int32 XML_branch = 976;
const sal_Int32 XML_breadthByLvl = 977;
const sal_Int32 XML_breadthByNode = 978;
const sal_Int32 XML_bright = 979;
const sal_Int32 XML_brightRoom = 980;
const sal_Int32 XML_brightness = 981;
const sal_Int32 XML_brightnessContrast = 982;
const sal_Int32 XML_brk = 983;
const sal_Int32 XML_brkBin = 984;
const sal_Int32 XML_brkBinSub = 985;
const sal_Int32 XML_brown = 986;
const sal_Int32 XML_browse = 987;
const sal_Int32 XML_browser = 988;
const sal_Int32 XML_brushSize = 989;
const sal_Int32 XML_bstr = 990;
const sal_Int32 XML_btLr = 991;
const sal_Int32 XML_btnFace = 992;
const sal_Int32 XML_btnHighlight = 993;
const sal_Int32 XML_btnShadow = 994;
const sal_Int32 XML_btnText = 995;
const sal_Int32 XML_buAutoNum = 996;
const sal_Int32 XML_buBlip = 997;
const sal_Int32 XML_buChar = 998;
const sal_Int32 XML_buClr = 999;
const sal_Int32 XML_buClrTx = 1000;
const sal_Int32 XML_buFont = 1001;
const sal_Int32 XML_buFontTx = 1002;
const sal_Int32 XML_buNone = 1003;
const sal_Int32 XML_buSzPct = 1004;
const sal_Int32 XML_buSzPts = 1005;
const sal_Int32 XML_buSzTx = 1006;
const sal_Int32 XML_bubble3D = 1007;
const sal_Int32 XML_bubbleChart = 1008;
const sal_Int32 XML_bubbleScale = 1009;
const sal_Int32 XML_bubbleSize = 1010;
const sal_Int32 XML_build = 1011;
const sal_Int32 XML_builtIn = 1012;
const sal_Int32 XML_builtInGroupCount = 1013;
const sal_Int32 XML_builtInUnit = 1014;
const sal_Int32 XML_builtinId = 1015;
const sal_Int32 XML_bulEnabled = 1016;
const sal_Int32 XML_bullet = 1017;
const sal_Int32 XML_bulletEnabled = 1018;
const sal_Int32 XML_bullseye = 1019;
const sal_Int32 XML_burlyWood = 1020;
const sal_Int32 XML_button = 1021;
const sal_Int32 XML_bw = 1022;
const sal_Int32 XML_bwMode = 1023;
const sal_Int32 XML_bwmode = 1024;
const sal_Int32 XML_bwnormal = 1025;
const sal_Int32 XML_bwpure = 1026;
const sal_Int32 XML_bx = 1027;
const sal_Int32 XML_by = 1028;
const sal_Int32 XML_byPosition = 1029;
const sal_Int32 XML_byte = 1030;
const sal_Int32 XML_c = 1031;
const sal_Int32 XML_c15 = 1032;
const sal_Int32 XML_cBhvr = 1033;
const sal_Int32 XML_cdr = 1034;
const sal_Int32 XML_cGp = 1035;
const sal_Int32 XML_cGpRule = 1036;
const sal_Int32 XML_cMediaNode = 1037;
const sal_Int32 XML_cNvCnPr = 1038;
const sal_Int32 XML_cNvCxnSpPr = 1039;
const sal_Int32 XML_cNvGraphicFramePr = 1040;
const sal_Int32 XML_cNvGrpSpPr = 1041;
const sal_Int32 XML_cNvPicPr = 1042;
const sal_Int32 XML_cNvPr = 1043;
const sal_Int32 XML_cNvSpPr = 1044;
const sal_Int32 XML_cSld = 1045;
const sal_Int32 XML_cSldViewPr = 1046;
const sal_Int32 XML_cSp = 1047;
const sal_Int32 XML_cTn = 1048;
const sal_Int32 XML_cViewPr = 1049;
const sal_Int32 XML_ca = 1050;
const sal_Int32 XML_cabins = 1051;
const sal_Int32 XML_cacheField = 1052;
const sal_Int32 XML_cacheFields = 1053;
const sal_Int32 XML_cacheHierarchies = 1054;
const sal_Int32 XML_cacheHierarchy = 1055;
const sal_Int32 XML_cacheId = 1056;
const sal_Int32 XML_cacheIndex = 1057;
const sal_Int32 XML_cacheSource = 1058;
const sal_Int32 XML_cachedColBalance = 1059;
const sal_Int32 XML_cadetBlue = 1060;
const sal_Int32 XML_cakeSlice = 1061;
const sal_Int32 XML_calcChain = 1062;
const sal_Int32 XML_calcCompleted = 1063;
const sal_Int32 XML_calcId = 1064;
const sal_Int32 XML_calcMode = 1065;
const sal_Int32 XML_calcOnExit = 1066;
const sal_Int32 XML_calcOnSave = 1067;
const sal_Int32 XML_calcPr = 1068;
const sal_Int32 XML_calcmode = 1069;
const sal_Int32 XML_calculated = 1070;
const sal_Int32 XML_calculatedColumn = 1071;
const sal_Int32 XML_calculatedColumnFormula = 1072;
const sal_Int32 XML_calculatedItem = 1073;
const sal_Int32 XML_calculatedItems = 1074;
const sal_Int32 XML_calculatedMember = 1075;
const sal_Int32 XML_calculatedMembers = 1076;
const sal_Int32 XML_calendar = 1077;
const sal_Int32 XML_calendarType = 1078;
const sal_Int32 XML_call = 1079;
const sal_Int32 XML_callout = 1080;
const sal_Int32 XML_callout1 = 1081;
const sal_Int32 XML_callout2 = 1082;
const sal_Int32 XML_callout3 = 1083;
const sal_Int32 XML_camera = 1084;
const sal_Int32 XML_can = 1085;
const sal_Int32 XML_canSlip = 1086;
const sal_Int32 XML_candyCorn = 1087;
const sal_Int32 XML_cantSplit = 1088;
const sal_Int32 XML_canvas = 1089;
const sal_Int32 XML_cap = 1090;
const sal_Int32 XML_caps = 1091;
const sal_Int32 XML_caption = 1092;
const sal_Int32 XML_captionBeginsWith = 1093;
const sal_Int32 XML_captionBetween = 1094;
const sal_Int32 XML_captionContains = 1095;
const sal_Int32 XML_captionEndsWith = 1096;
const sal_Int32 XML_captionEqual = 1097;
const sal_Int32 XML_captionGreaterThan = 1098;
const sal_Int32 XML_captionGreaterThanOrEqual = 1099;
const sal_Int32 XML_captionLessThan = 1100;
const sal_Int32 XML_captionLessThanOrEqual = 1101;
const sal_Int32 XML_captionNotBeginsWith = 1102;
const sal_Int32 XML_captionNotBetween = 1103;
const sal_Int32 XML_captionNotContains = 1104;
const sal_Int32 XML_captionNotEndsWith = 1105;
const sal_Int32 XML_captionNotEqual = 1106;
const sal_Int32 XML_captionText = 1107;
const sal_Int32 XML_captions = 1108;
const sal_Int32 XML_cardinalText = 1109;
const sal_Int32 XML_caseSensitive = 1110;
const sal_Int32 XML_cat = 1111;
const sal_Int32 XML_catAx = 1112;
const sal_Int32 XML_catScaling = 1113;
const sal_Int32 XML_catLst = 1114;
const sal_Int32 XML_catalog = 1115;
const sal_Int32 XML_category = 1116;
const sal_Int32 XML_categoryAxis = 1117;
const sal_Int32 XML_categoryEl = 1118;
const sal_Int32 XML_categoryIdx = 1119;
const sal_Int32 XML_ccw = 1120;
const sal_Int32 XML_ccwIn = 1121;
const sal_Int32 XML_ccwOut = 1122;
const sal_Int32 XML_cd2 = 1123;
const sal_Int32 XML_cd3 = 1124;
const sal_Int32 XML_cd4 = 1125;
const sal_Int32 XML_cd8 = 1126;
const sal_Int32 XML_cell = 1127;
const sal_Int32 XML_cell3D = 1128;
const sal_Int32 XML_cellColor = 1129;
const sal_Int32 XML_cellComments = 1130;
const sal_Int32 XML_cellDel = 1131;
const sal_Int32 XML_cellIns = 1132;
const sal_Int32 XML_cellIs = 1133;
const sal_Int32 XML_cellMerge = 1134;
const sal_Int32 XML_cellMeta = 1135;
const sal_Int32 XML_cellMetadata = 1136;
const sal_Int32 XML_cellSmartTag = 1137;
const sal_Int32 XML_cellSmartTagPr = 1138;
const sal_Int32 XML_cellSmartTags = 1139;
const sal_Int32 XML_cellStyle = 1140;
const sal_Int32 XML_cellStyleXfs = 1141;
const sal_Int32 XML_cellStyles = 1142;
const sal_Int32 XML_cellWatch = 1143;
const sal_Int32 XML_cellWatches = 1144;
const sal_Int32 XML_cellXfs = 1145;
const sal_Int32 XML_celticKnotwork = 1146;
const sal_Int32 XML_center = 1147;
const sal_Int32 XML_centerContinuous = 1148;
const sal_Int32 XML_centerGroup = 1149;
const sal_Int32 XML_centered = 1150;
const sal_Int32 XML_certificateBanner = 1151;
const sal_Int32 XML_cf = 1152;
const sal_Int32 XML_cfIcon = 1153;
const sal_Int32 XML_cfRule = 1154;
const sal_Int32 XML_cfvo = 1155;
const sal_Int32 XML_ch = 1156;
const sal_Int32 XML_chAlign = 1157;
const sal_Int32 XML_chDir = 1158;
const sal_Int32 XML_chExt = 1159;
const sal_Int32 XML_chMax = 1160;
const sal_Int32 XML_chOff = 1161;
const sal_Int32 XML_chOrder = 1162;
const sal_Int32 XML_chPref = 1163;
const sal_Int32 XML_chainLink = 1164;
const sal_Int32 XML_champagneBottle = 1165;
const sal_Int32 XML_changesSavedWin = 1166;
const sal_Int32 XML_chapNum = 1167;
const sal_Int32 XML_chapSep = 1168;
const sal_Int32 XML_chapStyle = 1169;
const sal_Int32 XML_char = 1170;
const sal_Int32 XML_charRg = 1171;
const sal_Int32 XML_charSpace = 1172;
const sal_Int32 XML_character = 1173;
const sal_Int32 XML_characterSet = 1174;
const sal_Int32 XML_characterSpacingControl = 1175;
const sal_Int32 XML_characteristic = 1176;
const sal_Int32 XML_charset = 1177;
const sal_Int32 XML_chart = 1178;
const sal_Int32 XML_chartAndTx = 1179;
const sal_Int32 XML_chartArea = 1180;
const sal_Int32 XML_chartData = 1181;
const sal_Int32 XML_chartFormat = 1182;
const sal_Int32 XML_chartFormats = 1183;
const sal_Int32 XML_chartObject = 1184;
const sal_Int32 XML_chartPlus = 1185;
const sal_Int32 XML_chartSpace = 1186;
const sal_Int32 XML_chartStar = 1187;
const sal_Int32 XML_chartStyle = 1188;
const sal_Int32 XML_chartX = 1189;
const sal_Int32 XML_chartex = 1190;
const sal_Int32 XML_chartreuse = 1191;
const sal_Int32 XML_chartsheet = 1192;
const sal_Int32 XML_checkBox = 1193;
const sal_Int32 XML_checkCompatibility = 1194;
const sal_Int32 XML_checkErrors = 1195;
const sal_Int32 XML_checkStyle = 1196;
const sal_Int32 XML_checkbox = 1197;
const sal_Int32 XML_checked = 1198;
const sal_Int32 XML_checkedBarBlack = 1199;
const sal_Int32 XML_checkedBarColor = 1200;
const sal_Int32 XML_checkedState = 1201;
const sal_Int32 XML_checker = 1202;
const sal_Int32 XML_checkered = 1203;
const sal_Int32 XML_chevron = 1204;
const sal_Int32 XML_chicago = 1205;
const sal_Int32 XML_childStyle = 1206;
const sal_Int32 XML_childTnLst = 1207;
const sal_Int32 XML_chilly = 1208;
const sal_Int32 XML_chineseCounting = 1209;
const sal_Int32 XML_chineseCountingThousand = 1210;
const sal_Int32 XML_chineseLegalSimplified = 1211;
const sal_Int32 XML_chocolate = 1212;
const sal_Int32 XML_choose = 1213;
const sal_Int32 XML_chord = 1214;
const sal_Int32 XML_chosung = 1215;
const sal_Int32 XML_chr = 1216;
const sal_Int32 XML_christmasTree = 1217;
const sal_Int32 XML_chromakey = 1218;
const sal_Int32 XML_circle = 1219;
const sal_Int32 XML_circleNumDbPlain = 1220;
const sal_Int32 XML_circleNumWdBlackPlain = 1221;
const sal_Int32 XML_circleNumWdWhitePlain = 1222;
const sal_Int32 XML_circlesLines = 1223;
const sal_Int32 XML_circlesRectangles = 1224;
const sal_Int32 XML_circularArrow = 1225;
const sal_Int32 XML_citation = 1226;
const sal_Int32 XML_class = 1227;
const sal_Int32 XML_classic = 1228;
const sal_Int32 XML_classicalWave = 1229;
const sal_Int32 XML_classid = 1230;
const sal_Int32 XML_clean = 1231;
const sal_Int32 XML_clear = 1232;
const sal_Int32 XML_clearAll = 1233;
const sal_Int32 XML_clearComments = 1234;
const sal_Int32 XML_clearContents = 1235;
const sal_Int32 XML_clearFormats = 1236;
const sal_Int32 XML_click = 1237;
const sal_Int32 XML_clickAndTypeStyle = 1238;
const sal_Int32 XML_clickEffect = 1239;
const sal_Int32 XML_clickPar = 1240;
const sal_Int32 XML_clientData = 1241;
const sal_Int32 XML_clientInsertedTime = 1242;
const sal_Int32 XML_clip = 1243;
const sal_Int32 XML_clipArt = 1244;
const sal_Int32 XML_clipArtAndTx = 1245;
const sal_Int32 XML_clipArtAndVertTx = 1246;
const sal_Int32 XML_clippath = 1247;
const sal_Int32 XML_clipped = 1248;
const sal_Int32 XML_cliptowrap = 1249;
const sal_Int32 XML_clocks = 1250;
const sal_Int32 XML_close = 1251;
const sal_Int32 XML_cloud = 1252;
const sal_Int32 XML_cloudCallout = 1253;
const sal_Int32 XML_clr = 1254;
const sal_Int32 XML_clrChange = 1255;
const sal_Int32 XML_clrData = 1256;
const sal_Int32 XML_clrFrom = 1257;
const sal_Int32 XML_clrIdx = 1258;
const sal_Int32 XML_clrMap = 1259;
const sal_Int32 XML_clrMapOvr = 1260;
const sal_Int32 XML_clrMode = 1261;
const sal_Int32 XML_clrMru = 1262;
const sal_Int32 XML_clrRepl = 1263;
const sal_Int32 XML_clrScheme = 1264;
const sal_Int32 XML_clrSchemeMapping = 1265;
const sal_Int32 XML_clrSpc = 1266;
const sal_Int32 XML_clrTo = 1267;
const sal_Int32 XML_clrVal = 1268;
const sal_Int32 XML_clsid = 1269;
const sal_Int32 XML_clustered = 1270;
const sal_Int32 XML_clusteredColumn = 1271;
const sal_Int32 XML_cm = 1272;
const sal_Int32 XML_cmAuthor = 1273;
const sal_Int32 XML_cmAuthorLst = 1274;
const sal_Int32 XML_cmLst = 1275;
const sal_Int32 XML_cmd = 1276;
const sal_Int32 XML_cmpd = 1277;
const sal_Int32 XML_cnfStyle = 1278;
const sal_Int32 XML_cnt = 1279;
const sal_Int32 XML_cntxtAlts = 1280;
const sal_Int32 XML_code = 1281;
const sal_Int32 XML_codeName = 1282;
const sal_Int32 XML_codePage = 1283;
const sal_Int32 XML_coerce = 1284;
const sal_Int32 XML_coherent3DOff = 1285;
const sal_Int32 XML_col = 1286;
const sal_Int32 XML_colBreaks = 1287;
const sal_Int32 XML_colDelim = 1288;
const sal_Int32 XML_colFields = 1289;
const sal_Int32 XML_colFirst = 1290;
const sal_Int32 XML_colGrandTotals = 1291;
const sal_Int32 XML_colHeaderCaption = 1292;
const sal_Int32 XML_colHidden = 1293;
const sal_Int32 XML_colHierarchiesUsage = 1294;
const sal_Int32 XML_colHierarchyUsage = 1295;
const sal_Int32 XML_colId = 1296;
const sal_Int32 XML_colItems = 1297;
const sal_Int32 XML_colLast = 1298;
const sal_Int32 XML_colOff = 1299;
const sal_Int32 XML_colPageCount = 1300;
const sal_Int32 XML_collapse = 1301;
const sal_Int32 XML_collapsed = 1302;
const sal_Int32 XML_collapsedLevelsAreSubtotals = 1303;
const sal_Int32 XML_colon = 1304;
const sal_Int32 XML_color = 1305;
const sal_Int32 XML_color2 = 1306;
const sal_Int32 XML_colorAxis = 1307;
const sal_Int32 XML_colorFilter = 1308;
const sal_Int32 XML_colorFirst = 1309;
const sal_Int32 XML_colorHigh = 1310;
const sal_Int32 XML_colorId = 1311;
const sal_Int32 XML_colorLast = 1312;
const sal_Int32 XML_colorLow = 1313;
const sal_Int32 XML_colorMarkers = 1314;
const sal_Int32 XML_colorNegative = 1315;
const sal_Int32 XML_colorScale = 1316;
const sal_Int32 XML_colorSeries = 1317;
const sal_Int32 XML_colorStyle = 1318;
const sal_Int32 XML_colorTemp = 1319;
const sal_Int32 XML_colorTemperature = 1320;
const sal_Int32 XML_colormenu = 1321;
const sal_Int32 XML_colormode = 1322;
const sal_Int32 XML_colormru = 1323;
const sal_Int32 XML_colors = 1324;
const sal_Int32 XML_colorsDef = 1325;
const sal_Int32 XML_colorsDefHdr = 1326;
const sal_Int32 XML_colorsDefHdrLst = 1327;
const sal_Int32 XML_cols = 1328;
const sal_Int32 XML_column = 1329;
const sal_Int32 XML_columnSort = 1330;
const sal_Int32 XML_comb = 1331;
const sal_Int32 XML_combine = 1332;
const sal_Int32 XML_combineBrackets = 1333;
const sal_Int32 XML_comboBox = 1334;
const sal_Int32 XML_commIndAndComment = 1335;
const sal_Int32 XML_commIndicator = 1336;
const sal_Int32 XML_commNone = 1337;
const sal_Int32 XML_comma = 1338;
const sal_Int32 XML_command = 1339;
const sal_Int32 XML_commandType = 1340;
const sal_Int32 XML_comment = 1341;
const sal_Int32 XML_commentEx = 1342;
const sal_Int32 XML_commentList = 1343;
const sal_Int32 XML_commentPr = 1344;
const sal_Int32 XML_commentRangeEnd = 1345;
const sal_Int32 XML_commentRangeStart = 1346;
const sal_Int32 XML_commentReference = 1347;
const sal_Int32 XML_comments = 1348;
const sal_Int32 XML_commentsEx = 1349;
const sal_Int32 XML_comp = 1350;
const sal_Int32 XML_compact = 1351;
const sal_Int32 XML_compactData = 1352;
const sal_Int32 XML_compass = 1353;
const sal_Int32 XML_compat = 1354;
const sal_Int32 XML_compatLnSpc = 1355;
const sal_Int32 XML_compatMode = 1356;
const sal_Int32 XML_compatSetting = 1357;
const sal_Int32 XML_complex = 1358;
const sal_Int32 XML_composite = 1359;
const sal_Int32 XML_compressPunctuation = 1360;
const sal_Int32 XML_compressPunctuationAndJapaneseKana = 1361;
const sal_Int32 XML_computedArea = 1362;
const sal_Int32 XML_concurrent = 1363;
const sal_Int32 XML_concurrentCalc = 1364;
const sal_Int32 XML_concurrentManualCount = 1365;
const sal_Int32 XML_cond = 1366;
const sal_Int32 XML_condense = 1367;
const sal_Int32 XML_conditionalFormat = 1368;
const sal_Int32 XML_conditionalFormats = 1369;
const sal_Int32 XML_conditionalFormatting = 1370;
const sal_Int32 XML_conditionalFormattings = 1371;
const sal_Int32 XML_cone = 1372;
const sal_Int32 XML_coneToMax = 1373;
const sal_Int32 XML_confetti = 1374;
const sal_Int32 XML_confettiGrays = 1375;
const sal_Int32 XML_confettiOutline = 1376;
const sal_Int32 XML_confettiStreamers = 1377;
const sal_Int32 XML_confettiWhite = 1378;
const sal_Int32 XML_conformance = 1379;
const sal_Int32 XML_conn = 1380;
const sal_Int32 XML_connDist = 1381;
const sal_Int32 XML_connRout = 1382;
const sal_Int32 XML_connectString = 1383;
const sal_Int32 XML_connectangles = 1384;
const sal_Int32 XML_connection = 1385;
const sal_Int32 XML_connectionId = 1386;
const sal_Int32 XML_connections = 1387;
const sal_Int32 XML_connectloc = 1388;
const sal_Int32 XML_connectlocs = 1389;
const sal_Int32 XML_connector = 1390;
const sal_Int32 XML_connectortype = 1391;
const sal_Int32 XML_connecttype = 1392;
const sal_Int32 XML_consecutive = 1393;
const sal_Int32 XML_consecutiveHyphenLimit = 1394;
const sal_Int32 XML_consolidation = 1395;
const sal_Int32 XML_constr = 1396;
const sal_Int32 XML_constrLst = 1397;
const sal_Int32 XML_constrainbounds = 1398;
const sal_Int32 XML_cont = 1399;
const sal_Int32 XML_contDir = 1400;
const sal_Int32 XML_containsBlank = 1401;
const sal_Int32 XML_containsBlanks = 1402;
const sal_Int32 XML_containsDate = 1403;
const sal_Int32 XML_containsErrors = 1404;
const sal_Int32 XML_containsInteger = 1405;
const sal_Int32 XML_containsMixedTypes = 1406;
const sal_Int32 XML_containsNonDate = 1407;
const sal_Int32 XML_containsNumber = 1408;
const sal_Int32 XML_containsSemiMixedTypes = 1409;
const sal_Int32 XML_containsString = 1410;
const sal_Int32 XML_containsText = 1411;
const sal_Int32 XML_content = 1412;
const sal_Int32 XML_contentLocked = 1413;
const sal_Int32 XML_contentStatus = 1414;
const sal_Int32 XML_contentType = 1415;
const sal_Int32 XML_contextualSpacing = 1416;
const sal_Int32 XML_continuationNotice = 1417;
const sal_Int32 XML_continuationSeparator = 1418;
const sal_Int32 XML_continue = 1419;
const sal_Int32 XML_continuous = 1420;
const sal_Int32 XML_contourClr = 1421;
const sal_Int32 XML_contourW = 1422;
const sal_Int32 XML_contrast = 1423;
const sal_Int32 XML_contrasting = 1424;
const sal_Int32 XML_contributors = 1425;
const sal_Int32 XML_control = 1426;
const sal_Int32 XML_control1 = 1427;
const sal_Int32 XML_control2 = 1428;
const sal_Int32 XML_controlPr = 1429;
const sal_Int32 XML_controls = 1430;
const sal_Int32 XML_convMailMergeEsc = 1431;
const sal_Int32 XML_convex = 1432;
const sal_Int32 XML_conveyor = 1433;
const sal_Int32 XML_coolSlant = 1434;
const sal_Int32 XML_coordorigin = 1435;
const sal_Int32 XML_coordsize = 1436;
const sal_Int32 XML_copies = 1437;
const sal_Int32 XML_copy = 1438;
const sal_Int32 XML_coral = 1439;
const sal_Int32 XML_coreProperties = 1440;
const sal_Int32 XML_corner = 1441;
const sal_Int32 XML_cornerTabs = 1442;
const sal_Int32 XML_cornerTriangles = 1443;
const sal_Int32 XML_cornflowerBlue = 1444;
const sal_Int32 XML_cornsilk = 1445;
const sal_Int32 XML_count = 1446;
const sal_Int32 XML_countA = 1447;
const sal_Int32 XML_countASubtotal = 1448;
const sal_Int32 XML_countBy = 1449;
const sal_Int32 XML_countNums = 1450;
const sal_Int32 XML_countSubtotal = 1451;
const sal_Int32 XML_couponCutoutDashes = 1452;
const sal_Int32 XML_couponCutoutDots = 1453;
const sal_Int32 XML_cover = 1454;
const sal_Int32 XML_coverPg = 1455;
const sal_Int32 XML_cp = 1456;
const sal_Int32 XML_cr = 1457;
const sal_Int32 XML_crackSpacing = 1458;
const sal_Int32 XML_crashSave = 1459;
const sal_Int32 XML_crazyMaze = 1460;
const sal_Int32 XML_created = 1461;
const sal_Int32 XML_createdVersion = 1462;
const sal_Int32 XML_creationId = 1463;
const sal_Int32 XML_creator = 1464;
const sal_Int32 XML_creaturesButterfly = 1465;
const sal_Int32 XML_creaturesFish = 1466;
const sal_Int32 XML_creaturesInsects = 1467;
const sal_Int32 XML_creaturesLadyBug = 1468;
const sal_Int32 XML_credentials = 1469;
const sal_Int32 XML_crimson = 1470;
const sal_Int32 XML_cropbottom = 1471;
const sal_Int32 XML_cropleft = 1472;
const sal_Int32 XML_cropping = 1473;
const sal_Int32 XML_cropright = 1474;
const sal_Int32 XML_croptop = 1475;
const sal_Int32 XML_cross = 1476;
const sal_Int32 XML_crossAx = 1477;
const sal_Int32 XML_crossBetween = 1478;
const sal_Int32 XML_crossStitch = 1479;
const sal_Int32 XML_crosses = 1480;
const sal_Int32 XML_crossesAt = 1481;
const sal_Int32 XML_cryptAlgorithmClass = 1482;
const sal_Int32 XML_cryptAlgorithmSid = 1483;
const sal_Int32 XML_cryptAlgorithmType = 1484;
const sal_Int32 XML_cryptProvider = 1485;
const sal_Int32 XML_cryptProviderType = 1486;
const sal_Int32 XML_cryptProviderTypeExt = 1487;
const sal_Int32 XML_cryptProviderTypeExtSource = 1488;
const sal_Int32 XML_cryptSpinCount = 1489;
const sal_Int32 XML_cs = 1490;
const sal_Int32 XML_csCatId = 1491;
const sal_Int32 XML_csTypeId = 1492;
const sal_Int32 XML_csb0 = 1493;
const sal_Int32 XML_csb1 = 1494;
const sal_Int32 XML_css = 1495;
const sal_Int32 XML_cstate = 1496;
const sal_Int32 XML_cstheme = 1497;
const sal_Int32 XML_ct = 1498;
const sal_Int32 XML_ctr = 1499;
const sal_Int32 XML_ctrShpMap = 1500;
const sal_Int32 XML_ctrTitle = 1501;
const sal_Int32 XML_ctrX = 1502;
const sal_Int32 XML_ctrXOff = 1503;
const sal_Int32 XML_ctrY = 1504;
const sal_Int32 XML_ctrYOff = 1505;
const sal_Int32 XML_ctrlPr = 1506;
const sal_Int32 XML_cube = 1507;
const sal_Int32 XML_cubicBezTo = 1508;
const sal_Int32 XML_culture = 1509;
const sal_Int32 XML_cup = 1510;
const sal_Int32 XML_curly = 1511;
const sal_Int32 XML_current = 1512;
const sal_Int32 XML_currentDate = 1513;
const sal_Int32 XML_currentTime = 1514;
const sal_Int32 XML_curve = 1515;
const sal_Int32 XML_curved = 1516;
const sal_Int32 XML_curvedConnector2 = 1517;
const sal_Int32 XML_curvedConnector3 = 1518;
const sal_Int32 XML_curvedConnector4 = 1519;
const sal_Int32 XML_curvedConnector5 = 1520;
const sal_Int32 XML_curvedDownArrow = 1521;
const sal_Int32 XML_curvedLeftArrow = 1522;
const sal_Int32 XML_curvedRightArrow = 1523;
const sal_Int32 XML_curvedUpArrow = 1524;
const sal_Int32 XML_cust = 1525;
const sal_Int32 XML_custAng = 1526;
const sal_Int32 XML_custAutoTxt = 1527;
const sal_Int32 XML_custBib = 1528;
const sal_Int32 XML_custClr = 1529;
const sal_Int32 XML_custClrLst = 1530;
const sal_Int32 XML_custCoverPg = 1531;
const sal_Int32 XML_custDash = 1532;
const sal_Int32 XML_custData = 1533;
const sal_Int32 XML_custDataLst = 1534;
const sal_Int32 XML_custEq = 1535;
const sal_Int32 XML_custFlipHor = 1536;
const sal_Int32 XML_custFlipVert = 1537;
const sal_Int32 XML_custFtrs = 1538;
const sal_Int32 XML_custGeom = 1539;
const sal_Int32 XML_custHdrs = 1540;
const sal_Int32 XML_custLinFactNeighborX = 1541;
const sal_Int32 XML_custLinFactNeighborY = 1542;
const sal_Int32 XML_custLinFactX = 1543;
const sal_Int32 XML_custLinFactY = 1544;
const sal_Int32 XML_custPgNum = 1545;
const sal_Int32 XML_custPgNumB = 1546;
const sal_Int32 XML_custPgNumMargins = 1547;
const sal_Int32 XML_custPgNumT = 1548;
const sal_Int32 XML_custQuickParts = 1549;
const sal_Int32 XML_custRadScaleInc = 1550;
const sal_Int32 XML_custRadScaleRad = 1551;
const sal_Int32 XML_custScaleX = 1552;
const sal_Int32 XML_custScaleY = 1553;
const sal_Int32 XML_custShow = 1554;
const sal_Int32 XML_custShowLst = 1555;
const sal_Int32 XML_custSplit = 1556;
const sal_Int32 XML_custSzX = 1557;
const sal_Int32 XML_custSzY = 1558;
const sal_Int32 XML_custT = 1559;
const sal_Int32 XML_custTblOfContents = 1560;
const sal_Int32 XML_custTbls = 1561;
const sal_Int32 XML_custTxtBox = 1562;
const sal_Int32 XML_custUnit = 1563;
const sal_Int32 XML_custWatermarks = 1564;
const sal_Int32 XML_custom = 1565;
const sal_Int32 XML_custom1 = 1566;
const sal_Int32 XML_custom2 = 1567;
const sal_Int32 XML_custom3 = 1568;
const sal_Int32 XML_custom4 = 1569;
const sal_Int32 XML_custom5 = 1570;
const sal_Int32 XML_customBuiltin = 1571;
const sal_Int32 XML_customFilter = 1572;
const sal_Int32 XML_customFilters = 1573;
const sal_Int32 XML_customFormat = 1574;
const sal_Int32 XML_customHeight = 1575;
const sal_Int32 XML_customList = 1576;
const sal_Int32 XML_customListSort = 1577;
const sal_Int32 XML_customMarkFollows = 1578;
const sal_Int32 XML_customMenu = 1579;
const sal_Int32 XML_customPr = 1580;
const sal_Int32 XML_customProperties = 1581;
const sal_Int32 XML_customRollUp = 1582;
const sal_Int32 XML_customSheetView = 1583;
const sal_Int32 XML_customSheetViews = 1584;
const sal_Int32 XML_customStyle = 1585;
const sal_Int32 XML_customView = 1586;
const sal_Int32 XML_customWidth = 1587;
const sal_Int32 XML_customWorkbookView = 1588;
const sal_Int32 XML_customWorkbookViews = 1589;
const sal_Int32 XML_customXml = 1590;
const sal_Int32 XML_customXmlDelRangeEnd = 1591;
const sal_Int32 XML_customXmlDelRangeStart = 1592;
const sal_Int32 XML_customXmlInsRangeEnd = 1593;
const sal_Int32 XML_customXmlInsRangeStart = 1594;
const sal_Int32 XML_customXmlMoveFromRangeEnd = 1595;
const sal_Int32 XML_customXmlMoveFromRangeStart = 1596;
const sal_Int32 XML_customXmlMoveToRangeEnd = 1597;
const sal_Int32 XML_customXmlMoveToRangeStart = 1598;
const sal_Int32 XML_customXmlPr = 1599;
const sal_Int32 XML_cut = 1600;
const sal_Int32 XML_cw = 1601;
const sal_Int32 XML_cwIn = 1602;
const sal_Int32 XML_cwOut = 1603;
const sal_Int32 XML_cx = 1604;
const sal_Int32 XML_cx1 = 1605;
const sal_Int32 XML_cx2 = 1606;
const sal_Int32 XML_cx4 = 1607;
const sal_Int32 XML_cxn = 1608;
const sal_Int32 XML_cxnId = 1609;
const sal_Int32 XML_cxnLst = 1610;
const sal_Int32 XML_cxnSp = 1611;
const sal_Int32 XML_cxnSpLocks = 1612;
const sal_Int32 XML_cy = 1613;
const sal_Int32 XML_cyan = 1614;
const sal_Int32 XML_cycle = 1615;
const sal_Int32 XML_cylinder = 1616;
const sal_Int32 XML_d = 1617;
const sal_Int32 XML_dLbl = 1618;
const sal_Int32 XML_dLblPos = 1619;
const sal_Int32 XML_dLbls = 1620;
const sal_Int32 XML_dPr = 1621;
const sal_Int32 XML_dPt = 1622;
const sal_Int32 XML_dTable = 1623;
const sal_Int32 XML_dark1 = 1624;
const sal_Int32 XML_dark2 = 1625;
const sal_Int32 XML_darkBlue = 1626;
const sal_Int32 XML_darkCyan = 1627;
const sal_Int32 XML_darkDown = 1628;
const sal_Int32 XML_darkGray = 1629;
const sal_Int32 XML_darkGreen = 1630;
const sal_Int32 XML_darkGrid = 1631;
const sal_Int32 XML_darkHorizontal = 1632;
const sal_Int32 XML_darkMagenta = 1633;
const sal_Int32 XML_darkRed = 1634;
const sal_Int32 XML_darkTrellis = 1635;
const sal_Int32 XML_darkUp = 1636;
const sal_Int32 XML_darkVertical = 1637;
const sal_Int32 XML_darkYellow = 1638;
const sal_Int32 XML_darken = 1639;
const sal_Int32 XML_darkenLess = 1640;
const sal_Int32 XML_dash = 1641;
const sal_Int32 XML_dashDnDiag = 1642;
const sal_Int32 XML_dashDot = 1643;
const sal_Int32 XML_dashDotDot = 1644;
const sal_Int32 XML_dashDotDotHeavy = 1645;
const sal_Int32 XML_dashDotHeavy = 1646;
const sal_Int32 XML_dashDotStroked = 1647;
const sal_Int32 XML_dashHeavy = 1648;
const sal_Int32 XML_dashHorz = 1649;
const sal_Int32 XML_dashLong = 1650;
const sal_Int32 XML_dashLongHeavy = 1651;
const sal_Int32 XML_dashSmallGap = 1652;
const sal_Int32 XML_dashUpDiag = 1653;
const sal_Int32 XML_dashVert = 1654;
const sal_Int32 XML_dashdot = 1655;
const sal_Int32 XML_dashed = 1656;
const sal_Int32 XML_dashedHeavy = 1657;
const sal_Int32 XML_dashedSmall = 1658;
const sal_Int32 XML_dashstyle = 1659;
const sal_Int32 XML_data = 1660;
const sal_Int32 XML_dataBar = 1661;
const sal_Int32 XML_dataBinding = 1662;
const sal_Int32 XML_dataBound = 1663;
const sal_Int32 XML_dataCaption = 1664;
const sal_Int32 XML_dataCellStyle = 1665;
const sal_Int32 XML_dataConsolidate = 1666;
const sal_Int32 XML_dataDxfId = 1667;
const sal_Int32 XML_dataExtractLoad = 1668;
const sal_Int32 XML_dataField = 1669;
const sal_Int32 XML_dataFields = 1670;
const sal_Int32 XML_dataId = 1671;
const sal_Int32 XML_dataLabel = 1672;
const sal_Int32 XML_dataLabelCallout = 1673;
const sal_Int32 XML_dataLabels = 1674;
const sal_Int32 XML_dataModel = 1675;
const sal_Int32 XML_dataModelExt = 1676;
const sal_Int32 XML_dataOnRows = 1677;
const sal_Int32 XML_dataOnly = 1678;
const sal_Int32 XML_dataPoint = 1679;
const sal_Int32 XML_dataPoint3D = 1680;
const sal_Int32 XML_dataPointLine = 1681;
const sal_Int32 XML_dataPointMarker = 1682;
const sal_Int32 XML_dataPointMarkerLayout = 1683;
const sal_Int32 XML_dataPointWireframe = 1684;
const sal_Int32 XML_dataPosition = 1685;
const sal_Int32 XML_dataPt = 1686;
const sal_Int32 XML_dataRef = 1687;
const sal_Int32 XML_dataRefs = 1688;
const sal_Int32 XML_dataSource = 1689;
const sal_Int32 XML_dataSourceSort = 1690;
const sal_Int32 XML_dataTable = 1691;
const sal_Int32 XML_dataType = 1692;
const sal_Int32 XML_dataValidation = 1693;
const sal_Int32 XML_dataValidations = 1694;
const sal_Int32 XML_database = 1695;
const sal_Int32 XML_databaseField = 1696;
const sal_Int32 XML_datalabelsRange = 1697;
const sal_Int32 XML_datastoreItem = 1698;
const sal_Int32 XML_date = 1699;
const sal_Int32 XML_date1904 = 1700;
const sal_Int32 XML_dateAx = 1701;
const sal_Int32 XML_dateAxis = 1702;
const sal_Int32 XML_dateBetween = 1703;
const sal_Int32 XML_dateCompatibility = 1704;
const sal_Int32 XML_dateEqual = 1705;
const sal_Int32 XML_dateFormat = 1706;
const sal_Int32 XML_dateGroupItem = 1707;
const sal_Int32 XML_dateNewerThan = 1708;
const sal_Int32 XML_dateNewerThanOrEqual = 1709;
const sal_Int32 XML_dateNotBetween = 1710;
const sal_Int32 XML_dateNotEqual = 1711;
const sal_Int32 XML_dateOlderThan = 1712;
const sal_Int32 XML_dateOlderThanOrEqual = 1713;
const sal_Int32 XML_dateTime = 1714;
const sal_Int32 XML_dateTimeGrouping = 1715;
const sal_Int32 XML_day = 1716;
const sal_Int32 XML_dayLong = 1717;
const sal_Int32 XML_dayShort = 1718;
const sal_Int32 XML_days = 1719;
const sal_Int32 XML_dbColumn = 1720;
const sal_Int32 XML_dbPr = 1721;
const sal_Int32 XML_dbl = 1722;
const sal_Int32 XML_dblStrike = 1723;
const sal_Int32 XML_dc = 1724;
const sal_Int32 XML_dcmitype = 1725;
const sal_Int32 XML_dcterms = 1726;
const sal_Int32 XML_ddList = 1727;
const sal_Int32 XML_ddeItem = 1728;
const sal_Int32 XML_ddeItems = 1729;
const sal_Int32 XML_ddeLink = 1730;
const sal_Int32 XML_ddeService = 1731;
const sal_Int32 XML_ddeTopic = 1732;
const sal_Int32 XML_dec = 1733;
const sal_Int32 XML_decagon = 1734;
const sal_Int32 XML_decel = 1735;
const sal_Int32 XML_decimal = 1736;
const sal_Int32 XML_decimalEnclosedCircle = 1737;
const sal_Int32 XML_decimalEnclosedCircleChinese = 1738;
const sal_Int32 XML_decimalEnclosedFullstop = 1739;
const sal_Int32 XML_decimalEnclosedParen = 1740;
const sal_Int32 XML_decimalFullWidth = 1741;
const sal_Int32 XML_decimalFullWidth2 = 1742;
const sal_Int32 XML_decimalHalfWidth = 1743;
const sal_Int32 XML_decimalSymbol = 1744;
const sal_Int32 XML_decimalZero = 1745;
const sal_Int32 XML_decoArch = 1746;
const sal_Int32 XML_decoArchColor = 1747;
const sal_Int32 XML_decoBlocks = 1748;
const sal_Int32 XML_decorated = 1749;
const sal_Int32 XML_decorative = 1750;
const sal_Int32 XML_deepPink = 1751;
const sal_Int32 XML_deepSkyBlue = 1752;
const sal_Int32 XML_def = 1753;
const sal_Int32 XML_defJc = 1754;
const sal_Int32 XML_defLockedState = 1755;
const sal_Int32 XML_defPPr = 1756;
const sal_Int32 XML_defQFormat = 1757;
const sal_Int32 XML_defRPr = 1758;
const sal_Int32 XML_defSemiHidden = 1759;
const sal_Int32 XML_defStyle = 1760;
const sal_Int32 XML_defTabSz = 1761;
const sal_Int32 XML_defUIPriority = 1762;
const sal_Int32 XML_defUnhideWhenUsed = 1763;
const sal_Int32 XML_default = 1764;
const sal_Int32 XML_defaultAttributeDrillState = 1765;
const sal_Int32 XML_defaultColWidth = 1766;
const sal_Int32 XML_defaultGridColor = 1767;
const sal_Int32 XML_defaultMemberUniqueName = 1768;
const sal_Int32 XML_defaultPivotStyle = 1769;
const sal_Int32 XML_defaultRowHeight = 1770;
const sal_Int32 XML_defaultSize = 1771;
const sal_Int32 XML_defaultSubtotal = 1772;
const sal_Int32 XML_defaultTabStop = 1773;
const sal_Int32 XML_defaultTableStyle = 1774;
const sal_Int32 XML_defaultTextStyle = 1775;
const sal_Int32 XML_defaultThemeVersion = 1776;
const sal_Int32 XML_definedName = 1777;
const sal_Int32 XML_definedNames = 1778;
const sal_Int32 XML_deg = 1779;
const sal_Int32 XML_degHide = 1780;
const sal_Int32 XML_degree = 1781;
const sal_Int32 XML_del = 1782;
const sal_Int32 XML_del1 = 1783;
const sal_Int32 XML_del2 = 1784;
const sal_Int32 XML_delInstrText = 1785;
const sal_Int32 XML_delText = 1786;
const sal_Int32 XML_delay = 1787;
const sal_Int32 XML_delete = 1788;
const sal_Int32 XML_deleteCol = 1789;
const sal_Int32 XML_deleteColumns = 1790;
const sal_Int32 XML_deleteRow = 1791;
const sal_Int32 XML_deleteRows = 1792;
const sal_Int32 XML_deleted = 1793;
const sal_Int32 XML_deletedField = 1794;
const sal_Int32 XML_delimited = 1795;
const sal_Int32 XML_delimiter = 1796;
const sal_Int32 XML_den = 1797;
const sal_Int32 XML_denormalized = 1798;
const sal_Int32 XML_depth = 1799;
const sal_Int32 XML_depthByBranch = 1800;
const sal_Int32 XML_depthByNode = 1801;
const sal_Int32 XML_depthPercent = 1802;
const sal_Int32 XML_des = 1803;
const sal_Int32 XML_desOrSelf = 1804;
const sal_Int32 XML_desc = 1805;
const sal_Int32 XML_descending = 1806;
const sal_Int32 XML_descendingAlpha = 1807;
const sal_Int32 XML_descendingNatural = 1808;
const sal_Int32 XML_descr = 1809;
const sal_Int32 XML_description = 1810;
const sal_Int32 XML_destId = 1811;
const sal_Int32 XML_destOrd = 1812;
const sal_Int32 XML_destination = 1813;
const sal_Int32 XML_destinationFile = 1814;
const sal_Int32 XML_detail = 1815;
const sal_Int32 XML_detectmouseclick = 1816;
const sal_Int32 XML_dgm = 1817;
const sal_Int32 XML_dgmbasetextscale = 1818;
const sal_Int32 XML_dgmfontsize = 1819;
const sal_Int32 XML_dgmlayout = 1820;
const sal_Int32 XML_dgmlayoutmru = 1821;
const sal_Int32 XML_dgmnodekind = 1822;
const sal_Int32 XML_dgmscalex = 1823;
const sal_Int32 XML_dgmscaley = 1824;
const sal_Int32 XML_dgmstyle = 1825;
const sal_Int32 XML_diagBrick = 1826;
const sal_Int32 XML_diagCross = 1827;
const sal_Int32 XML_diagStripe = 1828;
const sal_Int32 XML_diagonal = 1829;
const sal_Int32 XML_diagonalDown = 1830;
const sal_Int32 XML_diagonalUp = 1831;
const sal_Int32 XML_diagram = 1832;
const sal_Int32 XML_dialogsheet = 1833;
const sal_Int32 XML_diam = 1834;
const sal_Int32 XML_diamond = 1835;
const sal_Int32 XML_diamondsGray = 1836;
const sal_Int32 XML_diff = 1837;
const sal_Int32 XML_difference = 1838;
const sal_Int32 XML_differentFirst = 1839;
const sal_Int32 XML_differentOddEven = 1840;
const sal_Int32 XML_diffusity = 1841;
const sal_Int32 XML_dim = 1842;
const sal_Int32 XML_dimGray = 1843;
const sal_Int32 XML_dimension = 1844;
const sal_Int32 XML_dimensionUniqueName = 1845;
const sal_Int32 XML_dimensions = 1846;
const sal_Int32 XML_dir = 1847;
const sal_Int32 XML_dirty = 1848;
const sal_Int32 XML_disableEdit = 1849;
const sal_Int32 XML_disableFieldList = 1850;
const sal_Int32 XML_disablePrompts = 1851;
const sal_Int32 XML_disableRefresh = 1852;
const sal_Int32 XML_disabled = 1853;
const sal_Int32 XML_discrete = 1854;
const sal_Int32 XML_discretePr = 1855;
const sal_Int32 XML_diskRevisions = 1856;
const sal_Int32 XML_dispBlanksAs = 1857;
const sal_Int32 XML_dispDef = 1858;
const sal_Int32 XML_dispEq = 1859;
const sal_Int32 XML_dispRSqr = 1860;
const sal_Int32 XML_dispUnits = 1861;
const sal_Int32 XML_dispUnitsLbl = 1862;
const sal_Int32 XML_displacedByCustomXml = 1863;
const sal_Int32 XML_display = 1864;
const sal_Int32 XML_displayBackgroundShape = 1865;
const sal_Int32 XML_displayEmptyCellsAs = 1866;
const sal_Int32 XML_displayFolder = 1867;
const sal_Int32 XML_displayHangulFixedWidth = 1868;
const sal_Int32 XML_displayHidden = 1869;
const sal_Int32 XML_displayHorizontalDrawingGridEvery = 1870;
const sal_Int32 XML_displayName = 1871;
const sal_Int32 XML_displayText = 1872;
const sal_Int32 XML_displayVerticalDrawingGridEvery = 1873;
const sal_Int32 XML_displayXAxis = 1874;
const sal_Int32 XML_displayed = 1875;
const sal_Int32 XML_dissolve = 1876;
const sal_Int32 XML_dist = 1877;
const sal_Int32 XML_distB = 1878;
const sal_Int32 XML_distL = 1879;
const sal_Int32 XML_distR = 1880;
const sal_Int32 XML_distT = 1881;
const sal_Int32 XML_distance = 1882;
const sal_Int32 XML_distribute = 1883;
const sal_Int32 XML_distributeLetter = 1884;
const sal_Int32 XML_distributeSpace = 1885;
const sal_Int32 XML_distributed = 1886;
const sal_Int32 XML_div = 1887;
const sal_Int32 XML_divBdr = 1888;
const sal_Int32 XML_divId = 1889;
const sal_Int32 XML_divot = 1890;
const sal_Int32 XML_divs = 1891;
const sal_Int32 XML_divsChild = 1892;
const sal_Int32 XML_dk1 = 1893;
const sal_Int32 XML_dk2 = 1894;
const sal_Int32 XML_dkBlue = 1895;
const sal_Int32 XML_dkCyan = 1896;
const sal_Int32 XML_dkDnDiag = 1897;
const sal_Int32 XML_dkEdge = 1898;
const sal_Int32 XML_dkGoldenrod = 1899;
const sal_Int32 XML_dkGray = 1900;
const sal_Int32 XML_dkGreen = 1901;
const sal_Int32 XML_dkHorz = 1902;
const sal_Int32 XML_dkKhaki = 1903;
const sal_Int32 XML_dkMagenta = 1904;
const sal_Int32 XML_dkOliveGreen = 1905;
const sal_Int32 XML_dkOrange = 1906;
const sal_Int32 XML_dkOrchid = 1907;
const sal_Int32 XML_dkRed = 1908;
const sal_Int32 XML_dkSalmon = 1909;
const sal_Int32 XML_dkSeaGreen = 1910;
const sal_Int32 XML_dkSlateBlue = 1911;
const sal_Int32 XML_dkSlateGray = 1912;
const sal_Int32 XML_dkTurquoise = 1913;
const sal_Int32 XML_dkUpDiag = 1914;
const sal_Int32 XML_dkVert = 1915;
const sal_Int32 XML_dkViolet = 1916;
const sal_Int32 XML_dlblRangeCache = 1917;
const sal_Int32 XML_dllVersion = 1918;
const sal_Int32 XML_dm = 1919;
const sal_Int32 XML_dn = 1920;
const sal_Int32 XML_dnDiag = 1921;
const sal_Int32 XML_doNotAutoCompressPictures = 1922;
const sal_Int32 XML_doNotAutofitConstrainedTables = 1923;
const sal_Int32 XML_doNotBreakConstrainedForcedTable = 1924;
const sal_Int32 XML_doNotBreakWrappedTables = 1925;
const sal_Int32 XML_doNotCompress = 1926;
const sal_Int32 XML_doNotDemarcateInvalidXml = 1927;
const sal_Int32 XML_doNotDisplayPageBoundaries = 1928;
const sal_Int32 XML_doNotEmbedSmartTags = 1929;
const sal_Int32 XML_doNotExpandShiftReturn = 1930;
const sal_Int32 XML_doNotHyphenateCaps = 1931;
const sal_Int32 XML_doNotIncludeSubdocsInStats = 1932;
const sal_Int32 XML_doNotLeaveBackslashAlone = 1933;
const sal_Int32 XML_doNotOrganizeInFolder = 1934;
const sal_Int32 XML_doNotRelyOnCSS = 1935;
const sal_Int32 XML_doNotSaveAsSingleFile = 1936;
const sal_Int32 XML_doNotShadeFormData = 1937;
const sal_Int32 XML_doNotSnapToGridInCell = 1938;
const sal_Int32 XML_doNotSuppressBlankLines = 1939;
const sal_Int32 XML_doNotSuppressIndentation = 1940;
const sal_Int32 XML_doNotSuppressParagraphBorders = 1941;
const sal_Int32 XML_doNotTrackFormatting = 1942;
const sal_Int32 XML_doNotTrackMoves = 1943;
const sal_Int32 XML_doNotUseEastAsianBreakRules = 1944;
const sal_Int32 XML_doNotUseHTMLParagraphAutoSpacing = 1945;
const sal_Int32 XML_doNotUseIndentAsNumberingTabStop = 1946;
const sal_Int32 XML_doNotUseLongFileNames = 1947;
const sal_Int32 XML_doNotUseMarginsForDrawingGridOrigin = 1948;
const sal_Int32 XML_doNotValidateAgainstSchema = 1949;
const sal_Int32 XML_doNotVertAlignCellWithSp = 1950;
const sal_Int32 XML_doNotVertAlignInTxbx = 1951;
const sal_Int32 XML_doNotWrapTextWithPunct = 1952;
const sal_Int32 XML_done = 1953;
const sal_Int32 XML_doc = 1954;
const sal_Int32 XML_docDefaults = 1955;
const sal_Int32 XML_docEnd = 1956;
const sal_Int32 XML_docGrid = 1957;
const sal_Int32 XML_docLocation = 1958;
const sal_Int32 XML_docPart = 1959;
const sal_Int32 XML_docPartBody = 1960;
const sal_Int32 XML_docPartCategory = 1961;
const sal_Int32 XML_docPartGallery = 1962;
const sal_Int32 XML_docPartList = 1963;
const sal_Int32 XML_docPartObj = 1964;
const sal_Int32 XML_docPartPr = 1965;
const sal_Int32 XML_docPartUnique = 1966;
const sal_Int32 XML_docParts = 1967;
const sal_Int32 XML_docPr = 1968;
const sal_Int32 XML_docVar = 1969;
const sal_Int32 XML_docVars = 1970;
const sal_Int32 XML_document = 1971;
const sal_Int32 XML_document1 = 1972;
const sal_Int32 XML_document2 = 1973;
const sal_Int32 XML_documentProtection = 1974;
const sal_Int32 XML_documentType = 1975;
const sal_Int32 XML_dodecagon = 1976;
const sal_Int32 XML_dodgerBlue = 1977;
const sal_Int32 XML_donut = 1978;
const sal_Int32 XML_doors = 1979;
const sal_Int32 XML_dos = 1980;
const sal_Int32 XML_dot = 1981;
const sal_Int32 XML_dotDash = 1982;
const sal_Int32 XML_dotDashHeavy = 1983;
const sal_Int32 XML_dotDmnd = 1984;
const sal_Int32 XML_dotDotDash = 1985;
const sal_Int32 XML_dotDotDashHeavy = 1986;
const sal_Int32 XML_dotGrid = 1987;
const sal_Int32 XML_dotted = 1988;
const sal_Int32 XML_dottedHeavy = 1989;
const sal_Int32 XML_double = 1990;
const sal_Int32 XML_double_struck = 1991;
const sal_Int32 XML_doubleAccounting = 1992;
const sal_Int32 XML_doubleD = 1993;
const sal_Int32 XML_doubleDiamonds = 1994;
const sal_Int32 XML_doubleQuote = 1995;
const sal_Int32 XML_doubleWave = 1996;
const sal_Int32 XML_doubleclicknotify = 1997;
const sal_Int32 XML_doughnutChart = 1998;
const sal_Int32 XML_down = 1999;
const sal_Int32 XML_downArrow = 2000;
const sal_Int32 XML_downArrowCallout = 2001;
const sal_Int32 XML_downBar = 2002;
const sal_Int32 XML_downBars = 2003;
const sal_Int32 XML_downThenOver = 2004;
const sal_Int32 XML_dpi = 2005;
const sal_Int32 XML_dr = 2006;
const sal_Int32 XML_draft = 2007;
const sal_Int32 XML_dragOff = 2008;
const sal_Int32 XML_dragToCol = 2009;
const sal_Int32 XML_dragToData = 2010;
const sal_Int32 XML_dragToPage = 2011;
const sal_Int32 XML_dragToRow = 2012;
const sal_Int32 XML_drawing = 2013;
const sal_Int32 XML_drawingGridHorizontalOrigin = 2014;
const sal_Int32 XML_drawingGridHorizontalSpacing = 2015;
const sal_Int32 XML_drawingGridVerticalOrigin = 2016;
const sal_Int32 XML_drawingGridVerticalSpacing = 2017;
const sal_Int32 XML_drill = 2018;
const sal_Int32 XML_drop = 2019;
const sal_Int32 XML_dropCap = 2020;
const sal_Int32 XML_dropDownList = 2021;
const sal_Int32 XML_dropLine = 2022;
const sal_Int32 XML_dropLines = 2023;
const sal_Int32 XML_dropauto = 2024;
const sal_Int32 XML_ds = 2025;
const sal_Int32 XML_dstNode = 2026;
const sal_Int32 XML_dstrike = 2027;
const sal_Int32 XML_dt = 2028;
const sal_Int32 XML_dt2D = 2029;
const sal_Int32 XML_dtr = 2030;
const sal_Int32 XML_duotone = 2031;
const sal_Int32 XML_duplicateValues = 2032;
const sal_Int32 XML_dur = 2033;
const sal_Int32 XML_duration = 2034;
const sal_Int32 XML_dvAspect = 2035;
const sal_Int32 XML_dx = 2036;
const sal_Int32 XML_dxa = 2037;
const sal_Int32 XML_dxaOrig = 2038;
const sal_Int32 XML_dxf = 2039;
const sal_Int32 XML_dxfId = 2040;
const sal_Int32 XML_dxfs = 2041;
const sal_Int32 XML_dy = 2042;
const sal_Int32 XML_dyaOrig = 2043;
const sal_Int32 XML_dynamicAddress = 2044;
const sal_Int32 XML_dynamicFilter = 2045;
const sal_Int32 XML_dz = 2046;
const sal_Int32 XML_e = 2047;
const sal_Int32 XML_eMail = 2048;
const sal_Int32 XML_ea = 2049;
const sal_Int32 XML_ea1ChsPeriod = 2050;
const sal_Int32 XML_ea1ChsPlain = 2051;
const sal_Int32 XML_ea1ChtPeriod = 2052;
const sal_Int32 XML_ea1ChtPlain = 2053;
const sal_Int32 XML_ea1JpnChsDbPeriod = 2054;
const sal_Int32 XML_ea1JpnKorPeriod = 2055;
const sal_Int32 XML_ea1JpnKorPlain = 2056;
const sal_Int32 XML_eaLnBrk = 2057;
const sal_Int32 XML_eaVert = 2058;
const sal_Int32 XML_eachPage = 2059;
const sal_Int32 XML_eachSect = 2060;
const sal_Int32 XML_earth1 = 2061;
const sal_Int32 XML_earth2 = 2062;
const sal_Int32 XML_eastAsia = 2063;
const sal_Int32 XML_eastAsiaTheme = 2064;
const sal_Int32 XML_eastAsianLayout = 2065;
const sal_Int32 XML_eb = 2066;
const sal_Int32 XML_eclipsingSquares1 = 2067;
const sal_Int32 XML_eclipsingSquares2 = 2068;
const sal_Int32 XML_ed = 2069;
const sal_Int32 XML_edGrp = 2070;
const sal_Int32 XML_edge = 2071;
const sal_Int32 XML_edit = 2072;
const sal_Int32 XML_editAs = 2073;
const sal_Int32 XML_editData = 2074;
const sal_Int32 XML_editPage = 2075;
const sal_Int32 XML_editas = 2076;
const sal_Int32 XML_edited = 2077;
const sal_Int32 XML_editors = 2078;
const sal_Int32 XML_effect = 2079;
const sal_Int32 XML_effectClrLst = 2080;
const sal_Int32 XML_effectDag = 2081;
const sal_Int32 XML_effectExtent = 2082;
const sal_Int32 XML_effectLst = 2083;
const sal_Int32 XML_effectRef = 2084;
const sal_Int32 XML_effectStyle = 2085;
const sal_Int32 XML_effectStyleLst = 2086;
const sal_Int32 XML_eggsBlack = 2087;
const sal_Int32 XML_el = 2088;
const sal_Int32 XML_elbow = 2089;
const sal_Int32 XML_element = 2090;
const sal_Int32 XML_ellipse = 2091;
const sal_Int32 XML_ellipseRibbon = 2092;
const sal_Int32 XML_ellipseRibbon2 = 2093;
const sal_Int32 XML_ellipsis = 2094;
const sal_Int32 XML_else = 2095;
const sal_Int32 XML_em = 2096;
const sal_Int32 XML_emDash = 2097;
const sal_Int32 XML_email = 2098;
const sal_Int32 XML_embed = 2099;
const sal_Int32 XML_embedBold = 2100;
const sal_Int32 XML_embedBoldItalic = 2101;
const sal_Int32 XML_embedItalic = 2102;
const sal_Int32 XML_embedRegular = 2103;
const sal_Int32 XML_embedSystemFonts = 2104;
const sal_Int32 XML_embedTrueTypeFonts = 2105;
const sal_Int32 XML_embeddedFont = 2106;
const sal_Int32 XML_embeddedFontLst = 2107;
const sal_Int32 XML_emboss = 2108;
const sal_Int32 XML_embosscolor = 2109;
const sal_Int32 XML_emph = 2110;
const sal_Int32 XML_empty = 2111;
const sal_Int32 XML_emptyCellReference = 2112;
const sal_Int32 XML_enDash = 2113;
const sal_Int32 XML_enableDrill = 2114;
const sal_Int32 XML_enableFieldProperties = 2115;
const sal_Int32 XML_enableFormatConditionsCalculation = 2116;
const sal_Int32 XML_enableRefresh = 2117;
const sal_Int32 XML_enableWizard = 2118;
const sal_Int32 XML_enabled = 2119;
const sal_Int32 XML_encoding = 2120;
const sal_Int32 XML_end = 2121;
const sal_Int32 XML_endA = 2122;
const sal_Int32 XML_endAngle = 2123;
const sal_Int32 XML_endChars = 2124;
const sal_Int32 XML_endChr = 2125;
const sal_Int32 XML_endCnv = 2126;
const sal_Int32 XML_endCondLst = 2127;
const sal_Int32 XML_endCxn = 2128;
const sal_Int32 XML_endDate = 2129;
const sal_Int32 XML_endMarg = 2130;
const sal_Int32 XML_endNum = 2131;
const sal_Int32 XML_endOfListFormulaUpdate = 2132;
const sal_Int32 XML_endPad = 2133;
const sal_Int32 XML_endParaRPr = 2134;
const sal_Int32 XML_endPos = 2135;
const sal_Int32 XML_endPts = 2136;
const sal_Int32 XML_endSnd = 2137;
const sal_Int32 XML_endSty = 2138;
const sal_Int32 XML_endSync = 2139;
const sal_Int32 XML_endarrow = 2140;
const sal_Int32 XML_endarrowlength = 2141;
const sal_Int32 XML_endarrowwidth = 2142;
const sal_Int32 XML_endcap = 2143;
const sal_Int32 XML_endnote = 2144;
const sal_Int32 XML_endnotePr = 2145;
const sal_Int32 XML_endnoteRef = 2146;
const sal_Int32 XML_endnoteReference = 2147;
const sal_Int32 XML_endnotes = 2148;
const sal_Int32 XML_endsWith = 2149;
const sal_Int32 XML_enforcement = 2150;
const sal_Int32 XML_entr = 2151;
const sal_Int32 XML_entries = 2152;
const sal_Int32 XML_entry = 2153;
const sal_Int32 XML_entryMacro = 2154;
const sal_Int32 XML_envelopes = 2155;
const sal_Int32 XML_eol = 2156;
const sal_Int32 XML_eq = 2157;
const sal_Int32 XML_eqArr = 2158;
const sal_Int32 XML_eqArrPr = 2159;
const sal_Int32 XML_eqn = 2160;
const sal_Int32 XML_equ = 2161;
const sal_Int32 XML_equal = 2162;
const sal_Int32 XML_equalAverage = 2163;
const sal_Int32 XML_equalWidth = 2164;
const sal_Int32 XML_equation = 2165;
const sal_Int32 XML_equationxml = 2166;
const sal_Int32 XML_err = 2167;
const sal_Int32 XML_errBarType = 2168;
const sal_Int32 XML_errBars = 2169;
const sal_Int32 XML_errDir = 2170;
const sal_Int32 XML_errValType = 2171;
const sal_Int32 XML_error = 2172;
const sal_Int32 XML_errorBar = 2173;
const sal_Int32 XML_errorCaption = 2174;
const sal_Int32 XML_errorStyle = 2175;
const sal_Int32 XML_errorTitle = 2176;
const sal_Int32 XML_errors = 2177;
const sal_Int32 XML_evalError = 2178;
const sal_Int32 XML_evalOrder = 2179;
const sal_Int32 XML_even = 2180;
const sal_Int32 XML_evenAndOddHeaders = 2181;
const sal_Int32 XML_evenFooter = 2182;
const sal_Int32 XML_evenHBand = 2183;
const sal_Int32 XML_evenHeader = 2184;
const sal_Int32 XML_evenPage = 2185;
const sal_Int32 XML_evenVBand = 2186;
const sal_Int32 XML_everyone = 2187;
const sal_Int32 XML_evt = 2188;
const sal_Int32 XML_evtFilter = 2189;
const sal_Int32 XML_exact = 2190;
const sal_Int32 XML_excl = 2191;
const sal_Int32 XML_exclusive = 2192;
const sal_Int32 XML_exit = 2193;
const sal_Int32 XML_exitMacro = 2194;
const sal_Int32 XML_exp = 2195;
const sal_Int32 XML_explosion = 2196;
const sal_Int32 XML_expression = 2197;
const sal_Int32 XML_ext = 2198;
const sal_Int32 XML_extCalcPr = 2199;
const sal_Int32 XML_extLst = 2200;
const sal_Int32 XML_extend = 2201;
const sal_Int32 XML_extendable = 2202;
const sal_Int32 XML_extent = 2203;
const sal_Int32 XML_external = 2204;
const sal_Int32 XML_externalBook = 2205;
const sal_Int32 XML_externalData = 2206;
const sal_Int32 XML_externalLink = 2207;
const sal_Int32 XML_externalReference = 2208;
const sal_Int32 XML_externalReferences = 2209;
const sal_Int32 XML_extraClrScheme = 2210;
const sal_Int32 XML_extraClrSchemeLst = 2211;
const sal_Int32 XML_extrusion = 2212;
const sal_Int32 XML_extrusionClr = 2213;
const sal_Int32 XML_extrusionH = 2214;
const sal_Int32 XML_extrusionOk = 2215;
const sal_Int32 XML_extrusioncolor = 2216;
const sal_Int32 XML_extrusionok = 2217;
const sal_Int32 XML_f = 2218;
const sal_Int32 XML_fHdr = 2219;
const sal_Int32 XML_fLocksText = 2220;
const sal_Int32 XML_fLocksWithSheet = 2221;
const sal_Int32 XML_fName = 2222;
const sal_Int32 XML_fNode = 2223;
const sal_Int32 XML_fPr = 2224;
const sal_Int32 XML_fPrintsWithSheet = 2225;
const sal_Int32 XML_fPublished = 2226;
const sal_Int32 XML_face = 2227;
const sal_Int32 XML_facet = 2228;
const sal_Int32 XML_fact = 2229;
const sal_Int32 XML_factor = 2230;
const sal_Int32 XML_fade = 2231;
const sal_Int32 XML_fadeDir = 2232;
const sal_Int32 XML_fallback = 2233;
const sal_Int32 XML_false = 2234;
const sal_Int32 XML_family = 2235;
const sal_Int32 XML_fans = 2236;
const sal_Int32 XML_fast = 2237;
const sal_Int32 XML_fax = 2238;
const sal_Int32 XML_fc = 2239;
const sal_Int32 XML_ferris = 2240;
const sal_Int32 XML_ffData = 2241;
const sal_Int32 XML_fgClr = 2242;
const sal_Int32 XML_fgColor = 2243;
const sal_Int32 XML_fi = 2244;
const sal_Int32 XML_field = 2245;
const sal_Int32 XML_fieldGroup = 2246;
const sal_Int32 XML_fieldId = 2247;
const sal_Int32 XML_fieldIdWrapped = 2248;
const sal_Int32 XML_fieldListSortAscending = 2249;
const sal_Int32 XML_fieldMapData = 2250;
const sal_Int32 XML_fieldPosition = 2251;
const sal_Int32 XML_fieldPrintTitles = 2252;
const sal_Int32 XML_fieldUsage = 2253;
const sal_Int32 XML_fieldsUsage = 2254;
const sal_Int32 XML_fileRecoveryPr = 2255;
const sal_Int32 XML_fileSharing = 2256;
const sal_Int32 XML_fileType = 2257;
const sal_Int32 XML_fileVersion = 2258;
const sal_Int32 XML_filetime = 2259;
const sal_Int32 XML_fill = 2260;
const sal_Int32 XML_fillColor = 2261;
const sal_Int32 XML_fillClrLst = 2262;
const sal_Int32 XML_fillFormulas = 2263;
const sal_Int32 XML_fillId = 2264;
const sal_Int32 XML_fillOverlay = 2265;
const sal_Int32 XML_fillRect = 2266;
const sal_Int32 XML_fillRef = 2267;
const sal_Int32 XML_fillStyleLst = 2268;
const sal_Int32 XML_fillToRect = 2269;
const sal_Int32 XML_fillcolor = 2270;
const sal_Int32 XML_filled = 2271;
const sal_Int32 XML_fillok = 2272;
const sal_Int32 XML_fills = 2273;
const sal_Int32 XML_filltype = 2274;
const sal_Int32 XML_film = 2275;
const sal_Int32 XML_filter = 2276;
const sal_Int32 XML_filterColumn = 2277;
const sal_Int32 XML_filterMode = 2278;
const sal_Int32 XML_filterPrivacy = 2279;
const sal_Int32 XML_filterUnique = 2280;
const sal_Int32 XML_filterVal = 2281;
const sal_Int32 XML_filters = 2282;
const sal_Int32 XML_firebrick = 2283;
const sal_Int32 XML_firecrackers = 2284;
const sal_Int32 XML_first = 2285;
const sal_Int32 XML_firstAndLastLine = 2286;
const sal_Int32 XML_firstBackgroundRefresh = 2287;
const sal_Int32 XML_firstCol = 2288;
const sal_Int32 XML_firstColumn = 2289;
const sal_Int32 XML_firstColumnStripe = 2290;
const sal_Int32 XML_firstColumnSubheading = 2291;
const sal_Int32 XML_firstDataCol = 2292;
const sal_Int32 XML_firstDataRow = 2293;
const sal_Int32 XML_firstFooter = 2294;
const sal_Int32 XML_firstHeader = 2295;
const sal_Int32 XML_firstHeaderCell = 2296;
const sal_Int32 XML_firstHeaderRow = 2297;
const sal_Int32 XML_firstLine = 2298;
const sal_Int32 XML_firstLineChars = 2299;
const sal_Int32 XML_firstLineOnly = 2300;
const sal_Int32 XML_firstPage = 2301;
const sal_Int32 XML_firstPageNumber = 2302;
const sal_Int32 XML_firstRow = 2303;
const sal_Int32 XML_firstRowFirstColumn = 2304;
const sal_Int32 XML_firstRowLastColumn = 2305;
const sal_Int32 XML_firstRowStripe = 2306;
const sal_Int32 XML_firstRowSubheading = 2307;
const sal_Int32 XML_firstSheet = 2308;
const sal_Int32 XML_firstSliceAng = 2309;
const sal_Int32 XML_firstSlideNum = 2310;
const sal_Int32 XML_firstSubtotalColumn = 2311;
const sal_Int32 XML_firstSubtotalRow = 2312;
const sal_Int32 XML_firstTotalCell = 2313;
const sal_Int32 XML_fitText = 2314;
const sal_Int32 XML_fitToHeight = 2315;
const sal_Int32 XML_fitToPage = 2316;
const sal_Int32 XML_fitToSlide = 2317;
const sal_Int32 XML_fitToWidth = 2318;
const sal_Int32 XML_fitpath = 2319;
const sal_Int32 XML_fitshape = 2320;
const sal_Int32 XML_fixed = 2321;
const sal_Int32 XML_fixedVal = 2322;
const sal_Int32 XML_flash = 2323;
const sal_Int32 XML_flat = 2324;
const sal_Int32 XML_flatBorders = 2325;
const sal_Int32 XML_flatTx = 2326;
const sal_Int32 XML_fld = 2327;
const sal_Int32 XML_fldChar = 2328;
const sal_Int32 XML_fldCharType = 2329;
const sal_Int32 XML_fldData = 2330;
const sal_Int32 XML_fldLock = 2331;
const sal_Int32 XML_fldSimple = 2332;
const sal_Int32 XML_flip = 2333;
const sal_Int32 XML_flipH = 2334;
const sal_Int32 XML_flipV = 2335;
const sal_Int32 XML_float = 2336;
const sal_Int32 XML_flood = 2337;
const sal_Int32 XML_floor = 2338;
const sal_Int32 XML_floralWhite = 2339;
const sal_Int32 XML_flowChartAlternateProcess = 2340;
const sal_Int32 XML_flowChartCollate = 2341;
const sal_Int32 XML_flowChartConnector = 2342;
const sal_Int32 XML_flowChartDecision = 2343;
const sal_Int32 XML_flowChartDelay = 2344;
const sal_Int32 XML_flowChartDisplay = 2345;
const sal_Int32 XML_flowChartDocument = 2346;
const sal_Int32 XML_flowChartExtract = 2347;
const sal_Int32 XML_flowChartInputOutput = 2348;
const sal_Int32 XML_flowChartInternalStorage = 2349;
const sal_Int32 XML_flowChartMagneticDisk = 2350;
const sal_Int32 XML_flowChartMagneticDrum = 2351;
const sal_Int32 XML_flowChartMagneticTape = 2352;
const sal_Int32 XML_flowChartManualInput = 2353;
const sal_Int32 XML_flowChartManualOperation = 2354;
const sal_Int32 XML_flowChartMerge = 2355;
const sal_Int32 XML_flowChartMultidocument = 2356;
const sal_Int32 XML_flowChartOfflineStorage = 2357;
const sal_Int32 XML_flowChartOffpageConnector = 2358;
const sal_Int32 XML_flowChartOnlineStorage = 2359;
const sal_Int32 XML_flowChartOr = 2360;
const sal_Int32 XML_flowChartPredefinedProcess = 2361;
const sal_Int32 XML_flowChartPreparation = 2362;
const sal_Int32 XML_flowChartProcess = 2363;
const sal_Int32 XML_flowChartPunchedCard = 2364;
const sal_Int32 XML_flowChartPunchedTape = 2365;
const sal_Int32 XML_flowChartSort = 2366;
const sal_Int32 XML_flowChartSummingJunction = 2367;
const sal_Int32 XML_flowChartTerminator = 2368;
const sal_Int32 XML_flowDir = 2369;
const sal_Int32 XML_flowersBlockPrint = 2370;
const sal_Int32 XML_flowersDaisies = 2371;
const sal_Int32 XML_flowersModern1 = 2372;
const sal_Int32 XML_flowersModern2 = 2373;
const sal_Int32 XML_flowersPansy = 2374;
const sal_Int32 XML_flowersRedRose = 2375;
const sal_Int32 XML_flowersRoses = 2376;
const sal_Int32 XML_flowersTeacup = 2377;
const sal_Int32 XML_flowersTiny = 2378;
const sal_Int32 XML_fltVal = 2379;
const sal_Int32 XML_flythrough = 2380;
const sal_Int32 XML_fmla = 2381;
const sal_Int32 XML_fmt = 2382;
const sal_Int32 XML_fmtId = 2383;
const sal_Int32 XML_fmtOvrs = 2384;
const sal_Int32 XML_fmtScheme = 2385;
const sal_Int32 XML_fmtid = 2386;
const sal_Int32 XML_focus = 2387;
const sal_Int32 XML_focusposition = 2388;
const sal_Int32 XML_focussize = 2389;
const sal_Int32 XML_folHlink = 2390;
const sal_Int32 XML_foldedCorner = 2391;
const sal_Int32 XML_follow = 2392;
const sal_Int32 XML_followColorScheme = 2393;
const sal_Int32 XML_followSib = 2394;
const sal_Int32 XML_followedHyperlink = 2395;
const sal_Int32 XML_font = 2396;
const sal_Int32 XML_font4 = 2397;
const sal_Int32 XML_fontAlgn = 2398;
const sal_Int32 XML_fontColor = 2399;
const sal_Int32 XML_fontId = 2400;
const sal_Int32 XML_fontKey = 2401;
const sal_Int32 XML_fontRef = 2402;
const sal_Int32 XML_fontScale = 2403;
const sal_Int32 XML_fontScheme = 2404;
const sal_Int32 XML_fontSz = 2405;
const sal_Int32 XML_fonts = 2406;
const sal_Int32 XML_footer = 2407;
const sal_Int32 XML_footerReference = 2408;
const sal_Int32 XML_footnote = 2409;
const sal_Int32 XML_footnoteLayoutLikeWW8 = 2410;
const sal_Int32 XML_footnotePr = 2411;
const sal_Int32 XML_footnoteRef = 2412;
const sal_Int32 XML_footnoteReference = 2413;
const sal_Int32 XML_footnotes = 2414;
const sal_Int32 XML_for = 2415;
const sal_Int32 XML_forEach = 2416;
const sal_Int32 XML_forName = 2417;
const sal_Int32 XML_forceAA = 2418;
const sal_Int32 XML_forceFullCalc = 2419;
const sal_Int32 XML_forceUpgrade = 2420;
const sal_Int32 XML_forcedash = 2421;
const sal_Int32 XML_foredepth = 2422;
const sal_Int32 XML_forestGreen = 2423;
const sal_Int32 XML_forgetLastTabAlignment = 2424;
const sal_Int32 XML_formControlPr = 2425;
const sal_Int32 XML_formFld = 2426;
const sal_Int32 XML_formLetters = 2427;
const sal_Int32 XML_formProt = 2428;
const sal_Int32 XML_format = 2429;
const sal_Int32 XML_formatCells = 2430;
const sal_Int32 XML_formatCode = 2431;
const sal_Int32 XML_formatColumns = 2432;
const sal_Int32 XML_formatRows = 2433;
const sal_Int32 XML_formats = 2434;
const sal_Int32 XML_formatting = 2435;
const sal_Int32 XML_forms = 2436;
const sal_Int32 XML_formsDesign = 2437;
const sal_Int32 XML_formula = 2438;
const sal_Int32 XML_formula1 = 2439;
const sal_Int32 XML_formula2 = 2440;
const sal_Int32 XML_formulaRange = 2441;
const sal_Int32 XML_formulas = 2442;
const sal_Int32 XML_forward = 2443;
const sal_Int32 XML_fourObj = 2444;
const sal_Int32 XML_fov = 2445;
const sal_Int32 XML_fraktur = 2446;
const sal_Int32 XML_frame = 2447;
const sal_Int32 XML_frameLayout = 2448;
const sal_Int32 XML_framePr = 2449;
const sal_Int32 XML_frameSlides = 2450;
const sal_Int32 XML_frameStyle1 = 2451;
const sal_Int32 XML_frameStyle2 = 2452;
const sal_Int32 XML_frameStyle3 = 2453;
const sal_Int32 XML_frameStyle4 = 2454;
const sal_Int32 XML_frameStyle5 = 2455;
const sal_Int32 XML_frameStyle6 = 2456;
const sal_Int32 XML_frameStyle7 = 2457;
const sal_Int32 XML_frameset = 2458;
const sal_Int32 XML_framesetSplitbar = 2459;
const sal_Int32 XML_freeze = 2460;
const sal_Int32 XML_freezing = 2461;
const sal_Int32 XML_from = 2462;
const sal_Int32 XML_fromB = 2463;
const sal_Int32 XML_fromL = 2464;
const sal_Int32 XML_fromR = 2465;
const sal_Int32 XML_fromT = 2466;
const sal_Int32 XML_fromWordArt = 2467;
const sal_Int32 XML_front = 2468;
const sal_Int32 XML_frozen = 2469;
const sal_Int32 XML_frozenSplit = 2470;
const sal_Int32 XML_ftr = 2471;
const sal_Int32 XML_ftrs = 2472;
const sal_Int32 XML_fuchsia = 2473;
const sal_Int32 XML_full = 2474;
const sal_Int32 XML_fullAlpha = 2475;
const sal_Int32 XML_fullCalcOnLoad = 2476;
const sal_Int32 XML_fullDate = 2477;
const sal_Int32 XML_fullHangul = 2478;
const sal_Int32 XML_fullKatakana = 2479;
const sal_Int32 XML_fullPage = 2480;
const sal_Int32 XML_fullPrecision = 2481;
const sal_Int32 XML_fullScrn = 2482;
const sal_Int32 XML_fullwidthKatakana = 2483;
const sal_Int32 XML_func = 2484;
const sal_Int32 XML_funcPr = 2485;
const sal_Int32 XML_function = 2486;
const sal_Int32 XML_functionGroup = 2487;
const sal_Int32 XML_functionGroupId = 2488;
const sal_Int32 XML_functionGroups = 2489;
const sal_Int32 XML_funnel = 2490;
const sal_Int32 XML_futureMetadata = 2491;
const sal_Int32 XML_g = 2492;
const sal_Int32 XML_gDay = 2493;
const sal_Int32 XML_gMonth = 2494;
const sal_Int32 XML_gMonthDay = 2495;
const sal_Int32 XML_gYear = 2496;
const sal_Int32 XML_gYearMonth = 2497;
const sal_Int32 XML_gain = 2498;
const sal_Int32 XML_gainsboro = 2499;
const sal_Int32 XML_gallery = 2500;
const sal_Int32 XML_gamma = 2501;
const sal_Int32 XML_ganada = 2502;
const sal_Int32 XML_gap = 2503;
const sal_Int32 XML_gapDepth = 2504;
const sal_Int32 XML_gapWidth = 2505;
const sal_Int32 XML_gd = 2506;
const sal_Int32 XML_gdLst = 2507;
const sal_Int32 XML_gdRefAng = 2508;
const sal_Int32 XML_gdRefR = 2509;
const sal_Int32 XML_gdRefX = 2510;
const sal_Int32 XML_gdRefY = 2511;
const sal_Int32 XML_ge = 2512;
const sal_Int32 XML_gear6 = 2513;
const sal_Int32 XML_gear9 = 2514;
const sal_Int32 XML_gems = 2515;
const sal_Int32 XML_general = 2516;
const sal_Int32 XML_gfxdata = 2517;
const sal_Int32 XML_ghostCol = 2518;
const sal_Int32 XML_ghostRow = 2519;
const sal_Int32 XML_ghostWhite = 2520;
const sal_Int32 XML_gingerbreadMan = 2521;
const sal_Int32 XML_glitter = 2522;
const sal_Int32 XML_glossaryDocument = 2523;
const sal_Int32 XML_glow = 2524;
const sal_Int32 XML_goal = 2525;
const sal_Int32 XML_gold = 2526;
const sal_Int32 XML_goldenrod = 2527;
const sal_Int32 XML_grDir = 2528;
const sal_Int32 XML_gradFill = 2529;
const sal_Int32 XML_gradient = 2530;
const sal_Int32 XML_gradientActiveCaption = 2531;
const sal_Int32 XML_gradientCenter = 2532;
const sal_Int32 XML_gradientFill = 2533;
const sal_Int32 XML_gradientInactiveCaption = 2534;
const sal_Int32 XML_gradientRadial = 2535;
const sal_Int32 XML_gradientUnscaled = 2536;
const sal_Int32 XML_gradientshapeok = 2537;
const sal_Int32 XML_grainSize = 2538;
const sal_Int32 XML_gramEnd = 2539;
const sal_Int32 XML_gramStart = 2540;
const sal_Int32 XML_grammar = 2541;
const sal_Int32 XML_grand = 2542;
const sal_Int32 XML_grandCol = 2543;
const sal_Int32 XML_grandRow = 2544;
const sal_Int32 XML_grandTotalCaption = 2545;
const sal_Int32 XML_graphic = 2546;
const sal_Int32 XML_graphicData = 2547;
const sal_Int32 XML_graphicEl = 2548;
const sal_Int32 XML_graphicFrame = 2549;
const sal_Int32 XML_graphicFrameLocks = 2550;
const sal_Int32 XML_grav = 2551;
const sal_Int32 XML_gray = 2552;
const sal_Int32 XML_gray0625 = 2553;
const sal_Int32 XML_gray125 = 2554;
const sal_Int32 XML_grayOutline = 2555;
const sal_Int32 XML_grayScale = 2556;
const sal_Int32 XML_grayText = 2557;
const sal_Int32 XML_grayWhite = 2558;
const sal_Int32 XML_grayscale = 2559;
const sal_Int32 XML_grayscl = 2560;
const sal_Int32 XML_greaterThan = 2561;
const sal_Int32 XML_greaterThanOrEqual = 2562;
const sal_Int32 XML_green = 2563;
const sal_Int32 XML_greenMod = 2564;
const sal_Int32 XML_greenOff = 2565;
const sal_Int32 XML_greenYellow = 2566;
const sal_Int32 XML_gregorian = 2567;
const sal_Int32 XML_gregorianArabic = 2568;
const sal_Int32 XML_gregorianMeFrench = 2569;
const sal_Int32 XML_gregorianUs = 2570;
const sal_Int32 XML_gregorianXlitEnglish = 2571;
const sal_Int32 XML_gregorianXlitFrench = 2572;
const sal_Int32 XML_gridAfter = 2573;
const sal_Int32 XML_gridBefore = 2574;
const sal_Int32 XML_gridCol = 2575;
const sal_Int32 XML_gridDropZones = 2576;
const sal_Int32 XML_gridLegend = 2577;
const sal_Int32 XML_gridLines = 2578;
const sal_Int32 XML_gridLinesSet = 2579;
const sal_Int32 XML_gridSize = 2580;
const sal_Int32 XML_gridSpacing = 2581;
const sal_Int32 XML_gridSpan = 2582;
const sal_Int32 XML_gridlineMajor = 2583;
const sal_Int32 XML_gridlineMinor = 2584;
const sal_Int32 XML_group = 2585;
const sal_Int32 XML_groupBy = 2586;
const sal_Int32 XML_groupChr = 2587;
const sal_Int32 XML_groupChrPr = 2588;
const sal_Int32 XML_groupInterval = 2589;
const sal_Int32 XML_groupItems = 2590;
const sal_Int32 XML_groupLevel = 2591;
const sal_Int32 XML_groupLevels = 2592;
const sal_Int32 XML_groupMember = 2593;
const sal_Int32 XML_groupMembers = 2594;
const sal_Int32 XML_grouping = 2595;
const sal_Int32 XML_groups = 2596;
const sal_Int32 XML_grow = 2597;
const sal_Int32 XML_growAutofit = 2598;
const sal_Int32 XML_growShrinkType = 2599;
const sal_Int32 XML_grpFill = 2600;
const sal_Int32 XML_grpId = 2601;
const sal_Int32 XML_grpSp = 2602;
const sal_Int32 XML_grpSpLocks = 2603;
const sal_Int32 XML_grpSpPr = 2604;
const sal_Int32 XML_gs = 2605;
const sal_Int32 XML_gsLst = 2606;
const sal_Int32 XML_gt = 2607;
const sal_Int32 XML_gte = 2608;
const sal_Int32 XML_guid = 2609;
const sal_Int32 XML_guide = 2610;
const sal_Int32 XML_guideLst = 2611;
const sal_Int32 XML_gutter = 2612;
const sal_Int32 XML_gutterAtTop = 2613;
const sal_Int32 XML_h = 2614;
const sal_Int32 XML_hAnchor = 2615;
const sal_Int32 XML_hAnsi = 2616;
const sal_Int32 XML_hAnsiTheme = 2617;
const sal_Int32 XML_hArH = 2618;
const sal_Int32 XML_hMerge = 2619;
const sal_Int32 XML_hMode = 2620;
const sal_Int32 XML_hOff = 2621;
const sal_Int32 XML_hPercent = 2622;
const sal_Int32 XML_hR = 2623;
const sal_Int32 XML_hRule = 2624;
const sal_Int32 XML_hSpace = 2625;
const sal_Int32 XML_hagakiCard = 2626;
const sal_Int32 XML_hair = 2627;
const sal_Int32 XML_hairline = 2628;
const sal_Int32 XML_half = 2629;
const sal_Int32 XML_halfAlpha = 2630;
const sal_Int32 XML_halfFrame = 2631;
const sal_Int32 XML_halfHangul = 2632;
const sal_Int32 XML_halfKatakana = 2633;
const sal_Int32 XML_halfwidthKatakana = 2634;
const sal_Int32 XML_handles = 2635;
const sal_Int32 XML_handmade1 = 2636;
const sal_Int32 XML_handmade2 = 2637;
const sal_Int32 XML_handoutMaster = 2638;
const sal_Int32 XML_handoutMasterId = 2639;
const sal_Int32 XML_handoutMasterIdLst = 2640;
const sal_Int32 XML_handoutView = 2641;
const sal_Int32 XML_handouts1 = 2642;
const sal_Int32 XML_handouts2 = 2643;
const sal_Int32 XML_handouts3 = 2644;
const sal_Int32 XML_handouts4 = 2645;
const sal_Int32 XML_handouts6 = 2646;
const sal_Int32 XML_handouts9 = 2647;
const sal_Int32 XML_hang = 2648;
const sal_Int32 XML_hanging = 2649;
const sal_Int32 XML_hangingChars = 2650;
const sal_Int32 XML_hangingPunct = 2651;
const sal_Int32 XML_hardEdge = 2652;
const sal_Int32 XML_harsh = 2653;
const sal_Int32 XML_hasCustomPrompt = 2654;
const sal_Int32 XML_hash = 2655;
const sal_Int32 XML_hashData = 2656;
const sal_Int32 XML_hashValue = 2657;
const sal_Int32 XML_hc = 2658;
const sal_Int32 XML_hd10 = 2659;
const sal_Int32 XML_hd2 = 2660;
const sal_Int32 XML_hd3 = 2661;
const sal_Int32 XML_hd4 = 2662;
const sal_Int32 XML_hd5 = 2663;
const sal_Int32 XML_hd6 = 2664;
const sal_Int32 XML_hd8 = 2665;
const sal_Int32 XML_hdr = 2666;
const sal_Int32 XML_hdrShapeDefaults = 2667;
const sal_Int32 XML_hdrs = 2668;
const sal_Int32 XML_headEnd = 2669;
const sal_Int32 XML_header = 2670;
const sal_Int32 XML_headerFooter = 2671;
const sal_Int32 XML_headerReference = 2672;
const sal_Int32 XML_headerRow = 2673;
const sal_Int32 XML_headerRowBorderDxfId = 2674;
const sal_Int32 XML_headerRowCellStyle = 2675;
const sal_Int32 XML_headerRowCount = 2676;
const sal_Int32 XML_headerRowDxfId = 2677;
const sal_Int32 XML_headerSource = 2678;
const sal_Int32 XML_headers = 2679;
const sal_Int32 XML_headersInLastRefresh = 2680;
const sal_Int32 XML_heading = 2681;
const sal_Int32 XML_headings = 2682;
const sal_Int32 XML_heart = 2683;
const sal_Int32 XML_heartBalloon = 2684;
const sal_Int32 XML_heartGray = 2685;
const sal_Int32 XML_hearts = 2686;
const sal_Int32 XML_heavy = 2687;
const sal_Int32 XML_hebrew = 2688;
const sal_Int32 XML_hebrew1 = 2689;
const sal_Int32 XML_hebrew2 = 2690;
const sal_Int32 XML_hebrew2Minus = 2691;
const sal_Int32 XML_heebieJeebies = 2692;
const sal_Int32 XML_help = 2693;
const sal_Int32 XML_helpText = 2694;
const sal_Int32 XML_heptagon = 2695;
const sal_Int32 XML_hex = 2696;
const sal_Int32 XML_hexBinary = 2697;
const sal_Int32 XML_hexagon = 2698;
const sal_Int32 XML_hf = 2699;
const sal_Int32 XML_hiLoLine = 2700;
const sal_Int32 XML_hiLowLines = 2701;
const sal_Int32 XML_hidden = 2702;
const sal_Int32 XML_hiddenButton = 2703;
const sal_Int32 XML_hiddenColumn = 2704;
const sal_Int32 XML_hiddenColumns = 2705;
const sal_Int32 XML_hiddenLevel = 2706;
const sal_Int32 XML_hiddenRow = 2707;
const sal_Int32 XML_hiddenRows = 2708;
const sal_Int32 XML_hiddenSlides = 2709;
const sal_Int32 XML_hide = 2710;
const sal_Int32 XML_hideBot = 2711;
const sal_Int32 XML_hideGeom = 2712;
const sal_Int32 XML_hideGrammaticalErrors = 2713;
const sal_Int32 XML_hideLastTrans = 2714;
const sal_Int32 XML_hideLeft = 2715;
const sal_Int32 XML_hideMark = 2716;
const sal_Int32 XML_hideNewItems = 2717;
const sal_Int32 XML_hidePivotFieldList = 2718;
const sal_Int32 XML_hideRight = 2719;
const sal_Int32 XML_hideSpellingErrors = 2720;
const sal_Int32 XML_hideTop = 2721;
const sal_Int32 XML_hier = 2722;
const sal_Int32 XML_hierAlign = 2723;
const sal_Int32 XML_hierBranch = 2724;
const sal_Int32 XML_hierChild = 2725;
const sal_Int32 XML_hierRoot = 2726;
const sal_Int32 XML_hierarchy = 2727;
const sal_Int32 XML_hierarchyUsage = 2728;
const sal_Int32 XML_high = 2729;
const sal_Int32 XML_highContrast = 2730;
const sal_Int32 XML_highKashida = 2731;
const sal_Int32 XML_highlight = 2732;
const sal_Int32 XML_highlightClick = 2733;
const sal_Int32 XML_highlightText = 2734;
const sal_Int32 XML_hijri = 2735;
const sal_Int32 XML_hindiAlpha1Period = 2736;
const sal_Int32 XML_hindiAlphaPeriod = 2737;
const sal_Int32 XML_hindiConsonants = 2738;
const sal_Int32 XML_hindiCounting = 2739;
const sal_Int32 XML_hindiNumParenR = 2740;
const sal_Int32 XML_hindiNumPeriod = 2741;
const sal_Int32 XML_hindiNumbers = 2742;
const sal_Int32 XML_hindiVowels = 2743;
const sal_Int32 XML_hint = 2744;
const sal_Int32 XML_hiragana = 2745;
const sal_Int32 XML_history = 2746;
const sal_Int32 XML_hlink = 2747;
const sal_Int32 XML_hlinkClick = 2748;
const sal_Int32 XML_hlinkHover = 2749;
const sal_Int32 XML_hlinkMouseOver = 2750;
const sal_Int32 XML_hold = 2751;
const sal_Int32 XML_holeSize = 2752;
const sal_Int32 XML_holly = 2753;
const sal_Int32 XML_honeycomb = 2754;
const sal_Int32 XML_homePlate = 2755;
const sal_Int32 XML_honeydew = 2756;
const sal_Int32 XML_horizontal = 2757;
const sal_Int32 XML_horizontalCentered = 2758;
const sal_Int32 XML_horizontalDpi = 2759;
const sal_Int32 XML_horizontalScroll = 2760;
const sal_Int32 XML_horz = 2761;
const sal_Int32 XML_horzAlign = 2762;
const sal_Int32 XML_horzAnchor = 2763;
const sal_Int32 XML_horzBarState = 2764;
const sal_Int32 XML_horzBrick = 2765;
const sal_Int32 XML_horzCross = 2766;
const sal_Int32 XML_horzOverflow = 2767;
const sal_Int32 XML_horzStripe = 2768;
const sal_Int32 XML_hotLight = 2769;
const sal_Int32 XML_hotPink = 2770;
const sal_Int32 XML_hour = 2771;
const sal_Int32 XML_hours = 2772;
const sal_Int32 XML_houseFunky = 2773;
const sal_Int32 XML_how = 2774;
const sal_Int32 XML_hps = 2775;
const sal_Int32 XML_hpsBaseText = 2776;
const sal_Int32 XML_hpsRaise = 2777;
const sal_Int32 XML_hqprint = 2778;
const sal_Int32 XML_hr = 2779;
const sal_Int32 XML_hralign = 2780;
const sal_Int32 XML_href = 2781;
const sal_Int32 XML_hrnoshade = 2782;
const sal_Int32 XML_hrpct = 2783;
const sal_Int32 XML_hrstd = 2784;
const sal_Int32 XML_hsl = 2785;
const sal_Int32 XML_hslClr = 2786;
const sal_Int32 XML_ht = 2787;
const sal_Int32 XML_htmlFormat = 2788;
const sal_Int32 XML_htmlPubPr = 2789;
const sal_Int32 XML_htmlTables = 2790;
const sal_Int32 XML_hue = 2791;
const sal_Int32 XML_hueDir = 2792;
const sal_Int32 XML_hueMod = 2793;
const sal_Int32 XML_hueOff = 2794;
const sal_Int32 XML_hundredMillions = 2795;
const sal_Int32 XML_hundredThousands = 2796;
const sal_Int32 XML_hundreds = 2797;
const sal_Int32 XML_hybridMultilevel = 2798;
const sal_Int32 XML_hyperlink = 2799;
const sal_Int32 XML_hyperlinks = 2800;
const sal_Int32 XML_hyphen = 2801;
const sal_Int32 XML_hyphenationZone = 2802;
const sal_Int32 XML_hypnotic = 2803;
const sal_Int32 XML_i = 2804;
const sal_Int32 XML_i1 = 2805;
const sal_Int32 XML_i2 = 2806;
const sal_Int32 XML_i3 = 2807;
const sal_Int32 XML_i4 = 2808;
const sal_Int32 XML_i8 = 2809;
const sal_Int32 XML_iCs = 2810;
const sal_Int32 XML_iLevel = 2811;
const sal_Int32 XML_iMeasureFld = 2812;
const sal_Int32 XML_iMeasureHier = 2813;
const sal_Int32 XML_iceCreamCones = 2814;
const sal_Int32 XML_icon = 2815;
const sal_Int32 XML_iconFilter = 2816;
const sal_Int32 XML_iconId = 2817;
const sal_Int32 XML_iconSet = 2818;
const sal_Int32 XML_id = 2819;
const sal_Int32 XML_idcntr = 2820;
const sal_Int32 XML_iddest = 2821;
const sal_Int32 XML_identifier = 2822;
const sal_Int32 XML_ideographDigital = 2823;
const sal_Int32 XML_ideographEnclosedCircle = 2824;
const sal_Int32 XML_ideographLegalTraditional = 2825;
const sal_Int32 XML_ideographTraditional = 2826;
const sal_Int32 XML_ideographZodiac = 2827;
const sal_Int32 XML_ideographZodiacTraditional = 2828;
const sal_Int32 XML_idmap = 2829;
const sal_Int32 XML_idref = 2830;
const sal_Int32 XML_idsrc = 2831;
const sal_Int32 XML_idx = 2832;
const sal_Int32 XML_if = 2833;
const sal_Int32 XML_ignore = 2834;
const sal_Int32 XML_ignoreMixedContent = 2835;
const sal_Int32 XML_ignoredError = 2836;
const sal_Int32 XML_ignoredErrors = 2837;
const sal_Int32 XML_ilvl = 2838;
const sal_Int32 XML_image = 2839;
const sal_Int32 XML_imagealignshape = 2840;
const sal_Int32 XML_imageaspect = 2841;
const sal_Int32 XML_imagedata = 2842;
const sal_Int32 XML_imagesize = 2843;
const sal_Int32 XML_imeMode = 2844;
const sal_Int32 XML_img = 2845;
const sal_Int32 XML_imgEffect = 2846;
const sal_Int32 XML_imgH = 2847;
const sal_Int32 XML_imgLayer = 2848;
const sal_Int32 XML_imgProps = 2849;
const sal_Int32 XML_imgSz = 2850;
const sal_Int32 XML_imgW = 2851;
const sal_Int32 XML_immersive = 2852;
const sal_Int32 XML_imprint = 2853;
const sal_Int32 XML_in = 2854;
const sal_Int32 XML_inBase = 2855;
const sal_Int32 XML_inByRing = 2856;
const sal_Int32 XML_inEnd = 2857;
const sal_Int32 XML_inactiveBorder = 2858;
const sal_Int32 XML_inactiveCaption = 2859;
const sal_Int32 XML_inactiveCaptionText = 2860;
const sal_Int32 XML_includeHiddenRowCol = 2861;
const sal_Int32 XML_includeNewItemsInFilter = 2862;
const sal_Int32 XML_includePrintSettings = 2863;
const sal_Int32 XML_ind = 2864;
const sal_Int32 XML_indefinite = 2865;
const sal_Int32 XML_indent = 2866;
const sal_Int32 XML_index = 2867;
const sal_Int32 XML_indexed = 2868;
const sal_Int32 XML_indexedColors = 2869;
const sal_Int32 XML_indianRed = 2870;
const sal_Int32 XML_indigo = 2871;
const sal_Int32 XML_infoBk = 2872;
const sal_Int32 XML_infoText = 2873;
const sal_Int32 XML_information = 2874;
const sal_Int32 XML_init = 2875;
const sal_Int32 XML_initials = 2876;
const sal_Int32 XML_ink = 2877;
const sal_Int32 XML_inkAnnotations = 2878;
const sal_Int32 XML_inkTgt = 2879;
const sal_Int32 XML_inline = 2880;
const sal_Int32 XML_inlineStr = 2881;
const sal_Int32 XML_inner = 2882;
const sal_Int32 XML_innerShdw = 2883;
const sal_Int32 XML_inputCells = 2884;
const sal_Int32 XML_ins = 2885;
const sal_Int32 XML_insDel = 2886;
const sal_Int32 XML_insertBlankRow = 2887;
const sal_Int32 XML_insertClear = 2888;
const sal_Int32 XML_insertCol = 2889;
const sal_Int32 XML_insertColumns = 2890;
const sal_Int32 XML_insertDelete = 2891;
const sal_Int32 XML_insertHyperlinks = 2892;
const sal_Int32 XML_insertPageBreak = 2893;
const sal_Int32 XML_insertRow = 2894;
const sal_Int32 XML_insertRowShift = 2895;
const sal_Int32 XML_insertRows = 2896;
const sal_Int32 XML_inset = 2897;
const sal_Int32 XML_insetmode = 2898;
const sal_Int32 XML_insetpen = 2899;
const sal_Int32 XML_insetpenok = 2900;
const sal_Int32 XML_inside = 2901;
const sal_Int32 XML_insideH = 2902;
const sal_Int32 XML_insideMargin = 2903;
const sal_Int32 XML_insideV = 2904;
const sal_Int32 XML_instr = 2905;
const sal_Int32 XML_instrText = 2906;
const sal_Int32 XML_int = 2907;
const sal_Int32 XML_intLim = 2908;
const sal_Int32 XML_intVal = 2909;
const sal_Int32 XML_integer = 2910;
const sal_Int32 XML_integrated = 2911;
const sal_Int32 XML_intensity = 2912;
const sal_Int32 XML_interSp = 2913;
const sal_Int32 XML_interactiveSeq = 2914;
const sal_Int32 XML_intercept = 2915;
const sal_Int32 XML_intermediate = 2916;
const sal_Int32 XML_interval = 2917;
const sal_Int32 XML_intraSp = 2918;
const sal_Int32 XML_inv = 2919;
const sal_Int32 XML_invGamma = 2920;
const sal_Int32 XML_invGray = 2921;
const sal_Int32 XML_invalEndChars = 2922;
const sal_Int32 XML_invalStChars = 2923;
const sal_Int32 XML_invalid = 2924;
const sal_Int32 XML_invalidUrl = 2925;
const sal_Int32 XML_inverseGray = 2926;
const sal_Int32 XML_invertIfNegative = 2927;
const sal_Int32 XML_invx = 2928;
const sal_Int32 XML_invy = 2929;
const sal_Int32 XML_iroha = 2930;
const sal_Int32 XML_irohaFullWidth = 2931;
const sal_Int32 XML_irregularSeal1 = 2932;
const sal_Int32 XML_irregularSeal2 = 2933;
const sal_Int32 XML_is = 2934;
const sal_Int32 XML_isInverted = 2935;
const sal_Int32 XML_isLgl = 2936;
const sal_Int32 XML_isNarration = 2937;
const sal_Int32 XML_isPhoto = 2938;
const sal_Int32 XML_iscomment = 2939;
const sal_Int32 XML_isometricBottomDown = 2940;
const sal_Int32 XML_isometricBottomUp = 2941;
const sal_Int32 XML_isometricLeftDown = 2942;
const sal_Int32 XML_isometricLeftUp = 2943;
const sal_Int32 XML_isometricOffAxis1Left = 2944;
const sal_Int32 XML_isometricOffAxis1Right = 2945;
const sal_Int32 XML_isometricOffAxis1Top = 2946;
const sal_Int32 XML_isometricOffAxis2Left = 2947;
const sal_Int32 XML_isometricOffAxis2Right = 2948;
const sal_Int32 XML_isometricOffAxis2Top = 2949;
const sal_Int32 XML_isometricOffAxis3Bottom = 2950;
const sal_Int32 XML_isometricOffAxis3Left = 2951;
const sal_Int32 XML_isometricOffAxis3Right = 2952;
const sal_Int32 XML_isometricOffAxis4Bottom = 2953;
const sal_Int32 XML_isometricOffAxis4Left = 2954;
const sal_Int32 XML_isometricOffAxis4Right = 2955;
const sal_Int32 XML_isometricRightDown = 2956;
const sal_Int32 XML_isometricRightUp = 2957;
const sal_Int32 XML_isometricTopDown = 2958;
const sal_Int32 XML_isometricTopUp = 2959;
const sal_Int32 XML_issignatureline = 2960;
const sal_Int32 XML_italic = 2961;
const sal_Int32 XML_item = 2962;
const sal_Int32 XML_itemID = 2963;
const sal_Int32 XML_itemPageCount = 2964;
const sal_Int32 XML_itemPrintTitles = 2965;
const sal_Int32 XML_items = 2966;
const sal_Int32 XML_iterate = 2967;
const sal_Int32 XML_iterateCount = 2968;
const sal_Int32 XML_iterateDelta = 2969;
const sal_Int32 XML_ivory = 2970;
const sal_Int32 XML_japan = 2971;
const sal_Int32 XML_japaneseCounting = 2972;
const sal_Int32 XML_japaneseDigitalTenThousand = 2973;
const sal_Int32 XML_japaneseLegal = 2974;
const sal_Int32 XML_jc = 2975;
const sal_Int32 XML_joinstyle = 2976;
const sal_Int32 XML_just = 2977;
const sal_Int32 XML_justLow = 2978;
const sal_Int32 XML_justify = 2979;
const sal_Int32 XML_justifyLastLine = 2980;
const sal_Int32 XML_k = 2981;
const sal_Int32 XML_keepAlive = 2982;
const sal_Int32 XML_keepChangeHistory = 2983;
const sal_Int32 XML_keepLines = 2984;
const sal_Int32 XML_keepNext = 2985;
const sal_Int32 XML_kern = 2986;
const sal_Int32 XML_key = 2987;
const sal_Int32 XML_keyAttribute = 2988;
const sal_Int32 XML_keywords = 2989;
const sal_Int32 XML_khaki = 2990;
const sal_Int32 XML_kinsoku = 2991;
const sal_Int32 XML_kiosk = 2992;
const sal_Int32 XML_korea = 2993;
const sal_Int32 XML_koreanCounting = 2994;
const sal_Int32 XML_koreanDigital = 2995;
const sal_Int32 XML_koreanDigital2 = 2996;
const sal_Int32 XML_koreanLegal = 2997;
const sal_Int32 XML_kpi = 2998;
const sal_Int32 XML_kpis = 2999;
const sal_Int32 XML_kumimoji = 3000;
const sal_Int32 XML_kx = 3001;
const sal_Int32 XML_ky = 3002;
const sal_Int32 XML_l = 3003;
const sal_Int32 XML_lB = 3004;
const sal_Int32 XML_lBounds = 3005;
const sal_Int32 XML_lCtrCh = 3006;
const sal_Int32 XML_lCtrDes = 3007;
const sal_Int32 XML_lIns = 3008;
const sal_Int32 XML_lMarg = 3009;
const sal_Int32 XML_lMargin = 3010;
const sal_Int32 XML_lOff = 3011;
const sal_Int32 XML_lT = 3012;
const sal_Int32 XML_label = 3013;
const sal_Int32 XML_labelOnly = 3014;
const sal_Int32 XML_landscape = 3015;
const sal_Int32 XML_lang = 3016;
const sal_Int32 XML_language = 3017;
const sal_Int32 XML_largest = 3018;
const sal_Int32 XML_last = 3019;
const sal_Int32 XML_last7Days = 3020;
const sal_Int32 XML_lastClick = 3021;
const sal_Int32 XML_lastClr = 3022;
const sal_Int32 XML_lastCol = 3023;
const sal_Int32 XML_lastColumn = 3024;
const sal_Int32 XML_lastEdited = 3025;
const sal_Int32 XML_lastGuid = 3026;
const sal_Int32 XML_lastHeaderCell = 3027;
const sal_Int32 XML_lastIdx = 3028;
const sal_Int32 XML_lastLineOnly = 3029;
const sal_Int32 XML_lastModifiedBy = 3030;
const sal_Int32 XML_lastMonth = 3031;
const sal_Int32 XML_lastPrinted = 3032;
const sal_Int32 XML_lastQuarter = 3033;
const sal_Int32 XML_lastRenderedPageBreak = 3034;
const sal_Int32 XML_lastRow = 3035;
const sal_Int32 XML_lastRowFirstColumn = 3036;
const sal_Int32 XML_lastRowLastColumn = 3037;
const sal_Int32 XML_lastTotalCell = 3038;
const sal_Int32 XML_lastValue = 3039;
const sal_Int32 XML_lastView = 3040;
const sal_Int32 XML_lastWeek = 3041;
const sal_Int32 XML_lastYear = 3042;
const sal_Int32 XML_lat = 3043;
const sal_Int32 XML_latentStyles = 3044;
const sal_Int32 XML_latin = 3045;
const sal_Int32 XML_latinLnBrk = 3046;
const sal_Int32 XML_lavender = 3047;
const sal_Int32 XML_lavenderBlush = 3048;
const sal_Int32 XML_lawnGreen = 3049;
const sal_Int32 XML_layout = 3050;
const sal_Int32 XML_layoutDef = 3051;
const sal_Int32 XML_layoutDefHdr = 3052;
const sal_Int32 XML_layoutDefHdrLst = 3053;
const sal_Int32 XML_layoutId = 3054;
const sal_Int32 XML_layoutInCell = 3055;
const sal_Int32 XML_layoutNode = 3056;
const sal_Int32 XML_layoutPr = 3057;
const sal_Int32 XML_layoutRawTableWidth = 3058;
const sal_Int32 XML_layoutTableRowsApart = 3059;
const sal_Int32 XML_layoutTarget = 3060;
const sal_Int32 XML_lblAlgn = 3061;
const sal_Int32 XML_lblOffset = 3062;
const sal_Int32 XML_lc = 3063;
const sal_Int32 XML_ld = 3064;
const sal_Int32 XML_le = 3065;
const sal_Int32 XML_leader = 3066;
const sal_Int32 XML_leaderLine = 3067;
const sal_Int32 XML_leaderLines = 3068;
const sal_Int32 XML_ledger = 3069;
const sal_Int32 XML_left = 3070;
const sal_Int32 XML_leftArrow = 3071;
const sal_Int32 XML_leftArrowCallout = 3072;
const sal_Int32 XML_leftBrace = 3073;
const sal_Int32 XML_leftBracket = 3074;
const sal_Int32 XML_leftChars = 3075;
const sal_Int32 XML_leftCircularArrow = 3076;
const sal_Int32 XML_leftFromText = 3077;
const sal_Int32 XML_leftLabels = 3078;
const sal_Int32 XML_leftMargin = 3079;
const sal_Int32 XML_leftRightArrow = 3080;
const sal_Int32 XML_leftRightArrowCallout = 3081;
const sal_Int32 XML_leftRightCircularArrow = 3082;
const sal_Int32 XML_leftRightRibbon = 3083;
const sal_Int32 XML_leftRightUpArrow = 3084;
const sal_Int32 XML_leftUpArrow = 3085;
const sal_Int32 XML_legacy = 3086;
const sal_Int32 XML_legacyDrawing = 3087;
const sal_Int32 XML_legacyDrawingHF = 3088;
const sal_Int32 XML_legacyFlat1 = 3089;
const sal_Int32 XML_legacyFlat2 = 3090;
const sal_Int32 XML_legacyFlat3 = 3091;
const sal_Int32 XML_legacyFlat4 = 3092;
const sal_Int32 XML_legacyHarsh1 = 3093;
const sal_Int32 XML_legacyHarsh2 = 3094;
const sal_Int32 XML_legacyHarsh3 = 3095;
const sal_Int32 XML_legacyHarsh4 = 3096;
const sal_Int32 XML_legacyIndent = 3097;
const sal_Int32 XML_legacyMatte = 3098;
const sal_Int32 XML_legacyMetal = 3099;
const sal_Int32 XML_legacyNormal1 = 3100;
const sal_Int32 XML_legacyNormal2 = 3101;
const sal_Int32 XML_legacyNormal3 = 3102;
const sal_Int32 XML_legacyNormal4 = 3103;
const sal_Int32 XML_legacyObliqueBottom = 3104;
const sal_Int32 XML_legacyObliqueBottomLeft = 3105;
const sal_Int32 XML_legacyObliqueBottomRight = 3106;
const sal_Int32 XML_legacyObliqueFront = 3107;
const sal_Int32 XML_legacyObliqueLeft = 3108;
const sal_Int32 XML_legacyObliqueRight = 3109;
const sal_Int32 XML_legacyObliqueTop = 3110;
const sal_Int32 XML_legacyObliqueTopLeft = 3111;
const sal_Int32 XML_legacyObliqueTopRight = 3112;
const sal_Int32 XML_legacyPerspectiveBottom = 3113;
const sal_Int32 XML_legacyPerspectiveBottomLeft = 3114;
const sal_Int32 XML_legacyPerspectiveBottomRight = 3115;
const sal_Int32 XML_legacyPerspectiveFront = 3116;
const sal_Int32 XML_legacyPerspectiveLeft = 3117;
const sal_Int32 XML_legacyPerspectiveRight = 3118;
const sal_Int32 XML_legacyPerspectiveTop = 3119;
const sal_Int32 XML_legacyPerspectiveTopLeft = 3120;
const sal_Int32 XML_legacyPerspectiveTopRight = 3121;
const sal_Int32 XML_legacyPlastic = 3122;
const sal_Int32 XML_legacySpace = 3123;
const sal_Int32 XML_legacyWireframe = 3124;
const sal_Int32 XML_legend = 3125;
const sal_Int32 XML_legendEntry = 3126;
const sal_Int32 XML_legendPos = 3127;
const sal_Int32 XML_lemonChiffon = 3128;
const sal_Int32 XML_len = 3129;
const sal_Int32 XML_length = 3130;
const sal_Int32 XML_lengthspecified = 3131;
const sal_Int32 XML_lessThan = 3132;
const sal_Int32 XML_lessThanOrEqual = 3133;
const sal_Int32 XML_letter = 3134;
const sal_Int32 XML_level = 3135;
const sal_Int32 XML_lg = 3136;
const sal_Int32 XML_lgCheck = 3137;
const sal_Int32 XML_lgConfetti = 3138;
const sal_Int32 XML_lgDash = 3139;
const sal_Int32 XML_lgDashDot = 3140;
const sal_Int32 XML_lgDashDotDot = 3141;
const sal_Int32 XML_lgGrid = 3142;
const sal_Int32 XML_license = 3143;
const sal_Int32 XML_lid = 3144;
const sal_Int32 XML_ligatures = 3145;
const sal_Int32 XML_light1 = 3146;
const sal_Int32 XML_light2 = 3147;
const sal_Int32 XML_lightBulb = 3148;
const sal_Int32 XML_lightDown = 3149;
const sal_Int32 XML_lightGray = 3150;
const sal_Int32 XML_lightGrayscale = 3151;
const sal_Int32 XML_lightGrid = 3152;
const sal_Int32 XML_lightHorizontal = 3153;
const sal_Int32 XML_lightRig = 3154;
const sal_Int32 XML_lightTrellis = 3155;
const sal_Int32 XML_lightUp = 3156;
const sal_Int32 XML_lightVertical = 3157;
const sal_Int32 XML_lighten = 3158;
const sal_Int32 XML_lightenLess = 3159;
const sal_Int32 XML_lightface = 3160;
const sal_Int32 XML_lightharsh = 3161;
const sal_Int32 XML_lightharsh2 = 3162;
const sal_Int32 XML_lightlevel = 3163;
const sal_Int32 XML_lightlevel2 = 3164;
const sal_Int32 XML_lightning1 = 3165;
const sal_Int32 XML_lightning2 = 3166;
const sal_Int32 XML_lightningBolt = 3167;
const sal_Int32 XML_lightposition = 3168;
const sal_Int32 XML_lightposition2 = 3169;
const sal_Int32 XML_lights = 3170;
const sal_Int32 XML_lim = 3171;
const sal_Int32 XML_limLoc = 3172;
const sal_Int32 XML_limLow = 3173;
const sal_Int32 XML_limLowPr = 3174;
const sal_Int32 XML_limUpp = 3175;
const sal_Int32 XML_limUppPr = 3176;
const sal_Int32 XML_lime = 3177;
const sal_Int32 XML_limeGreen = 3178;
const sal_Int32 XML_limo = 3179;
const sal_Int32 XML_lin = 3180;
const sal_Int32 XML_linClrLst = 3181;
const sal_Int32 XML_linDir = 3182;
const sal_Int32 XML_line = 3183;
const sal_Int32 XML_line3DChart = 3184;
const sal_Int32 XML_lineChart = 3185;
const sal_Int32 XML_lineInv = 3186;
const sal_Int32 XML_lineMarker = 3187;
const sal_Int32 XML_linePitch = 3188;
const sal_Int32 XML_lineRule = 3189;
const sal_Int32 XML_lineTo = 3190;
const sal_Int32 XML_lineWeight = 3191;
const sal_Int32 XML_lineWidthScale = 3192;
const sal_Int32 XML_lineWrapLikeWord6 = 3193;
const sal_Int32 XML_linear = 3194;
const sal_Int32 XML_linen = 3195;
const sal_Int32 XML_lines = 3196;
const sal_Int32 XML_linesAndChars = 3197;
const sal_Int32 XML_linestyle = 3198;
const sal_Int32 XML_link = 3199;
const sal_Int32 XML_linkStyles = 3200;
const sal_Int32 XML_linkTarget = 3201;
const sal_Int32 XML_linkToQuery = 3202;
const sal_Int32 XML_linkedToFile = 3203;
const sal_Int32 XML_linkedTxbx = 3204;
const sal_Int32 XML_list = 3205;
const sal_Int32 XML_listDataValidation = 3206;
const sal_Int32 XML_listEntry = 3207;
const sal_Int32 XML_listItem = 3208;
const sal_Int32 XML_listSeparator = 3209;
const sal_Int32 XML_lit = 3210;
const sal_Int32 XML_lkTxEntry = 3211;
const sal_Int32 XML_ln = 3212;
const sal_Int32 XML_lnB = 3213;
const sal_Int32 XML_lnBlToTr = 3214;
const sal_Int32 XML_lnDef = 3215;
const sal_Int32 XML_lnL = 3216;
const sal_Int32 XML_lnNumType = 3217;
const sal_Int32 XML_lnR = 3218;
const sal_Int32 XML_lnRef = 3219;
const sal_Int32 XML_lnSpAfChP = 3220;
const sal_Int32 XML_lnSpAfParP = 3221;
const sal_Int32 XML_lnSpCh = 3222;
const sal_Int32 XML_lnSpPar = 3223;
const sal_Int32 XML_lnSpc = 3224;
const sal_Int32 XML_lnSpcReduction = 3225;
const sal_Int32 XML_lnStyleLst = 3226;
const sal_Int32 XML_lnT = 3227;
const sal_Int32 XML_lnTlToBr = 3228;
const sal_Int32 XML_lnTo = 3229;
const sal_Int32 XML_lo = 3230;
const sal_Int32 XML_loCatId = 3231;
const sal_Int32 XML_loTypeId = 3232;
const sal_Int32 XML_local = 3233;
const sal_Int32 XML_localConnection = 3234;
const sal_Int32 XML_localRefresh = 3235;
const sal_Int32 XML_localSheetId = 3236;
const sal_Int32 XML_location = 3237;
const sal_Int32 XML_lock = 3238;
const sal_Int32 XML_lockRevision = 3239;
const sal_Int32 XML_lockStructure = 3240;
const sal_Int32 XML_lockText = 3241;
const sal_Int32 XML_lockWindows = 3242;
const sal_Int32 XML_locked = 3243;
const sal_Int32 XML_lockedCanvas = 3244;
const sal_Int32 XML_lockrotationcenter = 3245;
const sal_Int32 XML_loext = 3246;
const sal_Int32 XML_log = 3247;
const sal_Int32 XML_logBase = 3248;
const sal_Int32 XML_lon = 3249;
const sal_Int32 XML_long = 3250;
const sal_Int32 XML_longCurve = 3251;
const sal_Int32 XML_longFileNames = 3252;
const sal_Int32 XML_longText = 3253;
const sal_Int32 XML_longdash = 3254;
const sal_Int32 XML_longdashdot = 3255;
const sal_Int32 XML_longdashdotdot = 3256;
const sal_Int32 XML_loop = 3257;
const sal_Int32 XML_low = 3258;
const sal_Int32 XML_lowKashida = 3259;
const sal_Int32 XML_lowerLetter = 3260;
const sal_Int32 XML_lowerRoman = 3261;
const sal_Int32 XML_lowestEdited = 3262;
const sal_Int32 XML_lpstr = 3263;
const sal_Int32 XML_lpwstr = 3264;
const sal_Int32 XML_lrTb = 3265;
const sal_Int32 XML_lrTbV = 3266;
const sal_Int32 XML_ls = 3267;
const sal_Int32 XML_lsdException = 3268;
const sal_Int32 XML_lstStyle = 3269;
const sal_Int32 XML_lt = 3270;
const sal_Int32 XML_lt1 = 3271;
const sal_Int32 XML_lt2 = 3272;
const sal_Int32 XML_ltBlue = 3273;
const sal_Int32 XML_ltCoral = 3274;
const sal_Int32 XML_ltCyan = 3275;
const sal_Int32 XML_ltDnDiag = 3276;
const sal_Int32 XML_ltGoldenrodYellow = 3277;
const sal_Int32 XML_ltGray = 3278;
const sal_Int32 XML_ltGreen = 3279;
const sal_Int32 XML_ltHorz = 3280;
const sal_Int32 XML_ltPink = 3281;
const sal_Int32 XML_ltSalmon = 3282;
const sal_Int32 XML_ltSeaGreen = 3283;
const sal_Int32 XML_ltSkyBlue = 3284;
const sal_Int32 XML_ltSlateGray = 3285;
const sal_Int32 XML_ltSteelBlue = 3286;
const sal_Int32 XML_ltUpDiag = 3287;
const sal_Int32 XML_ltVert = 3288;
const sal_Int32 XML_ltYellow = 3289;
const sal_Int32 XML_lte = 3290;
const sal_Int32 XML_lu = 3291;
const sal_Int32 XML_lum = 3292;
const sal_Int32 XML_lumMod = 3293;
const sal_Int32 XML_lumOff = 3294;
const sal_Int32 XML_lvl = 3295;
const sal_Int32 XML_lvl1pPr = 3296;
const sal_Int32 XML_lvl2pPr = 3297;
const sal_Int32 XML_lvl3pPr = 3298;
const sal_Int32 XML_lvl4pPr = 3299;
const sal_Int32 XML_lvl5pPr = 3300;
const sal_Int32 XML_lvl6pPr = 3301;
const sal_Int32 XML_lvl7pPr = 3302;
const sal_Int32 XML_lvl8pPr = 3303;
const sal_Int32 XML_lvl9pPr = 3304;
const sal_Int32 XML_lvlAtOnce = 3305;
const sal_Int32 XML_lvlJc = 3306;
const sal_Int32 XML_lvlOne = 3307;
const sal_Int32 XML_lvlOverride = 3308;
const sal_Int32 XML_lvlPicBulletId = 3309;
const sal_Int32 XML_lvlRestart = 3310;
const sal_Int32 XML_lvlText = 3311;
const sal_Int32 XML_m = 3312;
const sal_Int32 XML_mPr = 3313;
const sal_Int32 XML_mac = 3314;
const sal_Int32 XML_macro = 3315;
const sal_Int32 XML_macrosheet = 3316;
const sal_Int32 XML_magenta = 3317;
const sal_Int32 XML_mailAsAttachment = 3318;
const sal_Int32 XML_mailMerge = 3319;
const sal_Int32 XML_mailSubject = 3320;
const sal_Int32 XML_mailingLabels = 3321;
const sal_Int32 XML_main = 3322;
const sal_Int32 XML_mainDocumentType = 3323;
const sal_Int32 XML_mainSeq = 3324;
const sal_Int32 XML_major = 3325;
const sal_Int32 XML_majorAscii = 3326;
const sal_Int32 XML_majorBidi = 3327;
const sal_Int32 XML_majorEastAsia = 3328;
const sal_Int32 XML_majorFont = 3329;
const sal_Int32 XML_majorGridlines = 3330;
const sal_Int32 XML_majorHAnsi = 3331;
const sal_Int32 XML_majorTickMark = 3332;
const sal_Int32 XML_majorTickMarks = 3333;
const sal_Int32 XML_majorTimeUnit = 3334;
const sal_Int32 XML_majorUnit = 3335;
const sal_Int32 XML_man = 3336;
const sal_Int32 XML_manifestLocation = 3337;
const sal_Int32 XML_manual = 3338;
const sal_Int32 XML_manualBreakCount = 3339;
const sal_Int32 XML_manualLayout = 3340;
const sal_Int32 XML_manualMax = 3341;
const sal_Int32 XML_manualMin = 3342;
const sal_Int32 XML_map = 3343;
const sal_Int32 XML_mapId = 3344;
const sal_Int32 XML_mapPins = 3345;
const sal_Int32 XML_mapleLeaf = 3346;
const sal_Int32 XML_mapleMuffins = 3347;
const sal_Int32 XML_mappedName = 3348;
const sal_Int32 XML_mappingCount = 3349;
const sal_Int32 XML_maps = 3350;
const sal_Int32 XML_marB = 3351;
const sal_Int32 XML_marBottom = 3352;
const sal_Int32 XML_marH = 3353;
const sal_Int32 XML_marL = 3354;
const sal_Int32 XML_marLeft = 3355;
const sal_Int32 XML_marR = 3356;
const sal_Int32 XML_marRight = 3357;
const sal_Int32 XML_marT = 3358;
const sal_Int32 XML_marTop = 3359;
const sal_Int32 XML_marW = 3360;
const sal_Int32 XML_margin = 3361;
const sal_Int32 XML_marker = 3362;
const sal_Int32 XML_markers = 3363;
const sal_Int32 XML_markup = 3364;
const sal_Int32 XML_maroon = 3365;
const sal_Int32 XML_marquee = 3366;
const sal_Int32 XML_marqueeToothed = 3367;
const sal_Int32 XML_master = 3368;
const sal_Int32 XML_masterClrMapping = 3369;
const sal_Int32 XML_masterPages = 3370;
const sal_Int32 XML_masterRel = 3371;
const sal_Int32 XML_match = 3372;
const sal_Int32 XML_matchSrc = 3373;
const sal_Int32 XML_matchingName = 3374;
const sal_Int32 XML_mathDivide = 3375;
const sal_Int32 XML_mathEqual = 3376;
const sal_Int32 XML_mathFont = 3377;
const sal_Int32 XML_mathMinus = 3378;
const sal_Int32 XML_mathMultiply = 3379;
const sal_Int32 XML_mathNotEqual = 3380;
const sal_Int32 XML_mathPlus = 3381;
const sal_Int32 XML_mathPr = 3382;
const sal_Int32 XML_matrix = 3383;
const sal_Int32 XML_matte = 3384;
const sal_Int32 XML_max = 3385;
const sal_Int32 XML_maxAxisType = 3386;
const sal_Int32 XML_maxAng = 3387;
const sal_Int32 XML_maxDate = 3388;
const sal_Int32 XML_maxDepth = 3389;
const sal_Int32 XML_maxDist = 3390;
const sal_Int32 XML_maxLength = 3391;
const sal_Int32 XML_maxMin = 3392;
const sal_Int32 XML_maxR = 3393;
const sal_Int32 XML_maxRId = 3394;
const sal_Int32 XML_maxRank = 3395;
const sal_Int32 XML_maxSheetId = 3396;
const sal_Int32 XML_maxSubtotal = 3397;
const sal_Int32 XML_maxVal = 3398;
const sal_Int32 XML_maxValue = 3399;
const sal_Int32 XML_maxX = 3400;
const sal_Int32 XML_maxY = 3401;
const sal_Int32 XML_maximized = 3402;
const sal_Int32 XML_mc = 3403;
const sal_Int32 XML_mcJc = 3404;
const sal_Int32 XML_mcPr = 3405;
const sal_Int32 XML_mcs = 3406;
const sal_Int32 XML_mdx = 3407;
const sal_Int32 XML_mdxMetadata = 3408;
const sal_Int32 XML_mdxSubqueries = 3409;
const sal_Int32 XML_measure = 3410;
const sal_Int32 XML_measureFilter = 3411;
const sal_Int32 XML_measureGroup = 3412;
const sal_Int32 XML_measureGroups = 3413;
const sal_Int32 XML_measures = 3414;
const sal_Int32 XML_med = 3415;
const sal_Int32 XML_medAquamarine = 3416;
const sal_Int32 XML_medBlue = 3417;
const sal_Int32 XML_medOrchid = 3418;
const sal_Int32 XML_medPurple = 3419;
const sal_Int32 XML_medSeaGreen = 3420;
const sal_Int32 XML_medSlateBlue = 3421;
const sal_Int32 XML_medSpringGreen = 3422;
const sal_Int32 XML_medTurquoise = 3423;
const sal_Int32 XML_medVioletRed = 3424;
const sal_Int32 XML_media = 3425;
const sal_Int32 XML_mediaAndTx = 3426;
const sal_Int32 XML_mediacall = 3427;
const sal_Int32 XML_medium = 3428;
const sal_Int32 XML_mediumDashDot = 3429;
const sal_Int32 XML_mediumDashDotDot = 3430;
const sal_Int32 XML_mediumDashed = 3431;
const sal_Int32 XML_mediumGray = 3432;
const sal_Int32 XML_mediumKashida = 3433;
const sal_Int32 XML_member = 3434;
const sal_Int32 XML_memberName = 3435;
const sal_Int32 XML_memberPropertyField = 3436;
const sal_Int32 XML_memberValueDatatype = 3437;
const sal_Int32 XML_members = 3438;
const sal_Int32 XML_menu = 3439;
const sal_Int32 XML_menuBar = 3440;
const sal_Int32 XML_menuHighlight = 3441;
const sal_Int32 XML_menuText = 3442;
const sal_Int32 XML_merge = 3443;
const sal_Int32 XML_mergeCell = 3444;
const sal_Int32 XML_mergeCells = 3445;
const sal_Int32 XML_mergeInterval = 3446;
const sal_Int32 XML_mergeItem = 3447;
const sal_Int32 XML_metadata = 3448;
const sal_Int32 XML_metadataStrings = 3449;
const sal_Int32 XML_metadataType = 3450;
const sal_Int32 XML_metadataTypes = 3451;
const sal_Int32 XML_metal = 3452;
const sal_Int32 XML_meth = 3453;
const sal_Int32 XML_method = 3454;
const sal_Int32 XML_mid = 3455;
const sal_Int32 XML_midCat = 3456;
const sal_Int32 XML_midL = 3457;
const sal_Int32 XML_midR = 3458;
const sal_Int32 XML_middle = 3459;
const sal_Int32 XML_middleDot = 3460;
const sal_Int32 XML_midnightBlue = 3461;
const sal_Int32 XML_millions = 3462;
const sal_Int32 XML_min = 3463;
const sal_Int32 XML_minAxisType = 3464;
const sal_Int32 XML_minAng = 3465;
const sal_Int32 XML_minDate = 3466;
const sal_Int32 XML_minLength = 3467;
const sal_Int32 XML_minMax = 3468;
const sal_Int32 XML_minR = 3469;
const sal_Int32 XML_minRId = 3470;
const sal_Int32 XML_minRefreshableVersion = 3471;
const sal_Int32 XML_minSubtotal = 3472;
const sal_Int32 XML_minSupportedVersion = 3473;
const sal_Int32 XML_minValue = 3474;
const sal_Int32 XML_minVer = 3475;
const sal_Int32 XML_minX = 3476;
const sal_Int32 XML_minY = 3477;
const sal_Int32 XML_minimized = 3478;
const sal_Int32 XML_minimumVersion = 3479;
const sal_Int32 XML_minor = 3480;
const sal_Int32 XML_minorAscii = 3481;
const sal_Int32 XML_minorBidi = 3482;
const sal_Int32 XML_minorEastAsia = 3483;
const sal_Int32 XML_minorFont = 3484;
const sal_Int32 XML_minorGridlines = 3485;
const sal_Int32 XML_minorHAnsi = 3486;
const sal_Int32 XML_minorTickMark = 3487;
const sal_Int32 XML_minorTickMarks = 3488;
const sal_Int32 XML_minorTimeUnit = 3489;
const sal_Int32 XML_minorUnit = 3490;
const sal_Int32 XML_mintCream = 3491;
const sal_Int32 XML_minus = 3492;
const sal_Int32 XML_minusx = 3493;
const sal_Int32 XML_minusy = 3494;
const sal_Int32 XML_minute = 3495;
const sal_Int32 XML_minutes = 3496;
const sal_Int32 XML_mirrorIndents = 3497;
const sal_Int32 XML_mirrorMargins = 3498;
const sal_Int32 XML_missingCaption = 3499;
const sal_Int32 XML_missingItemsLimit = 3500;
const sal_Int32 XML_mistyRose = 3501;
const sal_Int32 XML_miter = 3502;
const sal_Int32 XML_miterlimit = 3503;
const sal_Int32 XML_moccasin = 3504;
const sal_Int32 XML_mod = 3505;
const sal_Int32 XML_modId = 3506;
const sal_Int32 XML_model = 3507;
const sal_Int32 XML_modelId = 3508;
const sal_Int32 XML_modern = 3509;
const sal_Int32 XML_modified = 3510;
const sal_Int32 XML_modifyVerifier = 3511;
const sal_Int32 XML_mods = 3512;
const sal_Int32 XML_mongolianVert = 3513;
const sal_Int32 XML_monospace = 3514;
const sal_Int32 XML_month = 3515;
const sal_Int32 XML_monthLong = 3516;
const sal_Int32 XML_monthShort = 3517;
const sal_Int32 XML_months = 3518;
const sal_Int32 XML_moon = 3519;
const sal_Int32 XML_moons = 3520;
const sal_Int32 XML_morning = 3521;
const sal_Int32 XML_morph = 3522;
const sal_Int32 XML_mosaic = 3523;
const sal_Int32 XML_moveFrom = 3524;
const sal_Int32 XML_moveFromRangeEnd = 3525;
const sal_Int32 XML_moveFromRangeStart = 3526;
const sal_Int32 XML_moveTo = 3527;
const sal_Int32 XML_moveToRangeEnd = 3528;
const sal_Int32 XML_moveToRangeStart = 3529;
const sal_Int32 XML_moveWith = 3530;
const sal_Int32 XML_moveWithCells = 3531;
const sal_Int32 XML_movie = 3532;
const sal_Int32 XML_movingAvg = 3533;
const sal_Int32 XML_mp = 3534;
const sal_Int32 XML_mpFld = 3535;
const sal_Int32 XML_mpMap = 3536;
const sal_Int32 XML_mps = 3537;
const sal_Int32 XML_mr = 3538;
const sal_Int32 XML_mruColors = 3539;
const sal_Int32 XML_ms = 3540;
const sal_Int32 XML_mult = 3541;
const sal_Int32 XML_multiLevelType = 3542;
const sal_Int32 XML_multiLine = 3543;
const sal_Int32 XML_multiLvlStrCache = 3544;
const sal_Int32 XML_multiLvlStrRef = 3545;
const sal_Int32 XML_multilevel = 3546;
const sal_Int32 XML_multipleFieldFilters = 3547;
const sal_Int32 XML_multipleItemSelectionAllowed = 3548;
const sal_Int32 XML_musicNotes = 3549;
const sal_Int32 XML_mute = 3550;
const sal_Int32 XML_mwSmallCaps = 3551;
const sal_Int32 XML_n = 3552;
const sal_Int32 XML_na = 3553;
const sal_Int32 XML_name = 3554;
const sal_Int32 XML_nameLen = 3555;
const sal_Int32 XML_namespaceUri = 3556;
const sal_Int32 XML_namespaceuri = 3557;
const sal_Int32 XML_narHorz = 3558;
const sal_Int32 XML_narVert = 3559;
const sal_Int32 XML_narrow = 3560;
const sal_Int32 XML_nary = 3561;
const sal_Int32 XML_naryLim = 3562;
const sal_Int32 XML_naryPr = 3563;
const sal_Int32 XML_native = 3564;
const sal_Int32 XML_navajoWhite = 3565;
const sal_Int32 XML_navy = 3566;
const sal_Int32 XML_nc = 3567;
const sal_Int32 XML_nd = 3568;
const sal_Int32 XML_ndxf = 3569;
const sal_Int32 XML_neCell = 3570;
const sal_Int32 XML_negative = 3571;
const sal_Int32 XML_negativeBarColorSameAsPositive = 3572;
const sal_Int32 XML_negativeFillColor = 3573;
const sal_Int32 XML_negativeInteger = 3574;
const sal_Int32 XML_neq = 3575;
const sal_Int32 XML_never = 3576;
const sal_Int32 XML_new = 3577;
const sal_Int32 XML_newDocument = 3578;
const sal_Int32 XML_newLength = 3579;
const sal_Int32 XML_newName = 3580;
const sal_Int32 XML_newPage = 3581;
const sal_Int32 XML_newSection = 3582;
const sal_Int32 XML_newsflash = 3583;
const sal_Int32 XML_next = 3584;
const sal_Int32 XML_nextAc = 3585;
const sal_Int32 XML_nextClick = 3586;
const sal_Int32 XML_nextColumn = 3587;
const sal_Int32 XML_nextCondLst = 3588;
const sal_Int32 XML_nextId = 3589;
const sal_Int32 XML_nextMonth = 3590;
const sal_Int32 XML_nextPage = 3591;
const sal_Int32 XML_nextQuarter = 3592;
const sal_Int32 XML_nextTo = 3593;
const sal_Int32 XML_nextWeek = 3594;
const sal_Int32 XML_nextYear = 3595;
const sal_Int32 XML_nf = 3596;
const sal_Int32 XML_nil = 3597;
const sal_Int32 XML_nlCheck = 3598;
const sal_Int32 XML_noAdjustHandles = 3599;
const sal_Int32 XML_noArr = 3600;
const sal_Int32 XML_noAutofit = 3601;
const sal_Int32 XML_noBar = 3602;
const sal_Int32 XML_noBorder = 3603;
const sal_Int32 XML_noBreak = 3604;
const sal_Int32 XML_noBreakHyphen = 3605;
const sal_Int32 XML_noChangeArrowheads = 3606;
const sal_Int32 XML_noChangeAspect = 3607;
const sal_Int32 XML_noChangeShapeType = 3608;
const sal_Int32 XML_noColumnBalance = 3609;
const sal_Int32 XML_noControl = 3610;
const sal_Int32 XML_noConversion = 3611;
const sal_Int32 XML_noCrop = 3612;
const sal_Int32 XML_noDrilldown = 3613;
const sal_Int32 XML_noEditPoints = 3614;
const sal_Int32 XML_noEndCap = 3615;
const sal_Int32 XML_noEndnote = 3616;
const sal_Int32 XML_noExtraLineSpacing = 3617;
const sal_Int32 XML_noFill = 3618;
const sal_Int32 XML_noGrp = 3619;
const sal_Int32 XML_noHBand = 3620;
const sal_Int32 XML_noIndicator = 3621;
const sal_Int32 XML_noLabel = 3622;
const sal_Int32 XML_noLeading = 3623;
const sal_Int32 XML_noLineBreaksAfter = 3624;
const sal_Int32 XML_noLineBreaksBefore = 3625;
const sal_Int32 XML_noMove = 3626;
const sal_Int32 XML_noMultiLvlLbl = 3627;
const sal_Int32 XML_noProof = 3628;
const sal_Int32 XML_noPunctuationKerning = 3629;
const sal_Int32 XML_noResize = 3630;
const sal_Int32 XML_noResizeAllowed = 3631;
const sal_Int32 XML_noRot = 3632;
const sal_Int32 XML_noSelect = 3633;
const sal_Int32 XML_noSmoking = 3634;
const sal_Int32 XML_noSpaceRaiseLower = 3635;
const sal_Int32 XML_noStrike = 3636;
const sal_Int32 XML_noTabHangInd = 3637;
const sal_Int32 XML_noTextEdit = 3638;
const sal_Int32 XML_noUngrp = 3639;
const sal_Int32 XML_noVBand = 3640;
const sal_Int32 XML_noWrap = 3641;
const sal_Int32 XML_node = 3642;
const sal_Int32 XML_nodeHorzAlign = 3643;
const sal_Int32 XML_nodePh = 3644;
const sal_Int32 XML_nodeType = 3645;
const sal_Int32 XML_nodeVertAlign = 3646;
const sal_Int32 XML_nonAsst = 3647;
const sal_Int32 XML_nonAutoSortDefault = 3648;
const sal_Int32 XML_nonIsoscelesTrapezoid = 3649;
const sal_Int32 XML_nonNegativeInteger = 3650;
const sal_Int32 XML_nonNorm = 3651;
const sal_Int32 XML_nonPositiveInteger = 3652;
const sal_Int32 XML_none = 3653;
const sal_Int32 XML_nor = 3654;
const sal_Int32 XML_norm = 3655;
const sal_Int32 XML_normAutofit = 3656;
const sal_Int32 XML_normal = 3657;
const sal_Int32 XML_normalViewPr = 3658;
const sal_Int32 XML_normalizeH = 3659;
const sal_Int32 XML_normalizedString = 3660;
const sal_Int32 XML_northwest = 3661;
const sal_Int32 XML_notBeside = 3662;
const sal_Int32 XML_notBetween = 3663;
const sal_Int32 XML_notContains = 3664;
const sal_Int32 XML_notContainsBlanks = 3665;
const sal_Int32 XML_notContainsErrors = 3666;
const sal_Int32 XML_notContainsText = 3667;
const sal_Int32 XML_notEqual = 3668;
const sal_Int32 XML_notFirstPage = 3669;
const sal_Int32 XML_notSpecified = 3670;
const sal_Int32 XML_notTrueType = 3671;
const sal_Int32 XML_notchedRightArrow = 3672;
const sal_Int32 XML_notes = 3673;
const sal_Int32 XML_notesMaster = 3674;
const sal_Int32 XML_notesMasterId = 3675;
const sal_Int32 XML_notesMasterIdLst = 3676;
const sal_Int32 XML_notesMasterView = 3677;
const sal_Int32 XML_notesStyle = 3678;
const sal_Int32 XML_notesSz = 3679;
const sal_Int32 XML_notesTextViewPr = 3680;
const sal_Int32 XML_notesView = 3681;
const sal_Int32 XML_notesViewPr = 3682;
const sal_Int32 XML_nothing = 3683;
const sal_Int32 XML_np = 3684;
const sal_Int32 XML_ns = 3685;
const sal_Int32 XML_nsid = 3686;
const sal_Int32 XML_null = 3687;
const sal_Int32 XML_num = 3688;
const sal_Int32 XML_numCache = 3689;
const sal_Int32 XML_numCol = 3690;
const sal_Int32 XML_numDim = 3691;
const sal_Int32 XML_numFmt = 3692;
const sal_Int32 XML_numFmtId = 3693;
const sal_Int32 XML_numFmts = 3694;
const sal_Int32 XML_numForm = 3695;
const sal_Int32 XML_numId = 3696;
const sal_Int32 XML_numIdMacAtCleanup = 3697;
const sal_Int32 XML_numLit = 3698;
const sal_Int32 XML_numPicBullet = 3699;
const sal_Int32 XML_numPicBulletId = 3700;
const sal_Int32 XML_numPr = 3701;
const sal_Int32 XML_numRef = 3702;
const sal_Int32 XML_numRestart = 3703;
const sal_Int32 XML_numSld = 3704;
const sal_Int32 XML_numSpacing = 3705;
const sal_Int32 XML_numStart = 3706;
const sal_Int32 XML_numStyleLink = 3707;
const sal_Int32 XML_numTab = 3708;
const sal_Int32 XML_number = 3709;
const sal_Int32 XML_numberInDash = 3710;
const sal_Int32 XML_numberOfShades = 3711;
const sal_Int32 XML_numberStoredAsText = 3712;
const sal_Int32 XML_numbering = 3713;
const sal_Int32 XML_numberingChange = 3714;
const sal_Int32 XML_nvCxnSpPr = 3715;
const sal_Int32 XML_nvGraphicFramePr = 3716;
const sal_Int32 XML_nvGrpSpPr = 3717;
const sal_Int32 XML_nvPicPr = 3718;
const sal_Int32 XML_nvPr = 3719;
const sal_Int32 XML_nvSpPr = 3720;
const sal_Int32 XML_nwCell = 3721;
const sal_Int32 XML_o = 3722;
const sal_Int32 XML_oMath = 3723;
const sal_Int32 XML_oMathPara = 3724;
const sal_Int32 XML_oMathParaPr = 3725;
const sal_Int32 XML_obj = 3726;
const sal_Int32 XML_objAndTwoObj = 3727;
const sal_Int32 XML_objAndTx = 3728;
const sal_Int32 XML_objDist = 3729;
const sal_Int32 XML_objOnly = 3730;
const sal_Int32 XML_objOverTx = 3731;
const sal_Int32 XML_objTx = 3732;
const sal_Int32 XML_object = 3733;
const sal_Int32 XML_objectDefaults = 3734;
const sal_Int32 XML_objectType = 3735;
const sal_Int32 XML_objects = 3736;
const sal_Int32 XML_obliqueBottom = 3737;
const sal_Int32 XML_obliqueBottomLeft = 3738;
const sal_Int32 XML_obliqueBottomRight = 3739;
const sal_Int32 XML_obliqueLeft = 3740;
const sal_Int32 XML_obliqueRight = 3741;
const sal_Int32 XML_obliqueTop = 3742;
const sal_Int32 XML_obliqueTopLeft = 3743;
const sal_Int32 XML_obliqueTopRight = 3744;
const sal_Int32 XML_oblob = 3745;
const sal_Int32 XML_obscured = 3746;
const sal_Int32 XML_oc = 3747;
const sal_Int32 XML_octagon = 3748;
const sal_Int32 XML_ocx = 3749;
const sal_Int32 XML_ocxPr = 3750;
const sal_Int32 XML_odbc = 3751;
const sal_Int32 XML_odcFile = 3752;
const sal_Int32 XML_oddFooter = 3753;
const sal_Int32 XML_oddHBand = 3754;
const sal_Int32 XML_oddHeader = 3755;
const sal_Int32 XML_oddPage = 3756;
const sal_Int32 XML_oddVBand = 3757;
const sal_Int32 XML_odso = 3758;
const sal_Int32 XML_odxf = 3759;
const sal_Int32 XML_ofPieChart = 3760;
const sal_Int32 XML_ofPieType = 3761;
const sal_Int32 XML_off = 3762;
const sal_Int32 XML_offset = 3763;
const sal_Int32 XML_offset2 = 3764;
const sal_Int32 XML_offsetFrom = 3765;
const sal_Int32 XML_olapFunctions = 3766;
const sal_Int32 XML_olapPr = 3767;
const sal_Int32 XML_old = 3768;
const sal_Int32 XML_oldComment = 3769;
const sal_Int32 XML_oldCustomMenu = 3770;
const sal_Int32 XML_oldDescription = 3771;
const sal_Int32 XML_oldFormula = 3772;
const sal_Int32 XML_oldFunction = 3773;
const sal_Int32 XML_oldFunctionGroupId = 3774;
const sal_Int32 XML_oldHelp = 3775;
const sal_Int32 XML_oldHidden = 3776;
const sal_Int32 XML_oldLace = 3777;
const sal_Int32 XML_oldLength = 3778;
const sal_Int32 XML_oldName = 3779;
const sal_Int32 XML_oldPh = 3780;
const sal_Int32 XML_oldQuotePrefix = 3781;
const sal_Int32 XML_oldShortcutKey = 3782;
const sal_Int32 XML_oldStatusBar = 3783;
const sal_Int32 XML_ole = 3784;
const sal_Int32 XML_oleChartEl = 3785;
const sal_Int32 XML_oleItem = 3786;
const sal_Int32 XML_oleItems = 3787;
const sal_Int32 XML_oleLink = 3788;
const sal_Int32 XML_oleObj = 3789;
const sal_Int32 XML_oleObject = 3790;
const sal_Int32 XML_oleObjects = 3791;
const sal_Int32 XML_oleSize = 3792;
const sal_Int32 XML_oleUpdate = 3793;
const sal_Int32 XML_oleicon = 3794;
const sal_Int32 XML_oleid = 3795;
const sal_Int32 XML_olive = 3796;
const sal_Int32 XML_oliveDrab = 3797;
const sal_Int32 XML_on = 3798;
const sal_Int32 XML_onBegin = 3799;
const sal_Int32 XML_onClick = 3800;
const sal_Int32 XML_onDblClick = 3801;
const sal_Int32 XML_onEnd = 3802;
const sal_Int32 XML_onMouseOut = 3803;
const sal_Int32 XML_onMouseOver = 3804;
const sal_Int32 XML_onNext = 3805;
const sal_Int32 XML_onPrev = 3806;
const sal_Int32 XML_onStopAudio = 3807;
const sal_Int32 XML_one = 3808;
const sal_Int32 XML_oneCell = 3809;
const sal_Int32 XML_oneCellAnchor = 3810;
const sal_Int32 XML_oneField = 3811;
const sal_Int32 XML_oned = 3812;
const sal_Int32 XML_onlySync = 3813;
const sal_Int32 XML_onlyUseConnectionFile = 3814;
const sal_Int32 XML_op = 3815;
const sal_Int32 XML_opEmu = 3816;
const sal_Int32 XML_opacity = 3817;
const sal_Int32 XML_opacity2 = 3818;
const sal_Int32 XML_open = 3819;
const sal_Int32 XML_openDmnd = 3820;
const sal_Int32 XML_operator = 3821;
const sal_Int32 XML_optimizeForBrowser = 3822;
const sal_Int32 XML_optimizeMemory = 3823;
const sal_Int32 XML_orange = 3824;
const sal_Int32 XML_orangeRed = 3825;
const sal_Int32 XML_orchid = 3826;
const sal_Int32 XML_order = 3827;
const sal_Int32 XML_ordinal = 3828;
const sal_Int32 XML_ordinalText = 3829;
const sal_Int32 XML_orgChart = 3830;
const sal_Int32 XML_organizeInFolders = 3831;
const sal_Int32 XML_orgchart = 3832;
const sal_Int32 XML_orient = 3833;
const sal_Int32 XML_orientation = 3834;
const sal_Int32 XML_orientationangle = 3835;
const sal_Int32 XML_origin = 3836;
const sal_Int32 XML_original = 3837;
const sal_Int32 XML_orthographicFront = 3838;
const sal_Int32 XML_ostorage = 3839;
const sal_Int32 XML_ostream = 3840;
const sal_Int32 XML_other = 3841;
const sal_Int32 XML_otherStyle = 3842;
const sal_Int32 XML_out = 3843;
const sal_Int32 XML_outByRing = 3844;
const sal_Int32 XML_outEnd = 3845;
const sal_Int32 XML_outer = 3846;
const sal_Int32 XML_outerShdw = 3847;
const sal_Int32 XML_outline = 3848;
const sal_Int32 XML_outline1pPr = 3849;
const sal_Int32 XML_outline2pPr = 3850;
const sal_Int32 XML_outlineData = 3851;
const sal_Int32 XML_outlineLevel = 3852;
const sal_Int32 XML_outlineLevelCol = 3853;
const sal_Int32 XML_outlineLevelRow = 3854;
const sal_Int32 XML_outlineLvl = 3855;
const sal_Int32 XML_outlinePr = 3856;
const sal_Int32 XML_outlineSymbols = 3857;
const sal_Int32 XML_outlineView = 3858;
const sal_Int32 XML_outlineViewPr = 3859;
const sal_Int32 XML_outset = 3860;
const sal_Int32 XML_outside = 3861;
const sal_Int32 XML_outsideMargin = 3862;
const sal_Int32 XML_oval = 3863;
const sal_Int32 XML_ovals = 3864;
const sal_Int32 XML_over = 3865;
const sal_Int32 XML_overThenDown = 3866;
const sal_Int32 XML_overflow = 3867;
const sal_Int32 XML_overflowPunct = 3868;
const sal_Int32 XML_overhead = 3869;
const sal_Int32 XML_overlap = 3870;
const sal_Int32 XML_overlay = 3871;
const sal_Int32 XML_override = 3872;
const sal_Int32 XML_overrideClrMapping = 3873;
const sal_Int32 XML_overwriteClear = 3874;
const sal_Int32 XML_owners = 3875;
const sal_Int32 XML_p = 3876;
const sal_Int32 XML_p14 = 3877;
const sal_Int32 XML_p15 = 3878;
const sal_Int32 XML_pBdr = 3879;
const sal_Int32 XML_pLen = 3880;
const sal_Int32 XML_pPos = 3881;
const sal_Int32 XML_pPr = 3882;
const sal_Int32 XML_pPrChange = 3883;
const sal_Int32 XML_pPrDefault = 3884;
const sal_Int32 XML_pRg = 3885;
const sal_Int32 XML_pStyle = 3886;
const sal_Int32 XML_packages = 3887;
const sal_Int32 XML_page = 3888;
const sal_Int32 XML_pageBottom = 3889;
const sal_Int32 XML_pageBreakBefore = 3890;
const sal_Int32 XML_pageBreakPreview = 3891;
const sal_Int32 XML_pageField = 3892;
const sal_Int32 XML_pageFieldLabels = 3893;
const sal_Int32 XML_pageFieldValues = 3894;
const sal_Int32 XML_pageFields = 3895;
const sal_Int32 XML_pageItem = 3896;
const sal_Int32 XML_pageLayout = 3897;
const sal_Int32 XML_pageMargins = 3898;
const sal_Int32 XML_pageOrder = 3899;
const sal_Int32 XML_pageOverThenDown = 3900;
const sal_Int32 XML_pageSetUpPr = 3901;
const sal_Int32 XML_pageSetup = 3902;
const sal_Int32 XML_pageStyle = 3903;
const sal_Int32 XML_pageWrap = 3904;
const sal_Int32 XML_pages = 3905;
const sal_Int32 XML_paleGoldenrod = 3906;
const sal_Int32 XML_paleGreen = 3907;
const sal_Int32 XML_paleTurquoise = 3908;
const sal_Int32 XML_paleVioletRed = 3909;
const sal_Int32 XML_palmsBlack = 3910;
const sal_Int32 XML_palmsColor = 3911;
const sal_Int32 XML_pan = 3912;
const sal_Int32 XML_pane = 3913;
const sal_Int32 XML_panose = 3914;
const sal_Int32 XML_panose1 = 3915;
const sal_Int32 XML_papayaWhip = 3916;
const sal_Int32 XML_paperClips = 3917;
const sal_Int32 XML_paperHeight = 3918;
const sal_Int32 XML_paperSize = 3919;
const sal_Int32 XML_paperSrc = 3920;
const sal_Int32 XML_paperUnits = 3921;
const sal_Int32 XML_paperWidth = 3922;
const sal_Int32 XML_papyrus = 3923;
const sal_Int32 XML_par = 3924;
const sal_Int32 XML_parOf = 3925;
const sal_Int32 XML_parTrans = 3926;
const sal_Int32 XML_parTransId = 3927;
const sal_Int32 XML_parTxLTRAlign = 3928;
const sal_Int32 XML_parTxRTLAlign = 3929;
const sal_Int32 XML_paraId = 3930;
const sal_Int32 XML_paraIdParent = 3931;
const sal_Int32 XML_paragraph = 3932;
const sal_Int32 XML_parallel = 3933;
const sal_Int32 XML_parallelogram = 3934;
const sal_Int32 XML_param = 3935;
const sal_Int32 XML_parameter = 3936;
const sal_Int32 XML_parameterType = 3937;
const sal_Int32 XML_parameters = 3938;
const sal_Int32 XML_parent = 3939;
const sal_Int32 XML_parentSet = 3940;
const sal_Int32 XML_paretoLine = 3941;
const sal_Int32 XML_parsePre = 3942;
const sal_Int32 XML_partyFavor = 3943;
const sal_Int32 XML_partyGlass = 3944;
const sal_Int32 XML_password = 3945;
const sal_Int32 XML_pasteAll = 3946;
const sal_Int32 XML_pasteBorders = 3947;
const sal_Int32 XML_pasteColWidths = 3948;
const sal_Int32 XML_pasteComments = 3949;
const sal_Int32 XML_pasteDataValidation = 3950;
const sal_Int32 XML_pasteFormats = 3951;
const sal_Int32 XML_pasteFormulas = 3952;
const sal_Int32 XML_pasteNumberFormats = 3953;
const sal_Int32 XML_pasteValues = 3954;
const sal_Int32 XML_path = 3955;
const sal_Int32 XML_pathEditMode = 3956;
const sal_Int32 XML_pathLst = 3957;
const sal_Int32 XML_pattFill = 3958;
const sal_Int32 XML_pattern = 3959;
const sal_Int32 XML_patternFill = 3960;
const sal_Int32 XML_patternType = 3961;
const sal_Int32 XML_pct = 3962;
const sal_Int32 XML_pct10 = 3963;
const sal_Int32 XML_pct12 = 3964;
const sal_Int32 XML_pct15 = 3965;
const sal_Int32 XML_pct20 = 3966;
const sal_Int32 XML_pct25 = 3967;
const sal_Int32 XML_pct30 = 3968;
const sal_Int32 XML_pct35 = 3969;
const sal_Int32 XML_pct37 = 3970;
const sal_Int32 XML_pct40 = 3971;
const sal_Int32 XML_pct45 = 3972;
const sal_Int32 XML_pct5 = 3973;
const sal_Int32 XML_pct50 = 3974;
const sal_Int32 XML_pct55 = 3975;
const sal_Int32 XML_pct60 = 3976;
const sal_Int32 XML_pct62 = 3977;
const sal_Int32 XML_pct65 = 3978;
const sal_Int32 XML_pct70 = 3979;
const sal_Int32 XML_pct75 = 3980;
const sal_Int32 XML_pct80 = 3981;
const sal_Int32 XML_pct85 = 3982;
const sal_Int32 XML_pct87 = 3983;
const sal_Int32 XML_pct90 = 3984;
const sal_Int32 XML_pct95 = 3985;
const sal_Int32 XML_pctHeight = 3986;
const sal_Int32 XML_pctPosHOffset = 3987;
const sal_Int32 XML_pctPosVOffset = 3988;
const sal_Int32 XML_pctWidth = 3989;
const sal_Int32 XML_peachPuff = 3990;
const sal_Int32 XML_penClr = 3991;
const sal_Int32 XML_pencilSize = 3992;
const sal_Int32 XML_pencils = 3993;
const sal_Int32 XML_pentagon = 3994;
const sal_Int32 XML_people = 3995;
const sal_Int32 XML_peopleHats = 3996;
const sal_Int32 XML_peopleWaving = 3997;
const sal_Int32 XML_percent = 3998;
const sal_Int32 XML_percentDiff = 3999;
const sal_Int32 XML_percentOfCol = 4000;
const sal_Int32 XML_percentOfRow = 4001;
const sal_Int32 XML_percentOfTotal = 4002;
const sal_Int32 XML_percentStacked = 4003;
const sal_Int32 XML_percentage = 4004;
const sal_Int32 XML_percentile = 4005;
const sal_Int32 XML_period = 4006;
const sal_Int32 XML_permEnd = 4007;
const sal_Int32 XML_permStart = 4008;
const sal_Int32 XML_persistPropertyBag = 4009;
const sal_Int32 XML_persistStorage = 4010;
const sal_Int32 XML_persistStream = 4011;
const sal_Int32 XML_persistStreamInit = 4012;
const sal_Int32 XML_persistence = 4013;
const sal_Int32 XML_personal = 4014;
const sal_Int32 XML_personalCompose = 4015;
const sal_Int32 XML_personalReply = 4016;
const sal_Int32 XML_personalView = 4017;
const sal_Int32 XML_perspective = 4018;
const sal_Int32 XML_perspectiveAbove = 4019;
const sal_Int32 XML_perspectiveAboveLeftFacing = 4020;
const sal_Int32 XML_perspectiveAboveRightFacing = 4021;
const sal_Int32 XML_perspectiveBelow = 4022;
const sal_Int32 XML_perspectiveContrastingLeftFacing = 4023;
const sal_Int32 XML_perspectiveContrastingRightFacing = 4024;
const sal_Int32 XML_perspectiveFront = 4025;
const sal_Int32 XML_perspectiveHeroicExtremeLeftFacing = 4026;
const sal_Int32 XML_perspectiveHeroicExtremeRightFacing = 4027;
const sal_Int32 XML_perspectiveHeroicLeftFacing = 4028;
const sal_Int32 XML_perspectiveHeroicRightFacing = 4029;
const sal_Int32 XML_perspectiveLeft = 4030;
const sal_Int32 XML_perspectiveRelaxed = 4031;
const sal_Int32 XML_perspectiveRelaxedModerately = 4032;
const sal_Int32 XML_perspectiveRight = 4033;
const sal_Int32 XML_peru = 4034;
const sal_Int32 XML_pg = 4035;
const sal_Int32 XML_pgBorders = 4036;
const sal_Int32 XML_pgMar = 4037;
const sal_Int32 XML_pgNum = 4038;
const sal_Int32 XML_pgNumB = 4039;
const sal_Int32 XML_pgNumMargins = 4040;
const sal_Int32 XML_pgNumT = 4041;
const sal_Int32 XML_pgNumType = 4042;
const sal_Int32 XML_pgSz = 4043;
const sal_Int32 XML_ph = 4044;
const sal_Int32 XML_phClr = 4045;
const sal_Int32 XML_phant = 4046;
const sal_Int32 XML_phantPr = 4047;
const sal_Int32 XML_phldr = 4048;
const sal_Int32 XML_phldrT = 4049;
const sal_Int32 XML_phonetic = 4050;
const sal_Int32 XML_phoneticPr = 4051;
const sal_Int32 XML_photoAlbum = 4052;
const sal_Int32 XML_pic = 4053;
const sal_Int32 XML_picLocks = 4054;
const sal_Int32 XML_picTx = 4055;
const sal_Int32 XML_pict = 4056;
const sal_Int32 XML_picture = 4057;
const sal_Int32 XML_pictureFormat = 4058;
const sal_Int32 XML_pictureOptions = 4059;
const sal_Int32 XML_pictureStackUnit = 4060;
const sal_Int32 XML_pid = 4061;
const sal_Int32 XML_pie = 4062;
const sal_Int32 XML_pie3DChart = 4063;
const sal_Int32 XML_pieChart = 4064;
const sal_Int32 XML_pieWedge = 4065;
const sal_Int32 XML_pinYin = 4066;
const sal_Int32 XML_pink = 4067;
const sal_Int32 XML_pitch = 4068;
const sal_Int32 XML_pitchFamily = 4069;
const sal_Int32 XML_pivot = 4070;
const sal_Int32 XML_pivotArea = 4071;
const sal_Int32 XML_pivotAreas = 4072;
const sal_Int32 XML_pivotButton = 4073;
const sal_Int32 XML_pivotCache = 4074;
const sal_Int32 XML_pivotCacheDefinition = 4075;
const sal_Int32 XML_pivotCacheRecords = 4076;
const sal_Int32 XML_pivotCaches = 4077;
const sal_Int32 XML_pivotField = 4078;
const sal_Int32 XML_pivotFields = 4079;
const sal_Int32 XML_pivotFmt = 4080;
const sal_Int32 XML_pivotFmts = 4081;
const sal_Int32 XML_pivotHierarchies = 4082;
const sal_Int32 XML_pivotHierarchy = 4083;
const sal_Int32 XML_pivotSelection = 4084;
const sal_Int32 XML_pivotSource = 4085;
const sal_Int32 XML_pivotTable = 4086;
const sal_Int32 XML_pivotTableDefinition = 4087;
const sal_Int32 XML_pivotTableStyle = 4088;
const sal_Int32 XML_pivotTableStyleInfo = 4089;
const sal_Int32 XML_pivotTables = 4090;
const sal_Int32 XML_pixelsPerInch = 4091;
const sal_Int32 XML_placeholder = 4092;
const sal_Int32 XML_placeholders = 4093;
const sal_Int32 XML_plaid = 4094;
const sal_Int32 XML_plane = 4095;
const sal_Int32 XML_plaque = 4096;
const sal_Int32 XML_plaqueTabs = 4097;
const sal_Int32 XML_plastic = 4098;
const sal_Int32 XML_plcHide = 4099;
const sal_Int32 XML_plotArea = 4100;
const sal_Int32 XML_plotArea3D = 4101;
const sal_Int32 XML_plotAreaRegion = 4102;
const sal_Int32 XML_plotSurface = 4103;
const sal_Int32 XML_plotVisOnly = 4104;
const sal_Int32 XML_plum = 4105;
const sal_Int32 XML_plus = 4106;
const sal_Int32 XML_poinsettias = 4107;
const sal_Int32 XML_points = 4108;
const sal_Int32 XML_polar = 4109;
const sal_Int32 XML_poly = 4110;
const sal_Int32 XML_polyline = 4111;
const sal_Int32 XML_portrait = 4112;
const sal_Int32 XML_pos = 4113;
const sal_Int32 XML_posEven = 4114;
const sal_Int32 XML_posOdd = 4115;
const sal_Int32 XML_posOffset = 4116;
const sal_Int32 XML_position = 4117;
const sal_Int32 XML_positionH = 4118;
const sal_Int32 XML_positionV = 4119;
const sal_Int32 XML_positiveInteger = 4120;
const sal_Int32 XML_post = 4121;
const sal_Int32 XML_postSp = 4122;
const sal_Int32 XML_postageStamp = 4123;
const sal_Int32 XML_powder = 4124;
const sal_Int32 XML_powderBlue = 4125;
const sal_Int32 XML_power = 4126;
const sal_Int32 XML_prLst = 4127;
const sal_Int32 XML_prSet = 4128;
const sal_Int32 XML_preSp = 4129;
const sal_Int32 XML_preced = 4130;
const sal_Int32 XML_precedSib = 4131;
const sal_Int32 XML_preferPic = 4132;
const sal_Int32 XML_preferRelativeResize = 4133;
const sal_Int32 XML_preferSingleView = 4134;
const sal_Int32 XML_preferrelative = 4135;
const sal_Int32 XML_prefixMappings = 4136;
const sal_Int32 XML_pres = 4137;
const sal_Int32 XML_presAssocID = 4138;
const sal_Int32 XML_presId = 4139;
const sal_Int32 XML_presLayoutVars = 4140;
const sal_Int32 XML_presName = 4141;
const sal_Int32 XML_presOf = 4142;
const sal_Int32 XML_presParOf = 4143;
const sal_Int32 XML_presStyleCnt = 4144;
const sal_Int32 XML_presStyleIdx = 4145;
const sal_Int32 XML_presStyleLbl = 4146;
const sal_Int32 XML_present = 4147;
const sal_Int32 XML_presentation = 4148;
const sal_Int32 XML_presentationAccent = 4149;
const sal_Int32 XML_presentationPr = 4150;
const sal_Int32 XML_presentationText = 4151;
const sal_Int32 XML_preserve = 4152;
const sal_Int32 XML_preserveFormatting = 4153;
const sal_Int32 XML_preserveHistory = 4154;
const sal_Int32 XML_preserveSortFilterLayout = 4155;
const sal_Int32 XML_presetClass = 4156;
const sal_Int32 XML_presetID = 4157;
const sal_Int32 XML_presetSubtype = 4158;
const sal_Int32 XML_pressure = 4159;
const sal_Int32 XML_prev = 4160;
const sal_Int32 XML_prevAc = 4161;
const sal_Int32 XML_prevCondLst = 4162;
const sal_Int32 XML_previousCol = 4163;
const sal_Int32 XML_previousRow = 4164;
const sal_Int32 XML_pri = 4165;
const sal_Int32 XML_primFontSz = 4166;
const sal_Int32 XML_print = 4167;
const sal_Int32 XML_printArea = 4168;
const sal_Int32 XML_printBodyTextBeforeHeader = 4169;
const sal_Int32 XML_printColBlack = 4170;
const sal_Int32 XML_printDrill = 4171;
const sal_Int32 XML_printFormsData = 4172;
const sal_Int32 XML_printFractionalCharacterWidth = 4173;
const sal_Int32 XML_printOptions = 4174;
const sal_Int32 XML_printPostScriptOverText = 4175;
const sal_Int32 XML_printSettings = 4176;
const sal_Int32 XML_printTwoOnOne = 4177;
const sal_Int32 XML_printer = 4178;
const sal_Int32 XML_printerSettings = 4179;
const sal_Int32 XML_priority = 4180;
const sal_Int32 XML_prism = 4181;
const sal_Int32 XML_prnPr = 4182;
const sal_Int32 XML_prnWhat = 4183;
const sal_Int32 XML_product = 4184;
const sal_Int32 XML_productSubtotal = 4185;
const sal_Int32 XML_progId = 4186;
const sal_Int32 XML_progress = 4187;
const sal_Int32 XML_prompt = 4188;
const sal_Int32 XML_promptTitle = 4189;
const sal_Int32 XML_promptedSolutions = 4190;
const sal_Int32 XML_proofErr = 4191;
const sal_Int32 XML_proofState = 4192;
const sal_Int32 XML_property = 4193;
const sal_Int32 XML_propertyName = 4194;
const sal_Int32 XML_props3d = 4195;
const sal_Int32 XML_prot = 4196;
const sal_Int32 XML_protected = 4197;
const sal_Int32 XML_protectedRange = 4198;
const sal_Int32 XML_protectedRanges = 4199;
const sal_Int32 XML_protection = 4200;
const sal_Int32 XML_provid = 4201;
const sal_Int32 XML_proxy = 4202;
const sal_Int32 XML_prst = 4203;
const sal_Int32 XML_prstClr = 4204;
const sal_Int32 XML_prstDash = 4205;
const sal_Int32 XML_prstGeom = 4206;
const sal_Int32 XML_prstMaterial = 4207;
const sal_Int32 XML_prstShdw = 4208;
const sal_Int32 XML_prstTrans = 4209;
const sal_Int32 XML_prstTxWarp = 4210;
const sal_Int32 XML_pt = 4211;
const sal_Int32 XML_ptCount = 4212;
const sal_Int32 XML_ptInCategory = 4213;
const sal_Int32 XML_ptInSeries = 4214;
const sal_Int32 XML_ptLst = 4215;
const sal_Int32 XML_ptType = 4216;
const sal_Int32 XML_ptab = 4217;
const sal_Int32 XML_ptsTypes = 4218;
const sal_Int32 XML_pubBrowser = 4219;
const sal_Int32 XML_publishItems = 4220;
const sal_Int32 XML_publishToServer = 4221;
const sal_Int32 XML_published = 4222;
const sal_Int32 XML_pull = 4223;
const sal_Int32 XML_pumpkin1 = 4224;
const sal_Int32 XML_purple = 4225;
const sal_Int32 XML_push = 4226;
const sal_Int32 XML_pushPinNote1 = 4227;
const sal_Int32 XML_pushPinNote2 = 4228;
const sal_Int32 XML_pyra = 4229;
const sal_Int32 XML_pyraAcctBkgdNode = 4230;
const sal_Int32 XML_pyraAcctPos = 4231;
const sal_Int32 XML_pyraAcctRatio = 4232;
const sal_Int32 XML_pyraAcctTxMar = 4233;
const sal_Int32 XML_pyraAcctTxNode = 4234;
const sal_Int32 XML_pyraLvlNode = 4235;
const sal_Int32 XML_pyramid = 4236;
const sal_Int32 XML_pyramidToMax = 4237;
const sal_Int32 XML_pyramids = 4238;
const sal_Int32 XML_pyramidsAbove = 4239;
const sal_Int32 XML_qFormat = 4240;
const sal_Int32 XML_qs = 4241;
const sal_Int32 XML_qsCatId = 4242;
const sal_Int32 XML_qsTypeId = 4243;
const sal_Int32 XML_quadArrow = 4244;
const sal_Int32 XML_quadArrowCallout = 4245;
const sal_Int32 XML_quadBezTo = 4246;
const sal_Int32 XML_quadrants = 4247;
const sal_Int32 XML_qualifier = 4248;
const sal_Int32 XML_quarter = 4249;
const sal_Int32 XML_quarters = 4250;
const sal_Int32 XML_query = 4251;
const sal_Int32 XML_queryCache = 4252;
const sal_Int32 XML_queryFailed = 4253;
const sal_Int32 XML_queryTable = 4254;
const sal_Int32 XML_queryTableDeletedFields = 4255;
const sal_Int32 XML_queryTableField = 4256;
const sal_Int32 XML_queryTableFieldId = 4257;
const sal_Int32 XML_queryTableFields = 4258;
const sal_Int32 XML_queryTableRefresh = 4259;
const sal_Int32 XML_quickTimeFile = 4260;
const sal_Int32 XML_quotePrefix = 4261;
const sal_Int32 XML_r = 4262;
const sal_Int32 XML_r1 = 4263;
const sal_Int32 XML_r2 = 4264;
const sal_Int32 XML_r4 = 4265;
const sal_Int32 XML_r8 = 4266;
const sal_Int32 XML_rAng = 4267;
const sal_Int32 XML_rAngAx = 4268;
const sal_Int32 XML_rB = 4269;
const sal_Int32 XML_rCtr = 4270;
const sal_Int32 XML_rCtrCh = 4271;
const sal_Int32 XML_rCtrDes = 4272;
const sal_Int32 XML_rFont = 4273;
const sal_Int32 XML_rFonts = 4274;
const sal_Int32 XML_rId = 4275;
const sal_Int32 XML_rIns = 4276;
const sal_Int32 XML_rMarg = 4277;
const sal_Int32 XML_rMargin = 4278;
const sal_Int32 XML_rOff = 4279;
const sal_Int32 XML_rPh = 4280;
const sal_Int32 XML_rPr = 4281;
const sal_Int32 XML_rPrChange = 4282;
const sal_Int32 XML_rPrDefault = 4283;
const sal_Int32 XML_rSp = 4284;
const sal_Int32 XML_rSpRule = 4285;
const sal_Int32 XML_rStyle = 4286;
const sal_Int32 XML_rT = 4287;
const sal_Int32 XML_ra = 4288;
const sal_Int32 XML_rad = 4289;
const sal_Int32 XML_radPr = 4290;
const sal_Int32 XML_radarChart = 4291;
const sal_Int32 XML_radarStyle = 4292;
const sal_Int32 XML_radial = 4293;
const sal_Int32 XML_radiusrange = 4294;
const sal_Int32 XML_raf = 4295;
const sal_Int32 XML_random = 4296;
const sal_Int32 XML_randomBar = 4297;
const sal_Int32 XML_range = 4298;
const sal_Int32 XML_rangePr = 4299;
const sal_Int32 XML_rangeSet = 4300;
const sal_Int32 XML_rangeSets = 4301;
const sal_Int32 XML_rank = 4302;
const sal_Int32 XML_rankBy = 4303;
const sal_Int32 XML_rc = 4304;
const sal_Int32 XML_rcc = 4305;
const sal_Int32 XML_rcft = 4306;
const sal_Int32 XML_rcmt = 4307;
const sal_Int32 XML_rctx = 4308;
const sal_Int32 XML_rcv = 4309;
const sal_Int32 XML_rd = 4310;
const sal_Int32 XML_rdn = 4311;
const sal_Int32 XML_readModeInkLockDown = 4312;
const sal_Int32 XML_readOnly = 4313;
const sal_Int32 XML_readOnlyRecommended = 4314;
const sal_Int32 XML_readingOrder = 4315;
const sal_Int32 XML_realTimeData = 4316;
const sal_Int32 XML_recipientData = 4317;
const sal_Int32 XML_recipients = 4318;
const sal_Int32 XML_recolor = 4319;
const sal_Int32 XML_recolortarget = 4320;
const sal_Int32 XML_recommended = 4321;
const sal_Int32 XML_reconnectionMethod = 4322;
const sal_Int32 XML_recordCount = 4323;
const sal_Int32 XML_rect = 4324;
const sal_Int32 XML_red = 4325;
const sal_Int32 XML_redMod = 4326;
const sal_Int32 XML_redOff = 4327;
const sal_Int32 XML_ref = 4328;
const sal_Int32 XML_ref3D = 4329;
const sal_Int32 XML_refError = 4330;
const sal_Int32 XML_refFor = 4331;
const sal_Int32 XML_refForName = 4332;
const sal_Int32 XML_refMode = 4333;
const sal_Int32 XML_refPtType = 4334;
const sal_Int32 XML_refType = 4335;
const sal_Int32 XML_reference = 4336;
const sal_Int32 XML_references = 4337;
const sal_Int32 XML_refersTo = 4338;
const sal_Int32 XML_reflection = 4339;
const sal_Int32 XML_refreshAllConnections = 4340;
const sal_Int32 XML_refreshError = 4341;
const sal_Int32 XML_refreshOnChange = 4342;
const sal_Int32 XML_refreshOnLoad = 4343;
const sal_Int32 XML_refreshedBy = 4344;
const sal_Int32 XML_refreshedDate = 4345;
const sal_Int32 XML_refreshedVersion = 4346;
const sal_Int32 XML_regionMap = 4347;
const sal_Int32 XML_regroupid = 4348;
const sal_Int32 XML_regrouptable = 4349;
const sal_Int32 XML_regular = 4350;
const sal_Int32 XML_rel = 4351;
const sal_Int32 XML_relId = 4352;
const sal_Int32 XML_relIds = 4353;
const sal_Int32 XML_relOff = 4354;
const sal_Int32 XML_relSizeAnchor = 4355;
const sal_Int32 XML_relation = 4356;
const sal_Int32 XML_relationtable = 4357;
const sal_Int32 XML_relative = 4358;
const sal_Int32 XML_relativeFrom = 4359;
const sal_Int32 XML_relativeHeight = 4360;
const sal_Int32 XML_relativeIndent = 4361;
const sal_Int32 XML_relativeTo = 4362;
const sal_Int32 XML_relaxedInset = 4363;
const sal_Int32 XML_relid = 4364;
const sal_Int32 XML_relyOnVML = 4365;
const sal_Int32 XML_relyOnVml = 4366;
const sal_Int32 XML_remove = 4367;
const sal_Int32 XML_removeDataOnSave = 4368;
const sal_Int32 XML_removeDateAndTime = 4369;
const sal_Int32 XML_removePersonalInfoOnSave = 4370;
const sal_Int32 XML_removePersonalInformation = 4371;
const sal_Int32 XML_render = 4372;
const sal_Int32 XML_repairLoad = 4373;
const sal_Int32 XML_repeat = 4374;
const sal_Int32 XML_repeatCount = 4375;
const sal_Int32 XML_repeatDur = 4376;
const sal_Int32 XML_repl = 4377;
const sal_Int32 XML_resId = 4378;
const sal_Int32 XML_reservationPassword = 4379;
const sal_Int32 XML_resizeGraphics = 4380;
const sal_Int32 XML_resizeHandles = 4381;
const sal_Int32 XML_rest = 4382;
const sal_Int32 XML_restart = 4383;
const sal_Int32 XML_restored = 4384;
const sal_Int32 XML_restoredLeft = 4385;
const sal_Int32 XML_restoredTop = 4386;
const sal_Int32 XML_result = 4387;
const sal_Int32 XML_rev = 4388;
const sal_Int32 XML_revDir = 4389;
const sal_Int32 XML_revPos = 4390;
const sal_Int32 XML_reveal = 4391;
const sal_Int32 XML_reverse = 4392;
const sal_Int32 XML_reverseDiagStripe = 4393;
const sal_Int32 XML_reviewed = 4394;
const sal_Int32 XML_reviewedList = 4395;
const sal_Int32 XML_revision = 4396;
const sal_Int32 XML_revisionId = 4397;
const sal_Int32 XML_revisionView = 4398;
const sal_Int32 XML_revisions = 4399;
const sal_Int32 XML_revisionsPassword = 4400;
const sal_Int32 XML_rfmt = 4401;
const sal_Int32 XML_rgb = 4402;
const sal_Int32 XML_rgbColor = 4403;
const sal_Int32 XML_ribbon = 4404;
const sal_Int32 XML_ribbon2 = 4405;
const sal_Int32 XML_riblet = 4406;
const sal_Int32 XML_rich = 4407;
const sal_Int32 XML_richText = 4408;
const sal_Int32 XML_rig = 4409;
const sal_Int32 XML_right = 4410;
const sal_Int32 XML_rightArrow = 4411;
const sal_Int32 XML_rightArrowCallout = 4412;
const sal_Int32 XML_rightBrace = 4413;
const sal_Int32 XML_rightBracket = 4414;
const sal_Int32 XML_rightChars = 4415;
const sal_Int32 XML_rightFromText = 4416;
const sal_Int32 XML_rightMargin = 4417;
const sal_Int32 XML_rightToLeft = 4418;
const sal_Int32 XML_rightVertical = 4419;
const sal_Int32 XML_rings = 4420;
const sal_Int32 XML_ripple = 4421;
const sal_Int32 XML_ris = 4422;
const sal_Int32 XML_rm = 4423;
const sal_Int32 XML_rnd = 4424;
const sal_Int32 XML_roman = 4425;
const sal_Int32 XML_romanLcParenBoth = 4426;
const sal_Int32 XML_romanLcParenR = 4427;
const sal_Int32 XML_romanLcPeriod = 4428;
const sal_Int32 XML_romanUcParenBoth = 4429;
const sal_Int32 XML_romanUcParenR = 4430;
const sal_Int32 XML_romanUcPeriod = 4431;
const sal_Int32 XML_root = 4432;
const sal_Int32 XML_rosyBrown = 4433;
const sal_Int32 XML_rot = 4434;
const sal_Int32 XML_rotPath = 4435;
const sal_Int32 XML_rotWithShape = 4436;
const sal_Int32 XML_rotX = 4437;
const sal_Int32 XML_rotY = 4438;
const sal_Int32 XML_rotate = 4439;
const sal_Int32 XML_rotation = 4440;
const sal_Int32 XML_rotationangle = 4441;
const sal_Int32 XML_rotationcenter = 4442;
const sal_Int32 XML_round = 4443;
const sal_Int32 XML_round1Rect = 4444;
const sal_Int32 XML_round2DiagRect = 4445;
const sal_Int32 XML_round2SameRect = 4446;
const sal_Int32 XML_roundRect = 4447;
const sal_Int32 XML_roundedCorners = 4448;
const sal_Int32 XML_roundrect = 4449;
const sal_Int32 XML_row = 4450;
const sal_Int32 XML_rowBreaks = 4451;
const sal_Int32 XML_rowColShift = 4452;
const sal_Int32 XML_rowDrillCount = 4453;
const sal_Int32 XML_rowFields = 4454;
const sal_Int32 XML_rowGrandTotals = 4455;
const sal_Int32 XML_rowHeaderCaption = 4456;
const sal_Int32 XML_rowHidden = 4457;
const sal_Int32 XML_rowHierarchiesUsage = 4458;
const sal_Int32 XML_rowHierarchyUsage = 4459;
const sal_Int32 XML_rowItems = 4460;
const sal_Int32 XML_rowNumbers = 4461;
const sal_Int32 XML_rowOff = 4462;
const sal_Int32 XML_rowPageCount = 4463;
const sal_Int32 XML_rowSpan = 4464;
const sal_Int32 XML_rows = 4465;
const sal_Int32 XML_royalBlue = 4466;
const sal_Int32 XML_rqt = 4467;
const sal_Int32 XML_rrc = 4468;
const sal_Int32 XML_rsaAES = 4469;
const sal_Int32 XML_rsaFull = 4470;
const sal_Int32 XML_rsid = 4471;
const sal_Int32 XML_rsidDel = 4472;
const sal_Int32 XML_rsidP = 4473;
const sal_Int32 XML_rsidR = 4474;
const sal_Int32 XML_rsidRDefault = 4475;
const sal_Int32 XML_rsidRPr = 4476;
const sal_Int32 XML_rsidRoot = 4477;
const sal_Int32 XML_rsidSect = 4478;
const sal_Int32 XML_rsidTr = 4479;
const sal_Int32 XML_rsids = 4480;
const sal_Int32 XML_rsnm = 4481;
const sal_Int32 XML_rt = 4482;
const sal_Int32 XML_rtShortDist = 4483;
const sal_Int32 XML_rtTriangle = 4484;
const sal_Int32 XML_rtf = 4485;
const sal_Int32 XML_rtl = 4486;
const sal_Int32 XML_rtlCol = 4487;
const sal_Int32 XML_rtlGutter = 4488;
const sal_Int32 XML_rtn = 4489;
const sal_Int32 XML_ru = 4490;
const sal_Int32 XML_ruby = 4491;
const sal_Int32 XML_rubyAlign = 4492;
const sal_Int32 XML_rubyBase = 4493;
const sal_Int32 XML_rubyPr = 4494;
const sal_Int32 XML_rule = 4495;
const sal_Int32 XML_ruleLst = 4496;
const sal_Int32 XML_rules = 4497;
const sal_Int32 XML_runTotal = 4498;
const sal_Int32 XML_rupBuild = 4499;
const sal_Int32 XML_russianLower = 4500;
const sal_Int32 XML_russianUpper = 4501;
const sal_Int32 XML_s = 4502;
const sal_Int32 XML_sId = 4503;
const sal_Int32 XML_sPre = 4504;
const sal_Int32 XML_sPrePr = 4505;
const sal_Int32 XML_sSub = 4506;
const sal_Int32 XML_sSubPr = 4507;
const sal_Int32 XML_sSubSup = 4508;
const sal_Int32 XML_sSubSupPr = 4509;
const sal_Int32 XML_sSup = 4510;
const sal_Int32 XML_sSupPr = 4511;
const sal_Int32 XML_saddleBrown = 4512;
const sal_Int32 XML_safari = 4513;
const sal_Int32 XML_saka = 4514;
const sal_Int32 XML_salmon = 4515;
const sal_Int32 XML_salt = 4516;
const sal_Int32 XML_saltData = 4517;
const sal_Int32 XML_saltValue = 4518;
const sal_Int32 XML_sameClick = 4519;
const sal_Int32 XML_sameDir = 4520;
const sal_Int32 XML_sampData = 4521;
const sal_Int32 XML_sandyBrown = 4522;
const sal_Int32 XML_sans_serif = 4523;
const sal_Int32 XML_sat = 4524;
const sal_Int32 XML_satMod = 4525;
const sal_Int32 XML_satOff = 4526;
const sal_Int32 XML_saturation = 4527;
const sal_Int32 XML_saveData = 4528;
const sal_Int32 XML_saveExternalLinkValues = 4529;
const sal_Int32 XML_saveFormsData = 4530;
const sal_Int32 XML_saveInvalidXml = 4531;
const sal_Int32 XML_savePassword = 4532;
const sal_Int32 XML_savePreviewPicture = 4533;
const sal_Int32 XML_saveSmartTagsAsXml = 4534;
const sal_Int32 XML_saveSubsetFonts = 4535;
const sal_Int32 XML_saveThroughXslt = 4536;
const sal_Int32 XML_saveXmlDataOnly = 4537;
const sal_Int32 XML_sawtooth = 4538;
const sal_Int32 XML_sawtoothGray = 4539;
const sal_Int32 XML_sb = 4540;
const sal_Int32 XML_scale = 4541;
const sal_Int32 XML_scaleToFitPaper = 4542;
const sal_Int32 XML_scaleWithDoc = 4543;
const sal_Int32 XML_scaled = 4544;
const sal_Int32 XML_scaling = 4545;
const sal_Int32 XML_scaredCat = 4546;
const sal_Int32 XML_scatterChart = 4547;
const sal_Int32 XML_scatterStyle = 4548;
const sal_Int32 XML_scenario = 4549;
const sal_Int32 XML_scenarios = 4550;
const sal_Int32 XML_scene3d = 4551;
const sal_Int32 XML_schema = 4552;
const sal_Int32 XML_schemaLibrary = 4553;
const sal_Int32 XML_schemaLocation = 4554;
const sal_Int32 XML_schemaRef = 4555;
const sal_Int32 XML_schemaRefs = 4556;
const sal_Int32 XML_scheme = 4557;
const sal_Int32 XML_schemeClr = 4558;
const sal_Int32 XML_scope = 4559;
const sal_Int32 XML_scr = 4560;
const sal_Int32 XML_screen = 4561;
const sal_Int32 XML_screen16x10 = 4562;
const sal_Int32 XML_screen16x9 = 4563;
const sal_Int32 XML_screen4x3 = 4564;
const sal_Int32 XML_scrgbClr = 4565;
const sal_Int32 XML_script = 4566;
const sal_Int32 XML_scrollBar = 4567;
const sal_Int32 XML_scrollbar = 4568;
const sal_Int32 XML_sd = 4569;
const sal_Int32 XML_sdt = 4570;
const sal_Int32 XML_sdtContent = 4571;
const sal_Int32 XML_sdtContentLocked = 4572;
const sal_Int32 XML_sdtEndContent = 4573;
const sal_Int32 XML_sdtEndPr = 4574;
const sal_Int32 XML_sdtLocked = 4575;
const sal_Int32 XML_sdtPr = 4576;
const sal_Int32 XML_seCell = 4577;
const sal_Int32 XML_seaGreen = 4578;
const sal_Int32 XML_seaShell = 4579;
const sal_Int32 XML_seattle = 4580;
const sal_Int32 XML_secChAlign = 4581;
const sal_Int32 XML_secFontSz = 4582;
const sal_Int32 XML_secHead = 4583;
const sal_Int32 XML_secLinDir = 4584;
const sal_Int32 XML_secSibSp = 4585;
const sal_Int32 XML_second = 4586;
const sal_Int32 XML_secondColumnStripe = 4587;
const sal_Int32 XML_secondColumnSubheading = 4588;
const sal_Int32 XML_secondPiePt = 4589;
const sal_Int32 XML_secondPieSize = 4590;
const sal_Int32 XML_secondRowStripe = 4591;
const sal_Int32 XML_secondRowSubheading = 4592;
const sal_Int32 XML_secondSubtotalColumn = 4593;
const sal_Int32 XML_secondSubtotalRow = 4594;
const sal_Int32 XML_seconds = 4595;
const sal_Int32 XML_sectEnd = 4596;
const sal_Int32 XML_sectPr = 4597;
const sal_Int32 XML_sectPrChange = 4598;
const sal_Int32 XML_securityDescriptor = 4599;
const sal_Int32 XML_seek = 4600;
const sal_Int32 XML_segments = 4601;
const sal_Int32 XML_selectFldWithFirstOrLastChar = 4602;
const sal_Int32 XML_selectLockedCells = 4603;
const sal_Int32 XML_selectUnlockedCells = 4604;
const sal_Int32 XML_selected = 4605;
const sal_Int32 XML_selection = 4606;
const sal_Int32 XML_self = 4607;
const sal_Int32 XML_semiHidden = 4608;
const sal_Int32 XML_semicolon = 4609;
const sal_Int32 XML_sendLocale = 4610;
const sal_Int32 XML_sep = 4611;
const sal_Int32 XML_sepChr = 4612;
const sal_Int32 XML_separate = 4613;
const sal_Int32 XML_separator = 4614;
const sal_Int32 XML_seq = 4615;
const sal_Int32 XML_ser = 4616;
const sal_Int32 XML_serAx = 4617;
const sal_Int32 XML_serLines = 4618;
const sal_Int32 XML_series = 4619;
const sal_Int32 XML_seriesAxis = 4620;
const sal_Int32 XML_seriesEl = 4621;
const sal_Int32 XML_seriesIdx = 4622;
const sal_Int32 XML_seriesLine = 4623;
const sal_Int32 XML_serverCommand = 4624;
const sal_Int32 XML_serverField = 4625;
const sal_Int32 XML_serverFill = 4626;
const sal_Int32 XML_serverFont = 4627;
const sal_Int32 XML_serverFontColor = 4628;
const sal_Int32 XML_serverFormat = 4629;
const sal_Int32 XML_serverFormats = 4630;
const sal_Int32 XML_serverNumberFormat = 4631;
const sal_Int32 XML_serverSldId = 4632;
const sal_Int32 XML_serverSldModifiedTime = 4633;
const sal_Int32 XML_serverZoom = 4634;
const sal_Int32 XML_set = 4635;
const sal_Int32 XML_setDefinition = 4636;
const sal_Int32 XML_sets = 4637;
const sal_Int32 XML_settings = 4638;
const sal_Int32 XML_shade = 4639;
const sal_Int32 XML_shadeToTitle = 4640;
const sal_Int32 XML_shadow = 4641;
const sal_Int32 XML_shadowcolor = 4642;
const sal_Int32 XML_shadowedSquares = 4643;
const sal_Int32 XML_shadowok = 4644;
const sal_Int32 XML_shape = 4645;
const sal_Int32 XML_shapeDefaults = 4646;
const sal_Int32 XML_shapeId = 4647;
const sal_Int32 XML_shapeLayoutLikeWW8 = 4648;
const sal_Int32 XML_shapedefaults = 4649;
const sal_Int32 XML_shapeid = 4650;
const sal_Int32 XML_shapelayout = 4651;
const sal_Int32 XML_shapetype = 4652;
const sal_Int32 XML_shared = 4653;
const sal_Int32 XML_sharedItems = 4654;
const sal_Int32 XML_sharksTeeth = 4655;
const sal_Int32 XML_sharpenSoften = 4656;
const sal_Int32 XML_shd = 4657;
const sal_Int32 XML_shdw1 = 4658;
const sal_Int32 XML_shdw10 = 4659;
const sal_Int32 XML_shdw11 = 4660;
const sal_Int32 XML_shdw12 = 4661;
const sal_Int32 XML_shdw13 = 4662;
const sal_Int32 XML_shdw14 = 4663;
const sal_Int32 XML_shdw15 = 4664;
const sal_Int32 XML_shdw16 = 4665;
const sal_Int32 XML_shdw17 = 4666;
const sal_Int32 XML_shdw18 = 4667;
const sal_Int32 XML_shdw19 = 4668;
const sal_Int32 XML_shdw2 = 4669;
const sal_Int32 XML_shdw20 = 4670;
const sal_Int32 XML_shdw3 = 4671;
const sal_Int32 XML_shdw4 = 4672;
const sal_Int32 XML_shdw5 = 4673;
const sal_Int32 XML_shdw6 = 4674;
const sal_Int32 XML_shdw7 = 4675;
const sal_Int32 XML_shdw8 = 4676;
const sal_Int32 XML_shdw9 = 4677;
const sal_Int32 XML_sheet = 4678;
const sal_Int32 XML_sheetCalcPr = 4679;
const sal_Int32 XML_sheetData = 4680;
const sal_Int32 XML_sheetDataSet = 4681;
const sal_Int32 XML_sheetFormatPr = 4682;
const sal_Int32 XML_sheetId = 4683;
const sal_Int32 XML_sheetIdMap = 4684;
const sal_Int32 XML_sheetName = 4685;
const sal_Int32 XML_sheetNames = 4686;
const sal_Int32 XML_sheetPosition = 4687;
const sal_Int32 XML_sheetPr = 4688;
const sal_Int32 XML_sheetProtection = 4689;
const sal_Int32 XML_sheetView = 4690;
const sal_Int32 XML_sheetViews = 4691;
const sal_Int32 XML_sheets = 4692;
const sal_Int32 XML_shimmer = 4693;
const sal_Int32 XML_shingle = 4694;
const sal_Int32 XML_shininess = 4695;
const sal_Int32 XML_shorebirdTracks = 4696;
const sal_Int32 XML_short = 4697;
const sal_Int32 XML_shortcutKey = 4698;
const sal_Int32 XML_shortdash = 4699;
const sal_Int32 XML_shortdashdot = 4700;
const sal_Int32 XML_shortdashdotdot = 4701;
const sal_Int32 XML_shortdot = 4702;
const sal_Int32 XML_show = 4703;
const sal_Int32 XML_showAll = 4704;
const sal_Int32 XML_showAnimation = 4705;
const sal_Int32 XML_showAsCaption = 4706;
const sal_Int32 XML_showAsIcon = 4707;
const sal_Int32 XML_showAutoFilter = 4708;
const sal_Int32 XML_showBorderUnselectedTables = 4709;
const sal_Int32 XML_showBreaksInFrames = 4710;
const sal_Int32 XML_showBubbleSize = 4711;
const sal_Int32 XML_showButton = 4712;
const sal_Int32 XML_showCalcMbrs = 4713;
const sal_Int32 XML_showCaptions = 4714;
const sal_Int32 XML_showCatName = 4715;
const sal_Int32 XML_showCell = 4716;
const sal_Int32 XML_showColHeaders = 4717;
const sal_Int32 XML_showColStripes = 4718;
const sal_Int32 XML_showColumnStripes = 4719;
const sal_Int32 XML_showComments = 4720;
const sal_Int32 XML_showDLblsOverMax = 4721;
const sal_Int32 XML_showDataAs = 4722;
const sal_Int32 XML_showDataDropDown = 4723;
const sal_Int32 XML_showDataLabelsRange = 4724;
const sal_Int32 XML_showDataTips = 4725;
const sal_Int32 XML_showDrill = 4726;
const sal_Int32 XML_showDropDown = 4727;
const sal_Int32 XML_showDropDowns = 4728;
const sal_Int32 XML_showDropZones = 4729;
const sal_Int32 XML_showEmptyCol = 4730;
const sal_Int32 XML_showEmptyRow = 4731;
const sal_Int32 XML_showEnvelope = 4732;
const sal_Int32 XML_showError = 4733;
const sal_Int32 XML_showErrorMessage = 4734;
const sal_Int32 XML_showFirstColumn = 4735;
const sal_Int32 XML_showFormatting = 4736;
const sal_Int32 XML_showFormulaBar = 4737;
const sal_Int32 XML_showFormulas = 4738;
const sal_Int32 XML_showGridLines = 4739;
const sal_Int32 XML_showGuides = 4740;
const sal_Int32 XML_showHeader = 4741;
const sal_Int32 XML_showHeaders = 4742;
const sal_Int32 XML_showHorizontalScroll = 4743;
const sal_Int32 XML_showHorzBorder = 4744;
const sal_Int32 XML_showInFieldList = 4745;
const sal_Int32 XML_showInkAnnotation = 4746;
const sal_Int32 XML_showInputMessage = 4747;
const sal_Int32 XML_showItems = 4748;
const sal_Int32 XML_showKeys = 4749;
const sal_Int32 XML_showLastColumn = 4750;
const sal_Int32 XML_showLeaderLines = 4751;
const sal_Int32 XML_showLegendKey = 4752;
const sal_Int32 XML_showMasterPhAnim = 4753;
const sal_Int32 XML_showMasterSp = 4754;
const sal_Int32 XML_showMemberPropertyTips = 4755;
const sal_Int32 XML_showMissing = 4756;
const sal_Int32 XML_showMultipleLabel = 4757;
const sal_Int32 XML_showNarration = 4758;
const sal_Int32 XML_showNegBubbles = 4759;
const sal_Int32 XML_showObjects = 4760;
const sal_Int32 XML_showOutline = 4761;
const sal_Int32 XML_showOutlineIcons = 4762;
const sal_Int32 XML_showOutlineSymbols = 4763;
const sal_Int32 XML_showPageBreaks = 4764;
const sal_Int32 XML_showPercent = 4765;
const sal_Int32 XML_showPivotChartFilter = 4766;
const sal_Int32 XML_showPr = 4767;
const sal_Int32 XML_showPropAsCaption = 4768;
const sal_Int32 XML_showPropCell = 4769;
const sal_Int32 XML_showPropTip = 4770;
const sal_Int32 XML_showRowCol = 4771;
const sal_Int32 XML_showRowColHeaders = 4772;
const sal_Int32 XML_showRowHeaders = 4773;
const sal_Int32 XML_showRowStripes = 4774;
const sal_Int32 XML_showRuler = 4775;
const sal_Int32 XML_showScrollbar = 4776;
const sal_Int32 XML_showSerName = 4777;
const sal_Int32 XML_showSheetTabs = 4778;
const sal_Int32 XML_showSpeakerNotes = 4779;
const sal_Int32 XML_showSpecialPlsOnTitleSld = 4780;
const sal_Int32 XML_showStatusbar = 4781;
const sal_Int32 XML_showTip = 4782;
const sal_Int32 XML_showVal = 4783;
const sal_Int32 XML_showValue = 4784;
const sal_Int32 XML_showVertBorder = 4785;
const sal_Int32 XML_showVerticalScroll = 4786;
const sal_Int32 XML_showWhenStopped = 4787;
const sal_Int32 XML_showWhiteSpace = 4788;
const sal_Int32 XML_showXMLTags = 4789;
const sal_Int32 XML_showZeros = 4790;
const sal_Int32 XML_showingPlcHdr = 4791;
const sal_Int32 XML_showsigndate = 4792;
const sal_Int32 XML_shp = 4793;
const sal_Int32 XML_shpTxLTRAlignCh = 4794;
const sal_Int32 XML_shpTxRTLAlignCh = 4795;
const sal_Int32 XML_shred = 4796;
const sal_Int32 XML_shrinkToFit = 4797;
const sal_Int32 XML_si = 4798;
const sal_Int32 XML_sib = 4799;
const sal_Int32 XML_sibSp = 4800;
const sal_Int32 XML_sibTrans = 4801;
const sal_Int32 XML_sibTransId = 4802;
const sal_Int32 XML_side = 4803;
const sal_Int32 XML_sideWall = 4804;
const sal_Int32 XML_sienna = 4805;
const sal_Int32 XML_sig = 4806;
const sal_Int32 XML_sigma = 4807;
const sal_Int32 XML_signatureline = 4808;
const sal_Int32 XML_signinginstructions = 4809;
const sal_Int32 XML_signinginstructionsset = 4810;
const sal_Int32 XML_sigprovurl = 4811;
const sal_Int32 XML_silver = 4812;
const sal_Int32 XML_simplePos = 4813;
const sal_Int32 XML_single = 4814;
const sal_Int32 XML_singleAccounting = 4815;
const sal_Int32 XML_singleLevel = 4816;
const sal_Int32 XML_singleQuote = 4817;
const sal_Int32 XML_singleSignOnId = 4818;
const sal_Int32 XML_singleXmlCell = 4819;
const sal_Int32 XML_singleXmlCells = 4820;
const sal_Int32 XML_singleclick = 4821;
const sal_Int32 XML_size = 4822;
const sal_Int32 XML_sizeAuto = 4823;
const sal_Int32 XML_sizeRelH = 4824;
const sal_Int32 XML_sizeRelV = 4825;
const sal_Int32 XML_sizeRepresents = 4826;
const sal_Int32 XML_sizeWithCells = 4827;
const sal_Int32 XML_skew = 4828;
const sal_Int32 XML_skewamt = 4829;
const sal_Int32 XML_skewangle = 4830;
const sal_Int32 XML_skip = 4831;
const sal_Int32 XML_skipTimed = 4832;
const sal_Int32 XML_skw = 4833;
const sal_Int32 XML_skyBlue = 4834;
const sal_Int32 XML_skyrocket = 4835;
const sal_Int32 XML_slantDashDot = 4836;
const sal_Int32 XML_slateBlue = 4837;
const sal_Int32 XML_slateGray = 4838;
const sal_Int32 XML_sld = 4839;
const sal_Int32 XML_sldAll = 4840;
const sal_Int32 XML_sldId = 4841;
const sal_Int32 XML_sldIdLst = 4842;
const sal_Int32 XML_sldImg = 4843;
const sal_Int32 XML_sldLayout = 4844;
const sal_Int32 XML_sldLayoutId = 4845;
const sal_Int32 XML_sldLayoutIdLst = 4846;
const sal_Int32 XML_sldLst = 4847;
const sal_Int32 XML_sldMaster = 4848;
const sal_Int32 XML_sldMasterId = 4849;
const sal_Int32 XML_sldMasterIdLst = 4850;
const sal_Int32 XML_sldMasterView = 4851;
const sal_Int32 XML_sldNum = 4852;
const sal_Int32 XML_sldRg = 4853;
const sal_Int32 XML_sldSorterView = 4854;
const sal_Int32 XML_sldSyncPr = 4855;
const sal_Int32 XML_sldSz = 4856;
const sal_Int32 XML_sldTgt = 4857;
const sal_Int32 XML_sldThumbnailView = 4858;
const sal_Int32 XML_sldView = 4859;
const sal_Int32 XML_slideViewPr = 4860;
const sal_Int32 XML_slides = 4861;
const sal_Int32 XML_slope = 4862;
const sal_Int32 XML_slow = 4863;
const sal_Int32 XML_sm = 4864;
const sal_Int32 XML_smCheck = 4865;
const sal_Int32 XML_smConfetti = 4866;
const sal_Int32 XML_smGrid = 4867;
const sal_Int32 XML_small = 4868;
const sal_Int32 XML_smallCaps = 4869;
const sal_Int32 XML_smallFrac = 4870;
const sal_Int32 XML_smartTag = 4871;
const sal_Int32 XML_smartTagPr = 4872;
const sal_Int32 XML_smartTagType = 4873;
const sal_Int32 XML_smartTagTypes = 4874;
const sal_Int32 XML_smartTags = 4875;
const sal_Int32 XML_smileyFace = 4876;
const sal_Int32 XML_smooth = 4877;
const sal_Int32 XML_smoothMarker = 4878;
const sal_Int32 XML_smoothness = 4879;
const sal_Int32 XML_smtClean = 4880;
const sal_Int32 XML_smtId = 4881;
const sal_Int32 XML_snake = 4882;
const sal_Int32 XML_snapToChars = 4883;
const sal_Int32 XML_snapToGrid = 4884;
const sal_Int32 XML_snapToObjects = 4885;
const sal_Int32 XML_snapVertSplitter = 4886;
const sal_Int32 XML_snd = 4887;
const sal_Int32 XML_sndAc = 4888;
const sal_Int32 XML_sndTgt = 4889;
const sal_Int32 XML_sng = 4890;
const sal_Int32 XML_sngStrike = 4891;
const sal_Int32 XML_snip1Rect = 4892;
const sal_Int32 XML_snip2DiagRect = 4893;
const sal_Int32 XML_snip2SameRect = 4894;
const sal_Int32 XML_snipRoundRect = 4895;
const sal_Int32 XML_snow = 4896;
const sal_Int32 XML_snowflakeFancy = 4897;
const sal_Int32 XML_snowflakes = 4898;
const sal_Int32 XML_soft = 4899;
const sal_Int32 XML_softEdge = 4900;
const sal_Int32 XML_softHyphen = 4901;
const sal_Int32 XML_softRound = 4902;
const sal_Int32 XML_softmetal = 4903;
const sal_Int32 XML_solid = 4904;
const sal_Int32 XML_solidDmnd = 4905;
const sal_Int32 XML_solidFill = 4906;
const sal_Int32 XML_solutionID = 4907;
const sal_Int32 XML_solveOrder = 4908;
const sal_Int32 XML_sombrero = 4909;
const sal_Int32 XML_sort = 4910;
const sal_Int32 XML_sortBy = 4911;
const sal_Int32 XML_sortByTuple = 4912;
const sal_Int32 XML_sortCondition = 4913;
const sal_Int32 XML_sortMethod = 4914;
const sal_Int32 XML_sortState = 4915;
const sal_Int32 XML_sortType = 4916;
const sal_Int32 XML_sorterViewPr = 4917;
const sal_Int32 XML_source = 4918;
const sal_Int32 XML_sourceData = 4919;
const sal_Int32 XML_sourceFile = 4920;
const sal_Int32 XML_sourceFileName = 4921;
const sal_Int32 XML_sourceLinked = 4922;
const sal_Int32 XML_sourceName = 4923;
const sal_Int32 XML_sourceObject = 4924;
const sal_Int32 XML_sourceRef = 4925;
const sal_Int32 XML_sourceSheetId = 4926;
const sal_Int32 XML_sourceType = 4927;
const sal_Int32 XML_southwest = 4928;
const sal_Int32 XML_sp = 4929;
const sal_Int32 XML_sp3d = 4930;
const sal_Int32 XML_spAutoFit = 4931;
const sal_Int32 XML_spDef = 4932;
const sal_Int32 XML_spLocks = 4933;
const sal_Int32 XML_spPr = 4934;
const sal_Int32 XML_spTgt = 4935;
const sal_Int32 XML_spTree = 4936;
const sal_Int32 XML_space = 4937;
const sal_Int32 XML_spaceForUL = 4938;
const sal_Int32 XML_spacing = 4939;
const sal_Int32 XML_spacingInWholePoints = 4940;
const sal_Int32 XML_span = 4941;
const sal_Int32 XML_spanAng = 4942;
const sal_Int32 XML_spans = 4943;
const sal_Int32 XML_sparkle = 4944;
const sal_Int32 XML_sparklineGroups = 4945;
const sal_Int32 XML_sparklineGroup = 4946;
const sal_Int32 XML_sparklines = 4947;
const sal_Int32 XML_sparkline = 4948;
const sal_Int32 XML_spc = 4949;
const sal_Int32 XML_spcAft = 4950;
const sal_Int32 XML_spcBef = 4951;
const sal_Int32 XML_spcCol = 4952;
const sal_Int32 XML_spcFirstLastPara = 4953;
const sal_Int32 XML_spcPct = 4954;
const sal_Int32 XML_spcPts = 4955;
const sal_Int32 XML_spd = 4956;
const sal_Int32 XML_specVanish = 4957;
const sal_Int32 XML_specularity = 4958;
const sal_Int32 XML_spellEnd = 4959;
const sal_Int32 XML_spellStart = 4960;
const sal_Int32 XML_speller = 4961;
const sal_Int32 XML_spelling = 4962;
const sal_Int32 XML_sphere = 4963;
const sal_Int32 XML_spid = 4964;
const sal_Int32 XML_spidmax = 4965;
const sal_Int32 XML_spinCount = 4966;
const sal_Int32 XML_split = 4967;
const sal_Int32 XML_splitAll = 4968;
const sal_Int32 XML_splitFirst = 4969;
const sal_Int32 XML_splitPgBreakAndParaMark = 4970;
const sal_Int32 XML_splitPos = 4971;
const sal_Int32 XML_splitType = 4972;
const sal_Int32 XML_spokes = 4973;
const sal_Int32 XML_spreadsheet = 4974;
const sal_Int32 XML_springGreen = 4975;
const sal_Int32 XML_spt = 4976;
const sal_Int32 XML_sq = 4977;
const sal_Int32 XML_sqlType = 4978;
const sal_Int32 XML_sqref = 4979;
const sal_Int32 XML_square = 4980;
const sal_Int32 XML_squareTabs = 4981;
const sal_Int32 XML_src = 4982;
const sal_Int32 XML_srcId = 4983;
const sal_Int32 XML_srcNode = 4984;
const sal_Int32 XML_srcOrd = 4985;
const sal_Int32 XML_srcRect = 4986;
const sal_Int32 XML_srgbClr = 4987;
const sal_Int32 XML_ss = 4988;
const sal_Int32 XML_ssd16 = 4989;
const sal_Int32 XML_ssd2 = 4990;
const sal_Int32 XML_ssd32 = 4991;
const sal_Int32 XML_ssd4 = 4992;
const sal_Int32 XML_ssd6 = 4993;
const sal_Int32 XML_ssd8 = 4994;
const sal_Int32 XML_sst = 4995;
const sal_Int32 XML_st = 4996;
const sal_Int32 XML_stA = 4997;
const sal_Int32 XML_stAng = 4998;
const sal_Int32 XML_stBulletLvl = 4999;
const sal_Int32 XML_stCondLst = 5000;
const sal_Int32 XML_stCxn = 5001;
const sal_Int32 XML_stElem = 5002;
const sal_Int32 XML_stPos = 5003;
const sal_Int32 XML_stSnd = 5004;
const sal_Int32 XML_stack = 5005;
const sal_Int32 XML_stackScale = 5006;
const sal_Int32 XML_stacked = 5007;
const sal_Int32 XML_standard = 5008;
const sal_Int32 XML_star = 5009;
const sal_Int32 XML_star10 = 5010;
const sal_Int32 XML_star12 = 5011;
const sal_Int32 XML_star16 = 5012;
const sal_Int32 XML_star24 = 5013;
const sal_Int32 XML_star32 = 5014;
const sal_Int32 XML_star4 = 5015;
const sal_Int32 XML_star5 = 5016;
const sal_Int32 XML_star6 = 5017;
const sal_Int32 XML_star7 = 5018;
const sal_Int32 XML_star8 = 5019;
const sal_Int32 XML_stars = 5020;
const sal_Int32 XML_stars3d = 5021;
const sal_Int32 XML_starsBlack = 5022;
const sal_Int32 XML_starsShadowed = 5023;
const sal_Int32 XML_starsTop = 5024;
const sal_Int32 XML_start = 5025;
const sal_Int32 XML_startAngle = 5026;
const sal_Int32 XML_startAt = 5027;
const sal_Int32 XML_startChars = 5028;
const sal_Int32 XML_startDate = 5029;
const sal_Int32 XML_startNum = 5030;
const sal_Int32 XML_startOverride = 5031;
const sal_Int32 XML_startarrow = 5032;
const sal_Int32 XML_startarrowlength = 5033;
const sal_Int32 XML_startarrowwidth = 5034;
const sal_Int32 XML_state = 5035;
const sal_Int32 XML_status = 5036;
const sal_Int32 XML_statusBar = 5037;
const sal_Int32 XML_statusText = 5038;
const sal_Int32 XML_std = 5039;
const sal_Int32 XML_stdDev = 5040;
const sal_Int32 XML_stdDevP = 5041;
const sal_Int32 XML_stdDevPSubtotal = 5042;
const sal_Int32 XML_stdDevSubtotal = 5043;
const sal_Int32 XML_stdDevp = 5044;
const sal_Int32 XML_stdErr = 5045;
const sal_Int32 XML_stealth = 5046;
const sal_Int32 XML_steelBlue = 5047;
const sal_Int32 XML_stemThick = 5048;
const sal_Int32 XML_step = 5049;
const sal_Int32 XML_stockChart = 5050;
const sal_Int32 XML_stop = 5051;
const sal_Int32 XML_stopIfTrue = 5052;
const sal_Int32 XML_storage = 5053;
const sal_Int32 XML_storeItemID = 5054;
const sal_Int32 XML_storeMappedDataAs = 5055;
const sal_Int32 XML_stored = 5056;
const sal_Int32 XML_stp = 5057;
const sal_Int32 XML_str = 5058;
const sal_Int32 XML_strCache = 5059;
const sal_Int32 XML_strDim = 5060;
const sal_Int32 XML_strLit = 5061;
const sal_Int32 XML_strRef = 5062;
const sal_Int32 XML_strVal = 5063;
const sal_Int32 XML_stra = 5064;
const sal_Int32 XML_straight = 5065;
const sal_Int32 XML_straightConnector1 = 5066;
const sal_Int32 XML_stream = 5067;
const sal_Int32 XML_stretch = 5068;
const sal_Int32 XML_strictFirstAndLastChars = 5069;
const sal_Int32 XML_strike = 5070;
const sal_Int32 XML_strikeBLTR = 5071;
const sal_Int32 XML_strikeH = 5072;
const sal_Int32 XML_strikeTLBR = 5073;
const sal_Int32 XML_strikeV = 5074;
const sal_Int32 XML_string = 5075;
const sal_Int32 XML_stringRefSyntax = 5076;
const sal_Int32 XML_stringValue1 = 5077;
const sal_Int32 XML_stringValue2 = 5078;
const sal_Int32 XML_stripedRightArrow = 5079;
const sal_Int32 XML_strips = 5080;
const sal_Int32 XML_stroke = 5081;
const sal_Int32 XML_strokecolor = 5082;
const sal_Int32 XML_stroked = 5083;
const sal_Int32 XML_strokeok = 5084;
const sal_Int32 XML_strokeweight = 5085;
const sal_Int32 XML_sty = 5086;
const sal_Int32 XML_style = 5087;
const sal_Int32 XML_styleClr = 5088;
const sal_Int32 XML_styleData = 5089;
const sal_Int32 XML_styleDef = 5090;
const sal_Int32 XML_styleDefHdr = 5091;
const sal_Int32 XML_styleDefHdrLst = 5092;
const sal_Int32 XML_styleId = 5093;
const sal_Int32 XML_styleLbl = 5094;
const sal_Int32 XML_styleLink = 5095;
const sal_Int32 XML_styleLockQFSet = 5096;
const sal_Int32 XML_styleLockTheme = 5097;
const sal_Int32 XML_styleName = 5098;
const sal_Int32 XML_stylePaneFormatFilter = 5099;
const sal_Int32 XML_stylePaneSortMethod = 5100;
const sal_Int32 XML_styleSet = 5101;
const sal_Int32 XML_styleSheet = 5102;
const sal_Int32 XML_styles = 5103;
const sal_Int32 XML_stylisticSets = 5104;
const sal_Int32 XML_sub = 5105;
const sal_Int32 XML_subDoc = 5106;
const sal_Int32 XML_subFontBySize = 5107;
const sal_Int32 XML_subHide = 5108;
const sal_Int32 XML_subSp = 5109;
const sal_Int32 XML_subSup = 5110;
const sal_Int32 XML_subTitle = 5111;
const sal_Int32 XML_subTnLst = 5112;
const sal_Int32 XML_subject = 5113;
const sal_Int32 XML_subscript = 5114;
const sal_Int32 XML_subsetted = 5115;
const sal_Int32 XML_subtotal = 5116;
const sal_Int32 XML_subtotalCaption = 5117;
const sal_Int32 XML_subtotalHiddenItems = 5118;
const sal_Int32 XML_subtotalTop = 5119;
const sal_Int32 XML_suff = 5120;
const sal_Int32 XML_suggestedsigner = 5121;
const sal_Int32 XML_suggestedsigner2 = 5122;
const sal_Int32 XML_suggestedsigneremail = 5123;
const sal_Int32 XML_sum = 5124;
const sal_Int32 XML_sumSubtotal = 5125;
const sal_Int32 XML_summaryBelow = 5126;
const sal_Int32 XML_summaryLength = 5127;
const sal_Int32 XML_summaryRight = 5128;
const sal_Int32 XML_sun = 5129;
const sal_Int32 XML_sunburst = 5130;
const sal_Int32 XML_sunrise = 5131;
const sal_Int32 XML_sunset = 5132;
const sal_Int32 XML_sup = 5133;
const sal_Int32 XML_supHide = 5134;
const sal_Int32 XML_superscript = 5135;
const sal_Int32 XML_supportAdvancedDrill = 5136;
const sal_Int32 XML_supportSubquery = 5137;
const sal_Int32 XML_suppressAutoHyphens = 5138;
const sal_Int32 XML_suppressBottomSpacing = 5139;
const sal_Int32 XML_suppressLineNumbers = 5140;
const sal_Int32 XML_suppressOverlap = 5141;
const sal_Int32 XML_suppressSpBfAfterPgBrk = 5142;
const sal_Int32 XML_suppressSpacingAtTopOfPage = 5143;
const sal_Int32 XML_suppressTopSpacing = 5144;
const sal_Int32 XML_suppressTopSpacingWP = 5145;
const sal_Int32 XML_surface3DChart = 5146;
const sal_Int32 XML_surfaceChart = 5147;
const sal_Int32 XML_svgBlip = 5148;
const sal_Int32 XML_swAng = 5149;
const sal_Int32 XML_swCell = 5150;
const sal_Int32 XML_swapBordersFacingPages = 5151;
const sal_Int32 XML_swirligig = 5152;
const sal_Int32 XML_swiss = 5153;
const sal_Int32 XML_switch = 5154;
const sal_Int32 XML_swooshArrow = 5155;
const sal_Int32 XML_sx = 5156;
const sal_Int32 XML_sy = 5157;
const sal_Int32 XML_sym = 5158;
const sal_Int32 XML_symbol = 5159;
const sal_Int32 XML_syncBehavior = 5160;
const sal_Int32 XML_syncHorizontal = 5161;
const sal_Int32 XML_syncRef = 5162;
const sal_Int32 XML_syncVertical = 5163;
const sal_Int32 XML_sysClr = 5164;
const sal_Int32 XML_sysDash = 5165;
const sal_Int32 XML_sysDashDot = 5166;
const sal_Int32 XML_sysDashDotDot = 5167;
const sal_Int32 XML_sysDot = 5168;
const sal_Int32 XML_sz = 5169;
const sal_Int32 XML_szCs = 5170;
const sal_Int32 XML_t = 5171;
const sal_Int32 XML_t1 = 5172;
const sal_Int32 XML_t2 = 5173;
const sal_Int32 XML_tCtr = 5174;
const sal_Int32 XML_tCtrCh = 5175;
const sal_Int32 XML_tCtrDes = 5176;
const sal_Int32 XML_tIns = 5177;
const sal_Int32 XML_tL = 5178;
const sal_Int32 XML_tMarg = 5179;
const sal_Int32 XML_tOff = 5180;
const sal_Int32 XML_tR = 5181;
const sal_Int32 XML_tab = 5182;
const sal_Int32 XML_tabColor = 5183;
const sal_Int32 XML_tabIndex = 5184;
const sal_Int32 XML_tabLst = 5185;
const sal_Int32 XML_tabRatio = 5186;
const sal_Int32 XML_tabSelected = 5187;
const sal_Int32 XML_table = 5188;
const sal_Int32 XML_tableBorderDxfId = 5189;
const sal_Int32 XML_tableCellDelete = 5190;
const sal_Int32 XML_tableCellInsert = 5191;
const sal_Int32 XML_tableColumn = 5192;
const sal_Int32 XML_tableColumnId = 5193;
const sal_Int32 XML_tableColumns = 5194;
const sal_Int32 XML_tablePart = 5195;
const sal_Int32 XML_tableParts = 5196;
const sal_Int32 XML_tableRowDelete = 5197;
const sal_Int32 XML_tableRowInsert = 5198;
const sal_Int32 XML_tableStyle = 5199;
const sal_Int32 XML_tableStyleElement = 5200;
const sal_Int32 XML_tableStyleId = 5201;
const sal_Int32 XML_tableStyleInfo = 5202;
const sal_Int32 XML_tableStyles = 5203;
const sal_Int32 XML_tableType = 5204;
const sal_Int32 XML_tablelimits = 5205;
const sal_Int32 XML_tableproperties = 5206;
const sal_Int32 XML_tables = 5207;
const sal_Int32 XML_tabs = 5208;
const sal_Int32 XML_tag = 5209;
const sal_Int32 XML_tagLst = 5210;
const sal_Int32 XML_tags = 5211;
const sal_Int32 XML_tailEnd = 5212;
const sal_Int32 XML_taiwan = 5213;
const sal_Int32 XML_taiwaneseCounting = 5214;
const sal_Int32 XML_taiwaneseCountingThousand = 5215;
const sal_Int32 XML_taiwaneseDigital = 5216;
const sal_Int32 XML_tan = 5217;
const sal_Int32 XML_target = 5218;
const sal_Int32 XML_targetScreenSize = 5219;
const sal_Int32 XML_targetScreenSz = 5220;
const sal_Int32 XML_targetscreensize = 5221;
const sal_Int32 XML_tav = 5222;
const sal_Int32 XML_tavLst = 5223;
const sal_Int32 XML_tbLrV = 5224;
const sal_Int32 XML_tbRl = 5225;
const sal_Int32 XML_tbRlV = 5226;
const sal_Int32 XML_tbl = 5227;
const sal_Int32 XML_tblBg = 5228;
const sal_Int32 XML_tblBorders = 5229;
const sal_Int32 XML_tblCaption = 5230;
const sal_Int32 XML_tblCellMar = 5231;
const sal_Int32 XML_tblCellSpacing = 5232;
const sal_Int32 XML_tblDescription = 5233;
const sal_Int32 XML_tblGrid = 5234;
const sal_Int32 XML_tblGridChange = 5235;
const sal_Int32 XML_tblHeader = 5236;
const sal_Int32 XML_tblInd = 5237;
const sal_Int32 XML_tblLayout = 5238;
const sal_Int32 XML_tblLook = 5239;
const sal_Int32 XML_tblOfContents = 5240;
const sal_Int32 XML_tblOverlap = 5241;
const sal_Int32 XML_tblPr = 5242;
const sal_Int32 XML_tblPrChange = 5243;
const sal_Int32 XML_tblPrEx = 5244;
const sal_Int32 XML_tblPrExChange = 5245;
const sal_Int32 XML_tblStyle = 5246;
const sal_Int32 XML_tblStyleColBandSize = 5247;
const sal_Int32 XML_tblStyleLst = 5248;
const sal_Int32 XML_tblStylePr = 5249;
const sal_Int32 XML_tblStyleRowBandSize = 5250;
const sal_Int32 XML_tblW = 5251;
const sal_Int32 XML_tblpPr = 5252;
const sal_Int32 XML_tblpX = 5253;
const sal_Int32 XML_tblpXSpec = 5254;
const sal_Int32 XML_tblpY = 5255;
const sal_Int32 XML_tblpYSpec = 5256;
const sal_Int32 XML_tbls = 5257;
const sal_Int32 XML_tc = 5258;
const sal_Int32 XML_tcBdr = 5259;
const sal_Int32 XML_tcBorders = 5260;
const sal_Int32 XML_tcFitText = 5261;
const sal_Int32 XML_tcMar = 5262;
const sal_Int32 XML_tcPr = 5263;
const sal_Int32 XML_tcPrChange = 5264;
const sal_Int32 XML_tcStyle = 5265;
const sal_Int32 XML_tcTxStyle = 5266;
const sal_Int32 XML_tcW = 5267;
const sal_Int32 XML_teal = 5268;
const sal_Int32 XML_teardrop = 5269;
const sal_Int32 XML_temporary = 5270;
const sal_Int32 XML_tenMillions = 5271;
const sal_Int32 XML_tenThousands = 5272;
const sal_Int32 XML_tentative = 5273;
const sal_Int32 XML_text = 5274;
const sal_Int32 XML_text1 = 5275;
const sal_Int32 XML_text2 = 5276;
const sal_Int32 XML_textAlignment = 5277;
const sal_Int32 XML_textAndBackground = 5278;
const sal_Int32 XML_textArchDown = 5279;
const sal_Int32 XML_textArchDownPour = 5280;
const sal_Int32 XML_textArchUp = 5281;
const sal_Int32 XML_textArchUpPour = 5282;
const sal_Int32 XML_textButton = 5283;
const sal_Int32 XML_textButtonPour = 5284;
const sal_Int32 XML_textCanDown = 5285;
const sal_Int32 XML_textCanUp = 5286;
const sal_Int32 XML_textCascadeDown = 5287;
const sal_Int32 XML_textCascadeUp = 5288;
const sal_Int32 XML_textChevron = 5289;
const sal_Int32 XML_textChevronInverted = 5290;
const sal_Int32 XML_textCircle = 5291;
const sal_Int32 XML_textCirclePour = 5292;
const sal_Int32 XML_textCurveDown = 5293;
const sal_Int32 XML_textCurveUp = 5294;
const sal_Int32 XML_textDates = 5295;
const sal_Int32 XML_textDeflate = 5296;
const sal_Int32 XML_textDeflateBottom = 5297;
const sal_Int32 XML_textDeflateInflate = 5298;
const sal_Int32 XML_textDeflateInflateDeflate = 5299;
const sal_Int32 XML_textDeflateTop = 5300;
const sal_Int32 XML_textDirection = 5301;
const sal_Int32 XML_textDoubleWave1 = 5302;
const sal_Int32 XML_textFadeDown = 5303;
const sal_Int32 XML_textFadeLeft = 5304;
const sal_Int32 XML_textFadeRight = 5305;
const sal_Int32 XML_textFadeUp = 5306;
const sal_Int32 XML_textField = 5307;
const sal_Int32 XML_textFields = 5308;
const sal_Int32 XML_textFile = 5309;
const sal_Int32 XML_textFill = 5310;
const sal_Int32 XML_textFit = 5311;
const sal_Int32 XML_textHAlign = 5312;
const sal_Int32 XML_textInflate = 5313;
const sal_Int32 XML_textInflateBottom = 5314;
const sal_Int32 XML_textInflateTop = 5315;
const sal_Int32 XML_textInput = 5316;
const sal_Int32 XML_textLength = 5317;
const sal_Int32 XML_textNoShape = 5318;
const sal_Int32 XML_textOutline = 5319;
const sal_Int32 XML_textPlain = 5320;
const sal_Int32 XML_textPr = 5321;
const sal_Int32 XML_textRingInside = 5322;
const sal_Int32 XML_textRingOutside = 5323;
const sal_Int32 XML_textRotation = 5324;
const sal_Int32 XML_textSlantDown = 5325;
const sal_Int32 XML_textSlantUp = 5326;
const sal_Int32 XML_textStop = 5327;
const sal_Int32 XML_textTriangle = 5328;
const sal_Int32 XML_textTriangleInverted = 5329;
const sal_Int32 XML_textVAlign = 5330;
const sal_Int32 XML_textWave1 = 5331;
const sal_Int32 XML_textWave2 = 5332;
const sal_Int32 XML_textWave4 = 5333;
const sal_Int32 XML_textWrapping = 5334;
const sal_Int32 XML_textborder = 5335;
const sal_Int32 XML_textbox = 5336;
const sal_Int32 XML_textboxTightWrap = 5337;
const sal_Int32 XML_textboxrect = 5338;
const sal_Int32 XML_textdata = 5339;
const sal_Int32 XML_textlink = 5340;
const sal_Int32 XML_textpath = 5341;
const sal_Int32 XML_textpathok = 5342;
const sal_Int32 XML_tgtEl = 5343;
const sal_Int32 XML_tgtFrame = 5344;
const sal_Int32 XML_thai = 5345;
const sal_Int32 XML_thaiAlphaParenBoth = 5346;
const sal_Int32 XML_thaiAlphaParenR = 5347;
const sal_Int32 XML_thaiAlphaPeriod = 5348;
const sal_Int32 XML_thaiCounting = 5349;
const sal_Int32 XML_thaiDist = 5350;
const sal_Int32 XML_thaiDistribute = 5351;
const sal_Int32 XML_thaiLetters = 5352;
const sal_Int32 XML_thaiNumParenBoth = 5353;
const sal_Int32 XML_thaiNumParenR = 5354;
const sal_Int32 XML_thaiNumPeriod = 5355;
const sal_Int32 XML_thaiNumbers = 5356;
const sal_Int32 XML_theme = 5357;
const sal_Int32 XML_themeColor = 5358;
const sal_Int32 XML_themeElements = 5359;
const sal_Int32 XML_themeFill = 5360;
const sal_Int32 XML_themeFillShade = 5361;
const sal_Int32 XML_themeFillTint = 5362;
const sal_Int32 XML_themeFontLang = 5363;
const sal_Int32 XML_themeManager = 5364;
const sal_Int32 XML_themeOverride = 5365;
const sal_Int32 XML_themeShade = 5366;
const sal_Int32 XML_themeTint = 5367;
const sal_Int32 XML_thick = 5368;
const sal_Int32 XML_thickBetweenThin = 5369;
const sal_Int32 XML_thickBetweenThinLarge = 5370;
const sal_Int32 XML_thickBetweenThinSmall = 5371;
const sal_Int32 XML_thickBot = 5372;
const sal_Int32 XML_thickBottom = 5373;
const sal_Int32 XML_thickThin = 5374;
const sal_Int32 XML_thickThinLarge = 5375;
const sal_Int32 XML_thickThinLargeGap = 5376;
const sal_Int32 XML_thickThinMediumGap = 5377;
const sal_Int32 XML_thickThinSmall = 5378;
const sal_Int32 XML_thickThinSmallGap = 5379;
const sal_Int32 XML_thickTop = 5380;
const sal_Int32 XML_thicket = 5381;
const sal_Int32 XML_thickness = 5382;
const sal_Int32 XML_thin = 5383;
const sal_Int32 XML_thinDiagCross = 5384;
const sal_Int32 XML_thinDiagStripe = 5385;
const sal_Int32 XML_thinHorzCross = 5386;
const sal_Int32 XML_thinHorzStripe = 5387;
const sal_Int32 XML_thinReverseDiagStripe = 5388;
const sal_Int32 XML_thinThick = 5389;
const sal_Int32 XML_thinThickLarge = 5390;
const sal_Int32 XML_thinThickLargeGap = 5391;
const sal_Int32 XML_thinThickMediumGap = 5392;
const sal_Int32 XML_thinThickSmall = 5393;
const sal_Int32 XML_thinThickSmallGap = 5394;
const sal_Int32 XML_thinThickThinLargeGap = 5395;
const sal_Int32 XML_thinThickThinMediumGap = 5396;
const sal_Int32 XML_thinThickThinSmallGap = 5397;
const sal_Int32 XML_thinThin = 5398;
const sal_Int32 XML_thinVertStripe = 5399;
const sal_Int32 XML_thirdColumnSubheading = 5400;
const sal_Int32 XML_thirdRowSubheading = 5401;
const sal_Int32 XML_thirdSubtotalColumn = 5402;
const sal_Int32 XML_thirdSubtotalRow = 5403;
const sal_Int32 XML_thisMonth = 5404;
const sal_Int32 XML_thisQuarter = 5405;
const sal_Int32 XML_thisWeek = 5406;
const sal_Int32 XML_thisYear = 5407;
const sal_Int32 XML_thistle = 5408;
const sal_Int32 XML_thousands = 5409;
const sal_Int32 XML_threeDEmboss = 5410;
const sal_Int32 XML_threeDEngrave = 5411;
const sal_Int32 XML_threePt = 5412;
const sal_Int32 XML_thresh = 5413;
const sal_Int32 XML_through = 5414;
const sal_Int32 XML_thruBlk = 5415;
const sal_Int32 XML_tickLabels = 5416;
const sal_Int32 XML_tickLblPos = 5417;
const sal_Int32 XML_tickLblSkip = 5418;
const sal_Int32 XML_tickMarkSkip = 5419;
const sal_Int32 XML_tight = 5420;
const sal_Int32 XML_tile = 5421;
const sal_Int32 XML_tileRect = 5422;
const sal_Int32 XML_time = 5423;
const sal_Int32 XML_timePeriod = 5424;
const sal_Int32 XML_timing = 5425;
const sal_Int32 XML_tint = 5426;
const sal_Int32 XML_title = 5427;
const sal_Int32 XML_titleOnly = 5428;
const sal_Int32 XML_titlePg = 5429;
const sal_Int32 XML_titleStyle = 5430;
const sal_Int32 XML_tl = 5431;
const sal_Int32 XML_tl2br = 5432;
const sal_Int32 XML_tm = 5433;
const sal_Int32 XML_tmAbs = 5434;
const sal_Int32 XML_tmFilter = 5435;
const sal_Int32 XML_tmPct = 5436;
const sal_Int32 XML_tmRoot = 5437;
const sal_Int32 XML_tmpl = 5438;
const sal_Int32 XML_tmplLst = 5439;
const sal_Int32 XML_tn = 5440;
const sal_Int32 XML_tnLst = 5441;
const sal_Int32 XML_to = 5442;
const sal_Int32 XML_today = 5443;
const sal_Int32 XML_token = 5444;
const sal_Int32 XML_tomato = 5445;
const sal_Int32 XML_tomorrow = 5446;
const sal_Int32 XML_toolbar = 5447;
const sal_Int32 XML_tooltip = 5448;
const sal_Int32 XML_top = 5449;
const sal_Int32 XML_top10 = 5450;
const sal_Int32 XML_topAndBottom = 5451;
const sal_Int32 XML_topAutoShow = 5452;
const sal_Int32 XML_topFromText = 5453;
const sal_Int32 XML_topLabels = 5454;
const sal_Int32 XML_topLeft = 5455;
const sal_Int32 XML_topLeftCell = 5456;
const sal_Int32 XML_topLinePunct = 5457;
const sal_Int32 XML_topMargin = 5458;
const sal_Int32 XML_topRight = 5459;
const sal_Int32 XML_tornPaper = 5460;
const sal_Int32 XML_tornPaperBlack = 5461;
const sal_Int32 XML_totalRow = 5462;
const sal_Int32 XML_totalsRowBorderDxfId = 5463;
const sal_Int32 XML_totalsRowCellStyle = 5464;
const sal_Int32 XML_totalsRowCount = 5465;
const sal_Int32 XML_totalsRowDxfId = 5466;
const sal_Int32 XML_totalsRowFormula = 5467;
const sal_Int32 XML_totalsRowFunction = 5468;
const sal_Int32 XML_totalsRowLabel = 5469;
const sal_Int32 XML_totalsRowShown = 5470;
const sal_Int32 XML_tp = 5471;
const sal_Int32 XML_tpl = 5472;
const sal_Int32 XML_tplc = 5473;
const sal_Int32 XML_tpls = 5474;
const sal_Int32 XML_tr = 5475;
const sal_Int32 XML_tr2bl = 5476;
const sal_Int32 XML_trHeight = 5477;
const sal_Int32 XML_trPr = 5478;
const sal_Int32 XML_trPrChange = 5479;
const sal_Int32 XML_track = 5480;
const sal_Int32 XML_trackRevisions = 5481;
const sal_Int32 XML_trackedChanges = 5482;
const sal_Int32 XML_trans = 5483;
const sal_Int32 XML_transition = 5484;
const sal_Int32 XML_transitionEntry = 5485;
const sal_Int32 XML_transitionEvaluation = 5486;
const sal_Int32 XML_translucentPowder = 5487;
const sal_Int32 XML_transp = 5488;
const sal_Int32 XML_trapezoid = 5489;
const sal_Int32 XML_tree = 5490;
const sal_Int32 XML_treemap = 5491;
const sal_Int32 XML_trees = 5492;
const sal_Int32 XML_trellis = 5493;
const sal_Int32 XML_trend = 5494;
const sal_Int32 XML_trendline = 5495;
const sal_Int32 XML_trendlineLabel = 5496;
const sal_Int32 XML_trendlineLbl = 5497;
const sal_Int32 XML_trendlineType = 5498;
const sal_Int32 XML_tri = 5499;
const sal_Int32 XML_triangle = 5500;
const sal_Int32 XML_triangleParty = 5501;
const sal_Int32 XML_triangles = 5502;
const sal_Int32 XML_tribal1 = 5503;
const sal_Int32 XML_tribal2 = 5504;
const sal_Int32 XML_tribal3 = 5505;
const sal_Int32 XML_tribal4 = 5506;
const sal_Int32 XML_tribal5 = 5507;
const sal_Int32 XML_tribal6 = 5508;
const sal_Int32 XML_trillions = 5509;
const sal_Int32 XML_trim = 5510;
const sal_Int32 XML_triple = 5511;
const sal_Int32 XML_true = 5512;
const sal_Int32 XML_truncateFontHeightsLikeWP6 = 5513;
const sal_Int32 XML_tupleCache = 5514;
const sal_Int32 XML_turquoise = 5515;
const sal_Int32 XML_twistedLines1 = 5516;
const sal_Int32 XML_twistedLines2 = 5517;
const sal_Int32 XML_twoCell = 5518;
const sal_Int32 XML_twoCellAnchor = 5519;
const sal_Int32 XML_twoColTx = 5520;
const sal_Int32 XML_twoDigitTextYear = 5521;
const sal_Int32 XML_twoObj = 5522;
const sal_Int32 XML_twoObjAndObj = 5523;
const sal_Int32 XML_twoObjAndTx = 5524;
const sal_Int32 XML_twoObjOverTx = 5525;
const sal_Int32 XML_twoPt = 5526;
const sal_Int32 XML_twoTxTwoObj = 5527;
const sal_Int32 XML_tx = 5528;
const sal_Int32 XML_tx1 = 5529;
const sal_Int32 XML_tx2 = 5530;
const sal_Int32 XML_txAnchorHorz = 5531;
const sal_Int32 XML_txAnchorHorzCh = 5532;
const sal_Int32 XML_txAnchorVert = 5533;
const sal_Int32 XML_txAnchorVertCh = 5534;
const sal_Int32 XML_txAndChart = 5535;
const sal_Int32 XML_txAndClipArt = 5536;
const sal_Int32 XML_txAndMedia = 5537;
const sal_Int32 XML_txAndObj = 5538;
const sal_Int32 XML_txAndTwoObj = 5539;
const sal_Int32 XML_txBlDir = 5540;
const sal_Int32 XML_txBody = 5541;
const sal_Int32 XML_txBox = 5542;
const sal_Int32 XML_txData = 5543;
const sal_Int32 XML_txDef = 5544;
const sal_Int32 XML_txDir = 5545;
const sal_Int32 XML_txEffectClrLst = 5546;
const sal_Int32 XML_txEl = 5547;
const sal_Int32 XML_txFillClrLst = 5548;
const sal_Int32 XML_txLinClrLst = 5549;
const sal_Int32 XML_txOverObj = 5550;
const sal_Int32 XML_txPr = 5551;
const sal_Int32 XML_txSp = 5552;
const sal_Int32 XML_txStyles = 5553;
const sal_Int32 XML_txXfrm = 5554;
const sal_Int32 XML_txbx = 5555;
const sal_Int32 XML_txbxContent = 5556;
const sal_Int32 XML_txtBox = 5557;
const sal_Int32 XML_ty = 5558;
const sal_Int32 XML_type = 5559;
const sal_Int32 XML_typeAny = 5560;
const sal_Int32 XML_typeface = 5561;
const sal_Int32 XML_types = 5562;
const sal_Int32 XML_u = 5563;
const sal_Int32 XML_uBounds = 5564;
const sal_Int32 XML_uFill = 5565;
const sal_Int32 XML_uFillTx = 5566;
const sal_Int32 XML_uLn = 5567;
const sal_Int32 XML_uLnTx = 5568;
const sal_Int32 XML_ua = 5569;
const sal_Int32 XML_udl = 5570;
const sal_Int32 XML_ui1 = 5571;
const sal_Int32 XML_ui2 = 5572;
const sal_Int32 XML_ui4 = 5573;
const sal_Int32 XML_ui8 = 5574;
const sal_Int32 XML_uiCompat97To2003 = 5575;
const sal_Int32 XML_uiExpand = 5576;
const sal_Int32 XML_uiPriority = 5577;
const sal_Int32 XML_uid = 5578;
const sal_Int32 XML_uint = 5579;
const sal_Int32 XML_ulTrailSpace = 5580;
const sal_Int32 XML_un = 5581;
const sal_Int32 XML_unbalanced = 5582;
const sal_Int32 XML_unbalancedGroup = 5583;
const sal_Int32 XML_unboundColumnsLeft = 5584;
const sal_Int32 XML_unboundColumnsRight = 5585;
const sal_Int32 XML_uncheckedState = 5586;
const sal_Int32 XML_undOvr = 5587;
const sal_Int32 XML_underDot = 5588;
const sal_Int32 XML_underlineTabInNumList = 5589;
const sal_Int32 XML_underscore = 5590;
const sal_Int32 XML_undo = 5591;
const sal_Int32 XML_undone = 5592;
const sal_Int32 XML_undrawn = 5593;
const sal_Int32 XML_ungrouping = 5594;
const sal_Int32 XML_unhideWhenUsed = 5595;
const sal_Int32 XML_uniqueCount = 5596;
const sal_Int32 XML_uniqueId = 5597;
const sal_Int32 XML_uniqueList = 5598;
const sal_Int32 XML_uniqueMemberProperty = 5599;
const sal_Int32 XML_uniqueName = 5600;
const sal_Int32 XML_uniqueParent = 5601;
const sal_Int32 XML_uniqueTag = 5602;
const sal_Int32 XML_uniqueValues = 5603;
const sal_Int32 XML_units = 5604;
const sal_Int32 XML_unitsLabel = 5605;
const sal_Int32 XML_unknown = 5606;
const sal_Int32 XML_unknownRelationship = 5607;
const sal_Int32 XML_unlocked = 5608;
const sal_Int32 XML_unlockedFormula = 5609;
const sal_Int32 XML_unsignedByte = 5610;
const sal_Int32 XML_unsignedInt = 5611;
const sal_Int32 XML_unsignedLong = 5612;
const sal_Int32 XML_unsignedShort = 5613;
const sal_Int32 XML_up = 5614;
const sal_Int32 XML_upArrow = 5615;
const sal_Int32 XML_upArrowCallout = 5616;
const sal_Int32 XML_upBar = 5617;
const sal_Int32 XML_upBars = 5618;
const sal_Int32 XML_upDiag = 5619;
const sal_Int32 XML_upDownArrow = 5620;
const sal_Int32 XML_upDownArrowCallout = 5621;
const sal_Int32 XML_upDownBars = 5622;
const sal_Int32 XML_updateAutomatic = 5623;
const sal_Int32 XML_updateFields = 5624;
const sal_Int32 XML_updateLinks = 5625;
const sal_Int32 XML_updatedVersion = 5626;
const sal_Int32 XML_upgradeOnRefresh = 5627;
const sal_Int32 XML_upperLetter = 5628;
const sal_Int32 XML_upperRoman = 5629;
const sal_Int32 XML_upr = 5630;
const sal_Int32 XML_upright = 5631;
const sal_Int32 XML_uri = 5632;
const sal_Int32 XML_url = 5633;
const sal_Int32 XML_usb0 = 5634;
const sal_Int32 XML_usb1 = 5635;
const sal_Int32 XML_usb2 = 5636;
const sal_Int32 XML_usb3 = 5637;
const sal_Int32 XML_useA = 5638;
const sal_Int32 XML_useAltKinsokuLineBreakRules = 5639;
const sal_Int32 XML_useAnsiKerningPairs = 5640;
const sal_Int32 XML_useAutoFormatting = 5641;
const sal_Int32 XML_useBgFill = 5642;
const sal_Int32 XML_useDef = 5643;
const sal_Int32 XML_useFELayout = 5644;
const sal_Int32 XML_useFirstPageNumber = 5645;
const sal_Int32 XML_useLongFilenames = 5646;
const sal_Int32 XML_useNormalStyleForList = 5647;
const sal_Int32 XML_usePrinterDefaults = 5648;
const sal_Int32 XML_usePrinterMetrics = 5649;
const sal_Int32 XML_useSingleBorderforContiguousCells = 5650;
const sal_Int32 XML_useSpRect = 5651;
const sal_Int32 XML_useTimings = 5652;
const sal_Int32 XML_useWord2002TableStyleRules = 5653;
const sal_Int32 XML_useWord97LineBreakRules = 5654;
const sal_Int32 XML_useXSLTWhenSaving = 5655;
const sal_Int32 XML_user = 5656;
const sal_Int32 XML_userA = 5657;
const sal_Int32 XML_userB = 5658;
const sal_Int32 XML_userC = 5659;
const sal_Int32 XML_userD = 5660;
const sal_Int32 XML_userDrawn = 5661;
const sal_Int32 XML_userE = 5662;
const sal_Int32 XML_userF = 5663;
const sal_Int32 XML_userG = 5664;
const sal_Int32 XML_userH = 5665;
const sal_Int32 XML_userI = 5666;
const sal_Int32 XML_userInfo = 5667;
const sal_Int32 XML_userInterface = 5668;
const sal_Int32 XML_userJ = 5669;
const sal_Int32 XML_userK = 5670;
const sal_Int32 XML_userL = 5671;
const sal_Int32 XML_userM = 5672;
const sal_Int32 XML_userN = 5673;
const sal_Int32 XML_userName = 5674;
const sal_Int32 XML_userO = 5675;
const sal_Int32 XML_userP = 5676;
const sal_Int32 XML_userQ = 5677;
const sal_Int32 XML_userR = 5678;
const sal_Int32 XML_userS = 5679;
const sal_Int32 XML_userSet = 5680;
const sal_Int32 XML_userShapes = 5681;
const sal_Int32 XML_userT = 5682;
const sal_Int32 XML_userU = 5683;
const sal_Int32 XML_userV = 5684;
const sal_Int32 XML_userW = 5685;
const sal_Int32 XML_userX = 5686;
const sal_Int32 XML_userY = 5687;
const sal_Int32 XML_userZ = 5688;
const sal_Int32 XML_userdrawn = 5689;
const sal_Int32 XML_userhidden = 5690;
const sal_Int32 XML_users = 5691;
const sal_Int32 XML_uturnArrow = 5692;
const sal_Int32 XML_v = 5693;
const sal_Int32 XML_v2 = 5694;
const sal_Int32 XML_v3 = 5695;
const sal_Int32 XML_v3v4 = 5696;
const sal_Int32 XML_v4 = 5697;
const sal_Int32 XML_vAlign = 5698;
const sal_Int32 XML_vAnchor = 5699;
const sal_Int32 XML_vMerge = 5700;
const sal_Int32 XML_vMergeOrig = 5701;
const sal_Int32 XML_vSpace = 5702;
const sal_Int32 XML_vacatedStyle = 5703;
const sal_Int32 XML_val = 5704;
const sal_Int32 XML_valAx = 5705;
const sal_Int32 XML_valScaling = 5706;
const sal_Int32 XML_value = 5707;
const sal_Int32 XML_valueAxis = 5708;
const sal_Int32 XML_valueBetween = 5709;
const sal_Int32 XML_valueColors = 5710;
const sal_Int32 XML_valueColorPositions = 5711;
const sal_Int32 XML_valueEqual = 5712;
const sal_Int32 XML_valueGreaterThan = 5713;
const sal_Int32 XML_valueGreaterThanOrEqual = 5714;
const sal_Int32 XML_valueLessThan = 5715;
const sal_Int32 XML_valueLessThanOrEqual = 5716;
const sal_Int32 XML_valueMetadata = 5717;
const sal_Int32 XML_valueNotBetween = 5718;
const sal_Int32 XML_valueNotEqual = 5719;
const sal_Int32 XML_valueType = 5720;
const sal_Int32 XML_values = 5721;
const sal_Int32 XML_vanish = 5722;
const sal_Int32 XML_var = 5723;
const sal_Int32 XML_varLst = 5724;
const sal_Int32 XML_varP = 5725;
const sal_Int32 XML_varPSubtotal = 5726;
const sal_Int32 XML_varScale = 5727;
const sal_Int32 XML_varSubtotal = 5728;
const sal_Int32 XML_variable = 5729;
const sal_Int32 XML_variant = 5730;
const sal_Int32 XML_variation = 5731;
const sal_Int32 XML_varp = 5732;
const sal_Int32 XML_varyColors = 5733;
const sal_Int32 XML_vbProcedure = 5734;
const sal_Int32 XML_vc = 5735;
const sal_Int32 XML_vector = 5736;
const sal_Int32 XML_vendorID = 5737;
const sal_Int32 XML_venn = 5738;
const sal_Int32 XML_verb = 5739;
const sal_Int32 XML_version = 5740;
const sal_Int32 XML_vert = 5741;
const sal_Int32 XML_vert270 = 5742;
const sal_Int32 XML_vertAlign = 5743;
const sal_Int32 XML_vertAnchor = 5744;
const sal_Int32 XML_vertBarState = 5745;
const sal_Int32 XML_vertCompress = 5746;
const sal_Int32 XML_vertJc = 5747;
const sal_Int32 XML_vertOverflow = 5748;
const sal_Int32 XML_vertStripe = 5749;
const sal_Int32 XML_vertTitleAndTx = 5750;
const sal_Int32 XML_vertTitleAndTxOverChart = 5751;
const sal_Int32 XML_vertTx = 5752;
const sal_Int32 XML_vertical = 5753;
const sal_Int32 XML_verticalCentered = 5754;
const sal_Int32 XML_verticalDpi = 5755;
const sal_Int32 XML_verticalScroll = 5756;
const sal_Int32 XML_verticies = 5757;
const sal_Int32 XML_veryHidden = 5758;
const sal_Int32 XML_video = 5759;
const sal_Int32 XML_videoFile = 5760;
const sal_Int32 XML_vietnameseCounting = 5761;
const sal_Int32 XML_view = 5762;
const sal_Int32 XML_view3D = 5763;
const sal_Int32 XML_viewMergedData = 5764;
const sal_Int32 XML_viewPr = 5765;
const sal_Int32 XML_viewpoint = 5766;
const sal_Int32 XML_viewpointorigin = 5767;
const sal_Int32 XML_vine = 5768;
const sal_Int32 XML_violet = 5769;
const sal_Int32 XML_visibility = 5770;
const sal_Int32 XML_visible = 5771;
const sal_Int32 XML_visualTotals = 5772;
const sal_Int32 XML_vm = 5773;
const sal_Int32 XML_vml = 5774;
const sal_Int32 XML_vocabulary = 5775;
const sal_Int32 XML_vol = 5776;
const sal_Int32 XML_volType = 5777;
const sal_Int32 XML_volTypes = 5778;
const sal_Int32 XML_vortex = 5779;
const sal_Int32 XML_vstream = 5780;
const sal_Int32 XML_vt = 5781;
const sal_Int32 XML_w = 5782;
const sal_Int32 XML_w10 = 5783;
const sal_Int32 XML_w14 = 5784;
const sal_Int32 XML_w15 = 5785;
const sal_Int32 XML_wAfter = 5786;
const sal_Int32 XML_wArH = 5787;
const sal_Int32 XML_wBefore = 5788;
const sal_Int32 XML_wMode = 5789;
const sal_Int32 XML_wOff = 5790;
const sal_Int32 XML_wR = 5791;
const sal_Int32 XML_wall = 5792;
const sal_Int32 XML_warmMatte = 5793;
const sal_Int32 XML_warning = 5794;
const sal_Int32 XML_warp = 5795;
const sal_Int32 XML_waterfall = 5796;
const sal_Int32 XML_watermarks = 5797;
const sal_Int32 XML_wavAudioFile = 5798;
const sal_Int32 XML_wave = 5799;
const sal_Int32 XML_waveline = 5800;
const sal_Int32 XML_wavy = 5801;
const sal_Int32 XML_wavyDbl = 5802;
const sal_Int32 XML_wavyDouble = 5803;
const sal_Int32 XML_wavyHeavy = 5804;
const sal_Int32 XML_wd = 5805;
const sal_Int32 XML_wd10 = 5806;
const sal_Int32 XML_wd12 = 5807;
const sal_Int32 XML_wd2 = 5808;
const sal_Int32 XML_wd3 = 5809;
const sal_Int32 XML_wd32 = 5810;
const sal_Int32 XML_wd4 = 5811;
const sal_Int32 XML_wd5 = 5812;
const sal_Int32 XML_wd6 = 5813;
const sal_Int32 XML_wd8 = 5814;
const sal_Int32 XML_wdDnDiag = 5815;
const sal_Int32 XML_wdUpDiag = 5816;
const sal_Int32 XML_weave = 5817;
const sal_Int32 XML_weavingAngles = 5818;
const sal_Int32 XML_weavingBraid = 5819;
const sal_Int32 XML_weavingRibbon = 5820;
const sal_Int32 XML_weavingStrips = 5821;
const sal_Int32 XML_web = 5822;
const sal_Int32 XML_webHidden = 5823;
const sal_Int32 XML_webPr = 5824;
const sal_Int32 XML_webPublishItem = 5825;
const sal_Int32 XML_webPublishItems = 5826;
const sal_Int32 XML_webPublishObject = 5827;
const sal_Int32 XML_webPublishObjects = 5828;
const sal_Int32 XML_webPublishing = 5829;
const sal_Int32 XML_webSettings = 5830;
const sal_Int32 XML_wedge = 5831;
const sal_Int32 XML_wedgeEllipseCallout = 5832;
const sal_Int32 XML_wedgeRectCallout = 5833;
const sal_Int32 XML_wedgeRoundRectCallout = 5834;
const sal_Int32 XML_weight = 5835;
const sal_Int32 XML_wgp = 5836;
const sal_Int32 XML_wheat = 5837;
const sal_Int32 XML_wheel = 5838;
const sal_Int32 XML_wheelReverse = 5839;
const sal_Int32 XML_whenNotActive = 5840;
const sal_Int32 XML_white = 5841;
const sal_Int32 XML_whiteFlowers = 5842;
const sal_Int32 XML_whiteSmoke = 5843;
const sal_Int32 XML_whiteTextOnBlack = 5844;
const sal_Int32 XML_whole = 5845;
const sal_Int32 XML_wholeTable = 5846;
const sal_Int32 XML_wholeTbl = 5847;
const sal_Int32 XML_wide = 5848;
const sal_Int32 XML_widowControl = 5849;
const sal_Int32 XML_width = 5850;
const sal_Int32 XML_win = 5851;
const sal_Int32 XML_window = 5852;
const sal_Int32 XML_windowFrame = 5853;
const sal_Int32 XML_windowHeight = 5854;
const sal_Int32 XML_windowProtection = 5855;
const sal_Int32 XML_windowText = 5856;
const sal_Int32 XML_windowWidth = 5857;
const sal_Int32 XML_wipe = 5858;
const sal_Int32 XML_wireFrame = 5859;
const sal_Int32 XML_wireframe = 5860;
const sal_Int32 XML_withEffect = 5861;
const sal_Int32 XML_withGroup = 5862;
const sal_Int32 XML_woodwork = 5863;
const sal_Int32 XML_wordArtVert = 5864;
const sal_Int32 XML_wordArtVertRtl = 5865;
const sal_Int32 XML_wordWrap = 5866;
const sal_Int32 XML_words = 5867;
const sal_Int32 XML_workbook = 5868;
const sal_Int32 XML_workbookParameter = 5869;
const sal_Int32 XML_workbookPassword = 5870;
const sal_Int32 XML_workbookPr = 5871;
const sal_Int32 XML_workbookProtection = 5872;
const sal_Int32 XML_workbookView = 5873;
const sal_Int32 XML_workbookViewId = 5874;
const sal_Int32 XML_worksheet = 5875;
const sal_Int32 XML_worksheetSource = 5876;
const sal_Int32 XML_wp = 5877;
const sal_Int32 XML_wp14 = 5878;
const sal_Int32 XML_wpJustification = 5879;
const sal_Int32 XML_wpSpaceWidth = 5880;
const sal_Int32 XML_wpc = 5881;
const sal_Int32 XML_wpg = 5882;
const sal_Int32 XML_wps = 5883;
const sal_Int32 XML_wrap = 5884;
const sal_Int32 XML_wrapIndent = 5885;
const sal_Int32 XML_wrapNone = 5886;
const sal_Int32 XML_wrapPolygon = 5887;
const sal_Int32 XML_wrapRight = 5888;
const sal_Int32 XML_wrapSquare = 5889;
const sal_Int32 XML_wrapText = 5890;
const sal_Int32 XML_wrapThrough = 5891;
const sal_Int32 XML_wrapTight = 5892;
const sal_Int32 XML_wrapTopAndBottom = 5893;
const sal_Int32 XML_wrapTrailSpaces = 5894;
const sal_Int32 XML_wrapcoords = 5895;
const sal_Int32 XML_writeProtection = 5896;
const sal_Int32 XML_wsDr = 5897;
const sal_Int32 XML_wsp = 5898;
const sal_Int32 XML_x = 5899;
const sal_Int32 XML_x12ac = 5900;
const sal_Int32 XML_x14 = 5901;
const sal_Int32 XML_x15 = 5902;
const sal_Int32 XML_x2 = 5903;
const sal_Int32 XML_xAlign = 5904;
const sal_Int32 XML_xIllusions = 5905;
const sal_Int32 XML_xMode = 5906;
const sal_Int32 XML_xSplit = 5907;
const sal_Int32 XML_xVal = 5908;
const sal_Int32 XML_xWindow = 5909;
const sal_Int32 XML_xdr = 5910;
const sal_Int32 XML_xf = 5911;
const sal_Int32 XML_xfDxf = 5912;
const sal_Int32 XML_xfId = 5913;
const sal_Int32 XML_xfrm = 5914;
const sal_Int32 XML_xfrmType = 5915;
const sal_Int32 XML_xl2000 = 5916;
const sal_Int32 XML_xl97 = 5917;
const sal_Int32 XML_xlm = 5918;
const sal_Int32 XML_xm = 5919;
const sal_Int32 XML_xml = 5920;
const sal_Int32 XML_xmlBased = 5921;
const sal_Int32 XML_xmlCellPr = 5922;
const sal_Int32 XML_xmlColumnPr = 5923;
const sal_Int32 XML_xmlDataType = 5924;
const sal_Int32 XML_xmlPr = 5925;
const sal_Int32 XML_xmlns = 5926;
const sal_Int32 XML_xpath = 5927;
const sal_Int32 XML_xr = 5928;
const sal_Int32 XML_xr10 = 5929;
const sal_Int32 XML_xr16 = 5930;
const sal_Int32 XML_xr2 = 5931;
const sal_Int32 XML_xr6 = 5932;
const sal_Int32 XML_xrange = 5933;
const sal_Int32 XML_xsc = 5934;
const sal_Int32 XML_xscale = 5935;
const sal_Int32 XML_xsi = 5936;
const sal_Int32 XML_xy = 5937;
const sal_Int32 XML_y = 5938;
const sal_Int32 XML_yAlign = 5939;
const sal_Int32 XML_yMode = 5940;
const sal_Int32 XML_ySplit = 5941;
const sal_Int32 XML_yVal = 5942;
const sal_Int32 XML_yWindow = 5943;
const sal_Int32 XML_year = 5944;
const sal_Int32 XML_yearLong = 5945;
const sal_Int32 XML_yearShort = 5946;
const sal_Int32 XML_yearToDate = 5947;
const sal_Int32 XML_years = 5948;
const sal_Int32 XML_yellow = 5949;
const sal_Int32 XML_yellowGreen = 5950;
const sal_Int32 XML_yesterday = 5951;
const sal_Int32 XML_yrange = 5952;
const sal_Int32 XML_z = 5953;
const sal_Int32 XML_zOrder = 5954;
const sal_Int32 XML_zOrderOff = 5955;
const sal_Int32 XML_zanyTriangles = 5956;
const sal_Int32 XML_zero = 5957;
const sal_Int32 XML_zeroAsc = 5958;
const sal_Int32 XML_zeroDesc = 5959;
const sal_Int32 XML_zeroHeight = 5960;
const sal_Int32 XML_zeroValues = 5961;
const sal_Int32 XML_zeroWid = 5962;
const sal_Int32 XML_zigZag = 5963;
const sal_Int32 XML_zigZagStitch = 5964;
const sal_Int32 XML_zoom = 5965;
const sal_Int32 XML_zoomContents = 5966;
const sal_Int32 XML_zoomScale = 5967;
const sal_Int32 XML_zoomScaleNormal = 5968;
const sal_Int32 XML_zoomScalePageLayoutView = 5969;
const sal_Int32 XML_zoomScaleSheetLayoutView = 5970;
const sal_Int32 XML_zoomToFit = 5971;
const sal_Int32 XML_TOKEN_COUNT = 5972;

const sal_Int32 XML_TOKEN_INVALID = ::com::sun::star::xml::sax::FastToken::DONTKNOW;



} // namespace oox

#endif
