
#include "ooxml/resourceids.hxx"
#include "OOXMLFactory_dml-textCharacter.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "oox/token/tokens.hxx"

#ifdef _MSC_VER
#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels
#pragma warning(disable:4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable:4702) // unreachable code
#endif

namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

OOXMLFactory_dml_textCharacter::OOXMLFactory_dml_textCharacter()
{
}

OOXMLFactory_dml_textCharacter::~OOXMLFactory_dml_textCharacter()
{
}

OOXMLFactory_ns::Pointer_t OOXMLFactory_dml_textCharacter::m_pInstance;

OOXMLFactory_ns::Pointer_t OOXMLFactory_dml_textCharacter::getInstance()
{
    if (!m_pInstance)
        m_pInstance = new OOXMLFactory_dml_textCharacter();

    return m_pInstance;
}

const AttributeInfo* OOXMLFactory_dml_textCharacter::getAttributeInfoArray(Id nId)
{
    switch (nId)
    {
    case NN_dml_textCharacter|DEFINE_CT_TextFont:
        {
            const static AttributeInfo info[] = {
                { oox::XML_typeface, ResourceType::String, NN_dml_textCharacter|DEFINE_ST_TextTypeface },
                { oox::XML_panose, ResourceType::Hex, NN_dml_textCharacter|DEFINE_ST_Panose },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_textCharacter|DEFINE_CT_TextCharacterProperties:
        {
            const static AttributeInfo info[] = {
                { oox::XML_kumimoji, ResourceType::Boolean, 0 },
                { oox::XML_lang, ResourceType::String, NN_dml_textCharacter|DEFINE_ST_TextLanguageID },
                { oox::XML_altLang, ResourceType::String, NN_dml_textCharacter|DEFINE_ST_TextLanguageID },
                { oox::XML_sz, ResourceType::Integer, NN_dml_textCharacter|DEFINE_ST_TextFontSize },
                { oox::XML_b, ResourceType::Boolean, 0 },
                { oox::XML_i, ResourceType::Boolean, 0 },
                { oox::XML_u, ResourceType::List, NN_dml_textCharacter|DEFINE_ST_TextUnderlineType },
                { oox::XML_strike, ResourceType::List, NN_dml_textCharacter|DEFINE_ST_TextStrikeType },
                { oox::XML_kern, ResourceType::Integer, NN_dml_textCharacter|DEFINE_ST_TextNonNegativePoint },
                { oox::XML_cap, ResourceType::List, NN_dml_textCharacter|DEFINE_ST_TextCapsType },
                { oox::XML_spc, ResourceType::Integer, NN_dml_textCharacter|DEFINE_ST_TextPoint },
                { oox::XML_normalizeH, ResourceType::Boolean, 0 },
                { oox::XML_noProof, ResourceType::Boolean, 0 },
                { oox::XML_dirty, ResourceType::Boolean, 0 },
                { oox::XML_err, ResourceType::Boolean, 0 },
                { oox::XML_smtClean, ResourceType::Boolean, 0 },
                { oox::XML_smtId, ResourceType::Integer, 0 },
                { oox::XML_bmk, ResourceType::String, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    default:
        break;
    }

    return NULL;
}

bool OOXMLFactory_dml_textCharacter::getListValue(Id nId, std::string_view aValue, sal_uInt32& rOutValue)
{
    (void) aValue;
    (void) rOutValue;

    switch (nId)
    {
    case NN_dml_textCharacter|DEFINE_ST_TextUnderlineType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "dbl") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dbl; }
            else if (aValue == "dotted") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotted; }
            else if (aValue == "dottedHeavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dottedHeavy; }
            else if (aValue == "dash") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dash; }
            else if (aValue == "dashHeavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dashHeavy; }
            else if (aValue == "dashLong") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dashLong; }
            else if (aValue == "dashLongHeavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dashLongHeavy; }
            else if (aValue == "dotDash") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDash; }
            else if (aValue == "dotDashHeavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDashHeavy; }
            else if (aValue == "dotDotDash") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDotDash; }
            else if (aValue == "dotDotDashHeavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDotDashHeavy; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "heavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_heavy; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "none") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_none; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "sng") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_sng; }
            else { return false; }
            return true;
        case 'w':
            if (aValue == "words") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_words; }
            else if (aValue == "wavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_wavy; }
            else if (aValue == "wavyHeavy") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_wavyHeavy; }
            else if (aValue == "wavyDbl") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_wavyDbl; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_textCharacter|DEFINE_ST_TextStrikeType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "dblStrike") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextStrikeType_dblStrike; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "noStrike") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextStrikeType_noStrike; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "sngStrike") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextStrikeType_sngStrike; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_textCharacter|DEFINE_ST_TextCapsType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "all") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextCapsType_all; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "none") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextCapsType_none; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "small") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextCapsType_small; }
            else { return false; }
            return true;
        }
        return false;
    default:
        break;
    }

    return false;
}

bool OOXMLFactory_dml_textCharacter::getElementId(Id nDefine, Id nId, ResourceType& rOutResource, Id& rOutElement)
{
    (void) rOutResource;
    (void) rOutElement;

    switch (nDefine)
    {
    case NN_dml_textCharacter|DEFINE_CT_TextUnderlineFillGroupWrapper:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_blipFill: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_BlipFillProperties; break;
        case oox::NMSP_dml|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_dml|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_SolidColorFillProperties; break;
        case oox::NMSP_w14|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_w14|oox::XML_noFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SolidColorFillProperties; break;
        default: return false;
        }
        return true;
    case NN_dml_textCharacter|DEFINE_EG_TextUnderlineLine:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_uLn: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeLineProperties|DEFINE_CT_LineProperties; break;
        default: return false;
        }
        return true;
    case NN_dml_textCharacter|DEFINE_CT_TextCharacterProperties:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_blipFill: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_BlipFillProperties; break;
        case oox::NMSP_dml|oox::XML_cs: rOutResource = ResourceType::Properties; rOutElement = NN_dml_textCharacter|DEFINE_CT_TextFont; break;
        case oox::NMSP_dml|oox::XML_ea: rOutResource = ResourceType::Properties; rOutElement = NN_dml_textCharacter|DEFINE_CT_TextFont; break;
        case oox::NMSP_dml|oox::XML_effectDag: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_EffectContainer; break;
        case oox::NMSP_dml|oox::XML_extLst: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_OfficeArtExtensionList; break;
        case oox::NMSP_dml|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_dml|oox::XML_highlight: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_Color; break;
        case oox::NMSP_dml|oox::XML_hlinkClick: rOutResource = ResourceType::Properties; rOutElement = NN_dml_stylesheet|DEFINE_CT_Hyperlink; break;
        case oox::NMSP_dml|oox::XML_hlinkMouseOver: rOutResource = ResourceType::Properties; rOutElement = NN_dml_stylesheet|DEFINE_CT_Hyperlink; break;
        case oox::NMSP_dml|oox::XML_latin: rOutResource = ResourceType::Properties; rOutElement = NN_dml_textCharacter|DEFINE_CT_TextFont; break;
        case oox::NMSP_dml|oox::XML_ln: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeLineProperties|DEFINE_CT_LineProperties; break;
        case oox::NMSP_dml|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeEffects|DEFINE_CT_SolidColorFillProperties; break;
        case oox::NMSP_dml|oox::XML_sym: rOutResource = ResourceType::Properties; rOutElement = NN_dml_textCharacter|DEFINE_CT_TextFont; break;
        case oox::NMSP_dml|oox::XML_uLn: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeLineProperties|DEFINE_CT_LineProperties; break;
        case oox::NMSP_w14|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_w14|oox::XML_noFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SolidColorFillProperties; break;
        default: return false;
        }
        return true;
    default:
        switch (nId)
        {
        default: return false;
        }
        return true;
    }
}

void OOXMLFactory_dml_textCharacter::charactersAction(OOXMLFastContextHandler*, const OUString&)
{
}

Id OOXMLFactory_dml_textCharacter::getResourceId(Id nDefine, sal_Int32 nToken)
{
    (void) nDefine;
    (void) nToken;

    switch (nDefine)
    {
    case NN_dml_textCharacter|DEFINE_CT_TextFont:
        switch (nToken)
        {
        case oox::XML_charset: return NS_ooxml::LN_CT_TextFont_charset;
        case oox::XML_panose: return NS_ooxml::LN_CT_TextFont_panose;
        case oox::XML_pitchFamily: return NS_ooxml::LN_CT_TextFont_pitchFamily;
        case oox::XML_typeface: return NS_ooxml::LN_CT_TextFont_typeface;
        }
        break;
    case NN_dml_textCharacter|DEFINE_CT_TextUnderlineFillGroupWrapper:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_gradFill: return NS_ooxml::LN_EG_FillProperties_gradFill;
        case oox::NMSP_w14|oox::XML_noFill: return NS_ooxml::LN_EG_FillProperties_noFill;
        case oox::NMSP_w14|oox::XML_solidFill: return NS_ooxml::LN_EG_FillProperties_solidFill;
        }
        break;
    case NN_dml_textCharacter|DEFINE_CT_TextCharacterProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_gradFill: return NS_ooxml::LN_EG_FillProperties_gradFill;
        case oox::NMSP_w14|oox::XML_noFill: return NS_ooxml::LN_EG_FillProperties_noFill;
        case oox::NMSP_w14|oox::XML_solidFill: return NS_ooxml::LN_EG_FillProperties_solidFill;
        }
        break;
    default:
        switch (nToken)
        {
        }
        break;
    }
    return 0;
}

void OOXMLFactory_dml_textCharacter::attributeAction(OOXMLFastContextHandler*, Token_t, const OOXMLValue&)
{
}

/// @endcond
}}
